/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IGraphicI;
import igeo.core.IGraphicObject;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.gui.IGraphicMode;
import igeo.gui.IRootPanel;
import igeo.gui.IView;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGraphicServer {
    public ArrayList<IGraphicI> graphicsGL;
    public HashMap<IView, ArrayList<IGraphicI>> graphicsJava;
    public ArrayList<IView> views;
    public IServer server;
    public IRootPanel panel;
    public IGraphicMode[] modes = null;
    public boolean useGL;

    public IGraphicServer(IServer iServer, IRootPanel iRootPanel) {
        this.server = iServer;
        this.panel = iRootPanel;
        this.views = new ArrayList();
        for (int i = 0; i < this.panel.paneNum(); ++i) {
            this.views.add(this.panel.getPane(i).getView());
        }
    }

    public void addView(IView iView) {
        this.views.add(iView);
    }

    public void setMode(IGraphicMode iGraphicMode) {
        if (this.views != null) {
            for (IView iView : this.views) {
                iView.setMode(new IGraphicMode(iGraphicMode));
            }
        }
    }

    public void enableGL() {
        this.useGL = true;
    }

    public void disableGL() {
        this.useGL = false;
    }

    public boolean isGL() {
        return this.useGL;
    }

    public void add(IObject iObject) {
        boolean bl = false;
        for (IView iView : this.views) {
            if (!iView.mode().isGL()) continue;
            bl = true;
        }
        if (bl) {
            IGraphicObject iGraphicObject = iObject.getGraphic(this.views.get(0).mode());
            if (iGraphicObject != null) {
                this.add(iGraphicObject, this.views.get(0));
            } else {
                IOut.err("graphic of the object is null : " + iObject);
            }
        } else {
            for (IView iView : this.views) {
                IGraphicObject iGraphicObject = iObject.getGraphic(iView.mode());
                if (iGraphicObject != null) {
                    this.add(iGraphicObject, iView);
                    continue;
                }
                IOut.err("graphic of the object is null : " + iObject);
            }
        }
    }

    public void add(IGraphicI iGraphicI, IView iView) {
        if (iView.mode().isGL()) {
            if (this.graphicsGL == null) {
                this.graphicsGL = new ArrayList();
            }
            this.graphicsGL.add(iGraphicI);
        } else if (iView.mode().isJava()) {
            ArrayList<IGraphicI> arrayList;
            if (this.graphicsJava == null) {
                this.graphicsJava = new HashMap();
            }
            if ((arrayList = this.graphicsJava.get(iView)) == null) {
                arrayList = new ArrayList();
                this.graphicsJava.put(iView, arrayList);
            }
            arrayList.add(iGraphicI);
        }
    }

    public ArrayList<IGraphicI> getObjects(IView iView) {
        if (iView.mode().isGL()) {
            return this.graphicsGL;
        }
        if (iView.mode().isJava()) {
            return this.graphicsJava.get(iView);
        }
        return null;
    }

    public void remove(IGraphicI iGraphicI) {
        if (this.modes == null) {
            this.modes = IGraphicMode.getAllModes();
        }
        for (IGraphicMode iGraphicMode : this.modes) {
            if (!iGraphicI.isDrawable(iGraphicMode)) continue;
            if (iGraphicMode.isGL()) {
                this.graphicsGL.remove(iGraphicI);
                continue;
            }
            if (!iGraphicMode.isJava()) continue;
            for (IView iView : this.views) {
                if (this.graphicsJava.get(iView) == null) continue;
                this.graphicsJava.get(iView).remove(iGraphicI);
            }
        }
    }

    public void clearObjects() {
        if (this.graphicsGL != null) {
            this.graphicsGL.clear();
            this.graphicsGL = null;
        }
        if (this.graphicsJava != null) {
            for (IView iView : this.views) {
                if (this.graphicsJava.get(iView) == null) continue;
                this.graphicsJava.get(iView).clear();
            }
            this.graphicsJava.clear();
            this.graphicsJava = null;
        }
    }

    public void clearViews() {
        this.views.clear();
    }
}

