/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.geo.IFunction;
import igeo.geo.IMatrix;
import igeo.geo.IMatrix4;
import igeo.geo.IPiecewisePolynomialFunction;
import igeo.geo.IPolynomialFunction;

public class IBSplineBasisFunction {
    public int degree;
    public IBSplineBasisSubFunction[] functions;
    public double[] knots;

    public IBSplineBasisFunction(int n, double[] dArray) {
        this.degree = n;
        this.knots = dArray;
        this.init();
    }

    public IBSplineBasisFunction(IBSplineBasisFunction iBSplineBasisFunction) {
        this.degree = iBSplineBasisFunction.degree;
        this.knots = new double[iBSplineBasisFunction.knots.length];
        for (int i = 0; i < iBSplineBasisFunction.knots.length; ++i) {
            this.knots[i] = iBSplineBasisFunction.knots[i];
        }
        this.init(iBSplineBasisFunction);
    }

    public IBSplineBasisFunction dup() {
        return new IBSplineBasisFunction(this);
    }

    public void init(IBSplineBasisFunction iBSplineBasisFunction) {
        this.functions = new IBSplineBasisSubFunction[this.knots.length - this.degree - 1];
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = new IBSplineBasisSubFunction(iBSplineBasisFunction.functions[i], this.knots);
        }
    }

    public void init() {
        this.functions = new IBSplineBasisSubFunction[this.knots.length - this.degree - 1];
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = new IBSplineBasisSubFunction(this.degree, i, this.knots);
        }
    }

    public int index(double d) {
        int n = this.degree;
        int n2 = this.knots.length - 1 - this.degree;
        if (d <= this.knots[n]) {
            return n;
        }
        if (d >= this.knots[n2]) {
            return n2 - 1;
        }
        int n3 = (n + n2) / 2;
        while (n < n2 && (d < this.knots[n3] || d >= this.knots[n3 + 1])) {
            if (d < this.knots[n3]) {
                n2 = n3;
            } else {
                n = n3;
            }
            n3 = (n + n2) / 2;
        }
        return n3;
    }

    public double[] eval(double d) {
        int n = this.index(d);
        double[] dArray = new double[this.degree + 1];
        for (int i = 0; i <= this.degree; ++i) {
            dArray[i] = i + n - this.degree >= 0 && i + n - this.degree < this.functions.length ? this.functions[i + n - this.degree].functions[this.degree - i + 1].eval(d) : 0.0;
        }
        return dArray;
    }

    public double[] eval(int n, double d) {
        double[] dArray = new double[this.degree + 1];
        for (int i = 0; i <= this.degree; ++i) {
            dArray[i] = i + n - this.degree >= 0 && i + n - this.degree < this.functions.length ? this.functions[i + n - this.degree].functions[this.degree - i + 1].eval(d) : 0.0;
        }
        return dArray;
    }

    public void differentiate() {
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i].differentiate();
        }
    }

    public IMatrix[] getMatrices() {
        IMatrix[] iMatrixArray = new IMatrix[this.knots.length - this.degree * 2 - 1];
        for (int i = 0; i < iMatrixArray.length; ++i) {
            iMatrixArray[i] = new IMatrix(this.degree + 1, this.degree + 1);
            iMatrixArray[i].setZero();
            double d = this.knots[i + this.degree];
            double d2 = this.knots[i + this.degree + 1];
            double[] dArray = new double[]{d, d2 - d};
            IPolynomialFunction iPolynomialFunction = new IPolynomialFunction(dArray);
            for (int j = 0; j <= this.degree; ++j) {
                IPolynomialFunction iPolynomialFunction2 = (IPolynomialFunction)this.functions[j + i].functions[this.degree - j + 1];
                iPolynomialFunction2 = iPolynomialFunction2.substitute(iPolynomialFunction);
                for (int k = 0; k <= this.degree; ++k) {
                    iMatrixArray[i].set(k, j, iPolynomialFunction2.coeff[this.degree - k]);
                }
            }
        }
        return iMatrixArray;
    }

    public IMatrix getMatrix(int n) {
        IMatrix iMatrix = new IMatrix(this.degree + 1, this.degree + 1);
        iMatrix.setZero();
        double d = this.knots[n + this.degree];
        double d2 = this.knots[n + this.degree + 1];
        double[] dArray = new double[]{d, d2 - d};
        IPolynomialFunction iPolynomialFunction = new IPolynomialFunction(dArray);
        for (int i = 0; i <= this.degree; ++i) {
            IPolynomialFunction iPolynomialFunction2 = (IPolynomialFunction)this.functions[i + n].functions[this.degree - i + 1];
            iPolynomialFunction2 = iPolynomialFunction2.substitute(iPolynomialFunction);
            for (int j = 0; j <= this.degree; ++j) {
                iMatrix.set(j, i, iPolynomialFunction2.coeff[this.degree - j]);
            }
        }
        return iMatrix;
    }

    public IMatrix getBezierMatrix(int n) {
        IMatrix iMatrix = this.getMatrix(n);
        IMatrix4 iMatrix4 = new IMatrix4(-1.0, 3.0, -3.0, 1.0, 3.0, -6.0, 3.0, 0.0, -3.0, 3.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        iMatrix4.invert();
        if (iMatrix.rowNum() == 3) {
            int n2;
            IMatrix iMatrix2 = new IMatrix(4, 3);
            for (n2 = 0; n2 < 3; ++n2) {
                iMatrix2.set(0, n2, 0.0);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                iMatrix2.set(1, n2, iMatrix.get(0, n2));
            }
            for (n2 = 0; n2 < 3; ++n2) {
                iMatrix2.set(2, n2, iMatrix.get(1, n2));
            }
            for (n2 = 0; n2 < 3; ++n2) {
                iMatrix2.set(3, n2, iMatrix.get(2, n2));
            }
            return iMatrix4.mul(iMatrix2);
        }
        if (iMatrix.rowNum() == 4) {
            return iMatrix4.mul(iMatrix);
        }
        return null;
    }

    public class IBSplineBasisSubFunction
    extends IPiecewisePolynomialFunction {
        public int degree;
        public int index;
        public double[] knots;

        public IBSplineBasisSubFunction(int n, int n2, double[] dArray) {
            this.degree = n;
            this.index = n2;
            this.knots = dArray;
            this.init();
        }

        public IBSplineBasisSubFunction(IBSplineBasisSubFunction iBSplineBasisSubFunction, double[] dArray) {
            super(iBSplineBasisSubFunction);
            this.degree = iBSplineBasisSubFunction.degree;
            this.index = iBSplineBasisSubFunction.index;
            this.knots = dArray;
        }

        public IBSplineBasisSubFunction dup() {
            return new IBSplineBasisSubFunction(this, this.knots);
        }

        public void init() {
            if (this.degree == 0) {
                double[] dArray = new double[2];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.knots[this.index + i];
                }
                super.init(dArray);
                double[] dArray2 = new double[]{1.0};
                IPolynomialFunction iPolynomialFunction = new IPolynomialFunction(dArray2);
                this.setFunction(0, iPolynomialFunction);
                return;
            }
            IBSplineBasisSubFunction iBSplineBasisSubFunction = new IBSplineBasisSubFunction(this.degree - 1, this.index, this.knots);
            IBSplineBasisSubFunction iBSplineBasisSubFunction2 = new IBSplineBasisSubFunction(this.degree - 1, this.index + 1, this.knots);
            double[] dArray = new double[]{-this.knots[this.index] / (this.knots[this.index + this.degree] - this.knots[this.index]), 1.0 / (this.knots[this.index + this.degree] - this.knots[this.index])};
            IPolynomialFunction iPolynomialFunction = new IPolynomialFunction(dArray);
            double[] dArray3 = new double[]{this.knots[this.index + this.degree + 1] / (this.knots[this.index + this.degree + 1] - this.knots[this.index + 1]), -1.0 / (this.knots[this.index + this.degree + 1] - this.knots[this.index + 1])};
            IPolynomialFunction iPolynomialFunction2 = new IPolynomialFunction(dArray3);
            iBSplineBasisSubFunction.mul(iPolynomialFunction);
            iBSplineBasisSubFunction2.mul(iPolynomialFunction2);
            iBSplineBasisSubFunction.add(iBSplineBasisSubFunction2);
            super.init(iBSplineBasisSubFunction);
        }

        public void add(IBSplineBasisSubFunction iBSplineBasisSubFunction) {
            int n;
            IBSplineBasisSubFunction iBSplineBasisSubFunction2 = this;
            IBSplineBasisSubFunction iBSplineBasisSubFunction3 = iBSplineBasisSubFunction;
            if (this.index > iBSplineBasisSubFunction.index) {
                iBSplineBasisSubFunction2 = iBSplineBasisSubFunction;
                iBSplineBasisSubFunction3 = this;
            }
            double[] dArray = new double[this.degree + 2 + iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index];
            IFunction[] iFunctionArray = new IFunction[this.degree + 3 + iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index];
            for (n = 0; n < iBSplineBasisSubFunction2.domains.length; ++n) {
                dArray[n] = iBSplineBasisSubFunction2.domains[n];
            }
            while (n < iBSplineBasisSubFunction3.domains.length + iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index) {
                dArray[n] = iBSplineBasisSubFunction3.domains[n - (iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index)];
                ++n;
            }
            for (n = 0; n < iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index; ++n) {
                iFunctionArray[n] = iBSplineBasisSubFunction2.functions[n];
            }
            while (n < iBSplineBasisSubFunction2.functions.length) {
                if (iBSplineBasisSubFunction2.functions[n] != null && iBSplineBasisSubFunction3.functions[n - iBSplineBasisSubFunction3.index + iBSplineBasisSubFunction2.index] != null) {
                    iFunctionArray[n] = new IPolynomialFunction((IPolynomialFunction)iBSplineBasisSubFunction2.functions[n]);
                    ((IPolynomialFunction)iFunctionArray[n]).add((IPolynomialFunction)iBSplineBasisSubFunction3.functions[n - iBSplineBasisSubFunction3.index + iBSplineBasisSubFunction2.index]);
                } else {
                    iFunctionArray[n] = iBSplineBasisSubFunction2.functions[n] == null && iBSplineBasisSubFunction3.functions[n - iBSplineBasisSubFunction3.index + iBSplineBasisSubFunction2.index] != null ? iBSplineBasisSubFunction3.functions[n - iBSplineBasisSubFunction3.index + iBSplineBasisSubFunction2.index] : (iBSplineBasisSubFunction2.functions[n] != null && iBSplineBasisSubFunction3.functions[n - iBSplineBasisSubFunction3.index + iBSplineBasisSubFunction2.index] == null ? iBSplineBasisSubFunction2.functions[n] : null);
                }
                ++n;
            }
            while (n < iBSplineBasisSubFunction3.functions.length + iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index) {
                iFunctionArray[n] = iBSplineBasisSubFunction3.functions[n - (iBSplineBasisSubFunction3.index - iBSplineBasisSubFunction2.index)];
                ++n;
            }
            this.domains = dArray;
            this.functions = iFunctionArray;
        }

        public String toString() {
            return "IBSplineBasisSubFunction: index=" + String.valueOf(this.index) + " degree=" + String.valueOf(this.degree) + "\n" + super.toString();
        }
    }
}

