/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.geo.ICurve;
import igeo.geo.ICurveR;
import igeo.geo.IMesh;
import igeo.geo.IMeshR;
import igeo.geo.IPoint;
import igeo.geo.IPointR;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceR;
import igeo.geo.IVec;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBoundingBox {
    public IVec min = null;
    public IVec max = null;

    public void setObjects(IServer iServer) {
        this.setObjects(iServer.getObjects());
    }

    public void compare(IVec iVec) {
        if (this.min == null || this.max == null) {
            this.init(iVec);
            return;
        }
        if (iVec.x < this.min.x) {
            this.min.x = iVec.x;
        } else if (iVec.x > this.max.x) {
            this.max.x = iVec.x;
        }
        if (iVec.y < this.min.y) {
            this.min.y = iVec.y;
        } else if (iVec.y > this.max.y) {
            this.max.y = iVec.y;
        }
        if (iVec.z < this.min.z) {
            this.min.z = iVec.z;
        } else if (iVec.z > this.max.z) {
            this.max.z = iVec.z;
        }
    }

    public void init(IVec iVec) {
        this.min = new IVec(iVec);
        this.max = new IVec(iVec);
    }

    public synchronized void setObjects(ArrayList<IObject> arrayList) {
        if (arrayList.size() > 1000) {
            IOut.debug(10, "calculating bounding box of " + arrayList.size() + " objects");
        }
        boolean bl = true;
        for (IObject iObject : arrayList) {
            int n;
            int n2;
            IObject iObject2;
            if (!iObject.visible()) continue;
            if (iObject instanceof IPoint) {
                iObject2 = (IPoint)iObject;
                if (bl) {
                    this.init(((IPoint)iObject2).get());
                    bl = false;
                    continue;
                }
                this.compare(((IPoint)iObject2).get());
                continue;
            }
            if (iObject instanceof IPointR) {
                iObject2 = (IPointR)iObject;
                if (bl) {
                    this.init(((IPointR)iObject2).get());
                    bl = false;
                    continue;
                }
                this.compare(((IPointR)iObject2).get());
                continue;
            }
            if (iObject instanceof ICurve) {
                iObject2 = (ICurve)iObject;
                for (n2 = 0; n2 < ((ICurve)iObject2).num(); ++n2) {
                    if (bl) {
                        this.init(((ICurve)iObject2).cp(n2).get());
                        bl = false;
                        continue;
                    }
                    this.compare(((ICurve)iObject2).cp(n2).get());
                }
                continue;
            }
            if (iObject instanceof ICurveR) {
                iObject2 = (ICurveR)iObject;
                for (n2 = 0; n2 < ((ICurveR)iObject2).num(); ++n2) {
                    if (bl) {
                        this.init(((ICurveR)iObject2).cp(n2).get());
                        bl = false;
                        continue;
                    }
                    this.compare(((ICurveR)iObject2).cp(n2).get());
                }
                continue;
            }
            if (iObject instanceof ISurface) {
                iObject2 = (ISurface)iObject;
                for (n2 = 0; n2 < ((ISurface)iObject2).unum(); ++n2) {
                    for (n = 0; n < ((ISurface)iObject2).vnum(); ++n) {
                        if (bl) {
                            this.init(((ISurface)iObject2).cp(n2, n).get());
                            bl = false;
                            continue;
                        }
                        this.compare(((ISurface)iObject2).cp(n2, n).get());
                    }
                }
                continue;
            }
            if (iObject instanceof ISurfaceR) {
                iObject2 = (ISurfaceR)iObject;
                for (n2 = 0; n2 < ((ISurfaceR)iObject2).unum(); ++n2) {
                    for (n = 0; n < ((ISurfaceR)iObject2).vnum(); ++n) {
                        if (bl) {
                            this.init(((ISurfaceR)iObject2).cp(n2, n).get());
                            bl = false;
                            continue;
                        }
                        this.compare(((ISurfaceR)iObject2).cp(n2, n).get());
                    }
                }
                continue;
            }
            if (iObject instanceof IMesh) {
                iObject2 = (IMesh)iObject;
                for (n2 = 0; n2 < ((IMesh)iObject2).vertexNum(); ++n2) {
                    if (bl) {
                        this.init(((IMesh)iObject2).vertex(n2).get());
                        bl = false;
                        continue;
                    }
                    this.compare(((IMesh)iObject2).vertex(n2).get());
                }
                continue;
            }
            if (!(iObject instanceof IMeshR)) continue;
            iObject2 = (IMeshR)iObject;
            for (n2 = 0; n2 < ((IMeshR)iObject2).vertexNum(); ++n2) {
                if (bl) {
                    this.init(((IMeshR)iObject2).vertex(n2).get());
                    bl = false;
                    continue;
                }
                this.compare(((IMeshR)iObject2).vertex(n2).get());
            }
        }
        if (this.min.eq(this.max, 0.002)) {
            IOut.err("bounding box is too small. minimum size is set");
            IVec iVec = new IVec(0.002, 0.002, 0.002);
            iVec.div(2.0);
            this.max.set(this.min).add(iVec);
            this.min.sub(iVec);
        }
        if (arrayList.size() > 1000) {
            IOut.debug(10, "calculation of bounding box completed");
        }
    }

    public String toString() {
        String string = null;
        if (this.min != null) {
            string = this.min.toString();
        }
        String string2 = null;
        if (this.max != null) {
            string2 = this.max.toString();
        }
        return string + "-" + string2;
    }
}

