/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.geo.ISurfaceI;
import igeo.geo.IVec2;
import igeo.gui.IPolyline;
import igeo.gui.IPolyline2D;
import igeo.gui.ITrimLoopGraphic;

public class IIsoparmGraphic {
    public IPolyline[] polyline = null;

    public IIsoparmGraphic(ISurfaceI iSurfaceI, double d, boolean bl) {
        this.init(iSurfaceI, d, bl);
    }

    public IIsoparmGraphic(ISurfaceI iSurfaceI, double d, boolean bl, ITrimLoopGraphic[] iTrimLoopGraphicArray, ITrimLoopGraphic[] iTrimLoopGraphicArray2) {
        this.init(iSurfaceI, d, bl, iTrimLoopGraphicArray, iTrimLoopGraphicArray2);
    }

    public void init(ISurfaceI iSurfaceI, double d, boolean bl) {
        int n = 32;
        this.polyline = new IPolyline[1];
        if (bl) {
            int n2 = iSurfaceI.uepNum();
            if (iSurfaceI.udeg() == 1) {
                this.polyline[0] = new IPolyline(n2);
                for (int i = 0; i < n2; ++i) {
                    this.polyline[0].set(i, iSurfaceI.pt(iSurfaceI.u(i, 0.0), d));
                }
            } else {
                this.polyline[0] = new IPolyline((n2 - 1) * n + 1);
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n && i < n2 - 1 || j == 0; ++j) {
                        this.polyline[0].set(i * n + j, iSurfaceI.pt(iSurfaceI.u(i, (double)j / (double)n), d));
                    }
                }
            }
        } else {
            int n3 = iSurfaceI.vepNum();
            if (iSurfaceI.vdeg() == 1) {
                this.polyline[0] = new IPolyline(n3);
                for (int i = 0; i < n3; ++i) {
                    this.polyline[0].set(i, iSurfaceI.pt(d, iSurfaceI.v(i, 0.0)));
                }
            } else {
                this.polyline[0] = new IPolyline((n3 - 1) * n + 1);
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n && i < n3 - 1 || j == 0; ++j) {
                        this.polyline[0].set(i * n + j, iSurfaceI.pt(d, iSurfaceI.v(i, (double)j / (double)n)));
                    }
                }
            }
        }
    }

    public void init(ISurfaceI iSurfaceI, double d, boolean bl, ITrimLoopGraphic[] iTrimLoopGraphicArray, ITrimLoopGraphic[] iTrimLoopGraphicArray2) {
        int n;
        if (iTrimLoopGraphicArray == null && iTrimLoopGraphicArray2 == null) {
            this.init(iSurfaceI, d, bl);
            return;
        }
        int n2 = 32;
        IPolyline2D[] iPolyline2DArray = null;
        if (iTrimLoopGraphicArray != null) {
            iPolyline2DArray = new IPolyline2D[iTrimLoopGraphicArray.length];
            for (int i = 0; i < iTrimLoopGraphicArray.length; ++i) {
                iPolyline2DArray[i] = iTrimLoopGraphicArray[i].getPolyline2D();
            }
        }
        IPolyline2D[] iPolyline2DArray2 = null;
        if (iTrimLoopGraphicArray2 != null) {
            iPolyline2DArray2 = new IPolyline2D[iTrimLoopGraphicArray2.length];
            for (int i = 0; i < iTrimLoopGraphicArray2.length; ++i) {
                iPolyline2DArray2[i] = iTrimLoopGraphicArray2[i].getPolyline2D();
            }
        }
        IPolyline2D[] iPolyline2DArray3 = null;
        iPolyline2DArray3 = bl ? IPolyline2D.xLineInside(d, iPolyline2DArray, iPolyline2DArray2) : IPolyline2D.yLineInside(d, iPolyline2DArray, iPolyline2DArray2);
        if (iPolyline2DArray3 == null) {
            return;
        }
        int n3 = 0;
        n3 = bl ? iSurfaceI.uepNum() : iSurfaceI.vepNum();
        int n4 = 0;
        n4 = bl ? iSurfaceI.udeg() : iSurfaceI.vdeg();
        int n5 = 0;
        for (n = 0; n < n3 - 1; ++n) {
            double d2 = 0.0;
            for (int i = 0; i == 0 && n4 == 1 || i < n2 && n4 > 1; ++i) {
                if (n <= 0 && i <= 0) continue;
                d2 = bl ? iSurfaceI.u(n, (double)i / (double)n2) : iSurfaceI.v(n, (double)i / (double)n2);
                while (!(n5 >= iPolyline2DArray3.length || bl && iPolyline2DArray3[n5].get((int)(iPolyline2DArray3[n5].num() - 1)).x > d2 || !bl && iPolyline2DArray3[n5].get((int)(iPolyline2DArray3[n5].num() - 1)).y > d2)) {
                    ++n5;
                }
                if (n5 >= iPolyline2DArray3.length || !(bl && iPolyline2DArray3[n5].get((int)0).x < d2) && (bl || !(iPolyline2DArray3[n5].get((int)0).y < d2))) continue;
                IVec2 iVec2 = null;
                iVec2 = bl ? new IVec2(d2, iPolyline2DArray3[n5].get((int)0).y) : new IVec2(iPolyline2DArray3[n5].get((int)0).x, d2);
                iPolyline2DArray3[n5].insert(iPolyline2DArray3[n5].num() - 1, iVec2);
            }
        }
        this.polyline = new IPolyline[iPolyline2DArray3.length];
        for (n = 0; n < iPolyline2DArray3.length; ++n) {
            this.polyline[n] = new IPolyline(iPolyline2DArray3[n].num());
            for (int i = 0; i < iPolyline2DArray3[n].num(); ++i) {
                this.polyline[n].set(i, iSurfaceI.pt(iPolyline2DArray3[n].get(i)));
            }
        }
    }

    public int num() {
        if (this.polyline == null) {
            return 0;
        }
        return this.polyline.length;
    }

    public IPolyline getLine(int n) {
        return this.polyline[n];
    }
}

