/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.core.IOut;
import igeo.core.IServerI;
import igeo.io.IObjFileExporter;
import igeo.io.IObjFileImporter;
import igeo.io.IRhino3dmExporter;
import igeo.io.IRhino3dmImporter;
import java.io.File;

public class IIO {
    public static final String extensionObj = "obj";
    public static final String extensionRhino = "3dm";

    public static boolean isExtension(String string, String string2) {
        String string3 = IIO.getExtension(string);
        if (string3 == null) {
            return false;
        }
        return string3.toLowerCase().equals(string2.toLowerCase());
    }

    public static String getExtension(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[stringArray.length - 1];
    }

    public static FileType getFileType(String string) {
        if (IIO.isExtension(string, extensionRhino)) {
            return FileType.RHINO;
        }
        if (IIO.isExtension(string, extensionObj)) {
            return FileType.OBJ;
        }
        return FileType.OTHER;
    }

    public static boolean open(String string, IServerI iServerI) {
        IOut.debug(0, "opening " + string);
        FileType fileType = IIO.getFileType(string);
        if (fileType == FileType.OBJ) {
            return IIO.openOBJ(new File(string), iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.openRhino(new File(string), iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(string) + " is not supported");
        return false;
    }

    public static boolean open(File file, IServerI iServerI) {
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            return IIO.openOBJ(file, iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.openRhino(file, iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return false;
    }

    public static boolean openOBJ(File file, IServerI iServerI) {
        IOut.debug(0, "opening obj file " + file);
        if (IObjFileImporter.read(file, iServerI) != null) {
            IOut.debug(0, "opening complete");
            return true;
        }
        IOut.err("error occured in opening file " + file.toString());
        return false;
    }

    public static boolean openRhino(File file, IServerI iServerI) {
        IOut.debug(0, "opening 3dm file " + file);
        if (IRhino3dmImporter.read(file, iServerI)) {
            IOut.debug(0, "opening complete");
            return true;
        }
        IOut.err("error occured in opening file " + file.toString());
        return false;
    }

    public static boolean save(String string, IServerI iServerI) {
        FileType fileType = IIO.getFileType(string);
        if (fileType == FileType.OBJ) {
            boolean bl = IIO.saveOBJ(new File(string), iServerI);
            return bl;
        }
        if (fileType == FileType.RHINO) {
            boolean bl = IIO.saveRhino(new File(string), iServerI);
            return bl;
        }
        IOut.err("file extension ." + IIO.getExtension(string) + " is not supported");
        return false;
    }

    public static boolean save(File file, IServerI iServerI) {
        FileType fileType = IIO.getFileType(file.getName());
        if (fileType == FileType.OBJ) {
            return IIO.saveOBJ(file, iServerI);
        }
        if (fileType == FileType.RHINO) {
            return IIO.saveRhino(file, iServerI);
        }
        IOut.err("file extension ." + IIO.getExtension(file.getName()) + " is not supported");
        return false;
    }

    public static boolean saveOBJ(File file, IServerI iServerI) {
        IOut.debug(0, "saving obj file: " + file);
        if (IObjFileExporter.write(file, iServerI)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    public static boolean saveRhino(File file, IServerI iServerI) {
        IOut.debug(0, "saving 3dm file: " + file);
        if (IRhino3dmExporter.write(file, iServerI)) {
            IOut.debug(0, "saving complete");
            return true;
        }
        IOut.err("error occured in saving file " + file.toString());
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        RHINO,
        OBJ,
        OTHER;

    }
}

