/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import java.io.PrintStream;

public class IOut {
    public static PrintStream ps = System.out;
    public static PrintStream err = System.err;
    public static PrintStream debug = System.out;
    public static boolean printStack = true;
    public static boolean enabled = true;
    public static boolean errEnabled = true;
    public static boolean debugEnabled = true;
    public static int debugLevel = 0;
    public static String errPrefix = "ERROR: ";
    public static String debugPrefix = "DEBUG: ";

    public static void setStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void setErrStream(PrintStream printStream) {
        err = printStream;
    }

    public static void enablePrintStack() {
        printStack = true;
    }

    public static void disablePrintStack() {
        printStack = false;
    }

    public static void enablePrint() {
        enabled = true;
    }

    public static void disablePrint() {
        enabled = false;
    }

    public static void enableErr() {
        errEnabled = true;
    }

    public static void disableErr() {
        errEnabled = false;
    }

    public static void debugLevel(int n) {
        debugLevel = n;
    }

    public static int debugLevel() {
        return debugLevel;
    }

    protected static void printCurrentStack() {
        IOut.printCurrentStack(ps);
    }

    protected static void printCurrentStack(PrintStream printStream) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null && stackTraceElementArray.length > 3) {
            IOut.printStack(printStream, stackTraceElementArray[3]);
        }
    }

    protected static void printStack(PrintStream printStream, StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        printStream.print(string + "." + stackTraceElement.getMethodName() + ": ");
    }

    public static void p(Object object) {
        if (enabled) {
            if (printStack) {
                IOut.printCurrentStack(ps);
            }
            ps.println(object);
        }
    }

    public static void p() {
        if (enabled) {
            if (printStack) {
                IOut.printCurrentStack(ps);
            }
            ps.println();
        }
    }

    public static void err(Object object) {
        if (errEnabled) {
            if (printStack) {
                IOut.printCurrentStack(err);
            }
            err.print(errPrefix);
            err.println(object);
        }
    }

    public static void err() {
        if (errEnabled) {
            if (printStack) {
                IOut.printCurrentStack(err);
            }
            err.print(errPrefix);
            err.println();
        }
    }

    public static void debug(int n, Object object) {
        if (debugEnabled && (debugLevel < 0 || n <= debugLevel)) {
            if (printStack) {
                IOut.printCurrentStack(debug);
            }
            debug.print(debugPrefix);
            debug.println(object);
        }
    }

    public static void debug(int n) {
        if (debugEnabled && (debugLevel < 0 || n <= debugLevel)) {
            if (printStack) {
                IOut.printCurrentStack(debug);
            }
            debug.print(debugPrefix);
            debug.println();
        }
    }

    public static void println(Object object) {
        if (enabled) {
            ps.println(object);
        }
    }

    public static void println(boolean bl) {
        if (enabled) {
            ps.println(bl);
        }
    }

    public static void println(char c) {
        if (enabled) {
            ps.println(c);
        }
    }

    public static void println(char[] cArray) {
        if (enabled) {
            ps.println(cArray);
        }
    }

    public static void println(double d) {
        if (enabled) {
            ps.println(d);
        }
    }

    public static void println(float f) {
        if (enabled) {
            ps.println(f);
        }
    }

    public static void println(int n) {
        if (enabled) {
            ps.println(n);
        }
    }

    public static void println(long l) {
        if (enabled) {
            ps.println(l);
        }
    }

    public static void println(String string) {
        if (enabled) {
            ps.println(string);
        }
    }

    public static void println() {
        if (enabled) {
            ps.println();
        }
    }

    public static void print(Object object) {
        if (enabled) {
            ps.print(object);
        }
    }

    public static void print(boolean bl) {
        if (enabled) {
            ps.print(bl);
        }
    }

    public static void print(char c) {
        if (enabled) {
            ps.print(c);
        }
    }

    public static void print(char[] cArray) {
        if (enabled) {
            ps.print(cArray);
        }
    }

    public static void print(double d) {
        if (enabled) {
            ps.print(d);
        }
    }

    public static void print(float f) {
        if (enabled) {
            ps.print(f);
        }
    }

    public static void print(int n) {
        if (enabled) {
            ps.print(n);
        }
    }

    public static void print(long l) {
        if (enabled) {
            ps.print(l);
        }
    }

    public static void print(String string) {
        if (enabled) {
            ps.print(string);
        }
    }

    public static void flush() {
        if (enabled) {
            ps.flush();
        }
    }

    public static PrintStream get() {
        return ps;
    }
}

