/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IParameterObject;
import igeo.core.IServerI;
import igeo.geo.IBool;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IEntityParameter;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVecI;
import java.util.ArrayList;

public class IVec2
extends IParameterObject
implements IVec2I,
IEntityParameter {
    public double x;
    public double y;

    public IVec2() {
    }

    public IVec2(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public IVec2(IVec2 iVec2) {
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
    }

    public IVec2(IVecI iVecI) {
        this.x = iVecI.x();
        this.y = iVecI.y();
    }

    public IVec2(IServerI iServerI) {
        super(iServerI);
    }

    public IVec2(IServerI iServerI, double d, double d2) {
        super(iServerI);
        this.x = d;
        this.y = d2;
    }

    public IVec2(IServerI iServerI, IVec2 iVec2) {
        super(iServerI);
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IServerI iServerI, IVec2I iVec2I) {
        super(iServerI);
        IVec2 iVec2 = iVec2I.get();
        this.x = iVec2.x;
        this.y = iVec2.y;
    }

    public IVec2(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
    }

    public IVec2(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.x = iVecI.x();
        this.y = iVecI.y();
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public IVec2 get() {
        return new IVec2(this);
    }

    public IVec2 dup() {
        return new IVec2(this);
    }

    public IVec to3d() {
        return new IVec(this);
    }

    public IVec to3d(double d) {
        return new IVec(this.x, this.y, d);
    }

    public IVec to3d(IDoubleI iDoubleI) {
        return new IVec(this.x, this.y, iDoubleI.x());
    }

    public IVec4 to4d() {
        return new IVec4(this.x, this.y, 0.0);
    }

    public IVec4 to4d(double d, double d2) {
        return new IVec4(this.x, this.y, d, d2);
    }

    public IVec4 to4d(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec4(this.x, this.y, iDoubleI.x(), iDoubleI2.x());
    }

    public IDouble getX() {
        return new IDouble(this.x);
    }

    public IDouble getY() {
        return new IDouble(this.y);
    }

    public IVec2 set(double d, double d2) {
        this.x = d;
        this.y = d2;
        return this;
    }

    public IVec2 set(IVec2 iVec2) {
        this.x = iVec2.x;
        this.y = iVec2.y;
        return this;
    }

    public IVec2 set(IVec2I iVec2I) {
        return this.set(iVec2I.get());
    }

    public IVec2 set(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        return this;
    }

    public IVec2 add(double d, double d2) {
        this.x += d;
        this.y += d2;
        return this;
    }

    public IVec2 add(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x += iDoubleI.x();
        this.y += iDoubleI2.x();
        return this;
    }

    public IVec2 add(IVec2 iVec2) {
        this.x += iVec2.x;
        this.y += iVec2.y;
        return this;
    }

    public IVec2 add(IVec2I iVec2I) {
        return this.add(iVec2I.get());
    }

    public IVec2 sub(double d, double d2) {
        this.x -= d;
        this.y -= d2;
        return this;
    }

    public IVec2 sub(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.x -= iDoubleI.x();
        this.y -= iDoubleI2.x();
        return this;
    }

    public IVec2 sub(IVec2 iVec2) {
        this.x -= iVec2.x;
        this.y -= iVec2.y;
        return this;
    }

    public IVec2 sub(IVec2I iVec2I) {
        return this.sub(iVec2I.get());
    }

    public IVec2 mul(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public IVec2 mul(IDouble iDouble) {
        return this.mul(iDouble.x);
    }

    public IVec2 mul(IDoubleI iDoubleI) {
        return this.mul(iDoubleI.x());
    }

    public IVec2 div(double d) {
        this.x /= d;
        this.y /= d;
        return this;
    }

    public IVec2 div(IDouble iDouble) {
        return this.div(iDouble.x);
    }

    public IVec2 div(IDoubleI iDoubleI) {
        return this.div(iDoubleI.x());
    }

    public IVec2 neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public IVec2 rev() {
        return this.neg();
    }

    public IVec2 add(IVec2 iVec2, double d) {
        this.x += iVec2.x * d;
        this.y += iVec2.y * d;
        return this;
    }

    public IVec2 add(IVec2I iVec2I, double d) {
        return this.add(iVec2I.get(), d);
    }

    public IVec2 add(IVec2I iVec2I, IDoubleI iDoubleI) {
        this.add(iVec2I.get(), iDoubleI.x());
        return this;
    }

    public double dot(IVec2 iVec2) {
        return this.x * iVec2.x + this.y * iVec2.y;
    }

    public double dot(IVec2I iVec2I) {
        return this.dot(iVec2I.get());
    }

    public double dot(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dot(iVec2I);
    }

    public IDouble dot(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dot(iVec2I));
    }

    public IVec cross(IVec2 iVec2) {
        return new IVec(0.0, 0.0, this.x * iVec2.y - this.y * iVec2.x);
    }

    public IVec cross(IVec2I iVec2I) {
        return this.cross(iVec2I.get());
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    public double len2() {
        return this.x * this.x + this.y * this.y;
    }

    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    public IDouble len2(ISwitchR iSwitchR) {
        return new IDouble(this.len2());
    }

    public IVec2 len(IDoubleI iDoubleI) {
        return this.len(iDoubleI.x());
    }

    public IVec2 len(double d) {
        this.x *= (d /= this.len());
        this.y *= d;
        return this;
    }

    public IVec2 unit() {
        double d = this.len();
        this.x /= d;
        this.y /= d;
        return this;
    }

    public IVec2 ortho() {
        double d = this.x;
        this.x = -this.y;
        this.y = d;
        return this;
    }

    public double dist(IVec2 iVec2) {
        return Math.sqrt((this.x - iVec2.x) * (this.x - iVec2.x) + (this.y - iVec2.y) * (this.y - iVec2.y));
    }

    public double dist(IVec2I iVec2I) {
        return this.dist(iVec2I.get());
    }

    public double dist(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist(iVec2I);
    }

    public IDouble dist(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dist(iVec2I));
    }

    public double dist2(IVec2 iVec2) {
        return (this.x - iVec2.x) * (this.x - iVec2.x) + (this.y - iVec2.y) * (this.y - iVec2.y);
    }

    public double dist2(IVec2I iVec2I) {
        return this.dist2(iVec2I.get());
    }

    public double dist2(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist2(iVec2I);
    }

    public IDouble dist2(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.dist2(iVec2I));
    }

    public boolean eq(IVec2 iVec2) {
        return this.eq(iVec2, IConfig.lengthResolution);
    }

    public boolean eq(IVec2I iVec2I) {
        return this.eq(iVec2I.get(), IConfig.lengthResolution);
    }

    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eq(iVec2I);
    }

    public IBool eq(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eq(iVec2I));
    }

    public boolean eq(IVec2 iVec2, double d) {
        return this.dist2(iVec2) <= d * d;
    }

    public boolean eq(IVec2I iVec2I, double d) {
        return this.eq(iVec2I.get(), d);
    }

    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eq(iVec2I, d);
    }

    public IBool eq(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eq(iVec2I, iDoubleI.x()));
    }

    public boolean eqX(IVec2 iVec2) {
        return this.eqX(iVec2, IConfig.lengthResolution);
    }

    public boolean eqY(IVec2 iVec2) {
        return this.eqY(iVec2, IConfig.lengthResolution);
    }

    public boolean eqX(IVec2I iVec2I) {
        return this.eqX(iVec2I.get(), IConfig.lengthResolution);
    }

    public boolean eqY(IVec2I iVec2I) {
        return this.eqY(iVec2I.get(), IConfig.lengthResolution);
    }

    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqX(iVec2I);
    }

    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqY(iVec2I);
    }

    public IBool eqX(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eqX(iVec2I));
    }

    public IBool eqY(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBool(this.eqY(iVec2I));
    }

    public boolean eqX(IVec2 iVec2, double d) {
        return Math.abs(iVec2.x - this.x) <= d;
    }

    public boolean eqY(IVec2 iVec2, double d) {
        return Math.abs(iVec2.y - this.y) <= d;
    }

    public boolean eqX(IVec2I iVec2I, double d) {
        return Math.abs(iVec2I.x() - this.x) <= d;
    }

    public boolean eqY(IVec2I iVec2I, double d) {
        return Math.abs(iVec2I.y() - this.y) <= d;
    }

    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqX(iVec2I, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqY(iVec2I, d);
    }

    public IBool eqX(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eqX(iVec2I, iDoubleI.x()));
    }

    public IBool eqY(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBool(this.eqY(iVec2I, iDoubleI.x()));
    }

    public double angle(IVec2 iVec2) {
        double d = this.x * iVec2.x + this.y * iVec2.y;
        double d2 = this.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = iVec2.len();
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = this.x * iVec2.y - this.y * iVec2.x;
        double d5 = d / (d2 * d3);
        if (d5 > 1.0) {
            d5 = 1.0;
        } else if (d5 < -1.0) {
            d5 = -1.0;
        }
        double d6 = Math.acos(d5);
        if (d4 < 0.0) {
            return -d6;
        }
        return d6;
    }

    public double angle(IVec2I iVec2I) {
        return this.angle(iVec2I.get());
    }

    public double angle(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.angle(iVec2I);
    }

    public IDouble angle(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDouble(this.angle(iVec2I));
    }

    public IVec2 rot(double d) {
        double d2 = this.x;
        this.x = this.x * Math.cos(d) - this.y * Math.sin(d);
        this.y = d2 * Math.sin(d) + this.y * Math.cos(d);
        return this;
    }

    public IVec2 rot(IDoubleI iDoubleI) {
        return this.rot(iDoubleI.x());
    }

    public IVec2 rot(IVec2 iVec2, double d) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).rot(d).add(iVec2);
    }

    public IVec2 rot(IVec2I iVec2I, double d) {
        return this.rot(iVec2I.get(), d);
    }

    public IVec2 rot(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.rot(iVec2I.get(), iDoubleI.x());
    }

    public IVec2 rot(IVec2 iVec2) {
        return this.rot(this.angle(iVec2));
    }

    public IVec2 rot(IVec2I iVec2I) {
        return this.rot(iVec2I.get());
    }

    public IVec2 rot(IVec2 iVec2, IVec2 iVec22) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).rot(iVec22.diff(iVec2)).add(iVec2);
    }

    public IVec2 rot(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.rot(iVec2I.get(), iVec2I2.get());
    }

    public IVec2 scale(double d) {
        return this.mul(d);
    }

    public IVec2 scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public IVec2 scale(IVec2 iVec2, double d) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).mul(d).add(iVec2);
    }

    public IVec2 scale(IVec2I iVec2I, double d) {
        return this.scale(iVec2I.get(), d);
    }

    public IVec2 scale(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.scale(iVec2I.get(), iDoubleI.x());
    }

    public IVec2 mirror(IVec2 iVec2) {
        return this.add(iVec2.dup().mul(this.dot(iVec2) / iVec2.len2() * -2.0));
    }

    public IVec2 mirror(IVec2I iVec2I) {
        return this.mirror(iVec2I.get());
    }

    public IVec2 mirror(IVec2 iVec2, IVec2 iVec22) {
        if (iVec2 == this) {
            return this;
        }
        return this.sub(iVec2).mirror(iVec22).add(iVec2);
    }

    public IVec2 mirror(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.mirror(iVec2I.get(), iVec2I2.get());
    }

    public IVec2 transform(IVec2 iVec2, IVec2 iVec22) {
        double d = iVec2.x * this.x + iVec22.x * this.y;
        double d2 = iVec2.y * this.x + iVec22.y * this.y;
        this.x = d;
        this.y = d2;
        return this;
    }

    public IVec2 transform(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.transform(iVec2I.get(), iVec2I2.get());
    }

    public IVec2 transform(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        return this.transform(iVec2, iVec22).add(iVec23);
    }

    public IVec2 transform(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3) {
        return this.transform(iVec2I.get(), iVec2I2.get(), iVec2I3.get());
    }

    public IVec2 diff(IVec2I iVec2I) {
        return this.dup().sub(iVec2I);
    }

    public IVec2 mid(IVec2I iVec2I) {
        return this.dup().add(iVec2I).div(2.0);
    }

    public IVec2 sum(IVec2I iVec2I) {
        return this.dup().add(iVec2I);
    }

    public IVec2 sum(IVec2I ... iVec2IArray) {
        IVec2 iVec2 = this.dup();
        for (IVec2I iVec2I : iVec2IArray) {
            iVec2.add(iVec2I);
        }
        return iVec2;
    }

    public IVec2 bisect(IVec2 iVec2) {
        return this.dup().unit().add(iVec2.dup().unit());
    }

    public IVec2 bisect(IVec2I iVec2I) {
        return this.bisect(iVec2I.get());
    }

    public IVec2 sum(IVec2 iVec2, double d, double d2) {
        return this.dup().mul(d).add(iVec2, d2);
    }

    public IVec2 sum(IVec2I iVec2I, double d, double d2) {
        return this.sum(iVec2I.get(), d, d2);
    }

    public IVec2 sum(IVec2I iVec2I, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVec2I.get(), iDoubleI.x(), iDoubleI2.x());
    }

    public IVec2 sum(IVec2 iVec2, double d) {
        return this.dup().mul(1.0 - d).add(iVec2, d);
    }

    public IVec2 sum(IVec2I iVec2I, double d) {
        return this.sum(iVec2I.get(), d);
    }

    public IVec2 sum(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.sum((IVec2I)iVec2I.get(), iDoubleI.get());
    }

    public boolean isParallel(IVec2I iVec2I) {
        return this.isParallel(iVec2I, IConfig.angleResolution);
    }

    public boolean isParallel(IVec2I iVec2I, double d) {
        return Math.abs(this.dot(iVec2I.get()) / (this.len() * iVec2I.get().len())) > Math.cos(d);
    }

    public boolean isStraight(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.isStraight(iVec2I, iVec2I2, IConfig.angleResolution);
    }

    public boolean isStraight(IVec2I iVec2I, IVec2I iVec2I2, double d) {
        return iVec2I.get().diff(this).isParallel(iVec2I2.get().diff(iVec2I), d);
    }

    public static IVec2 intersect(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3, IVec2I iVec2I4) {
        double d = iVec2I4.x() * iVec2I2.y() - iVec2I2.x() * iVec2I4.y();
        if (d == 0.0) {
            return null;
        }
        IVec2 iVec2 = new IVec2(iVec2I.x() * iVec2I2.y() * iVec2I4.x() - iVec2I3.x() * iVec2I2.x() * iVec2I4.y() - (iVec2I.y() - iVec2I3.y()) * iVec2I2.x() * iVec2I4.x(), iVec2I3.y() * iVec2I2.y() * iVec2I4.x() - iVec2I.y() * iVec2I2.x() * iVec2I4.y() + (iVec2I.x() - iVec2I3.x()) * iVec2I2.y() * iVec2I4.y());
        iVec2.div(d);
        return iVec2;
    }

    public static IVec2 intersectYLine(IVec2 iVec2, IVec2 iVec22, double d) {
        if (iVec22.x == 0.0) {
            return null;
        }
        return new IVec2(d, iVec2.y - (iVec2.x - d) * iVec22.y / iVec22.x);
    }

    public static IVec2 intersectXLine(IVec2 iVec2, IVec2 iVec22, double d) {
        if (iVec22.y == 0.0) {
            return null;
        }
        return new IVec2(iVec2.x - (iVec2.y - d) * iVec22.x / iVec22.y, d);
    }

    public static IVec2 intersectSegment(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3, IVec2I iVec2I4) {
        if (Math.max(iVec2I.x(), iVec2I2.x()) < Math.min(iVec2I3.x(), iVec2I4.x()) || Math.max(iVec2I3.x(), iVec2I4.x()) < Math.min(iVec2I.x(), iVec2I2.x()) || Math.max(iVec2I.y(), iVec2I2.y()) < Math.min(iVec2I3.y(), iVec2I4.y()) || Math.max(iVec2I3.y(), iVec2I4.y()) < Math.min(iVec2I.y(), iVec2I2.y())) {
            return null;
        }
        IVec2 iVec2 = IVec2.intersect(iVec2I, iVec2I2.get().diff(iVec2I), iVec2I3, iVec2I4.get().diff(iVec2I3));
        if (iVec2 == null) {
            return null;
        }
        if (!iVec2.isBetween(iVec2I, iVec2I2) || !iVec2.isBetween(iVec2I3, iVec2I4)) {
            return null;
        }
        return iVec2;
    }

    public static IVec2 intersectPolyline(IVec2I iVec2I, IVec2I iVec2I2, IVec2I[] iVec2IArray, boolean bl) {
        for (int i = 0; i < iVec2IArray.length - 1 || bl && i < iVec2IArray.length; ++i) {
            IVec2 iVec2 = IVec2.intersectSegment(iVec2I, iVec2I2, iVec2IArray[i], iVec2IArray[(i + 1) % iVec2IArray.length]);
            if (iVec2 == null) continue;
            return iVec2;
        }
        return null;
    }

    public static IVec2 intersectPolyline(IVec2I iVec2I, IVec2I iVec2I2, IVec2I[] iVec2IArray) {
        return IVec2.intersectPolyline(iVec2I, iVec2I2, iVec2IArray, false);
    }

    public static IVec2 intersectPolygon(IVec2I iVec2I, IVec2I iVec2I2, IVec2I[] iVec2IArray) {
        return IVec2.intersectPolyline(iVec2I, iVec2I2, iVec2IArray, true);
    }

    public static IVec2 intersectSegmentAndXLine(IVec2I iVec2I, IVec2I iVec2I2, double d) {
        if (Math.max(iVec2I.y(), iVec2I2.y()) < d || Math.min(iVec2I.y(), iVec2I2.y()) > d) {
            return null;
        }
        IVec2 iVec2 = iVec2I2.get().diff(iVec2I);
        if (iVec2.y == 0.0) {
            return iVec2I.get().dup();
        }
        iVec2.mul((d - iVec2I.y()) / iVec2.y);
        iVec2.add(iVec2I);
        return iVec2;
    }

    public static IVec2 intersectSegmentAndYLine(IVec2I iVec2I, IVec2I iVec2I2, double d) {
        if (Math.max(iVec2I.x(), iVec2I2.x()) < d || Math.min(iVec2I.x(), iVec2I2.x()) > d) {
            return null;
        }
        IVec2 iVec2 = iVec2I2.get().diff(iVec2I);
        if (iVec2.x == 0.0) {
            return iVec2I.get().dup();
        }
        iVec2.mul((d - iVec2I.x()) / iVec2.x);
        iVec2.add(iVec2I);
        return iVec2;
    }

    public static IVec2I[] removeStraightPoints(IVec2I[] iVec2IArray, boolean bl) {
        int n = iVec2IArray.length;
        if (n <= 2) {
            return iVec2IArray;
        }
        ArrayList<IVec2I> arrayList = new ArrayList<IVec2I>();
        arrayList.add(iVec2IArray[0]);
        for (int i = 1; !bl && i < n - 1 || bl && i < n; ++i) {
            if (((IVec2I)arrayList.get(arrayList.size() - 1)).get().isStraight(iVec2IArray[i], iVec2IArray[(i + 1) % n])) continue;
            arrayList.add(iVec2IArray[i]);
        }
        if (bl && ((IVec2I)arrayList.get(arrayList.size() - 1)).get().isStraight((IVec2I)arrayList.get(0), (IVec2I)arrayList.get(1))) {
            arrayList.remove(0);
        }
        if (arrayList.size() == n) {
            return iVec2IArray;
        }
        IVec2I[] iVec2IArray2 = new IVec2I[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            iVec2IArray2[i] = (IVec2I)arrayList.get(i);
        }
        return iVec2IArray2;
    }

    public static IVec2I[] removeDuplicatedPoints(IVec2I[] iVec2IArray, boolean bl) {
        int n = iVec2IArray.length;
        ArrayList<IVec2I> arrayList = new ArrayList<IVec2I>();
        arrayList.add(iVec2IArray[0]);
        for (int i = 1; i < n; ++i) {
            if (((IVec2I)arrayList.get(arrayList.size() - 1)).get().eq(iVec2IArray[i])) continue;
            if (bl && i == n - 1) {
                if (((IVec2I)arrayList.get(0)).get().eq(iVec2IArray[i])) continue;
                arrayList.add(iVec2IArray[i]);
                continue;
            }
            arrayList.add(iVec2IArray[i]);
        }
        return arrayList.toArray(new IVec2I[arrayList.size()]);
    }

    public boolean isInside(IVec2I[] iVec2IArray) {
        double d = 0.0;
        int n = iVec2IArray.length;
        for (int i = 0; i < n; ++i) {
            IVec2 iVec2 = iVec2IArray[i].get().diff(this);
            IVec2 iVec22 = iVec2IArray[(i + 1) % n].get().diff(this);
            d += iVec2.angle(iVec22);
        }
        return Math.abs(d) < 0.1;
    }

    public boolean isInside(IVec2[] iVec2Array) {
        int n;
        double d = 0.0;
        int n2 = iVec2Array.length;
        for (n = 0; n < n2; ++n) {
            IVec2 iVec2;
            IVec2 iVec22 = iVec2Array[n].diff(this);
            double d2 = iVec22.angle(iVec2 = iVec2Array[(n + 1) % n2].diff(this));
            if (Math.abs(d2 - Math.PI) < IConfig.angleResolution || Math.abs(d2 + Math.PI) < IConfig.angleResolution || iVec22.len() < IConfig.lengthResolution || iVec2.len() < IConfig.lengthResolution) {
                return true;
            }
            d += d2;
        }
        n = (int)(Math.abs(d / (Math.PI * 2)) + 0.5);
        return n % 2 != 0;
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
    }

    public double distToLine(IVec2 iVec2, IVec2 iVec22) {
        double d = iVec22.x - iVec2.x;
        double d2 = iVec22.y - iVec2.y;
        return Math.abs(d2 * this.x + -d * this.y - iVec2.x * iVec22.y + iVec22.x * iVec2.y) / Math.sqrt(d2 * d2 + d * d);
    }

    public boolean isOnLine(IVec2 iVec2, IVec2 iVec22) {
        return this.distToLine(iVec2, iVec22) < IConfig.lengthResolution;
    }

    public boolean isBetween(IVec2I iVec2I, IVec2I iVec2I2) {
        IVec2 iVec2;
        IVec2 iVec22 = this.diff(iVec2I);
        double d = iVec22.dot(iVec2 = iVec2I2.get().diff(iVec2I));
        if (d < 0.0) {
            return false;
        }
        return !(d > iVec2.len2());
    }
}

