/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IG;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.geo.IBoundingBox;
import igeo.gui.IComponent;
import igeo.gui.IGraphics;
import igeo.gui.IPane;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;

public class IPanel
extends IComponent
implements IServerI,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener,
ComponentListener {
    public ArrayList<IPane> panes = new ArrayList();
    public IG ig = this.ig;
    public IPane currentMousePane = null;
    public IBoundingBox boundingBox;
    public int serverStatusCount;

    public IPanel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void setIG(IG iG) {
        this.ig = iG;
    }

    public IServer server() {
        return this.ig.server();
    }

    public void addPane(IPane iPane) {
        this.panes.add(iPane);
        iPane.setParent(this);
    }

    public IPane getPane(int n) {
        return this.panes.get(n);
    }

    public int paneNum() {
        return this.panes.size();
    }

    public void removePane(int n) {
        this.panes.remove(n);
    }

    public void clearPane() {
        this.panes.clear();
    }

    public void show() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).show();
        }
    }

    public void hide() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).hide();
        }
    }

    public void focus() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).focus();
        }
    }

    public void setSize(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        for (int i = 0; i < this.panes.size(); ++i) {
            int n5 = this.panes.get(i).getX() * n / n3;
            int n6 = this.panes.get(i).getY() * n2 / n4;
            int n7 = this.panes.get(i).getWidth() * n / n3;
            int n8 = this.panes.get(i).getHeight() * n2 / n4;
            this.panes.get(i).setBounds(n5, n6, n7, n8);
        }
        this.width = n;
        this.height = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(IGraphics iGraphics) {
        for (int i = 0; i < this.panes.size(); ++i) {
            Object object = IG.lock;
            synchronized (object) {
                if (this.panes.get(i).isVisible()) {
                    this.panes.get(i).draw(iGraphics);
                }
                continue;
            }
        }
    }

    public IPane getPaneAt(MouseEvent mouseEvent) {
        return this.getPaneAt(mouseEvent.getX(), mouseEvent.getY());
    }

    public IPane getPaneAt(int n, int n2) {
        for (int i = this.panes.size() - 1; i >= 0; --i) {
            if (!this.panes.get(i).isVisible() || !this.panes.get(i).contains(n, n2)) continue;
            return this.panes.get(i);
        }
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        IPane iPane = this.getPaneAt(mouseEvent);
        if (iPane != null) {
            this.currentMousePane = iPane;
            iPane.mousePressed(mouseEvent);
        } else {
            IOut.err("no pane");
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        IPane iPane = null;
        if (this.currentMousePane != null) {
            this.currentMousePane.mouseReleased(mouseEvent);
        } else {
            iPane = this.getPaneAt(mouseEvent);
            if (iPane != null) {
                iPane.mouseReleased(mouseEvent);
                this.currentMousePane = iPane;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        IPane iPane = this.getPaneAt(mouseEvent);
        if (iPane != null) {
            iPane.mouseClicked(mouseEvent);
        }
        this.currentMousePane = iPane;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        IPane iPane = this.getPaneAt(mouseEvent);
        if (iPane != null) {
            iPane.mouseMoved(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        IPane iPane = null;
        iPane = this.currentMousePane != null ? this.currentMousePane : this.getPaneAt(mouseEvent);
        if (iPane != null) {
            iPane.mouseDragged(mouseEvent);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.mouseWheelMoved(mouseWheelEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isControlDown();
        if (n == 70 && !bl2) {
            this.currentMousePane.focus();
        } else if (n == 83 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, true, false);
        } else if (n == 83 && bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(false, true, false);
        } else if (n == 87 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, false, false);
        } else if (n == 84 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, true, true);
        } else if (n == 84 && bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(false, true, true);
        } else if (n == 81 && bl2 && !bl) {
            System.exit(1);
        } else if (n == 83 && bl2 && !bl) {
            this.ig.save();
        }
        if (this.currentMousePane != null) {
            this.currentMousePane.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.keyReleased(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.keyTyped(keyEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = componentEvent.getComponent().getBounds().width;
        int n2 = componentEvent.getComponent().getBounds().height;
        this.setSize(n, n2);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public IBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new IBoundingBox();
        }
        if (this.ig.server().statusCount != this.serverStatusCount) {
            this.boundingBox.setObjects(this.ig.server());
            this.serverStatusCount = this.ig.server().statusCount();
        }
    }
}

