/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.geo.ISurfaceI;
import igeo.geo.ITrimCurve;
import igeo.geo.ITrimCurveI;
import igeo.geo.IVec2;
import igeo.gui.IPolyline;
import igeo.gui.IPolyline2D;
import igeo.gui.ITrimCurveGraphic;

public class ITrimLoopGraphic {
    public ISurfaceI surface;
    public ITrimCurveI[] curves;
    public IPolyline2D polyline2 = null;
    public IPolyline polyline = null;
    public int resolution;
    public boolean isOuterTrim = true;
    public boolean reversed = false;

    public ITrimLoopGraphic(ITrimCurveI[] iTrimCurveIArray, boolean bl, int n) {
        this.curves = iTrimCurveIArray;
        this.surface = iTrimCurveIArray[0].surface();
        this.isOuterTrim = bl;
        this.resolution = n;
    }

    public ITrimLoopGraphic(int n, boolean bl, int n2) {
        this.curves = new ITrimCurve[n];
        this.isOuterTrim = bl;
        this.resolution = n2;
    }

    public ITrimLoopGraphic(ISurfaceI iSurfaceI) {
        this.surface = iSurfaceI;
    }

    public int num() {
        return this.curves.length;
    }

    public void set(int n, ITrimCurveI iTrimCurveI) {
        this.curves[n] = iTrimCurveI;
        this.surface = iTrimCurveI.surface();
    }

    public IPolyline2D getPolyline2D() {
        if (this.polyline2 == null) {
            this.setup2D();
        }
        return this.polyline2;
    }

    public IPolyline getPolyline() {
        if (this.polyline == null) {
            this.setup3D();
        }
        return this.polyline;
    }

    public boolean reversed() {
        if (this.polyline2 == null) {
            this.setup2D();
        }
        return this.reversed;
    }

    public void setup2D() {
        int n;
        if (this.curves == null && this.surface != null) {
            this.polyline2 = new IPolyline2D(4);
            double d = 0.0;
            double d2 = 1.0;
            double d3 = 0.0;
            double d4 = 1.0;
            this.polyline2.set(0, new IVec2(d, d3));
            this.polyline2.set(1, new IVec2(d2, d3));
            this.polyline2.set(2, new IVec2(d2, d4));
            this.polyline2.set(3, new IVec2(d, d4));
            this.polyline2.close();
            return;
        }
        this.polyline2 = new IPolyline2D();
        for (n = 0; n < this.curves.length; ++n) {
            ITrimCurveGraphic iTrimCurveGraphic = new ITrimCurveGraphic(this.curves[n]);
            iTrimCurveGraphic.setup2D(this.resolution);
            if (n == 0 || this.polyline2.get(this.polyline2.num() - 1).dist(iTrimCurveGraphic.polyline2.get(0)) < this.polyline2.get(this.polyline2.num() - 1).dist(iTrimCurveGraphic.polyline2.get(iTrimCurveGraphic.polyline2.num() - 1))) {
                this.polyline2.append(iTrimCurveGraphic.polyline2);
                continue;
            }
            this.polyline2.append(iTrimCurveGraphic.polyline2, true);
        }
        this.polyline2.close();
        this.polyline2.removeDuplicatedPoints();
        this.polyline2.removeStraightPoints();
        n = this.polyline2.isNormalPositive() ? 1 : 0;
        if (this.isOuterTrim && n == 0 || !this.isOuterTrim && n != 0) {
            this.polyline2.reverse();
            this.reversed = true;
        }
    }

    public void setup3D() {
        if (this.curves == null && this.surface != null) {
            double d = 0.0;
            double d2 = 1.0;
            double d3 = 0.0;
            double d4 = 1.0;
            ITrimCurveGraphic iTrimCurveGraphic = new ITrimCurveGraphic(this.surface, new IPolyline2D(new IVec2(d, d3), new IVec2(d2, d3)));
            ITrimCurveGraphic iTrimCurveGraphic2 = new ITrimCurveGraphic(this.surface, new IPolyline2D(new IVec2(d2, d3), new IVec2(d2, d4)));
            ITrimCurveGraphic iTrimCurveGraphic3 = new ITrimCurveGraphic(this.surface, new IPolyline2D(new IVec2(d2, d4), new IVec2(d, d4)));
            ITrimCurveGraphic iTrimCurveGraphic4 = new ITrimCurveGraphic(this.surface, new IPolyline2D(new IVec2(d, d4), new IVec2(d, d3)));
            this.polyline = new IPolyline();
            this.polyline.append(iTrimCurveGraphic.getPolyline(1));
            this.polyline.append(iTrimCurveGraphic2.getPolyline(1));
            this.polyline.append(iTrimCurveGraphic3.getPolyline(1));
            this.polyline.append(iTrimCurveGraphic4.getPolyline(1));
            this.polyline.close();
            return;
        }
        if (this.surface.udeg() == 1 && this.surface.vdeg() == 1 && this.surface.ucpNum() == 2 && this.surface.vcpNum() == 2 && this.surface.isFlat()) {
            if (this.polyline2 == null) {
                this.setup2D();
            }
            this.polyline = new IPolyline(this.polyline2.num());
            for (int i = 0; i < this.polyline2.num(); ++i) {
                this.polyline.set(i, this.surface.pt(this.polyline2.get(i)));
            }
        } else {
            this.polyline = new IPolyline();
            for (int i = 0; i < this.curves.length; ++i) {
                ITrimCurveGraphic iTrimCurveGraphic = new ITrimCurveGraphic(this.curves[i]);
                iTrimCurveGraphic.setup3D(this.resolution);
                if (i == 0 || this.polyline.get(this.polyline.num() - 1).dist(iTrimCurveGraphic.polyline.get(0)) < this.polyline.get(this.polyline.num() - 1).dist(iTrimCurveGraphic.polyline.get(iTrimCurveGraphic.polyline.num() - 1))) {
                    this.polyline.append(iTrimCurveGraphic.polyline);
                    continue;
                }
                this.polyline.append(iTrimCurveGraphic.polyline, true);
            }
            this.polyline.close();
        }
        this.polyline.close();
    }
}

