/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IG;
import igeo.core.IOut;
import igeo.geo.IBSplineBasisFunction;
import igeo.geo.IBool;
import igeo.geo.ICurveI;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IEntityParameter;
import igeo.geo.IInteger;
import igeo.geo.IIntegerI;
import igeo.geo.INurbsGeo;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec4;
import igeo.geo.IVec4I;
import igeo.geo.IVecI;

public class ICurveGeo
extends INurbsGeo
implements ICurveI,
IEntityParameter {
    public IVecI[] controlPoints;
    public int degree;
    public double[] knots;
    public double ustart;
    public double uend;
    public boolean[] defaultWeights;
    public IBSplineBasisFunction basisFunction;
    public IBSplineBasisFunction derivativeFunction;

    public ICurveGeo() {
    }

    public ICurveGeo(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        this.ustart = d;
        this.uend = d2;
        if (d != 0.0 || d2 != 1.0) {
            ICurveGeo.normalizeKnots(dArray, d, d2);
        }
        this.init(iVecIArray, n, dArray);
    }

    public ICurveGeo(IVecI[] iVecIArray, int n, double[] dArray) {
        this.ustart = dArray[0];
        this.uend = dArray[dArray.length - 1];
        if (dArray[0] != 0.0 || dArray[dArray.length - 1] != 1.0) {
            ICurveGeo.normalizeKnots(dArray, dArray[0], dArray[dArray.length - 1]);
        }
        this.init(iVecIArray, n, dArray);
    }

    public ICurveGeo(IVecI[] iVecIArray, int n) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, n, ICurveGeo.createKnots(n, iVecIArray.length));
    }

    public ICurveGeo(IVecI[] iVecIArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, 1, ICurveGeo.createKnots(1, iVecIArray.length));
    }

    public ICurveGeo(IVecI[] iVecIArray, int n, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, n, bl);
    }

    public ICurveGeo(IVecI[] iVecIArray, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(iVecIArray, 1, bl);
    }

    public ICurveGeo(IVecI iVecI, IVecI iVecI2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init(new IVecI[]{iVecI, iVecI2}, 1, ICurveGeo.createKnots(1, 2));
    }

    public ICurveGeo(double d, double d2, double d3, double d4, double d5, double d6) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6));
    }

    public ICurveGeo(double[][] dArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), 1);
    }

    public ICurveGeo(double[][] dArray, int n) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), n);
    }

    public ICurveGeo(double[][] dArray, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), 1, bl);
    }

    public ICurveGeo(double[][] dArray, int n, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.init((IVecI[])ICurveGeo.getPointsFromArray(dArray), n, bl);
    }

    public ICurveGeo(ICurveGeo iCurveGeo) {
        this.controlPoints = new IVecI[iCurveGeo.controlPoints.length];
        for (int i = 0; i < this.controlPoints.length; ++i) {
            this.controlPoints[i] = iCurveGeo.controlPoints[i].dup();
        }
        this.knots = new double[iCurveGeo.knots.length];
        System.arraycopy(iCurveGeo.knots, 0, this.knots, 0, this.knots.length);
        this.degree = iCurveGeo.degree;
        this.ustart = iCurveGeo.ustart;
        this.uend = iCurveGeo.uend;
        this.init(this.controlPoints, this.degree, this.knots);
    }

    public void init(IVecI[] iVecIArray) {
        this.init(iVecIArray, 1, ICurveGeo.createKnots(1, iVecIArray.length));
    }

    public void init(IVecI[] iVecIArray, int n) {
        this.init(iVecIArray, n, ICurveGeo.createKnots(n, iVecIArray.length));
    }

    public void init(IVecI[] iVecIArray, boolean bl) {
        this.init(iVecIArray, 1, bl);
    }

    public void init(IVecI[] iVecIArray, int n, boolean bl) {
        if (bl) {
            IVecI[] iVecIArray2 = ICurveGeo.createClosedControlPoints(iVecIArray, n);
            this.init(iVecIArray2, n, ICurveGeo.createClosedKnots(n, iVecIArray2.length));
        } else {
            this.init(iVecIArray, n, ICurveGeo.createKnots(n, iVecIArray.length));
        }
    }

    public void init(IVecI[] iVecIArray, int n, double[] dArray) {
        this.controlPoints = iVecIArray;
        this.degree = n;
        this.knots = dArray;
        this.basisFunction = new IBSplineBasisFunction(n, dArray);
        this.defaultWeights = new boolean[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            this.defaultWeights[i] = !(iVecIArray[i] instanceof IVec4I);
        }
    }

    public static IVec[] getPointsFromArray(double[][] dArray) {
        IVec[] iVecArray = new IVec[dArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            if (dArray[i].length == 4) {
                iVecArray[i] = new IVec4(dArray[i][0], dArray[i][1], dArray[i][2], dArray[i][3]);
                continue;
            }
            iVecArray[i] = new IVec();
            if (dArray[i].length >= 1) {
                iVecArray[i].x = dArray[i][0];
            }
            if (dArray[i].length >= 2) {
                iVecArray[i].y = dArray[i][1];
            }
            if (dArray[i].length < 3) continue;
            iVecArray[i].z = dArray[i][2];
        }
        return iVecArray;
    }

    public ICurveGeo get() {
        return this;
    }

    public ICurveGeo dup() {
        return new ICurveGeo(this);
    }

    public IVec pt(IDoubleI iDoubleI) {
        return this.pt(iDoubleI.x());
    }

    public IVec pt(double d) {
        IVec iVec = new IVec();
        this.pt(d, iVec);
        return iVec;
    }

    public void pt(double d, IVec iVec) {
        int n = this.basisFunction.index(d);
        double[] dArray = this.basisFunction.eval(n, d);
        double d2 = 0.0;
        for (int i = 0; i <= this.degree; ++i) {
            IVec iVec2 = this.controlPoints[n - this.degree + i].get();
            double d3 = 1.0;
            if (!this.defaultWeights[n - this.degree + i]) {
                d3 = ((IVec4)iVec2).w;
            }
            iVec.x += iVec2.x * d3 * dArray[i];
            iVec.y += iVec2.y * d3 * dArray[i];
            iVec.z += iVec2.z * d3 * dArray[i];
            d2 += d3 * dArray[i];
        }
        iVec.x /= d2;
        iVec.y /= d2;
        iVec.z /= d2;
    }

    public IVec tan(IDoubleI iDoubleI) {
        return this.tan(iDoubleI.x());
    }

    public IVec tan(double d) {
        IVec iVec = new IVec();
        this.tan(d, iVec);
        return iVec;
    }

    public void tan(double d, IVec iVec) {
        if (this.derivativeFunction == null) {
            this.derivativeFunction = new IBSplineBasisFunction(this.basisFunction);
            this.derivativeFunction.differentiate();
        }
        int n = this.derivativeFunction.index(d);
        double[] dArray = this.derivativeFunction.eval(n, d);
        double[] dArray2 = this.basisFunction.eval(n, d);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.degree; ++i) {
            IVec iVec2 = this.controlPoints[n - this.degree + i].get();
            double d2 = 1.0;
            if (!this.defaultWeights[n - this.degree + i]) {
                d2 = ((IVec4)iVec2).w;
            }
            iVec4.x += iVec2.x * d2 * dArray2[i];
            iVec4.y += iVec2.y * d2 * dArray2[i];
            iVec4.z += iVec2.z * d2 * dArray2[i];
            iVec4.w += d2 * dArray2[i];
            iVec42.x += iVec2.x * d2 * dArray[i];
            iVec42.y += iVec2.y * d2 * dArray[i];
            iVec42.z += iVec2.z * d2 * dArray[i];
            iVec42.w += d2 * dArray[i];
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    public IVec cp(int n) {
        return this.controlPoints[n].get();
    }

    public IVecI cp(IIntegerI iIntegerI) {
        return this.controlPoints[iIntegerI.x()];
    }

    public IVec ep(int n) {
        return this.pt(this.knots[n + this.degree]);
    }

    public IVec ep(IIntegerI iIntegerI) {
        return this.pt(this.knots[iIntegerI.x() + this.degree]);
    }

    public IVec start() {
        return this.pt(0.0);
    }

    public IVec end() {
        return this.pt(1.0);
    }

    public IVec startCP() {
        return this.controlPoints[0].get();
    }

    public IVec endCP() {
        return this.controlPoints[this.controlPoints.length - 1].get();
    }

    public double knot(int n) {
        return this.knots[n];
    }

    public IDouble knot(IIntegerI iIntegerI) {
        return new IDouble(this.knots[iIntegerI.x()]);
    }

    public int knotNum() {
        return this.knots.length;
    }

    public int knotNum(ISwitchE iSwitchE) {
        return this.knotNum();
    }

    public IInteger knotNum(ISwitchR iSwitchR) {
        return new IInteger(this.knotNum());
    }

    public int deg() {
        return this.degree;
    }

    public int deg(ISwitchE iSwitchE) {
        return this.deg();
    }

    public IInteger deg(ISwitchR iSwitchR) {
        return new IInteger(this.deg());
    }

    public int num() {
        return this.controlPoints.length;
    }

    public int num(ISwitchE iSwitchE) {
        return this.num();
    }

    public IInteger num(ISwitchR iSwitchR) {
        return new IInteger(this.num());
    }

    public int cpNum() {
        return this.num();
    }

    public int cpNum(ISwitchE iSwitchE) {
        return this.cpNum();
    }

    public IInteger cpNum(ISwitchR iSwitchR) {
        return new IInteger(this.cpNum());
    }

    public int epNum() {
        return this.knots.length - 2 * this.degree;
    }

    public int epNum(ISwitchE iSwitchE) {
        return this.epNum();
    }

    public IInteger epNum(ISwitchR iSwitchR) {
        return new IInteger(this.epNum());
    }

    public boolean isRational() {
        if (this.defaultWeights == null) {
            IOut.err("defaultWeights is null");
            return false;
        }
        for (int i = 0; i < this.defaultWeights.length; ++i) {
            if (this.defaultWeights[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isRational(ISwitchE iSwitchE) {
        return this.isRational();
    }

    public IBool isRational(ISwitchR iSwitchR) {
        return new IBool(this.isRational());
    }

    public double len() {
        return 0.0;
    }

    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    public double u(int n, double d) {
        if (d >= 0.0) {
            return this.knots[n + this.degree] + (this.knots[n + this.degree + 1] - this.knots[n + this.degree]) * d;
        }
        return this.knots[n + this.degree] + (this.knots[n + this.degree] - this.knots[n + this.degree - 1]) * d;
    }

    public IDouble u(IInteger iInteger, IDouble iDouble) {
        return new IDouble(this.u(iInteger.x(), iDouble.x()));
    }

    public double ustart() {
        return this.ustart;
    }

    public double uend() {
        return this.uend;
    }

    public double ustart(ISwitchE iSwitchE) {
        return this.ustart();
    }

    public double uend(ISwitchE iSwitchE) {
        return this.uend();
    }

    public IDouble ustart(ISwitchR iSwitchR) {
        return new IDouble(this.ustart());
    }

    public IDouble uend(ISwitchR iSwitchR) {
        return new IDouble(this.uend());
    }

    public boolean isClosed() {
        boolean bl = true;
        if (this.knots[0] != 0.0 || this.knots[this.knots.length - 1] != 1.0) {
            bl = false;
        }
        if (bl) {
            return this.cp(0).eq(this.cp(this.cpNum() - 1));
        }
        return this.pt(0.0).eq(this.pt(1.0));
    }

    public boolean isClosed(ISwitchE iSwitchE) {
        return this.isClosed();
    }

    public IBool isClosed(ISwitchR iSwitchR) {
        return new IBool(this.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICurveGeo rev() {
        Object object = IG.lock;
        synchronized (object) {
            IVecI[] iVecIArray = new IVecI[this.controlPoints.length];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                iVecIArray[i] = this.controlPoints[this.controlPoints.length - 1 - i];
            }
            double[] dArray = new double[this.knots.length];
            for (int i = 0; i < this.knots.length; ++i) {
                dArray[i] = 1.0 - this.knots[this.knots.length - 1 - i];
            }
            boolean[] blArray = new boolean[this.defaultWeights.length];
            for (int i = 0; i < this.defaultWeights.length; ++i) {
                blArray[i] = this.defaultWeights[this.defaultWeights.length - 1 - i];
            }
            this.controlPoints = iVecIArray;
            this.knots = dArray;
            this.defaultWeights = blArray;
            if (this.ustart != 0.0 || this.uend != 1.0) {
                double d = -this.uend;
                double d2 = -this.ustart;
                this.ustart = d;
                this.uend = d2;
            }
            this.basisFunction = new IBSplineBasisFunction(this.degree, this.knots);
            this.derivativeFunction = null;
        }
        return this;
    }
}

