/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IOut;
import igeo.geo.IBoolI;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IEdge;
import igeo.geo.IFace;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVec4I;
import igeo.geo.IVecI;
import igeo.util.IComparator;
import java.util.ArrayList;

public class IVertex
implements IVecI {
    public ArrayList<IEdge> edges;
    public ArrayList<IFace> faces;
    public ArrayList<IVertex> linkedVertices;
    public IVecI pos;
    public IVecI normal;
    public IVec2I texture;

    public IVertex() {
        this.pos = new IVec();
        this.init();
    }

    public IVertex(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.init();
    }

    public IVertex(IVec iVec) {
        this.pos = iVec;
        this.init();
    }

    public IVertex(IVec4 iVec4) {
        this.pos = iVec4;
        this.init();
    }

    public IVertex(IVecI iVecI) {
        this.pos = iVecI;
        this.init();
    }

    public IVertex(IVertex iVertex) {
        int n;
        this.edges = new ArrayList();
        for (n = 0; n < iVertex.edges.size(); ++n) {
            this.edges.add(iVertex.edges.get(n));
        }
        this.faces = new ArrayList();
        for (n = 0; n < iVertex.faces.size(); ++n) {
            this.faces.add(iVertex.faces.get(n));
        }
        this.linkedVertices = new ArrayList();
        for (n = 0; n < iVertex.linkedVertices.size(); ++n) {
            this.linkedVertices.add(iVertex.linkedVertices.get(n));
        }
        this.pos = iVertex.pos.dup();
        if (iVertex.normal != null) {
            this.normal = iVertex.normal.dup();
        }
        if (iVertex.texture != null) {
            this.texture = iVertex.texture.dup();
        }
    }

    public void init() {
        this.edges = new ArrayList();
        this.faces = new ArrayList();
        this.linkedVertices = new ArrayList();
    }

    public void del() {
        int n;
        for (n = 0; n < this.faces.size(); ++n) {
            this.faces.get(n).del();
        }
        for (n = 0; n < this.edges.size(); ++n) {
            this.edges.get(n).del();
        }
        for (n = 0; n < this.linkedVertices.size(); ++n) {
            this.linkedVertices.get((int)n).linkedVertices.remove(this);
        }
    }

    public double x() {
        return this.pos.x();
    }

    public double y() {
        return this.pos.y();
    }

    public double z() {
        return this.pos.z();
    }

    public IVec get() {
        return this.pos.get();
    }

    public IVertex dup() {
        return new IVertex(this);
    }

    public IVec2I to2d() {
        return this.pos.to2d();
    }

    public IVec4I to4d() {
        return this.pos.to4d();
    }

    public IVec4I to4d(double d) {
        return this.pos.to4d(d);
    }

    public IVec4I to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    public IDoubleI getX() {
        return this.pos.getX();
    }

    public IDoubleI getY() {
        return this.pos.getY();
    }

    public IDoubleI getZ() {
        return this.pos.getZ();
    }

    public IVertex set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public IVertex set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    public IVertex set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    public IVertex add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    public IVertex sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    public IVertex sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVertex sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    public IVertex mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    public IVertex mul(double d) {
        this.pos.mul(d);
        return this;
    }

    public IVertex div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    public IVertex div(double d) {
        this.pos.div(d);
        return this;
    }

    public IVertex neg() {
        this.pos.neg();
        return this;
    }

    public IVertex rev() {
        this.pos.rev();
        return this;
    }

    public IVertex add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    public IVertex add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    public IDoubleI dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    public IVecI cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    public double len() {
        return this.pos.len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    public IDoubleI len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    public double len2() {
        return this.pos.len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    public IDoubleI len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    public IVertex len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    public IVertex len(double d) {
        this.pos.len(d);
        return this;
    }

    public IVertex unit() {
        this.pos.unit();
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    public IDoubleI dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    public IDoubleI dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    public IVertex rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    public IVertex rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    public IVertex rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    public IVecI rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVertex scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    public IVertex scale(double d) {
        this.pos.scale(d);
        return this;
    }

    public IVertex scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    public IVertex scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    public IVertex ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IVertex ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IVertex mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    public IVertex mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    public IVertex transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    public IVertex transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    public IVertex transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVertex transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IVertex diff(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IVertex mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IVertex sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVertex sum(IVecI ... iVecIArray) {
        IVertex iVertex = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVertex.add(iVecI);
        }
        return iVertex;
    }

    public IVertex bisect(IVecI iVecI) {
        return this.dup().unit().add(iVecI.dup().unit());
    }

    public IVertex sum(IVecI iVecI, double d, double d2) {
        return this.dup().mul(d).add(iVecI, d2);
    }

    public IVertex sum(IVecI iVecI, double d) {
        return this.dup().mul(1.0 - d).add(iVecI, d);
    }

    public IVertex sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.dup().mul(iDoubleI).add(iVecI, iDoubleI2);
    }

    public IVertex sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.dup().mul(new IDouble(1.0).sub(iDoubleI)).add(iVecI, iDoubleI);
    }

    public IVec getAverageNormal() {
        if (this.faces == null || this.faces.size() == 0) {
            return new IVec(0.0, 0.0, 1.0);
        }
        IVec iVec = new IVec(0.0, 0.0, 0.0);
        for (int i = 0; i < this.faces.size(); ++i) {
            iVec.add(this.faces.get(i).getAverageNormal());
        }
        iVec.unit();
        return iVec;
    }

    public void calcNormal() {
        this.normal = this.getAverageNormal();
    }

    public IVecI normal() {
        return this.nrml();
    }

    public IVecI nrml() {
        if (this.normal == null) {
            this.calcNormal();
        }
        return this.normal;
    }

    public IVertex normal(IVec iVec) {
        this.nrml(iVec);
        return this;
    }

    public IVertex normal(double d, double d2, double d3) {
        this.nrml(d, d2, d3);
        return this;
    }

    public IVertex nrml(IVec iVec) {
        this.normal = iVec;
        return this;
    }

    public IVertex nrml(double d, double d2, double d3) {
        this.nrml(new IVec(d, d2, d3));
        return this;
    }

    public IVec2I texture() {
        return this.texture;
    }

    public IVertex texture(IVec2I iVec2I) {
        this.texture = iVec2I;
        return this;
    }

    public IVertex texture(double d, double d2) {
        this.texture(new IVec2(d, d2));
        return this;
    }

    public void addEdge(IEdge iEdge) {
        this.edges.add(iEdge);
        if (iEdge.getVertex(0) == this) {
            this.linkedVertices.add(iEdge.getVertex(1));
        } else {
            this.linkedVertices.add(iEdge.getVertex(0));
        }
    }

    public IEdge getEdge(int n) {
        return this.edge(n);
    }

    public IEdge edge(int n) {
        return this.edges.get(n);
    }

    public int edgeNum() {
        return this.edges.size();
    }

    public IEdge getEdgeTo(IVertex iVertex) {
        for (int i = 0; i < this.edges.size(); ++i) {
            IEdge iEdge = this.edges.get(i);
            if (iEdge.getOtherVertex(this) != iVertex) continue;
            return iEdge;
        }
        return null;
    }

    public IEdge createEdgeTo(IVertex iVertex) {
        IEdge iEdge = this.getEdgeTo(iVertex);
        if (iEdge == null) {
            iEdge = new IEdge(this, iVertex);
        }
        return iEdge;
    }

    public void addFace(IFace iFace) {
        this.faces.add(iFace);
    }

    public IFace getFace(int n) {
        return this.face(n);
    }

    public IFace face(int n) {
        return this.faces.get(n);
    }

    public int faceNum() {
        return this.faces.size();
    }

    public IVertex getLinkedVertex(int n) {
        return this.linkedVertices.get(n);
    }

    public int linkedVertexNum() {
        return this.linkedVertices.size();
    }

    public void replaceLinkedVertex(IVertex iVertex, IVertex iVertex2) {
        int n = this.linkedVertices.indexOf(iVertex);
        if (n < 0) {
            IOut.err("no such linked vertex in this vertex");
            return;
        }
        this.linkedVertices.set(n, iVertex2);
    }

    public void replaceVertex(IVertex iVertex) {
        int n;
        int n2;
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        for (int i = 0; i < this.edges.size(); ++i) {
            IVertex iVertex2 = this.edges.get(i).getOtherVertex(this);
            for (int j = 0; j < iVertex.edges.size(); ++j) {
                IVertex iVertex3 = iVertex.edges.get(j).getOtherVertex(iVertex);
                if (iVertex2 != iVertex3 || arrayList.contains(iVertex2)) continue;
                arrayList.add(iVertex2);
            }
        }
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        for (n2 = 0; n2 < this.edges.size(); ++n2) {
            IEdge iEdge = this.edges.get(n2);
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                if (!iEdge.contains((IVertex)arrayList.get(n))) continue;
                bl = true;
            }
            if (iEdge.contains(iVertex)) {
                bl = true;
            }
            if (bl) {
                arrayList2.add(iEdge);
                continue;
            }
            iEdge.replaceVertex(this, iVertex);
            iVertex.addEdge(iEdge);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            ((IEdge)arrayList2.get(n2)).del();
        }
        for (n2 = 0; n2 < this.linkedVertices.size(); ++n2) {
            IVertex iVertex4 = this.linkedVertices.get(n2);
            boolean bl = false;
            for (n = 0; n < arrayList.size() && !bl; ++n) {
                if (iVertex4 != arrayList.get(n)) continue;
                bl = true;
            }
            if (iVertex4 == iVertex) {
                bl = true;
            }
            if (bl) continue;
            iVertex4.replaceLinkedVertex(this, iVertex);
        }
        for (n2 = 0; n2 < this.faces.size(); ++n2) {
            IFace iFace = this.faces.get(n2);
            iFace.replaceVertex(this, iVertex);
            iVertex.addFace(iFace);
        }
    }

    public IEdge[] getOtherEdges(IEdge iEdge) {
        IEdge[] iEdgeArray = new IEdge[this.edges.size() - 1];
        if (!this.edges.contains(iEdge)) {
            IOut.err("no such edge in this vertex");
            return null;
        }
        int n = 0;
        for (int i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i) == iEdge) continue;
            iEdgeArray[n] = this.edges.get(i);
            ++n;
        }
        return iEdgeArray;
    }

    public String toString() {
        return "IVertex: " + this.pos + " (normal=" + this.normal + ", texture=" + this.texture + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZYXComparator
    implements IComparator<IVertex> {
        @Override
        public int compare(IVertex iVertex, IVertex iVertex2) {
            IVec iVec = iVertex.pos.get();
            IVec iVec2 = iVertex2.pos.get();
            if (iVec.z < iVec2.z - IConfig.lengthResolution) {
                return 1;
            }
            if (iVec.z > iVec2.z + IConfig.lengthResolution) {
                return -1;
            }
            if (iVec.y < iVec2.y - IConfig.lengthResolution) {
                return 1;
            }
            if (iVec.y > iVec2.y + IConfig.lengthResolution) {
                return -1;
            }
            if (iVec.x < iVec2.x - IConfig.lengthResolution) {
                return 1;
            }
            if (iVec.x > iVec2.x + IConfig.lengthResolution) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZComparator
    implements IComparator<IVertex> {
        @Override
        public int compare(IVertex iVertex, IVertex iVertex2) {
            double d;
            double d2 = iVertex.pos.z();
            if (d2 < (d = iVertex2.pos.z())) {
                return 1;
            }
            if (d2 > d) {
                return -1;
            }
            return 0;
        }
    }
}

