/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IGraphicObject;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceR;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicFillGL;
import igeo.gui.ISurfaceGraphicWireframeGL;
import java.awt.Color;

public class ISurfaceGraphicGL
extends IGraphicObject {
    public static float defaultColorRed = 0.5f;
    public static float defaultColorGreen = 0.5f;
    public static float defaultColorBlue = 0.5f;
    public static float defaultColorAlpha = 1.0f;
    public static float defaultShininess = 0.3f;
    public ISurfaceGraphicFillGL fill;
    public ISurfaceGraphicWireframeGL wireframe;

    public ISurfaceGraphicGL(ISurface iSurface) {
        super(iSurface);
    }

    public ISurfaceGraphicGL(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
    }

    public void setColor(Color color) {
        super.setColor(color);
        if (this.fill != null) {
            this.fill.setColor(color);
        }
        if (this.wireframe != null) {
            this.wireframe.setColor(color);
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }

    public void draw(IGraphics iGraphics) {
        if (iGraphics.view().mode().isWireframe()) {
            if (this.wireframe == null) {
                if (this.parent instanceof ISurface) {
                    this.wireframe = new ISurfaceGraphicWireframeGL((ISurface)this.parent);
                } else if (this.parent instanceof ISurfaceR) {
                    this.wireframe = new ISurfaceGraphicWireframeGL((ISurfaceR)this.parent);
                }
                this.wireframe.setColor(this.color);
            }
            this.wireframe.draw(iGraphics);
        }
        if (iGraphics.view().mode().isFill()) {
            if (this.fill == null) {
                if (this.parent instanceof ISurface) {
                    this.fill = new ISurfaceGraphicFillGL((ISurface)this.parent);
                } else if (this.parent instanceof ISurfaceR) {
                    this.fill = new ISurfaceGraphicFillGL((ISurfaceR)this.parent);
                }
                this.fill.setColor(this.color);
            }
            this.fill.draw(iGraphics);
        }
    }
}

