/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.geo.ICurve;
import igeo.geo.IMesh;
import igeo.geo.IPoint;
import igeo.geo.ISurface;
import igeo.gui.IGraphicMode;
import igeo.gui.IPanel;
import igeo.io.IIO;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class IG
implements IServerI {
    public static final Object lock = new Object();
    public static final String GL = "igeo.p.PIGraphicsGL";
    protected static ArrayList<IG> iglist = null;
    protected static int currentId = -1;
    public IServer server;
    public IPanel panel = null;
    public String inputFile;
    public String outputFile;
    public String basePath = ".";

    public static int majorVersion() {
        return 0;
    }

    public static int minorVersion() {
        return 7;
    }

    public static int buildVersion() {
        return 0;
    }

    public static int revisionVersion() {
        return 0;
    }

    public static Calendar versionDate() {
        return new GregorianCalendar(2011, 8, 31);
    }

    public static String version() {
        return String.valueOf(IG.majorVersion()) + "." + String.valueOf(IG.minorVersion()) + "." + String.valueOf(IG.buildVersion()) + "." + String.valueOf(IG.revisionVersion());
    }

    public static IG init() {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG();
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG init(IPanel iPanel) {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG(iPanel);
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG current() {
        if (iglist == null || currentId < 0 || currentId >= iglist.size()) {
            return null;
        }
        return iglist.get(currentId);
    }

    public static void setCurrent(IG iG) {
        int n = iglist.indexOf(iG);
        if (n >= 0 && n < iglist.size()) {
            currentId = n;
        } else {
            iglist.add(iG);
            currentId = iglist.size() - 1;
        }
    }

    public static void setCurrent(IPanel iPanel) {
        for (int i = 0; i < iglist.size(); ++i) {
            if (IG.iglist.get((int)i).panel != iPanel) continue;
            currentId = i;
            return;
        }
        IOut.err("no IG instance found for " + iPanel);
    }

    public static IG getIG(IPanel iPanel) {
        for (IG iG : iglist) {
            if (iG.panel != iPanel) continue;
            return iG;
        }
        return null;
    }

    public static boolean open(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return false;
        }
        return iG.openFile(string);
    }

    public static boolean save(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return false;
        }
        return iG.saveFile(string);
    }

    public static void outputFile(String string) {
        IG iG = IG.current();
        if (iG != null) {
            iG.setOutputFile(string);
        }
    }

    public static String outputFile() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getOutputFile();
    }

    public static void inputFile(String string) {
        IG iG = IG.current();
        if (iG != null) {
            iG.setInputFile(string);
        }
    }

    public static String inputFile() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getInputFile();
    }

    public static IPoint[] points() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getPoints();
    }

    public static ICurve[] curves() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getCurves();
    }

    public static ISurface[] surfaces() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getSurfaces();
    }

    public static IMesh[] meshes() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getMeshes();
    }

    public static IObject[] objects(Class clazz) {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getObjects(clazz);
    }

    public static ILayer layer(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getLayer(string);
    }

    public static ILayer[] layers() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getAllLayers();
    }

    public static void delLayer(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return;
        }
        iG.removeLayer(string);
    }

    public static void focus() {
        IG iG = IG.current();
        if (iG == null) {
            return;
        }
        iG.focusView();
    }

    public static boolean isGL() {
        IG iG = IG.current();
        if (iG == null) {
            IOut.err("no IG found");
            return true;
        }
        if (iG.server().graphicServer() == null) {
            IOut.err("no graphic server found");
            return true;
        }
        return iG.server().graphicServer().isGL();
    }

    public static void graphicMode(IGraphicMode iGraphicMode) {
        IG iG = IG.current();
        if (iG == null) {
            return;
        }
        iG.server().setGraphicMode(iGraphicMode);
    }

    public static void wireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, false, true, false));
    }

    public static void fill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, false));
    }

    public static void fillWithWireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, false));
    }

    public static void transparentFill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, true));
    }

    public static void transparentFillWithWireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, true));
    }

    public static void p(Object object) {
        IOut.printlnWithOffset(object, 1);
    }

    public static void p() {
        IOut.printlnWithOffset(1);
    }

    public static void enabePrintPrefix() {
        IOut.enablePrefix();
    }

    public static void disablePrintPrefix() {
        IOut.disablePrefix();
    }

    protected IG() {
        this.server = new IServer(this);
    }

    protected IG(IPanel iPanel) {
        this.server = new IServer(this, iPanel);
        this.panel = iPanel;
        iPanel.setIG(this);
    }

    public boolean openFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
        }
        boolean bl = IIO.open(string, (IServerI)this);
        this.server.update();
        this.inputFile = string;
        this.focusView();
        return bl;
    }

    public boolean saveFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
            File file2 = new File(this.basePath);
            if (!file2.isDirectory()) {
                IOut.debug(20, "creating directory" + file2.toString());
                if (!file2.mkdir()) {
                    IOut.err("failed to create directory: " + file2.toString());
                }
            }
        }
        return IIO.save(string, (IServerI)this);
    }

    public boolean save() {
        if (this.outputFile == null) {
            IOut.err("output filename is not set. not saved");
            return false;
        }
        return this.saveFile(this.outputFile);
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String setBasePath(String string) {
        this.basePath = string;
        return this.basePath;
    }

    public ILayer getLayer(String string) {
        return this.server.getLayer(string);
    }

    public ILayer[] getAllLayers() {
        return this.server.getAllLayers();
    }

    public void removeLayer(String string) {
        this.server.removeLayer(string);
    }

    public IPoint[] getPoints() {
        return this.server.getPoints();
    }

    public ICurve[] getCurves() {
        return this.server.getCurves();
    }

    public ISurface[] getSurfaces() {
        return this.server.getSurfaces();
    }

    public IMesh[] getMeshes() {
        return this.server.getMeshes();
    }

    public IObject[] getObjects(Class clazz) {
        return this.server.getObjects(clazz);
    }

    public void focusView() {
        if (this.panel != null) {
            this.panel.focus();
        }
    }

    public IServer server() {
        return this.server;
    }

    public void clear() {
        this.server.clear();
    }
}

