/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IServerI;
import igeo.geo.ICircleGeo;
import igeo.geo.INurbsGeo;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceGeo;
import igeo.geo.IVec;
import igeo.geo.IVecI;

public class ICylinder
extends ISurface {
    public IVec pt1;
    public IVec pt2;
    public double radius1;
    public double radius2;

    public ICylinder(IVec iVec, IVec iVec2, double d) {
        this(null, iVec, iVec2, d, d);
    }

    public ICylinder(IServerI iServerI, IVec iVec, IVec iVec2, double d) {
        this(iServerI, iVec, iVec2, d, d);
    }

    public ICylinder(IVec iVec, IVec iVec2, double d, double d2) {
        this(null, iVec, iVec2, d, d2);
    }

    public ICylinder(IServerI iServerI, IVec iVec, IVec iVec2, double d, double d2) {
        super(iServerI);
        this.pt1 = iVec;
        this.pt2 = iVec2;
        this.radius1 = d;
        this.radius2 = d2;
        this.initCylinder(iServerI);
    }

    public void initCylinder(IServerI iServerI) {
        IVec iVec = this.pt2.diff(this.pt1);
        IVecI[][] iVecIArray = new IVec[][]{ICircleGeo.circleCP(this.pt1, iVec, this.radius1), ICircleGeo.circleCP(this.pt2, iVec, this.radius2)};
        this.surface = new ISurfaceGeo(iVecIArray, 1, ICircleGeo.circleDeg(), INurbsGeo.createKnots(1, 2), ICircleGeo.circleKnots());
        super.initSurface(iServerI);
    }
}

