/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.core.IBasicMaterial;
import igeo.core.IConfig;
import igeo.core.ILayer;
import igeo.core.IMaterial;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IParameterObject;
import igeo.core.IServerI;
import igeo.geo.IArc;
import igeo.geo.IArcGeo;
import igeo.geo.IBoundingBox;
import igeo.geo.IBrep;
import igeo.geo.ICircle;
import igeo.geo.ICircleGeo;
import igeo.geo.ICurve;
import igeo.geo.ICurveGeo;
import igeo.geo.IFace;
import igeo.geo.IMesh;
import igeo.geo.IMeshGeo;
import igeo.geo.IMeshI;
import igeo.geo.IPoint;
import igeo.geo.IPolycurve;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceGeo;
import igeo.geo.ISurfaceI;
import igeo.geo.ITrimCurve;
import igeo.geo.ITrimCurveI;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec4;
import igeo.geo.IVecI;
import igeo.geo.IVertex;
import igeo.gui.ITrimLoopGraphic;
import igeo.io.IRhino3dmExporter;
import igeo.io.IRhino3dmImporter;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.CRC32;

public class IRhino3dm {
    public static final int tcodeStartSection = 1;
    public static final int tcodeCommentBlock = 1;
    public static final int tcodeEndOfFile = Short.MAX_VALUE;
    public static final int tcodeEndOfFileGoo = 32766;
    public static final int tcodeLegacyGeometry = 65536;
    public static final int tcodeOpenNurbsObject = 131072;
    public static final int tcodeGeometry = 0x100000;
    public static final int tcodeAnnotation = 0x200000;
    public static final int tcodeDisplay = 0x400000;
    public static final int tcodeRender = 0x800000;
    public static final int tcodeInterface = 0x2000000;
    public static final int tcodeTolerance = 0x8000000;
    public static final int tcodeTable = 0x10000000;
    public static final int tcodeTableRec = 0x20000000;
    public static final int tcodeUser = 0x40000000;
    public static final int tcodeShort = Integer.MIN_VALUE;
    public static final int tcodeCRC = 32768;
    public static final int tcodeAnonymousChunk = 0x40008000;
    public static final int tcodeMaterialTable = 0x10000010;
    public static final int tcodeLayerTable = 0x10000011;
    public static final int tcodeLightTable = 0x10000012;
    public static final int tcodeObjectTable = 0x10000013;
    public static final int tcodePropertiesTable = 0x10000014;
    public static final int tcodeSettingsTable = 0x10000015;
    public static final int tcodeBitmapTable = 0x10000016;
    public static final int tcodeUserTable = 0x10000017;
    public static final int tcodeGroupTable = 0x10000018;
    public static final int tcodeFontTable = 0x10000019;
    public static final int tcodeDimStyleTable = 0x10000020;
    public static final int tcodeInstanceDefinitionTable = 0x10000021;
    public static final int tcodeHatchPatternTable = 0x10000022;
    public static final int tcodeLinetypeTable = 268435491;
    public static final int tcodeObsoleteLayerSetTable = 268435492;
    public static final int tcodeTextureMappingTable = 268435493;
    public static final int tcodeHistoryRecordTable = 268435494;
    public static final int tcodeEndOfTable = -1;
    public static final int tcodePropertiesRevisionHistory = 536903713;
    public static final int tcodePropertiesNotes = 0x20008022;
    public static final int tcodePropertiesPreviewImage = 536903715;
    public static final int tcodePropertiesApplication = 536903716;
    public static final int tcodePropertiesCompressedPreviewImage = 536903717;
    public static final int tcodePropertiesOpenNurbsVersion = -1610612698;
    public static final int tcodeSettingsPluginList = 536903989;
    public static final int tcodeSettingsUnitStandTols = 536903729;
    public static final int tcodeSettingsRenderMesh = 536903730;
    public static final int tcodeSettingsAnalysisMesh = 536903731;
    public static final int tcodeSettingsAnnotation = 536903732;
    public static final int tcodeSettingsNamedCPlaneList = 536903733;
    public static final int tcodeSettingsNamedViewList = 536903734;
    public static final int tcodeSettingsViewList = 536903735;
    public static final int tcodeSettingsCurrentLayerIndex = -1610612680;
    public static final int tcodeSettingsCurrentMaterialIndex = 536903737;
    public static final int tcodeSettingsCurrentColor = 536903738;
    public static final int tcodeSettings_Never_Use_This = 536903742;
    public static final int tcodeSettingsCurrentWireDensity = -1610612676;
    public static final int tcodeSettingsRender = 536903741;
    public static final int tcodeSettingsGridDefaults = 536903743;
    public static final int tcodeSettingsModelURL = 536903985;
    public static final int tcodeSettingsCurrentFontIndex = -1610612430;
    public static final int tcodeSettingsCurrentDimStyleIndex = -1610612429;
    public static final int tcodeSettingsAttributes = 536903988;
    public static final int tcodeViewRecord = 536903739;
    public static final int tcodeViewCPlane = 536903995;
    public static final int tcodeViewViewport = 536904251;
    public static final int tcodeViewShowConGrid = -1610611909;
    public static final int tcodeViewShowConAxes = -1610611653;
    public static final int tcodeViewShowWorldAxes = -1610611397;
    public static final int tcodeViewTraceImage = 536905275;
    public static final int tcodeViewWallPaper = 536905531;
    public static final int tcodeViewWallPaperV3 = 536905547;
    public static final int tcodeViewTarget = 536905787;
    public static final int tcodeViewDisplayMode = -1610610373;
    public static final int tcodeViewName = 536906299;
    public static final int tcodeViewPosition = 536906555;
    public static final int tcodeViewAttributes = 536906811;
    public static final int tcodeViewViewportUserData = 536907067;
    public static final int tcodeBitmapRecord = 536903824;
    public static final int tcodeMaterialRecord = 536903744;
    public static final int tcodeLayerRecord = 536903760;
    public static final int tcodeLightRecord = 536903776;
    public static final int tcodeLightRecordAttributes = 33587297;
    public static final int tcodeLightRecordAttributesUserData = 0x2000062;
    public static final int tcodeLightRecordEnd = -2113929105;
    public static final int tcodeUserTableUUID = 0x20008080;
    public static final int tcodeUserTableRecordHeader = 0x20008082;
    public static final int tcodeUserRecord = 536871041;
    public static final int tcodeGroupRecord = 536903795;
    public static final int tcodeFontRecord = 536903796;
    public static final int tcodeDimStyleRecord = 536903797;
    public static final int tcodeInstanceDefinitionRecord = 536903798;
    public static final int tcodeHatchPatternRecord = 536903799;
    public static final int tcodeLineTypeRecord = 536903800;
    public static final int tcodeObsoleteLayerSetRecord = 536903801;
    public static final int tcodeTextureMappingRecord = 536903802;
    public static final int tcodeHistoryRecordRecord = 536903803;
    public static final int tcodeObjectRecord = 536903792;
    public static final int tcodeObjectRecordType = -2113929103;
    public static final int tcodeObjectRecordAttributes = 33587314;
    public static final int tcodeObjectRecordAttributesUserData = 33554547;
    public static final int tcodeObjectRecordHistory = 33587316;
    public static final int tcodeObjectRecordHistoryHeader = 33587317;
    public static final int tcodeObjectRecordHistoryData = 33587318;
    public static final int tcodeObjectRecordEnd = -2113929089;
    public static final int tcodeOpenNurbsClass = 163834;
    public static final int tcodeOpenNurbsClassUUID = 196603;
    public static final int tcodeOpenNurbsClassData = 196604;
    public static final int tcodeOpenNurbsClassUserData = 163837;
    public static final int tcodeOpenNurbsClassUserDataHeader = 196601;
    public static final int tcodeOpenNurbsClassEnd = -2147319809;
    public static final int tcodeAnnotationSettings = 0x200001;
    public static final int tcodeTextBlock = 0x200004;
    public static final int tcodeAnnotationLeader = 0x200005;
    public static final int tcodeLinearDimension = 0x200006;
    public static final int tcodeAngularDimension = 0x200007;
    public static final int tcodeRadialDimension = 0x200008;
    public static final int tcodeRhinoIOObjectNurbsCurve = 131080;
    public static final int tcodeRhinoIOObjectNurbsSurface = 131081;
    public static final int tcodeRhinoIOObjectBrep = 131083;
    public static final int tcodeRhinoIOObjectData = 196606;
    public static final int tcodeRhinoIOObjectEnd = 196607;
    public static final int tcodeLegacyASM = 65537;
    public static final int tcodeLegacyPRT = 65538;
    public static final int tcodeLegacySHL = 65539;
    public static final int tcodeLegacyFAC = 65540;
    public static final int tcodeLegacyBND = 65541;
    public static final int tcodeLegacyTRM = 65542;
    public static final int tcodeLegacySRF = 65543;
    public static final int tcodeLegacyCRV = 65544;
    public static final int tcodeLegacySPL = 65545;
    public static final int tcodeLegacyPNT = 65546;
    public static final int tcodeStuff = 256;
    public static final int tcodeLegacyASMStuff = 65793;
    public static final int tcodeLegacyPRTStuff = 65794;
    public static final int tcodeLegacySHLStuff = 65795;
    public static final int tcodeLegacyFACStuff = 65796;
    public static final int tcodeLegacyBNDStuff = 65797;
    public static final int tcodeLegacyTRMStuff = 65798;
    public static final int tcodeLegacySRFStuff = 65799;
    public static final int tcodeLegacyCRVStuff = 65800;
    public static final int tcodeLegacySPLStuff = 65801;
    public static final int tcodeLegacyPNTStuff = 65802;
    public static final int tcodeRhPoint = 0x100001;
    public static final int tcodeRhSpotLight = 0x800001;
    public static final int tcodeOldRhTrimesh = 0x100011;
    public static final int tcodeOldMeshVertexNormals = 0x100012;
    public static final int tcodeOldMeshUV = 0x100013;
    public static final int tcodeOldFullMesh = 0x100014;
    public static final int tcodeMeshObject = 0x100015;
    public static final int tcodeCompressedMeshGeometry = 0x100017;
    public static final int tcodeAnalysisMesh = 0x100018;
    public static final int tcodeName = 0x2000001;
    public static final int tcodeView = 0x2000002;
    public static final int tcodeCPlane = 0x2000003;
    public static final int tcodeNamedCPlane = 0x2000004;
    public static final int tcodeNamedView = 0x2000005;
    public static final int tcodeViewport = 0x2000006;
    public static final int tcodeShowGrid = -2113929209;
    public static final int tcodeShowGridAxes = -2113929208;
    public static final int tcodeShowWorldAxes = -2113929207;
    public static final int tcodeViewportPosition = 0x200000A;
    public static final int tcodeViewportTraceInfo = 0x200000B;
    public static final int tcodeSnapSide = 0x200000C;
    public static final int tcodeNearClipPlane = 0x200000D;
    public static final int tcodeHideTrace = 0x200000E;
    public static final int tcodeNotes = 0x200000F;
    public static final int tcodeUnitAndTolerances = 0x2000010;
    public static final int tcodeMaximizedViewport = -2113929199;
    public static final int tcodeViewportWallPaper = 0x2000012;
    public static final int tcodeSummary = 33554451;
    public static final int tcodeBitmapPreview = 33554452;
    public static final int tcodeViewportDisplayMode = -2113929195;
    public static final int tcodeLayerRef = -1610612735;
    public static final int tcodeXData = 0x40000001;
    public static final int tcodeRGB = -2143289343;
    public static final int tcodeTextureMap = 0x400002;
    public static final int tcodeBumpMap = 0x400003;
    public static final int tcodeTransparency = -2143289340;
    public static final int tcodeDispAmResolution = -2143289339;
    public static final int tcodeRGBDisplay = -2143289338;
    public static final int tcodeRenderMaterialID = 0x400007;
    public static final int tcodeLayer = 0x400010;
    public static final int tcodeLayerObselete1 = -2143289325;
    public static final int tcodeLayerObselete2 = -2143289324;
    public static final int tcodeLayerObselete3 = -2143289323;
    public static final int tcodeLayerOn = -2143289322;
    public static final int tcodeLayerThawed = -2143289321;
    public static final int tcodeLayerLocked = -2143289320;
    public static final int tcodeLayerVisible = -2143289326;
    public static final int tcodeLayerPickable = -2143289296;
    public static final int tcodeLayerSnapable = -2143289295;
    public static final int tcodeLayerRenderable = -2143289294;
    public static final int tcodeLayerState = -2143289293;
    public static final int tcodeLayerIndex = -2143289292;
    public static final int tcodeLayerMaterialIndex = -2143289291;
    public static final int tcodeRenderMeshParams = 0x400020;
    public static final int tcodeDispCPLines = -2143289310;
    public static final int tcodeDispMaxLength = 4194339;
    public static final int tcodeCurrentLayer = -2143289307;
    public static final int tcodeLayerName = 0x400011;
    public static final int tcodeLegacyTolFit = 0x8000001;
    public static final int tcodeLegacyTolAngle = 0x8000002;
    public static final int tcodeDictionary = 1073774608;
    public static final int tcodeDictionaryID = 1073774609;
    public static final int tcodeDictionaryEntry = 1073774610;
    public static final int tcodeDictionaryEnd = -1073741805;
    public static final short activeSpaceNoSpace = 0;
    public static final short activeSpaceModelSpace = 1;
    public static final short activeSpacePageSpace = 2;
    public static final int objectModeNormalObject = 0;
    public static final int objectModeHiddenObject = 1;
    public static final int objectModeLockedObject = 2;
    public static final int objectModeIdefObject = 3;
    public static final int objectModeCount = 4;
    public static final int colorSourceFromLayer = 0;
    public static final int colorSourceFromObject = 1;
    public static final int colorSourceFromMaterial = 2;
    public static final int colorSourceFromParent = 3;
    public static final int plotColorSourceFromLayer = 0;
    public static final int plotColorSourceFromObject = 1;
    public static final int plotColorSourceFromMaterial = 2;
    public static final int plotColorSourceFromParent = 3;
    public static final int plotWeightSourceFromLayer = 0;
    public static final int plotWeightSourceFromObject = 1;
    public static final int plotWeightSourceFromParent = 3;
    public static final int linetypeSourceFromLayer = 0;
    public static final int linetypeSourceFromObject = 1;
    public static final int linetypeSourceFromParent = 3;
    public static final int materialSourceFromLayer = 0;
    public static final int materialSourceFromObject = 1;
    public static final int materialSourceFromParent = 3;
    public static final short objectDecorationNoDecolation = 0;
    public static final short objectDecorationStartArrowHead = 8;
    public static final short objectDecorationEndArrowHead = 16;
    public static final short objectDecorationBothArrowHead = 24;

    public static Endian endian(int n) {
        return n <= 0 ? Endian.LittleEndian : Endian.BigEndian;
    }

    public static Endian endian() {
        int n = 1;
        if ((n >>> 24 & 0xFF) == 1) {
            return Endian.LittleEndian;
        }
        return Endian.BigEndian;
    }

    static int btoi(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= (byArray[n] & 0xFF) << 8 * i;
        }
        return n;
    }

    public static byte[] stob(short s) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(s & 0xFF);
            s = (short)(s >>> 8);
        }
        return byArray;
    }

    public static byte[] itob(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        return byArray;
    }

    public static byte[] ltob(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return byArray;
    }

    public static String hex(int n) {
        String string = new String();
        for (int i = 0; i < 4; ++i) {
            string = string + IRhino3dm.hex((byte)(n >> (3 - i) * 8 & 0xFF));
        }
        return string;
    }

    public static String hex(short s) {
        String string = new String();
        for (int i = 0; i < 2; ++i) {
            string = string + IRhino3dm.hex((byte)(s >> (1 - i) * 8 & 0xFF));
        }
        return string;
    }

    public static String hex(byte by) {
        String string = new String();
        for (int i = 1; i >= 0; --i) {
            int n = by >> i * 4 & 0xF;
            string = n < 10 ? string + String.valueOf((char)(48 + n)) : string + String.valueOf((char)(65 + n - 10));
        }
        return string;
    }

    public static String hex(char c) {
        String string = new String();
        for (int i = 1; i >= 0; --i) {
            int n = c >> i * 4 & 0xF;
            string = n < 10 ? string + String.valueOf((char)(48 + n)) : string + String.valueOf((char)(65 + n - 10));
        }
        return string;
    }

    public static String hex(byte[] byArray) {
        String string = new String();
        for (int i = 0; i < byArray.length; ++i) {
            string = string + IRhino3dm.hex(byArray[i]);
        }
        return string;
    }

    public static String hex(char[] cArray) {
        String string = new String();
        for (int i = 0; i < cArray.length; ++i) {
            string = string + IRhino3dm.hex(cArray[i]);
        }
        return string;
    }

    public static String asciiOrHex(byte[] byArray) {
        String string = new String();
        for (int i = 0; i < byArray.length; ++i) {
            string = byArray[i] > 32 && byArray[i] < 127 || byArray[i] == 9 || byArray[i] == 10 || byArray[i] == 13 ? string + String.valueOf(byArray[i]) : string + IRhino3dm.hex(byArray[i]);
        }
        return string;
    }

    public static void printHex(byte[] byArray, PrintStream printStream) {
        for (int i = 0; i < byArray.length; ++i) {
            printStream.print(IRhino3dm.hex(byArray[i]));
        }
    }

    public static void printAsciiOrHex(byte[] byArray, PrintStream printStream) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 32 && byArray[i] < 127 || byArray[i] == 9 || byArray[i] == 10 || byArray[i] == 13) {
                printStream.print((char)byArray[i]);
                continue;
            }
            printStream.print(IRhino3dm.hex(byArray[i]));
        }
    }

    public static byte[] hexStringToByte(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = IRhino3dm.hexCharToByte(string.charAt(i * 2), string.charAt(i * 2 + 1));
        }
        return byArray;
    }

    public static byte hexCharToByte(char c) {
        byte by = 0;
        if (c >= '0' && c <= '9') {
            by = (byte)(c - 48);
        } else if (c >= 'A' && c <= 'F') {
            by = (byte)(c - 65 + 10);
        } else if (c >= 'a' && c <= 'f') {
            by = (byte)(c - 97 + 10);
        }
        return by;
    }

    public static byte hexCharToByte(char c, char c2) {
        byte by = IRhino3dm.hexCharToByte(c2);
        byte by2 = IRhino3dm.hexCharToByte(c);
        by = (byte)(by | by2 << 4 & 0xF0);
        return by;
    }

    public static class Viewport
    extends Geometry {
        public static final String uuid = "D66E5CCF-EA39-11d3-BFE5-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class UserStringList
    extends UserData {
        public static final String uuid = "CE28DE29-F4C5-4faa-A50A-C3A6849B6329";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class UnknownUserData
    extends UserData {
        public static final String uuid = "850324A8-050E-11d4-BFFA-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class SurfaceProxy
    extends Surface {
        public static final String uuid = "4ED7D4E2-E947-11d3-BFE5-0010830122F0";
        public Surface surface;
        public boolean transposed;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public void setProxySurface(Surface surface) {
            if (surface == this) {
                surface = null;
            }
            this.surface = surface;
            this.transposed = false;
        }
    }

    public static class SumSurface
    extends Surface {
        public static final String uuid = "C4CD5359-446D-4690-9FF5-29059732472B";
        public Curve[] curve;
        public IVec basepoint;
        public BoundingBox bbox;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                this.basepoint = IRhino3dmImporter.readPoint3(inputStream);
                this.bbox = IRhino3dmImporter.readBoundingBox(inputStream);
                this.curve = new Curve[2];
                RhinoObject rhinoObject = IRhino3dmImporter.readObject(rhino3dmFile, inputStream);
                if (rhinoObject != null) {
                    if (rhinoObject instanceof Curve) {
                        this.curve[0] = (Curve)rhinoObject;
                    } else {
                        IOut.err("wrong instance of class : " + rhinoObject);
                    }
                }
                if ((rhinoObject = IRhino3dmImporter.readObject(rhino3dmFile, inputStream)) != null) {
                    if (rhinoObject instanceof Curve) {
                        this.curve[1] = (Curve)rhinoObject;
                    } else {
                        IOut.err("wrong instance of class : " + rhinoObject);
                    }
                }
            }
        }

        public ISurface createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            ISurfaceGeo iSurfaceGeo = this.createIGGeometry(rhino3dmFile, iServerI);
            return new ISurface(iServerI, iSurfaceGeo);
        }

        public ISurfaceGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.curve[0] == null || this.curve[1] == null || this.basepoint == null) {
                return null;
            }
            ICurveGeo iCurveGeo = this.curve[0].createIGGeometry(rhino3dmFile, iServerI);
            ICurveGeo iCurveGeo2 = this.curve[1].createIGGeometry(rhino3dmFile, iServerI);
            int n = iCurveGeo.deg();
            int n2 = iCurveGeo2.deg();
            double[] dArray = iCurveGeo.knots;
            double[] dArray2 = iCurveGeo2.knots;
            int n3 = iCurveGeo.num();
            int n4 = iCurveGeo2.num();
            Interval interval = this.curve[0].domain();
            Interval interval2 = this.curve[1].domain();
            IVecI[][] iVecIArray = new IVecI[n3][n4];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    iVecIArray[i][j] = this.basepoint.dup().add(iCurveGeo.cp(i)).add(iCurveGeo2.cp(j));
                }
            }
            ISurfaceGeo iSurfaceGeo = new ISurfaceGeo(iVecIArray, n, n2, dArray, dArray2);
            iSurfaceGeo.ustart = interval.v1;
            iSurfaceGeo.uend = interval.v2;
            iSurfaceGeo.vstart = interval2.v1;
            iSurfaceGeo.vend = interval2.v2;
            return iSurfaceGeo;
        }
    }

    public static class RevSurface
    extends Surface {
        public static final String uuid = "A16220D3-163B-11d4-8000-0010830122F0";
        public Curve curve;
        public Line axis;
        public Interval angle;
        public Interval t;
        public boolean transposed = false;
        public BoundingBox bbox;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                RhinoObject rhinoObject;
                this.axis = IRhino3dmImporter.readLine(inputStream);
                this.angle = IRhino3dmImporter.readInterval(inputStream);
                this.bbox = IRhino3dmImporter.readBoundingBox(inputStream);
                this.transposed = IRhino3dmImporter.readInt(inputStream) != 0;
                byte by = IRhino3dmImporter.readByte(inputStream);
                if (by != 0 && (rhinoObject = IRhino3dmImporter.readObject(rhino3dmFile, inputStream)) != null) {
                    if (rhinoObject instanceof Curve) {
                        this.curve = (Curve)rhinoObject;
                    } else {
                        IOut.err("wrong instance of class : " + rhinoObject);
                    }
                }
                this.t = new Interval(this.angle.min(), this.angle.max());
            } else if (n == 2) {
                RhinoObject rhinoObject;
                this.axis = IRhino3dmImporter.readLine(inputStream);
                this.angle = IRhino3dmImporter.readInterval(inputStream);
                this.t = IRhino3dmImporter.readInterval(inputStream);
                this.bbox = IRhino3dmImporter.readBoundingBox(inputStream);
                this.transposed = IRhino3dmImporter.readInt(inputStream) != 0;
                byte by = IRhino3dmImporter.readByte(inputStream);
                if (by != 0 && (rhinoObject = IRhino3dmImporter.readObject(rhino3dmFile, inputStream)) != null) {
                    if (rhinoObject instanceof Curve) {
                        this.curve = (Curve)rhinoObject;
                    } else {
                        IOut.err("wrong instance of class : " + rhinoObject);
                    }
                }
            }
        }

        public ISurface createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            ISurfaceGeo iSurfaceGeo = this.createIGGeometry(rhino3dmFile, iServerI);
            return new ISurface(iServerI, iSurfaceGeo);
        }

        public ISurfaceGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            Object object;
            double d;
            IVec iVec = this.axis.from;
            IVec iVec2 = this.axis.to.diff(this.axis.from);
            ICurveGeo iCurveGeo = this.curve.createIGGeometry(rhino3dmFile, iServerI);
            if (iCurveGeo == null) {
                IOut.err("no valid profile curve");
                return null;
            }
            IVec[] iVecArray = new IVec[iCurveGeo.cpNum()];
            for (int i = 0; i < iCurveGeo.cpNum(); ++i) {
                iVecArray[i] = iCurveGeo.cp(i).dup().projectToLine(iVec, iVec2);
            }
            IVecI[][] iVecIArray = new IVec4[iCurveGeo.cpNum()][];
            double[] dArray = new double[iCurveGeo.knotNum()];
            for (int i = 0; i < iCurveGeo.knotNum(); ++i) {
                dArray[i] = iCurveGeo.knot(i);
            }
            double[] dArray2 = null;
            int n = iCurveGeo.deg();
            int n2 = 1;
            if (Math.abs(this.angle.length()) < Math.PI * 2 - IConfig.angleResolution) {
                d = this.angle.v2 - this.angle.v1;
                dArray2 = IArcGeo.arcKnots(d);
                n2 = IArcGeo.arcDeg();
                for (int i = 0; i < iCurveGeo.cpNum(); ++i) {
                    IVec iVec3 = iCurveGeo.cp(i).dup();
                    iVec3.rot(iVecArray[i], iVec2, this.angle.v1);
                    iVecIArray[i] = IArcGeo.arcCP(iVecArray[i], iVec2, iVec3, d);
                }
            } else {
                dArray2 = ICircleGeo.circleKnots();
                n2 = ICircleGeo.circleDeg();
                for (int i = 0; i < iCurveGeo.cpNum(); ++i) {
                    IVec iVec4 = iCurveGeo.cp(i).get().diff(iVecArray[i]);
                    iVecIArray[i] = ICircleGeo.circleCP(iVecArray[i], iVec2, iVec4, iVec4.len());
                }
            }
            d = iCurveGeo.ustart();
            double d2 = iCurveGeo.uend();
            double d3 = this.t.v1;
            double d4 = this.t.v2;
            if (!this.transposed) {
                object = dArray;
                dArray = dArray2;
                dArray2 = object;
                double d5 = d;
                d = d3;
                d3 = d5;
                d5 = d2;
                d2 = d4;
                d4 = d5;
                int n3 = n;
                n = n2;
                n2 = n3;
                IVec4[][] iVec4Array = new IVec4[iVecIArray[0].length][iVecIArray.length];
                for (int i = 0; i < iVecIArray.length; ++i) {
                    for (int j = 0; j < iVecIArray[i].length; ++j) {
                        iVec4Array[j][i] = iVecIArray[i][j];
                    }
                }
                iVecIArray = iVec4Array;
            }
            object = new ISurfaceGeo(iVecIArray, n, n2, dArray, dArray2);
            object.ustart = d;
            object.uend = d2;
            object.vstart = d3;
            object.vend = d4;
            return object;
        }
    }

    public static class PolylineCurve
    extends Curve {
        public static final String uuid = "4ED7D4E6-E947-11d3-BFE5-0010830122F0";
        public Polyline pline;
        public ArrayList<Double> t;
        public int dim;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public boolean isValid() {
            return this.pline.isValid();
        }

        public Interval domain() {
            int n = this.pline.size();
            if (n >= 2 && this.t.get(0) < this.t.get(n - 1)) {
                return new Interval(this.t.get(0), this.t.get(n - 1));
            }
            return null;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                this.pline = IRhino3dmImporter.readPolyline(inputStream);
                this.t = IRhino3dmImporter.readArrayDouble(inputStream);
                this.dim = IRhino3dmImporter.readInt(inputStream);
            }
        }

        public ICurve createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            ICurve iCurve = new ICurve(iServerI, this.pline.toArray(new IVec[this.pline.size()]));
            return iCurve;
        }

        public ICurveGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return new ICurveGeo(this.pline.toArray(new IVec[this.pline.size()]));
        }

        public ITrimCurve createTrimCurve(Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            return new ITrimCurve(this.pline.toArray(new IVec[this.pline.size()]));
        }
    }

    public static class Polyline
    extends PointArray {
        public boolean isValid() {
            return true;
        }

        public Polyline() {
        }

        public Polyline(int n) {
            super(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PointArray
    extends ArrayList<IVec> {
        public PointArray() {
        }

        public PointArray(int n) {
            super(n);
        }
    }

    public static class PolyEdgeCurve
    extends PolyCurve {
        public static final String uuid = "39FF3DD3-FE0F-4807-9D59-185F0D73C0E4";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class PolyEdgeSegment
    extends CurveProxy {
        public static final String uuid = "42F47A87-5B1B-4e31-AB87-4639D78325D6";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PolyCurve
    extends Curve {
        public static final String uuid = "4ED7D4E0-E947-11d3-BFE5-0010830122F0";
        public static final double sqrtEpsilon = 1.490116119385E-8;
        public CurveArray segment;
        public ArrayList<Double> t;

        @Override
        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        @Override
        public Interval domain() {
            int n = this.segment.size();
            if (n > 0 && this.t.get(0) < this.t.get(n)) {
                return new Interval(this.t.get(0), this.t.get(n));
            }
            return null;
        }

        public Interval segmentDomain(int n) {
            Interval interval = new Interval();
            if (n >= 0 && n < this.count()) {
                interval.v1 = this.t.get(n);
                interval.v2 = this.t.get(n + 1);
            }
            return interval;
        }

        @Override
        public boolean isValid() {
            return this.isValid(false);
        }

        public boolean isValid(boolean bl) {
            for (int i = 0; i < this.segment.size(); ++i) {
                if (((Curve)this.segment.get(i)).isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Object object;
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = IRhino3dmImporter.readInt(inputStream);
            int n4 = IRhino3dmImporter.readInt(inputStream);
            int n5 = IRhino3dmImporter.readInt(inputStream);
            BoundingBox boundingBox = IRhino3dmImporter.readBoundingBox(inputStream);
            this.t = IRhino3dmImporter.readArrayDouble(inputStream);
            this.segment = new CurveArray(n3);
            for (int i = 0; i < n3; ++i) {
                object = IRhino3dmImporter.readObject(rhino3dmFile, inputStream);
                if (object == null) continue;
                if (object instanceof Curve) {
                    Curve curve = (Curve)object;
                    this.segment.add(curve);
                    continue;
                }
                throw new IOException("invalid class of instance: " + object);
            }
            if (this.segment.size() == 0) {
                throw new IOException("number of segemnts is zero");
            }
            if (this.segment.size() != n3) {
                throw new IOException("number of segemnts doesn't match with count");
            }
            if (this.t.size() != n3 + 1) {
                throw new IOException("number of domain doesn't match with number of segment");
            }
            Object object2 = null;
            object = ((Curve)this.segment.get(0)).domain();
            double d = 0.0;
            double d2 = ((Interval)object).length();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 1; i < n3; ++i) {
                d4 = this.t.get(i);
                object2 = object;
                d = d2;
                object = ((Curve)this.segment.get(i)).domain();
                if (object == null) {
                    // empty if block
                }
                d2 = ((Interval)object).length();
                d5 = ((Interval)object2).v2;
                if (d5 == d4 || d5 != ((Interval)object).v1 || !(d4 > ((Interval)object2).v1) || !(d4 < ((Interval)object).v2)) continue;
                d3 = (d <= d2 ? d : d2) * 1.490116119385E-8;
                if (!(Math.abs(d4 - d5) <= d3)) continue;
                this.t.set(i, d5);
            }
            d3 = d2 * 1.490116119385E-8;
            d5 = ((Interval)object).v2;
            d4 = this.t.get(n3);
            if (d5 != d4 && d4 > ((Interval)object).v1 && Math.abs(d5 - d4) <= d3) {
                this.t.set(n3, d5);
            }
            if (rhino3dmFile.openNurbsVersion < 200304080) {
                this.removeNesting();
            }
        }

        public int count() {
            if (this.segment == null) {
                return 0;
            }
            return this.segment.size();
        }

        public Curve segmentCurve(int n) {
            return (Curve)this.segment.get(n);
        }

        public void removeNesting() {
            int n = this.count();
            ArrayList<Double> arrayList = this.t;
            CurveArray curveArray = this.segment;
            this.t = new ArrayList();
            this.t.add(arrayList.get(0));
            this.segment = new CurveArray();
            for (int i = 0; i < n; ++i) {
                if (curveArray.get(i) instanceof PolyCurve) {
                    PolyCurve polyCurve = (PolyCurve)curveArray.get(i);
                    this.flatten(polyCurve, new Interval(arrayList.get(i), arrayList.get(i + 1)), this.t, this.segment);
                    continue;
                }
                this.t.add(arrayList.get(i + 1));
                this.segment.add(curveArray.get(i));
            }
        }

        public void flatten(PolyCurve polyCurve, Interval interval, ArrayList<Double> arrayList, CurveArray curveArray) {
            int n = polyCurve.count();
            double d = interval.v1;
            Interval interval2 = polyCurve.domain();
            for (int i = 0; i < n; ++i) {
                double d2 = polyCurve.segmentDomain((int)i).v1;
                double d3 = interval2.normalizedParameterAt(d2);
                double d4 = interval.parameterAt(d3);
                Curve curve = polyCurve.segmentCurve(i);
                if (curve instanceof PolyCurve) {
                    this.flatten((PolyCurve)curve, new Interval(d, d4), arrayList, curveArray);
                    polyCurve.harvestSegment(i);
                } else {
                    arrayList.add(d4);
                    curveArray.add(curve);
                    polyCurve.harvestSegment(i);
                }
                d = d4;
            }
        }

        public Curve harvestSegment(int n) {
            Curve curve = null;
            if (n >= 0 && n < this.segment.size()) {
                curve = (Curve)this.segment.get(n);
                this.segment.set(n, null);
            }
            return curve;
        }

        @Override
        public IObject createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
            for (int i = 0; i < this.segment.size(); ++i) {
                IObject iObject = ((Curve)this.segment.get(i)).createIObject(rhino3dmFile, iServerI);
                if (!(iObject instanceof ICurve)) continue;
                arrayList.add((ICurve)iObject);
            }
            return new IPolycurve(arrayList);
        }

        @Override
        public ITrimCurve createTrimCurve(Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            return null;
        }
    }

    public static class PointGrid
    extends Geometry {
        public static final String uuid = "4ED7D4E5-E947-11d3-BFE5-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 2;
        }
    }

    public static class Point
    extends Geometry {
        public static final String uuid = "C3101A1D-F157-11d3-BFE7-0010830122F0";
        public IVec point;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 1;
        }

        public Point() {
        }

        public Point(IVec iVec) {
            this.point = iVec;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            if (nArray[0] != 1) {
                throw new IOException("invalid major version : " + String.valueOf(nArray[0]));
            }
            this.point = new IVec();
            this.point.x = IRhino3dmImporter.readDouble(inputStream);
            this.point.y = IRhino3dmImporter.readDouble(inputStream);
            this.point.z = IRhino3dmImporter.readDouble(inputStream);
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeChunkVersion(outputStream, 1, 0, cRC32);
            if (this.point == null) {
                IOut.err("point is null");
                this.point = new IVec();
            }
            IRhino3dmExporter.writeDouble(outputStream, this.point.x, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.point.y, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.point.z, cRC32);
        }

        public IPoint createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            IPoint iPoint = new IPoint(iServerI, this.point);
            return iPoint;
        }

        public IVec createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return this.point.dup();
        }
    }

    public static class PointCloud
    extends Geometry {
        public static final String uuid = "2488F347-F8FA-11d3-BFEC-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 2;
        }
    }

    public static class ClippingPlaneSurface
    extends PlaneSurface {
        public static final String uuid = "DBC5A584-CE3F-4170-98A8-497069CA5C36";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0x20000000;
        }
    }

    public static class PlaneSurface
    extends Surface {
        public static final String uuid = "4ED7D4DF-E947-11d3-BFE5-0010830122F0";
        public Plane plane;
        public Interval[] domain;
        public Interval[] extents;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                this.plane = IRhino3dmImporter.readPlane(inputStream);
                this.domain = new Interval[2];
                this.domain[0] = IRhino3dmImporter.readInterval(inputStream);
                this.domain[1] = IRhino3dmImporter.readInterval(inputStream);
                this.extents = new Interval[2];
                this.extents[0] = this.domain[0];
                this.extents[1] = this.domain[1];
                if (n2 >= 1) {
                    this.extents[0] = IRhino3dmImporter.readInterval(inputStream);
                    this.extents[1] = IRhino3dmImporter.readInterval(inputStream);
                }
            }
        }

        public ISurface createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.plane == null) {
                IOut.err("plane is null");
                return null;
            }
            if (this.extents == null) {
                IOut.err("extent is null");
                return null;
            }
            IVec iVec = this.plane.origin;
            IVecI[][] iVecIArray = new IVec[2][2];
            iVecIArray[0][0] = iVec.dup().add(this.plane.xaxis, this.extents[0].v1).add(this.plane.yaxis, this.extents[1].v1);
            iVecIArray[1][0] = iVec.dup().add(this.plane.xaxis, this.extents[0].v2).add(this.plane.yaxis, this.extents[1].v1);
            iVecIArray[0][1] = iVec.dup().add(this.plane.xaxis, this.extents[0].v1).add(this.plane.yaxis, this.extents[1].v2);
            iVecIArray[1][1] = iVec.dup().add(this.plane.xaxis, this.extents[0].v2).add(this.plane.yaxis, this.extents[1].v2);
            double[] dArray = new double[]{this.domain[0].v1, this.domain[0].v1, this.domain[0].v2, this.domain[0].v2};
            double[] dArray2 = new double[]{this.domain[1].v1, this.domain[1].v1, this.domain[1].v2, this.domain[1].v2};
            return new ISurface(iServerI, iVecIArray, 1, 1, dArray, dArray2, this.domain[0].v1, this.domain[0].v2, this.domain[1].v1, this.domain[1].v2);
        }

        public ISurfaceGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.plane == null) {
                IOut.err("plane is null");
                return null;
            }
            if (this.extents == null) {
                IOut.err("extent is null");
                return null;
            }
            IVec iVec = this.plane.origin;
            IVecI[][] iVecIArray = new IVec[2][2];
            iVecIArray[0][0] = iVec.dup().add(this.plane.xaxis, this.extents[0].v1).add(this.plane.yaxis, this.extents[1].v1);
            iVecIArray[1][0] = iVec.dup().add(this.plane.xaxis, this.extents[0].v2).add(this.plane.yaxis, this.extents[1].v1);
            iVecIArray[0][1] = iVec.dup().add(this.plane.xaxis, this.extents[0].v1).add(this.plane.yaxis, this.extents[1].v2);
            iVecIArray[1][1] = iVec.dup().add(this.plane.xaxis, this.extents[0].v2).add(this.plane.yaxis, this.extents[1].v2);
            double[] dArray = new double[]{this.domain[0].v1, this.domain[0].v1, this.domain[0].v2, this.domain[0].v2};
            double[] dArray2 = new double[]{this.domain[1].v1, this.domain[1].v1, this.domain[1].v2, this.domain[1].v2};
            return new ISurfaceGeo(iVecIArray, 1, 1, dArray, dArray2, this.domain[0].v1, this.domain[0].v2, this.domain[1].v1, this.domain[1].v2);
        }

        public Interval domain(int n) {
            return n != 0 ? this.domain[1] : this.domain[0];
        }

        public boolean isValid() {
            return this.plane.isValid() && this.domain[0].isIncreasing() && this.domain[1].isIncreasing() && this.extents[0].isIncreasing() && this.extents[1].isIncreasing();
        }
    }

    public static class OffsetSurface
    extends SurfaceProxy {
        public static final String uuid = "00C61749-D430-4ecc-83A8-29130A20CF9C";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class MorphControl
    extends Geometry {
        public static final String uuid = "D379E6D8-7C31-4407-A913-E3B7040D034A";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 131072;
        }
    }

    public static class NurbsCage
    extends Geometry {
        public static final String uuid = "06936AFB-3D3C-41ac-BF70-C9319FA480A1";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0x8000000;
        }
    }

    public static class NurbsSurface
    extends Surface {
        public static final String uuid = "4ED7D4DE-E947-11d3-BFE5-0010830122F0";
        public int dim;
        public int isRat;
        public int[] order;
        public int[] cvCount;
        public int[] knotCapacity;
        public double[][] knot;
        public IVec[][] cv;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public NurbsSurface() {
        }

        public NurbsSurface(ISurfaceGeo iSurfaceGeo) {
            int n;
            this.dim = 3;
            this.isRat = iSurfaceGeo.isRational() ? 1 : 0;
            this.order = new int[2];
            this.order[0] = iSurfaceGeo.udeg() + 1;
            this.order[1] = iSurfaceGeo.vdeg() + 1;
            this.cvCount = new int[2];
            this.cvCount[0] = iSurfaceGeo.unum();
            this.cvCount[1] = iSurfaceGeo.vnum();
            this.knot = new double[2][];
            double[] dArray = new double[iSurfaceGeo.uknotNum()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = iSurfaceGeo.uknot(i);
            }
            this.knot[0] = NurbsCurve.getRhinoKnots(dArray);
            double[] dArray2 = new double[iSurfaceGeo.vknotNum()];
            for (n = 0; n < dArray2.length; ++n) {
                dArray2[n] = iSurfaceGeo.vknot(n);
            }
            this.knot[1] = NurbsCurve.getRhinoKnots(dArray2);
            this.cv = new IVec[this.cvCount[0]][this.cvCount[1]];
            for (n = 0; n < this.cvCount[0]; ++n) {
                for (int i = 0; i < this.cvCount[1]; ++i) {
                    this.cv[n][i] = iSurfaceGeo.cp(n, i);
                }
            }
        }

        public Interval domain(int n) {
            Interval interval = new Interval();
            interval.v1 = this.knot[n][this.order[n] - 2];
            interval.v2 = this.knot[n][this.cvCount[n] - 1];
            return interval;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3;
                int n4;
                this.order = new int[2];
                this.cvCount = new int[2];
                this.knotCapacity = new int[2];
                this.knot = new double[2][];
                this.dim = IRhino3dmImporter.readInt(inputStream);
                this.isRat = IRhino3dmImporter.readInt(inputStream);
                this.order[0] = IRhino3dmImporter.readInt(inputStream);
                this.order[1] = IRhino3dmImporter.readInt(inputStream);
                this.cvCount[0] = IRhino3dmImporter.readInt(inputStream);
                this.cvCount[1] = IRhino3dmImporter.readInt(inputStream);
                int n5 = IRhino3dmImporter.readInt(inputStream);
                int n6 = IRhino3dmImporter.readInt(inputStream);
                BoundingBox boundingBox = IRhino3dmImporter.readBoundingBox(inputStream);
                int n7 = IRhino3dmImporter.readInt(inputStream);
                this.knot[0] = new double[n7];
                for (n4 = 0; n4 < n7; ++n4) {
                    this.knot[0][n4] = IRhino3dmImporter.readDouble(inputStream);
                }
                n7 = IRhino3dmImporter.readInt(inputStream);
                this.knot[1] = new double[n7];
                for (n4 = 0; n4 < n7; ++n4) {
                    this.knot[1][n4] = IRhino3dmImporter.readDouble(inputStream);
                }
                n4 = IRhino3dmImporter.readInt(inputStream);
                int n8 = n3 = this.isRat != 0 ? this.dim + 1 : this.dim;
                if (n4 != this.cvCount[0] * this.cvCount[1]) {
                    IOut.err("cv count (" + this.cvCount + ") doesn't match with cvCount[0](" + this.cvCount[0] + ") * cvCount[1](" + this.cvCount[1] + ")");
                }
                this.cv = new IVec[this.cvCount[0]][this.cvCount[1]];
                for (int i = 0; i < this.cvCount[0]; ++i) {
                    for (int j = 0; j < this.cvCount[1]; ++j) {
                        double d;
                        this.cv[i][j] = this.isRat != 0 ? new IVec4() : new IVec();
                        if (this.dim >= 1) {
                            this.cv[i][j].x = IRhino3dmImporter.readDouble(inputStream);
                        }
                        if (this.dim >= 2) {
                            this.cv[i][j].y = IRhino3dmImporter.readDouble(inputStream);
                        }
                        if (this.dim >= 3) {
                            this.cv[i][j].z = IRhino3dmImporter.readDouble(inputStream);
                        }
                        if (this.dim >= 4) {
                            IOut.err(this.dim + " dimension point cannot be read");
                            for (int k = 0; k < this.dim - 3; ++k) {
                                IRhino3dmImporter.readDouble(inputStream);
                            }
                        }
                        if (this.isRat == 0) continue;
                        ((IVec4)this.cv[i][j]).w = d = IRhino3dmImporter.readDouble(inputStream);
                        this.cv[i][j].x /= d;
                        this.cv[i][j].y /= d;
                        this.cv[i][j].z /= d;
                    }
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            int n;
            int n2;
            IRhino3dmExporter.writeChunkVersion(outputStream, 1, 0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.dim, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.isRat, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.order[0], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.order[1], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.cvCount[0], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.cvCount[1], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, 0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, 0, cRC32);
            IRhino3dmExporter.writeBoundingBox(outputStream, new BoundingBox(), cRC32);
            int n3 = this.knot[0] != null ? this.knot[0].length : 0;
            IRhino3dmExporter.writeInt32(outputStream, n3, cRC32);
            for (n2 = 0; n2 < n3; ++n2) {
                IRhino3dmExporter.writeDouble(outputStream, this.knot[0][n2], cRC32);
            }
            n2 = this.knot[1] != null ? this.knot[1].length : 0;
            IRhino3dmExporter.writeInt32(outputStream, n2, cRC32);
            for (n = 0; n < n2; ++n) {
                IRhino3dmExporter.writeDouble(outputStream, this.knot[1][n], cRC32);
            }
            n = this.cv != null && this.dim == 3 && this.cvCount[0] > 0 && this.cvCount[1] > 0 ? this.cvCount[0] * this.cvCount[1] : 0;
            IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
            if (n > 0) {
                for (int i = 0; i < this.cvCount[0]; ++i) {
                    for (int j = 0; j < this.cvCount[1]; ++j) {
                        if (this.isRat == 0) {
                            IRhino3dmExporter.writeDouble(outputStream, this.cv[i][j].x, cRC32);
                            IRhino3dmExporter.writeDouble(outputStream, this.cv[i][j].y, cRC32);
                            IRhino3dmExporter.writeDouble(outputStream, this.cv[i][j].z, cRC32);
                            continue;
                        }
                        double d = 1.0;
                        if (this.cv[i][j] instanceof IVec4) {
                            d = ((IVec4)this.cv[i][j]).w;
                        }
                        IRhino3dmExporter.writeDouble(outputStream, this.cv[i][j].x * d, cRC32);
                        IRhino3dmExporter.writeDouble(outputStream, this.cv[i][j].y * d, cRC32);
                        IRhino3dmExporter.writeDouble(outputStream, this.cv[i][j].z * d, cRC32);
                        IRhino3dmExporter.writeDouble(outputStream, d, cRC32);
                    }
                }
            }
        }

        public int cvSize() {
            return this.isRat != 0 ? this.dim + 1 : this.dim;
        }

        public double[] getIGUKnots() {
            double[] dArray = new double[this.knot[0].length + 2];
            if (this.order[0] == 2) {
                dArray[0] = this.knot[0][0];
                for (int i = 0; i < this.knot[0].length; ++i) {
                    dArray[i + 1] = this.knot[0][i];
                }
                dArray[this.knot[0].length + 1] = this.knot[0][this.knot[0].length - 1];
            } else if (this.order[0] > 2 && this.knot[0].length > 2) {
                dArray[0] = this.knot[0][0] - (this.knot[0][1] - this.knot[0][0]);
                for (int i = 0; i < this.knot[0].length; ++i) {
                    dArray[i + 1] = this.knot[0][i];
                }
                dArray[this.knot[0].length + 1] = this.knot[0][this.knot[0].length - 1] + (this.knot[0][this.knot[0].length - 1] - this.knot[0][this.knot[0].length - 2]);
            } else {
                IOut.err("wrong knot length (" + this.knot[0].length + ") at order = " + this.order[0] + ", and cv count = " + this.cvCount[0]);
            }
            return dArray;
        }

        public double[] getIGVKnots() {
            double[] dArray = new double[this.knot[1].length + 2];
            if (this.order[1] == 2) {
                dArray[0] = this.knot[1][0];
                for (int i = 0; i < this.knot[1].length; ++i) {
                    dArray[i + 1] = this.knot[1][i];
                }
                dArray[this.knot[1].length + 1] = this.knot[1][this.knot[1].length - 1];
            } else if (this.order[1] > 2 && this.knot[1].length > 2) {
                dArray[0] = this.knot[1][0] - (this.knot[1][1] - this.knot[1][0]);
                for (int i = 0; i < this.knot[1].length; ++i) {
                    dArray[i + 1] = this.knot[1][i];
                }
                dArray[this.knot[1].length + 1] = this.knot[1][this.knot[1].length - 1] + (this.knot[1][this.knot[1].length - 1] - this.knot[1][this.knot[1].length - 2]);
            } else {
                IOut.err("wrong knot length (" + this.knot[1].length + ") at order = " + this.order[1] + ", and cv count = " + this.cvCount[1]);
            }
            return dArray;
        }

        public ISurface createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.order == null) {
                IOut.err("order is null");
                return null;
            }
            if (this.knot == null) {
                IOut.err("knot is null");
                return null;
            }
            if (this.cv == null) {
                IOut.err("cv is null");
                return null;
            }
            double[] dArray = this.getIGUKnots();
            double[] dArray2 = this.getIGVKnots();
            double d = 0.0;
            double d2 = 0.0;
            if (this.knot[0].length > this.order[0] - 2) {
                d = this.knot[0][this.order[0] - 2];
                d2 = this.knot[0][this.knot[0].length - 1 - (this.order[0] - 2)];
            }
            double d3 = 0.0;
            double d4 = 0.0;
            if (this.knot[1].length > this.order[1] - 2) {
                d3 = this.knot[1][this.order[1] - 2];
                d4 = this.knot[1][this.knot[1].length - 1 - (this.order[1] - 2)];
            }
            return new ISurface(iServerI, this.cv, this.order[0] - 1, this.order[1] - 1, dArray, dArray2, d, d2, d3, d4);
        }

        public ISurfaceGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.order == null) {
                IOut.err("order is null");
                return null;
            }
            if (this.knot == null) {
                IOut.err("knot is null");
                return null;
            }
            if (this.cv == null) {
                IOut.err("cv is null");
                return null;
            }
            double[] dArray = this.getIGUKnots();
            double[] dArray2 = this.getIGVKnots();
            double d = 0.0;
            double d2 = 1.0;
            if (this.knot[0].length > this.order[0] - 2) {
                d = this.knot[0][this.order[0] - 2];
                d2 = this.knot[0][this.knot[0].length - 1 - (this.order[0] - 2)];
            }
            double d3 = 0.0;
            double d4 = 0.0;
            if (this.knot[1].length > this.order[1] - 2) {
                d3 = this.knot[1][this.order[1] - 2];
                d4 = this.knot[1][this.knot[1].length - 1 - (this.order[1] - 2)];
            }
            return new ISurfaceGeo(this.cv, this.order[0] - 1, this.order[1] - 1, dArray, dArray2, d, d2, d3, d4);
        }
    }

    public static class NurbsCurve
    extends Curve {
        public static final String uuid = "4ED7D4DD-E947-11d3-BFE5-0010830122F0";
        public int dim;
        public int isRat;
        public int order;
        public int cvCount;
        public int knotCapacity;
        public double[] knot;
        public IVec[] cv;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public NurbsCurve() {
        }

        public NurbsCurve(ICurveGeo iCurveGeo) {
            int n;
            this.dim = 3;
            this.isRat = iCurveGeo.isRational() ? 1 : 0;
            this.order = iCurveGeo.deg() + 1;
            this.cvCount = iCurveGeo.num();
            double[] dArray = new double[iCurveGeo.knotNum()];
            for (n = 0; n < iCurveGeo.knotNum(); ++n) {
                dArray[n] = iCurveGeo.knot(n);
            }
            this.knot = NurbsCurve.getRhinoKnots(dArray);
            this.cv = new IVec[iCurveGeo.num()];
            for (n = 0; n < iCurveGeo.num(); ++n) {
                this.cv[n] = iCurveGeo.cp(n);
            }
            this.icurve = iCurveGeo;
        }

        public NurbsCurve(ITrimCurve iTrimCurve) {
            int n;
            this.dim = 2;
            this.isRat = iTrimCurve.isRational() ? 1 : 0;
            this.order = iTrimCurve.deg() + 1;
            this.cvCount = iTrimCurve.num();
            double[] dArray = new double[iTrimCurve.knotNum()];
            for (n = 0; n < iTrimCurve.knotNum(); ++n) {
                dArray[n] = iTrimCurve.knot(n);
            }
            this.knot = NurbsCurve.getRhinoKnots(dArray);
            this.cv = new IVec[iTrimCurve.num()];
            for (n = 0; n < iTrimCurve.num(); ++n) {
                this.cv[n] = iTrimCurve.cp(n);
            }
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3;
                this.dim = IRhino3dmImporter.readInt(inputStream);
                this.isRat = IRhino3dmImporter.readInt(inputStream);
                this.order = IRhino3dmImporter.readInt(inputStream);
                this.cvCount = IRhino3dmImporter.readInt(inputStream);
                int n4 = IRhino3dmImporter.readInt(inputStream);
                int n5 = IRhino3dmImporter.readInt(inputStream);
                BoundingBox boundingBox = IRhino3dmImporter.readBoundingBox(inputStream);
                int n6 = IRhino3dmImporter.readInt(inputStream);
                this.knot = new double[n6];
                for (n3 = 0; n3 < n6; ++n3) {
                    this.knot[n3] = IRhino3dmImporter.readDouble(inputStream);
                }
                n3 = IRhino3dmImporter.readInt(inputStream);
                int n7 = this.isRat != 0 ? this.dim + 1 : this.dim;
                this.cv = new IVec[n3];
                for (int i = 0; i < n3; ++i) {
                    this.cv[i] = this.isRat != 0 ? new IVec4() : new IVec();
                    if (this.dim >= 1) {
                        this.cv[i].x = IRhino3dmImporter.readDouble(inputStream);
                    }
                    if (this.dim >= 2) {
                        this.cv[i].y = IRhino3dmImporter.readDouble(inputStream);
                    }
                    if (this.dim >= 3) {
                        this.cv[i].z = IRhino3dmImporter.readDouble(inputStream);
                    }
                    if (this.dim >= 4) {
                        IOut.err(this.dim + " dimension point cannot be read");
                        for (int j = 0; j < this.dim - 3; ++j) {
                            IRhino3dmImporter.readDouble(inputStream);
                        }
                    }
                    if (this.isRat != 0) {
                        double d;
                        ((IVec4)this.cv[i]).w = d = IRhino3dmImporter.readDouble(inputStream);
                        this.cv[i].x /= d;
                        this.cv[i].y /= d;
                        this.cv[i].z /= d;
                    }
                    IOut.debug(100, "cv[" + i + "] = " + this.cv[i]);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            int n;
            IRhino3dmExporter.writeChunkVersion(outputStream, 1, 0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.dim, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.isRat, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.order, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.cvCount, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, 0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, 0, cRC32);
            IRhino3dmExporter.writeBoundingBox(outputStream, new BoundingBox(), cRC32);
            int n2 = this.knot == null ? 0 : this.knot.length;
            IRhino3dmExporter.writeInt32(outputStream, n2, cRC32);
            for (n = 0; n < n2; ++n) {
                IRhino3dmExporter.writeDouble(outputStream, this.knot[n], cRC32);
            }
            n = this.cv != null && (this.dim == 2 || this.dim == 3) ? this.cv.length : 0;
            IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
            for (int i = 0; i < n; ++i) {
                double d;
                if (this.dim == 2) {
                    if (this.isRat == 0) {
                        IRhino3dmExporter.writeDouble(outputStream, this.cv[i].x, cRC32);
                        IRhino3dmExporter.writeDouble(outputStream, this.cv[i].y, cRC32);
                        continue;
                    }
                    d = 1.0;
                    if (this.cv[i] instanceof IVec4) {
                        d = ((IVec4)this.cv[i]).w;
                    }
                    IRhino3dmExporter.writeDouble(outputStream, this.cv[i].x * d, cRC32);
                    IRhino3dmExporter.writeDouble(outputStream, this.cv[i].y * d, cRC32);
                    IRhino3dmExporter.writeDouble(outputStream, d, cRC32);
                    continue;
                }
                if (this.dim != 3) continue;
                if (this.isRat == 0) {
                    IRhino3dmExporter.writeDouble(outputStream, this.cv[i].x, cRC32);
                    IRhino3dmExporter.writeDouble(outputStream, this.cv[i].y, cRC32);
                    IRhino3dmExporter.writeDouble(outputStream, this.cv[i].z, cRC32);
                    continue;
                }
                d = 1.0;
                if (this.cv[i] instanceof IVec4) {
                    d = ((IVec4)this.cv[i]).w;
                }
                IRhino3dmExporter.writeDouble(outputStream, this.cv[i].x * d, cRC32);
                IRhino3dmExporter.writeDouble(outputStream, this.cv[i].y * d, cRC32);
                IRhino3dmExporter.writeDouble(outputStream, this.cv[i].z * d, cRC32);
                IRhino3dmExporter.writeDouble(outputStream, d, cRC32);
            }
        }

        public double[] getIGKnots() {
            double[] dArray = new double[this.knot.length + 2];
            if (this.order == 2) {
                dArray[0] = this.knot[0];
                for (int i = 0; i < this.knot.length; ++i) {
                    dArray[i + 1] = this.knot[i];
                }
                dArray[this.knot.length + 1] = this.knot[this.knot.length - 1];
            } else if (this.order > 2 && this.knot.length > 2) {
                dArray[0] = this.knot[0] - (this.knot[1] - this.knot[0]);
                for (int i = 0; i < this.knot.length; ++i) {
                    dArray[i + 1] = this.knot[i];
                }
                dArray[this.knot.length + 1] = this.knot[this.knot.length - 1] + (this.knot[this.knot.length - 1] - this.knot[this.knot.length - 2]);
            } else {
                IOut.err("wrong knot length (" + this.knot.length + ") at order = " + this.order + ", and cv count = " + this.cvCount);
            }
            return dArray;
        }

        public static double[] getRhinoKnots(double[] dArray) {
            if (dArray.length <= 2) {
                IOut.err("knot is too short");
            }
            double[] dArray2 = new double[dArray.length - 2];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[i + 1];
            }
            return dArray2;
        }

        public ICurve createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            double[] dArray = this.getIGKnots();
            double d = 0.0;
            double d2 = 1.0;
            if (this.knot.length <= this.order - 2) {
                IOut.err("knot is too short: knot.length=" + this.knot.length + ", order=" + this.order);
                return null;
            }
            d = this.knot[this.order - 2];
            d2 = this.knot[this.knot.length - 1 - (this.order - 2)];
            ICurve iCurve = new ICurve(iServerI, this.cv, this.order - 1, dArray, d, d2);
            return iCurve;
        }

        public ICurveGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            double[] dArray = this.getIGKnots();
            double d = 0.0;
            double d2 = 1.0;
            if (this.knot.length <= this.order - 2) {
                IOut.err("knot is too short: knot.length=" + this.knot.length + ", order=" + this.order);
                return null;
            }
            d = this.knot[this.order - 2];
            d2 = this.knot[this.knot.length - 1 - (this.order - 2)];
            return new ICurveGeo(this.cv, this.order - 1, dArray, d, d2);
        }

        public ITrimCurve createTrimCurve(Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            double[] dArray = this.getIGKnots();
            double d = 0.0;
            double d2 = 1.0;
            if (this.knot.length <= this.order - 2) {
                IOut.err("knot is too short: knot.length=" + this.knot.length + ", order=" + this.order);
                return null;
            }
            d = this.knot[this.order - 2];
            d2 = this.knot[this.knot.length - 1 - (this.order - 2)];
            return new ITrimCurve(this.cv, this.order - 1, dArray, d, d2);
        }

        public int cvSize() {
            return this.isRat != 0 ? this.dim + 1 : this.dim;
        }

        public static Interval getKnotVectorDomain(int n, int n2, double[] dArray) {
            if (n < 2 || n2 < n || dArray == null) {
                return null;
            }
            Interval interval = new Interval();
            interval.v1 = dArray[n - 2];
            interval.v2 = dArray[n2 - 1];
            return interval;
        }

        public static boolean isValidKnotVector(int n, int n2, double[] dArray) {
            int n3;
            if (n < 2 || n2 < n || dArray == null || dArray[n - 2] >= dArray[n - 1] || dArray[n2 - 2] >= dArray[n2 - 1]) {
                return false;
            }
            for (n3 = 0; n3 < dArray.length - 1; ++n3) {
                if (!(dArray[n3] > dArray[n3 + 1])) continue;
                return false;
            }
            for (n3 = 0; n3 < dArray.length - n + 1; ++n3) {
                if (!(dArray[n3] >= dArray[n3 + n - 1])) continue;
                return false;
            }
            return true;
        }

        public Interval domain() {
            return NurbsCurve.getKnotVectorDomain(this.order, this.cvCount, this.knot);
        }

        public boolean isValid() {
            if (this.dim <= 0 || this.order < 2 || this.cvCount < this.order || this.cv == null || this.knot == null || NurbsCurve.isValidKnotVector(this.order, this.cvCount, this.knot)) {
                return false;
            }
            if (this.isRat != 0) {
                // empty if block
            }
            return true;
        }
    }

    public static class BoundingBox {
        public IVec min = new IVec();
        public IVec max = new IVec();
    }

    public static class MeshNgonUserData
    extends UserData {
        public static final String uuid = "31F55AA3-71FB-49f5-A975-757584D937FF";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class MeshFaceRef
    extends Geometry {
        public static final String uuid = "4F529AA5-EF8D-4c25-BCBB-162D510AA280";
        public Mesh mesh;
        public int meshFaceIndex;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class MeshEdgeRef
    extends Geometry {
        public static final String uuid = "ED727872-463A-4424-851F-9EC02CB0F155";
        public Mesh mesh;
        public int topEdgeIndex;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0x2000000;
        }
    }

    public static class MeshVertexRef
    extends Geometry {
        public static final String uuid = "C547B4BD-BDCD-49b6-A983-0C4A7F02E31A";
        public Mesh mesh;
        public int meshVertexIndex;
        public int meshTopVertexIndex;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0x1000000;
        }
    }

    public static class MappingTag {
        public UUID mappingId;
        public TextureMapping.Type mappingType;
        public int mappingCRC;
        public Xform meshXform;

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            inputStream = new ByteArrayInputStream(chunk.content);
            int n = IRhino3dmImporter.readInt(inputStream);
            int n2 = IRhino3dmImporter.readInt(inputStream);
            if (n == 1) {
                this.mappingId = IRhino3dmImporter.readUUID(inputStream);
                this.mappingCRC = IRhino3dmImporter.readInt(inputStream);
                this.meshXform = IRhino3dmImporter.readXform(inputStream);
                if (n2 >= 1) {
                    this.mappingType = TextureMapping.type(IRhino3dmImporter.readInt(inputStream));
                }
            }
        }
    }

    public static class MeshFace {
        public int[] vertexIndex;

        public MeshFace() {
        }

        public MeshFace(int[] nArray) {
            if (nArray.length == 4) {
                this.vertexIndex = nArray;
            }
        }

        public MeshFace(int n, int n2, int n3, int n4) {
            this.vertexIndex = new int[4];
            this.vertexIndex[0] = n;
            this.vertexIndex[1] = n2;
            this.vertexIndex[2] = n3;
            this.vertexIndex[3] = n4;
        }

        public String toString() {
            return this.vertexIndex[0] + "-" + this.vertexIndex[1] + "-" + this.vertexIndex[2] + "-" + this.vertexIndex[3];
        }
    }

    public static class TextureCoordinates {
        public MappingTag tag;
        public int dim;
        public ArrayList<IVec> texture;
    }

    public static class MeshParameters {
        public boolean customSetting = false;
        public boolean computeCurvature = false;
        public boolean simplePlanes = false;
        public boolean refine = true;
        public boolean jaggedSeams = false;
        public byte reserved1 = 0;
        public byte reserved2 = 0;
        public byte mesher = 0;
        public int textureRange = 2;
        public double tolerance = 0.0;
        public double relativeTolerance = 0.0;
        public double minTolerance = 0.0;
        public double minEdgeLength = 1.0E-4;
        public double maxEdgeLength = 0.0;
        public double gridAspectRatio = 6.0;
        public int gridMinCount = 0;
        public int gridMaxCount = 0;
        public double gridAngle = 0.3490658503988659;
        public double gridAmplification = 1.0;
        public double refineAngle = 0.3490658503988659;
        public int faceType = 0;

        public static boolean readIntAsBoolean(InputStream inputStream) throws IOException {
            return IRhino3dmImporter.readInt(inputStream) != 0;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                boolean bl = false;
                this.computeCurvature = MeshParameters.readIntAsBoolean(inputStream);
                this.simplePlanes = MeshParameters.readIntAsBoolean(inputStream);
                this.refine = MeshParameters.readIntAsBoolean(inputStream);
                this.jaggedSeams = MeshParameters.readIntAsBoolean(inputStream);
                int n3 = IRhino3dmImporter.readInt(inputStream);
                this.tolerance = IRhino3dmImporter.readDouble(inputStream);
                this.minEdgeLength = IRhino3dmImporter.readDouble(inputStream);
                this.maxEdgeLength = IRhino3dmImporter.readDouble(inputStream);
                this.gridAspectRatio = IRhino3dmImporter.readDouble(inputStream);
                this.gridMinCount = IRhino3dmImporter.readInt(inputStream);
                this.gridMaxCount = IRhino3dmImporter.readInt(inputStream);
                this.gridAngle = IRhino3dmImporter.readDouble(inputStream);
                this.gridAmplification = IRhino3dmImporter.readDouble(inputStream);
                this.refineAngle = IRhino3dmImporter.readDouble(inputStream);
                double d = IRhino3dmImporter.readDouble(inputStream);
                this.faceType = IRhino3dmImporter.readInt(inputStream);
                if (this.faceType < 0 || this.faceType > 2) {
                    this.faceType = 0;
                    throw new IOException("faceType out of range");
                }
                if (n2 >= 1) {
                    this.textureRange = IRhino3dmImporter.readInt(inputStream);
                    if (n2 >= 2) {
                        this.customSetting = IRhino3dmImporter.readBool(inputStream);
                        this.relativeTolerance = IRhino3dmImporter.readDouble(inputStream);
                        if (n2 >= 3) {
                            this.mesher = IRhino3dmImporter.readByte(inputStream);
                        }
                    }
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
        }
    }

    public static class MeshCurvatureStats {
        public CurvatureStyle style;
        public double infinity;
        public int countInfinite;
        public int count;
        public double mode;
        public double average;
        public double adev;
        public Interval range;

        public static CurvatureStyle style(int n) {
            switch (n) {
                case 1: {
                    return CurvatureStyle.GaussianCurvature;
                }
                case 2: {
                    return CurvatureStyle.MeanCurvature;
                }
                case 3: {
                    return CurvatureStyle.MinCurvature;
                }
                case 4: {
                    return CurvatureStyle.MaxCurvature;
                }
            }
            return CurvatureStyle.UnknownCurvature;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                boolean bl = false;
                this.style = MeshCurvatureStats.style(IRhino3dmImporter.readInt(inputStream));
                this.infinity = IRhino3dmImporter.readDouble(inputStream);
                this.countInfinite = IRhino3dmImporter.readInt(inputStream);
                this.count = IRhino3dmImporter.readInt(inputStream);
                this.mode = IRhino3dmImporter.readDouble(inputStream);
                this.average = IRhino3dmImporter.readDouble(inputStream);
                this.adev = IRhino3dmImporter.readDouble(inputStream);
                this.range = IRhino3dmImporter.readInterval(inputStream);
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CurvatureStyle {
            UnknownCurvature,
            GaussianCurvature,
            MeanCurvature,
            MinCurvature,
            MaxCurvature;

        }
    }

    public static class SurfaceCurvature {
        public double k1;
        public double k2;
    }

    public static class Mesh
    extends Geometry {
        public static final String uuid = "4ED7D4E4-E947-11d3-BFE5-0010830122F0";
        public ArrayList<IVec> vertices;
        public ArrayList<MeshFace> faces;
        public ArrayList<IVec> normals;
        public ArrayList<IVec> unitNormals;
        public MappingTag ttag;
        public ArrayList<IVec2> texture;
        public ArrayList<TextureCoordinates> textureCoordinates;
        public ArrayList<IVec2> surfaceParameter;
        public Interval[] surfaceDomain;
        public double[] surfaceScale;
        public Interval[] packedTextureDomain;
        public boolean packedTextureRotate;
        public ArrayList<SurfaceCurvature> surfaceCurvature;
        public MappingTag ctag;
        public ArrayList<Color> color;
        public ArrayList<Boolean> hide;
        public int hiddenCount;
        public RhinoObject parent;
        public MeshParameters meshParameters;
        public int invalidCount;
        public int quadCount;
        public int triangleCount;
        public int closed;
        public float[][] vbox;
        public float[][] nbox;
        public float[][] tbox;
        public MeshCurvatureStats[] curvatureStat;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 32;
        }

        public Mesh() {
        }

        public Mesh(IMeshI iMeshI) {
            Object object;
            int n;
            ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
            this.vertices = new ArrayList();
            this.normals = new ArrayList();
            this.texture = new ArrayList();
            this.color = new ArrayList();
            this.surfaceCurvature = new ArrayList();
            for (n = 0; n < iMeshI.vertexNum(); ++n) {
                object = iMeshI.vertex(n);
                arrayList.add((IVertex)object);
                this.vertices.add(((IVertex)object).get());
                if (((IVertex)object).normal != null) {
                    this.normals.add(((IVertex)object).normal.get());
                }
                if (((IVertex)object).texture == null) continue;
                this.texture.add(((IVertex)object).texture.get());
            }
            this.faces = new ArrayList();
            for (n = 0; n < iMeshI.faceNum(); ++n) {
                int n2;
                int n3;
                int n4;
                int n5;
                object = iMeshI.face(n);
                if (((IFace)object).vertexNum() == 3) {
                    n5 = arrayList.indexOf(((IFace)object).vertex(0));
                    n4 = arrayList.indexOf(((IFace)object).vertex(1));
                    n3 = arrayList.indexOf(((IFace)object).vertex(2));
                    if (n5 < 0 || n4 < 0 || n3 < 0) continue;
                    this.faces.add(new MeshFace(n5, n4, n3, n3));
                    continue;
                }
                if (((IFace)object).vertexNum() == 4) {
                    n5 = arrayList.indexOf(((IFace)object).vertex(0));
                    n4 = arrayList.indexOf(((IFace)object).vertex(1));
                    n3 = arrayList.indexOf(((IFace)object).vertex(2));
                    n2 = arrayList.indexOf(((IFace)object).vertex(3));
                    if (n5 < 0 || n4 < 0 || n3 < 0 || n2 < 0) continue;
                    this.faces.add(new MeshFace(n5, n4, n3, n2));
                    continue;
                }
                if (((IFace)object).vertexNum() <= 4) continue;
                n5 = arrayList.indexOf(((IFace)object).vertex(0));
                n4 = arrayList.indexOf(((IFace)object).vertex(1));
                if (n5 < 0 || n4 < 0) continue;
                for (n3 = 2; n3 < ((IFace)object).vertexNum(); n3 += 2) {
                    if (n3 < ((IFace)object).vertexNum() - 1) {
                        n2 = arrayList.indexOf(((IFace)object).vertex(n3));
                        int n6 = arrayList.indexOf(((IFace)object).vertex(n3 + 1));
                        if (n2 >= 0 && n6 >= 0) {
                            this.faces.add(new MeshFace(n5, n4, n2, n6));
                        }
                        n4 = n6;
                        continue;
                    }
                    n2 = arrayList.indexOf(((IFace)object).vertex(n3));
                    if (n2 < 0) continue;
                    this.faces.add(new MeshFace(n5, n4, n2, n2));
                }
            }
            this.surfaceDomain = new Interval[2];
            this.surfaceDomain[0] = new Interval(0.0, 1.0);
            this.surfaceDomain[1] = new Interval(0.0, 1.0);
            this.surfaceScale = new double[2];
            this.surfaceScale[0] = 0.0;
            this.surfaceScale[1] = 0.0;
            this.packedTextureDomain = new Interval[2];
            this.packedTextureDomain[0] = new Interval(0.0, 1.0);
            this.packedTextureDomain[1] = new Interval(0.0, 1.0);
            this.packedTextureRotate = false;
            this.vbox = new float[2][3];
            this.nbox = new float[2][3];
            this.tbox = new float[2][2];
            for (n = 0; n < arrayList.size(); ++n) {
                IParameterObject iParameterObject;
                if (n == 0) {
                    object = ((IVertex)arrayList.get(n)).get();
                    float f = (float)((IVec)object).x;
                    this.vbox[1][0] = f;
                    this.vbox[0][0] = f;
                    float f2 = (float)((IVec)object).y;
                    this.vbox[1][1] = f2;
                    this.vbox[0][1] = f2;
                    float f3 = (float)((IVec)object).z;
                    this.vbox[1][2] = f3;
                    this.vbox[0][2] = f3;
                    if (((IVertex)arrayList.get((int)n)).normal != null) {
                        iParameterObject = ((IVertex)arrayList.get((int)n)).normal.get();
                        float f4 = (float)iParameterObject.x;
                        this.nbox[1][0] = f4;
                        this.nbox[0][0] = f4;
                        float f5 = (float)iParameterObject.y;
                        this.nbox[1][1] = f5;
                        this.nbox[0][1] = f5;
                        float f6 = (float)iParameterObject.z;
                        this.nbox[1][2] = f6;
                        this.nbox[0][2] = f6;
                    } else {
                        this.nbox[1][0] = 0.0f;
                        this.nbox[0][0] = 0.0f;
                        this.nbox[1][1] = 0.0f;
                        this.nbox[0][1] = 0.0f;
                        this.nbox[1][2] = 0.0f;
                        this.nbox[0][2] = 0.0f;
                    }
                    if (((IVertex)arrayList.get((int)n)).texture != null) {
                        iParameterObject = ((IVertex)arrayList.get((int)n)).texture.get();
                        float f7 = (float)((IVec2)iParameterObject).x;
                        this.tbox[1][0] = f7;
                        this.tbox[0][0] = f7;
                        float f8 = (float)((IVec2)iParameterObject).y;
                        this.tbox[1][1] = f8;
                        this.tbox[0][1] = f8;
                        continue;
                    }
                    this.tbox[1][0] = 0.0f;
                    this.tbox[0][0] = 0.0f;
                    this.tbox[1][1] = 0.0f;
                    this.tbox[0][1] = 0.0f;
                    continue;
                }
                object = ((IVertex)arrayList.get(n)).get();
                if (((IVec)object).x < (double)this.vbox[0][0]) {
                    this.vbox[0][0] = (float)((IVec)object).x;
                } else if (((IVec)object).x > (double)this.vbox[1][0]) {
                    this.vbox[1][0] = (float)((IVec)object).x;
                }
                if (((IVec)object).y < (double)this.vbox[0][1]) {
                    this.vbox[0][1] = (float)((IVec)object).y;
                } else if (((IVec)object).y > (double)this.vbox[1][1]) {
                    this.vbox[1][1] = (float)((IVec)object).y;
                }
                if (((IVec)object).z < (double)this.vbox[0][2]) {
                    this.vbox[0][2] = (float)((IVec)object).z;
                } else if (((IVec)object).z > (double)this.vbox[1][2]) {
                    this.vbox[1][2] = (float)((IVec)object).z;
                }
                if (((IVertex)arrayList.get((int)n)).normal != null) {
                    iParameterObject = ((IVertex)arrayList.get((int)n)).normal.get();
                    if (iParameterObject.x < (double)this.nbox[0][0]) {
                        this.nbox[0][0] = (float)iParameterObject.x;
                    } else if (iParameterObject.x > (double)this.nbox[1][0]) {
                        this.nbox[1][0] = (float)iParameterObject.x;
                    }
                    if (iParameterObject.y < (double)this.nbox[0][1]) {
                        this.nbox[0][1] = (float)iParameterObject.y;
                    } else if (iParameterObject.y > (double)this.nbox[1][1]) {
                        this.nbox[1][1] = (float)iParameterObject.y;
                    }
                    if (iParameterObject.z < (double)this.nbox[0][2]) {
                        this.nbox[0][2] = (float)iParameterObject.z;
                    } else if (iParameterObject.z > (double)this.nbox[1][2]) {
                        this.nbox[1][2] = (float)iParameterObject.z;
                    }
                }
                if (((IVertex)arrayList.get((int)n)).texture == null) continue;
                iParameterObject = ((IVertex)arrayList.get((int)n)).texture.get();
                if (((IVec2)iParameterObject).x < (double)this.tbox[0][0]) {
                    this.tbox[0][0] = (float)((IVec2)iParameterObject).x;
                } else if (((IVec2)iParameterObject).x > (double)this.tbox[1][0]) {
                    this.tbox[1][0] = (float)((IVec2)iParameterObject).x;
                }
                if (((IVec2)iParameterObject).y < (double)this.tbox[0][1]) {
                    this.tbox[0][1] = (float)((IVec2)iParameterObject).y;
                    continue;
                }
                if (!(((IVec2)iParameterObject).y > (double)this.tbox[1][1])) continue;
                this.tbox[1][1] = (float)((IVec2)iParameterObject).y;
            }
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            IOut.err("reading start");
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1 || n == 3) {
                int n3;
                Object object;
                int n4;
                int n5;
                int n6 = IRhino3dmImporter.readInt(inputStream);
                int n7 = IRhino3dmImporter.readInt(inputStream);
                this.packedTextureDomain = new Interval[2];
                this.packedTextureDomain[0] = IRhino3dmImporter.readInterval(inputStream);
                this.packedTextureDomain[1] = IRhino3dmImporter.readInterval(inputStream);
                this.surfaceDomain = new Interval[2];
                this.surfaceDomain[0] = IRhino3dmImporter.readInterval(inputStream);
                this.surfaceDomain[1] = IRhino3dmImporter.readInterval(inputStream);
                this.surfaceScale = new double[2];
                this.surfaceScale[0] = IRhino3dmImporter.readDouble(inputStream);
                this.surfaceScale[1] = IRhino3dmImporter.readDouble(inputStream);
                this.vbox = new float[2][3];
                for (n5 = 0; n5 < this.vbox.length; ++n5) {
                    for (n4 = 0; n4 < this.vbox[n5].length; ++n4) {
                        this.vbox[n5][n4] = IRhino3dmImporter.readFloat(inputStream);
                    }
                }
                this.nbox = new float[2][3];
                for (n5 = 0; n5 < this.nbox.length; ++n5) {
                    for (n4 = 0; n4 < this.nbox[n5].length; ++n4) {
                        this.nbox[n5][n4] = IRhino3dmImporter.readFloat(inputStream);
                    }
                }
                this.tbox = new float[2][2];
                for (n5 = 0; n5 < this.tbox.length; ++n5) {
                    for (n4 = 0; n4 < this.tbox[n5].length; ++n4) {
                        this.tbox[n5][n4] = IRhino3dmImporter.readFloat(inputStream);
                    }
                }
                this.closed = IRhino3dmImporter.readInt(inputStream);
                n5 = 0;
                n5 = IRhino3dmImporter.readByte(inputStream);
                if (n5 > 0) {
                    Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
                    if (chunk.header != 0x40008000) {
                        throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
                    }
                    object = new ByteArrayInputStream(chunk.content);
                    this.meshParameters = new MeshParameters();
                    this.meshParameters.read(rhino3dmFile, (InputStream)object);
                }
                this.curvatureStat = new MeshCurvatureStats[4];
                for (n3 = 0; n3 < 4; ++n3) {
                    n5 = IRhino3dmImporter.readByte(inputStream);
                    if (n5 <= 0) continue;
                    object = IRhino3dmImporter.readChunk(inputStream);
                    if (((Chunk)object).header != 0x40008000) {
                        throw new IOException("invalid type code = " + IRhino3dm.hex(((Chunk)object).header));
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Chunk)object).content);
                    this.curvatureStat[n3] = new MeshCurvatureStats();
                    this.curvatureStat[n3].read(rhino3dmFile, byteArrayInputStream);
                }
                this.readFaceArray(rhino3dmFile, inputStream, n6, n7);
                if (n == 1) {
                    this.read1(rhino3dmFile, inputStream);
                } else if (n == 3) {
                    this.read2(rhino3dmFile, inputStream, n6);
                }
                if (n2 >= 2) {
                    n3 = IRhino3dmImporter.readInt(inputStream);
                    boolean bl = this.packedTextureRotate = n3 != 0;
                }
                if (n == 3 && n2 >= 3) {
                    this.ttag = new MappingTag();
                    this.ttag.mappingId = IRhino3dmImporter.readUUID(inputStream);
                    if (n6 > 0) {
                        int n8;
                        n3 = IRhino3dmImporter.readCompressedBufferSize(inputStream);
                        if (n3 != (n8 = 16) * n6) {
                            throw new IOException("buffer size (" + n3 + ") doesn't match with vcount(" + n6 + ")*surface_parameter_data_size(" + n8 + ")");
                        }
                        this.surfaceParameter = IRhino3dmImporter.readArrayPoint2(IRhino3dmImporter.readCompressedBuffer(inputStream, n3), n6);
                        if (IRhino3dm.endian() == Endian.BigEndian) {
                            // empty if block
                        }
                        if (n2 >= 4 && rhino3dmFile.openNurbsVersion >= 200606010) {
                            this.ttag.read(rhino3dmFile, inputStream);
                        }
                    }
                }
                if (this.surfaceParameter != null || this.vertices == null || this.vertices.size() > 0) {
                    // empty if block
                }
            }
        }

        public void read1(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            IOut.err();
            this.vertices = IRhino3dmImporter.readArrayPoint3f(inputStream);
            this.normals = IRhino3dmImporter.readArrayPoint3f(inputStream);
            this.texture = IRhino3dmImporter.readArrayPoint2f(inputStream);
            this.surfaceCurvature = IRhino3dmImporter.readArraySurfaceCurvature(inputStream);
            this.color = IRhino3dmImporter.readArrayColor(inputStream);
        }

        public void read2(Rhino3dmFile rhino3dmFile, InputStream inputStream, int n) throws IOException {
            IOut.err();
            Endian endian = IRhino3dm.endian();
            if (n > 0) {
                int n2 = 12;
                int n3 = IRhino3dmImporter.readCompressedBufferSize(inputStream);
                if (n3 > 0) {
                    if (n3 != n * n2) {
                        throw new IOException("buffer size (" + n3 + ") doesn't match with vcount(" + n + ")*vertex_data_size(" + n2 + ")");
                    }
                    this.vertices = IRhino3dmImporter.readArrayPoint3f(IRhino3dmImporter.readCompressedBuffer(inputStream, n3), n);
                }
                if ((n3 = IRhino3dmImporter.readCompressedBufferSize(inputStream)) > 0) {
                    if (n3 != n * n2) {
                        throw new IOException("buffer size (" + n3 + ") doesn't match with vcount(" + n + ")*normal_data_size(" + n2 + ")");
                    }
                    this.normals = IRhino3dmImporter.readArrayPoint3f(IRhino3dmImporter.readCompressedBuffer(inputStream, n3), n);
                }
                n2 = 8;
                n3 = IRhino3dmImporter.readCompressedBufferSize(inputStream);
                if (n3 > 0) {
                    if (n3 != n * n2) {
                        throw new IOException("buffer size (" + n3 + ") doesn't match with vcount(" + n + ")*texture_data_size(" + n2 + ")");
                    }
                    this.texture = IRhino3dmImporter.readArrayPoint2f(IRhino3dmImporter.readCompressedBuffer(inputStream, n3), n);
                }
                n2 = 16;
                n3 = IRhino3dmImporter.readCompressedBufferSize(inputStream);
                if (n3 > 0) {
                    if (n3 != n * n2) {
                        throw new IOException("buffer size (" + n3 + ") doesn't match with vcount(" + n + ")*curvature_data_size(" + n2 + ")");
                    }
                    this.surfaceCurvature = IRhino3dmImporter.readArraySurfaceCurvature(IRhino3dmImporter.readCompressedBuffer(inputStream, n3), n);
                }
                n2 = 4;
                n3 = IRhino3dmImporter.readCompressedBufferSize(inputStream);
                if (n3 > 0) {
                    if (n3 != n * n2) {
                        throw new IOException("buffer size (" + n3 + ") doesn't match with vcount(" + n + ")*color_data_size(" + n2 + ")");
                    }
                    this.color = IRhino3dmImporter.readArrayColor(IRhino3dmImporter.readCompressedBuffer(inputStream, n3), n);
                }
                if (endian == Endian.BigEndian) {
                    // empty if block
                }
            }
        }

        public void readFaceArray(Rhino3dmFile rhino3dmFile, InputStream inputStream, int n, int n2) throws IOException {
            this.faces = new ArrayList(n2);
            int n3 = 0;
            n3 = IRhino3dmImporter.readInt(inputStream);
            switch (n3) {
                case 1: {
                    byte[] byArray = new byte[4];
                    for (int i = 0; i < n2; ++i) {
                        byArray[0] = IRhino3dmImporter.readByte(inputStream);
                        byArray[1] = IRhino3dmImporter.readByte(inputStream);
                        byArray[2] = IRhino3dmImporter.readByte(inputStream);
                        byArray[3] = IRhino3dmImporter.readByte(inputStream);
                        this.faces.add(new MeshFace(byArray[0], byArray[1], byArray[2], byArray[3]));
                    }
                    break;
                }
                case 2: {
                    short[] sArray = new short[4];
                    for (int i = 0; i < n2; ++i) {
                        sArray[0] = IRhino3dmImporter.readShort(inputStream);
                        sArray[1] = IRhino3dmImporter.readShort(inputStream);
                        sArray[2] = IRhino3dmImporter.readShort(inputStream);
                        sArray[3] = IRhino3dmImporter.readShort(inputStream);
                        this.faces.add(new MeshFace(sArray[0], sArray[1], sArray[2], sArray[3]));
                    }
                    break;
                }
                case 4: {
                    int[] nArray = new int[4];
                    for (int i = 0; i < n2; ++i) {
                        nArray[0] = IRhino3dmImporter.readInt(inputStream);
                        nArray[1] = IRhino3dmImporter.readInt(inputStream);
                        nArray[2] = IRhino3dmImporter.readInt(inputStream);
                        nArray[3] = IRhino3dmImporter.readInt(inputStream);
                        this.faces.add(new MeshFace(nArray[0], nArray[1], nArray[2], nArray[3]));
                    }
                    break;
                }
            }
        }

        public IMesh createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return new IMesh(iServerI, this.createIGGeometry(rhino3dmFile, iServerI));
        }

        public IMeshGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.vertices == null) {
                IOut.err("mesh vertices is null");
                return null;
            }
            if (this.faces == null) {
                IOut.err("mesh face is null");
                return null;
            }
            if (this.vertices.size() == 0) {
                IOut.err("no mesh vertices found");
                return null;
            }
            if (this.faces.size() == 0) {
                IOut.err("no mesh face found");
                return null;
            }
            ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
            for (int i = 0; i < this.vertices.size(); ++i) {
                IVertex iVertex = new IVertex(this.vertices.get(i));
                if (this.normals != null && this.normals.size() == this.vertices.size()) {
                    iVertex.normal(this.normals.get(i));
                }
                if (this.texture != null && this.texture.size() == this.vertices.size()) {
                    iVertex.texture(this.texture.get(i));
                }
                arrayList.add(iVertex);
            }
            ArrayList<IFace> arrayList2 = new ArrayList<IFace>();
            for (int i = 0; i < this.faces.size(); ++i) {
                if (this.faces.get((int)i).vertexIndex == null || this.faces.get((int)i).vertexIndex.length < 3) continue;
                int[] nArray = this.faces.get((int)i).vertexIndex;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                for (int j = 0; j < nArray.length; ++j) {
                    if (j != 0 && (j <= 0 || nArray[j] == (Integer)arrayList3.get(arrayList3.size() - 1) || j >= nArray.length - 1 && (j != nArray.length - 1 || nArray[j] == (Integer)arrayList3.get(0)))) continue;
                    arrayList3.add(nArray[j]);
                }
                if (arrayList3.size() > 0) {
                    IVertex[] iVertexArray = new IVertex[arrayList3.size()];
                    for (int j = 0; j < arrayList3.size(); ++j) {
                        iVertexArray[j] = (IVertex)arrayList.get((Integer)arrayList3.get(j));
                    }
                    arrayList2.add(new IFace(iVertexArray));
                    continue;
                }
                IOut.err("no vertices is created");
            }
            if (arrayList2.size() == 0) {
                IOut.err("no face is created");
                return null;
            }
            return new IMeshGeo(arrayList2.toArray(new IFace[arrayList2.size()]));
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            int n;
            byte by;
            IRhino3dmExporter.writeChunkVersion(outputStream, 3, 2, cRC32);
            int n2 = this.vertices.size();
            int n3 = this.faces.size();
            IRhino3dmExporter.writeInt(outputStream, n2, cRC32);
            IRhino3dmExporter.writeInt(outputStream, n3, cRC32);
            IRhino3dmExporter.writeInterval(outputStream, this.packedTextureDomain[0], cRC32);
            IRhino3dmExporter.writeInterval(outputStream, this.packedTextureDomain[1], cRC32);
            IRhino3dmExporter.writeInterval(outputStream, this.surfaceDomain[0], cRC32);
            IRhino3dmExporter.writeInterval(outputStream, this.surfaceDomain[1], cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.surfaceScale[0], cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.surfaceScale[1], cRC32);
            for (by = 0; by < 2; ++by) {
                for (n = 0; n < 3; ++n) {
                    IRhino3dmExporter.writeFloat(outputStream, this.vbox[by][n], cRC32);
                }
            }
            for (by = 0; by < 2; ++by) {
                for (n = 0; n < 3; ++n) {
                    IRhino3dmExporter.writeFloat(outputStream, this.nbox[by][n], cRC32);
                }
            }
            for (by = 0; by < 2; ++by) {
                for (n = 0; n < 2; ++n) {
                    IRhino3dmExporter.writeFloat(outputStream, this.tbox[by][n], cRC32);
                }
            }
            IRhino3dmExporter.writeInt(outputStream, this.closed, cRC32);
            by = 0;
            IRhino3dmExporter.writeByte(outputStream, by, cRC32);
            for (n = 0; n < 4; ++n) {
                by = 0;
                IRhino3dmExporter.writeByte(outputStream, by, cRC32);
            }
            this.writeFaceArray(rhino3dmFile, outputStream, n2, n3, cRC32);
            this.write2(rhino3dmFile, outputStream, n2, cRC32);
            n = this.packedTextureRotate ? 1 : 0;
            IRhino3dmExporter.writeInt(outputStream, n, cRC32);
        }

        public void write1(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeArrayPoint3f(outputStream, this.vertices, cRC32);
            IRhino3dmExporter.writeArrayPoint3f(outputStream, this.normals, cRC32);
            IRhino3dmExporter.writeArrayPoint2f(outputStream, this.texture, cRC32);
            IRhino3dmExporter.writeArraySurfaceCurvature(outputStream, this.surfaceCurvature, cRC32);
            IRhino3dmExporter.writeArrayColor(outputStream, this.color, cRC32);
        }

        public void write2(Rhino3dmFile rhino3dmFile, OutputStream outputStream, int n, CRC32 cRC32) throws IOException {
            Endian endian = IRhino3dm.endian();
            if (n <= 0) {
                return;
            }
            int n2 = this.normals.size() == n ? n : 0;
            int n3 = this.texture.size() == n ? n : 0;
            int n4 = this.surfaceCurvature.size() == n ? n : 0;
            int n5 = this.color.size() == n ? n : 0;
            byte[] byArray = IRhino3dmExporter.writeArrayPoint3f(this.vertices, null);
            IRhino3dmExporter.writeCompressedBuffer(outputStream, byArray, byArray.length, cRC32);
            byArray = IRhino3dmExporter.writeArrayPoint3f(this.normals, null);
            IRhino3dmExporter.writeCompressedBuffer(outputStream, byArray, byArray.length, cRC32);
            byArray = IRhino3dmExporter.writeArrayPoint2f(this.texture, null);
            IRhino3dmExporter.writeCompressedBuffer(outputStream, byArray, byArray.length, cRC32);
            byArray = IRhino3dmExporter.writeArraySurfaceCurvature(this.surfaceCurvature, null);
            IRhino3dmExporter.writeCompressedBuffer(outputStream, byArray, byArray.length, cRC32);
            byArray = IRhino3dmExporter.writeArrayColor(this.color, null);
            IRhino3dmExporter.writeCompressedBuffer(outputStream, byArray, byArray.length, cRC32);
        }

        public void writeFaceArray(Rhino3dmFile rhino3dmFile, OutputStream outputStream, int n, int n2, CRC32 cRC32) throws IOException {
            byte[] byArray = new byte[4];
            short[] sArray = new short[4];
            int n3 = 0;
            n3 = n < 256 ? 1 : (n < 65536 ? 2 : 4);
            IRhino3dmExporter.writeInt(outputStream, n3, cRC32);
            switch (n3) {
                case 1: {
                    for (int i = 0; i < n2; ++i) {
                        IRhino3dmExporter.writeByte(outputStream, (byte)this.faces.get((int)i).vertexIndex[0], cRC32);
                        IRhino3dmExporter.writeByte(outputStream, (byte)this.faces.get((int)i).vertexIndex[1], cRC32);
                        IRhino3dmExporter.writeByte(outputStream, (byte)this.faces.get((int)i).vertexIndex[2], cRC32);
                        IRhino3dmExporter.writeByte(outputStream, (byte)this.faces.get((int)i).vertexIndex[3], cRC32);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n2; ++i) {
                        IRhino3dmExporter.writeShort(outputStream, (short)this.faces.get((int)i).vertexIndex[0], cRC32);
                        IRhino3dmExporter.writeShort(outputStream, (short)this.faces.get((int)i).vertexIndex[1], cRC32);
                        IRhino3dmExporter.writeShort(outputStream, (short)this.faces.get((int)i).vertexIndex[2], cRC32);
                        IRhino3dmExporter.writeShort(outputStream, (short)this.faces.get((int)i).vertexIndex[3], cRC32);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n2; ++i) {
                        IRhino3dmExporter.writeInt(outputStream, this.faces.get((int)i).vertexIndex[0], cRC32);
                        IRhino3dmExporter.writeInt(outputStream, this.faces.get((int)i).vertexIndex[1], cRC32);
                        IRhino3dmExporter.writeInt(outputStream, this.faces.get((int)i).vertexIndex[2], cRC32);
                        IRhino3dmExporter.writeInt(outputStream, this.faces.get((int)i).vertexIndex[3], cRC32);
                    }
                    break;
                }
            }
        }
    }

    public static class LineCurve
    extends Curve {
        public static final String uuid = "4ED7D4DB-E947-11d3-BFE5-0010830122F0";
        public Line line;
        public Interval t;
        public int dim;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public Interval domain() {
            return this.t;
        }

        public boolean isValid() {
            return this.t.isIncreasing() && this.line.length() > 0.0;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                this.line = IRhino3dmImporter.readLine(inputStream);
                this.t = IRhino3dmImporter.readInterval(inputStream);
                this.dim = IRhino3dmImporter.readInt32(inputStream);
                IOut.debug(100, "line = " + this.line.from + ", " + this.line.to);
            } else {
                IOut.err("wrong chunk major version :" + n);
            }
        }

        public ICurve createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.line == null) {
                return null;
            }
            ICurve iCurve = new ICurve(iServerI, this.line.from, this.line.to);
            return iCurve;
        }

        public ICurveGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.line == null) {
                return null;
            }
            return new ICurveGeo(this.line.from, this.line.to);
        }

        public ITrimCurve createTrimCurve(Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            if (this.line == null) {
                return null;
            }
            return new ITrimCurve(this.line.from, this.line.to);
        }
    }

    public static class Line {
        public IVec from;
        public IVec to;

        public double length() {
            return this.from.dist(this.to);
        }

        public String toString() {
            return "< " + this.from.toString() + ", " + this.to.toString() + " >";
        }
    }

    public static class CurveProxy
    extends Curve {
        public static final String uuid = "4ED7D4D9-E947-11d3-BFE5-0010830122F0";
        public Curve realCurve;
        public boolean reversed;
        public Interval realCurveDomain = new Interval();
        public Interval thisDomain = new Interval();

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public void setProxyCurve(Curve curve, Interval interval) {
            if (curve != this) {
                curve = null;
                this.realCurveDomain = null;
                this.thisDomain = null;
                this.reversed = false;
            } else {
                if (this.isValid() && this.thisDomain.includes(interval)) {
                    curve = this.realCurve;
                    double d = this.realCurveParameter(interval.v1);
                    double d2 = this.realCurveParameter(interval.v2);
                    interval.set(d, d2);
                } else {
                    curve = null;
                }
                this.realCurve = null;
            }
            if (this.realCurve != null) {
                this.setProxyCurveDomain(interval);
            } else {
                this.realCurveDomain = interval;
            }
            this.thisDomain = this.realCurveDomain;
        }

        public boolean setProxyCurveDomain(Interval interval) {
            if (!interval.isIncreasing()) {
                return false;
            }
            if (this.realCurve != null) {
                Interval interval2 = this.realCurve.domain();
                interval2.intersection(interval);
                if (interval2.isIncreasing()) {
                    this.realCurveDomain = interval2;
                }
            } else {
                this.realCurveDomain = interval;
            }
            return true;
        }

        public Interval proxyCurveDomain() {
            return this.realCurveDomain;
        }

        public double realCurveParameter(double d) {
            if (this.reversed || this.realCurveDomain.equals(this.thisDomain)) {
                double d2 = this.thisDomain.normalizedParameterAt(d);
                if (this.reversed) {
                    d2 = 1.0 - d2;
                }
                d = this.realCurveDomain.parameterAt(d2);
            }
            return d;
        }

        public void setDomain(Interval interval) {
            if (interval.isIncreasing()) {
                this.thisDomain.set(interval);
            }
        }

        public Interval domain() {
            return this.thisDomain;
        }

        public boolean reverse() {
            if (this.thisDomain.isIncreasing()) {
                this.reversed = !this.reversed;
                this.thisDomain.reverse();
            }
            return true;
        }

        public boolean proxyCurveIsReversed() {
            return this.reversed;
        }

        public boolean isValid() {
            if (this.realCurve == null) {
                return false;
            }
            if (!this.realCurve.isValid()) {
                return false;
            }
            if (!this.realCurveDomain.isIncreasing()) {
                return false;
            }
            if (!this.realCurve.domain().includes(this.realCurveDomain)) {
                return false;
            }
            if (!this.thisDomain.isIncreasing()) {
                return false;
            }
            return false;
        }
    }

    public static class LayerExtensions
    extends UserData {
        public static final String uuid = "3E4904E6-E930-4fbc-AA42-EBD407AEFE3B";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class InstanceRef
    extends Geometry {
        public static final String uuid = "F9CFB638-B9D4-4340-87E3-C56E7865D96A";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 4096;
        }
    }

    public static class Hatch
    extends Geometry {
        public static final String uuid = "0559733B-5332-49d1-A936-0532AC76ADE5";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 65536;
        }
    }

    public static class HatchExtra
    extends UserData {
        public static final String uuid = "3FF7007C-3D04-463f-84E3-132ACEB91062";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class DimStyleExtra
    extends UserData {
        public static final String uuid = "513FDE53-7284-4065-8601-06CEA8B28D6F";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class DetailView
    extends Geometry {
        public static final String uuid = "C8C66EFA-B3CB-4e00-9440-2AD66203379E";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 32768;
        }
    }

    public static class CurveOnSurface
    extends Curve {
        public static final String uuid = "4ED7D4D8-E947-11d3-BFE5-0010830122F0";
        public Curve curve2;
        public Curve curve3;
        public Surface surface;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public boolean isValid() {
            if (this.curve2 == null) {
                return false;
            }
            if (this.surface == null) {
                return false;
            }
            if (!this.curve2.isValid()) {
                return false;
            }
            return this.curve3 == null || this.curve3.isValid();
        }

        public Interval domain() {
            return this.curve2.domain();
        }
    }

    public static class BrepRegion
    extends RhinoObject {
        public static final String uuid = "CA7A0092-7EE6-4f99-B9D2-E1D6AA798AA1";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class BrepFaceSide
    extends RhinoObject {
        public static final String uuid = "30930370-0D5B-4ee4-8083-BD635C7398A4";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class BrepRegionTopologyUserData
    extends UserData {
        public static final String uuid = "7FE23D63-E536-43f1-98E2-C807A2625AFF";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Brep
    extends Geometry {
        public static final String uuid = "60B5DBC5-E660-11d3-BFE4-0010830122F0";
        public CurveArray curves2;
        public CurveArray curves3;
        public SurfaceArray surfaces;
        public BrepVertexArray vertices;
        public BrepEdgeArray edges;
        public BrepTrimArray trims;
        public BrepLoopArray loops;
        public BrepFaceArray faces;
        public BoundingBox bbox;
        public int isSolid;
        public ArrayList<ICurveGeo> icurves3;

        @Override
        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        @Override
        public int getType() {
            return 16;
        }

        public Brep() {
        }

        public Brep(IBrep iBrep) {
            this.curves2 = new CurveArray();
            this.curves3 = new CurveArray();
            this.surfaces = new SurfaceArray();
            this.vertices = new BrepVertexArray();
            this.edges = new BrepEdgeArray();
            this.trims = new BrepTrimArray();
            this.loops = new BrepLoopArray();
            this.faces = new BrepFaceArray();
            this.bbox = new BoundingBox();
            this.icurves3 = new ArrayList();
            this.isSolid = iBrep.solid ? 1 : 0;
            IBoundingBox iBoundingBox = new IBoundingBox();
            if (iBrep.surfaces != null) {
                for (int i = 0; i < iBrep.surfaces.length; ++i) {
                    this.addSurface(iBrep.surfaces[i], iBoundingBox);
                }
            }
            this.bbox.min = iBoundingBox.min;
            this.bbox.max = iBoundingBox.max;
        }

        public Brep(ISurfaceGeo iSurfaceGeo) {
            this.curves2 = new CurveArray();
            this.curves3 = new CurveArray();
            this.surfaces = new SurfaceArray();
            this.vertices = new BrepVertexArray();
            this.edges = new BrepEdgeArray();
            this.trims = new BrepTrimArray();
            this.loops = new BrepLoopArray();
            this.faces = new BrepFaceArray();
            this.bbox = new BoundingBox();
            this.isSolid = 0;
            this.icurves3 = new ArrayList();
            IBoundingBox iBoundingBox = new IBoundingBox();
            this.addSurface(iSurfaceGeo, iBoundingBox);
            this.bbox.min = iBoundingBox.min;
            this.bbox.max = iBoundingBox.max;
        }

        public void getTrimLoops(ISurfaceGeo iSurfaceGeo, ArrayList<ArrayList<ITrimCurve>> arrayList, ArrayList<BrepLoop.Type> arrayList2) {
            int n;
            ArrayList<ITrimCurve> arrayList3;
            int n2;
            if (!iSurfaceGeo.hasOuterTrim()) {
                ArrayList<ITrimCurve> arrayList4 = new ArrayList<ITrimCurve>();
                arrayList4.add(new ITrimCurve(new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0)).surface(iSurfaceGeo));
                arrayList4.add(new ITrimCurve(new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0)).surface(iSurfaceGeo));
                arrayList4.add(new ITrimCurve(new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)).surface(iSurfaceGeo));
                arrayList4.add(new ITrimCurve(new IVec(0.0, 1.0, 0.0), new IVec(0.0, 0.0, 0.0)).surface(iSurfaceGeo));
                arrayList.add(arrayList4);
                arrayList2.add(BrepLoop.Type.Outer);
            }
            for (n2 = 0; n2 < iSurfaceGeo.outerTrimLoopNum(); ++n2) {
                arrayList3 = new ArrayList<ITrimCurve>();
                for (n = 0; n < iSurfaceGeo.outerTrimNum(n2); ++n) {
                    arrayList3.add(iSurfaceGeo.outerTrim(n2, n).get());
                }
                arrayList.add(arrayList3);
                arrayList2.add(BrepLoop.Type.Outer);
            }
            for (n2 = 0; n2 < iSurfaceGeo.innerTrimLoopNum(); ++n2) {
                arrayList3 = new ArrayList();
                for (n = 0; n < iSurfaceGeo.innerTrimNum(n2); ++n) {
                    arrayList3.add(iSurfaceGeo.innerTrim(n2, n).get());
                }
                arrayList.add(arrayList3);
                arrayList2.add(BrepLoop.Type.Inner);
            }
            Brep.checkTrimLoopDirection(arrayList, arrayList2);
        }

        public boolean isEdgeTouching(ICurveGeo iCurveGeo, ICurveGeo iCurveGeo2) {
            return this.isEdgeTouching(iCurveGeo, iCurveGeo2, IConfig.lengthResolution);
        }

        public boolean isEdgeTouching(ICurveGeo iCurveGeo, ICurveGeo iCurveGeo2, double d) {
            IVec iVec = iCurveGeo.start();
            IVec iVec2 = iCurveGeo.end();
            IVec iVec3 = iCurveGeo2.start();
            IVec iVec4 = iCurveGeo2.end();
            if (iVec.eq(iVec3, d) && iVec2.eq(iVec4, d)) {
                return true;
            }
            return iVec.eq(iVec4, d) && iVec2.eq(iVec3, d);
        }

        public ICurveGeo getSharedICurve(ICurveGeo iCurveGeo) {
            if (this.icurves3 == null || this.icurves3.size() == 0) {
                return null;
            }
            for (int i = 0; i < this.icurves3.size(); ++i) {
                if (!this.isEdgeTouching(iCurveGeo, this.icurves3.get(i))) continue;
                return this.icurves3.get(i);
            }
            return null;
        }

        public Curve getCurve3(ICurveGeo iCurveGeo) {
            for (int i = 0; i < this.curves3.size(); ++i) {
                if (((Curve)this.curves3.get((int)i)).icurve != iCurveGeo) continue;
                return (Curve)this.curves3.get(i);
            }
            return null;
        }

        public BrepEdge getBrepEdge(Curve curve) {
            int n = this.curves3.indexOf(curve);
            if (n < 0) {
                return null;
            }
            for (int i = 0; i < this.edges.size(); ++i) {
                if (((BrepEdge)this.edges.get((int)i)).curve3Index != n) continue;
                return (BrepEdge)this.edges.get(i);
            }
            return null;
        }

        public BrepTrim getBrepTrim(BrepEdge brepEdge) {
            int n = this.edges.indexOf(brepEdge);
            if (n < 0) {
                return null;
            }
            for (int i = 0; i < this.trims.size(); ++i) {
                if (((BrepTrim)this.trims.get((int)i)).edgeIndex != n) continue;
                return (BrepTrim)this.trims.get(i);
            }
            return null;
        }

        public BrepVertex getSharedVertex(IVec iVec) {
            return this.getSharedVertex(iVec, IConfig.lengthResolution);
        }

        public BrepVertex getSharedVertex(IVec iVec, double d) {
            if (this.vertices == null || this.vertices.size() == 0) {
                return null;
            }
            for (int i = 0; i < this.vertices.size(); ++i) {
                if (!((BrepVertex)this.vertices.get((int)i)).point.eq(iVec, d)) continue;
                return (BrepVertex)this.vertices.get(i);
            }
            return null;
        }

        public void addSurface(ISurfaceGeo iSurfaceGeo, IBoundingBox iBoundingBox) {
            NurbsSurface nurbsSurface = new NurbsSurface(iSurfaceGeo);
            this.surfaces.add(nurbsSurface);
            BrepFace brepFace = new BrepFace(this.faces.size(), this.surfaces.size() - 1, nurbsSurface, this);
            this.faces.add(brepFace);
            ArrayList<ArrayList<ITrimCurve>> arrayList = new ArrayList<ArrayList<ITrimCurve>>();
            ArrayList<BrepLoop.Type> arrayList2 = new ArrayList<BrepLoop.Type>();
            this.getTrimLoops(iSurfaceGeo, arrayList, arrayList2);
            for (int i = 0; i < arrayList.size(); ++i) {
                BrepLoop brepLoop = new BrepLoop(this.loops.size(), this.faces.size() - 1, arrayList2.get(i), this);
                this.loops.add(brepLoop);
                brepFace.addLoopIndex(this.loops.size() - 1);
                for (int j = 0; j < arrayList.get(i).size(); ++j) {
                    Object object;
                    CurveProxy curveProxy;
                    Object object2;
                    Object object3;
                    BrepVertex brepVertex;
                    Object object4;
                    Object object5;
                    ITrimCurve iTrimCurve = arrayList.get(i).get(j);
                    NurbsCurve nurbsCurve = new NurbsCurve(iTrimCurve);
                    this.curves2.add(nurbsCurve);
                    ICurveGeo iCurveGeo = iTrimCurve.get3d();
                    ICurveGeo iCurveGeo2 = this.getSharedICurve(iCurveGeo);
                    Curve curve = null;
                    BrepEdge brepEdge = null;
                    if (iCurveGeo2 != null && (curve = this.getCurve3(iCurveGeo2)) != null) {
                        brepEdge = this.getBrepEdge(curve);
                    }
                    if (brepEdge == null) {
                        this.icurves3.add(iCurveGeo);
                        object5 = new NurbsCurve(iCurveGeo);
                        this.curves3.add(object5);
                        for (int k = 0; k < iCurveGeo.num(); ++k) {
                            iBoundingBox.compare(iCurveGeo.cp(k));
                        }
                        object4 = iCurveGeo.start();
                        brepVertex = this.getSharedVertex((IVec)object4);
                        if (brepVertex == null) {
                            brepVertex = new BrepVertex(this.vertices.size(), (IVec)object4);
                            this.vertices.add(brepVertex);
                        }
                        if ((object3 = this.getSharedVertex((IVec)(object2 = iCurveGeo.end()))) == null) {
                            object3 = new BrepVertex(this.vertices.size(), (IVec)object2);
                            this.vertices.add(object3);
                        }
                        Interval interval = ((NurbsCurve)object5).domain();
                        curveProxy = new BrepEdge(this.edges.size(), this.curves3.indexOf(object5), brepVertex.vertexIndex, ((BrepVertex)object3).vertexIndex, interval, interval, this);
                        this.edges.add(curveProxy);
                        brepVertex.addEdgeIndex(((BrepEdge)curveProxy).edgeIndex);
                        ((BrepVertex)object3).addEdgeIndex(((BrepEdge)curveProxy).edgeIndex);
                        object = nurbsCurve.domain();
                        Interval interval2 = new Interval((Interval)object);
                        BrepTrim brepTrim = new BrepTrim(this.trims.size(), this.curves2.indexOf(nurbsCurve), this.edges.indexOf(curveProxy), brepVertex.vertexIndex, ((BrepVertex)object3).vertexIndex, brepLoop.loopIndex, interval2, (Interval)object, this, iTrimCurve);
                        this.trims.add(brepTrim);
                        brepLoop.addTrimIndex(brepTrim.trimIndex);
                        ((BrepEdge)curveProxy).addTrimIndex(brepTrim.trimIndex);
                        continue;
                    }
                    object5 = nurbsCurve.domain();
                    object4 = new Interval((Interval)object5);
                    brepVertex = (BrepVertex)this.vertices.get(brepEdge.vertexIndex[0]);
                    object2 = (BrepVertex)this.vertices.get(brepEdge.vertexIndex[1]);
                    object3 = iCurveGeo.start();
                    boolean bl = false;
                    if (((IVec)object3).dist(brepVertex.point) > ((IVec)object3).dist(((BrepVertex)object2).point)) {
                        bl = true;
                    }
                    curveProxy = new BrepTrim(this.trims.size(), this.curves2.indexOf(nurbsCurve), brepEdge.edgeIndex, brepVertex.vertexIndex, ((BrepVertex)object2).vertexIndex, brepLoop.loopIndex, (Interval)object4, (Interval)object5, this, iTrimCurve);
                    ((BrepTrim)curveProxy).type = BrepTrim.Type.Mated;
                    object = this.getBrepTrim(brepEdge);
                    if (object != null) {
                        ((BrepTrim)object).type = BrepTrim.Type.Mated;
                    }
                    if (bl) {
                        ((BrepTrim)curveProxy).reverse();
                    }
                    this.trims.add(curveProxy);
                    brepLoop.addTrimIndex(((BrepTrim)curveProxy).trimIndex);
                    brepEdge.addTrimIndex(((BrepTrim)curveProxy).trimIndex);
                }
            }
        }

        public void addSingleSurface(ISurfaceGeo iSurfaceGeo, IBoundingBox iBoundingBox) {
            int n;
            Object object;
            int n2;
            NurbsSurface nurbsSurface = new NurbsSurface(iSurfaceGeo);
            this.surfaces.add(nurbsSurface);
            BrepFace brepFace = new BrepFace(this.faces.size(), this.surfaces.size() - 1, nurbsSurface, this);
            this.faces.add(brepFace);
            ArrayList<ArrayList<ITrimCurve>> arrayList = new ArrayList<ArrayList<ITrimCurve>>();
            ArrayList<BrepLoop.Type> arrayList2 = new ArrayList<BrepLoop.Type>();
            if (!iSurfaceGeo.hasOuterTrim()) {
                ArrayList<ITrimCurve> arrayList3 = new ArrayList<ITrimCurve>();
                arrayList3.add(new ITrimCurve(new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0)).surface(iSurfaceGeo));
                arrayList3.add(new ITrimCurve(new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0)).surface(iSurfaceGeo));
                arrayList3.add(new ITrimCurve(new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)).surface(iSurfaceGeo));
                arrayList3.add(new ITrimCurve(new IVec(0.0, 1.0, 0.0), new IVec(0.0, 0.0, 0.0)).surface(iSurfaceGeo));
                arrayList.add(arrayList3);
                arrayList2.add(BrepLoop.Type.Outer);
            }
            for (n2 = 0; n2 < iSurfaceGeo.outerTrimLoopNum(); ++n2) {
                object = new ArrayList<ITrimCurve>();
                for (n = 0; n < iSurfaceGeo.outerTrimNum(n2); ++n) {
                    ((ArrayList)object).add(iSurfaceGeo.outerTrim(n2, n).get());
                }
                arrayList.add((ArrayList<ITrimCurve>)object);
                arrayList2.add(BrepLoop.Type.Outer);
            }
            for (n2 = 0; n2 < iSurfaceGeo.innerTrimLoopNum(); ++n2) {
                object = new ArrayList();
                for (n = 0; n < iSurfaceGeo.innerTrimNum(n2); ++n) {
                    ((ArrayList)object).add(iSurfaceGeo.innerTrim(n2, n).get());
                }
                arrayList.add((ArrayList<ITrimCurve>)object);
                arrayList2.add(BrepLoop.Type.Inner);
            }
            Brep.checkTrimLoopDirection(arrayList, arrayList2);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = new BrepLoop(this.loops.size(), this.faces.size() - 1, arrayList2.get(n2), this);
                this.loops.add(object);
                brepFace.addLoopIndex(this.loops.size() - 1);
                BrepVertex brepVertex = null;
                for (int i = 0; i < arrayList.get(n2).size(); ++i) {
                    ITrimCurve iTrimCurve = arrayList.get(n2).get(i);
                    NurbsCurve nurbsCurve = new NurbsCurve(iTrimCurve);
                    this.curves2.add(nurbsCurve);
                    ICurveGeo iCurveGeo = iTrimCurve.get3d();
                    this.icurves3.add(iCurveGeo);
                    NurbsCurve nurbsCurve2 = new NurbsCurve(iCurveGeo);
                    this.curves3.add(nurbsCurve2);
                    for (int j = 0; j < iCurveGeo.num(); ++j) {
                        iBoundingBox.compare(iCurveGeo.cp(j));
                    }
                    BrepVertex brepVertex2 = null;
                    if (i == 0) {
                        brepVertex2 = new BrepVertex(this.vertices.size(), iCurveGeo.start());
                        this.vertices.add(brepVertex2);
                        brepVertex = brepVertex2;
                    } else {
                        brepVertex2 = (BrepVertex)this.vertices.get(this.vertices.size() - 1);
                    }
                    BrepVertex brepVertex3 = null;
                    if (i < arrayList.get(n2).size() - 1) {
                        brepVertex3 = new BrepVertex(this.vertices.size(), iCurveGeo.end());
                        this.vertices.add(brepVertex3);
                    } else {
                        brepVertex3 = brepVertex;
                    }
                    Interval interval = nurbsCurve2.domain();
                    BrepEdge brepEdge = new BrepEdge(this.edges.size(), this.curves3.indexOf(nurbsCurve2), brepVertex2.vertexIndex, brepVertex3.vertexIndex, interval, interval, this);
                    this.edges.add(brepEdge);
                    Interval interval2 = nurbsCurve.domain();
                    BrepTrim brepTrim = new BrepTrim(this.trims.size(), this.curves2.size() - 1, this.edges.indexOf(brepEdge), brepVertex2.vertexIndex, brepVertex3.vertexIndex, this.loops.size() - 1, interval2, interval2, this, iTrimCurve);
                    this.trims.add(brepTrim);
                    ((BrepLoop)object).addTrimIndex(this.trims.size() - 1);
                    brepEdge.addTrimIndex(this.trims.size() - 1);
                    brepVertex2.addEdgeIndex(this.edges.size() - 1);
                    brepVertex3.addEdgeIndex(this.edges.size() - 1);
                }
            }
        }

        public static void checkTrimLoopDirection(ArrayList<ArrayList<ITrimCurve>> arrayList, ArrayList<BrepLoop.Type> arrayList2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ITrimCurveI[] iTrimCurveIArray = arrayList.get(i).toArray(new ITrimCurve[arrayList.get(i).size()]);
                ITrimLoopGraphic iTrimLoopGraphic = new ITrimLoopGraphic(iTrimCurveIArray, arrayList2.get(i) == BrepLoop.Type.Outer, 1);
                if (!iTrimLoopGraphic.reversed()) continue;
                ArrayList<ITrimCurve> arrayList3 = new ArrayList<ITrimCurve>();
                for (int j = 0; j < iTrimCurveIArray.length; ++j) {
                    arrayList3.add(((ITrimCurve)iTrimCurveIArray[iTrimCurveIArray.length - 1 - j]).rev());
                }
                arrayList.set(i, arrayList3);
            }
        }

        @Override
        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 2) {
                this.readOld200(rhino3dmFile, inputStream);
            } else if (n == 3) {
                Interval interval;
                Interval interval2;
                boolean bl;
                Geometry geometry;
                int n3;
                int n4 = 100;
                IOut.debug(n4, "read curves2");
                this.curves2 = new CurveArray();
                this.curves2.read(rhino3dmFile, inputStream);
                int n5 = this.curves2.size();
                IOut.debug(n4, "curves2Count = " + n5);
                IOut.debug(n4, "read curves3");
                this.curves3 = new CurveArray();
                this.curves3.read(rhino3dmFile, inputStream);
                int n6 = this.curves3.size();
                IOut.debug(n4, "curves3Count = " + n6);
                IOut.debug(n4, "read surface");
                this.surfaces = new SurfaceArray();
                this.surfaces.read(rhino3dmFile, inputStream);
                int n7 = this.surfaces.size();
                IOut.debug(n4, "surfacesCount = " + n7);
                IOut.debug(n4, "read vertices");
                this.vertices = new BrepVertexArray();
                this.vertices.read(rhino3dmFile, inputStream);
                IOut.debug(n4, "verticesCount = " + this.vertices.size());
                IOut.debug(n4, "read edges");
                this.edges = new BrepEdgeArray();
                this.edges.read(rhino3dmFile, inputStream);
                IOut.debug(n4, "edgeCount = " + this.edges.size());
                for (n3 = 0; n3 < this.edges.size(); ++n3) {
                    geometry = (BrepEdge)this.edges.get(n3);
                    ((BrepEdge)geometry).brep = this;
                    if (((BrepEdge)geometry).curve3Index < 0 || ((BrepEdge)geometry).curve3Index >= n6) continue;
                    bl = ((CurveProxy)geometry).proxyCurveIsReversed();
                    interval2 = ((CurveProxy)geometry).proxyCurveDomain();
                    interval = ((CurveProxy)geometry).domain();
                    ((CurveProxy)geometry).setProxyCurve((Curve)this.curves3.get(((BrepEdge)geometry).curve3Index), interval2);
                    if (bl) {
                        ((CurveProxy)geometry).reverse();
                    }
                    ((CurveProxy)geometry).setDomain(interval);
                }
                IOut.debug(n4, "read trims");
                this.trims = new BrepTrimArray();
                this.trims.read(rhino3dmFile, inputStream);
                IOut.debug(n4, "trimCount = " + this.trims.size());
                for (n3 = 0; n3 < this.trims.size(); ++n3) {
                    geometry = (BrepTrim)this.trims.get(n3);
                    ((BrepTrim)geometry).brep = this;
                    if (((BrepTrim)geometry).curve2Index < 0 || ((BrepTrim)geometry).curve2Index >= n5) continue;
                    bl = ((CurveProxy)geometry).proxyCurveIsReversed();
                    interval2 = ((CurveProxy)geometry).proxyCurveDomain();
                    interval = ((CurveProxy)geometry).domain();
                    ((CurveProxy)geometry).setProxyCurve((Curve)this.curves2.get(((BrepTrim)geometry).curve2Index), interval2);
                    if (bl) {
                        ((CurveProxy)geometry).reverse();
                    }
                    ((CurveProxy)geometry).setDomain(interval);
                }
                IOut.debug(n4, "read loops");
                this.loops = new BrepLoopArray();
                this.loops.read(rhino3dmFile, inputStream);
                IOut.debug(n4, "loopCount=" + this.loops.size());
                for (n3 = 0; n3 < this.loops.size(); ++n3) {
                    ((BrepLoop)this.loops.get((int)n3)).brep = this;
                }
                IOut.debug(n4, "read faces");
                this.faces = new BrepFaceArray();
                this.faces.read(rhino3dmFile, inputStream);
                IOut.debug(n4, "facesCount=" + this.faces.size());
                for (n3 = 0; n3 < this.faces.size(); ++n3) {
                    geometry = (BrepFace)this.faces.get(n3);
                    ((BrepFace)geometry).brep = this;
                    if (((BrepFace)geometry).surfaceIndex < 0 || ((BrepFace)geometry).surfaceIndex >= n7) continue;
                    ((SurfaceProxy)geometry).setProxySurface((Surface)this.surfaces.get(((BrepFace)geometry).surfaceIndex));
                }
                this.bbox = new BoundingBox();
                this.bbox.min = IRhino3dmImporter.readPoint3(inputStream);
                this.bbox.max = IRhino3dmImporter.readPoint3(inputStream);
            }
        }

        public void readOld200(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int n = IRhino3dmImporter.readInt(inputStream);
            int n2 = IRhino3dmImporter.readInt(inputStream);
            int n3 = IRhino3dmImporter.readInt(inputStream);
            int n4 = IRhino3dmImporter.readInt(inputStream);
            int n5 = IRhino3dmImporter.readInt(inputStream);
            this.bbox.min = IRhino3dmImporter.readPoint3(inputStream);
            this.bbox.max = IRhino3dmImporter.readPoint3(inputStream);
            this.curves2 = new CurveArray(n4);
            for (int i = 0; i < n4; ++i) {
                PolyCurve polyCurve = new PolyCurve();
                polyCurve.read(rhino3dmFile, inputStream);
            }
        }

        @Override
        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            int n;
            IRhino3dmExporter.writeChunkVersion(outputStream, 3, 2, cRC32);
            this.curves2.write(rhino3dmFile, outputStream, cRC32);
            this.curves3.write(rhino3dmFile, outputStream, cRC32);
            this.surfaces.write(rhino3dmFile, outputStream, cRC32);
            this.vertices.write(rhino3dmFile, outputStream, cRC32);
            this.edges.write(rhino3dmFile, outputStream, cRC32);
            this.trims.write(rhino3dmFile, outputStream, cRC32);
            this.loops.write(rhino3dmFile, outputStream, cRC32);
            this.faces.write(rhino3dmFile, outputStream, cRC32);
            IRhino3dmExporter.writePoint(outputStream, this.bbox.min, cRC32);
            IRhino3dmExporter.writePoint(outputStream, this.bbox.max, cRC32);
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            byte by = 0;
            for (n = 0; n < this.faces.size(); ++n) {
                IRhino3dmExporter.writeByte(chunkOutputStream, by, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
            chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            by = 0;
            for (n = 0; n < this.faces.size(); ++n) {
                IRhino3dmExporter.writeByte(chunkOutputStream, by, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
            IRhino3dmExporter.writeInt(outputStream, this.isSolid, cRC32);
        }

        public BrepLoopArray getLoopsForFace(int n) {
            BrepLoopArray brepLoopArray = new BrepLoopArray();
            for (int i = 0; i < this.loops.size(); ++i) {
                if (((BrepLoop)this.loops.get((int)i)).faceIndex != n) continue;
                brepLoopArray.add(this.loops.get(i));
            }
            return brepLoopArray;
        }

        public BrepTrimArray getTrimsForLoop(BrepLoop brepLoop) {
            BrepTrimArray brepTrimArray = new BrepTrimArray();
            for (int i = 0; i < brepLoop.trimIndex.size(); ++i) {
                int n = brepLoop.trimIndex.get(i);
                if (n >= 0 && n < this.trims.size()) {
                    brepTrimArray.add(this.trims.get(n));
                    continue;
                }
                IOut.err("trimIndex is out of range: " + n);
            }
            return brepTrimArray;
        }

        public CurveArray getCurves2ForLoop(BrepLoop brepLoop) {
            BrepTrimArray brepTrimArray = this.getTrimsForLoop(brepLoop);
            CurveArray curveArray = new CurveArray();
            for (int i = 0; i < brepTrimArray.size(); ++i) {
                int n = ((BrepTrim)brepTrimArray.get((int)i)).curve2Index;
                if (n >= 0 && n < this.curves2.size()) {
                    curveArray.add(this.curves2.get(n));
                    continue;
                }
                IOut.err("curve2Index is out of range: " + n);
            }
            return curveArray;
        }

        public ArrayList<ITrimCurve> getTrimCurvesForLoop(BrepLoop brepLoop, Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            CurveArray curveArray = this.getCurves2ForLoop(brepLoop);
            ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
            for (int i = 0; i < curveArray.size(); ++i) {
                ITrimCurve iTrimCurve = ((Curve)curveArray.get(i)).createTrimCurve(rhino3dmFile, iServerI, iSurfaceI);
                if (iTrimCurve != null) {
                    iTrimCurve.normalizeControlPoints(iSurfaceI);
                    arrayList.add(iTrimCurve);
                    continue;
                }
                IOut.err("failed to create trim curve ");
            }
            return arrayList;
        }

        @Override
        public IObject createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            ArrayList<ISurfaceGeo> arrayList = new ArrayList<ISurfaceGeo>();
            for (int i = 0; i < this.faces.size(); ++i) {
                BrepFace brepFace = (BrepFace)this.faces.get(i);
                if (brepFace.faceIndex >= 0 && brepFace.faceIndex < this.surfaces.size()) {
                    ISurfaceGeo iSurfaceGeo = ((Surface)this.surfaces.get(brepFace.faceIndex)).createIGGeometry(rhino3dmFile, iServerI);
                    if (iSurfaceGeo != null) {
                        BrepLoopArray brepLoopArray = this.getLoopsForFace(brepFace.faceIndex);
                        for (int j = 0; j < brepLoopArray.size(); ++j) {
                            ArrayList<ITrimCurve> arrayList2 = this.getTrimCurvesForLoop((BrepLoop)brepLoopArray.get(j), rhino3dmFile, iServerI, iSurfaceGeo);
                            if (arrayList2.size() > 0) {
                                switch (((BrepLoop)brepLoopArray.get((int)j)).type) {
                                    case Inner: {
                                        iSurfaceGeo.addInnerTrimLoop(arrayList2.toArray(new ITrimCurve[arrayList2.size()]));
                                        break;
                                    }
                                    case Outer: {
                                        iSurfaceGeo.addOuterTrimLoop(arrayList2.toArray(new ITrimCurve[arrayList2.size()]));
                                        break;
                                    }
                                    default: {
                                        IOut.err("trim loop type is invalid : " + (Object)((Object)((BrepLoop)brepLoopArray.get((int)j)).type));
                                        break;
                                    }
                                }
                                continue;
                            }
                            IOut.err("no trim found for BrepLoop: BrepLoop.Type = " + (Object)((Object)((BrepLoop)brepLoopArray.get((int)j)).type));
                        }
                        arrayList.add(iSurfaceGeo);
                        continue;
                    }
                    IOut.err("failed to instantiate: @ " + this.surfaces.get(brepFace.faceIndex));
                    continue;
                }
                IOut.err("BrepFace faceIndex is out of range: " + brepFace.faceIndex);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            if (arrayList.size() == 1) {
                return new ISurface(iServerI, (ISurfaceGeo)arrayList.get(0));
            }
            return new IBrep(iServerI, arrayList.toArray(new ISurfaceGeo[arrayList.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrepFaceArray
    extends ArrayList<BrepFace> {
        public BrepFaceArray() {
        }

        public BrepFaceArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            if (n == 1) {
                int n2 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n2; ++i) {
                    BrepFace brepFace = new BrepFace();
                    brepFace.read(rhino3dmFile, inputStream);
                    this.add(brepFace);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            int n;
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 1, chunkOutputStream.getCRC());
            int n2 = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n2, chunkOutputStream.getCRC());
            for (n = 0; n < n2; ++n) {
                ((BrepFace)this.get(n)).write(rhino3dmFile, chunkOutputStream, chunkOutputStream.getCRC());
            }
            for (n = 0; n < n2; ++n) {
                IRhino3dmExporter.writeUUID(chunkOutputStream, ((BrepFace)this.get((int)n)).faceUUID, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrepLoopArray
    extends ArrayList<BrepLoop> {
        public BrepLoopArray() {
        }

        public BrepLoopArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            if (n == 1) {
                int n2 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n2; ++i) {
                    BrepLoop brepLoop = new BrepLoop();
                    brepLoop.read(rhino3dmFile, inputStream);
                    this.add(brepLoop);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 0, chunkOutputStream.getCRC());
            int n = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                ((BrepLoop)this.get(i)).write(rhino3dmFile, chunkOutputStream, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrepTrimArray
    extends ArrayList<BrepTrim> {
        public BrepTrimArray() {
        }

        public BrepTrimArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n3; ++i) {
                    BrepTrim brepTrim = new BrepTrim();
                    brepTrim.read(rhino3dmFile, inputStream);
                    this.add(brepTrim);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 0, chunkOutputStream.getCRC());
            int n = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                ((BrepTrim)this.get(i)).write(rhino3dmFile, chunkOutputStream, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrepEdgeArray
    extends ArrayList<BrepEdge> {
        public BrepEdgeArray() {
        }

        public BrepEdgeArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n3; ++i) {
                    BrepEdge brepEdge = new BrepEdge();
                    brepEdge.read(rhino3dmFile, inputStream);
                    this.add(brepEdge);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 0, chunkOutputStream.getCRC());
            int n = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                ((BrepEdge)this.get(i)).write(rhino3dmFile, chunkOutputStream, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrepVertexArray
    extends ArrayList<BrepVertex> {
        public BrepVertexArray() {
        }

        public BrepVertexArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n3; ++i) {
                    BrepVertex brepVertex = new BrepVertex();
                    brepVertex.read(rhino3dmFile, inputStream);
                    this.add(brepVertex);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 0, chunkOutputStream.getCRC());
            int n = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                ((BrepVertex)this.get(i)).write(rhino3dmFile, chunkOutputStream, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SurfaceArray
    extends ArrayList<Surface> {
        public SurfaceArray() {
        }

        public SurfaceArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n3; ++i) {
                    int n4 = IRhino3dmImporter.readInt(inputStream);
                    if (n4 != 1) continue;
                    RhinoObject rhinoObject = IRhino3dmImporter.readObject(rhino3dmFile, inputStream);
                    if (rhinoObject == null) {
                        throw new IOException("instance is null");
                    }
                    if (rhinoObject instanceof Surface) {
                        this.add((Surface)rhinoObject);
                        continue;
                    }
                    throw new IOException("invalid class of instance: " + rhinoObject);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 0, chunkOutputStream.getCRC());
            int n = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                if (this.get(i) != null) {
                    IRhino3dmExporter.writeInt32(chunkOutputStream, 1, chunkOutputStream.getCRC());
                    Chunk chunk = IRhino3dmExporter.getObjectChunk(rhino3dmFile, (RhinoObject)this.get(i));
                    IRhino3dmExporter.writeChunk(chunkOutputStream, chunk);
                    continue;
                }
                IRhino3dmExporter.writeInt32(chunkOutputStream, 0, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurveArray
    extends ArrayList<Curve> {
        public CurveArray() {
        }

        public CurveArray(int n) {
            super(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.header != 0x40008000) {
                throw new IOException("invalid type code = " + IRhino3dm.hex(chunk.header));
            }
            inputStream = new ByteArrayInputStream(chunk.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                int n3 = IRhino3dmImporter.readInt(inputStream);
                for (int i = 0; i < n3; ++i) {
                    int n4 = IRhino3dmImporter.readInt(inputStream);
                    if (n4 != 1) continue;
                    RhinoObject rhinoObject = IRhino3dmImporter.readObject(rhino3dmFile, inputStream);
                    if (rhinoObject == null) {
                        throw new IOException("instance is null");
                    }
                    if (rhinoObject instanceof Curve) {
                        this.add((Curve)rhinoObject);
                        continue;
                    }
                    throw new IOException("invalid class of instance: " + rhinoObject);
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000);
            IRhino3dmExporter.writeChunkVersion(chunkOutputStream, 1, 0, chunkOutputStream.getCRC());
            int n = this.size();
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                if (this.get(i) != null) {
                    IRhino3dmExporter.writeInt32(chunkOutputStream, 1, chunkOutputStream.getCRC());
                    Chunk chunk = IRhino3dmExporter.getObjectChunk(rhino3dmFile, (RhinoObject)this.get(i));
                    IRhino3dmExporter.writeChunk(chunkOutputStream, chunk);
                    continue;
                }
                IRhino3dmExporter.writeInt32(chunkOutputStream, 0, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    public static class BrepFace
    extends SurfaceProxy {
        public static final String uuid = "60B5DBC4-E660-11d3-BFE4-0010830122F0";
        public int faceIndex;
        public ArrayList<Integer> loopIndex;
        public int surfaceIndex;
        public boolean rev;
        public int faceMaterialChannel;
        public UUID faceUUID;
        public BoundingBox bbox;
        public Interval[] domain;
        public Mesh renderMesh;
        public Mesh analysisMesh;
        public Mesh previewMesh;
        public Brep brep;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public BrepFace() {
        }

        public BrepFace(int n, int n2, Surface surface, Brep brep) {
            this.faceIndex = n;
            this.surfaceIndex = n2;
            this.brep = brep;
            this.loopIndex = new ArrayList();
            this.faceUUID = surface.getClassUUID();
            this.domain = new Interval[2];
            this.domain[0] = surface.domain(0);
            this.domain[1] = surface.domain(1);
            this.rev = false;
            this.faceMaterialChannel = 0;
        }

        public void addLoopIndex(int n) {
            this.loopIndex.add(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            this.faceIndex = IRhino3dmImporter.readInt(inputStream);
            this.loopIndex = IRhino3dmImporter.readArrayInt(inputStream);
            this.surfaceIndex = IRhino3dmImporter.readInt(inputStream);
            this.rev = IRhino3dmImporter.readInt(inputStream) != 0;
            this.faceMaterialChannel = IRhino3dmImporter.readInt(inputStream);
            if (this.faceMaterialChannel < 0) {
                this.faceMaterialChannel = 0;
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeInt32(outputStream, this.faceIndex, cRC32);
            IRhino3dmExporter.writeArrayInt(outputStream, this.loopIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.surfaceIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.rev ? 1 : 0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.faceMaterialChannel, cRC32);
        }
    }

    public static class BrepLoop
    extends Geometry {
        public static final String uuid = "60B5DBC3-E660-11d3-BFE4-0010830122F0";
        public int loopIndex;
        public ArrayList<Integer> trimIndex;
        public Type type;
        public int faceIndex;
        public BoundingBox pbox;
        public Brep brep;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public BrepLoop() {
        }

        public BrepLoop(int n, int n2, Type type, Brep brep) {
            this.loopIndex = n;
            this.faceIndex = n2;
            this.trimIndex = new ArrayList();
            this.type = type;
            this.brep = brep;
        }

        public void addTrimIndex(int n) {
            this.trimIndex.add(n);
        }

        public static Type readType(int n) {
            switch (n) {
                case 0: {
                    return Type.Unknown;
                }
                case 1: {
                    return Type.Outer;
                }
                case 2: {
                    return Type.Inner;
                }
                case 3: {
                    return Type.Slit;
                }
                case 4: {
                    return Type.CrvOnSrf;
                }
                case 5: {
                    return Type.PtOnSrf;
                }
            }
            return Type.Unknown;
        }

        public static int getInt(Type type) {
            switch (type) {
                case Unknown: {
                    return 0;
                }
                case Outer: {
                    return 1;
                }
                case Inner: {
                    return 2;
                }
                case Slit: {
                    return 3;
                }
                case CrvOnSrf: {
                    return 4;
                }
                case PtOnSrf: {
                    return 5;
                }
            }
            return 0;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            this.loopIndex = IRhino3dmImporter.readInt(inputStream);
            this.trimIndex = IRhino3dmImporter.readArrayInt(inputStream);
            this.type = BrepLoop.readType(IRhino3dmImporter.readInt(inputStream));
            this.faceIndex = IRhino3dmImporter.readInt(inputStream);
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeInt32(outputStream, this.loopIndex, cRC32);
            IRhino3dmExporter.writeArrayInt(outputStream, this.trimIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, BrepLoop.getInt(this.type), cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.faceIndex, cRC32);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            Unknown,
            Outer,
            Inner,
            Slit,
            CrvOnSrf,
            PtOnSrf,
            TypeCount;

        }
    }

    public static class BrepTrim
    extends CurveProxy {
        public static final String uuid = "60B5DBC2-E660-11d3-BFE4-0010830122F0";
        public static final int force32BitTrimType = -1;
        public int trimIndex;
        public int curve2Index;
        public int edgeIndex;
        public int[] vertexIndex;
        public boolean rev3d;
        public Type type;
        public Surface.ISO iso;
        public int loopIndex;
        public double[] tolerance;
        public double legacy2dTol;
        public double legacy3dTol;
        public Brep brep;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public BrepTrim() {
        }

        public BrepTrim(int n, int n2, int n3, int n4, int n5, int n6, Interval interval, Interval interval2, Brep brep, ITrimCurve iTrimCurve) {
            this.trimIndex = n;
            this.curve2Index = n2;
            this.edgeIndex = n3;
            this.vertexIndex = new int[2];
            this.vertexIndex[0] = n4;
            this.vertexIndex[1] = n5;
            this.rev3d = false;
            this.type = Type.Boundary;
            this.loopIndex = n6;
            this.tolerance = new double[2];
            this.tolerance[0] = 0.0;
            this.tolerance[1] = 0.0;
            this.legacy2dTol = 0.0;
            this.legacy3dTol = 0.0;
            this.iso = this.getISOType(iTrimCurve);
            this.setProxyCurveDomain(interval);
            this.setDomain(interval2);
            this.brep = brep;
        }

        public Surface.ISO getISOType(ITrimCurve iTrimCurve) {
            if (this.isStraightOnX(iTrimCurve)) {
                if (iTrimCurve.num() == 2) {
                    if (iTrimCurve.cp((int)0).y == 0.0) {
                        return Surface.ISO.SIso;
                    }
                    if (iTrimCurve.cp((int)0).y == 1.0) {
                        return Surface.ISO.NIso;
                    }
                }
                return Surface.ISO.XIso;
            }
            if (this.isStraightOnY(iTrimCurve)) {
                if (iTrimCurve.num() == 2) {
                    if (iTrimCurve.cp((int)0).x == 0.0) {
                        return Surface.ISO.WIso;
                    }
                    if (iTrimCurve.cp((int)0).x == 1.0) {
                        return Surface.ISO.EIso;
                    }
                }
                return Surface.ISO.YIso;
            }
            return Surface.ISO.NotIso;
        }

        public boolean isStraightOnX(ITrimCurve iTrimCurve) {
            for (int i = 1; i < iTrimCurve.num(); ++i) {
                if (iTrimCurve.cp(0).eqY(iTrimCurve.cp(i))) continue;
                return false;
            }
            return true;
        }

        public boolean isStraightOnY(ITrimCurve iTrimCurve) {
            for (int i = 1; i < iTrimCurve.num(); ++i) {
                if (iTrimCurve.cp(0).eqX(iTrimCurve.cp(i))) continue;
                return false;
            }
            return true;
        }

        public static Type readType(int n) {
            switch (n) {
                case 0: {
                    return Type.Unknown;
                }
                case 1: {
                    return Type.Boundary;
                }
                case 2: {
                    return Type.Mated;
                }
                case 3: {
                    return Type.Seam;
                }
                case 4: {
                    return Type.Singular;
                }
                case 5: {
                    return Type.CrvOnSrf;
                }
                case 6: {
                    return Type.PtOnSrf;
                }
                case 7: {
                    return Type.Slit;
                }
            }
            return Type.Unknown;
        }

        public static int getInt(Type type) {
            switch (type) {
                case Unknown: {
                    return 0;
                }
                case Boundary: {
                    return 1;
                }
                case Mated: {
                    return 2;
                }
                case Seam: {
                    return 3;
                }
                case Singular: {
                    return 4;
                }
                case CrvOnSrf: {
                    return 5;
                }
                case PtOnSrf: {
                    return 6;
                }
                case Slit: {
                    return 7;
                }
            }
            return 0;
        }

        public boolean reverse() {
            super.reverse();
            this.rev3d = !this.rev3d;
            return true;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            this.trimIndex = IRhino3dmImporter.readInt(inputStream);
            this.curve2Index = IRhino3dmImporter.readInt(inputStream);
            Interval interval = IRhino3dmImporter.readInterval(inputStream);
            this.setProxyCurveDomain(interval);
            this.setDomain(interval);
            this.edgeIndex = IRhino3dmImporter.readInt(inputStream);
            this.vertexIndex = new int[2];
            this.vertexIndex[0] = IRhino3dmImporter.readInt(inputStream);
            this.vertexIndex[1] = IRhino3dmImporter.readInt(inputStream);
            this.rev3d = IRhino3dmImporter.readInt(inputStream) != 0;
            this.type = BrepTrim.readType(IRhino3dmImporter.readInt(inputStream));
            this.iso = Surface.readIso(IRhino3dmImporter.readInt(inputStream));
            this.loopIndex = IRhino3dmImporter.readInt(inputStream);
            this.tolerance = new double[2];
            this.tolerance[0] = IRhino3dmImporter.readDouble(inputStream);
            this.tolerance[1] = IRhino3dmImporter.readDouble(inputStream);
            if (rhino3dmFile.version >= 3 && rhino3dmFile.openNurbsVersion >= 200206180) {
                Interval interval2 = this.proxyCurveDomain();
                try {
                    interval2 = IRhino3dmImporter.readInterval(inputStream);
                }
                catch (IOException iOException) {
                    interval2 = this.proxyCurveDomain();
                }
                boolean bl = false;
                byte[] byArray = IRhino3dmImporter.readBytes(inputStream, 8);
                if (byArray[0] == 1) {
                    bl = true;
                }
                byArray = IRhino3dmImporter.readBytes(inputStream, 24);
                if (bl) {
                    this.reverse();
                }
                this.setDomain(interval2);
            } else {
                IVec iVec = IRhino3dmImporter.readPoint3(inputStream);
                IVec iVec2 = IRhino3dmImporter.readPoint3(inputStream);
            }
            this.legacy2dTol = IRhino3dmImporter.readDouble(inputStream);
            this.legacy3dTol = IRhino3dmImporter.readDouble(inputStream);
            IOut.debug(200, "trimIndex = " + this.trimIndex);
            IOut.debug(200, "curve2Index = " + this.curve2Index);
            IOut.debug(200, "thisDomain = " + this.thisDomain);
            IOut.debug(200, "realCurveDomain = " + this.realCurveDomain);
            IOut.debug(200, "edgeIndex = " + this.edgeIndex);
            IOut.debug(200, "vertexIndex = " + this.vertexIndex[0] + ", " + this.vertexIndex[1]);
            IOut.debug(200, "rev3d = " + this.rev3d);
            IOut.debug(200, "type = " + (Object)((Object)this.type));
            IOut.debug(200, "iso = " + (Object)((Object)this.iso));
            IOut.debug(200, "loopIndex = " + this.loopIndex);
            IOut.debug(200, "tolerance = " + this.tolerance);
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeInt32(outputStream, this.trimIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.curve2Index, cRC32);
            IRhino3dmExporter.writeInterval(outputStream, this.proxyCurveDomain(), cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.edgeIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.vertexIndex[0], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.vertexIndex[1], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.rev3d ? 1 : 0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, BrepTrim.getInt(this.type), cRC32);
            IRhino3dmExporter.writeInt32(outputStream, Surface.getInt(this.iso), cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.loopIndex, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.tolerance[0], cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.tolerance[1], cRC32);
            if (rhino3dmFile.version < 3) {
                IVec iVec = new IVec(0.0, 0.0, 0.0);
                IRhino3dmExporter.writePoint(outputStream, iVec, cRC32);
                IRhino3dmExporter.writePoint(outputStream, iVec, cRC32);
            } else {
                int n;
                IRhino3dmExporter.writeInterval(outputStream, this.domain(), cRC32);
                byte by = this.proxyCurveIsReversed() ? (byte)1 : 0;
                IRhino3dmExporter.writeByte(outputStream, by, cRC32);
                for (n = 0; n < 7; ++n) {
                    IRhino3dmExporter.writeByte(outputStream, (byte)0, cRC32);
                }
                for (n = 0; n < 24; ++n) {
                    IRhino3dmExporter.writeByte(outputStream, (byte)0, cRC32);
                }
            }
            IRhino3dmExporter.writeDouble(outputStream, this.legacy2dTol, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.legacy3dTol, cRC32);
        }

        public String toString() {
            return "trimIndex = " + this.trimIndex + "\n" + "curve2Index = " + this.curve2Index + "\n" + "edgeIndex = " + this.edgeIndex + "\n" + "vertexIndex[0] = " + this.vertexIndex[0] + "\n" + "vertexIndex[1] = " + this.vertexIndex[1] + "\n" + "rev3d = " + this.rev3d + "\n" + "type = " + (Object)((Object)this.type) + "\n" + "iso = " + (Object)((Object)this.iso) + "\n" + "loopIndex = " + this.loopIndex + "\n" + "tolerance[0] = " + this.tolerance[0] + "\n" + "tolerance[1] = " + this.tolerance[1] + "\n" + "legacy2dTol = " + this.legacy2dTol + "\n" + "legacy3dTol = " + this.legacy3dTol + "\n" + "brep = " + this.brep;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            Unknown,
            Boundary,
            Mated,
            Seam,
            Singular,
            CrvOnSrf,
            PtOnSrf,
            Slit,
            TrimTypeCount;

        }
    }

    public static class BrepTrimPoint {
        public IVec2 p;
        public double t;
        public double e;
    }

    public static class BrepEdge
    extends CurveProxy {
        public static final String uuid = "60B5DBC1-E660-11d3-BFE4-0010830122F0";
        public int edgeIndex;
        public int curve3Index;
        public int[] vertexIndex;
        public ArrayList<Integer> trimIndex;
        public double tolerance;
        public Brep brep;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 4;
        }

        public BrepEdge() {
        }

        public BrepEdge(int n, int n2, int n3, int n4, Interval interval, Interval interval2, Brep brep) {
            this.edgeIndex = n;
            this.curve3Index = n2;
            this.vertexIndex = new int[2];
            this.vertexIndex[0] = n3;
            this.vertexIndex[1] = n4;
            this.brep = brep;
            this.trimIndex = new ArrayList();
            this.tolerance = 0.0;
            this.setProxyCurveDomain(interval);
            this.setDomain(interval2);
        }

        public void addTrimIndex(int n) {
            this.trimIndex.add(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            this.edgeIndex = IRhino3dmImporter.readInt(inputStream);
            this.curve3Index = IRhino3dmImporter.readInt(inputStream);
            int n = IRhino3dmImporter.readInt(inputStream);
            Interval interval = IRhino3dmImporter.readInterval(inputStream);
            this.vertexIndex = new int[2];
            this.vertexIndex[0] = IRhino3dmImporter.readInt(inputStream);
            this.vertexIndex[1] = IRhino3dmImporter.readInt(inputStream);
            this.trimIndex = IRhino3dmImporter.readArrayInt(inputStream);
            this.tolerance = IRhino3dmImporter.readDouble(inputStream);
            Interval interval2 = interval;
            if (rhino3dmFile.version >= 3 && rhino3dmFile.openNurbsVersion >= 200206180) {
                try {
                    interval2 = IRhino3dmImporter.readInterval(inputStream);
                }
                catch (IOException iOException) {
                    interval2 = interval;
                }
            }
            this.setProxyCurve(null, interval);
            if (n != 0) {
                this.reverse();
            }
            this.setDomain(interval2);
            IOut.debug(200, "edgeIndex = " + this.edgeIndex);
            IOut.debug(200, "curve3Index = " + this.curve3Index);
            IOut.debug(200, "vertexIndex = " + this.vertexIndex[0] + ", " + this.vertexIndex[1]);
            IOut.debug(200, "trimIndex = " + this.trimIndex);
            IOut.debug(200, "tolerance = " + this.tolerance);
            IOut.debug(200, "domain = " + this.domain());
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeInt32(outputStream, this.edgeIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.curve3Index, cRC32);
            int n = this.proxyCurveIsReversed() ? 1 : 0;
            IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
            IRhino3dmExporter.writeInterval(outputStream, this.proxyCurveDomain(), cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.vertexIndex[0], cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.vertexIndex[1], cRC32);
            IRhino3dmExporter.writeArrayInt(outputStream, this.trimIndex, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.tolerance, cRC32);
            if (rhino3dmFile.version >= 4) {
                IRhino3dmExporter.writeInterval(outputStream, this.domain(), cRC32);
            }
        }
    }

    public static class BrepVertex
    extends Point {
        public static final String uuid = "60B5DBC0-E660-11d3-BFE4-0010830122F0";
        public int vertexIndex;
        public ArrayList<Integer> edgeIndex;
        public double tolerance;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public BrepVertex() {
        }

        public BrepVertex(int n, IVec iVec) {
            super(iVec);
            this.vertexIndex = n;
            this.edgeIndex = new ArrayList();
            this.tolerance = 0.0;
        }

        public void addEdgeIndex(int n) {
            this.edgeIndex.add(n);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            this.vertexIndex = IRhino3dmImporter.readInt(inputStream);
            this.point = IRhino3dmImporter.readPoint3(inputStream);
            this.edgeIndex = IRhino3dmImporter.readArrayInt(inputStream);
            this.tolerance = IRhino3dmImporter.readDouble(inputStream);
            IOut.debug(200, "vertexIndex = " + this.vertexIndex);
            IOut.debug(200, "point = " + this.point);
            String string = "";
            for (int i = 0; i < this.edgeIndex.size(); ++i) {
                string = string + this.edgeIndex.get(i) + ", ";
            }
            IOut.debug(200, "edgeIndex = " + string);
            IOut.debug(200, "tolerance = " + this.tolerance);
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeInt32(outputStream, this.vertexIndex, cRC32);
            IRhino3dmExporter.writePoint(outputStream, this.point, cRC32);
            IRhino3dmExporter.writeArrayInt(outputStream, this.edgeIndex, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.tolerance, cRC32);
        }
    }

    public static class WindowsBitmapEx
    extends WindowsBitmap {
        public static final String uuid = "203AFC17-BCC9-44fb-A07B-7F5C31BD5ED9";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class EmbeddedBitmap
    extends Bitmap {
        public static final String uuid = "772E6FC1-B17B-4fc4-8F54-5FDA511D76D2";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class WindowsBitmap
    extends Bitmap {
        public static final String uuid = "390465EB-3721-11d4-800B-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class Extrusion
    extends Surface {
        public static final String uuid = "36F53175-72B8-4d47-BF1F-B4E6FC24F4B9";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0x40000000;
        }
    }

    public static class ArcCurve
    extends Curve {
        public static final String uuid = "CF33BE2A-09B4-11d4-BFFB-0010830122F0";
        public Arc arc;
        public Interval t;
        public int dim;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public Interval domain() {
            return this.t;
        }

        public boolean isValid() {
            if (!this.t.isIncreasing()) {
                return false;
            }
            return this.arc.isValid();
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                this.arc = IRhino3dmImporter.readArc(inputStream);
                this.t = IRhino3dmImporter.readInterval(inputStream);
                this.dim = IRhino3dmImporter.readInt(inputStream);
                if (this.dim != 2 && this.dim != 3) {
                    this.dim = 3;
                }
            }
        }

        public ICurve createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            IVec iVec = this.arc.plane.origin;
            IVec iVec2 = this.arc.plane.zaxis;
            if (Math.abs(this.arc.angle.length()) < Math.PI * 2 - IConfig.angleResolution) {
                IVec iVec3 = this.arc.plane.xaxis.dup().len(this.arc.radius).add(iVec);
                iVec3.rot(iVec, iVec2, this.arc.angle.v1);
                double d = this.arc.angle.v2 - this.arc.angle.v1;
                IArc iArc = new IArc(iServerI, (IVecI)iVec, (IVecI)iVec2, (IVecI)iVec3, d);
                return iArc;
            }
            IVec iVec4 = this.arc.plane.xaxis;
            ICircle iCircle = new ICircle(iServerI, (IVecI)iVec, (IVecI)iVec2, (IVecI)iVec4, this.arc.radius);
            return iCircle;
        }

        public ICurveGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            IVec iVec = this.arc.plane.origin;
            IVec iVec2 = this.arc.plane.zaxis;
            if (Math.abs(this.arc.angle.length()) < Math.PI * 2 - IConfig.angleResolution) {
                IVec iVec3 = this.arc.plane.xaxis.dup().len(this.arc.radius).add(iVec);
                iVec3.rot(iVec, iVec2, this.arc.angle.v1);
                double d = this.arc.angle.v2 - this.arc.angle.v1;
                IArcGeo iArcGeo = new IArcGeo((IVecI)iVec, (IVecI)iVec2, (IVecI)iVec3, d);
                return iArcGeo;
            }
            IVec iVec4 = this.arc.plane.xaxis;
            ICircleGeo iCircleGeo = new ICircleGeo((IVecI)iVec, (IVecI)iVec2, (IVecI)iVec4, this.arc.radius);
            return iCircleGeo;
        }

        public ITrimCurve createTrimCurve(Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            IVec iVec = this.arc.plane.origin;
            IVec iVec2 = this.arc.plane.zaxis;
            if (Math.abs(this.arc.angle.length()) < Math.PI * 2 - IConfig.angleResolution) {
                IVec iVec3 = this.arc.plane.xaxis.dup().len(this.arc.radius).add(iVec);
                iVec3.rot(iVec, iVec2, this.arc.angle.v1);
                double d = this.arc.angle.v2 - this.arc.angle.v1;
                IArcGeo iArcGeo = new IArcGeo((IVecI)iVec, (IVecI)iVec2, (IVecI)iVec3, d);
                return new ITrimCurve(iArcGeo);
            }
            IVec iVec4 = this.arc.plane.xaxis;
            ICircleGeo iCircleGeo = new ICircleGeo((IVecI)iVec, (IVecI)iVec2, (IVecI)iVec4, this.arc.radius);
            return new ITrimCurve(iCircleGeo);
        }
    }

    public static class Arc
    extends Circle {
        public Interval angle;

        public boolean isValid() {
            return super.isValid() && this.angle.isValid() && this.angleRadians() >= 0.0 && this.angleRadians() <= Math.PI * 2;
        }

        public double angleRadians() {
            return this.angle.v2 - this.angle.v1;
        }

        public Interval domain() {
            return this.angle;
        }
    }

    public static class Circle {
        public Plane plane;
        public double radius;

        public boolean isValid() {
            return this.radius > 0.0 && this.plane.isValid();
        }
    }

    public static class Plane {
        public IVec origin;
        public IVec xaxis;
        public IVec yaxis;
        public IVec zaxis;
        public PlaneEquation planeEquation;

        public boolean isValid() {
            return true;
        }

        public String toString() {
            return "orig=" + this.origin + ", x=" + this.xaxis + ", y=" + this.yaxis + ", z=" + this.zaxis + ", eq=" + this.planeEquation;
        }
    }

    public static class PlaneEquation {
        public double x;
        public double y;
        public double z;
        public double d;

        public String toString() {
            return "plane equation {" + this.x + "," + this.y + "," + this.z + "," + this.d + "}";
        }
    }

    public static class AngularDimension2Extra
    extends UserData {
        public static final String uuid = "A68B151F-C778-4a6e-BCB4-23DDD1835677";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class OrdinateDimension2
    extends Annotation2 {
        public static final String uuid = "C8288D69-5BD8-4f50-9BAF-525A0086B0C3";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class TextDot
    extends Geometry {
        public static final String uuid = "74198302-CDF4-4f95-9609-6D684F22AB37";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 8192;
        }
    }

    public static class Leader2
    extends Annotation2 {
        public static final String uuid = "14922B7A-5B65-4f11-8345-D415A9637129";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class TextEntity2
    extends Annotation2 {
        public static final String uuid = "46F75541-F46B-48be-AA7E-B353BBE068A7";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class AngularDimension2
    extends Annotation2 {
        public static final String uuid = "841BC40B-A971-4a8e-94E5-BBA26D67348E";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class RadialDimension2
    extends Annotation2 {
        public static final String uuid = "B2B683FC-7964-4e96-B1F9-9B356A76B08B";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class LinearDimension2
    extends Annotation2 {
        public static final String uuid = "BD57F33B-A1B2-46e9-9C6E-AF09D30FFDDE";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class DimensionExtra
    extends UserData {
        public static final String uuid = "8AD5B9FC-0D5C-47fb-ADFD-74C28B6F661E";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class TextExtra
    extends UserData {
        public static final String uuid = "D90490A5-DB86-49f8-BDA1-9080B1F4E976";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class AnnotationArrow
    extends Geometry {
        public static final String uuid = "8BD94E1A-59E1-11d4-8018-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 512;
        }
    }

    public static class AnnotationTextDot
    extends Point {
        public static final String uuid = "8BD94E19-59E1-11d4-8018-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class Leader
    extends Annotation {
        public static final String uuid = "5DE6B211-486B-11d4-8014-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class TextEntity
    extends Annotation {
        public static final String uuid = "5DE6B210-486B-11d4-8014-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class AngularDimension
    extends Annotation {
        public static final String uuid = "5DE6B20F-486B-11d4-8014-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class RadialDimension
    extends Annotation {
        public static final String uuid = "5DE6B20E-486B-11d4-8014-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class LinearDimension
    extends Annotation {
        public static final String uuid = "5DE6B20D-486B-11d4-8014-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class Surface
    extends Geometry {
        public static final String uuid = "4ED7D4E1-E947-11d3-BFE5-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 8;
        }

        public static ISO readIso(int n) {
            switch (n) {
                case 0: {
                    return ISO.NotIso;
                }
                case 1: {
                    return ISO.XIso;
                }
                case 2: {
                    return ISO.YIso;
                }
                case 3: {
                    return ISO.WIso;
                }
                case 4: {
                    return ISO.SIso;
                }
                case 5: {
                    return ISO.EIso;
                }
                case 6: {
                    return ISO.NIso;
                }
            }
            return ISO.NotIso;
        }

        public static int getInt(ISO iSO) {
            switch (iSO) {
                case NotIso: {
                    return 0;
                }
                case XIso: {
                    return 1;
                }
                case YIso: {
                    return 2;
                }
                case WIso: {
                    return 3;
                }
                case SIso: {
                    return 4;
                }
                case EIso: {
                    return 5;
                }
                case NIso: {
                    return 6;
                }
            }
            return 0;
        }

        public Interval domain(int n) {
            return new Interval(0.0, 1.0);
        }

        public ISurface createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return null;
        }

        public ISurfaceGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ISO {
            NotIso,
            XIso,
            YIso,
            WIso,
            SIso,
            EIso,
            NIso,
            IsoCount;

        }
    }

    public static abstract class Curve
    extends Geometry {
        public static final String uuid = "4ED7D4D7-E947-11d3-BFE5-0010830122F0";
        public ICurveGeo icurve;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 4;
        }

        public abstract Interval domain();

        public abstract boolean isValid();

        public IObject createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return null;
        }

        public ICurveGeo createIGGeometry(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return null;
        }

        public ITrimCurve createTrimCurve(Rhino3dmFile rhino3dmFile, IServerI iServerI, ISurfaceI iSurfaceI) {
            return null;
        }
    }

    public static class Annotation2
    extends Geometry {
        public static final String uuid = "8D820224-BC6C-46b4-9066-BF39CC13AEFB";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 512;
        }
    }

    public static class Annotation
    extends Geometry {
        public static final String uuid = "ABAF5873-4145-11d4-800F-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 512;
        }
    }

    public static class UserData
    extends RhinoObject {
        public static final String uuid = "850324A7-050E-11d4-BFFA-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class HistoryRecord
    extends RhinoObject {
        public static final String uuid = "ECD0FD2F-2088-49dc-9641-9CF7A28FFA6B";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class Geometry
    extends RhinoObject {
        public static final String uuid = "4ED7D4DA-E947-11d3-BFE5-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class InstanceDefinition
    extends Geometry {
        public static final String uuid = "26F8BFF6-2618-417f-A158-153D64A94989";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 2048;
        }
    }

    public static class HatchPattern
    extends RhinoObject {
        public static final String uuid = "064E7C91-35F6-4734-A446-79FF7CD659E1";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class Light
    extends Geometry {
        public static final String uuid = "85A08513-F383-11d3-BFE7-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 256;
        }
    }

    public static class DimStyle
    extends RhinoObject {
        public static final String uuid = "81BD83D5-7120-41c4-9A57-C449336FF12C";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class Font
    extends RhinoObject {
        public static final String uuid = "4F0F51FB-35D0-4865-9998-6D2C6A99721D";
        public String fontName;
        public int fontWeight;
        public boolean fontItalic;
        public boolean fontUnderlined;
        public double linefeedRatio;
        public int fontIndex;
        public UUID fontId;
        public char[] facename;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
        }
    }

    public static class Group
    extends RhinoObject {
        public static final String uuid = "721D9F97-3645-44c4-8BE6-B2CF697D25CE";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class DisplayMaterialRef {
        public UUID viewportId;
        public UUID displayMaterialId;

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            this.viewportId = IRhino3dmImporter.readUUID(inputStream);
            this.displayMaterialId = IRhino3dmImporter.readUUID(inputStream);
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeUUID(outputStream, this.viewportId, cRC32);
            IRhino3dmExporter.writeUUID(outputStream, this.displayMaterialId, cRC32);
        }
    }

    public static class ObjectAttributes
    extends RhinoObject {
        public static final String uuid = "A828C015-09F5-477c-8665-F0482F5D6996";
        public static final UUID obsoletePageSpaceObjectId = new UUID(-1682229271, 8497, 20408, new byte[]{-71, -58, 85, 36, -123, -101, -104, -72});
        public UUID objectUUID;
        public String name;
        public String url;
        public int layerIndex;
        public int linetypeIndex;
        public int materialIndex;
        public RenderingAttributes renderingAttributes;
        public Color color;
        public Color plotColor;
        public int displayOrder;
        public double plotWeightMm;
        public short objectDecoration;
        public int wireDensity;
        public UUID viewportId;
        public short activeSpace;
        public boolean visible;
        public byte mode;
        public byte colorSource;
        public byte plotColorSource;
        public byte plotWeightSource;
        public byte materialSource;
        public byte linetypeSource;
        public ArrayList<Integer> group;
        public ArrayList<DisplayMaterialRef> dmref;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public ObjectAttributes() {
            this.objectUUID = null;
            this.name = null;
            this.url = null;
            this.layerIndex = 0;
            this.linetypeIndex = -1;
            this.materialIndex = -1;
            this.renderingAttributes = new RenderingAttributes();
            this.color = Color.black;
            this.plotColor = Color.black;
            this.displayOrder = 0;
            this.plotWeightMm = 0.0;
            this.objectDecoration = 0;
            this.wireDensity = 1;
            this.viewportId = null;
            this.activeSpace = 1;
            this.visible = true;
            this.mode = 0;
            this.colorSource = 0;
            this.plotColorSource = 0;
            this.plotWeightSource = 0;
            this.materialSource = 0;
            this.linetypeSource = 0;
            this.group = null;
            this.dmref = null;
        }

        public ObjectAttributes(IObject iObject, Rhino3dmFile rhino3dmFile) {
            this.objectUUID = UUID.randomUUID();
            this.name = iObject.name();
            this.url = null;
            this.layerIndex = iObject.layer() != null && iObject.server != null && iObject.server.layers != null ? iObject.server.layers.indexOf(iObject.layer()) : 0;
            this.linetypeIndex = -1;
            this.materialIndex = iObject.attr() != null && iObject.attr().material != null && rhino3dmFile.imaterials != null ? rhino3dmFile.imaterials.indexOf(iObject.attr().material) : -1;
            this.renderingAttributes = new RenderingAttributes();
            this.color = iObject.getColor();
            this.plotColor = iObject.getColor();
            this.displayOrder = 0;
            this.plotWeightMm = 0.0;
            this.objectDecoration = 0;
            this.wireDensity = 1;
            this.viewportId = null;
            this.activeSpace = 1;
            this.visible = iObject.visible();
            this.mode = 0;
            this.colorSource = this.color != null ? (byte)1 : 0;
            this.plotColorSource = 0;
            this.plotWeightSource = 0;
            this.materialSource = this.materialIndex >= 0 ? (byte)1 : 0;
            this.linetypeSource = 0;
            this.group = null;
            this.dmref = null;
        }

        public void readV5(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = 255;
            this.objectUUID = IRhino3dmImporter.readUUID(inputStream);
            this.layerIndex = IRhino3dmImporter.readInt(inputStream);
            n3 = IRhino3dmImporter.readByte(inputStream);
            if (n3 == 0) {
                return;
            }
            if (n3 == 1) {
                this.name = IRhino3dmImporter.readString(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 2) {
                this.url = IRhino3dmImporter.readString(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 3) {
                this.linetypeIndex = IRhino3dmImporter.readInt(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 4) {
                this.materialIndex = IRhino3dmImporter.readInt(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 5) {
                this.renderingAttributes.read(rhino3dmFile, inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 6) {
                this.color = IRhino3dmImporter.readColor(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 7) {
                this.plotColor = IRhino3dmImporter.readColor(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 8) {
                this.plotWeightMm = IRhino3dmImporter.readDouble(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 9) {
                this.objectDecoration = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 10) {
                this.wireDensity = IRhino3dmImporter.readInt(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 11) {
                this.visible = IRhino3dmImporter.readBool(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 12) {
                this.mode = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 13) {
                this.colorSource = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 14) {
                this.plotColorSource = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 15) {
                this.plotWeightSource = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 16) {
                this.materialSource = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 17) {
                this.linetypeSource = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 18) {
                this.group = IRhino3dmImporter.readArrayInt(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 19) {
                this.activeSpace = IRhino3dmImporter.readByte(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 20) {
                this.viewportId = IRhino3dmImporter.readUUID(inputStream);
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n3 == 21) {
                int n4 = IRhino3dmImporter.readInt(inputStream);
                this.dmref = new ArrayList(n4);
                for (int i = 0; i < n4; ++i) {
                    DisplayMaterialRef displayMaterialRef = new DisplayMaterialRef();
                    displayMaterialRef.read(rhino3dmFile, inputStream);
                    this.dmref.add(displayMaterialRef);
                }
                n3 = IRhino3dmImporter.readByte(inputStream);
            }
            if (n2 >= 1) {
                if (n3 == 22) {
                    this.displayOrder = IRhino3dmImporter.readInt(inputStream);
                    n3 = IRhino3dmImporter.readByte(inputStream);
                }
                if (n2 >= 2) {
                    // empty if block
                }
            }
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            if (rhino3dmFile.version >= 5 && rhino3dmFile.openNurbsVersion >= 200712190) {
                this.readV5(rhino3dmFile, inputStream);
                return;
            }
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n != 1) {
                IOut.err("wrong major version " + n);
                throw new IOException("wrong major version " + n);
            }
            this.objectUUID = IRhino3dmImporter.readUUID(inputStream);
            this.layerIndex = IRhino3dmImporter.readInt(inputStream);
            this.materialIndex = IRhino3dmImporter.readInt(inputStream);
            this.color = IRhino3dmImporter.readColor(inputStream);
            short s = IRhino3dmImporter.readShort(inputStream);
            if (rhino3dmFile.version < 4 || rhino3dmFile.openNurbsVersion < 200503170) {
                this.objectDecoration = (short)(s & 0x18);
            }
            IRhino3dmImporter.readShort(inputStream);
            IRhino3dmImporter.readDouble(inputStream);
            IRhino3dmImporter.readDouble(inputStream);
            this.wireDensity = IRhino3dmImporter.readInt(inputStream);
            this.mode = IRhino3dmImporter.readByte(inputStream);
            this.colorSource = IRhino3dmImporter.readByte(inputStream);
            this.linetypeSource = IRhino3dmImporter.readByte(inputStream);
            this.materialSource = IRhino3dmImporter.readByte(inputStream);
            this.name = IRhino3dmImporter.readString(inputStream);
            this.url = IRhino3dmImporter.readString(inputStream);
            boolean bl = this.visible = (this.mode & 0xF) != 1;
            if (n2 >= 1) {
                this.group = IRhino3dmImporter.readArrayInt(inputStream);
                if (n2 >= 2) {
                    this.visible = IRhino3dmImporter.readBool(inputStream);
                    if (n2 >= 3) {
                        int n3;
                        int n4 = IRhino3dmImporter.readInt(inputStream);
                        this.dmref = new ArrayList(n4);
                        for (n3 = 0; n3 < n4; ++n3) {
                            DisplayMaterialRef displayMaterialRef = new DisplayMaterialRef();
                            displayMaterialRef.read(rhino3dmFile, inputStream);
                            this.dmref.add(displayMaterialRef);
                        }
                        if (n2 >= 4) {
                            this.objectDecoration = (short)(IRhino3dmImporter.readInt(inputStream) & 0xFF);
                            this.plotColorSource = IRhino3dmImporter.readByte(inputStream);
                            this.plotColor = IRhino3dmImporter.readColor(inputStream);
                            this.plotWeightSource = IRhino3dmImporter.readByte(inputStream);
                            this.plotWeightMm = IRhino3dmImporter.readDouble(inputStream);
                            if (n2 >= 5) {
                                this.linetypeIndex = IRhino3dmImporter.readInt(inputStream);
                                if (n2 >= 6) {
                                    n3 = IRhino3dmImporter.readByte(inputStream);
                                    this.activeSpace = (short)(n3 == 1 ? 2 : 1);
                                    this.dmref.clear();
                                    n4 = IRhino3dmImporter.readInt(inputStream);
                                    for (int i = 0; i < n4; ++i) {
                                        DisplayMaterialRef displayMaterialRef = new DisplayMaterialRef();
                                        displayMaterialRef.viewportId = IRhino3dmImporter.readUUID(inputStream);
                                        if (obsoletePageSpaceObjectId.equals(displayMaterialRef.viewportId)) {
                                            this.viewportId = displayMaterialRef.viewportId;
                                            continue;
                                        }
                                        this.dmref.add(displayMaterialRef);
                                    }
                                    if (n2 >= 7) {
                                        this.renderingAttributes.read(rhino3dmFile, inputStream);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeChunkVersion(outputStream, 1, 6, cRC32);
            IRhino3dmExporter.writeUUID(outputStream, this.objectUUID, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.layerIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.materialIndex, cRC32);
            IRhino3dmExporter.writeColor(outputStream, this.color, cRC32);
            short s = this.objectDecoration;
            IRhino3dmExporter.writeInt16(outputStream, s, cRC32);
            s = 0;
            IRhino3dmExporter.writeInt16(outputStream, s, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, 0.0, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, 1.0, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.wireDensity, cRC32);
            IRhino3dmExporter.writeByte(outputStream, this.mode, cRC32);
            IRhino3dmExporter.writeByte(outputStream, this.colorSource, cRC32);
            IRhino3dmExporter.writeByte(outputStream, this.linetypeSource, cRC32);
            IRhino3dmExporter.writeByte(outputStream, this.materialSource, cRC32);
            IRhino3dmExporter.writeString(outputStream, this.name, cRC32);
            IRhino3dmExporter.writeString(outputStream, this.url, cRC32);
            IRhino3dmExporter.writeArrayInt(outputStream, this.group, cRC32);
            IRhino3dmExporter.writeBool(outputStream, this.visible, cRC32);
            IRhino3dmExporter.writeArrayDisplayMaterialRef(rhino3dmFile, outputStream, this.dmref, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.objectDecoration, cRC32);
            IRhino3dmExporter.writeByte(outputStream, this.plotColorSource, cRC32);
            IRhino3dmExporter.writeColor(outputStream, this.plotColor, cRC32);
            IRhino3dmExporter.writeByte(outputStream, this.plotWeightSource, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.plotWeightMm, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.linetypeIndex, cRC32);
            byte by = 0;
            switch (this.activeSpace) {
                case 0: {
                    by = 0;
                    break;
                }
                case 1: {
                    by = 0;
                    break;
                }
                case 2: {
                    by = 1;
                }
            }
            IRhino3dmExporter.writeByte(outputStream, by, cRC32);
            int n = 0;
            if (this.dmref != null) {
                n = this.dmref.size();
            }
            boolean bl = this.activeSpace == 2 && this.viewportId != null && this.viewportId != UUID.nilValue;
            IRhino3dmExporter.writeInt32(outputStream, bl ? n + 1 : n, cRC32);
            if (bl) {
                IRhino3dmExporter.writeUUID(outputStream, this.viewportId, cRC32);
                UUID uUID = new UUID(-1682229271, 8497, 20408, new byte[]{-71, -58, 85, 36, -123, -101, -104, -72});
                IRhino3dmExporter.writeUUID(outputStream, uUID, cRC32);
            }
            for (int i = 0; this.dmref != null && i < n; ++i) {
                IRhino3dmExporter.writeUUID(outputStream, this.dmref.get((int)i).viewportId, cRC32);
                IRhino3dmExporter.writeUUID(outputStream, this.dmref.get((int)i).displayMaterialId, cRC32);
            }
        }

        public String toString() {
            return "objectUUID = " + this.objectUUID + "\n" + "name = " + this.name + "\n" + "url = " + this.url + "\n" + "layerIndex = " + this.layerIndex + "\n" + "linetypeIndex = " + this.linetypeIndex + "\n" + "materialIndex = " + this.materialIndex + "\n" + "renderingAttributes = " + this.renderingAttributes + "\n" + "color = " + this.color + "\n" + "plotColor = " + Color.black + "\n" + "displayOrder = " + this.displayOrder + "\n" + "plotWeightMm = " + this.plotWeightMm + "\n" + "objectDecoration = " + this.objectDecoration + "\n" + "wireDensity = " + this.wireDensity + "\n" + "viewportId = " + this.viewportId + "\n" + "activeSpace = " + this.activeSpace + "\n" + "visible = " + this.visible + "\n" + "mode = " + this.mode + "\n" + "colorSource = " + this.colorSource + "\n" + "plotColorSource = " + this.plotColorSource + "\n" + "plotWeightSource = " + this.plotWeightSource + "\n" + "materialSource = " + this.materialSource + "\n" + "linetypeSource = " + this.linetypeSource + "\n" + "group = " + this.group + "\n" + "dmref = " + this.dmref + "\n";
        }
    }

    public static class Layer
    extends RhinoObject {
        public static final String uuid = "95809813-E985-11d3-BFE5-0010830122F0";
        public int layerIndex;
        public UUID layerId;
        public UUID parentLayerId;
        public int igesLevel;
        public int materialIndex;
        public int linetypeIndex;
        public Color color;
        public UUID displayMaterialId;
        public Color plotColor;
        public double plotWeightMm;
        public String name;
        public boolean visible;
        public boolean locked;
        public boolean expanded;
        public RenderingAttributes renderingAttributes;
        public ILayer ilayer;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 64;
        }

        public Layer() {
            this.layerId = null;
            this.parentLayerId = null;
            this.layerIndex = -1;
            this.igesLevel = -1;
            this.materialIndex = -1;
            this.linetypeIndex = -1;
            this.color = new Color(0, 0, 0);
            this.displayMaterialId = null;
            this.plotColor = new Color(255, 255, 255);
            this.plotWeightMm = 0.0;
            this.visible = true;
            this.locked = false;
            this.expanded = true;
            this.renderingAttributes = new RenderingAttributes();
        }

        public Layer(ILayer iLayer, int n) {
            this.layerId = UUID.randomUUID();
            this.parentLayerId = null;
            this.layerIndex = n;
            this.igesLevel = -1;
            this.materialIndex = -1;
            this.linetypeIndex = -1;
            this.color = iLayer.clr();
            this.displayMaterialId = null;
            this.plotColor = new Color(255, 255, 255, 0);
            this.plotWeightMm = 0.0;
            this.visible = iLayer.visible();
            this.locked = false;
            this.expanded = true;
            this.renderingAttributes = new RenderingAttributes();
            this.name = iLayer.name();
            this.ilayer = iLayer;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int n;
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n2 == 1) {
                n = IRhino3dmImporter.readInt(inputStream);
                switch (n) {
                    case 0: {
                        this.visible = true;
                        this.locked = false;
                        break;
                    }
                    case 1: {
                        this.visible = false;
                        this.locked = false;
                        break;
                    }
                    case 2: {
                        this.visible = true;
                        this.locked = true;
                        break;
                    }
                    default: {
                        this.visible = true;
                        this.locked = false;
                    }
                }
            }
            this.layerIndex = IRhino3dmImporter.readInt(inputStream);
            this.igesLevel = IRhino3dmImporter.readInt(inputStream);
            this.materialIndex = IRhino3dmImporter.readInt(inputStream);
            n = IRhino3dmImporter.readInt(inputStream);
            this.color = IRhino3dmImporter.readColor(inputStream);
            IRhino3dmImporter.readShort(inputStream);
            IRhino3dmImporter.readShort(inputStream);
            IRhino3dmImporter.readDouble(inputStream);
            IRhino3dmImporter.readDouble(inputStream);
            this.name = IRhino3dmImporter.readString(inputStream);
            if (n3 >= 1) {
                this.visible = IRhino3dmImporter.readBool(inputStream);
                if (n3 >= 2) {
                    this.linetypeIndex = IRhino3dmImporter.readInt(inputStream);
                    if (n3 >= 3) {
                        this.plotColor = IRhino3dmImporter.readColor(inputStream);
                        this.plotWeightMm = IRhino3dmImporter.readDouble(inputStream);
                        if (n3 >= 4) {
                            this.locked = IRhino3dmImporter.readBool(inputStream);
                            if (n3 >= 5) {
                                this.layerId = IRhino3dmImporter.readUUID(inputStream);
                                if (n3 >= 6 && rhino3dmFile.openNurbsVersion > 200505110) {
                                    this.parentLayerId = IRhino3dmImporter.readUUID(inputStream);
                                    this.expanded = IRhino3dmImporter.readBool(inputStream);
                                }
                                if (n3 >= 7) {
                                    this.renderingAttributes = new RenderingAttributes();
                                    this.renderingAttributes.read(rhino3dmFile, inputStream);
                                    if (n3 >= 8) {
                                        this.displayMaterialId = IRhino3dmImporter.readUUID(inputStream);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeChunkVersion(outputStream, 1, 8, cRC32);
            int n = 0;
            n = this.visible ? 0 : (this.locked ? 2 : 1);
            IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.layerIndex, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.igesLevel, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.materialIndex, cRC32);
            n = 0;
            IRhino3dmExporter.writeInt32(outputStream, n, cRC32);
            IRhino3dmExporter.writeColor(outputStream, this.color, cRC32);
            short s = 0;
            IRhino3dmExporter.writeInt16(outputStream, s, cRC32);
            IRhino3dmExporter.writeInt16(outputStream, s, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, 0.0, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, 1.0, cRC32);
            IRhino3dmExporter.writeString(outputStream, this.name, cRC32);
            IRhino3dmExporter.writeBool(outputStream, this.visible, cRC32);
            IRhino3dmExporter.writeInt32(outputStream, this.linetypeIndex, cRC32);
            IRhino3dmExporter.writeColor(outputStream, this.plotColor, cRC32);
            IRhino3dmExporter.writeDouble(outputStream, this.plotWeightMm, cRC32);
            IRhino3dmExporter.writeBool(outputStream, this.locked, cRC32);
            IRhino3dmExporter.writeUUID(outputStream, this.layerId, cRC32);
            IRhino3dmExporter.writeUUID(outputStream, this.parentLayerId, cRC32);
            IRhino3dmExporter.writeBool(outputStream, this.expanded, cRC32);
            this.renderingAttributes.write(rhino3dmFile, outputStream, cRC32);
            IRhino3dmExporter.writeUUID(outputStream, this.displayMaterialId, cRC32);
        }

        public ILayer createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            if (this.name == null) {
                IOut.err("layer name is null. no layer is instantiated.");
                return null;
            }
            this.ilayer = iServerI.server().getLayer(this.name);
            if (this.color != null) {
                this.ilayer.setColor(this.color);
            }
            this.ilayer.setVisible(this.visible);
            return this.ilayer;
        }

        public String toString() {
            return "Layer : name " + this.name + "\n" + "layerIndex = " + this.layerIndex + "\n" + "layerId = " + this.layerId + "\n" + "parentLayerId = " + this.parentLayerId + "\n" + "igesLevel = " + this.igesLevel + "\n" + "materialIndex = " + this.materialIndex + "\n" + "linetypeIndex = " + this.linetypeIndex + "\n" + "color = " + this.color + "\n" + "displayMaterialId = " + this.displayMaterialId + "\n" + "plotColor = " + this.plotColor + "\n" + "plotWeightMm = " + this.plotWeightMm + "\n" + "visible = " + this.visible + "\n" + "locked = " + this.locked + "\n" + "expanded = " + this.expanded + "\n" + "RenderingAttributes = " + this.renderingAttributes + "\n";
        }
    }

    public static class Settings {
        public void setPluginList(Chunk chunk) {
        }

        public void setUnitStandTols(Chunk chunk) {
        }

        public void setRenderMesh(Chunk chunk) {
        }

        public void setAnalysisMesh(Chunk chunk) {
        }

        public void setAnnotation(Chunk chunk) {
        }

        public void setNamedCPlaneList(Chunk chunk) {
        }

        public void setNamedViewList(Chunk chunk) {
        }

        public void setViewList(Chunk chunk) {
        }

        public void setCurrentLayerIndex(Chunk chunk) {
        }

        public void setCurrentFontIndex(Chunk chunk) {
        }

        public void setCurrentDimStyleIndex(Chunk chunk) {
        }

        public void setCurrentMaterialIndex(Chunk chunk) {
        }

        public void setCurrentColor(Chunk chunk) {
        }

        public void setCurrentWireDensity(Chunk chunk) {
        }

        public void setRender(Chunk chunk) {
        }

        public void setGridDefaults(Chunk chunk) {
        }

        public void setModelURL(Chunk chunk) {
        }

        public void setAttributes(Chunk chunk) {
        }

        public static class IOSettings {
        }

        public static class EarthAnchorPoint {
        }

        public static class RenderSettings {
        }

        public static class ViewSettings {
        }

        public static class PageSettings {
        }

        public static class WallPaperImage {
        }

        public static class ViewTraceImage {
        }

        public static class ViewPosition {
        }

        public static class ConstractionPlane {
        }

        public static class ConstructionPlaneGridDefaults {
        }

        public static class AnnotationSettings {
        }

        public static class UnitAndTolerances {
        }
    }

    public static class Properties {
        public int openNurbsVersion = -1;
        public byte[] notes;
        public byte[] previewImage;
        public byte[] application;
        public byte[] compressedPreviewImage;
        public byte[] revisionHistory;

        public void setOpenNurbsVersion(Chunk chunk) {
            this.openNurbsVersion = chunk.body;
        }

        public void setNotes(Chunk chunk) {
            this.notes = chunk.content;
        }

        public void setPreviewImage(Chunk chunk) {
            this.previewImage = chunk.content;
        }

        public void setApplication(Chunk chunk) {
            this.application = chunk.content;
        }

        public void setCompressedPreviewImage(Chunk chunk) {
            this.compressedPreviewImage = chunk.content;
        }

        public void setRevisionHistory(Chunk chunk) {
            this.revisionHistory = chunk.content;
        }
    }

    public static class Linetype
    extends RhinoObject {
        public static final String uuid = "26F10A24-7D13-4f05-8FDA-8E364DAF8EA6";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0;
        }
    }

    public static class TextureMapping
    extends RhinoObject {
        public static final String uuid = "32EC997A-C3BF-4ae5-AB19-FD572B8AD554";

        public static Type type(int n) {
            switch (n) {
                case 0: {
                    return Type.NoMapping;
                }
                case 1: {
                    return Type.SrfpMapping;
                }
                case 2: {
                    return Type.PlaneMapping;
                }
                case 3: {
                    return Type.CylinderMapping;
                }
                case 4: {
                    return Type.SphereMapping;
                }
                case 5: {
                    return Type.BoxMapping;
                }
                case 6: {
                    return Type.MeshMappingPrimitive;
                }
                case 7: {
                    return Type.SrfMappingPrimitive;
                }
                case 8: {
                    return Type.BrepMappingPrimitive;
                }
            }
            return Type.NoMapping;
        }

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            NoMapping,
            SrfpMapping,
            PlaneMapping,
            CylinderMapping,
            SphereMapping,
            BoxMapping,
            MeshMappingPrimitive,
            SrfMappingPrimitive,
            BrepMappingPrimitive;

        }
    }

    public static class Bitmap
    extends RhinoObject {
        public static final String uuid = "390465E9-3721-11d4-800B-0010830122F0";

        public UUID getClassUUID() {
            return new UUID(uuid);
        }
    }

    public static class RenderingAttributes {
        public ArrayList<MaterialRef> materials = new ArrayList();

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.content == null) {
                IOut.err("no chunk content");
                throw new IOException("no chunk content");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
            int n = IRhino3dmImporter.readInt(byteArrayInputStream);
            int n2 = IRhino3dmImporter.readInt(byteArrayInputStream);
            if (n != 1) {
                throw new IOException("invalid major version : " + String.valueOf(n));
            }
            int n3 = IRhino3dmImporter.readInt(byteArrayInputStream);
            for (int i = 0; i < n3; ++i) {
                MaterialRef materialRef = new MaterialRef();
                materialRef.read(rhino3dmFile, byteArrayInputStream);
                this.materials.add(materialRef);
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000, 1, 0);
            int n = 0;
            if (this.materials != null) {
                n = this.materials.size();
            }
            IRhino3dmExporter.writeInt32(chunkOutputStream, n, chunkOutputStream.getCRC());
            for (int i = 0; i < n; ++i) {
                this.materials.get(i).write(rhino3dmFile, chunkOutputStream, chunkOutputStream.getCRC());
            }
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    public static class Texture
    extends RhinoObject {
        public static final String uuid = "D6FF106D-329B-4f29-97E2-FD282A618020";
        public UUID textureId;
        public int mappingChannelId;
        public String filename;
        public boolean filenameRelativePath;
        public boolean on;
        public Type type;
        public Mode mode;
        public Filter minFilter;
        public Filter magFilter;
        public Wrap wrapU;
        public Wrap wrapV;
        public Wrap wrapW;
        public boolean applyUVW;
        public Xform uvw;
        public Color borderColor;
        public Color transparentColor;
        public UUID transparencyTextureId;
        public Interval bumpScale;
        public double blendConstantA;
        public double[] blendA;
        public double blendConstantRGB;
        public double[] blendRGB;
        public int blendOrder;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Wrap {
            RepeatWrap,
            ClampWrap,
            Force32BitTextureWrap;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Filter {
            NearestFilter,
            LinearFilter,
            Force32BitTextureFilter;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Mode {
            NoTextureMode,
            ModulateTexture,
            DecalTexture,
            BlendTexture,
            Force32BitTextureMode;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            NoTextureType,
            BumpTexture,
            TransparencyTexture,
            EMapTexture,
            Force32BitTextureType;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum MappingChannel {
            TCChannel,
            DefaultChannel,
            SrfPChannel,
            EMapChannel;

        }
    }

    public static class MappingChannel {
        public UUID mappingId;
        public int mappingIndex;
        public int mappingChannelId;
        public Xform objectXform;

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.content == null) {
                IOut.err("chunk content is null");
                throw new IOException("chunk content is null");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
            int n = IRhino3dmImporter.readInt(byteArrayInputStream);
            int n2 = IRhino3dmImporter.readInt(byteArrayInputStream);
            if (n != 1) {
                IOut.err("invalid majorVersion : " + n);
                throw new IOException("invalid major version" + String.valueOf(n));
            }
            this.mappingChannelId = IRhino3dmImporter.readInt(byteArrayInputStream);
            this.mappingId = IRhino3dmImporter.readUUID(byteArrayInputStream);
            if (n2 >= 1) {
                this.objectXform = IRhino3dmImporter.readXform(byteArrayInputStream);
                if (rhino3dmFile.openNurbsVersion < 200610030 && this.objectXform.isZero()) {
                    this.objectXform.identity();
                }
            }
        }
    }

    public static class MaterialRef {
        public UUID pluginId;
        public UUID materialId;
        public UUID materialBackfaceId;
        public int materialSource = 0;
        public char reserved1;
        public char reserved2;
        public char reserved3;
        public int materialIndex = -1;
        public int materialBackfaceIndex = -1;

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
            if (chunk.content == null) {
                IOut.err("chunk content is null");
                throw new IOException("chunk content is null");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
            int n = IRhino3dmImporter.readInt(byteArrayInputStream);
            int n2 = IRhino3dmImporter.readInt(byteArrayInputStream);
            if (n != 1) {
                IOut.err("invalid major version : " + n);
                throw new IOException("invalid major version" + String.valueOf(n));
            }
            this.pluginId = IRhino3dmImporter.readUUID(byteArrayInputStream);
            this.materialId = IRhino3dmImporter.readUUID(byteArrayInputStream);
            int n3 = IRhino3dmImporter.readInt(byteArrayInputStream);
            for (int i = 0; i < n3; ++i) {
                MappingChannel mappingChannel = new MappingChannel();
                mappingChannel.read(rhino3dmFile, byteArrayInputStream);
            }
            if (n2 >= 1) {
                this.materialBackfaceId = IRhino3dmImporter.readUUID(byteArrayInputStream);
                this.materialSource = IRhino3dmImporter.readInt(byteArrayInputStream);
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000, 1, 1);
            IRhino3dmExporter.writeUUID(chunkOutputStream, this.pluginId, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeUUID(chunkOutputStream, this.materialId, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeInt32(chunkOutputStream, 0, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeUUID(chunkOutputStream, this.materialBackfaceId, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeInt32(chunkOutputStream, this.materialSource, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }
    }

    public static class Material
    extends RhinoObject {
        public static final String uuid = "60B5DBBC-E660-11d3-BFE4-0010830122F0";
        public UUID materialId = UUID.nilValue;
        public int materialIndex = 0;
        public String materialName = null;
        public String flamingoLibrary = null;
        public Color ambient = new Color(0, 0, 0);
        public Color diffuse = new Color(128, 128, 128);
        public Color emission = new Color(0, 0, 0);
        public Color specular = new Color(255, 255, 255);
        public Color reflection = new Color(255, 255, 255);
        public Color transparent = new Color(255, 255, 255);
        public double indexOfRefraction = 1.0;
        public double reflectivity = 0.0;
        public double shine = 0.0;
        public double transparency = 0.0;
        public boolean shared = false;
        public ArrayList<Texture> textures = null;
        public ArrayList<UUIDIndex> materialChannel = null;
        public UUID pluginId = UUID.nilValue;
        IMaterial imaterial;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 128;
        }

        public Material() {
        }

        public Material(IBasicMaterial iBasicMaterial) {
            this();
            if (iBasicMaterial.ambient != null) {
                this.ambient = iBasicMaterial.ambient;
            }
            if (iBasicMaterial.diffuse != null) {
                this.diffuse = iBasicMaterial.diffuse;
            }
            if (iBasicMaterial.emission != null) {
                this.emission = iBasicMaterial.emission;
            }
            if (iBasicMaterial.specular != null) {
                this.specular = iBasicMaterial.specular;
            }
            if (iBasicMaterial.reflection != null) {
                this.reflection = iBasicMaterial.reflection;
            }
            if (iBasicMaterial.transparent != null) {
                this.transparent = iBasicMaterial.transparent;
            }
            this.indexOfRefraction = iBasicMaterial.refraction;
            this.reflectivity = iBasicMaterial.reflectivity;
            this.shine = iBasicMaterial.shine;
            this.transparency = iBasicMaterial.transparency;
            this.imaterial = iBasicMaterial;
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
            int[] nArray = IRhino3dmImporter.readChunkVersion(inputStream);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n == 1) {
                this.readV3(rhino3dmFile, inputStream, n2);
            } else if (n == 2) {
                Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
                if (chunk.content == null) {
                    IOut.err("chunk content is null");
                    throw new IOException("chunk content is null");
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
                n = IRhino3dmImporter.readInt(byteArrayInputStream);
                n2 = IRhino3dmImporter.readInt(byteArrayInputStream);
                this.materialId = IRhino3dmImporter.readUUID(byteArrayInputStream);
                this.materialIndex = IRhino3dmImporter.readInt(byteArrayInputStream);
                this.materialName = IRhino3dmImporter.readString(byteArrayInputStream);
                this.pluginId = IRhino3dmImporter.readUUID(byteArrayInputStream);
                this.ambient = IRhino3dmImporter.readColor(byteArrayInputStream);
                this.diffuse = IRhino3dmImporter.readColor(byteArrayInputStream);
                this.emission = IRhino3dmImporter.readColor(byteArrayInputStream);
                this.specular = IRhino3dmImporter.readColor(byteArrayInputStream);
                this.reflection = IRhino3dmImporter.readColor(byteArrayInputStream);
                this.transparent = IRhino3dmImporter.readColor(byteArrayInputStream);
                if (rhino3dmFile.openNurbsVersion < 200912010 && this.transparent.getRed() == 128 && this.transparent.getGreen() == 128 && this.transparent.getBlue() == 128) {
                    this.transparent = this.diffuse;
                }
                this.indexOfRefraction = IRhino3dmImporter.readDouble(byteArrayInputStream);
                this.reflectivity = IRhino3dmImporter.readDouble(byteArrayInputStream);
                this.shine = IRhino3dmImporter.readDouble(byteArrayInputStream);
                this.transparency = IRhino3dmImporter.readDouble(byteArrayInputStream);
                IOut.debug(100, "materialId = " + this.materialId);
                IOut.debug(100, "materialIndex = " + this.materialIndex);
                IOut.debug(100, "materialName = " + this.materialName);
                IOut.debug(100, "pluginId = " + this.pluginId);
                IOut.debug(100, "ambient = " + this.ambient);
                IOut.debug(100, "diffuse = " + this.diffuse);
                IOut.debug(100, "emission = " + this.emission);
                IOut.debug(100, "specular = " + this.specular);
                IOut.debug(100, "reflaction = " + this.reflection);
                IOut.debug(100, "transparent = " + this.transparent);
                IOut.debug(100, "indexOfRefraction = " + this.indexOfRefraction);
                IOut.debug(100, "reflectivity = " + this.reflectivity);
                IOut.debug(100, "shine = " + this.shine);
                IOut.debug(100, "transparency = " + this.transparency);
                Chunk chunk2 = IRhino3dmImporter.readChunk(byteArrayInputStream);
                if (chunk.content == null) {
                    IOut.err("chunk content is null");
                    throw new IOException("chunk content is null");
                }
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(chunk2.content);
                int n3 = IRhino3dmImporter.readInt(byteArrayInputStream2);
                int n4 = IRhino3dmImporter.readInt(byteArrayInputStream2);
                if (n3 == 1) {
                    int n5 = IRhino3dmImporter.readInt(byteArrayInputStream2);
                    for (int i = 0; i < n5; ++i) {
                    }
                }
                if (n2 >= 1) {
                    this.flamingoLibrary = IRhino3dmImporter.readString(byteArrayInputStream);
                    if (n2 >= 2) {
                        this.materialChannel = IRhino3dmImporter.readArrayUUIDIndex(byteArrayInputStream);
                    }
                }
            }
        }

        public void readV3(Rhino3dmFile rhino3dmFile, InputStream inputStream, int n) throws IOException {
            IOut.err();
            this.ambient = IRhino3dmImporter.readColor(inputStream);
            this.diffuse = IRhino3dmImporter.readColor(inputStream);
            this.emission = IRhino3dmImporter.readColor(inputStream);
            this.specular = IRhino3dmImporter.readColor(inputStream);
            this.shine = IRhino3dmImporter.readDouble(inputStream);
            if (this.shine < 0.0) {
                this.shine = 0.0;
            } else if (this.shine > 255.0) {
                this.shine = 255.0;
            }
            this.transparency = IRhino3dmImporter.readDouble(inputStream);
            if (this.transparency < 0.0) {
                this.transparency = 0.0;
            } else if (this.transparency > 1.0) {
                this.transparency = 1.0;
            }
            IRhino3dmImporter.readByte(inputStream);
            IRhino3dmImporter.readByte(inputStream);
            IRhino3dmImporter.readByte(inputStream);
            IRhino3dmImporter.readByte(inputStream);
            IRhino3dmImporter.readColor(inputStream);
            IRhino3dmImporter.readShort(inputStream);
            IRhino3dmImporter.readShort(inputStream);
            IRhino3dmImporter.readDouble(inputStream);
            IRhino3dmImporter.readDouble(inputStream);
            String string = IRhino3dmImporter.readString(inputStream);
            int n2 = IRhino3dmImporter.readInt(inputStream);
            int n3 = IRhino3dmImporter.readInt(inputStream);
            if (string == null || string.length() > 0) {
                // empty if block
            }
            string = IRhino3dmImporter.readString(inputStream);
            n2 = IRhino3dmImporter.readInt(inputStream);
            n3 = IRhino3dmImporter.readInt(inputStream);
            double d = IRhino3dmImporter.readDouble(inputStream);
            if (string == null || string.length() > 0) {
                // empty if block
            }
            string = IRhino3dmImporter.readString(inputStream);
            n2 = IRhino3dmImporter.readInt(inputStream);
            n3 = IRhino3dmImporter.readInt(inputStream);
            if (string == null || string.length() > 0) {
                // empty if block
            }
            this.materialIndex = IRhino3dmImporter.readInt(inputStream);
            this.pluginId = IRhino3dmImporter.readUUID(inputStream);
            this.flamingoLibrary = IRhino3dmImporter.readString(inputStream);
            this.materialName = IRhino3dmImporter.readString(inputStream);
            if (n >= 1) {
                this.materialId = IRhino3dmImporter.readUUID(inputStream);
                this.reflection = IRhino3dmImporter.readColor(inputStream);
                this.transparent = IRhino3dmImporter.readColor(inputStream);
                this.indexOfRefraction = IRhino3dmImporter.readDouble(inputStream);
            } else {
                this.materialId = UUID.randomUUID();
            }
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeChunkVersion(outputStream, 2, 0, cRC32);
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream = new IRhino3dmExporter.ChunkOutputStream(0x40008000, 1, 2);
            IRhino3dmExporter.writeUUID(chunkOutputStream, this.materialId, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeInt(chunkOutputStream, this.materialIndex, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeString(chunkOutputStream, this.materialName, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeUUID(chunkOutputStream, this.pluginId, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeColor(chunkOutputStream, this.ambient, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeColor(chunkOutputStream, this.diffuse, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeColor(chunkOutputStream, this.emission, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeColor(chunkOutputStream, this.specular, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeColor(chunkOutputStream, this.reflection, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeColor(chunkOutputStream, this.transparent, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeDouble(chunkOutputStream, this.indexOfRefraction, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeDouble(chunkOutputStream, this.reflectivity, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeDouble(chunkOutputStream, this.shine, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeDouble(chunkOutputStream, this.transparency, chunkOutputStream.getCRC());
            IRhino3dmExporter.ChunkOutputStream chunkOutputStream2 = new IRhino3dmExporter.ChunkOutputStream(0x40008000, 1, 0);
            IRhino3dmExporter.writeInt(chunkOutputStream2, 0, chunkOutputStream2.getCRC());
            IRhino3dmExporter.writeChunk(chunkOutputStream, chunkOutputStream2.getChunk());
            IRhino3dmExporter.writeString(chunkOutputStream, this.flamingoLibrary, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeArrayUUIDIndex(rhino3dmFile, chunkOutputStream, this.materialChannel, chunkOutputStream.getCRC());
            IRhino3dmExporter.writeChunk(outputStream, chunkOutputStream.getChunk());
        }

        public String toString() {
            return "materialId = " + this.materialId + "\n" + "materialIndex = " + this.materialIndex + "\n" + "materialName = " + this.materialName + "\n" + "flamingoLibrary = " + this.flamingoLibrary + "\n" + "ambient = " + this.ambient + "\n" + "diffuse = " + this.diffuse + "\n" + "emission = " + this.emission + "\n" + "specular = " + this.specular + "\n" + "reflection = " + this.reflection + "\n" + "transparent = " + this.transparent + "\n" + "indexOfRefraction = " + this.indexOfRefraction + "\n" + "reflectivity = " + this.reflectivity + "\n" + "shine = " + this.shine + "\n" + "transparency = " + this.transparency + "\n" + "shared = " + this.shared + "\n" + "textures num = " + (this.textures == null ? 0 : this.textures.size()) + "\n" + "materialChannel num = " + (this.materialChannel == null ? 0 : this.materialChannel.size()) + "\n" + "pluginId = " + this.pluginId;
        }
    }

    public static class RhinoObject {
        public static final String uuid = "60B5DBBD-E660-11d3-BFE4-0010830122F0";
        static final int objectTypeUnknown = 0;
        static final int objectTypePoint = 1;
        static final int objectTypePointset = 2;
        static final int objectTypeCurve = 4;
        static final int objectTypeSurface = 8;
        static final int objectTypeBrep = 16;
        static final int objectTypeMesh = 32;
        static final int objectTypeLayer = 64;
        static final int objectTypeMaterial = 128;
        static final int objectTypeLight = 256;
        static final int objectTypeAnnotation = 512;
        static final int objectTypeUserData = 1024;
        static final int objectTypeInstanceDefinition = 2048;
        static final int objectTypeInstanceReference = 4096;
        static final int objectTypeTextDot = 8192;
        static final int objectTypeGrip = 16384;
        static final int objectTypeDetail = 32768;
        static final int objectTypeHatch = 65536;
        static final int objectTypeMorphControl = 131072;
        static final int objectTypeLoop = 524288;
        static final int objectTypePolysrfFilter = 0x200000;
        static final int objectTypeEdgeFilter = 0x400000;
        static final int objectTypePolyledgeFilter = 0x800000;
        static final int objectTypeMeshVertex = 0x1000000;
        static final int objectTypeMeshEdge = 0x2000000;
        static final int objectTypeMeshFace = 0x4000000;
        static final int objectTypeCage = 0x8000000;
        static final int objectTypePhantom = 0x10000000;
        static final int objectTypeClipPlane = 0x20000000;
        static final int objectTypeBeam = 0x40000000;
        static final int objectTypeExtrusion = 0x40000000;
        static final int objectTypeAny = -1;
        public ObjectAttributes attributes = null;

        public UUID getClassUUID() {
            return new UUID(uuid);
        }

        public int getType() {
            return 0;
        }

        public void read(Rhino3dmFile rhino3dmFile, byte[] byArray) throws IOException {
            this.read(rhino3dmFile, new ByteArrayInputStream(byArray));
        }

        public void read(Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
        }

        public void write(Rhino3dmFile rhino3dmFile, OutputStream outputStream, CRC32 cRC32) throws IOException {
        }

        public void setAttributes(ObjectAttributes objectAttributes) {
            this.attributes = objectAttributes;
        }

        public IObject createIObject(Rhino3dmFile rhino3dmFile, IServerI iServerI) {
            return null;
        }

        public void setAttributesToIObject(Rhino3dmFile rhino3dmFile, IObject iObject) {
            if (this.attributes == null) {
                IOut.err("no attributes is set");
                return;
            }
            ILayer iLayer = null;
            if (this.attributes.name != null) {
                iObject.name(this.attributes.name);
                IOut.debug(10, "object name : " + this.attributes.name);
            }
            if (rhino3dmFile != null && rhino3dmFile.layers != null && this.attributes.layerIndex >= 0 && this.attributes.layerIndex < rhino3dmFile.layers.length) {
                iLayer = rhino3dmFile.layers[this.attributes.layerIndex].ilayer;
                iLayer.add(iObject);
                IOut.debug(10, "layer name : " + iLayer.name());
                if (!iLayer.isVisible()) {
                    iObject.hide();
                }
            }
            if (this.attributes.colorSource == 1 && this.attributes.color != null) {
                iObject.setColor(this.attributes.color);
                IOut.debug(10, "set object color : " + this.attributes.color);
                IOut.debug(10, "set object color : <" + this.attributes.color.getRed() + "," + this.attributes.color.getGreen() + "," + this.attributes.color.getBlue() + "," + this.attributes.color.getAlpha() + ">");
            } else if (iLayer != null) {
                iObject.setColor(iLayer.getColor());
                IOut.debug(10, "set layer color : " + iLayer.getColor());
            }
            if (!this.attributes.visible) {
                iObject.hide();
            }
            IOut.debug(10, "object color : " + iObject.getColor());
        }
    }

    public static class StartSection {
        public String information;

        public StartSection(String string) {
            this.information = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassRegistry {
        public static HashMap<UUID, Class<? extends RhinoObject>> map;

        public static void init() {
            map = new HashMap();
            ClassRegistry.put("60B5DBBD-E660-11d3-BFE4-0010830122F0", RhinoObject.class);
            ClassRegistry.put("A828C015-09F5-477c-8665-F0482F5D6996", ObjectAttributes.class);
            ClassRegistry.put("60B5DBBC-E660-11d3-BFE4-0010830122F0", Material.class);
            ClassRegistry.put("D6FF106D-329B-4f29-97E2-FD282A618020", Texture.class);
            ClassRegistry.put("390465E9-3721-11d4-800B-0010830122F0", Bitmap.class);
            ClassRegistry.put("32EC997A-C3BF-4ae5-AB19-FD572B8AD554", TextureMapping.class);
            ClassRegistry.put("26F10A24-7D13-4f05-8FDA-8E364DAF8EA6", Linetype.class);
            ClassRegistry.put("95809813-E985-11d3-BFE5-0010830122F0", Layer.class);
            ClassRegistry.put("721D9F97-3645-44c4-8BE6-B2CF697D25CE", Group.class);
            ClassRegistry.put("4F0F51FB-35D0-4865-9998-6D2C6A99721D", Font.class);
            ClassRegistry.put("81BD83D5-7120-41c4-9A57-C449336FF12C", DimStyle.class);
            ClassRegistry.put("85A08513-F383-11d3-BFE7-0010830122F0", Light.class);
            ClassRegistry.put("064E7C91-35F6-4734-A446-79FF7CD659E1", HatchPattern.class);
            ClassRegistry.put("26F8BFF6-2618-417f-A158-153D64A94989", InstanceDefinition.class);
            ClassRegistry.put("4ED7D4DA-E947-11d3-BFE5-0010830122F0", Geometry.class);
            ClassRegistry.put("ECD0FD2F-2088-49dc-9641-9CF7A28FFA6B", HistoryRecord.class);
            ClassRegistry.put("850324A7-050E-11d4-BFFA-0010830122F0", UserData.class);
            ClassRegistry.put("ABAF5873-4145-11d4-800F-0010830122F0", Annotation.class);
            ClassRegistry.put("8D820224-BC6C-46b4-9066-BF39CC13AEFB", Annotation2.class);
            ClassRegistry.put("4ED7D4D7-E947-11d3-BFE5-0010830122F0", Curve.class);
            ClassRegistry.put("4ED7D4E1-E947-11d3-BFE5-0010830122F0", Surface.class);
            ClassRegistry.put("5DE6B20D-486B-11d4-8014-0010830122F0", LinearDimension.class);
            ClassRegistry.put("5DE6B20E-486B-11d4-8014-0010830122F0", RadialDimension.class);
            ClassRegistry.put("5DE6B20F-486B-11d4-8014-0010830122F0", AngularDimension.class);
            ClassRegistry.put("5DE6B210-486B-11d4-8014-0010830122F0", TextEntity.class);
            ClassRegistry.put("5DE6B211-486B-11d4-8014-0010830122F0", Leader.class);
            ClassRegistry.put("8BD94E19-59E1-11d4-8018-0010830122F0", AnnotationTextDot.class);
            ClassRegistry.put("8BD94E1A-59E1-11d4-8018-0010830122F0", AnnotationArrow.class);
            ClassRegistry.put("D90490A5-DB86-49f8-BDA1-9080B1F4E976", TextExtra.class);
            ClassRegistry.put("8AD5B9FC-0D5C-47fb-ADFD-74C28B6F661E", DimensionExtra.class);
            ClassRegistry.put("BD57F33B-A1B2-46e9-9C6E-AF09D30FFDDE", LinearDimension2.class);
            ClassRegistry.put("B2B683FC-7964-4e96-B1F9-9B356A76B08B", RadialDimension2.class);
            ClassRegistry.put("841BC40B-A971-4a8e-94E5-BBA26D67348E", AngularDimension2.class);
            ClassRegistry.put("46F75541-F46B-48be-AA7E-B353BBE068A7", TextEntity2.class);
            ClassRegistry.put("14922B7A-5B65-4f11-8345-D415A9637129", Leader2.class);
            ClassRegistry.put("74198302-CDF4-4f95-9609-6D684F22AB37", TextDot.class);
            ClassRegistry.put("C8288D69-5BD8-4f50-9BAF-525A0086B0C3", OrdinateDimension2.class);
            ClassRegistry.put("A68B151F-C778-4a6e-BCB4-23DDD1835677", AngularDimension2Extra.class);
            ClassRegistry.put("CF33BE2A-09B4-11d4-BFFB-0010830122F0", ArcCurve.class);
            ClassRegistry.put("36F53175-72B8-4d47-BF1F-B4E6FC24F4B9", Extrusion.class);
            ClassRegistry.put("390465EB-3721-11d4-800B-0010830122F0", WindowsBitmap.class);
            ClassRegistry.put("772E6FC1-B17B-4fc4-8F54-5FDA511D76D2", EmbeddedBitmap.class);
            ClassRegistry.put("203AFC17-BCC9-44fb-A07B-7F5C31BD5ED9", WindowsBitmapEx.class);
            ClassRegistry.put("60B5DBC0-E660-11d3-BFE4-0010830122F0", BrepVertex.class);
            ClassRegistry.put("60B5DBC1-E660-11d3-BFE4-0010830122F0", BrepEdge.class);
            ClassRegistry.put("60B5DBC2-E660-11d3-BFE4-0010830122F0", BrepTrim.class);
            ClassRegistry.put("60B5DBC3-E660-11d3-BFE4-0010830122F0", BrepLoop.class);
            ClassRegistry.put("60B5DBC4-E660-11d3-BFE4-0010830122F0", BrepFace.class);
            ClassRegistry.put("60B5DBC5-E660-11d3-BFE4-0010830122F0", Brep.class);
            ClassRegistry.put("7FE23D63-E536-43f1-98E2-C807A2625AFF", BrepRegionTopologyUserData.class);
            ClassRegistry.put("30930370-0D5B-4ee4-8083-BD635C7398A4", BrepFaceSide.class);
            ClassRegistry.put("CA7A0092-7EE6-4f99-B9D2-E1D6AA798AA1", BrepRegion.class);
            ClassRegistry.put("4ED7D4D8-E947-11d3-BFE5-0010830122F0", CurveOnSurface.class);
            ClassRegistry.put("C8C66EFA-B3CB-4e00-9440-2AD66203379E", DetailView.class);
            ClassRegistry.put("513FDE53-7284-4065-8601-06CEA8B28D6F", DimStyleExtra.class);
            ClassRegistry.put("3FF7007C-3D04-463f-84E3-132ACEB91062", HatchExtra.class);
            ClassRegistry.put("0559733B-5332-49d1-A936-0532AC76ADE5", Hatch.class);
            ClassRegistry.put("F9CFB638-B9D4-4340-87E3-C56E7865D96A", InstanceRef.class);
            ClassRegistry.put("3E4904E6-E930-4fbc-AA42-EBD407AEFE3B", LayerExtensions.class);
            ClassRegistry.put("4ED7D4D9-E947-11d3-BFE5-0010830122F0", CurveProxy.class);
            ClassRegistry.put("4ED7D4DB-E947-11d3-BFE5-0010830122F0", LineCurve.class);
            ClassRegistry.put("4ED7D4E4-E947-11d3-BFE5-0010830122F0", Mesh.class);
            ClassRegistry.put("C547B4BD-BDCD-49b6-A983-0C4A7F02E31A", MeshVertexRef.class);
            ClassRegistry.put("ED727872-463A-4424-851F-9EC02CB0F155", MeshEdgeRef.class);
            ClassRegistry.put("4F529AA5-EF8D-4c25-BCBB-162D510AA280", MeshFaceRef.class);
            ClassRegistry.put("31F55AA3-71FB-49f5-A975-757584D937FF", MeshNgonUserData.class);
            ClassRegistry.put("4ED7D4DD-E947-11d3-BFE5-0010830122F0", NurbsCurve.class);
            ClassRegistry.put("4ED7D4DE-E947-11d3-BFE5-0010830122F0", NurbsSurface.class);
            ClassRegistry.put("06936AFB-3D3C-41ac-BF70-C9319FA480A1", NurbsCage.class);
            ClassRegistry.put("D379E6D8-7C31-4407-A913-E3B7040D034A", MorphControl.class);
            ClassRegistry.put("00C61749-D430-4ecc-83A8-29130A20CF9C", OffsetSurface.class);
            ClassRegistry.put("4ED7D4DF-E947-11d3-BFE5-0010830122F0", PlaneSurface.class);
            ClassRegistry.put("DBC5A584-CE3F-4170-98A8-497069CA5C36", ClippingPlaneSurface.class);
            ClassRegistry.put("2488F347-F8FA-11d3-BFEC-0010830122F0", PointCloud.class);
            ClassRegistry.put("C3101A1D-F157-11d3-BFE7-0010830122F0", Point.class);
            ClassRegistry.put("4ED7D4E5-E947-11d3-BFE5-0010830122F0", PointGrid.class);
            ClassRegistry.put("4ED7D4E0-E947-11d3-BFE5-0010830122F0", PolyCurve.class);
            ClassRegistry.put("42F47A87-5B1B-4e31-AB87-4639D78325D6", PolyEdgeSegment.class);
            ClassRegistry.put("39FF3DD3-FE0F-4807-9D59-185F0D73C0E4", PolyEdgeCurve.class);
            ClassRegistry.put("4ED7D4E6-E947-11d3-BFE5-0010830122F0", PolylineCurve.class);
            ClassRegistry.put("A16220D3-163B-11d4-8000-0010830122F0", RevSurface.class);
            ClassRegistry.put("C4CD5359-446D-4690-9FF5-29059732472B", SumSurface.class);
            ClassRegistry.put("4ED7D4E2-E947-11d3-BFE5-0010830122F0", SurfaceProxy.class);
            ClassRegistry.put("850324A8-050E-11d4-BFFA-0010830122F0", UnknownUserData.class);
            ClassRegistry.put("D66E5CCF-EA39-11d3-BFE5-0010830122F0", Viewport.class);
            ClassRegistry.put("5EAF1119-0B51-11d4-BFFE-0010830122F0", NurbsCurve.class);
            ClassRegistry.put("76A709D5-1550-11d4-8000-0010830122F0", NurbsCurve.class);
            ClassRegistry.put("4760C817-0BE3-11d4-BFFE-0010830122F0", NurbsSurface.class);
            ClassRegistry.put("FA4FD4B5-1613-11d4-8000-0010830122F0", NurbsSurface.class);
            ClassRegistry.put("EF638317-154B-11d4-8000-0010830122F0", PolyCurve.class);
            ClassRegistry.put("0705FDEF-3E2A-11d4-800E-0010830122F0", Brep.class);
            ClassRegistry.put("2D4CFEDB-3E2A-11d4-800E-0010830122F0", Brep.class);
            ClassRegistry.put("F06FC243-A32A-4608-9DD8-A7D2C4CE2A36", Brep.class);
            ClassRegistry.put("0A8401B6-4D34-4b99-8615-1B4E723DC4E5", RevSurface.class);
            ClassRegistry.put("665F6331-2A66-4cce-81D0-B5EEBD9B5417", SumSurface.class);
        }

        public static void put(String string, Class<? extends RhinoObject> clazz) {
            ClassRegistry.put(new UUID(string), clazz);
        }

        public static void put(UUID uUID, Class<? extends RhinoObject> clazz) {
            if (map.containsKey(uUID)) {
                IOut.err("UUID " + uUID + " is already set @" + clazz);
            }
            map.put(uUID, clazz);
        }

        public static Class<? extends RhinoObject> get(UUID uUID) {
            return map.get(uUID);
        }
    }

    public static class Xform {
        public double[][] xform;

        public Xform() {
            this.xform = new double[4][4];
        }

        public Xform(double[][] dArray) {
            this.xform = dArray;
        }

        public boolean isZero() {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (this.xform[i][j] == 0.0) continue;
                    return false;
                }
            }
            return true;
        }

        public void identity() {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.xform[i][j] = i == j ? 1.0 : 0.0;
                }
            }
        }
    }

    public static class Interval {
        public double v1;
        public double v2;

        public Interval() {
        }

        public Interval(double d, double d2) {
            this.v1 = d;
            this.v2 = d2;
        }

        public Interval(Interval interval) {
            this.v1 = interval.v1;
            this.v2 = interval.v2;
        }

        public boolean isIncreasing() {
            return this.v1 < this.v2;
        }

        public boolean isValid() {
            return true;
        }

        public boolean includes(double d) {
            return this.includes(d, false);
        }

        public boolean includes(double d, boolean bl) {
            if (bl) {
                return Math.min(this.v1, this.v2) < d && d < Math.max(this.v1, this.v2);
            }
            return Math.min(this.v1, this.v2) <= d && d <= Math.max(this.v1, this.v2);
        }

        public boolean includes(Interval interval) {
            return this.includes(interval, false);
        }

        public boolean includes(Interval interval, boolean bl) {
            if (!this.includes(interval.v1) || !this.includes(interval.v2)) {
                return false;
            }
            return !bl || this.includes(interval.v1, true) || this.includes(interval.v2, true);
        }

        public void set(double d, double d2) {
            this.v1 = d;
            this.v2 = d2;
        }

        public void set(Interval interval) {
            this.v1 = interval.v1;
            this.v2 = interval.v2;
        }

        public boolean equals(Interval interval) {
            if (this.v1 != interval.v1) {
                return false;
            }
            return this.v2 == interval.v2;
        }

        public void reverse() {
            double d = this.v1;
            this.v1 = this.v2;
            this.v2 = d;
        }

        public double normalizedParameterAt(double d) {
            double d2 = this.v1;
            if (this.v1 != this.v2) {
                d2 = d == this.v2 ? 1.0 : (d - this.v1) / (this.v2 - this.v1);
            }
            return d2;
        }

        public double parameterAt(double d) {
            return (1.0 - d) * this.v1 + d * this.v2;
        }

        public double min() {
            return Math.min(this.v1, this.v2);
        }

        public double max() {
            return Math.max(this.v1, this.v2);
        }

        public double length() {
            return this.v2 - this.v1;
        }

        public void intersection(Interval interval) {
            double d;
            double d2;
            double d3 = this.min();
            double d4 = d3 >= (d2 = interval.min()) ? d3 : d2;
            d3 = this.max();
            d2 = interval.max();
            double d5 = d = d3 <= d2 ? d3 : d2;
            if (d4 <= d) {
                this.set(d4, d);
            }
        }

        public String toString() {
            return "[" + this.v1 + "," + this.v2 + "]";
        }
    }

    public static class UUIDIndex {
        public UUID id;
        public int i;
    }

    public static class UUID {
        public static UUID nilValue = new UUID(0, 0, 0, new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
        public int data1;
        public short data2;
        public short data3;
        public byte[] data4;

        static UUID randomUUID() {
            java.util.UUID uUID = java.util.UUID.randomUUID();
            return new UUID(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
        }

        public UUID() {
        }

        public UUID(String string) {
            this.initWithString(string);
        }

        public UUID(int n, short s, short s2, byte[] byArray) {
            this.data1 = n;
            this.data2 = s;
            this.data3 = s2;
            this.data4 = byArray;
        }

        public UUID(long l, long l2) {
            this.data1 = (int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.data2 = (short)(l >>> 16 & 0xFFFFL);
            this.data3 = (short)(l & 0xFFFFL);
            this.data4 = new byte[8];
            for (int i = 0; i < 8; ++i) {
                this.data4[i] = (byte)(l2 >>> 8 * (7 - i) & 0xFFL);
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof UUID)) {
                return super.equals(object);
            }
            UUID uUID = (UUID)object;
            if (this.data1 != uUID.data1 || this.data2 != uUID.data2 || this.data3 != uUID.data3) {
                return false;
            }
            for (int i = 0; i < this.data4.length; ++i) {
                if (this.data4[i] == uUID.data4[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.data1;
        }

        public String toString() {
            return "UUID: " + IRhino3dm.hex(this.data1) + "-" + IRhino3dm.hex(this.data2) + "-" + IRhino3dm.hex(this.data3) + "-" + IRhino3dm.hex(this.data4);
        }

        public void initWithString(String string) {
            if ((string = string.replaceAll("-", "")).length() != 32) {
                IOut.err("wrong input string for UUID : " + string);
                return;
            }
            String string2 = string.substring(0, 8);
            String string3 = string.substring(8, 12);
            String string4 = string.substring(12, 16);
            String string5 = string.substring(16, 32);
            try {
                this.data1 = UUID.hexStringToInt(string2);
                this.data2 = UUID.hexStringToShort(string3);
                this.data3 = UUID.hexStringToShort(string4);
                this.data4 = UUID.hexStringToBytes(string5);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }

        public void write(OutputStream outputStream, CRC32 cRC32) throws IOException {
            IRhino3dmExporter.writeInt32(outputStream, this.data1, cRC32);
            IRhino3dmExporter.writeInt16(outputStream, this.data2, cRC32);
            IRhino3dmExporter.writeInt16(outputStream, this.data3, cRC32);
            IRhino3dmExporter.writeBytes(outputStream, this.data4, cRC32);
        }

        public static byte[] hexStringToBytes(String string) throws NumberFormatException {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length() / 2; ++i) {
                byArray[i] = UUID.hexStringToByte(string.substring(i * 2, i * 2 + 2));
            }
            return byArray;
        }

        public static int hexStringToInt(String string) throws NumberFormatException {
            if (string.length() != 8) {
                throw new NumberFormatException("invalid string \"" + string + "\"");
            }
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                n <<= 4;
                n |= UUID.charToByte(string.charAt(i));
            }
            return n;
        }

        public static short hexStringToShort(String string) throws NumberFormatException {
            if (string.length() != 4) {
                throw new NumberFormatException("invalid string \"" + string + "\"");
            }
            short s = 0;
            for (int i = 0; i < string.length(); ++i) {
                s = (short)(s << 4);
                s = (short)(s | UUID.charToByte(string.charAt(i)));
            }
            return s;
        }

        public static byte hexStringToByte(String string) {
            if (string.length() != 2) {
                throw new NumberFormatException("invalid string \"" + string + "\"");
            }
            return (byte)(UUID.charToByte(string.charAt(0)) << 4 | UUID.charToByte(string.charAt(1)));
        }

        public static byte charToByte(char c) throws NumberFormatException {
            if (c >= '0' && c <= '9') {
                return (byte)(c - 48);
            }
            if (c >= 'a' && c <= 'f') {
                return (byte)(c - 97 + 10);
            }
            if (c >= 'A' && c <= 'F') {
                return (byte)(c - 65 + 10);
            }
            throw new NumberFormatException("invalid character \"" + c + "\"");
        }
    }

    public static class Rhino3dmFile {
        public int version;
        public int openNurbsVersion;
        public StartSection startSection;
        public Properties properties;
        public Settings settings;
        public Bitmap[] bitmaps;
        public TextureMapping[] textureMappings;
        public ArrayList<Material> materials;
        public ArrayList<IMaterial> imaterials;
        public Linetype[] linetypes;
        public Layer[] layers;
        public Group[] groups;
        public Font[] fonts;
        public DimStyle[] dimStyles;
        public Light[] lights;
        public HatchPattern[] hatchPatterns;
        public InstanceDefinition[] instanceDefinitions;
        public RhinoObject[] rhinoObjects;
        public HistoryRecord[] historyRecords;
        public UserData[] userData;
        public IServerI server;

        public void setServer(IServerI iServerI) {
            this.server = iServerI;
        }

        public Rhino3dmFile() {
        }

        public Rhino3dmFile(int n, int n2, IServerI iServerI) {
            this.version = n;
            this.openNurbsVersion = n2;
            this.server = iServerI;
        }

        public int sizeOfChunkLength() {
            if (this.version < 50) {
                return 4;
            }
            return 8;
        }
    }

    public static class ChunkTable
    extends Chunk {
        public ArrayList<Chunk> chunks;
        public int endTCode = -1;
        public boolean serialized = false;

        public ChunkTable(int n, int n2) {
            super(n, 0);
            this.endTCode = n2;
            this.chunks = new ArrayList();
            if (this.doCRC()) {
                this.crc = new CRC32();
            }
        }

        public ChunkTable(int n) {
            super(n, 0);
            this.chunks = new ArrayList();
            if (this.doCRC()) {
                this.crc = new CRC32();
            }
        }

        public void add(Chunk chunk) {
            this.chunks.add(chunk);
            this.serialized = false;
        }

        public void serialize() throws IOException {
            if (!this.serialized) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = 0; i < this.chunks.size(); ++i) {
                    IRhino3dmExporter.writeChunk(byteArrayOutputStream, this.chunks.get(i));
                }
                IRhino3dmExporter.writeChunk(byteArrayOutputStream, new Chunk(this.endTCode, 0));
                this.content = byteArrayOutputStream.toByteArray();
                this.body = this.content.length;
                this.serialized = true;
            }
        }

        public boolean doCRC() {
            return false;
        }
    }

    public static class Chunk {
        public int header;
        public int body;
        public byte[] content = null;
        public CRC32 crc;

        public Chunk(int n, int n2) {
            this.header = n;
            this.body = n2;
        }

        public Chunk(int n, int n2, byte[] byArray, CRC32 cRC32) {
            this.header = n;
            this.body = n2;
            this.content = byArray;
            this.crc = cRC32;
        }

        public Chunk(int n, int n2, byte[] byArray) {
            this.header = n;
            this.body = n2;
            this.content = byArray;
            if (this.doCRC()) {
                this.crc = new CRC32();
                this.crc.update(this.content);
            }
        }

        public Chunk(int n, byte[] byArray, CRC32 cRC32) {
            this.header = n;
            this.content = byArray;
            this.body = this.content.length;
            this.crc = cRC32;
        }

        public Chunk(int n, byte[] byArray) {
            this.header = n;
            this.content = byArray;
            this.body = this.content.length;
            if (this.doCRC()) {
                this.crc = new CRC32();
                this.crc.update(this.content);
            }
        }

        public Chunk(int n, String string) {
            this.header = n;
            this.content = string.getBytes();
            this.body = this.content.length;
            if (this.doCRC()) {
                this.crc = new CRC32();
                this.crc.update(this.content);
            }
        }

        public Chunk(int n, int n2, int n3) {
            this.header = n;
            this.body = n2;
            this.content = IRhino3dm.itob(n3);
            if (this.doCRC()) {
                this.crc = new CRC32();
                this.crc.update(this.content);
            }
        }

        public void setContentLength() {
            this.body = this.content != null ? this.content.length : 0;
        }

        public int getHeader() {
            return this.header;
        }

        public int getBody() {
            return this.body;
        }

        public byte[] getContent() {
            return this.content;
        }

        public int contentLength() {
            return this.content.length;
        }

        public int chunkLength() {
            int n = 8;
            if (this.content != null) {
                n += this.content.length;
            }
            return n;
        }

        public byte[] getBytes() {
            byte[] byArray = null;
            byArray = this.content == null ? new byte[8] : new byte[8 + this.content.length];
            System.arraycopy(IRhino3dm.itob(this.header), 0, byArray, 0, 4);
            System.arraycopy(IRhino3dm.itob(this.body), 0, byArray, 4, 4);
            if (this.content != null) {
                System.arraycopy(this.content, 0, byArray, 8, this.content.length);
            }
            return byArray;
        }

        public boolean isShort() {
            return (this.header & Integer.MIN_VALUE) != 0;
        }

        public boolean doCRC() {
            return (this.header & 0x8000) != 0;
        }

        public boolean isEndOfTable() {
            return this.header == -1;
        }

        public void setCRC(CRC32 cRC32) {
            this.crc = cRC32;
        }

        public int getCRC() {
            return (int)this.crc.getValue();
        }

        public String toString() {
            String string = "header: " + IRhino3dm.hex(this.header) + "\n" + "body: " + IRhino3dm.hex(this.body) + "\n";
            if (this.content != null) {
                string = string + "length: " + this.content.length + "\n" + "content: " + IRhino3dm.hex(this.content) + "\n";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Endian {
        LittleEndian,
        BigEndian;

    }
}

