/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IServerI;
import igeo.geo.ICircleGeo;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.INurbsGeo;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceGeo;
import igeo.geo.IVec;
import igeo.geo.IVecI;

public class ICylinder
extends ISurface {
    public IVecI pt1;
    public IVecI pt2;
    public IDoubleI radius1;
    public IDoubleI radius2;

    public ICylinder(IVecI iVecI, IVecI iVecI2, double d) {
        this(null, iVecI, iVecI2, d, d);
    }

    public ICylinder(IServerI iServerI, IVecI iVecI, IVecI iVecI2, double d) {
        this(iServerI, iVecI, iVecI2, d, d);
    }

    public ICylinder(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        this(null, iVecI, iVecI2, d, d2);
    }

    public ICylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this(null, iVecI, iVecI2, iDoubleI, iDoubleI);
    }

    public ICylinder(IServerI iServerI, IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this(iServerI, iVecI, iVecI2, iDoubleI, iDoubleI);
    }

    public ICylinder(IServerI iServerI, IVecI iVecI, IVecI iVecI2, double d, double d2) {
        this(iServerI, iVecI, iVecI2, new IDouble(d), new IDouble(d2));
    }

    public ICylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this(null, iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public ICylinder(IServerI iServerI, IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super(iServerI);
        this.pt1 = iVecI;
        this.pt2 = iVecI2;
        this.radius1 = iDoubleI;
        this.radius2 = iDoubleI2;
        this.initCylinder(iServerI);
    }

    public void initCylinder(IServerI iServerI) {
        IVec iVec = this.pt1.get();
        IVec iVec2 = this.pt2.get();
        IVec iVec3 = iVec2.diff(iVec);
        IVecI[][] iVecIArray = new IVec[][]{ICircleGeo.circleCP(iVec, iVec3, this.radius1.x()), ICircleGeo.circleCP(iVec2, iVec3, this.radius2.x())};
        this.surface = new ISurfaceGeo(iVecIArray, 1, ICircleGeo.circleDeg(), INurbsGeo.createKnots(1, 2), ICircleGeo.circleKnots());
        super.initSurface(iServerI);
    }
}

