/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IOut;
import igeo.core.IParameterObject;
import igeo.core.IServerI;
import igeo.geo.IBool;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IEntityParameter;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVecI;
import igeo.geo.IVectorObject;

public class IVec
extends IParameterObject
implements IVecI,
IEntityParameter {
    public static final IVec origin = new IVec(0.0, 0.0, 0.0);
    public static final IVec xaxis = new IVec(1.0, 0.0, 0.0);
    public static final IVec yaxis = new IVec(0.0, 1.0, 0.0);
    public static final IVec zaxis = new IVec(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public IVec() {
    }

    public IVec(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public IVec(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IVecI iVecI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
    }

    public IVec(IVec2I iVec2I) {
        this.x = iVec2I.x();
        this.y = iVec2I.y();
        this.z = 0.0;
    }

    public IVec(IServerI iServerI) {
        super(iServerI);
    }

    public IVec(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public IVec(IServerI iServerI, IVec iVec) {
        super(iServerI);
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
    }

    public IVec(IServerI iServerI, IVec2I iVec2I) {
        super(iServerI);
        this.x = iVec2I.x();
        this.y = iVec2I.y();
        this.z = 0.0;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public IVec get() {
        return this;
    }

    public IVec dup() {
        return new IVec(this.x, this.y, this.z);
    }

    public IVec2 to2d() {
        return new IVec2(this);
    }

    public IVec4 to4d() {
        return new IVec4(this);
    }

    public IVec4 to4d(double d) {
        return new IVec4(this, d);
    }

    public IVec4 to4d(IDoubleI iDoubleI) {
        return new IVec4((IVecI)this, iDoubleI);
    }

    public IDouble getX() {
        return new IDouble(this.x);
    }

    public IDouble getY() {
        return new IDouble(this.y);
    }

    public IDouble getZ() {
        return new IDouble(this.z);
    }

    public IVec set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public IVec set(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        return this;
    }

    public IVec set(IVecI iVecI) {
        return this.set(iVecI.get());
    }

    public IVec set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        return this;
    }

    public IVec add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public IVec add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x += iDoubleI.x();
        this.y += iDoubleI2.x();
        this.z += iDoubleI3.x();
        return this;
    }

    public IVec add(IVec iVec) {
        this.x += iVec.x;
        this.y += iVec.y;
        this.z += iVec.z;
        return this;
    }

    public IVec add(IVecI iVecI) {
        return this.add(iVecI.get());
    }

    public IVec sub(double d, double d2, double d3) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
        return this;
    }

    public IVec sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x -= iDoubleI.x();
        this.y -= iDoubleI2.x();
        this.z -= iDoubleI3.x();
        return this;
    }

    public IVec sub(IVec iVec) {
        this.x -= iVec.x;
        this.y -= iVec.y;
        this.z -= iVec.z;
        return this;
    }

    public IVec sub(IVecI iVecI) {
        return this.sub(iVecI.get());
    }

    public IVec mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public IVec mul(IDouble iDouble) {
        this.x *= iDouble.x;
        this.y *= iDouble.x;
        this.z *= iDouble.x;
        return this;
    }

    public IVec mul(IDoubleI iDoubleI) {
        return this.mul(iDoubleI.x());
    }

    public IVec div(double d) {
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public IVec div(IDouble iDouble) {
        this.x /= iDouble.x;
        this.y /= iDouble.x;
        this.z /= iDouble.x;
        return this;
    }

    public IVec div(IDoubleI iDoubleI) {
        return this.div(iDoubleI.x());
    }

    public IVec neg() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public IVec rev() {
        return this.neg();
    }

    public IVec flip() {
        return this.neg();
    }

    public IVec add(IVec iVec, double d) {
        this.x += d * iVec.x;
        this.y += d * iVec.y;
        this.z += d * iVec.z;
        return this;
    }

    public IVec add(IVecI iVecI, double d) {
        return this.add(iVecI.get(), d);
    }

    public IVec add(IVecI iVecI, IDoubleI iDoubleI) {
        return this.add((IVecI)iVecI.get(), iDoubleI);
    }

    public double dot(IVec iVec) {
        return this.x * iVec.x + this.y * iVec.y + this.z * iVec.z;
    }

    public double dot(IVecI iVecI) {
        return this.dot(iVecI.get());
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dot(iVecI);
    }

    public IDouble dot(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.dot(iVecI));
    }

    public IVec cross(IVec iVec) {
        return this.dup().set(this.y * iVec.z - this.z * iVec.y, this.z * iVec.x - this.x * iVec.z, this.x * iVec.y - this.y * iVec.x);
    }

    public IVec cross(IVecI iVecI) {
        return this.cross(iVecI.get());
    }

    public IVec icross(IVec iVec) {
        double d = this.y * iVec.z - this.z * iVec.y;
        double d2 = this.z * iVec.x - this.x * iVec.z;
        double d3 = this.x * iVec.y - this.y * iVec.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    public double len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    public IDouble len2(ISwitchR iSwitchR) {
        return new IDouble(this.len2());
    }

    public IVec len(double d) {
        this.x *= (d /= this.len());
        this.y *= d;
        this.z *= d;
        return this;
    }

    public IVec len(IDoubleI iDoubleI) {
        return this.len(iDoubleI.x());
    }

    public IVec unit() {
        double d = this.len();
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public double dist(IVec iVec) {
        return Math.sqrt((this.x - iVec.x) * (this.x - iVec.x) + (this.y - iVec.y) * (this.y - iVec.y) + (this.z - iVec.z) * (this.z - iVec.z));
    }

    public double dist(IVecI iVecI) {
        return this.dist(iVecI.get());
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist(iVecI);
    }

    public IDouble dist(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.dist(iVecI));
    }

    public double dist2(IVec iVec) {
        return (this.x - iVec.x) * (this.x - iVec.x) + (this.y - iVec.y) * (this.y - iVec.y) + (this.z - iVec.z) * (this.z - iVec.z);
    }

    public double dist2(IVecI iVecI) {
        return this.dist2(iVecI.get());
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist2(iVecI);
    }

    public IDouble dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.dist2(iVecI));
    }

    public boolean eq(IVec iVec) {
        return this.eq(iVec, IConfig.lengthResolution);
    }

    public boolean eq(IVecI iVecI) {
        return this.eq(iVecI.get(), IConfig.lengthResolution);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eq(iVecI);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eq(iVecI));
    }

    public boolean eq(IVec iVec, double d) {
        return this.dist2(iVec) <= d * d;
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.eq(iVecI.get(), d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eq(iVecI, d);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eq(iVecI, iDoubleI.x()));
    }

    public boolean eqX(IVec iVec) {
        return this.eqX(iVec, IConfig.lengthResolution);
    }

    public boolean eqY(IVec iVec) {
        return this.eqY(iVec, IConfig.lengthResolution);
    }

    public boolean eqZ(IVec iVec) {
        return this.eqZ(iVec, IConfig.lengthResolution);
    }

    public boolean eqX(IVecI iVecI) {
        return this.eqX(iVecI, IConfig.lengthResolution);
    }

    public boolean eqY(IVecI iVecI) {
        return this.eqY(iVecI, IConfig.lengthResolution);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.eqZ(iVecI, IConfig.lengthResolution);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqX(iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqY(iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqZ(iVecI);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eqX(iVecI));
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eqY(iVecI));
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eqZ(iVecI));
    }

    public boolean eqX(IVec iVec, double d) {
        return Math.abs(this.x - iVec.x) <= d;
    }

    public boolean eqY(IVec iVec, double d) {
        return Math.abs(this.y - iVec.y) <= d;
    }

    public boolean eqZ(IVec iVec, double d) {
        return Math.abs(this.z - iVec.z) <= d;
    }

    public boolean eqX(IVecI iVecI, double d) {
        return Math.abs(this.x - iVecI.x()) <= d;
    }

    public boolean eqY(IVecI iVecI, double d) {
        return Math.abs(this.y - iVecI.y()) <= d;
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return Math.abs(this.z - iVecI.z()) <= d;
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqX(iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqY(iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqZ(iVecI, d);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eqX(iVecI, iDoubleI.x()));
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eqY(iVecI, iDoubleI.x()));
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eqZ(iVecI, iDoubleI.x()));
    }

    public double angle(IVec iVec) {
        double d = this.len();
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = iVec.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.dot(iVec) / (d * d2);
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        return Math.acos(d3);
    }

    public double angle(IVecI iVecI) {
        return this.angle(iVecI.get());
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.angle(iVecI);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.angle(iVecI));
    }

    public double angle(IVec iVec, IVec iVec2) {
        double d = this.len();
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = iVec.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.dot(iVec) / (d * d2);
        IVec iVec3 = this.cross(iVec);
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        double d4 = Math.acos(d3);
        if (iVec3.dot(iVec2) < 0.0) {
            return -d4;
        }
        return d4;
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.angle(iVecI.get(), iVecI2.get());
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.angle(iVecI, iVecI2);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return new IDouble(this.angle(iVecI, iVecI2));
    }

    public IVec rot(IVec iVec, double d) {
        double[][] dArray = new double[3][3];
        IVec iVec2 = iVec.dup().unit();
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0 - d3;
        dArray[0][0] = iVec2.x * iVec2.x * d4 + d3;
        dArray[0][1] = iVec2.x * iVec2.y * d4 - iVec2.z * d2;
        dArray[0][2] = iVec2.x * iVec2.z * d4 + iVec2.y * d2;
        dArray[1][0] = iVec2.y * iVec2.x * d4 + iVec2.z * d2;
        dArray[1][1] = iVec2.y * iVec2.y * d4 + d3;
        dArray[1][2] = iVec2.y * iVec2.z * d4 - iVec2.x * d2;
        dArray[2][0] = iVec2.z * iVec2.x * d4 - iVec2.y * d2;
        dArray[2][1] = iVec2.z * iVec2.y * d4 + iVec2.x * d2;
        dArray[2][2] = iVec2.z * iVec2.z * d4 + d3;
        double d5 = this.x;
        double d6 = this.y;
        this.x = dArray[0][0] * d5 + dArray[0][1] * d6 + dArray[0][2] * this.z;
        this.y = dArray[1][0] * d5 + dArray[1][1] * d6 + dArray[1][2] * this.z;
        this.z = dArray[2][0] * d5 + dArray[2][1] * d6 + dArray[2][2] * this.z;
        return this;
    }

    public IVec rot(IVecI iVecI, double d) {
        return this.rot(iVecI.get(), d);
    }

    public IVec rot(IVecI iVecI, IDoubleI iDoubleI) {
        return this.rot(iVecI.get(), iDoubleI.x());
    }

    public IVec rot(IVec iVec, IVec iVec2, double d) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).rot(iVec2, d).add(iVec);
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2, double d) {
        return this.rot(iVecI.get(), iVecI2.get(), d);
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return this.rot(iVecI.get(), iVecI2.get(), iDoubleI.x());
    }

    public IVec rot(IVec iVec, IVec iVec2) {
        return this.rot(iVec, iVec2.cross(iVec).angle(this.cross(iVec)));
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2) {
        return this.rot(iVecI.get(), iVecI2.get());
    }

    public IVec rot(IVec iVec, IVec iVec2, IVec iVec3) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).rot(iVec2, iVec3.diff(iVec)).add(iVec);
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.rot(iVecI.get(), iVecI2.get(), iVecI3.get());
    }

    public IVec scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public IVec scale(double d) {
        return this.mul(d);
    }

    public IVec scale(IVec iVec, double d) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).scale(d).add(iVec);
    }

    public IVec scale(IVecI iVecI, double d) {
        return this.scale(iVecI.get(), d);
    }

    public IVec scale(IVecI iVecI, IDoubleI iDoubleI) {
        return this.scale(iVecI.get(), iDoubleI.x());
    }

    public IVec scale1d(IVec iVec, double d) {
        IVec iVec2 = iVec.dup().unit();
        iVec2.mul(this.dot(iVec2));
        IVec iVec3 = this.diff(iVec2);
        return this.set(iVec2.mul(d).add(iVec3));
    }

    public IVec scale1d(IVecI iVecI, double d) {
        return this.scale1d(iVecI.get(), d);
    }

    public IVec scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        return this.scale1d(iVecI.get(), iDoubleI.x());
    }

    public IVec scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).scale1d(iVecI2, d).add(iVecI);
    }

    public IVec scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return this.scale1d(iVecI, iVecI2, iDoubleI.x());
    }

    public IVec ref(IVec iVec) {
        return this.add(iVec.dup().mul(this.dot(iVec) / iVec.len2() * -2.0));
    }

    public IVec ref(IVecI iVecI) {
        return this.ref(iVecI.get());
    }

    public IVec ref(IVec iVec, IVec iVec2) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).ref(iVec2).add(iVec);
    }

    public IVec ref(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI.get(), iVecI2.get());
    }

    public IVec mirror(IVec iVec) {
        return this.ref(iVec);
    }

    public IVec mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    public IVec mirror(IVec iVec, IVec iVec2) {
        return this.ref(iVec, iVec2);
    }

    public IVec mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    public IVec shear(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.x + d * this.y + d6 * this.z;
        double d8 = d2 * this.x + this.y + d3 * this.z;
        double d9 = d5 * this.x + d4 * this.y + this.z;
        this.x = d7;
        this.y = d8;
        this.z = d9;
        return this;
    }

    public IVec shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        return this.shear(iDoubleI == null ? 0.0 : iDoubleI.x(), iDoubleI2 == null ? 0.0 : iDoubleI2.x(), iDoubleI3 == null ? 0.0 : iDoubleI3.x(), iDoubleI4 == null ? 0.0 : iDoubleI4.x(), iDoubleI5 == null ? 0.0 : iDoubleI5.x(), iDoubleI6 == null ? 0.0 : iDoubleI6.x());
    }

    public IVec shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shear(d, d2, d3, d4, d5, d6).add(iVecI);
    }

    public IVec shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        return this.shear(iVecI, iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x(), iDoubleI4.x(), iDoubleI5.x(), iDoubleI6.x());
    }

    public IVec shearXY(double d, double d2) {
        return this.shear(d, d2, 0.0, 0.0, 0.0, 0.0);
    }

    public IVec shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearXY(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearXY(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearXY(d, d2).add(iVecI);
    }

    public IVec shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearXY(iVecI, iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearYZ(double d, double d2) {
        return this.shear(0.0, 0.0, d, d2, 0.0, 0.0);
    }

    public IVec shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearYZ(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearYZ(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearYZ(d, d2).add(iVecI);
    }

    public IVec shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearYZ(iVecI, iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearZX(double d, double d2) {
        return this.shear(0.0, 0.0, 0.0, 0.0, d, d2);
    }

    public IVec shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearZX(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearZX(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearZX(d, d2).add(iVecI);
    }

    public IVec shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearZX(iVecI, iDoubleI.x(), iDoubleI2.x());
    }

    public IVec translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVec translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVec transform(IMatrix3I iMatrix3I) {
        return this.set(iMatrix3I.mul(this));
    }

    public IVec transform(IMatrix4I iMatrix4I) {
        return this.set(iMatrix4I.mul(this));
    }

    public IVec transform(IVec iVec, IVec iVec2, IVec iVec3) {
        double d = iVec.x * this.x + iVec2.x * this.y + iVec3.x * this.z;
        double d2 = iVec.y * this.x + iVec2.y * this.y + iVec3.y * this.z;
        double d3 = iVec.z * this.x + iVec2.z * this.y + iVec3.z * this.z;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public IVec transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.transform(iVecI.get(), iVecI2.get(), iVecI3.get());
    }

    public IVec transform(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        return this.transform(iVec, iVec2, iVec3).add(iVec4);
    }

    public IVec transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return this.transform(iVecI.get(), iVecI2.get(), iVecI3.get());
    }

    public IVec mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVec mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVec cp() {
        return this.dup();
    }

    public IVec cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IVec cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVec diff(IVec iVec) {
        return this.dup().sub(iVec);
    }

    public IVec diff(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IVec mid(IVec iVec) {
        return this.dup().add(iVec).div(2.0);
    }

    public IVec mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IVec sum(IVec iVec) {
        return this.dup().add(iVec);
    }

    public IVec sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVec sum(IVec ... iVecArray) {
        IVec iVec = this.dup();
        for (IVec iVec2 : iVecArray) {
            iVec.add(iVec2);
        }
        return iVec;
    }

    public IVec sum(IVecI ... iVecIArray) {
        IVec iVec = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVec.add(iVecI);
        }
        return iVec;
    }

    public IVec bisect(IVec iVec) {
        return this.dup().unit().add(iVec.dup().unit());
    }

    public IVec bisect(IVecI iVecI) {
        return this.bisect(iVecI.get());
    }

    public IVec sum(IVec iVec, double d, double d2) {
        return this.dup().mul(d).add(iVec, d2);
    }

    public IVec sum(IVec iVec, double d) {
        return this.dup().mul(1.0 - d).add(iVec, d);
    }

    public IVec sum(IVecI iVecI, double d, double d2) {
        return this.sum(iVecI.get(), d, d2);
    }

    public IVec sum(IVecI iVecI, double d) {
        return this.sum(iVecI.get(), d);
    }

    public IVec sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI.get(), iDoubleI.x(), iDoubleI2.x());
    }

    public IVec sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI.get(), iDoubleI.x());
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z) + ")";
    }

    public boolean isParallel(IVecI iVecI) {
        return this.isParallel(iVecI, IConfig.angleResolution);
    }

    public boolean isParallel(IVecI iVecI, double d) {
        return Math.abs(this.dot(iVecI.get()) / (this.len() * iVecI.get().len())) > Math.cos(d);
    }

    public boolean isStraight(IVecI iVecI, IVecI iVecI2) {
        return this.isStraight(iVecI, iVecI2, IConfig.angleResolution);
    }

    public boolean isStraight(IVecI iVecI, IVecI iVecI2, double d) {
        return iVecI.get().diff(this).isParallel(iVecI2.get().diff(iVecI), d);
    }

    public static IVecI getNormal(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return iVecI2.diff(iVecI).cross(iVecI3.diff(iVecI)).unit();
    }

    public static IVec getNormal(IVec iVec, IVec iVec2, IVec iVec3) {
        return iVec2.diff(iVec).icross(iVec3.diff(iVec)).unit();
    }

    public IVecI getNormal(IVecI iVecI, IVecI iVecI2) {
        return iVecI.diff(this).cross(iVecI2.diff(this)).unit();
    }

    public IVec getNormal(IVec iVec, IVec iVec2) {
        return iVec.diff(this).icross(iVec2.diff(this)).unit();
    }

    public IVec projectToPlane(IVecI iVecI, IVecI iVecI2) {
        double d = this.dot(iVecI2) / iVecI.dot(iVecI2);
        this.x -= d * iVecI.x();
        this.y -= d * iVecI.y();
        this.z -= d * iVecI.z();
        return this;
    }

    public IVec projectToPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        if (iVecI3 == this) {
            return this;
        }
        return this.sub(iVecI3).projectToPlane(iVecI, iVecI2).add(iVecI3);
    }

    public IVec projectToLine(IVecI iVecI, IVecI iVecI2) {
        if (iVecI == this) {
            return this;
        }
        IVec iVec = this.diff(iVecI);
        double d = iVec.dot(iVecI2) / iVecI2.len();
        return iVec.set(iVecI2.get()).len(d).add(iVecI);
    }

    public double[] projectTo2Vec(IVecI iVecI, IVecI iVecI2) {
        double d;
        double d2;
        IVec iVec;
        double[] dArray = new double[3];
        IVec iVec2 = iVecI.get().cross(iVecI2);
        double d3 = iVec2.len2();
        if (d3 == 0.0) {
            return null;
        }
        dArray[2] = this.dot(iVec2) / d3;
        this.sub(iVec2.mul(dArray[2]));
        IVec iVec3 = iVecI.get();
        if (iVec3 == iVecI) {
            iVec3 = iVec3.dup();
        }
        if ((iVec = iVecI2.get()) == iVecI2) {
            iVec = iVec.dup();
        }
        if ((d2 = 1.0 - (d = iVec3.dot(iVec)) * d) == 0.0) {
            return null;
        }
        double d4 = this.dot(iVec3);
        double d5 = this.dot(iVec);
        dArray[0] = (d4 - d5 * d) / d2 / iVecI.len();
        dArray[1] = (d5 - d4 * d) / d2 / iVecI2.len();
        return dArray;
    }

    public IVec[] decompose(IVecI iVecI, IVecI iVecI2) {
        IVec iVec;
        double d;
        IVec iVec2;
        IVec iVec3 = iVecI.get();
        if (iVec3 == iVecI) {
            iVec3 = iVec3.dup();
        }
        if ((iVec2 = iVecI2.get()) == iVecI2) {
            iVec2 = iVec2.dup();
        }
        if ((d = (iVec = iVec3.cross(iVec2)).len()) == 0.0) {
            IOut.err("two vectors are in same direction");
            return null;
        }
        iVec.div(d);
        iVec.mul(this.dot(iVec));
        IVec iVec4 = this.dup().sub(iVec);
        iVec3.unit();
        iVec2.unit();
        double d2 = iVec3.dot(iVec2);
        double d3 = 1.0 - d2 * d2;
        if (d3 == 0.0) {
            IOut.err("two vectors are in same direction");
            return null;
        }
        double d4 = iVec4.dot(iVec3);
        double d5 = iVec4.dot(iVec2);
        iVec3.mul((d4 - d5 * d2) / d3);
        iVec2.mul((d5 - d4 * d2) / d3);
        return new IVec[]{iVec3, iVec2, iVec};
    }

    public double distanceToPlane(IVecI iVecI, IVecI iVecI2) {
        return Math.abs(this.diff(iVecI2).dot(iVecI) / iVecI.len());
    }

    public IVec perpendicularVectorToLine(IVecI iVecI, IVecI iVecI2) {
        IVec iVec = iVecI.get().dup();
        IVec iVec2 = iVecI2.diff(this).get();
        return iVec.mul(-iVec.dot(iVec2) / iVec.len2()).add(iVec2);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.isOnPlane(iVecI, iVecI2, iVecI3, IConfig.lengthResolution);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2) {
        return this.isOnPlane(iVecI, iVecI2, IConfig.lengthResolution);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return this.isOnPlane(IVec.getNormal(iVecI, iVecI2, iVecI3), iVecI, d);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2, double d) {
        return this.distanceToPlane(iVecI, iVecI2) < d;
    }

    public IVectorObject show(IVecI iVecI) {
        return new IVectorObject(this, iVecI);
    }

    public IVectorObject show() {
        return new IVectorObject(this);
    }

    public IVectorObject show(IServerI iServerI, IVecI iVecI) {
        return new IVectorObject(iServerI, this, iVecI);
    }

    public IVectorObject show(IServerI iServerI) {
        return new IVectorObject(iServerI, (IVecI)this);
    }

    public static boolean isFlat(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return iVecI.get().isOnPlane(iVecI2, iVecI3, iVecI4);
    }

    public static boolean isFlat(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, double d) {
        return iVecI.get().isOnPlane(iVecI2, iVecI3, iVecI4, d);
    }

    public static boolean isArrayEqual(IVec[] iVecArray, IVec[] iVecArray2, boolean bl, boolean bl2) {
        return IVec.isArrayEqual(iVecArray, iVecArray2, bl, bl2, IConfig.lengthResolution);
    }

    public static boolean isArrayEqual(IVec[] iVecArray, IVec[] iVecArray2, boolean bl, boolean bl2, double d) {
        int n;
        boolean bl3;
        int n2;
        if (iVecArray.length != iVecArray2.length) {
            return false;
        }
        int n3 = iVecArray.length;
        if (!bl) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                if (iVecArray[n4].eq(iVecArray2[n4], d) || bl2) continue;
                return false;
            }
            if (!bl2) {
                return true;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (iVecArray[n4].eq(iVecArray2[n3 - 1 - n4], d)) continue;
                return false;
            }
            return true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bl3 = true;
            for (n = 0; n < n3; ++n) {
                if (iVecArray[n].eq(iVecArray2[(n + n2) % n3], d)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            return true;
        }
        if (!bl2) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bl3 = true;
            for (n = 0; n < n3; ++n) {
                if (iVecArray[n].eq(iVecArray2[(n + n2) % n3], d)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            return true;
        }
        return false;
    }

    public static IVec averageNormal(IVecI[] iVecIArray) {
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return new IVec(0.0, 0.0, 1.0);
        }
        int n = iVecIArray.length;
        if (n <= 2) {
            if (n <= 1) {
                return new IVec(0.0, 0.0, 1.0);
            }
            IVec iVec = iVecIArray[1].get().diff(iVecIArray[0]).cross(xaxis);
            if (!iVec.eq(origin)) {
                return iVec.unit();
            }
            return iVecIArray[1].get().diff(iVecIArray[0]).cross(yaxis).unit();
        }
        if (n == 3) {
            return iVecIArray[1].get().diff(iVecIArray[0]).cross(iVecIArray[2].get().diff(iVecIArray[1])).unit();
        }
        IVec iVec = new IVec();
        for (int i = 0; i < n; ++i) {
            IVec iVec2 = iVecIArray[(i + 1) % n].get().diff(iVecIArray[i]);
            IVec iVec3 = iVecIArray[(i + 2) % n].get().diff(iVecIArray[(i + 1) % n]);
            iVec.add(iVec2.cross(iVec3));
        }
        if (iVec.eq(origin)) {
            return new IVec(0.0, 0.0, 1.0);
        }
        return iVec.unit();
    }
}

