/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IGraphicObject;
import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServerI;
import igeo.geo.IBoolI;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IMatrix3I;
import igeo.geo.IMatrix4I;
import igeo.geo.ISwitchE;
import igeo.geo.ISwitchR;
import igeo.geo.IVec;
import igeo.geo.IVec2I;
import igeo.geo.IVec4;
import igeo.geo.IVec4I;
import igeo.geo.IVec4R;
import igeo.geo.IVecI;
import igeo.geo.IVecR;
import igeo.gui.IGraphicMode;
import igeo.gui.IVectorGraphic;
import java.awt.Color;

public class IVectorObject
extends IObject
implements IVecI {
    public IVecI vec;
    public IVecI root;

    public IVectorObject(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.vec = iVecI;
        this.root = new IVec(0.0, 0.0, 0.0);
        this.initVector(iServerI);
    }

    public IVectorObject(IVecI iVecI) {
        this((IServerI)null, iVecI);
    }

    public IVectorObject(IServerI iServerI, IVecI iVecI, IVecI iVecI2) {
        super(iServerI);
        this.vec = iVecI;
        this.root = iVecI2;
        this.initVector(iServerI);
    }

    public IVectorObject(IVecI iVecI, IVecI iVecI2) {
        this(null, iVecI, iVecI2);
    }

    public IVectorObject(IServerI iServerI, IVectorObject iVectorObject) {
        super(iServerI, iVectorObject);
        this.vec = iVectorObject.vec;
        this.root = iVectorObject.root;
        this.initVector(iServerI);
        this.setColor(iVectorObject.getColor());
    }

    public IVectorObject(IVectorObject iVectorObject) {
        super(iVectorObject);
        this.vec = iVectorObject.vec;
        this.root = iVectorObject.root;
        this.initVector(iVectorObject.server);
        this.setColor(iVectorObject.getColor());
    }

    public IVecI vector() {
        return this.vec;
    }

    public IVectorObject vector(IVecI iVecI) {
        this.vec = iVecI;
        return this;
    }

    public IVecI root() {
        return this.root;
    }

    public IVectorObject root(IVecI iVecI) {
        this.root = iVecI;
        return this;
    }

    protected void initVector(IServerI iServerI) {
        if (this.vec instanceof IVec) {
            this.parameter = (IVec)this.vec;
        } else if (this.vec instanceof IVecR) {
            this.parameter = (IVecR)this.vec;
        } else if (this.vec instanceof IVec4) {
            this.parameter = (IVec4)this.vec;
        } else if (this.vec instanceof IVec4R) {
            this.parameter = (IVec4R)this.vec;
        }
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        return new IVectorGraphic(this);
    }

    public double x() {
        return this.vec.x();
    }

    public double y() {
        return this.vec.y();
    }

    public double z() {
        return this.vec.z();
    }

    public IVec get() {
        return this.vec.get();
    }

    public IVectorObject dup() {
        return new IVectorObject(this);
    }

    public IVec2I to2d() {
        return this.vec.to2d();
    }

    public IVec4I to4d() {
        return this.vec.to4d();
    }

    public IVec4I to4d(double d) {
        return this.vec.to4d(d);
    }

    public IVec4I to4d(IDoubleI iDoubleI) {
        return this.vec.to4d(iDoubleI);
    }

    public IDoubleI getX() {
        return this.vec.getX();
    }

    public IDoubleI getY() {
        return this.vec.getY();
    }

    public IDoubleI getZ() {
        return this.vec.getZ();
    }

    public IVectorObject set(IVecI iVecI) {
        this.vec.set(iVecI);
        return this;
    }

    public IVectorObject set(double d, double d2, double d3) {
        this.vec.set(d, d2, d3);
        return this;
    }

    public IVectorObject set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVectorObject add(double d, double d2, double d3) {
        this.vec.add(d, d2, d3);
        return this;
    }

    public IVectorObject add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVectorObject add(IVecI iVecI) {
        this.vec.add(iVecI);
        return this;
    }

    public IVectorObject sub(double d, double d2, double d3) {
        this.vec.sub(d, d2, d3);
        return this;
    }

    public IVectorObject sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVectorObject sub(IVecI iVecI) {
        this.vec.sub(iVecI);
        return this;
    }

    public IVectorObject mul(IDoubleI iDoubleI) {
        this.vec.mul(iDoubleI);
        return this;
    }

    public IVectorObject mul(double d) {
        this.vec.mul(d);
        return this;
    }

    public IVectorObject div(IDoubleI iDoubleI) {
        this.vec.div(iDoubleI);
        return this;
    }

    public IVectorObject div(double d) {
        this.vec.div(d);
        return this;
    }

    public IVectorObject neg() {
        this.vec.neg();
        return this;
    }

    public IVectorObject rev() {
        return this.neg();
    }

    public IVectorObject flip() {
        return this.neg();
    }

    public IVectorObject add(IVecI iVecI, double d) {
        this.vec.add(iVecI, d);
        return this;
    }

    public IVectorObject add(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.add(iVecI, iDoubleI);
        return this;
    }

    public double dot(IVecI iVecI) {
        return this.vec.dot(iVecI);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.dot(iSwitchE, iVecI);
    }

    public IDoubleI dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.dot(iSwitchR, iVecI);
    }

    public IVecI cross(IVecI iVecI) {
        return this.vec.cross(iVecI);
    }

    public double len() {
        return this.vec.len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.vec.len(iSwitchE);
    }

    public IDoubleI len(ISwitchR iSwitchR) {
        return this.vec.len(iSwitchR);
    }

    public double len2() {
        return this.vec.len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.vec.len2(iSwitchE);
    }

    public IDoubleI len2(ISwitchR iSwitchR) {
        return this.vec.len2(iSwitchR);
    }

    public IVectorObject len(IDoubleI iDoubleI) {
        this.vec.len(iDoubleI);
        return this;
    }

    public IVectorObject len(double d) {
        this.vec.len(d);
        return this;
    }

    public IVectorObject unit() {
        this.vec.unit();
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.vec.dist(iVecI);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.dist(iSwitchE, iVecI);
    }

    public IDoubleI dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.dist(iSwitchR, iVecI);
    }

    public double dist2(IVecI iVecI) {
        return this.vec.dist2(iVecI);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.dist2(iSwitchE, iVecI);
    }

    public IDoubleI dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.dist2(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI) {
        return this.vec.eq(iVecI);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eq(iSwitchE, iVecI);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eq(iSwitchR, iVecI);
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.vec.eq(iVecI, d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eq(iSwitchE, iVecI, d);
    }

    public IBoolI eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eq(iSwitchR, iVecI, iDoubleI);
    }

    public boolean eqX(IVecI iVecI) {
        return this.vec.eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.vec.eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.vec.eqZ(iVecI);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eqX(iSwitchE, iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eqY(iSwitchE, iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.eqZ(iSwitchE, iVecI);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eqX(iSwitchR, iVecI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eqY(iSwitchR, iVecI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.eqZ(iSwitchR, iVecI);
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.vec.eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.vec.eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.vec.eqZ(iVecI, d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eqX(iSwitchE, iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eqY(iSwitchE, iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.vec.eqZ(iSwitchE, iVecI, d);
    }

    public IBoolI eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eqX(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eqY(iSwitchR, iVecI, iDoubleI);
    }

    public IBoolI eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.vec.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    public double angle(IVecI iVecI) {
        return this.vec.angle(iVecI);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.vec.angle(iSwitchE, iVecI);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.vec.angle(iSwitchR, iVecI);
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.vec.angle(iVecI, iVecI2);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.vec.angle(iSwitchE, iVecI, iVecI2);
    }

    public IDoubleI angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.vec.angle(iSwitchR, iVecI, iVecI2);
    }

    public IVectorObject rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.rot(iVecI, iDoubleI);
        return this;
    }

    public IVectorObject rot(IVecI iVecI, double d) {
        this.vec.rot(iVecI, d);
        return this;
    }

    public IVectorObject rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.vec.rot(iVecI, iVecI2, d);
        return this;
    }

    public IVectorObject rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.vec.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IVectorObject rot(IVecI iVecI, IVecI iVecI2) {
        this.vec.rot(iVecI, iVecI2);
        return this;
    }

    public IVectorObject rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.vec.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVectorObject scale(IDoubleI iDoubleI) {
        this.vec.scale(iDoubleI);
        return this;
    }

    public IVectorObject scale(double d) {
        this.vec.scale(d);
        return this;
    }

    public IVectorObject scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.scale(iVecI, iDoubleI);
        return this;
    }

    public IVectorObject scale(IVecI iVecI, double d) {
        this.vec.scale(iVecI, d);
        return this;
    }

    public IVectorObject scale1d(IVecI iVecI, double d) {
        this.vec.scale1d(iVecI, d);
        return this;
    }

    public IVectorObject scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.vec.scale1d(iVecI, iDoubleI);
        return this;
    }

    public IVectorObject scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.vec.scale1d(iVecI, iVecI2, d);
        return this;
    }

    public IVectorObject scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.vec.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    public IVectorObject ref(IVecI iVecI) {
        this.vec.ref(iVecI);
        return this;
    }

    public IVectorObject ref(IVecI iVecI, IVecI iVecI2) {
        this.vec.ref(iVecI, iVecI2);
        return this;
    }

    public IVectorObject mirror(IVecI iVecI) {
        this.vec.ref(iVecI);
        return this;
    }

    public IVectorObject mirror(IVecI iVecI, IVecI iVecI2) {
        this.vec.ref(iVecI, iVecI2);
        return this;
    }

    public IVectorObject shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.vec.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    public IVectorObject shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.vec.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IVectorObject shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.vec.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    public IVectorObject shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.vec.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IVectorObject shearXY(double d, double d2) {
        this.vec.shearXY(d, d2);
        return this;
    }

    public IVectorObject shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    public IVectorObject shearXY(IVecI iVecI, double d, double d2) {
        this.vec.shearXY(iVecI, d, d2);
        return this;
    }

    public IVectorObject shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IVectorObject shearYZ(double d, double d2) {
        this.vec.shearYZ(d, d2);
        return this;
    }

    public IVectorObject shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    public IVectorObject shearYZ(IVecI iVecI, double d, double d2) {
        this.vec.shearYZ(iVecI, d, d2);
        return this;
    }

    public IVectorObject shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IVectorObject shearZX(double d, double d2) {
        this.vec.shearZX(d, d2);
        return this;
    }

    public IVectorObject shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    public IVectorObject shearZX(IVecI iVecI, double d, double d2) {
        this.vec.shearZX(iVecI, d, d2);
        return this;
    }

    public IVectorObject shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.vec.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    public IVectorObject translate(double d, double d2, double d3) {
        this.vec.translate(d, d2, d3);
        return this;
    }

    public IVectorObject translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.vec.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVectorObject translate(IVecI iVecI) {
        this.vec.translate(iVecI);
        return this;
    }

    public IVectorObject mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVectorObject mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVectorObject mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVectorObject cp() {
        return this.dup();
    }

    public IVectorObject cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IVectorObject cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVectorObject cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVectorObject transform(IMatrix3I iMatrix3I) {
        this.vec.transform(iMatrix3I);
        return this;
    }

    public IVectorObject transform(IMatrix4I iMatrix4I) {
        this.vec.transform(iMatrix4I);
        return this;
    }

    public IVectorObject transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.vec.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVectorObject transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.vec.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IVectorObject diff(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IVectorObject mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IVectorObject sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVectorObject sum(IVecI ... iVecIArray) {
        IVectorObject iVectorObject = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVectorObject.add(iVecI);
        }
        return iVectorObject;
    }

    public IVectorObject bisect(IVecI iVecI) {
        return this.dup().unit().add(iVecI.dup().unit());
    }

    public IVectorObject sum(IVecI iVecI, double d, double d2) {
        return this.dup().mul(d).add(iVecI, d2);
    }

    public IVectorObject sum(IVecI iVecI, double d) {
        return this.dup().mul(1.0 - d).add(iVecI, d);
    }

    public IVectorObject sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.dup().mul(iDoubleI).add(iVecI, iDoubleI2);
    }

    public IVectorObject sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.dup().mul(new IDouble(1.0).sub(iDoubleI)).add(iVecI, iDoubleI);
    }

    public IVectorObject setSize(double d) {
        return this.size(d);
    }

    public IVectorObject size(double d) {
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IVectorGraphic)) continue;
            ((IVectorGraphic)this.graphics.get(i)).size(d);
        }
        return this;
    }

    public double getSize() {
        return this.size();
    }

    public double size() {
        if (this.graphics == null) {
            IOut.err("no graphics is set");
            return -1.0;
        }
        for (int i = 0; this.graphics != null && i < this.graphics.size(); ++i) {
            if (!(this.graphics.get(i) instanceof IVectorGraphic)) continue;
            return ((IVectorGraphic)this.graphics.get(i)).size();
        }
        return -1.0;
    }

    public IVectorObject name(String string) {
        super.name(string);
        return this;
    }

    public IVectorObject layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    public IVectorObject hide() {
        super.hide();
        return this;
    }

    public IVectorObject show() {
        super.show();
        return this;
    }

    public IVectorObject clr(Color color) {
        super.clr(color);
        return this;
    }

    public IVectorObject clr(int n) {
        super.clr(n);
        return this;
    }

    public IVectorObject clr(float f) {
        super.clr(f);
        return this;
    }

    public IVectorObject clr(double d) {
        super.clr(d);
        return this;
    }

    public IVectorObject clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    public IVectorObject clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    public IVectorObject clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    public IVectorObject clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    public IVectorObject clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    public IVectorObject clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    public IVectorObject clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    public IVectorObject clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    public IVectorObject clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    public IVectorObject hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    public IVectorObject hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    public IVectorObject hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    public IVectorObject hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    public IVectorObject setColor(Color color) {
        super.setColor(color);
        return this;
    }

    public IVectorObject setColor(int n) {
        super.setColor(n);
        return this;
    }

    public IVectorObject setColor(float f) {
        super.setColor(f);
        return this;
    }

    public IVectorObject setColor(double d) {
        super.setColor(d);
        return this;
    }

    public IVectorObject setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    public IVectorObject setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    public IVectorObject setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    public IVectorObject setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    public IVectorObject setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    public IVectorObject setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    public IVectorObject setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    public IVectorObject setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    public IVectorObject setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    public IVectorObject setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    public IVectorObject setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    public IVectorObject setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    public IVectorObject setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

