/*
 * Decompiled with CFR 0.152.
 */
package igeo.util;

import igeo.geo.ISurfaceI;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.util.IMap;

public class ISurfaceDensityMap
extends IMap {
    public ISurfaceI surface;
    public IVec orig;
    public IVec uvec;
    public IVec vvec;

    public ISurfaceDensityMap(ISurfaceI iSurfaceI) {
        this.surface = iSurfaceI;
        this.initMap();
    }

    public void initMap() {
        this.orig = this.surface.corner(0, 0).get();
        this.uvec = this.surface.corner(1, 0).diff(this.orig).get();
        this.vvec = this.surface.corner(0, 1).diff(this.orig).get();
    }

    public void initDensityMapU(int n, int n2) {
    }

    public double projectU(double d, double d2) {
        IVec iVec = this.surface.pt(d, d2).get();
        iVec.sub(this.orig);
        double[] dArray = iVec.projectTo2Vec(this.uvec, this.vvec);
        return dArray[0];
    }

    public double projectV(double d, double d2) {
        IVec iVec = this.surface.pt(d, d2).get();
        iVec.sub(this.orig);
        double[] dArray = iVec.projectTo2Vec(this.uvec, this.vvec);
        return dArray[1];
    }

    public IVec2 project(double d, double d2) {
        IVec iVec = this.surface.pt(d, d2).get();
        iVec.sub(this.orig);
        double[] dArray = iVec.projectTo2Vec(this.uvec, this.vvec);
        return new IVec2(dArray[0], dArray[1]);
    }
}

