/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IConfig;
import igeo.core.IOut;
import igeo.core.IServerI;
import igeo.geo.ICircleGeo;
import igeo.geo.ICurve;
import igeo.geo.ICurveI;
import igeo.geo.ICylinder;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.INurbsGeo;
import igeo.geo.ISphere;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceI;
import igeo.geo.IVec;
import igeo.geo.IVec4I;
import igeo.geo.IVecI;
import igeo.geo.IVecR;
import igeo.util.IComparator;
import igeo.util.ISort;
import java.util.ArrayList;

public class ISurfaceCreator {
    public static IServerI server = null;

    public static void server(IServerI iServerI) {
        server = iServerI;
    }

    public static IServerI server() {
        return server;
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return new ISurface(server, iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return new ISurface(server, iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2) {
        return new ISurface(server, iVecIArray, n, n2);
    }

    public static ISurface surface(IVecI[][] iVecIArray) {
        return new ISurface(server, iVecIArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return new ISurface(server, iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return new ISurface(server, iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return new ISurface(server, iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface surface(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return new ISurface(server, iVecIArray, bl, bl2);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return new ISurface(server, iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return new ISurface(server, iVecI, iVecI2, iVecI3);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return new ISurface(server, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return new ISurface(server, d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface surface(double[][][] dArray) {
        return new ISurface(server, dArray);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2) {
        return new ISurface(server, dArray, n, n2);
    }

    public static ISurface surface(double[][][] dArray, boolean bl, boolean bl2) {
        return new ISurface(server, dArray, bl, bl2);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return new ISurface(server, dArray, n, n2, bl, bl2);
    }

    public static ISurface surface(ISurfaceI iSurfaceI) {
        return new ISurface(server, iSurfaceI);
    }

    public static ISurface surface(ICurveI iCurveI) {
        return new ISurface(server, iCurveI);
    }

    public static ISurface surface(ICurveI[] iCurveIArray) {
        return new ISurface(server, iCurveIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray) {
        return new ISurface(server, iVecIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n) {
        return new ISurface(server, iVecIArray, n);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n, double[] dArray) {
        return new ISurface(server, iVecIArray, n, dArray);
    }

    public static ISphere sphere(double d, double d2, double d3, double d4) {
        return new ISphere(server, d, d2, d3, d4);
    }

    public static ISphere sphere(IVecI iVecI, double d) {
        return new ISphere(server, iVecI, d);
    }

    public static ISphere sphere(IVecI iVecI, IDoubleI iDoubleI) {
        return new ISphere(server, iVecI, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d) {
        return new ICylinder(server, iVecI, iVecI2, d);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return new ICylinder(server, iVecI, iVecI2, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return new ICylinder(server, iVecI, iVecI2, d, d2);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new ICylinder(server, iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, double d) {
        return new ICylinder(server, iVecI, iVecI2, d, 0.0);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return new ICylinder(server, iVecI, iVecI2, iDoubleI, new IDouble(0.0));
    }

    public static ISurface plane(IVecI iVecI, double d, double d2) {
        return ISurfaceCreator.plane(iVecI, new IVec(d, 0.0, 0.0), new IVec(0.0, d2, 0.0));
    }

    public static ISurface plane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return new ISurface(server, iVecI, iVecI.dup().add(iVecI2), iVecI.dup().add(iVecI2).add(iVecI3), iVecI.dup().add(iVecI3));
    }

    public static ISurface extrude(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, (IVecI)IVec.averageNormal(iVecIArray).len(d));
    }

    public static ISurface extrude(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, (IVecI)new IVecR(IVec.averageNormal(iVecIArray)).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, (IVecI)IVec.averageNormal(iVecIArray).len(d));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, (IVecI)new IVecR(IVec.averageNormal(iVecIArray)).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, (IVecI)IVec.averageNormal(iVecIArray).len(d));
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, (IVecI)new IVecR(IVec.averageNormal(iVecIArray)).len(iDoubleI));
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.extrude(iVecIArray2, n, dArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        IVecI[][] iVecIArray2 = new IVecI[2][iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[0][i] = iVecIArray[i];
            iVecIArray2[1][i] = iVecIArray[i].dup().add(iVecI);
        }
        return new ISurface(server, iVecIArray2, 1, n, INurbsGeo.createKnots(1, 2), dArray, 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface extrude(IVecI[] iVecIArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, ICurve iCurve) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.extrude(iVecIArray2, n, dArray, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iCurve.cps(), iCurve.deg(), iCurve.knots());
    }

    public static ISurface extrude(ICurveI iCurveI, IVecI iVecI) {
        IVecI[][] iVecIArray = new IVecI[2][iCurveI.num()];
        for (int i = 0; i < iCurveI.num(); ++i) {
            iVecIArray[0][i] = iCurveI.cp(i);
            iVecIArray[1][i] = iCurveI.cp(i).dup().add(iVecI);
        }
        return new ISurface(server, iVecIArray, 1, iCurveI.deg(), INurbsGeo.createKnots(1, 2), iCurveI.knots(), 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.extrude(iVecIArray, 1, false, iVecIArray2, 1, false);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.extrude(iVecIArray, n, false, iVecIArray2, n2, false);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        IVecI[] iVecIArray3 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray3 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray3.length);
        } else {
            iVecIArray3 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray3.length);
        }
        IVecI[] iVecIArray4 = null;
        double[] dArray2 = null;
        if (bl2) {
            iVecIArray4 = INurbsGeo.createClosedCP(iVecIArray2, n2);
            dArray2 = INurbsGeo.createClosedKnots(n2, iVecIArray4.length);
        } else {
            iVecIArray4 = iVecIArray2;
            dArray2 = INurbsGeo.createKnots(n2, iVecIArray4.length);
        }
        return ISurfaceCreator.extrude(iVecIArray3, n, dArray, iVecIArray4, n2, dArray2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        IVecI iVecI = iVecIArray[0];
        IVecI[][] iVecIArray3 = new IVec[iVecIArray2.length][iVecIArray.length];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            for (int j = 0; j < iVecIArray.length; ++j) {
                iVecIArray3[i][j] = iVecIArray2[i].dup().add(iVecIArray[j]).sub(iVecI);
            }
        }
        return new ISurface(server, iVecIArray3, n2, n, dArray2, dArray, 0.0, 1.0, 0.0, 1.0);
    }

    public static ISurface extrude(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.extrude(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, 1, false, null, iVecIArray2, 1, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, 1, false, iVecI, iVecIArray2, 1, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, false, null, iVecIArray2, n2, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, false, iVecI, iVecIArray2, n2, false);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, null, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI[] iVecIArray2, int n2, boolean bl2) {
        IVecI[] iVecIArray3 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray3 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray3.length);
        } else {
            iVecIArray3 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray3.length);
        }
        IVecI[] iVecIArray4 = null;
        double[] dArray2 = null;
        if (bl2) {
            iVecIArray4 = INurbsGeo.createClosedCP(iVecIArray2, n2);
            dArray2 = INurbsGeo.createClosedKnots(n2, iVecIArray4.length);
        } else {
            iVecIArray4 = iVecIArray2;
            dArray2 = INurbsGeo.createKnots(n2, iVecIArray4.length);
        }
        return ISurfaceCreator.sweep(iVecIArray3, n, dArray, iVecI, iVecIArray4, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, 1, null, null, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, 1, null, iVecI, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, null, null, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, null, iVecI, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, ICurveI iCurveI) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.sweep(iVecIArray2, n, dArray, iVecI, iCurveI.cps(), iCurveI.deg(), iCurveI.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, null, iCurveI);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecIArray, 1, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), null, iVecIArray, 1, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecIArray, n, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), null, iVecIArray, n, null);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n, boolean bl) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iVecIArray2, n, dArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, null, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), iVecI, iCurveI2.cps(), iCurveI2.deg(), iCurveI2.knots());
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, null, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        if (iVecIArray == null || iVecIArray.length <= 1) {
            IOut.err("profile is null or number of array is too less");
            return null;
        }
        if (iVecIArray2 == null || iVecIArray2.length <= 1) {
            IOut.err("rail is null or number of array is too less");
            return null;
        }
        if (dArray == null) {
            dArray = INurbsGeo.createKnots(n, iVecIArray.length);
        }
        if (dArray2 == null) {
            dArray2 = INurbsGeo.createKnots(n2, iVecIArray2.length);
        }
        IVec iVec = IVec.averageNormal(iVecIArray);
        iVecI = iVecI == null ? ISurfaceCreator.getCenter(iVecIArray, n) : iVecI.dup();
        boolean bl = ISurfaceCreator.isClosed(iVecIArray2, n2);
        IVecI[] iVecIArray3 = ISurfaceCreator.duplicatePoints(iVecIArray);
        IVecI[][] iVecIArray4 = new IVecI[iVecIArray2.length][];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            IVecI[] iVecIArray5;
            IVecI iVecI2 = null;
            if (i == 0) {
                if (!bl && i < iVecIArray2.length - 1) {
                    iVecI2 = iVecIArray2[i + 1].diff(iVecIArray2[i]);
                } else if (bl && iVecIArray2.length - n2 > 0) {
                    iVecI2 = iVecIArray2[iVecIArray2.length - n2].diff(iVecIArray2[iVecIArray2.length - n2 - 1]);
                }
                iVecIArray5 = ISurfaceCreator.orient(iVecIArray3, iVecI, iVec, iVecIArray2[i], iVecI2);
                if (bl) {
                    if (i < iVecIArray2.length - 1) {
                        iVecI2 = iVecIArray2[i + 1].diff(iVecIArray2[i]);
                    }
                    iVecIArray5 = ISurfaceCreator.orientAndBisect(iVecIArray3, iVecI, iVec, iVecIArray2[i], iVecI2);
                }
                iVecIArray4[i] = iVecIArray5;
                continue;
            }
            if (bl && i >= iVecIArray2.length - n2) {
                iVecIArray4[i] = ISurfaceCreator.duplicatePoints(iVecIArray4[i - (iVecIArray2.length - n2)]);
                continue;
            }
            iVecI2 = i < iVecIArray2.length - 1 ? iVecIArray2[i + 1].diff(iVecIArray2[i]) : iVecIArray2[i].diff(iVecIArray2[i - 1]);
            iVecIArray5 = ISurfaceCreator.orientAndBisect(iVecIArray3, iVecI, iVec, iVecIArray2[i], iVecI2);
            iVecIArray4[i] = iVecIArray5;
        }
        return new ISurface(server, iVecIArray4, n2, n, dArray2, dArray, 0.0, 1.0, 0.0, 1.0);
    }

    public static IVecI[] duplicatePoints(IVecI[] iVecIArray) {
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i].dup();
        }
        return iVecIArray2;
    }

    public static IVecI[] duplicatePoints(IVecI[] iVecIArray, double d) {
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            double d2 = 1.0;
            if (iVecIArray[i] instanceof IVec4I) {
                d2 = ((IVec4I)iVecIArray[i]).w();
            }
            iVecIArray2[i] = iVecIArray[i].to4d(d2 * d);
        }
        return iVecIArray2;
    }

    public static IVecI[] orient(IVecI[] iVecIArray, IVecI iVecI, IVec iVec, IVecI iVecI2, IVecI iVecI3) {
        IVec iVec2 = null;
        double d = 0.0;
        boolean bl = true;
        if (iVecI3 != null) {
            iVec2 = iVec.cross(iVecI3);
            d = iVec.angle(iVecI3, (IVecI)iVec2);
            bl = d < IConfig.angleResolution;
        }
        for (IVecI iVecI4 : iVecIArray) {
            iVecI4.sub(iVecI);
            if (!bl) {
                iVecI4.rot((IVecI)iVec2, d);
            }
            iVecI4.add(iVecI2);
        }
        if (!bl) {
            iVec.rot(iVec2, d);
        }
        iVecI.set(iVecI2);
        if (iVecI2 instanceof IVec4I) {
            return ISurfaceCreator.duplicatePoints(iVecIArray, ((IVec4I)iVecI2).w());
        }
        return ISurfaceCreator.duplicatePoints(iVecIArray);
    }

    public static IVecI[] orientAndBisect(IVecI[] iVecIArray, IVecI iVecI, IVec iVec, IVecI iVecI2, IVecI iVecI3) {
        IVec iVec2 = null;
        double d = 0.0;
        boolean bl = true;
        if (iVecI3 != null) {
            iVec2 = iVec.cross(iVecI3);
            d = iVec.angle(iVecI3, (IVecI)iVec2);
            bl = d < IConfig.angleResolution;
        }
        IVecI[] iVecIArray2 = null;
        iVecIArray2 = iVecI2 instanceof IVec4I ? ISurfaceCreator.duplicatePoints(iVecIArray, ((IVec4I)iVecI2).w()) : ISurfaceCreator.duplicatePoints(iVecIArray);
        double d2 = d / 2.0;
        for (IVecI iVecI4 : iVecIArray) {
            iVecI4.sub(iVecI);
            if (!bl) {
                iVecI4.rot((IVecI)iVec2, d);
            }
            iVecI4.add(iVecI2);
        }
        IVec iVec3 = iVec.cross(iVec2);
        if (!bl) {
            iVec3.rot(iVec2, d2);
        }
        for (IVecI iVecI5 : iVecIArray2) {
            iVecI5.sub(iVecI);
            if (!bl) {
                iVecI5.rot((IVecI)iVec2, d2);
                if (Math.abs(d2 - 1.5707963267948966) >= IConfig.angleResolution) {
                    double d3 = 1.0 / Math.abs(Math.cos(d2));
                    iVecI5.scale1d((IVecI)iVec3, d3);
                }
            }
            iVecI5.add(iVecI2);
        }
        if (!bl) {
            iVec.rot(iVec2, d);
        }
        iVecI.set(iVecI2);
        return iVecIArray2;
    }

    public static boolean isClosed(IVecI[] iVecIArray, int n) {
        boolean bl = true;
        for (int i = 0; i < n && bl; ++i) {
            if (iVecIArray[i].eq(iVecIArray[iVecIArray.length - n + i])) continue;
            bl = false;
        }
        return bl;
    }

    public static IVec getCenter(IVecI[] iVecIArray, int n) {
        boolean bl = ISurfaceCreator.isClosed(iVecIArray, n);
        IVec iVec = new IVec();
        int n2 = 0;
        for (int i = 0; i < iVecIArray.length && !bl || i < iVecIArray.length - n && bl; ++i) {
            iVec.add(iVecIArray[i]);
            ++n2;
        }
        iVec.div(n2);
        return iVec;
    }

    public static ISurface pipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, 1, false, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, false, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.pipe(iVecIArray2, n, dArray, d);
    }

    public static ISurface pipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.pipe(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        IVec iVec = IVec.averageNormal(iVecIArray);
        IVec iVec2 = iVecIArray[1].get().diff(iVecIArray[0]);
        IVec iVec3 = iVecIArray[0].get();
        IVecI[] iVecIArray2 = ICircleGeo.circleCP(iVec3, iVec2, iVec2.cross(iVec), d);
        int n2 = ICircleGeo.circleDeg();
        double[] dArray2 = ICircleGeo.circleKnots();
        return ISurfaceCreator.sweep(iVecIArray2, n2, dArray2, (IVecI)iVec3, iVecIArray, n, dArray);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d);
    }

    public static ISurface squarePipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, 1, false, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, false, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2) {
        IVecI[] iVecIArray2 = null;
        double[] dArray = null;
        if (bl) {
            iVecIArray2 = INurbsGeo.createClosedCP(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray2.length);
        } else {
            iVecIArray2 = iVecIArray;
            dArray = INurbsGeo.createKnots(n, iVecIArray2.length);
        }
        return ISurfaceCreator.rectPipe(iVecIArray2, n, dArray, d, d2);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2) {
        return ISurfaceCreator.rectPipe(iCurveI.cps(), iCurveI.deg(), iCurveI.knots(), d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        IVecI[] iVecIArray2;
        IVec iVec = IVec.averageNormal(iVecIArray);
        IVec iVec2 = iVecIArray[1].get().diff(iVecIArray[0]);
        IVec iVec3 = iVecIArray[0].get();
        IVec iVec4 = iVec2.cross(iVec);
        if (iVec4.eq(new IVec(0.0, 0.0, 0.0))) {
            iVec4 = new IVec(1.0, 0.0, 0.0);
        }
        iVec4.len(d / 2.0);
        IVec iVec5 = iVec2.cross(iVec4);
        if (iVec5.eq(new IVec(0.0, 0.0, 0.0))) {
            iVec4 = new IVec(0.0, 1.0, 0.0);
        }
        iVec5.len(d2 / 2.0);
        iVecIArray2 = new IVec[]{iVec3.dup().sub(iVec4).sub(iVec5), iVec3.dup().add(iVec4).sub(iVec5), iVec3.dup().add(iVec4).add(iVec5), iVec3.dup().sub(iVec4).add(iVec5), iVecIArray2[0].dup()};
        double[] dArray2 = INurbsGeo.createClosedKnots(1, iVecIArray2.length);
        return ISurfaceCreator.sweep(iVecIArray2, 1, dArray2, (IVecI)iVec3, iVecIArray, n, dArray);
    }

    public static ISurface loft(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loft(iCurveIArray, 1, false);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loft(iCurveIArray, n, false);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n, boolean bl) {
        int n2 = ISurfaceCreator.checkCPNumForLoft(iCurveIArray);
        if (n2 < 2) {
            return null;
        }
        IVecI[][] iVecIArray = new IVec[iCurveIArray.length][n2];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                iVecIArray[i][j] = iCurveIArray[i].cp(j);
            }
        }
        double[] dArray = null;
        if (bl) {
            iVecIArray = INurbsGeo.createClosedCPInU(iVecIArray, n);
            dArray = INurbsGeo.createClosedKnots(n, iVecIArray.length);
        } else {
            dArray = INurbsGeo.createKnots(n, iVecIArray.length);
        }
        double[] dArray2 = null;
        int n3 = iCurveIArray[0].deg();
        if (iCurveIArray[0].num() == n2) {
            dArray2 = iCurveIArray[0].knots();
        } else {
            if (n3 > n2 - 1) {
                n3 = n2 - 1;
            }
            dArray2 = INurbsGeo.createKnots(n3, n2);
        }
        return new ISurface(server, iVecIArray, n, n3, dArray, dArray2, 0.0, 1.0, 0.0, 1.0);
    }

    public static int checkCPNumForLoft(ICurveI[] iCurveIArray) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no curve is provided");
            return 0;
        }
        int n = iCurveIArray[0].num();
        boolean bl = true;
        for (int i = 1; i < iCurveIArray.length; ++i) {
            if (iCurveIArray[i].num() == n) continue;
            bl = false;
            if (iCurveIArray[i].num() >= n) continue;
            n = iCurveIArray[i].num();
        }
        if (!bl) {
            IOut.err("num of control points needs to be same for lofting");
        }
        return n;
    }

    public static IVecI[][] checkCPNumForLoft(IVecI[][] iVecIArray) {
        if (iVecIArray == null || iVecIArray.length == 0) {
            IOut.err("no pts is provided");
            return null;
        }
        int n = iVecIArray[0].length;
        boolean bl = true;
        for (int i = 1; i < iVecIArray.length; ++i) {
            if (iVecIArray[i].length == n) continue;
            bl = false;
            if (iVecIArray[i].length >= n) continue;
            n = iVecIArray[i].length;
        }
        if (!bl) {
            IOut.err("num of control points needs to be same for lofting");
        }
        if (bl) {
            return iVecIArray;
        }
        IVecI[][] iVecIArray2 = new IVecI[iVecIArray.length][n];
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                iVecIArray2[i][j] = iVecIArray[i][j];
            }
        }
        return iVecIArray2;
    }

    public static ISurface loft(IVecI[][] iVecIArray) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray));
    }

    public static ISurface loft(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray), bl, bl2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray), n, n2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray), n, n2, bl, bl2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3));
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, boolean bl) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3), false, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3), 1, n);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n, boolean bl) {
        IVecI[][] iVecIArray3 = new IVecI[][]{iVecIArray, iVecIArray2};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray3), 1, n, false, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4));
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, boolean bl) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4), false, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4), n, n2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2, boolean bl) {
        IVecI[][] iVecIArray4 = new IVecI[][]{iVecIArray, iVecIArray2, iVecIArray3};
        return ISurfaceCreator.surface(ISurfaceCreator.checkCPNumForLoft(iVecIArray4), n, n2, false, bl);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftX(iCurveIArray, 1, false);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftX(iCurveIArray, n, false);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n, boolean bl) {
        ArrayList<ICurveI> arrayList = new ArrayList<ICurveI>();
        for (ICurveI iCurveI : iCurveIArray) {
            arrayList.add(iCurveI);
        }
        ISort.sort(arrayList, new XCurveComparator());
        return ISurfaceCreator.loft(arrayList.toArray(new ICurveI[arrayList.size()]), n, bl);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftY(iCurveIArray, 1, false);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftY(iCurveIArray, n, false);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n, boolean bl) {
        ArrayList<ICurveI> arrayList = new ArrayList<ICurveI>();
        for (ICurveI iCurveI : iCurveIArray) {
            arrayList.add(iCurveI);
        }
        ISort.sort(arrayList, new YCurveComparator());
        return ISurfaceCreator.loft(arrayList.toArray(new ICurveI[arrayList.size()]), n, bl);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftZ(iCurveIArray, 1, false);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftZ(iCurveIArray, n, false);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n, boolean bl) {
        ArrayList<ICurveI> arrayList = new ArrayList<ICurveI>();
        for (ICurveI iCurveI : iCurveIArray) {
            arrayList.add(iCurveI);
        }
        ISort.sort(arrayList, new ZCurveComparator());
        return ISurfaceCreator.loft(arrayList.toArray(new ICurveI[arrayList.size()]), n, bl);
    }

    public static IVec getCenter(ICurveI iCurveI) {
        return ISurfaceCreator.getCenter(iCurveI.cps(), iCurveI.deg());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZCurveComparator
    implements IComparator<ICurveI> {
        @Override
        public int compare(ICurveI iCurveI, ICurveI iCurveI2) {
            double d = ISurfaceCreator.getCenter((ICurveI)iCurveI).z;
            double d2 = ISurfaceCreator.getCenter((ICurveI)iCurveI2).z;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class YCurveComparator
    implements IComparator<ICurveI> {
        @Override
        public int compare(ICurveI iCurveI, ICurveI iCurveI2) {
            double d = ISurfaceCreator.getCenter((ICurveI)iCurveI).y;
            double d2 = ISurfaceCreator.getCenter((ICurveI)iCurveI2).y;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCurveComparator
    implements IComparator<ICurveI> {
        @Override
        public int compare(ICurveI iCurveI, ICurveI iCurveI2) {
            double d = ISurfaceCreator.getCenter((ICurveI)iCurveI).x;
            double d2 = ISurfaceCreator.getCenter((ICurveI)iCurveI2).x;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }
}

