/*
 * Decompiled with CFR 0.152.
 */
package igeo.geo;

import igeo.core.IServerI;
import igeo.geo.ICircleGeo;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceGeo;
import igeo.geo.IVec;
import igeo.geo.IVec4;
import igeo.geo.IVecI;

public class ISphere
extends ISurface {
    public IVecI center;
    public IDoubleI radius;

    public static double[] sphereKnots() {
        return new double[]{0.0, 0.0, 0.0, 0.5, 0.5, 1.0, 1.0, 1.0};
    }

    public ISphere(double d, double d2, double d3, double d4) {
        this(null, (IVecI)new IVec(d, d2, d3), d4);
    }

    public ISphere(IServerI iServerI, double d, double d2, double d3, double d4) {
        this(iServerI, (IVecI)new IVec(d, d2, d3), d4);
    }

    public ISphere(IVecI iVecI, double d) {
        this(null, iVecI, d);
    }

    public ISphere(IServerI iServerI, IVecI iVecI, double d) {
        this(iServerI, iVecI, new IDouble(d));
    }

    public ISphere(IVecI iVecI, IDoubleI iDoubleI) {
        this(null, iVecI, iDoubleI);
    }

    public ISphere(IServerI iServerI, IVecI iVecI, IDoubleI iDoubleI) {
        super(iServerI);
        this.center = iVecI;
        this.radius = iDoubleI;
        this.initSphere(iServerI);
    }

    public void initSphere(IServerI iServerI) {
        IVecI[][] iVecIArray = new IVec4[9][5];
        double d = Math.sqrt(2.0) / 2.0;
        double d2 = this.radius.x();
        IVec iVec = this.center.get();
        IVec4 iVec4 = iVec.to4d().add(0.0, 0.0, d2);
        IVec4 iVec42 = iVec4.dup();
        iVec42.w = d;
        IVec4 iVec43 = iVec.get().to4d().add(0.0, 0.0, -d2);
        IVec4 iVec44 = iVec43.dup();
        iVec44.w = d;
        IVec4[] iVec4Array = ICircleGeo.circleCP(iVec, new IVec(0.0, 0.0, 1.0), d2);
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray[i][0] = i % 2 == 0 ? iVec43.dup() : iVec44.dup();
            iVecIArray[i][1] = iVec4Array[i].dup().add(0.0, 0.0, -d2);
            ((IVec4)iVecIArray[i][1]).w *= d;
            iVecIArray[i][2] = iVec4Array[i];
            iVecIArray[i][3] = iVec4Array[i].dup().add(0.0, 0.0, d2);
            ((IVec4)iVecIArray[i][3]).w *= d;
            iVecIArray[i][4] = i % 2 == 0 ? iVec4.dup() : iVec42.dup();
        }
        this.surface = new ISurfaceGeo(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleDeg(), ICircleGeo.circleKnots(), ISphere.sphereKnots());
        super.initSurface(iServerI);
    }
}

