/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IOut;
import igeo.geo.IBool;
import igeo.geo.IBoolOp;
import igeo.geo.IBoolR;
import igeo.geo.IDouble;
import igeo.geo.IDoubleOp;
import igeo.geo.IDoubleR;
import igeo.geo.IEntityParameter;
import igeo.geo.IInteger;
import igeo.geo.IIntegerOp;
import igeo.geo.IIntegerR;
import igeo.geo.IParameter;
import igeo.geo.IReferenceParameter;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.geo.IVec2Op;
import igeo.geo.IVec2R;
import igeo.geo.IVec4;
import igeo.geo.IVec4Op;
import igeo.geo.IVec4R;
import igeo.geo.IVecOp;
import igeo.geo.IVecR;
import igeo.gui.IDoubleBuffer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParameterViewer
extends Component {
    public static boolean bottomUp = true;
    public static Color bgcolor = Color.white;
    public static int paramXSpacing = 160;
    public static int paramYSpacing = 40;
    public ArrayList<IParameter> parameters;
    public ArrayList<IParameterGraphic> pgraphics;
    public IDoubleBuffer db;

    public IParameterViewer(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
        this.parameters = new ArrayList();
        this.pgraphics = new ArrayList();
        this.db = new IDoubleBuffer(this);
    }

    public IParameterGraphic addParameter(IParameter iParameter, int n, int n2) {
        if (!this.parameters.contains(iParameter)) {
            this.parameters.add(iParameter);
            IParameterGraphic iParameterGraphic = new IParameterGraphic(iParameter);
            this.pgraphics.add(iParameterGraphic);
            iParameterGraphic.setSize(this.getFontMetrics(IParameterGraphic.font));
            iParameterGraphic.setLocation(n, n2);
            IParameter[] iParameterArray = IParameterGraphic.getOperand2(iParameter);
            for (int i = 0; iParameterArray != null && i < iParameterArray.length; ++i) {
                int n3 = n + paramXSpacing * i;
                int n4 = n2 + paramYSpacing;
                if (!bottomUp) {
                    n4 = n2 - paramYSpacing;
                }
                iParameterGraphic.addLink(this.addParameter(iParameterArray[i], n3, n4));
            }
            return iParameterGraphic;
        }
        return IParameterViewer.findParameterGraphic(iParameter, this.pgraphics);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics graphics2 = this.db.getGraphics();
        graphics2.setColor(bgcolor);
        graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.pgraphics.size(); ++i) {
            this.pgraphics.get(i).paint((Graphics2D)graphics2);
        }
        graphics2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.db.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    @Override
    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.db.setSize(n, n2);
    }

    public static IParameterGraphic findParameterGraphic(IParameter iParameter, ArrayList<IParameterGraphic> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get((int)i).parameter != iParameter) continue;
            return arrayList.get(i);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IParameterGraphic {
        public static int topBlank = 0;
        public static int bottomBlank = 6;
        public static int leftBlank = 4;
        public static int rightBlank = 6;
        public static int handleHeight = 4;
        public static int handleWidth = 8;
        public static int handleGap = 6;
        public static int cornerSizeX = 6;
        public static int cornerSizeY = 8;
        public static Color bgcolor = new Color(140, 140, 140, 100);
        public static Color typeColor = new Color(80, 80, 80);
        public static Color valueColor = Color.black;
        public static Color handleColor = new Color(60, 60, 60);
        public static Color linkColor = new Color(0, 0, 0, 192);
        public static BasicStroke linkStroke = new BasicStroke(0.5f, 0, 2);
        public static int fontSize = 12;
        public static Font font = new Font("Sanserif", 0, fontSize);
        public static boolean showValue = true;
        public String type;
        public String value;
        public Rectangle bounds;
        public GeneralPath bgShape;
        public int fontHeight;
        public int fontWidth1;
        public int fontWidth2;
        public int inputNum = 0;
        public IParameter parameter;
        public ArrayList<IParameterGraphic> linkedParameters = null;

        public IParameterGraphic(IParameter iParameter) {
            this.setParameter2(iParameter);
        }

        public void addLink(IParameter iParameter, ArrayList<IParameterGraphic> arrayList) {
            IParameterGraphic iParameterGraphic = IParameterViewer.findParameterGraphic(iParameter, arrayList);
            if (iParameterGraphic != null) {
                this.addLink(iParameterGraphic);
            } else {
                IOut.p("parameter cannot be found");
            }
        }

        public void addLink(IParameterGraphic iParameterGraphic) {
            if (this.linkedParameters == null) {
                this.linkedParameters = new ArrayList();
            }
            this.linkedParameters.add(iParameterGraphic);
            this.inputNum = this.linkedParameters.size();
        }

        public Point getInputLocation(int n) {
            return new Point(this.bounds.x + n * (handleGap + handleWidth) + handleWidth / 2, this.bounds.y + (bottomUp ? this.bounds.height : 0));
        }

        public Point getOutputLocation() {
            return new Point(this.bounds.x + handleWidth / 2, this.bounds.y + (bottomUp ? 0 : this.bounds.height));
        }

        public void paint(Graphics2D graphics2D) {
            this.drawBGShape(graphics2D);
            if (this.type != null) {
                graphics2D.setFont(font);
                graphics2D.setColor(typeColor);
                graphics2D.drawString(this.type, this.bounds.x + leftBlank, this.bounds.y + topBlank + this.fontHeight);
                graphics2D.setColor(valueColor);
                graphics2D.drawString(this.value, this.bounds.x + leftBlank + this.fontWidth1, this.bounds.y + topBlank + this.fontHeight);
            }
            for (int i = 0; i < this.inputNum; ++i) {
                graphics2D.setColor(handleColor);
                graphics2D.fillRect(this.bounds.x + i * (handleGap + handleWidth), this.bounds.y + (bottomUp ? this.bounds.height - handleHeight : 0), handleWidth, handleHeight);
                graphics2D.setColor(linkColor);
                graphics2D.setStroke(linkStroke);
                Point point = this.linkedParameters.get(i).getOutputLocation();
                Point point2 = this.getInputLocation(i);
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            }
            graphics2D.setColor(handleColor);
            graphics2D.fillRect(this.bounds.x, this.bounds.y + (bottomUp ? 0 : this.bounds.height - handleHeight), handleWidth, handleHeight);
        }

        public void setLabel(String string, String string2) {
            this.type = string + ": ";
            this.value = string2;
        }

        public void setLocation(int n, int n2) {
            if (this.bounds == null) {
                this.bounds = new Rectangle();
            }
            this.bounds.x = n;
            this.bounds.y = n2;
        }

        public void setSize(int n, int n2) {
            if (this.bounds == null) {
                this.bounds = new Rectangle();
            }
            this.bounds.width = n;
            this.bounds.height = n2;
        }

        public void setSize(FontMetrics fontMetrics) {
            this.fontHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
            this.fontWidth1 = fontMetrics.stringWidth(this.type);
            this.fontWidth2 = fontMetrics.stringWidth(this.value);
            if (this.bounds == null) {
                this.bounds = new Rectangle();
            }
            this.bounds.width = this.fontWidth1 + this.fontWidth2 + leftBlank + rightBlank;
            this.bounds.height = this.fontHeight + topBlank + bottomBlank;
        }

        public void drawBGShape(Graphics2D graphics2D) {
            if (this.bgShape == null) {
                this.bgShape = new GeneralPath(0, 6);
                this.bgShape.moveTo(this.bounds.x, this.bounds.y);
                this.bgShape.lineTo(this.bounds.x, this.bounds.y + this.bounds.height);
                if (bottomUp) {
                    this.bgShape.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height);
                    this.bgShape.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + cornerSizeY);
                    this.bgShape.lineTo(this.bounds.x + this.bounds.width - cornerSizeX, this.bounds.y);
                } else {
                    this.bgShape.lineTo(this.bounds.x + this.bounds.width - cornerSizeX, this.bounds.y + this.bounds.height);
                    this.bgShape.lineTo(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height - cornerSizeY);
                    this.bgShape.lineTo(this.bounds.x + this.bounds.width, this.bounds.y);
                }
                this.bgShape.closePath();
            }
            graphics2D.setColor(bgcolor);
            graphics2D.fill(this.bgShape);
        }

        public void setParameter2(IParameter iParameter) {
            String string = null;
            String string2 = null;
            this.parameter = iParameter;
            if (iParameter instanceof IReferenceParameter) {
                iParameter = ((IReferenceParameter)iParameter).operator();
            }
            if (iParameter instanceof IBoolOp) {
                string = "bool";
                if (iParameter instanceof IBool) {
                    string2 = IParameterGraphic.toString((IBool)iParameter);
                }
            } else if (iParameter instanceof IIntegerOp) {
                string = "int";
                if (iParameter instanceof IInteger) {
                    string2 = IParameterGraphic.toString((IInteger)iParameter);
                }
            } else if (iParameter instanceof IDoubleOp) {
                string = "double";
                if (iParameter instanceof IDouble) {
                    string2 = IParameterGraphic.toString((IDouble)iParameter);
                }
            } else if (iParameter instanceof IVec2Op) {
                string = "vector2D";
                if (iParameter instanceof IVec2) {
                    string2 = IParameterGraphic.toString((IVec2)iParameter);
                }
            } else if (iParameter instanceof IVecOp) {
                string = "vector3D";
                if (iParameter instanceof IVec) {
                    string2 = IParameterGraphic.toString((IVec)iParameter);
                }
            } else if (iParameter instanceof IVec4Op) {
                string = "vector4D";
                if (iParameter instanceof IVec4) {
                    string2 = IParameterGraphic.toString((IVec4)iParameter);
                }
            }
            if (string2 == null) {
                if (!(iParameter instanceof IEntityParameter)) {
                    string2 = iParameter.getClass().toString();
                    int n = -1;
                    n = string2.lastIndexOf(36);
                    if (n > 0) {
                        string2 = string2.substring(++n);
                    } else {
                        n = string2.lastIndexOf(46);
                        if (n > 0) {
                            string2 = string2.substring(++n);
                        } else {
                            n = string2.lastIndexOf(32);
                            if (n > 0) {
                                string2 = string2.substring(++n);
                            }
                        }
                    }
                    string2 = string2.toLowerCase();
                } else {
                    string2 = "unknown";
                }
            }
            this.setLabel(string, string2);
        }

        public void setParameter(IParameter iParameter) {
            String string = null;
            String string2 = null;
            this.parameter = iParameter;
            if (iParameter instanceof IBoolOp) {
                string = "bool";
                IBoolOp iBoolOp = (IBoolOp)iParameter;
                if (iBoolOp instanceof IBoolR) {
                    iBoolOp = ((IBoolR)iBoolOp).operator();
                }
                if (iBoolOp instanceof IBool) {
                    string2 = IParameterGraphic.toString((IBool)iBoolOp);
                } else {
                    if (iBoolOp instanceof IBoolR.And) {
                        string2 = "and";
                    } else if (iBoolOp instanceof IBoolR.Or) {
                        string2 = "or";
                    } else if (iBoolOp instanceof IBoolR.Not) {
                        string2 = "not";
                    } else {
                        IOut.p("no such operator class " + iBoolOp);
                        string2 = "?";
                    }
                    if (showValue) {
                        string2 = string2 + " <" + IParameterGraphic.toString(iBoolOp.get()) + ">";
                    }
                }
            } else if (iParameter instanceof IIntegerOp) {
                string = "int";
                IIntegerOp iIntegerOp = (IIntegerOp)iParameter;
                if (iIntegerOp instanceof IIntegerR) {
                    iIntegerOp = ((IIntegerR)iIntegerOp).operator();
                }
                if (iIntegerOp instanceof IInteger) {
                    string2 = IParameterGraphic.toString((IInteger)iIntegerOp);
                } else {
                    if (iIntegerOp instanceof IIntegerR.Add) {
                        string2 = "add";
                    } else if (iIntegerOp instanceof IIntegerR.Sub) {
                        string2 = "sub";
                    } else if (iIntegerOp instanceof IIntegerR.Mul) {
                        string2 = "mul";
                    } else if (iIntegerOp instanceof IIntegerR.Div) {
                        string2 = "div";
                    } else if (iIntegerOp instanceof IIntegerR.Neg) {
                        string2 = "neg";
                    } else if (iIntegerOp instanceof IIntegerR.Mod) {
                        string2 = "mod";
                    } else if (iIntegerOp instanceof IIntegerR.FromDouble) {
                        string2 = "fromDouble";
                    } else {
                        IOut.p("no such operator " + iIntegerOp);
                        string2 = "?";
                    }
                    if (showValue) {
                        string2 = string2 + " <" + IParameterGraphic.toString(iIntegerOp.get()) + ">";
                    }
                }
            } else if (iParameter instanceof IDoubleOp) {
                string = "double";
                IDoubleOp iDoubleOp = (IDoubleOp)iParameter;
                if (iDoubleOp instanceof IDoubleR) {
                    iDoubleOp = ((IDoubleR)iDoubleOp).operator();
                }
                if (iDoubleOp instanceof IDouble) {
                    string2 = IParameterGraphic.toString((IDouble)iDoubleOp);
                } else {
                    if (iDoubleOp instanceof IDoubleR.Add) {
                        string2 = "add";
                    } else if (iDoubleOp instanceof IDoubleR.Sub) {
                        string2 = "sub";
                    } else if (iDoubleOp instanceof IDoubleR.Mul) {
                        string2 = "mul";
                    } else if (iDoubleOp instanceof IDoubleR.Div) {
                        string2 = "div";
                    } else if (iDoubleOp instanceof IDoubleR.Neg) {
                        string2 = "neg";
                    } else if (iDoubleOp instanceof IDoubleR.Inv) {
                        string2 = "inv";
                    } else if (iDoubleOp instanceof IDoubleR.Abs) {
                        string2 = "abs";
                    } else if (iDoubleOp instanceof IDoubleR.FromInt) {
                        string2 = "fromInt";
                    } else if (iDoubleOp instanceof IDoubleR.Pow) {
                        string2 = "pow";
                    } else if (iDoubleOp instanceof IDoubleR.Sq) {
                        string2 = "sq";
                    } else if (iDoubleOp instanceof IDoubleR.Sqrt) {
                        string2 = "sqrt";
                    } else if (iDoubleOp instanceof IDoubleR.Exp) {
                        string2 = "exp";
                    } else if (iDoubleOp instanceof IDoubleR.Log) {
                        string2 = "log";
                    } else if (iDoubleOp instanceof IDoubleR.Sin) {
                        string2 = "sin";
                    } else if (iDoubleOp instanceof IDoubleR.Cos) {
                        string2 = "cos";
                    } else if (iDoubleOp instanceof IDoubleR.Tan) {
                        string2 = "tan";
                    } else if (iDoubleOp instanceof IDoubleR.ASin) {
                        string2 = "asin";
                    } else if (iDoubleOp instanceof IDoubleR.ACos) {
                        string2 = "acos";
                    } else if (iDoubleOp instanceof IDoubleR.ATan) {
                        string2 = "atan";
                    } else if (iDoubleOp instanceof IDoubleR.ATan2) {
                        string2 = "atan2";
                    } else if (iDoubleOp instanceof IDoubleR.Deg) {
                        string2 = "deg";
                    } else if (iDoubleOp instanceof IDoubleR.Rad) {
                        string2 = "rad";
                    } else if (iDoubleOp instanceof IVec2R.Dot) {
                        string2 = "dot";
                    } else if (iDoubleOp instanceof IVec2R.Angle) {
                        string2 = "angle";
                    } else if (iDoubleOp instanceof IVec2R.Len) {
                        string2 = "len";
                    } else if (iDoubleOp instanceof IVec2R.Len2) {
                        string2 = "len2";
                    } else if (iDoubleOp instanceof IVec2R.X) {
                        string2 = "x";
                    } else if (iDoubleOp instanceof IVec2R.Y) {
                        string2 = "y";
                    } else if (iDoubleOp instanceof IVecR.Dot) {
                        string2 = "dot";
                    } else if (iDoubleOp instanceof IVecR.Angle) {
                        string2 = "angle";
                    } else if (iDoubleOp instanceof IVecR.Len) {
                        string2 = "len";
                    } else if (iDoubleOp instanceof IVecR.Len2) {
                        string2 = "len2";
                    } else if (iDoubleOp instanceof IVecR.X) {
                        string2 = "x";
                    } else if (iDoubleOp instanceof IVecR.Y) {
                        string2 = "y";
                    } else if (iDoubleOp instanceof IVecR.Z) {
                        string2 = "z";
                    } else if (iDoubleOp instanceof IVec4R.X) {
                        string2 = "x";
                    } else if (iDoubleOp instanceof IVec4R.Y) {
                        string2 = "y";
                    } else if (iDoubleOp instanceof IVec4R.Z) {
                        string2 = "z";
                    } else if (iDoubleOp instanceof IVec4R.W) {
                        string2 = "w";
                    } else {
                        IOut.p("no such operator " + iDoubleOp);
                        string2 = "?";
                    }
                    if (showValue) {
                        string2 = string2 + " <" + IParameterGraphic.toString(iDoubleOp.get()) + ">";
                    }
                }
            } else if (iParameter instanceof IVec2Op) {
                string = "vector2D";
                IVec2Op iVec2Op = (IVec2Op)iParameter;
                if (iVec2Op instanceof IVec2R) {
                    iVec2Op = ((IVec2R)iVec2Op).operator();
                }
                if (iVec2Op instanceof IVec2) {
                    string2 = IParameterGraphic.toString((IVec2)iVec2Op);
                } else {
                    if (iVec2Op instanceof IVec2R.Add) {
                        string2 = "add";
                    } else if (iVec2Op instanceof IVec2R.Sub) {
                        string2 = "sub";
                    } else if (iVec2Op instanceof IVec2R.Mul) {
                        string2 = "mul";
                    } else if (iVec2Op instanceof IVec2R.Div) {
                        string2 = "div";
                    } else if (iVec2Op instanceof IVec2R.Neg) {
                        string2 = "neg";
                    } else if (iVec2Op instanceof IVec2R.Rot) {
                        string2 = "rot";
                    } else if (iVec2Op instanceof IVec2R.FromXY) {
                        string2 = "fromXY";
                    } else if (iVec2Op instanceof IVec2R.Unit) {
                        string2 = "unit";
                    } else if (iVec2Op instanceof IVec2R.Ortho) {
                        string2 = "ortho";
                    } else if (iVec2Op instanceof IVec2R.SetLen) {
                        string2 = "setLen";
                    } else {
                        IOut.p("no such operator " + iVec2Op);
                        string2 = "?";
                    }
                    if (showValue) {
                        string2 = string2 + " <" + IParameterGraphic.toString(iVec2Op.get()) + ">";
                    }
                }
            } else if (iParameter instanceof IVecOp) {
                string = "vector3D";
                IVecOp iVecOp = (IVecOp)iParameter;
                if (iVecOp instanceof IVecR) {
                    iVecOp = ((IVecR)iVecOp).operator();
                }
                if (iVecOp instanceof IVec) {
                    string2 = IParameterGraphic.toString((IVec)iVecOp);
                } else {
                    if (iVecOp instanceof IVecR.Add) {
                        string2 = "add";
                    } else if (iVecOp instanceof IVecR.Sub) {
                        string2 = "sub";
                    } else if (iVecOp instanceof IVecR.Mul) {
                        string2 = "mul";
                    } else if (iVecOp instanceof IVecR.Div) {
                        string2 = "div";
                    } else if (iVecOp instanceof IVecR.Neg) {
                        string2 = "neg";
                    } else if (iVecOp instanceof IVecR.FromXYZ) {
                        string2 = "fromXYZ";
                    } else if (iVecOp instanceof IVecR.Cross) {
                        string2 = "cross";
                    } else if (iVecOp instanceof IVec2R.Cross) {
                        string2 = "cross";
                    } else if (iVecOp instanceof IVecR.Rot) {
                        string2 = "rot";
                    } else if (iVecOp instanceof IVecR.Unit) {
                        string2 = "unit";
                    } else if (iVecOp instanceof IVecR.SetLen) {
                        string2 = "setLen";
                    } else {
                        IOut.p("no such operator " + iVecOp);
                        string2 = "?";
                    }
                    if (showValue) {
                        string2 = string2 + " <" + IParameterGraphic.toString(iVecOp.get()) + ">";
                    }
                }
            } else if (iParameter instanceof IVec4Op) {
                string = "vector4D";
                IVec4Op iVec4Op = (IVec4Op)iParameter;
                if (iVec4Op instanceof IVec4R) {
                    iVec4Op = ((IVec4R)iVec4Op).operator();
                }
                if (iVec4Op instanceof IVec4) {
                    string2 = IParameterGraphic.toString((IVec4)iVec4Op);
                } else {
                    if (iVec4Op instanceof IVec4R.FromVec) {
                        string2 = "fromVec";
                    } else if (iVec4Op instanceof IVec4R.FromVecAndW) {
                        string2 = "fromVecW";
                    } else if (iVec4Op instanceof IVec4R.FromXYZ) {
                        string2 = "fromXYZ";
                    } else if (iVec4Op instanceof IVec4R.FromXYZW) {
                        string2 = "fromXYZW";
                    } else if (iVec4Op instanceof IVec4R.Add) {
                        string2 = "add";
                    } else if (iVec4Op instanceof IVec4R.Sub) {
                        string2 = "sub";
                    } else if (iVec4Op instanceof IVec4R.Mul) {
                        string2 = "mul";
                    } else if (iVec4Op instanceof IVec4R.Div) {
                        string2 = "div";
                    } else if (iVec4Op instanceof IVec4R.Neg) {
                        string2 = "neg";
                    } else if (iVec4Op instanceof IVec4R.Cross) {
                        string2 = "cross";
                    } else if (iVec4Op instanceof IVec4R.Rot) {
                        string2 = "rot";
                    } else if (iVec4Op instanceof IVec4R.Unit) {
                        string2 = "unit";
                    } else if (iVec4Op instanceof IVec4R.SetLen) {
                        string2 = "setLen";
                    } else {
                        IOut.p("no such operator " + iVec4Op);
                        string2 = "?";
                    }
                    if (showValue) {
                        string2 = string2 + " <" + IParameterGraphic.toString(iVec4Op.get()) + ">";
                    }
                }
            } else {
                IOut.p("no such class " + iParameter);
            }
            this.setLabel(string, string2);
        }

        public static IParameter[] getOperand2(IParameter iParameter) {
            if (iParameter instanceof IReferenceParameter) {
                iParameter = ((IReferenceParameter)iParameter).operator();
            }
            if (iParameter instanceof IEntityParameter) {
                return null;
            }
            Field[] fieldArray = iParameter.getClass().getFields();
            ArrayList<IParameter> arrayList = null;
            IOut.p(iParameter.toString());
            for (int i = 0; i < fieldArray.length; ++i) {
                IOut.p("field" + i + " " + fieldArray[i].toString());
                if (Modifier.isStatic(fieldArray[i].getModifiers())) continue;
                Class<?> clazz = fieldArray[i].getType();
                Class<?>[] classArray = clazz.getInterfaces();
                boolean bl = false;
                for (int j = 0; !bl && j < classArray.length; ++j) {
                    if (!classArray[j].equals(IParameter.class)) continue;
                    bl = true;
                }
                if (!bl) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<IParameter>();
                }
                IParameter iParameter2 = null;
                try {
                    iParameter2 = (IParameter)fieldArray[i].get(iParameter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (iParameter2 == null) continue;
                arrayList.add(iParameter2);
            }
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            IParameter[] iParameterArray = new IParameter[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                iParameterArray[i] = (IParameter)arrayList.get(i);
            }
            return iParameterArray;
        }

        public static IParameter[] getOperand(IParameter iParameter) {
            if (iParameter instanceof IBoolOp) {
                IBoolOp iBoolOp = (IBoolOp)iParameter;
                if (iBoolOp instanceof IBoolR) {
                    iBoolOp = ((IBoolR)iBoolOp).operator();
                }
                if (iBoolOp instanceof IBool) {
                    return null;
                }
                if (iBoolOp instanceof IBoolR.And) {
                    return new IParameter[]{((IBoolR.And)iBoolOp).v1, ((IBoolR.And)iBoolOp).v2};
                }
                if (iBoolOp instanceof IBoolR.Or) {
                    return new IParameter[]{((IBoolR.Or)iBoolOp).v1, ((IBoolR.Or)iBoolOp).v2};
                }
                if (iBoolOp instanceof IBoolR.Not) {
                    return new IParameter[]{((IBoolR.Not)iBoolOp).v};
                }
                IOut.p("ERROR: no matching operation class in IBoolR");
                IOut.p(iBoolOp);
                return null;
            }
            if (iParameter instanceof IIntegerOp) {
                IIntegerOp iIntegerOp = (IIntegerOp)iParameter;
                if (iIntegerOp instanceof IIntegerR) {
                    iIntegerOp = ((IIntegerR)iIntegerOp).operator();
                }
                if (iIntegerOp instanceof IInteger) {
                    return null;
                }
                if (iIntegerOp instanceof IIntegerR.Add) {
                    return new IParameter[]{((IIntegerR.Add)iIntegerOp).v1, ((IIntegerR.Add)iIntegerOp).v2};
                }
                if (iIntegerOp instanceof IIntegerR.Sub) {
                    return new IParameter[]{((IIntegerR.Sub)iIntegerOp).v1, ((IIntegerR.Sub)iIntegerOp).v2};
                }
                if (iIntegerOp instanceof IIntegerR.Mul) {
                    return new IParameter[]{((IIntegerR.Mul)iIntegerOp).v1, ((IIntegerR.Mul)iIntegerOp).v2};
                }
                if (iIntegerOp instanceof IIntegerR.Div) {
                    return new IParameter[]{((IIntegerR.Div)iIntegerOp).v1, ((IIntegerR.Div)iIntegerOp).v2};
                }
                if (iIntegerOp instanceof IIntegerR.Neg) {
                    return new IParameter[]{((IIntegerR.Neg)iIntegerOp).v};
                }
                if (iIntegerOp instanceof IIntegerR.Mod) {
                    return new IParameter[]{((IIntegerR.Mod)iIntegerOp).v1, ((IIntegerR.Mod)iIntegerOp).v2};
                }
                if (iIntegerOp instanceof IIntegerR.FromDouble) {
                    return new IParameter[]{((IIntegerR.FromDouble)iIntegerOp).v};
                }
                IOut.p("ERROR: no matching operation class in IIntegerR");
                IOut.p(iIntegerOp);
                return null;
            }
            if (iParameter instanceof IDoubleOp) {
                IDoubleOp iDoubleOp = (IDoubleOp)iParameter;
                if (iDoubleOp instanceof IDoubleR) {
                    iDoubleOp = ((IDoubleR)iDoubleOp).operator();
                }
                if (iDoubleOp instanceof IDouble) {
                    return null;
                }
                if (iDoubleOp instanceof IDoubleR.Add) {
                    return new IParameter[]{((IDoubleR.Add)iDoubleOp).v1, ((IDoubleR.Add)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IDoubleR.Sub) {
                    return new IParameter[]{((IDoubleR.Sub)iDoubleOp).v1, ((IDoubleR.Sub)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IDoubleR.Mul) {
                    return new IParameter[]{((IDoubleR.Mul)iDoubleOp).v1, ((IDoubleR.Mul)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IDoubleR.Div) {
                    return new IParameter[]{((IDoubleR.Div)iDoubleOp).v1, ((IDoubleR.Div)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IDoubleR.Neg) {
                    return new IParameter[]{((IDoubleR.Neg)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Inv) {
                    return new IParameter[]{((IDoubleR.Neg)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Abs) {
                    return new IParameter[]{((IDoubleR.Abs)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.FromInt) {
                    return new IParameter[]{((IDoubleR.FromInt)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Pow) {
                    return new IParameter[]{((IDoubleR.Pow)iDoubleOp).v1, ((IDoubleR.Pow)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IDoubleR.Sq) {
                    return new IParameter[]{((IDoubleR.Sq)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Sqrt) {
                    return new IParameter[]{((IDoubleR.Sqrt)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Exp) {
                    return new IParameter[]{((IDoubleR.Exp)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Log) {
                    return new IParameter[]{((IDoubleR.Log)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Sin) {
                    return new IParameter[]{((IDoubleR.Sin)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Cos) {
                    return new IParameter[]{((IDoubleR.Cos)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Tan) {
                    return new IParameter[]{((IDoubleR.Tan)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.ASin) {
                    return new IParameter[]{((IDoubleR.ASin)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.ACos) {
                    return new IParameter[]{((IDoubleR.ACos)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.ATan) {
                    return new IParameter[]{((IDoubleR.ATan)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.ATan2) {
                    return new IParameter[]{((IDoubleR.ATan2)iDoubleOp).y, ((IDoubleR.ATan2)iDoubleOp).x};
                }
                if (iDoubleOp instanceof IDoubleR.Deg) {
                    return new IParameter[]{((IDoubleR.Deg)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IDoubleR.Rad) {
                    return new IParameter[]{((IDoubleR.Rad)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec2R.Dot) {
                    return new IParameter[]{((IVec2R.Dot)iDoubleOp).v1, ((IVec2R.Dot)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IVec2R.Angle) {
                    return new IParameter[]{((IVec2R.Angle)iDoubleOp).v1, ((IVec2R.Angle)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IVec2R.Len) {
                    return new IParameter[]{((IVec2R.Len)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec2R.Len2) {
                    return new IParameter[]{((IVec2R.Len2)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec2R.X) {
                    return new IParameter[]{((IVec2R.X)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec2R.Y) {
                    return new IParameter[]{((IVec2R.Y)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVecR.Dot) {
                    return new IParameter[]{((IVecR.Dot)iDoubleOp).v1, ((IVecR.Dot)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IVecR.Angle) {
                    return new IParameter[]{((IVecR.Angle)iDoubleOp).v1, ((IVecR.Angle)iDoubleOp).v2};
                }
                if (iDoubleOp instanceof IVecR.Len) {
                    return new IParameter[]{((IVecR.Len)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVecR.Len2) {
                    return new IParameter[]{((IVecR.Len2)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVecR.X) {
                    return new IParameter[]{((IVecR.X)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVecR.Y) {
                    return new IParameter[]{((IVecR.Y)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVecR.Z) {
                    return new IParameter[]{((IVecR.Z)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec4R.X) {
                    return new IParameter[]{((IVec4R.X)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec4R.Y) {
                    return new IParameter[]{((IVec4R.Y)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec4R.Z) {
                    return new IParameter[]{((IVec4R.Z)iDoubleOp).v};
                }
                if (iDoubleOp instanceof IVec4R.W) {
                    return new IParameter[]{((IVec4R.W)iDoubleOp).v};
                }
                IOut.p("ERROR: no matching operation class in IDouble");
                IOut.p(iDoubleOp);
                return null;
            }
            if (iParameter instanceof IVec2Op) {
                IVec2Op iVec2Op = (IVec2Op)iParameter;
                if (iVec2Op instanceof IVec2R) {
                    iVec2Op = ((IVec2R)iVec2Op).operator();
                }
                if (iVec2Op instanceof IVec2) {
                    return null;
                }
                if (iVec2Op instanceof IVec2R.Add) {
                    return new IParameter[]{((IVec2R.Add)iVec2Op).v1, ((IVec2R.Add)iVec2Op).v2};
                }
                if (iVec2Op instanceof IVec2R.Sub) {
                    return new IParameter[]{((IVec2R.Sub)iVec2Op).v1, ((IVec2R.Sub)iVec2Op).v2};
                }
                if (iVec2Op instanceof IVec2R.Mul) {
                    return new IParameter[]{((IVec2R.Mul)iVec2Op).v, ((IVec2R.Mul)iVec2Op).d};
                }
                if (iVec2Op instanceof IVec2R.Div) {
                    return new IParameter[]{((IVec2R.Div)iVec2Op).v, ((IVec2R.Div)iVec2Op).d};
                }
                if (iVec2Op instanceof IVec2R.Neg) {
                    return new IParameter[]{((IVec2R.Neg)iVec2Op).v};
                }
                if (iVec2Op instanceof IVec2R.Rot) {
                    return new IParameter[]{((IVec2R.Rot)iVec2Op).v, ((IVec2R.Rot)iVec2Op).angle};
                }
                if (iVec2Op instanceof IVec2R.FromXY) {
                    return new IParameter[]{((IVec2R.FromXY)iVec2Op).x, ((IVec2R.FromXY)iVec2Op).y};
                }
                if (iVec2Op instanceof IVec2R.Unit) {
                    return new IParameter[]{((IVec2R.Unit)iVec2Op).v};
                }
                if (iVec2Op instanceof IVec2R.Ortho) {
                    return new IParameter[]{((IVec2R.Ortho)iVec2Op).v};
                }
                if (iVec2Op instanceof IVec2R.SetLen) {
                    return new IParameter[]{((IVec2R.SetLen)iVec2Op).v, ((IVec2R.SetLen)iVec2Op).l};
                }
                IOut.p("ERROR: no matching operation class in IVec2R");
                IOut.p(iVec2Op);
                return null;
            }
            if (iParameter instanceof IVecOp) {
                IVecOp iVecOp = (IVecOp)iParameter;
                if (iVecOp instanceof IVecR) {
                    iVecOp = ((IVecR)iVecOp).operator();
                }
                if (iVecOp instanceof IVec) {
                    return null;
                }
                if (iVecOp instanceof IVecR.Add) {
                    return new IParameter[]{((IVecR.Add)iVecOp).v1, ((IVecR.Add)iVecOp).v2};
                }
                if (iVecOp instanceof IVecR.Sub) {
                    return new IParameter[]{((IVecR.Sub)iVecOp).v1, ((IVecR.Sub)iVecOp).v2};
                }
                if (iVecOp instanceof IVecR.Mul) {
                    return new IParameter[]{((IVecR.Mul)iVecOp).v, ((IVecR.Mul)iVecOp).d};
                }
                if (iVecOp instanceof IVecR.Div) {
                    return new IParameter[]{((IVecR.Div)iVecOp).v, ((IVecR.Div)iVecOp).d};
                }
                if (iVecOp instanceof IVecR.Neg) {
                    return new IParameter[]{((IVecR.Neg)iVecOp).v};
                }
                if (iVecOp instanceof IVecR.FromXYZ) {
                    return new IParameter[]{((IVecR.FromXYZ)iVecOp).x, ((IVecR.FromXYZ)iVecOp).y, ((IVecR.FromXYZ)iVecOp).z};
                }
                if (iVecOp instanceof IVecR.Cross) {
                    return new IParameter[]{((IVecR.Cross)iVecOp).v1, ((IVecR.Cross)iVecOp).v2};
                }
                if (iVecOp instanceof IVec2R.Cross) {
                    return new IParameter[]{((IVec2R.Cross)iVecOp).v1, ((IVec2R.Cross)iVecOp).v2};
                }
                if (iVecOp instanceof IVecR.Rot) {
                    return new IParameter[]{((IVecR.Rot)iVecOp).v, ((IVecR.Rot)iVecOp).axis, ((IVecR.Rot)iVecOp).angle};
                }
                if (iVecOp instanceof IVecR.Unit) {
                    return new IParameter[]{((IVecR.Unit)iVecOp).v};
                }
                if (iVecOp instanceof IVecR.SetLen) {
                    return new IParameter[]{((IVecR.SetLen)iVecOp).v, ((IVecR.SetLen)iVecOp).l};
                }
                IOut.p("ERROR: no matching operation class in IVecR");
                IOut.p(iVecOp);
                return null;
            }
            if (iParameter instanceof IVec4Op) {
                IVec4Op iVec4Op = (IVec4Op)iParameter;
                if (iVec4Op instanceof IVec4R) {
                    iVec4Op = ((IVec4R)iVec4Op).operator();
                }
                if (iVec4Op instanceof IVec4) {
                    return null;
                }
                if (iVec4Op instanceof IVec4R.FromVec) {
                    return new IParameter[]{((IVec4R.FromVec)iVec4Op).v};
                }
                if (iVec4Op instanceof IVec4R.FromVecAndW) {
                    return new IParameter[]{((IVec4R.FromVecAndW)iVec4Op).v, ((IVec4R.FromVecAndW)iVec4Op).w};
                }
                if (iVec4Op instanceof IVec4R.FromXYZ) {
                    return new IParameter[]{((IVec4R.FromXYZ)iVec4Op).x, ((IVec4R.FromXYZ)iVec4Op).y, ((IVec4R.FromXYZ)iVec4Op).z};
                }
                if (iVec4Op instanceof IVec4R.FromXYZW) {
                    return new IParameter[]{((IVec4R.FromXYZW)iVec4Op).x, ((IVec4R.FromXYZW)iVec4Op).y, ((IVec4R.FromXYZW)iVec4Op).z, ((IVec4R.FromXYZW)iVec4Op).w};
                }
                if (iVec4Op instanceof IVec4R.Add) {
                    return new IParameter[]{((IVec4R.Add)iVec4Op).v1, ((IVec4R.Add)iVec4Op).v2};
                }
                if (iVec4Op instanceof IVec4R.Sub) {
                    return new IParameter[]{((IVec4R.Sub)iVec4Op).v1, ((IVec4R.Sub)iVec4Op).v2};
                }
                if (iVec4Op instanceof IVec4R.Mul) {
                    return new IParameter[]{((IVec4R.Mul)iVec4Op).v, ((IVec4R.Mul)iVec4Op).d};
                }
                if (iVec4Op instanceof IVec4R.Div) {
                    return new IParameter[]{((IVec4R.Div)iVec4Op).v, ((IVec4R.Div)iVec4Op).d};
                }
                if (iVec4Op instanceof IVec4R.Neg) {
                    return new IParameter[]{((IVec4R.Neg)iVec4Op).v};
                }
                if (iVec4Op instanceof IVec4R.Cross) {
                    return new IParameter[]{((IVec4R.Cross)iVec4Op).v1, ((IVec4R.Cross)iVec4Op).v2};
                }
                if (iVec4Op instanceof IVec4R.Rot) {
                    return new IParameter[]{((IVec4R.Rot)iVec4Op).v, ((IVec4R.Rot)iVec4Op).axis, ((IVec4R.Rot)iVec4Op).angle};
                }
                if (iVec4Op instanceof IVec4R.Unit) {
                    return new IParameter[]{((IVec4R.Unit)iVec4Op).v};
                }
                if (iVec4Op instanceof IVec4R.SetLen) {
                    return new IParameter[]{((IVec4R.SetLen)iVec4Op).v, ((IVec4R.SetLen)iVec4Op).l};
                }
                IOut.p("ERROR: no matching operation class in IVec4R");
                IOut.p(iVec4Op);
                return null;
            }
            IOut.p("ERROR: no matching class");
            IOut.p(iParameter);
            return null;
        }

        public static void setupLink(ArrayList<IParameterGraphic> arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                IParameterGraphic iParameterGraphic = arrayList.get(i);
                IParameter iParameter = iParameterGraphic.parameter;
                IParameter[] iParameterArray = IParameterGraphic.getOperand(iParameter);
                if (iParameterArray == null) continue;
                for (int j = 0; j < iParameterArray.length; ++j) {
                    iParameterGraphic.addLink(iParameterArray[j], arrayList);
                }
            }
        }

        public static String toString(IBool iBool) {
            if (iBool.x) {
                return "true";
            }
            return "false";
        }

        public static String toString(IInteger iInteger) {
            return String.valueOf(iInteger.x);
        }

        public static String toString(double d) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (numberFormat instanceof DecimalFormat) {
                if (Double.isNaN(d)) {
                    return "NaN";
                }
                if (Math.abs(d) == 0.0) {
                    return "0";
                }
                if (Math.abs(d) < 0.1) {
                    ((DecimalFormat)numberFormat).applyPattern("0.###E0");
                } else if (Math.abs(d) < 1.0) {
                    ((DecimalFormat)numberFormat).setMaximumFractionDigits(3);
                } else if (Math.abs(d) < 10.0) {
                    ((DecimalFormat)numberFormat).setMaximumFractionDigits(3);
                } else if (Math.abs(d) < 100.0) {
                    ((DecimalFormat)numberFormat).setMaximumFractionDigits(2);
                } else if (Math.abs(d) < 1000.0) {
                    ((DecimalFormat)numberFormat).setMaximumFractionDigits(1);
                } else if (Math.abs(d) < 10000.0) {
                    ((DecimalFormat)numberFormat).applyPattern("0.###E0");
                }
                return numberFormat.format(d);
            }
            return String.valueOf(d);
        }

        public static String toString(IDouble iDouble) {
            return IParameterGraphic.toString(iDouble.x);
        }

        public static String toString(IVec2 iVec2) {
            return "(" + IParameterGraphic.toString(iVec2.x) + "," + IParameterGraphic.toString(iVec2.y) + ")";
        }

        public static String toString(IVec iVec) {
            return "(" + IParameterGraphic.toString(iVec.x) + "," + IParameterGraphic.toString(iVec.y) + "," + IParameterGraphic.toString(iVec.z) + ")";
        }

        public static String toString(IVec4 iVec4) {
            return "(" + IParameterGraphic.toString(iVec4.x) + "," + IParameterGraphic.toString(iVec4.y) + "," + IParameterGraphic.toString(iVec4.z) + "," + IParameterGraphic.toString(iVec4.w) + ")";
        }
    }
}

