/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IConfig;
import igeo.core.IGraphicObject;
import igeo.core.IObject;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceI;
import igeo.geo.ISurfaceR;
import igeo.geo.IVec;
import igeo.geo.IVec2;
import igeo.gui.IGLQuadMatrix;
import igeo.gui.IGLTriangles;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicGL;
import igeo.gui.ISurfaceMesh;
import igeo.gui.ITrimLoopGraphic;
import java.util.ArrayList;
import javax.media.opengl.GL;

public class ISurfaceGraphicFillGL
extends IGraphicObject {
    public static final boolean insertPointOnDegree1TwistedSurface = true;
    public int isoparmRatioU = IConfig.surfaceIsoparmResolution;
    public int isoparmRatioV = IConfig.surfaceIsoparmResolution;
    public ISurfaceI surface = null;
    public IGLQuadMatrix quadMatrix = null;
    public IGLTriangles triangles = null;
    public boolean initialized = false;

    public ISurfaceGraphicFillGL(ISurface iSurface) {
        super(iSurface);
        this.surface = iSurface.surface;
    }

    public ISurfaceGraphicFillGL(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface;
    }

    public ISurfaceGraphicFillGL(IObject iObject, ISurfaceI iSurfaceI) {
        super(iObject);
        this.surface = iSurfaceI;
    }

    public ISurfaceGraphicFillGL(ISurface iSurface, int n, int n2) {
        super(iSurface);
        this.isoparmRatioU = n;
        this.isoparmRatioV = n2;
    }

    public ISurfaceGraphicFillGL(ISurfaceR iSurfaceR, int n, int n2) {
        super(iSurfaceR);
        this.isoparmRatioU = n;
        this.isoparmRatioV = n2;
    }

    public void initSurface() {
        if (!this.surface.hasTrim() || !this.surface.hasInnerTrim() && this.surface.hasDefaultTrim()) {
            this.initWithoutTrim();
        } else {
            this.initWithTrim();
        }
        this.initialized = true;
    }

    public void initWithoutTrim() {
        double[] dArray;
        int n;
        int n2;
        int n3;
        double[] dArray2;
        int n4;
        if (this.surface.udeg() == 1) {
            n4 = this.surface.unum();
            dArray2 = new double[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                dArray2[n3] = this.surface.u(n3, 0.0);
            }
        } else {
            n4 = this.surface.uepNum();
            n3 = (n4 - 1) * this.isoparmRatioU + 1;
            dArray2 = new double[n3];
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < this.isoparmRatioU; ++n) {
                    if (n2 >= n4 - 1 && n != 0) continue;
                    dArray2[n2 * this.isoparmRatioU + n] = this.surface.u(n2, (double)n / (double)this.isoparmRatioU);
                }
            }
        }
        if (this.surface.vdeg() == 1) {
            n4 = this.surface.vnum();
            dArray = new double[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                dArray[n3] = this.surface.v(n3, 0.0);
            }
        } else {
            n4 = this.surface.vepNum();
            n3 = (n4 - 1) * this.isoparmRatioV + 1;
            dArray = new double[n3];
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < this.isoparmRatioV; ++n) {
                    if (n2 >= n4 - 1 && n != 0) continue;
                    dArray[n2 * this.isoparmRatioV + n] = this.surface.v(n2, (double)n / (double)this.isoparmRatioV);
                }
            }
        }
        if (this.surface.udeg() == 1 && this.surface.vdeg() == 1) {
            int n5;
            boolean[] blArray = new boolean[dArray2.length - 1];
            boolean[] blArray2 = new boolean[dArray.length - 1];
            n2 = 0;
            for (n = 0; n < dArray2.length - 1; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n < dArray.length - 1; ++n) {
                blArray2[n] = false;
            }
            for (n = 0; n < dArray2.length - 1; ++n) {
                for (n5 = 0; n5 < dArray.length - 1; ++n5) {
                    if (IVec.isFlat(this.surface.pt(dArray2[n], dArray[n5]), this.surface.pt(dArray2[n + 1], dArray[n5]), this.surface.pt(dArray2[n + 1], dArray[n5 + 1]), this.surface.pt(dArray2[n], dArray[n5 + 1]))) continue;
                    blArray[n] = true;
                    blArray2[n5] = true;
                    n2 = 1;
                }
            }
            if (n2 != 0) {
                int n6;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (n5 = 0; n5 < dArray2.length - 1; ++n5) {
                    arrayList.add(dArray2[n5]);
                    if (!blArray[n5]) continue;
                    for (n6 = 1; n6 < this.isoparmRatioU; ++n6) {
                        arrayList.add((dArray2[n5 + 1] - dArray2[n5]) * (double)n6 / (double)this.isoparmRatioU + dArray2[n5]);
                    }
                }
                arrayList.add(dArray2[dArray2.length - 1]);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                for (n6 = 0; n6 < dArray.length - 1; ++n6) {
                    arrayList2.add(dArray[n6]);
                    if (!blArray2[n6]) continue;
                    for (int i = 1; i < this.isoparmRatioV; ++i) {
                        arrayList2.add((dArray[n6 + 1] - dArray[n6]) * (double)i / (double)this.isoparmRatioV + dArray[n6]);
                    }
                }
                arrayList2.add(dArray[dArray.length - 1]);
                dArray2 = new double[arrayList.size()];
                for (n6 = 0; n6 < arrayList.size(); ++n6) {
                    dArray2[n6] = (Double)arrayList.get(n6);
                }
                dArray = new double[arrayList2.size()];
                for (n6 = 0; n6 < arrayList2.size(); ++n6) {
                    dArray[n6] = (Double)arrayList2.get(n6);
                }
            }
        }
        IVec[][] iVecArray = new IVec[dArray2.length][dArray.length];
        IVec[][] iVecArray2 = new IVec[dArray2.length][dArray.length];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (int i = 0; i < dArray.length; ++i) {
                iVecArray[n2][i] = this.surface.pt(dArray2[n2], dArray[i]).get();
                iVecArray2[n2][i] = this.surface.normal(dArray2[n2], dArray[i]).get().unit();
            }
        }
        this.quadMatrix = new IGLQuadMatrix(iVecArray, iVecArray2);
    }

    public void initWithTrim() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        ITrimLoopGraphic[] iTrimLoopGraphicArray = null;
        ITrimLoopGraphic[] iTrimLoopGraphicArray2 = null;
        if (this.surface.hasOuterTrim()) {
            iTrimLoopGraphicArray = new ITrimLoopGraphic[this.surface.outerTrimLoopNum()];
            for (n5 = 0; n5 < this.surface.outerTrimLoopNum(); ++n5) {
                iTrimLoopGraphicArray[n5] = new ITrimLoopGraphic(this.surface.outerTrimLoop(n5), true, IConfig.surfaceTrimEdgeResolution);
            }
        }
        if (this.surface.hasInnerTrim()) {
            iTrimLoopGraphicArray2 = new ITrimLoopGraphic[this.surface.innerTrimLoopNum()];
            for (n5 = 0; n5 < this.surface.innerTrimLoopNum(); ++n5) {
                iTrimLoopGraphicArray2[n5] = new ITrimLoopGraphic(this.surface.innerTrimLoop(n5), false, IConfig.surfaceTrimEdgeResolution);
            }
        }
        n5 = this.isoparmRatioU * (this.surface.uepNum() - 1) + 1;
        int n6 = this.isoparmRatioV * (this.surface.vepNum() - 1) + 1;
        double[] dArray = null;
        double[] dArray2 = null;
        if (this.surface.udeg() == 1) {
            n5 = this.surface.unum();
            dArray = new double[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                dArray[n4] = (double)n4 / (double)(n5 - 1);
            }
        } else {
            dArray = new double[n5];
            for (n4 = 0; n4 < this.surface.uepNum(); ++n4) {
                for (n3 = 0; n3 < this.isoparmRatioU && n4 < this.surface.uepNum() - 1 || n3 == 0; ++n3) {
                    dArray[n4 * this.isoparmRatioU + n3] = this.surface.u(n4, (double)n3 / (double)this.isoparmRatioU);
                }
            }
        }
        if (this.surface.vdeg() == 1) {
            n6 = this.surface.vnum();
            dArray2 = new double[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                dArray2[n4] = (double)n4 / (double)(n6 - 1);
            }
        } else {
            dArray2 = new double[n6];
            for (n4 = 0; n4 < this.surface.vepNum(); ++n4) {
                for (n3 = 0; n3 < this.isoparmRatioV && n4 < this.surface.vepNum() - 1 || n3 == 0; ++n3) {
                    dArray2[n4 * this.isoparmRatioV + n3] = this.surface.v(n4, (double)n3 / (double)this.isoparmRatioV);
                }
            }
        }
        if (this.surface.udeg() == 1 && this.surface.vdeg() == 1) {
            int n7;
            int n8;
            boolean[] blArray = new boolean[dArray.length - 1];
            boolean[] blArray2 = new boolean[dArray2.length - 1];
            n2 = 0;
            for (n8 = 0; n8 < dArray.length - 1; ++n8) {
                blArray[n8] = false;
            }
            for (n8 = 0; n8 < dArray2.length - 1; ++n8) {
                blArray2[n8] = false;
            }
            for (n8 = 0; n8 < dArray.length - 1; ++n8) {
                for (n7 = 0; n7 < dArray2.length - 1; ++n7) {
                    if (IVec.isFlat(this.surface.pt(dArray[n8], dArray2[n7]), this.surface.pt(dArray[n8 + 1], dArray2[n7]), this.surface.pt(dArray[n8 + 1], dArray2[n7 + 1]), this.surface.pt(dArray[n8], dArray2[n7 + 1]))) continue;
                    blArray[n8] = true;
                    blArray2[n7] = true;
                    n2 = 1;
                }
            }
            if (n2 != 0) {
                int n9;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (n7 = 0; n7 < dArray.length - 1; ++n7) {
                    arrayList.add(dArray[n7]);
                    if (!blArray[n7]) continue;
                    for (n9 = 1; n9 < this.isoparmRatioU; ++n9) {
                        arrayList.add((dArray[n7 + 1] - dArray[n7]) * (double)n9 / (double)this.isoparmRatioU + dArray[n7]);
                    }
                }
                arrayList.add(dArray[dArray.length - 1]);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                for (n9 = 0; n9 < dArray2.length - 1; ++n9) {
                    arrayList2.add(dArray2[n9]);
                    if (!blArray2[n9]) continue;
                    for (n = 1; n < this.isoparmRatioV; ++n) {
                        arrayList2.add((dArray2[n9 + 1] - dArray2[n9]) * (double)n / (double)this.isoparmRatioV + dArray2[n9]);
                    }
                }
                arrayList2.add(dArray2[dArray2.length - 1]);
                dArray = new double[arrayList.size()];
                for (n9 = 0; n9 < arrayList.size(); ++n9) {
                    dArray[n9] = (Double)arrayList.get(n9);
                }
                n5 = dArray.length;
                dArray2 = new double[arrayList2.size()];
                for (n9 = 0; n9 < arrayList2.size(); ++n9) {
                    dArray2[n9] = (Double)arrayList2.get(n9);
                }
                n6 = dArray2.length;
            }
        }
        IVec2[][] iVec2Array = new IVec2[n5][n6];
        for (int i = 0; i < n5; ++i) {
            for (n2 = 0; n2 < n6; ++n2) {
                iVec2Array[i][n2] = new IVec2(dArray[i], dArray2[n2]);
            }
        }
        IVec2[][] iVec2Array2 = null;
        if (iTrimLoopGraphicArray != null) {
            iVec2Array2 = new IVec2[iTrimLoopGraphicArray.length][];
            for (n2 = 0; n2 < iTrimLoopGraphicArray.length; ++n2) {
                iVec2Array2[n2] = iTrimLoopGraphicArray[n2].getPolyline2D().get();
            }
        }
        IVec2[][] iVec2Array3 = null;
        if (iTrimLoopGraphicArray2 != null) {
            iVec2Array3 = new IVec2[iTrimLoopGraphicArray2.length][];
            for (int i = 0; i < iTrimLoopGraphicArray2.length; ++i) {
                iVec2Array3[i] = iTrimLoopGraphicArray2[i].getPolyline2D().get();
            }
        }
        IVec2[][] iVec2Array4 = ISurfaceMesh.getTriangles(iVec2Array, iVec2Array2, iVec2Array3);
        IVec[][] iVecArray = new IVec[iVec2Array4.length][3];
        IVec[][] iVecArray2 = new IVec[iVec2Array4.length][3];
        for (n = 0; n < iVec2Array4.length; ++n) {
            for (int i = 0; i < iVec2Array4[n].length; ++i) {
                iVecArray[n][i] = this.surface.pt(iVec2Array4[n][i]).get();
                iVecArray2[n][i] = this.surface.normal(iVec2Array4[n][i]).get().unit();
            }
        }
        this.triangles = new IGLTriangles(iVecArray, iVecArray2);
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL() && iGraphicMode.isFill();
    }

    public void draw(IGraphics iGraphics) {
        GL gL;
        if (!this.initialized) {
            this.initSurface();
        }
        if ((gL = iGraphics.getGL()) != null) {
            float f = ISurfaceGraphicGL.defaultColorRed;
            float f2 = ISurfaceGraphicGL.defaultColorGreen;
            float f3 = ISurfaceGraphicGL.defaultColorBlue;
            float f4 = ISurfaceGraphicGL.defaultColorAlpha;
            if (this.color != null) {
                f = (float)this.color.getRed() / 255.0f;
                f2 = (float)this.color.getGreen() / 255.0f;
                f3 = (float)this.color.getBlue() / 255.0f;
                f4 = (float)this.color.getAlpha() / 255.0f;
            }
            if (iGraphics.view().mode().isTransparent()) {
                f4 = (float)transparentModeAlpha;
            }
            if (iGraphics.view().mode().isLight()) {
                float[] fArray = new float[]{f, f2, f3, f4};
                gL.glMaterialfv(1032, 4608, fArray, 0);
                gL.glMaterialfv(1032, 4609, fArray, 0);
                gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
                gL.glColor4f(f, f2, f3, 0.0f);
            } else {
                gL.glColor4f(f, f2, f3, f4);
            }
            if (this.quadMatrix != null) {
                this.quadMatrix.draw(gL);
            }
            if (this.triangles != null) {
                this.triangles.draw(gL);
            }
        }
    }
}

