/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IConfig;
import igeo.core.IDynamicObjectI;
import igeo.core.IObject;
import igeo.core.IServer;
import igeo.core.IServerI;
import java.util.ArrayList;

public class IDynamicServer
implements Runnable {
    public Thread thread;
    public int speed = IConfig.dynamicsUpdateSpeed;
    public IServer server;
    public boolean runningDynamics = false;
    public boolean startedOnce = false;
    public ArrayList<IDynamicObjectI> dynamics;

    public IDynamicServer(IServerI iServerI) {
        this.server = iServerI.server();
        this.dynamics = new ArrayList();
    }

    public synchronized void add(IObject iObject) {
        for (IDynamicObjectI iDynamicObjectI : iObject.dynamics) {
            this.add(iDynamicObjectI);
        }
    }

    public synchronized void add(IDynamicObjectI iDynamicObjectI) {
        if (!this.dynamics.contains(iDynamicObjectI)) {
            this.dynamics.add(iDynamicObjectI);
            if (!this.startedOnce) {
                this.start();
            }
        }
    }

    public int num() {
        return this.dynamics.size();
    }

    public IDynamicObjectI get(int n) {
        return this.dynamics.get(n);
    }

    public synchronized void remove(int n) {
        this.dynamics.remove(n);
    }

    public synchronized void remove(IDynamicObjectI iDynamicObjectI) {
        this.dynamics.remove(iDynamicObjectI);
    }

    public synchronized void clear() {
        this.dynamics.clear();
    }

    public void pause() {
        this.runningDynamics = false;
    }

    public void resume() {
        this.runningDynamics = true;
    }

    public void start() {
        this.thread = new Thread(this);
        this.runningDynamics = true;
        this.startedOnce = true;
        this.thread.start();
    }

    public void stop() {
        this.runningDynamics = false;
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread) {
            if (this.runningDynamics) {
                IDynamicServer iDynamicServer = this;
                synchronized (iDynamicServer) {
                    for (int i = 0; i < this.dynamics.size(); ++i) {
                        for (int j = i + 1; j < this.dynamics.size(); ++j) {
                            this.dynamics.get(i).interact(this.dynamics.get(j));
                        }
                    }
                    for (IDynamicObjectI iDynamicObjectI : this.dynamics) {
                        iDynamicObjectI.update();
                    }
                }
            }
            try {
                Thread.sleep(this.speed);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

