/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.ILayer;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.geo.IArc;
import igeo.geo.IBoolI;
import igeo.geo.ICircle;
import igeo.geo.ICurve;
import igeo.geo.ICurveCreator;
import igeo.geo.ICurveI;
import igeo.geo.ICylinder;
import igeo.geo.IDouble;
import igeo.geo.IDoubleI;
import igeo.geo.IMesh;
import igeo.geo.IPoint;
import igeo.geo.ISphere;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceCreator;
import igeo.geo.ISurfaceI;
import igeo.geo.IVec;
import igeo.geo.IVec2I;
import igeo.geo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IPanel;
import igeo.io.IIO;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class IG
implements IServerI {
    public static final Object lock = new Object();
    public static final String GL = "igeo.p.PIGraphicsGL";
    protected static ArrayList<IG> iglist = null;
    protected static int currentId = -1;
    public IServer server;
    public IPanel panel = null;
    public String inputFile;
    public String outputFile;
    public String basePath = ".";

    public static int majorVersion() {
        return 0;
    }

    public static int minorVersion() {
        return 7;
    }

    public static int buildVersion() {
        return 2;
    }

    public static int revisionVersion() {
        return 8;
    }

    public static Calendar versionDate() {
        return new GregorianCalendar(2011, 10, 15);
    }

    public static String version() {
        return String.valueOf(IG.majorVersion()) + "." + String.valueOf(IG.minorVersion()) + "." + String.valueOf(IG.buildVersion()) + "." + String.valueOf(IG.revisionVersion());
    }

    public static IG init() {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG();
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG init(IPanel iPanel) {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG(iPanel);
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG current() {
        if (iglist == null || currentId < 0 || currentId >= iglist.size()) {
            return null;
        }
        return iglist.get(currentId);
    }

    public static void setCurrent(IG iG) {
        int n = iglist.indexOf(iG);
        if (n >= 0 && n < iglist.size()) {
            currentId = n;
        } else {
            iglist.add(iG);
            currentId = iglist.size() - 1;
        }
        ICurveCreator.server(iG);
        ISurfaceCreator.server(iG);
    }

    public static void setCurrent(IPanel iPanel) {
        for (int i = 0; i < iglist.size(); ++i) {
            if (IG.iglist.get((int)i).panel != iPanel) continue;
            currentId = i;
            ICurveCreator.server(iglist.get(i));
            ISurfaceCreator.server(iglist.get(i));
            return;
        }
        IOut.err("no IG instance found for " + iPanel);
    }

    public static IG getIG(IPanel iPanel) {
        for (IG iG : iglist) {
            if (iG.panel != iPanel) continue;
            return iG;
        }
        return null;
    }

    public static boolean open(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return false;
        }
        return iG.openFile(string);
    }

    public static boolean save(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return false;
        }
        return iG.saveFile(string);
    }

    public static void outputFile(String string) {
        IG iG = IG.current();
        if (iG != null) {
            iG.setOutputFile(string);
        }
    }

    public static String outputFile() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getOutputFile();
    }

    public static void inputFile(String string) {
        IG iG = IG.current();
        if (iG != null) {
            iG.setInputFile(string);
        }
    }

    public static String inputFile() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getInputFile();
    }

    public static IPoint[] points() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getPoints();
    }

    public static ICurve[] curves() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getCurves();
    }

    public static ISurface[] surfaces() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getSurfaces();
    }

    public static IMesh[] meshes() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getMeshes();
    }

    public static IObject[] objects(Class clazz) {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getObjects(clazz);
    }

    public static ILayer layer(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getLayer(string);
    }

    public static ILayer[] layers() {
        IG iG = IG.current();
        if (iG == null) {
            return null;
        }
        return iG.getAllLayers();
    }

    public static void delLayer(String string) {
        IG iG = IG.current();
        if (iG == null) {
            return;
        }
        iG.removeLayer(string);
    }

    public static void focus() {
        IG iG = IG.current();
        if (iG == null) {
            return;
        }
        iG.focusView();
    }

    public static boolean isGL() {
        IG iG = IG.current();
        if (iG == null) {
            IOut.err("no IG found");
            return true;
        }
        if (iG.server().graphicServer() == null) {
            IOut.err("no graphic server found");
            return true;
        }
        return iG.server().graphicServer().isGL();
    }

    public static void graphicMode(IGraphicMode iGraphicMode) {
        IG iG = IG.current();
        if (iG == null) {
            return;
        }
        iG.server().setGraphicMode(iGraphicMode);
    }

    public static void wireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, false, true, false));
    }

    public static void fill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, false));
    }

    public static void fillWithWireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, false));
    }

    public static void transparentFill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, true));
    }

    public static void transparentFillWithWireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, true));
    }

    public static void p(Object object) {
        IOut.printlnWithOffset(object, 1);
    }

    public static void p() {
        IOut.printlnWithOffset(1);
    }

    public static void enabePrintPrefix() {
        IOut.enablePrefix();
    }

    public static void disablePrintPrefix() {
        IOut.disablePrefix();
    }

    protected IG() {
        this.server = new IServer(this);
    }

    protected IG(IPanel iPanel) {
        this.server = new IServer(this, iPanel);
        this.panel = iPanel;
        iPanel.setIG(this);
    }

    public boolean openFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
        }
        boolean bl = IIO.open(string, (IServerI)this);
        this.server.update();
        this.inputFile = string;
        this.focusView();
        return bl;
    }

    public boolean saveFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
            File file2 = new File(this.basePath);
            if (!file2.isDirectory()) {
                IOut.debug(20, "creating directory" + file2.toString());
                if (!file2.mkdir()) {
                    IOut.err("failed to create directory: " + file2.toString());
                }
            }
        }
        return IIO.save(string, (IServerI)this);
    }

    public boolean save() {
        if (this.outputFile == null) {
            IOut.err("output filename is not set. not saved");
            return false;
        }
        return this.saveFile(this.outputFile);
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String setBasePath(String string) {
        this.basePath = string;
        return this.basePath;
    }

    public ILayer getLayer(String string) {
        return this.server.getLayer(string);
    }

    public ILayer[] getAllLayers() {
        return this.server.getAllLayers();
    }

    public void removeLayer(String string) {
        this.server.removeLayer(string);
    }

    public IPoint[] getPoints() {
        return this.server.getPoints();
    }

    public ICurve[] getCurves() {
        return this.server.getCurves();
    }

    public ISurface[] getSurfaces() {
        return this.server.getSurfaces();
    }

    public IMesh[] getMeshes() {
        return this.server.getMeshes();
    }

    public IObject[] getObjects(Class clazz) {
        return this.server.getObjects(clazz);
    }

    public void focusView() {
        if (this.panel != null) {
            this.panel.focus();
        }
    }

    public IServer server() {
        return this.server;
    }

    public void clear() {
        this.server.clear();
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ICurveCreator.curve(iVecIArray, n, dArray, d, d2);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, double[] dArray) {
        return ICurveCreator.curve(iVecIArray, n, dArray);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n) {
        return ICurveCreator.curve(iVecIArray, n);
    }

    public static ICurve curve(IVecI[] iVecIArray) {
        return ICurveCreator.curve(iVecIArray);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, boolean bl) {
        return ICurveCreator.curve(iVecIArray, n, bl);
    }

    public static ICurve curve(IVecI[] iVecIArray, boolean bl) {
        return ICurveCreator.curve(iVecIArray, bl);
    }

    public static ICurve curve(IVecI iVecI, IVecI iVecI2) {
        return ICurveCreator.curve(iVecI, iVecI2);
    }

    public static ICurve curve(double d, double d2, double d3, double d4, double d5, double d6) {
        return ICurveCreator.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve curve(double[][] dArray) {
        return ICurveCreator.curve(dArray);
    }

    public static ICurve curve(double[][] dArray, int n) {
        return ICurveCreator.curve(dArray, n);
    }

    public static ICurve curve(double[][] dArray, boolean bl) {
        return ICurveCreator.curve(dArray, bl);
    }

    public static ICurve curve(double[][] dArray, int n, boolean bl) {
        return ICurveCreator.curve(dArray, n, bl);
    }

    public static ICurve curve(ICurveI iCurveI) {
        return ICurveCreator.curve(iCurveI);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return IG.curve(iVecIArray, n, dArray, d, d2);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, double[] dArray) {
        return IG.curve(iVecIArray, n, dArray);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n) {
        return IG.curve(iVecIArray, n);
    }

    public static ICurve crv(IVecI[] iVecIArray) {
        return IG.curve(iVecIArray);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, boolean bl) {
        return IG.curve(iVecIArray, n, bl);
    }

    public static ICurve crv(IVecI[] iVecIArray, boolean bl) {
        return IG.curve(iVecIArray, bl);
    }

    public static ICurve crv(IVecI iVecI, IVecI iVecI2) {
        return IG.curve(iVecI, iVecI2);
    }

    public static ICurve crv(double d, double d2, double d3, double d4, double d5, double d6) {
        return IG.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve crv(double[][] dArray) {
        return IG.curve(dArray);
    }

    public static ICurve crv(double[][] dArray, int n) {
        return IG.curve(dArray, n);
    }

    public static ICurve crv(double[][] dArray, boolean bl) {
        return IG.curve(dArray, bl);
    }

    public static ICurve crv(double[][] dArray, int n, boolean bl) {
        return IG.curve(dArray, n, bl);
    }

    public static ICurve crv(ICurveI iCurveI) {
        return IG.curve(iCurveI);
    }

    public static ICurve rect(IVecI iVecI, double d, double d2) {
        return ICurveCreator.rect(iVecI, d, d2);
    }

    public static ICurve rect(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.rect(iVecI, iVecI2, iVecI3);
    }

    public static ICurve rect(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.rect(d, d2, d3, d4, d5);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d) {
        return ICurveCreator.circle(iVecI, iVecI2, d);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, double d) {
        return ICurveCreator.circle(iVecI, d);
    }

    public static ICircle circle(double d, double d2, double d3, double d4) {
        return ICurveCreator.circle(d, d2, d3, d4);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ICurveCreator.circle(iVecI, iVecI2, d, d2);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, double d, double d2) {
        return ICurveCreator.circle(iVecI, d, d2);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.circle(d, d2, d3, d4, d5);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, d2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, d, bl);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, d, bl);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, boolean bl) {
        return ICurveCreator.circle(d, d2, d3, d4, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(IVecI iVecI, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, double d5, boolean bl) {
        return ICurveCreator.circle(d, d2, d3, d4, d5, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, bl);
    }

    public static ICircle ellipse(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.ellipse(iVecI, iVecI2, iVecI3);
    }

    public static ICircle ellipse(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.ellipse(iVecI, iDoubleI, iDoubleI2);
    }

    public static ICircle ellipse(IVecI iVecI, double d, double d2) {
        return ICurveCreator.ellipse(iVecI, d, d2);
    }

    public static ICircle ellipse(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.ellipse(d, d2, d3, d4, d5);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, d);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, double d) {
        return ICurveCreator.arc(iVecI, iVecI2, d);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ICurveCreator.arc(iVecI, iVecI2, iDoubleI);
    }

    public static IArc arc(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return ICurveCreator.arc(d, d2, d3, d4, d5, d6, d7);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iBoolI);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, bl);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iVecI4, iVecI5);
    }

    public static ICurve offset(ICurveI iCurveI, double d, IVecI iVecI) {
        return ICurveCreator.offset(iCurveI, d, iVecI);
    }

    public static ICurve offset(ICurveI iCurveI, IDoubleI iDoubleI, IVecI iVecI) {
        return ICurveCreator.offset(iCurveI, iDoubleI, iVecI);
    }

    public static ICurve offset(ICurveI iCurveI, double d) {
        return ICurveCreator.offset(iCurveI, d);
    }

    public static ICurve offset(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ICurveCreator.offset(iCurveI, iDoubleI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI) {
        return IVec.offset(iVecArray, d, iVecI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecArray, d, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecIArray, d, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI) {
        return IVec.offset(iVecIArray, d, iVecI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI) {
        return IVec.offset(iVecIArray, iDoubleI, iVecI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IVecI[] iVecIArray2, double d) {
        return IVec.offset(iVecIArray, iVecIArray2, d);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IVecI[] iVecIArray2, IDoubleI iDoubleI) {
        return IVec.offset(iVecIArray, iVecIArray2, iDoubleI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d) {
        return IVec.offset(iVecArray, d);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, boolean bl) {
        return IVec.offset(iVecArray, d, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, boolean bl) {
        return IVec.offset(iVecIArray, d, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d) {
        return IVec.offset(iVecIArray, d);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return IVec.offset(iVecIArray, iDoubleI);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2);
    }

    public static ISurface surface(IVecI[][] iVecIArray) {
        return ISurfaceCreator.surface(iVecIArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface surface(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(iVecIArray, bl, bl2);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.surface(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ISurfaceCreator.surface(iVecI, iVecI2, iVecI3);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return ISurfaceCreator.surface(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return ISurfaceCreator.surface(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface surface(double[][][] dArray) {
        return ISurfaceCreator.surface(dArray);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2) {
        return ISurfaceCreator.surface(dArray, n, n2);
    }

    public static ISurface surface(double[][][] dArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(dArray, bl, bl2);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(dArray, n, n2, bl, bl2);
    }

    public static ISurface surface(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.surface(iSurfaceI);
    }

    public static ISurface surface(ICurveI iCurveI) {
        return ISurfaceCreator.surface(iCurveI);
    }

    public static ISurface surface(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.surface(iCurveIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray) {
        return ISurfaceCreator.surface(iVecIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.surface(iVecIArray, n);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.surface(iVecIArray, n, dArray);
    }

    public static ISphere sphere(double d, double d2, double d3, double d4) {
        return ISurfaceCreator.sphere(d, d2, d3, d4);
    }

    public static ISphere sphere(IVecI iVecI, double d) {
        return ISurfaceCreator.sphere(iVecI, d);
    }

    public static ISphere sphere(IVecI iVecI, IDoubleI iDoubleI) {
        return ISurfaceCreator.sphere(iVecI, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, d);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, d, d2);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.cone(iVecI, iVecI2, d);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ISurfaceCreator.cone(iVecI, iVecI2, iDoubleI);
    }

    public static ISurface plane(IVecI iVecI, double d, double d2) {
        return ISurfaceCreator.plane(iVecI, d, d2);
    }

    public static ISurface plane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ISurfaceCreator.plane(iVecI, iVecI2, iVecI3);
    }

    public static ISurface extrude(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.extrude(iVecIArray, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iCurve);
    }

    public static ISurface extrude(ICurveI iCurveI, IVecI iVecI) {
        return ISurfaceCreator.extrude(iCurveI, iVecI);
    }

    public static ISurface extrude(ICurveI iCurveI, double d) {
        return ISurfaceCreator.extrude(iCurveI, d);
    }

    public static ISurface extrude(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iCurveI, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.extrude(iVecIArray, iVecIArray2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.extrude(iVecIArray, n, iVecIArray2, n2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iVecIArray2, n2, bl2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iVecIArray2, n2, dArray2);
    }

    public static ISurface extrude(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.extrude(iCurveI, iCurveI2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecI2, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecI2, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecI2, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iCurveI2);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iCurveI2);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iCurveI2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, iVecI2, iVecIArray2, n2, dArray2);
    }

    public static ISurface pipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.pipe(iVecI, iVecI2, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, bl, d);
    }

    public static ISurface pipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.pipe(iCurveI, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, dArray, d);
    }

    public static ISurface squarePipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.squarePipe(iVecI, iVecI2, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, bl, d);
    }

    public static ISurface squarePipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.squarePipe(iCurveI, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, dArray, d);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, d, d2);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d2, d3, d4);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d2);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d2, d3, d4);
    }

    public static ISurface loft(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loft(iCurveIArray);
    }

    public static ISurface loft(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.loft(iCurveI, iCurveI2);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loft(iCurveIArray, n);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loft(iCurveIArray, n, bl);
    }

    public static ISurface loft(IVecI[][] iVecIArray) {
        return ISurfaceCreator.loft(iVecIArray);
    }

    public static ISurface loft(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.loft(iVecIArray, bl, bl2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.loft(iVecIArray, n, n2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.loft(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, n);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, n, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, n, n2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, n, n2, bl);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftX(iCurveIArray);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftX(iCurveIArray, n);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftX(iCurveIArray, n, bl);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftY(iCurveIArray);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftY(iCurveIArray, n);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftY(iCurveIArray, n, bl);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftZ(iCurveIArray);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftZ(iCurveIArray, n);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftZ(iCurveIArray, n, bl);
    }

    public static ICurve flatten(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2) {
        return ICurveCreator.flatten(iCurveI, iVecI, iVecI2);
    }

    public static ICurve flatten(ICurveI iCurveI, IVecI iVecI) {
        return ICurveCreator.flatten(iCurveI, iVecI);
    }

    public static ICurve flatten(ICurveI iCurveI) {
        return ICurveCreator.flatten(iCurveI);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI, IVecI iVecI2) {
        return ISurfaceCreator.flatten(iSurfaceI, iVecI, iVecI2);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI) {
        return ISurfaceCreator.flatten(iSurfaceI, iVecI);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.flatten(iSurfaceI);
    }

    public static IVec vector(double d, double d2, double d3) {
        return new IVec(d, d2, d3);
    }

    public static IVec vector(IVec iVec) {
        return new IVec(iVec);
    }

    public static IVec vector(IVecI iVecI) {
        return new IVec(iVecI);
    }

    public static IVec vector(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDouble iDouble) {
        return new IVec(iDoubleI, iDoubleI2, iDouble);
    }

    public static IVec vector(IVec2I iVec2I) {
        return new IVec(iVec2I);
    }

    public static IVec vec(double d, double d2, double d3) {
        return IG.vector(d, d2, d3);
    }

    public static IVec vec(IVec iVec) {
        return IG.vector(iVec);
    }

    public static IVec vec(IVecI iVecI) {
        return IG.vector(iVecI);
    }

    public static IVec vec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDouble iDouble) {
        return IG.vector(iDoubleI, iDoubleI2, iDouble);
    }

    public static IVec vec(IVec2I iVec2I) {
        return IG.vector(iVec2I);
    }
}

