/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IConfig;
import igeo.core.IOut;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.util.IComparator;
import igeo.util.ISort;
import java.util.ArrayList;

public class IPolyline2D {
    public IVec2[] pts;
    public boolean closed = false;
    public IVec2 min = null;
    public IVec2 max = null;

    public IPolyline2D() {
    }

    public IPolyline2D(int n) {
        this.pts = new IVec2[n];
    }

    public IPolyline2D(IVec2[] iVec2Array) {
        this.pts = iVec2Array;
    }

    public IPolyline2D(IVec2 iVec2, IVec2 iVec22) {
        this.pts = new IVec2[2];
        this.pts[0] = iVec2;
        this.pts[1] = iVec22;
    }

    public IPolyline2D(IVec2 iVec2) {
        this.pts = new IVec2[1];
        this.pts[0] = iVec2;
    }

    public IPolyline2D(IPolyline2D iPolyline2D) {
        this.pts = new IVec2[iPolyline2D.num()];
        for (int i = 0; i < this.pts.length; ++i) {
            this.pts[i] = iPolyline2D.get(i);
        }
        this.closed = iPolyline2D.isClosed();
        this.min = iPolyline2D.min;
        this.max = iPolyline2D.max;
    }

    public IPolyline2D dup() {
        return new IPolyline2D(this);
    }

    public int num() {
        return this.pts.length;
    }

    public IVec2 get(int n) {
        return this.pts[n];
    }

    public IVec2 start() {
        return this.pts[0];
    }

    public IVec2 end() {
        return this.pts[this.pts.length - 1];
    }

    public IVec2[] get() {
        return this.pts;
    }

    public void set(int n, IVec2I iVec2I) {
        this.pts[n] = iVec2I.get();
    }

    public void set(int n, IVec2 iVec2) {
        this.pts[n] = iVec2;
    }

    public int indexOf(IVec2 iVec2) {
        for (int i = 0; i < this.pts.length; ++i) {
            if (this.pts[i] != iVec2) continue;
            return i;
        }
        return -1;
    }

    public void checkBoundary() {
        for (int i = 0; i < this.pts.length; ++i) {
            if (i == 0) {
                this.min = this.pts[i].dup();
                this.max = this.pts[i].dup();
                continue;
            }
            if (this.pts[i].x < this.min.x) {
                this.min.x = this.pts[i].x;
            } else if (this.pts[i].x > this.max.x) {
                this.max.x = this.pts[i].x;
            }
            if (this.pts[i].y < this.min.y) {
                this.min.y = this.pts[i].y;
                continue;
            }
            if (!(this.pts[i].y > this.max.y)) continue;
            this.max.y = this.pts[i].y;
        }
    }

    public IVec2 getMinBoundary() {
        if (this.min == null) {
            this.checkBoundary();
        }
        return this.min;
    }

    public IVec2 getMaxBoundary() {
        if (this.max == null) {
            this.checkBoundary();
        }
        return this.max;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    public void open() {
        this.closed = false;
    }

    public void add(IVec2 iVec2) {
        this.insert(this.pts.length, iVec2);
    }

    public void insert(int n, IVec2 iVec2) {
        int n2;
        IVec2[] iVec2Array = new IVec2[this.pts.length + 1];
        for (n2 = 0; n2 < n; ++n2) {
            iVec2Array[n2] = this.pts[n2];
        }
        iVec2Array[n] = iVec2;
        for (n2 = n; n2 < this.pts.length; ++n2) {
            iVec2Array[n2 + 1] = this.pts[n2];
        }
        this.pts = iVec2Array;
    }

    public void append(IPolyline2D iPolyline2D) {
        this.append(iPolyline2D.pts);
    }

    public void append(IPolyline2D iPolyline2D, boolean bl) {
        this.append(iPolyline2D.pts, bl);
    }

    public void append(IVec2[] iVec2Array) {
        this.append(iVec2Array, false);
    }

    public void append(IVec2[] iVec2Array, boolean bl) {
        if (this.pts == null || this.pts.length == 0) {
            this.pts = new IVec2[iVec2Array.length];
            if (!bl) {
                for (int i = 0; i < this.pts.length; ++i) {
                    this.pts[i] = iVec2Array[i];
                }
            } else {
                for (int i = 0; i < this.pts.length; ++i) {
                    this.pts[i] = iVec2Array[iVec2Array.length - 1 - i];
                }
            }
            return;
        }
        if (bl) {
            int n;
            int n2 = iVec2Array.length - 1;
            int n3 = 0;
            if (this.pts[this.pts.length - 1].eq(iVec2Array[iVec2Array.length - 1], IConfig.parameterResolution)) {
                n2 = iVec2Array.length - 2;
            }
            if (this.pts[0].eq(iVec2Array[0], IConfig.parameterResolution)) {
                n3 = 1;
            }
            IVec2[] iVec2Array2 = new IVec2[this.pts.length + n2 - n3 + 1];
            for (n = 0; n < this.pts.length; ++n) {
                iVec2Array2[n] = this.pts[n];
            }
            for (n = n2; n >= n3; --n) {
                iVec2Array2[this.pts.length + (n2 - n)] = iVec2Array[n];
            }
            this.pts = iVec2Array2;
        } else {
            int n;
            int n4 = 0;
            int n5 = iVec2Array.length - 1;
            if (this.pts[this.pts.length - 1].eq(iVec2Array[0], IConfig.parameterResolution)) {
                n4 = 1;
            }
            if (this.pts[0].eq(iVec2Array[iVec2Array.length - 1], IConfig.parameterResolution)) {
                n5 = iVec2Array.length - 2;
            }
            IVec2[] iVec2Array3 = new IVec2[this.pts.length + n5 - n4 + 1];
            for (n = 0; n < this.pts.length; ++n) {
                iVec2Array3[n] = this.pts[n];
            }
            for (n = n4; n <= n5; ++n) {
                iVec2Array3[n - n4 + this.pts.length] = iVec2Array[n];
            }
            this.pts = iVec2Array3;
        }
    }

    public void reverse() {
        IVec2[] iVec2Array = new IVec2[this.pts.length];
        for (int i = 0; i < this.pts.length; ++i) {
            iVec2Array[i] = this.pts[this.pts.length - i - 1];
        }
        this.pts = iVec2Array;
    }

    public static IPolyline2D join(IPolyline2D[] iPolyline2DArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < iPolyline2DArray.length; ++i) {
            n += iPolyline2DArray[i].num() - 1;
        }
        if (!bl) {
            ++n;
        }
        IPolyline2D iPolyline2D = new IPolyline2D(n);
        int n2 = 0;
        for (int i = 0; i < iPolyline2DArray.length; ++i) {
            for (int j = 0; j < iPolyline2DArray[i].num() - 1; ++j) {
                iPolyline2D.set(n2, iPolyline2DArray[i].get(j));
                ++n2;
            }
        }
        if (!bl) {
            iPolyline2D.set(n - 1, iPolyline2DArray[iPolyline2DArray.length - 1].end());
        }
        if (bl) {
            iPolyline2D.closed = true;
        }
        IOut.p("joined polyline: " + iPolyline2D);
        return iPolyline2D;
    }

    public IVec2[] intersect(IPolyline2D iPolyline2D) {
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
        for (int i = 0; this.closed && i < this.pts.length || !this.closed && i < this.pts.length - 1; ++i) {
            IVec2 iVec2 = IVec2.intersectPolyline(this.pts[i], this.pts[(i + 1) % this.pts.length], iPolyline2D.get());
            if (iVec2 == null) continue;
            arrayList.add(iVec2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        IVec2[] iVec2Array = new IVec2[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            iVec2Array[i] = (IVec2)arrayList.get(i);
        }
        return iVec2Array;
    }

    public void removeStraightPoints() {
        IVec2I[] iVec2IArray = IVec2.removeStraightPoints(this.pts, this.closed);
        this.pts = new IVec2[iVec2IArray.length];
        for (int i = 0; i < iVec2IArray.length; ++i) {
            this.pts[i] = iVec2IArray[i].get();
        }
    }

    public void removeDuplicatedPoints() {
        IVec2I[] iVec2IArray = IVec2.removeDuplicatedPoints(this.pts, this.closed);
        this.pts = new IVec2[iVec2IArray.length];
        for (int i = 0; i < iVec2IArray.length; ++i) {
            this.pts[i] = iVec2IArray[i].get();
        }
    }

    public static Intersection[] getPairsInsidePolygon(Intersection[] intersectionArray, IVec2[] iVec2Array, boolean bl) {
        int n;
        if (intersectionArray.length == 1) {
            return null;
        }
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (n = 0; n < intersectionArray.length; ++n) {
            arrayList.add(intersectionArray[n]);
        }
        if (bl) {
            ISort.sort(arrayList, new XComparator());
        } else {
            ISort.sort(arrayList, new YComparator());
        }
        for (n = 0; n < intersectionArray.length; ++n) {
            intersectionArray[n] = (Intersection)arrayList.get(n);
        }
        arrayList.clear();
        for (n = 0; n < intersectionArray.length - 1; ++n) {
            IVec2 iVec2 = null;
            iVec2 = n == 0 ? intersectionArray[n].dup().add(intersectionArray[n].diff(intersectionArray[n + 1]).div(2.0)) : intersectionArray[n - 1].mid(intersectionArray[n]);
            IVec2 iVec22 = intersectionArray[n].mid(intersectionArray[n + 1]);
            IVec2 iVec23 = null;
            iVec23 = n + 2 < intersectionArray.length ? intersectionArray[n + 1].mid(intersectionArray[n + 2]) : intersectionArray[n + 1].dup().add(intersectionArray[n + 1].diff(intersectionArray[n]).div(2.0));
            boolean bl2 = iVec2.isInside(iVec2Array);
            boolean bl3 = iVec22.isInside(iVec2Array);
            boolean bl4 = iVec23.isInside(iVec2Array);
            if (bl2 || !bl3 || bl4) continue;
            arrayList.add(intersectionArray[n]);
            arrayList.add(intersectionArray[n + 1]);
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Intersection[] intersectionArray2 = new Intersection[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            intersectionArray2[i] = (Intersection)arrayList.get(i);
        }
        return intersectionArray2;
    }

    public static IPolyline2D[] yLineInside(double d, IPolyline2D[] iPolyline2DArray, IPolyline2D[] iPolyline2DArray2) {
        int n;
        Intersection[] intersectionArray;
        int n2;
        if (iPolyline2DArray == null || iPolyline2DArray.length == 0) {
            return null;
        }
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (n2 = 0; n2 < iPolyline2DArray.length; ++n2) {
            intersectionArray = iPolyline2DArray[n2].intersectPolylineAndYLine(false, d);
            if (intersectionArray != null && intersectionArray.length % 2 != 0) {
                IOut.err("(x=" + d + ") number of intersection with outlines[" + n2 + "] is not even (#=" + intersectionArray.length + "). it must miss some intersection");
                intersectionArray = IPolyline2D.getPairsInsidePolygon(intersectionArray, iPolyline2DArray[n2].get(), false);
            }
            for (n = 0; intersectionArray != null && n < intersectionArray.length; ++n) {
                arrayList.add(intersectionArray[n]);
            }
        }
        for (n2 = 0; iPolyline2DArray2 != null && n2 < iPolyline2DArray2.length; ++n2) {
            intersectionArray = iPolyline2DArray2[n2].intersectPolylineAndYLine(true, d);
            if (intersectionArray != null && intersectionArray.length % 2 != 0) {
                IOut.err("(x=" + d + ") number of intersection with holes[" + n2 + "] is not even (#=" + intersectionArray.length + "). it must miss some intersection");
                intersectionArray = IPolyline2D.getPairsInsidePolygon(intersectionArray, iPolyline2DArray2[n2].get(), false);
            }
            for (n = 0; intersectionArray != null && n < intersectionArray.length; ++n) {
                arrayList.add(intersectionArray[n]);
            }
        }
        if (arrayList.size() % 2 != 0) {
            IOut.err("num of intersection should be even number (" + arrayList.size() + ")");
        }
        if (arrayList.size() <= 1) {
            return null;
        }
        ISort.sort(arrayList, new YComparator());
        IPolyline2D[] iPolyline2DArray3 = new IPolyline2D[arrayList.size() / 2];
        for (int i = 0; i < arrayList.size() / 2; ++i) {
            iPolyline2DArray3[i] = new IPolyline2D((IVec2)arrayList.get(i * 2), (IVec2)arrayList.get(i * 2 + 1));
        }
        return iPolyline2DArray3;
    }

    public static IPolyline2D[] xLineInside(double d, IPolyline2D[] iPolyline2DArray, IPolyline2D[] iPolyline2DArray2) {
        int n;
        Intersection[] intersectionArray;
        int n2;
        if (iPolyline2DArray == null || iPolyline2DArray.length == 0) {
            return null;
        }
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (n2 = 0; n2 < iPolyline2DArray.length; ++n2) {
            intersectionArray = iPolyline2DArray[n2].intersectPolylineAndXLine(false, d);
            if (intersectionArray != null && intersectionArray.length % 2 != 0) {
                IOut.err("(y=" + d + ") number of intersection with outlines[" + n2 + "] is not even (#=" + intersectionArray.length + "). it must miss some intersection");
                intersectionArray = IPolyline2D.getPairsInsidePolygon(intersectionArray, iPolyline2DArray[n2].get(), true);
            }
            for (n = 0; intersectionArray != null && n < intersectionArray.length; ++n) {
                arrayList.add(intersectionArray[n]);
            }
        }
        for (n2 = 0; iPolyline2DArray2 != null && n2 < iPolyline2DArray2.length; ++n2) {
            intersectionArray = iPolyline2DArray2[n2].intersectPolylineAndXLine(true, d);
            if (intersectionArray != null && intersectionArray.length % 2 != 0) {
                IOut.err("(y=" + d + ") number of intersection with holes[" + n2 + "] is not even (#=" + intersectionArray.length + "). it must miss some intersection");
                intersectionArray = IPolyline2D.getPairsInsidePolygon(intersectionArray, iPolyline2DArray2[n2].get(), true);
            }
            for (n = 0; intersectionArray != null && n < intersectionArray.length; ++n) {
                arrayList.add(intersectionArray[n]);
            }
        }
        if (arrayList.size() % 2 != 0) {
            IOut.err("num of intersection should be even number (" + arrayList.size() + ")");
        }
        if (arrayList.size() <= 1) {
            return null;
        }
        ISort.sort(arrayList, new XComparator());
        IPolyline2D[] iPolyline2DArray3 = new IPolyline2D[arrayList.size() / 2];
        for (int i = 0; i < arrayList.size() / 2; ++i) {
            iPolyline2DArray3[i] = new IPolyline2D((IVec2)arrayList.get(i * 2), (IVec2)arrayList.get(i * 2 + 1));
        }
        return iPolyline2DArray3;
    }

    public static IVec2I intersectXEdgeAndXLine(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3, IVec2I iVec2I4, IVec2I iVec2I5, boolean bl, boolean bl2) {
        double d;
        double d2 = iVec2I5.y();
        double d3 = iVec2I2.y();
        if (Math.abs(d3 - (d = iVec2I3.y())) >= IConfig.lengthResolution) {
            IOut.err("pt2 and pt3 are not on x line");
            return null;
        }
        if (iVec2I == null && iVec2I4 == null) {
            return iVec2I2;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        if (iVec2I != null) {
            d4 = iVec2I.y();
        }
        if (iVec2I4 != null) {
            d5 = iVec2I4.y();
        }
        if (iVec2I != null && iVec2I4 != null && (d4 < d2 && d5 < d2 || d4 > d2 && d5 > d2)) {
            return null;
        }
        if (Math.abs(iVec2I2.x() - iVec2I3.x()) < IConfig.lengthResolution) {
            return iVec2I5;
        }
        IVec2I iVec2I6 = iVec2I2;
        IVec2I iVec2I7 = iVec2I3;
        if (iVec2I2.x() < iVec2I3.x()) {
            iVec2I6 = iVec2I3;
            iVec2I7 = iVec2I2;
        }
        if ((iVec2I == null || d4 < d3) && (iVec2I4 == null || d5 > d3)) {
            if (bl && bl2 || !bl && !bl2) {
                return iVec2I6;
            }
            return iVec2I7;
        }
        if (bl && bl2 || !bl && !bl2) {
            return iVec2I7;
        }
        return iVec2I6;
    }

    public static IVec2I intersectYEdgeAndYLine(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3, IVec2I iVec2I4, IVec2I iVec2I5, boolean bl, boolean bl2) {
        double d;
        double d2 = iVec2I5.x();
        double d3 = iVec2I2.x();
        if (Math.abs(d3 - (d = iVec2I3.x())) >= IConfig.lengthResolution) {
            IOut.err("pt2 and pt3 are not on y line");
            return null;
        }
        if (iVec2I == null && iVec2I4 == null) {
            return iVec2I5;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        if (iVec2I != null) {
            d4 = iVec2I.x();
        }
        if (iVec2I4 != null) {
            d5 = iVec2I4.x();
        }
        if (iVec2I != null && iVec2I4 != null && (d4 < d2 && d5 < d2 || d4 > d2 && d5 > d2)) {
            return null;
        }
        if (Math.abs(iVec2I2.y() - iVec2I3.y()) < IConfig.lengthResolution) {
            return iVec2I5;
        }
        IVec2I iVec2I6 = iVec2I2;
        IVec2I iVec2I7 = iVec2I3;
        if (iVec2I2.y() < iVec2I3.y()) {
            iVec2I6 = iVec2I3;
            iVec2I7 = iVec2I2;
        }
        if ((iVec2I == null || d4 < d3) && (iVec2I4 == null || d5 > d3)) {
            if (bl && bl2 || !bl && !bl2) {
                return iVec2I6;
            }
            return iVec2I7;
        }
        if (bl && bl2 || !bl && !bl2) {
            return iVec2I7;
        }
        return iVec2I6;
    }

    public Intersection[] intersectPolylineAndXLine(boolean bl, double d) {
        int n = this.pts.length;
        boolean bl2 = IPolyline2D.isNormalPositive(this.pts, this.closed);
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (int i = 0; i < n - 1 || this.closed && i < n; ++i) {
            IVec2I iVec2I;
            IVec2 iVec2;
            IVec2 iVec22 = IVec2.intersectSegmentAndXLine(this.pts[i], this.pts[(i + 1) % n], d);
            if (iVec22 == null) continue;
            Intersection intersection = new Intersection(this, iVec22, this.pts[i], this.pts[(i + 1) % n]);
            intersection.setDirectionX();
            if (intersection.eqY(this.pts[(i + 1) % n], IConfig.parameterResolution)) {
                if (this.closed && i == n - 1 && arrayList.size() > 0 && ((Intersection)arrayList.get(0)).eq(intersection, IConfig.parameterResolution)) continue;
                if ((!this.closed && i < n - 2 || this.closed) && this.pts[(i + 1) % n].eqY(this.pts[(i + 2) % n], IConfig.parameterResolution)) {
                    iVec2 = null;
                    if (!this.closed && i + 3 < n || this.closed) {
                        iVec2 = this.pts[(i + 3) % n];
                    }
                    if ((iVec2I = IPolyline2D.intersectXEdgeAndXLine(this.pts[i], this.pts[(i + 1) % n], this.pts[(i + 2) % n], iVec2, intersection, bl2, bl)) != null) {
                        intersection.set(iVec2I);
                        if (iVec2I == this.pts[(i + 1) % n]) {
                            intersection.adjacent1 = this.pts[i];
                            intersection.adjacent2 = this.pts[(i + 2) % n];
                        } else if (iVec2I == this.pts[(i + 2) % n]) {
                            intersection.adjacent1 = this.pts[(i + 1) % n];
                            intersection.adjacent2 = iVec2;
                        } else {
                            intersection.adjacent1 = this.pts[i];
                            intersection.adjacent2 = this.pts[(i + 2) % n];
                        }
                        arrayList.add(intersection);
                    }
                    i += 2;
                    continue;
                }
                if (i == n - 2 && !this.closed || this.pts[i].y() < d && this.pts[(i + 2) % n].y() > d || this.pts[i].y() > d && this.pts[(i + 2) % n].y() < d) {
                    intersection.adjacent1 = this.pts[i];
                    intersection.adjacent2 = this.pts[(i + 1) % n];
                    arrayList.add(intersection);
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            if (intersection.eqY(this.pts[i], IConfig.parameterResolution)) {
                intersection.adjacent1 = i == 0 && !this.closed ? null : this.pts[(i - 1 + n) % n];
                intersection.adjacent2 = this.pts[(i + 1) % n];
                if (this.pts[i].eqY(this.pts[(i + 1) % n], IConfig.parameterResolution)) {
                    if (!this.closed) {
                        IVec2I iVec2I2;
                        iVec2 = null;
                        iVec2I = null;
                        if (i > 0) {
                            iVec2 = this.pts[i - 1];
                        }
                        if (i + 2 < n) {
                            iVec2I = this.pts[i + 2];
                        }
                        if ((iVec2I2 = IPolyline2D.intersectXEdgeAndXLine(iVec2, this.pts[i], this.pts[(i + 1) % n], iVec2I, intersection, bl2, bl)) != null) {
                            intersection.set(iVec2I2);
                            if (iVec2I2 == this.pts[i]) {
                                intersection.adjacent1 = iVec2;
                                intersection.adjacent2 = this.pts[(i + 2) % n];
                            } else if (iVec2I2 == this.pts[(i + 2) % n]) {
                                intersection.adjacent1 = this.pts[i];
                                intersection.adjacent2 = iVec2I;
                            } else {
                                intersection.adjacent1 = i == 0 && !this.closed ? null : this.pts[(i - 1 + n) % n];
                                intersection.adjacent2 = this.pts[(i + 1) % n];
                            }
                            arrayList.add(intersection);
                        }
                    }
                    i += 2;
                    continue;
                }
                if (!(i == 0 && !this.closed || this.pts[(i - 1 + n) % n].y() < d && this.pts[(i + 1) % n].y() > d) && (!(this.pts[(i - 1 + n) % n].y() > d) || !(this.pts[(i + 1) % n].y() < d))) continue;
                intersection.adjacent1 = i == 0 && !this.closed ? null : this.pts[i];
                intersection.adjacent2 = this.pts[(i + 1) % n];
                arrayList.add(intersection);
                continue;
            }
            arrayList.add(intersection);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Intersection[] intersectionArray = new Intersection[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            intersectionArray[i] = (Intersection)arrayList.get(i);
        }
        return intersectionArray;
    }

    public Intersection[] intersectPolylineAndYLine(boolean bl, double d) {
        int n = this.pts.length;
        boolean bl2 = IPolyline2D.isNormalPositive(this.pts, this.closed);
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (int i = 0; i < n - 1 || this.closed && i < n; ++i) {
            IVec2I iVec2I;
            IVec2 iVec2;
            IVec2 iVec22 = IVec2.intersectSegmentAndYLine(this.pts[i], this.pts[(i + 1) % n], d);
            if (iVec22 == null) continue;
            Intersection intersection = new Intersection(this, iVec22, this.pts[i], this.pts[(i + 1) % n]);
            intersection.setDirectionY();
            if (intersection.eqX(this.pts[(i + 1) % n], IConfig.parameterResolution)) {
                if (this.closed && i == n - 1 && arrayList.size() > 0 && ((Intersection)arrayList.get(0)).eq(intersection, IConfig.parameterResolution)) continue;
                if ((!this.closed && i < n - 2 || this.closed) && this.pts[(i + 1) % n].eqX(this.pts[(i + 2) % n], IConfig.parameterResolution)) {
                    iVec2 = null;
                    if (!this.closed && i + 3 < n || this.closed) {
                        iVec2 = this.pts[(i + 3) % n];
                    }
                    if ((iVec2I = IPolyline2D.intersectYEdgeAndYLine(this.pts[i], this.pts[(i + 1) % n], this.pts[(i + 2) % n], iVec2, intersection, bl2, bl)) != null) {
                        intersection.set(iVec2I);
                        if (iVec2I == this.pts[(i + 1) % n]) {
                            intersection.adjacent1 = this.pts[i];
                            intersection.adjacent2 = this.pts[(i + 2) % n];
                        } else if (iVec2I == this.pts[(i + 2) % n]) {
                            intersection.adjacent1 = this.pts[(i + 1) % n];
                            intersection.adjacent2 = iVec2;
                        } else {
                            intersection.adjacent1 = this.pts[i];
                            intersection.adjacent2 = this.pts[(i + 2) % n];
                        }
                        arrayList.add(intersection);
                    }
                    i += 2;
                    continue;
                }
                if (i == n - 2 && !this.closed || this.pts[i].x() < d && this.pts[(i + 2) % n].x() > d || this.pts[i].x() > d && this.pts[(i + 2) % n].x() < d) {
                    intersection.adjacent1 = this.pts[i];
                    intersection.adjacent2 = this.pts[(i + 1) % n];
                    arrayList.add(intersection);
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            if (intersection.eqX(this.pts[i], IConfig.parameterResolution)) {
                intersection.adjacent1 = i == 0 && !this.closed ? null : this.pts[(i - 1 + n) % n];
                intersection.adjacent2 = this.pts[(i + 1) % n];
                if (this.pts[i].eqX(this.pts[(i + 1) % n], IConfig.parameterResolution)) {
                    if (!this.closed) {
                        IVec2I iVec2I2;
                        iVec2 = null;
                        iVec2I = null;
                        if (i > 0) {
                            iVec2 = this.pts[i - 1];
                        }
                        if (i + 2 < n) {
                            iVec2I = this.pts[i + 2];
                        }
                        if ((iVec2I2 = IPolyline2D.intersectYEdgeAndYLine(iVec2, this.pts[i], this.pts[(i + 1) % n], iVec2I, intersection, bl2, bl)) != null) {
                            intersection.set(iVec2I2);
                            if (iVec2I2 == this.pts[i]) {
                                intersection.adjacent1 = iVec2;
                                intersection.adjacent2 = this.pts[(i + 2) % n];
                            } else if (iVec2I2 == this.pts[(i + 2) % n]) {
                                intersection.adjacent1 = this.pts[i];
                                intersection.adjacent2 = iVec2I;
                            } else {
                                intersection.adjacent1 = i == 0 && !this.closed ? null : this.pts[(i - 1 + n) % n];
                                intersection.adjacent2 = this.pts[(i + 1) % n];
                            }
                            arrayList.add(intersection);
                        }
                    }
                    i += 2;
                    continue;
                }
                if (!(i == 0 && !this.closed || this.pts[(i - 1 + n) % n].x() < d && this.pts[(i + 1) % n].x() > d) && (!(this.pts[(i - 1 + n) % n].x() > d) || !(this.pts[(i + 1) % n].x() < d))) continue;
                intersection.adjacent1 = i == 0 && !this.closed ? null : this.pts[i];
                intersection.adjacent2 = this.pts[(i + 1) % n];
                arrayList.add(intersection);
                continue;
            }
            arrayList.add(intersection);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Intersection[] intersectionArray = new Intersection[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            intersectionArray[i] = (Intersection)arrayList.get(i);
        }
        return intersectionArray;
    }

    public static double sumOfExteriorAngles(IVec2I[] iVec2IArray, boolean bl) {
        double d = 0.0;
        int n = iVec2IArray.length;
        for (int i = 0; bl && i < n || !bl && i < n - 2; ++i) {
            d += iVec2IArray[(i + 1) % n].get().diff(iVec2IArray[i]).angle(iVec2IArray[(i + 2) % n].get().diff(iVec2IArray[(i + 1) % n]));
        }
        return d;
    }

    public static boolean isNormalPositive(IVec2I[] iVec2IArray, boolean bl) {
        return IPolyline2D.sumOfExteriorAngles(iVec2IArray, bl) > 0.0;
    }

    public boolean isNormalPositive() {
        return IPolyline2D.isNormalPositive(this.pts, this.closed);
    }

    public String toString() {
        String string = "";
        string = string + "[";
        for (int i = 0; i < this.pts.length; ++i) {
            string = string + this.pts[i].toString();
            if (i >= this.pts.length - 1) continue;
            string = string + ", ";
        }
        string = string + "]";
        return string;
    }

    public static class Intersection
    extends IVec2 {
        public IPolyline2D polyline;
        public IVec2 adjacent1;
        public IVec2 adjacent2;
        public boolean orthogonal = false;
        public boolean orthogonalDirX = true;

        public Intersection(IPolyline2D iPolyline2D, IVec2 iVec2) {
            super(iVec2);
            this.polyline = iPolyline2D;
        }

        public Intersection(IPolyline2D iPolyline2D, IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
            super(iVec2);
            this.polyline = iPolyline2D;
            this.adjacent1 = iVec22;
            this.adjacent2 = iVec23;
        }

        public void setDirectionX() {
            this.orthogonal = true;
            this.orthogonalDirX = true;
        }

        public void setDirectionY() {
            this.orthogonal = true;
            this.orthogonalDirX = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class YComparator
    implements IComparator<Intersection> {
        @Override
        public int compare(Intersection intersection, Intersection intersection2) {
            if (intersection.y > intersection2.y) {
                return 1;
            }
            if (intersection.y < intersection2.y) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XComparator
    implements IComparator<Intersection> {
        @Override
        public int compare(Intersection intersection, Intersection intersection2) {
            if (intersection.x > intersection2.x) {
                return 1;
            }
            if (intersection.x < intersection2.x) {
                return -1;
            }
            return 0;
        }
    }
}

