/*
 * Decompiled with CFR 0.152.
 */
package igeo.core;

import igeo.core.IAttribute;
import igeo.core.IMaterial;
import igeo.core.IObject;
import igeo.core.IServer;
import igeo.core.IServerI;
import igeo.geo.ICurve;
import igeo.geo.IMesh;
import igeo.geo.IPoint;
import igeo.geo.ISurface;
import java.awt.Color;
import java.util.ArrayList;

public class ILayer
extends IObject {
    public ArrayList<IObject> objects;

    public ILayer() {
        this.attribute = new IAttribute();
        this.objects = new ArrayList();
    }

    public ILayer(String string) {
        this();
        this.attribute.name = string;
    }

    public ILayer(IServerI iServerI) {
        super(iServerI);
        this.attribute = new IAttribute();
        this.objects = new ArrayList();
    }

    public ILayer(IServerI iServerI, String string) {
        this(iServerI);
        this.attribute.name = string;
    }

    public int num() {
        return this.objects.size();
    }

    public IObject get(int n) {
        return this.objects.get(n);
    }

    public ILayer add(IObject iObject) {
        if (!this.objects.contains(iObject)) {
            this.objects.add(iObject);
            if (iObject.layer() != this) {
                iObject.layer(this);
            }
        }
        return this;
    }

    public ILayer remove(int n) {
        this.objects.remove(n);
        return this;
    }

    public ILayer remove(IObject iObject) {
        this.objects.remove(iObject);
        return this;
    }

    public boolean contains(IObject iObject) {
        return this.objects.contains(iObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPoint[] points() {
        ArrayList<IPoint> arrayList = new ArrayList<IPoint>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPoint)) continue;
                arrayList.add((IPoint)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IPoint[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICurve[] curves() {
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ICurve)) continue;
                arrayList.add((ICurve)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ICurve[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurface[] surfaces() {
        ArrayList<ISurface> arrayList = new ArrayList<ISurface>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ISurface)) continue;
                arrayList.add((ISurface)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ISurface[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMesh[] getMeshes() {
        ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IMesh)) continue;
                arrayList.add((IMesh)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IMesh[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject[] objects(Class clazz) {
        ArrayList<IObject> arrayList = new ArrayList<IObject>();
        IServer iServer = this.server;
        synchronized (iServer) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!clazz.isInstance(this.objects.get(i))) continue;
                arrayList.add(this.objects.get(i));
            }
        }
        return arrayList.toArray(new IObject[arrayList.size()]);
    }

    public IObject[] objects() {
        return this.objects.toArray(new IObject[this.objects.size()]);
    }

    public ILayer name(String string) {
        this.attribute.name = string;
        return this;
    }

    public boolean visible() {
        return this.attribute.visible;
    }

    public ILayer setVisible(boolean bl) {
        return this.visible(bl);
    }

    public ILayer visible(boolean bl) {
        this.attribute.visible = bl;
        if (this.attribute.visible) {
            this.show();
        } else {
            this.hide();
        }
        return this;
    }

    public ILayer hide() {
        super.hide();
        this.attribute.visible = false;
        for (IObject iObject : this.objects) {
            iObject.hide();
        }
        return this;
    }

    public ILayer show() {
        super.show();
        this.attribute.visible = true;
        for (IObject iObject : this.objects) {
            iObject.show();
        }
        return this;
    }

    public Color clr() {
        return this.attribute.clr();
    }

    public ILayer clr(Color color) {
        this.attribute.clr(color);
        return this;
    }

    public ILayer clr(int n) {
        this.attribute.clr(n);
        return this;
    }

    public ILayer clr(float f) {
        this.attribute.clr(f);
        return this;
    }

    public ILayer clr(double d) {
        this.attribute.clr(d);
        return this;
    }

    public ILayer clr(int n, int n2) {
        this.attribute.clr(n, n2);
        return this;
    }

    public ILayer clr(float f, float f2) {
        this.attribute.clr(f, f2);
        return this;
    }

    public ILayer clr(double d, double d2) {
        this.attribute.clr(d, d2);
        return this;
    }

    public ILayer clr(int n, int n2, int n3) {
        this.attribute.clr(n, n2, n3);
        return this;
    }

    public ILayer clr(float f, float f2, float f3) {
        this.attribute.clr(f, f2, f3);
        return this;
    }

    public ILayer clr(double d, double d2, double d3) {
        this.attribute.clr(d, d2, d3);
        return this;
    }

    public ILayer clr(int n, int n2, int n3, int n4) {
        this.attribute.clr(n, n2, n3, n4);
        return this;
    }

    public ILayer clr(float f, float f2, float f3, float f4) {
        this.attribute.clr(f, f2, f3, f4);
        return this;
    }

    public ILayer clr(double d, double d2, double d3, double d4) {
        this.attribute.clr(d, d2, d3, d4);
        return this;
    }

    public ILayer hsb(float f, float f2, float f3, float f4) {
        this.attribute.hsb(f, f2, f3, f4);
        return this;
    }

    public ILayer hsb(double d, double d2, double d3, double d4) {
        this.attribute.hsb(d, d2, d3, d4);
        return this;
    }

    public ILayer hsb(float f, float f2, float f3) {
        this.attribute.hsb(f, f2, f3);
        return this;
    }

    public ILayer hsb(double d, double d2, double d3) {
        this.attribute.hsb(d, d2, d3);
        return this;
    }

    public Color getColor() {
        return this.clr();
    }

    public ILayer setColor(Color color) {
        return this.clr(color);
    }

    public ILayer setColor(int n) {
        return this.clr(n);
    }

    public ILayer setColor(float f) {
        return this.clr(f);
    }

    public ILayer setColor(double d) {
        return this.clr(d);
    }

    public ILayer setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    public ILayer setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    public ILayer setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    public ILayer setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    public ILayer setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    public ILayer setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    public ILayer setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    public ILayer setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    public ILayer setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    public ILayer setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    public ILayer setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    public ILayer setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    public ILayer setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }

    public ILayer setMaterial(IMaterial iMaterial) {
        this.attribute.material = iMaterial;
        return this;
    }
}

