/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.core.IConfig;
import igeo.core.IGraphicObject;
import igeo.core.IObject;
import igeo.core.IOut;
import igeo.geo.ISurface;
import igeo.geo.ISurfaceI;
import igeo.geo.ISurfaceR;
import igeo.geo.IVec2;
import igeo.geo.IVec2I;
import igeo.gui.IGLLineLoop;
import igeo.gui.IGLLineStrip;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IIsoparmGraphic;
import igeo.gui.IPolyline2D;
import igeo.gui.ISurfaceGraphicGL;
import igeo.gui.ITrimLoopGraphic;
import java.util.ArrayList;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISurfaceGraphicWireframeGL
extends IGraphicObject {
    public static float weight = 1.0f;
    public int isoparmNumRatio = IConfig.surfaceIsoparmResolution;
    public int isoparmNumU;
    public int isoparmNumV;
    public ISurfaceI surface = null;
    public IGLLineStrip[] uline;
    public IGLLineStrip[] vline;
    public IGLLineLoop[] inTrim = null;
    public IGLLineLoop[] outTrim = null;
    public IPolyline2D[] uline2;
    public IPolyline2D[] vline2;
    public IPolyline2D[] inTrim2 = null;
    public IPolyline2D[] outTrim2 = null;
    public boolean simpleFlat = false;
    public boolean initialized = false;

    public ISurfaceGraphicWireframeGL(ISurface iSurface) {
        super(iSurface);
        this.surface = iSurface.surface;
    }

    public ISurfaceGraphicWireframeGL(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface;
    }

    public ISurfaceGraphicWireframeGL(IObject iObject, ISurfaceI iSurfaceI) {
        super(iObject);
        this.surface = iSurfaceI;
    }

    public ISurfaceGraphicWireframeGL(ISurface iSurface, int n) {
        super(iSurface);
        this.surface = iSurface.surface;
        this.isoparmNumRatio = n;
    }

    public ISurfaceGraphicWireframeGL(ISurfaceR iSurfaceR, int n) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface;
        this.isoparmNumRatio = n;
    }

    public ISurfaceGraphicWireframeGL(IObject iObject, ISurfaceI iSurfaceI, int n) {
        super(iObject);
        this.surface = iSurfaceI;
        this.isoparmNumRatio = n;
    }

    public void setIsoparmNumberRatio(int n) {
        this.isoparmNumRatio = n;
    }

    public ArrayList<IGLLineStrip> getLineInsideTrim(IVec2[] iVec2Array, IVec2[][] iVec2Array2, IVec2[][] iVec2Array3) {
        int n;
        ArrayList<IGLLineStrip> arrayList = new ArrayList<IGLLineStrip>();
        IGLLineStrip iGLLineStrip = null;
        if (iVec2Array3 == null && iVec2Array2 == null) {
            iGLLineStrip = new IGLLineStrip(iVec2Array.length);
            for (int i = 0; i < iVec2Array.length; ++i) {
                iGLLineStrip.setPoint(i, this.surface.pt(iVec2Array[i].x, iVec2Array[i].y).get());
            }
            arrayList.add(iGLLineStrip);
            return arrayList;
        }
        if (iVec2Array2 != null && iVec2Array2.length > 0) {
            for (n = 0; n < iVec2Array2[0].length; ++n) {
            }
        }
        n = 0;
        IVec2I[] iVec2IArray = null;
        for (int i = 0; i < iVec2Array.length; ++i) {
            int n2;
            int n3 = 1;
            IVec2I[] iVec2IArray2 = null;
            for (n2 = 0; iVec2Array2 != null && n2 < iVec2Array2.length && n3 != 0; ++n2) {
                if (iVec2Array[i].isInside(iVec2Array2[n2])) continue;
                n3 = 0;
                iVec2IArray2 = iVec2Array2[n2];
            }
            for (n2 = 0; iVec2Array3 != null && n2 < iVec2Array3.length && n3 != 0; ++n2) {
                if (!iVec2Array[i].isInside(iVec2Array3[n2])) continue;
                n3 = 0;
                iVec2IArray2 = iVec2Array3[n2];
            }
            if (n3 != 0) {
                if (n == 0) {
                    iGLLineStrip = new IGLLineStrip();
                    if (i > 0) {
                        IVec2 iVec2 = IVec2.intersectPolygon(iVec2Array[i - 1], iVec2Array[i], iVec2IArray);
                        if (iVec2 != null) {
                            IOut.p("intersect point!");
                            iGLLineStrip.addPoint(this.surface.pt(iVec2.x, iVec2.y).get());
                        } else {
                            IOut.p("intersect not found!");
                        }
                    }
                }
                iGLLineStrip.addPoint(this.surface.pt(iVec2Array[i].x, iVec2Array[i].y).get());
            } else if (n != 0) {
                if (iGLLineStrip.getNum() > 1) {
                    IVec2 iVec2 = IVec2.intersectPolygon(iVec2Array[i - 1], iVec2Array[i], iVec2IArray2);
                    if (iVec2 != null) {
                        IOut.p("intersect point!");
                        iGLLineStrip.addPoint(this.surface.pt(iVec2.x, iVec2.y).get());
                    } else {
                        IOut.p("intersect not found!");
                    }
                    iGLLineStrip.finalizePoint();
                    arrayList.add(iGLLineStrip);
                }
                iGLLineStrip = null;
            }
            n = n3;
            iVec2IArray = iVec2IArray2;
        }
        if (n != 0 && iGLLineStrip != null) {
            iGLLineStrip.finalizePoint();
            arrayList.add(iGLLineStrip);
        }
        return arrayList;
    }

    public void initSurface() {
        int n;
        IIsoparmGraphic iIsoparmGraphic;
        double d;
        int n2;
        int n3;
        ArrayList<IPolyline2D> arrayList;
        int n4;
        int n5 = this.surface.uepNum();
        int n6 = this.surface.vepNum();
        this.isoparmNumU = this.isoparmNumRatio * (n6 - 1) + 1;
        this.isoparmNumV = this.isoparmNumRatio * (n5 - 1) + 1;
        ITrimLoopGraphic[] iTrimLoopGraphicArray = null;
        ITrimLoopGraphic[] iTrimLoopGraphicArray2 = null;
        if (this.surface.hasOuterTrim()) {
            iTrimLoopGraphicArray = new ITrimLoopGraphic[this.surface.outerTrimLoopNum()];
            this.outTrim = new IGLLineLoop[this.surface.outerTrimLoopNum()];
            this.outTrim2 = new IPolyline2D[this.surface.outerTrimLoopNum()];
            for (n4 = 0; n4 < this.surface.outerTrimLoopNum(); ++n4) {
                iTrimLoopGraphicArray[n4] = new ITrimLoopGraphic(this.surface.outerTrimLoop(n4), true, IConfig.surfaceWireframeResolution);
                this.outTrim[n4] = new IGLLineLoop(iTrimLoopGraphicArray[n4].getPolyline());
                this.outTrim2[n4] = iTrimLoopGraphicArray[n4].getPolyline2D();
            }
        } else {
            iTrimLoopGraphicArray = new ITrimLoopGraphic[1];
            this.outTrim = new IGLLineLoop[1];
            this.outTrim2 = new IPolyline2D[1];
            iTrimLoopGraphicArray[0] = new ITrimLoopGraphic(this.surface);
            this.outTrim[0] = new IGLLineLoop(iTrimLoopGraphicArray[0].getPolyline());
            this.outTrim2[0] = iTrimLoopGraphicArray[0].getPolyline2D();
        }
        if (this.surface.hasInnerTrim()) {
            iTrimLoopGraphicArray2 = new ITrimLoopGraphic[this.surface.innerTrimLoopNum()];
            this.inTrim = new IGLLineLoop[this.surface.innerTrimLoopNum()];
            this.inTrim2 = new IPolyline2D[this.surface.innerTrimLoopNum()];
            for (n4 = 0; n4 < this.surface.innerTrimLoopNum(); ++n4) {
                iTrimLoopGraphicArray2[n4] = new ITrimLoopGraphic(this.surface.innerTrimLoop(n4), false, IConfig.surfaceWireframeResolution);
                this.inTrim[n4] = new IGLLineLoop(iTrimLoopGraphicArray2[n4].getPolyline());
                this.inTrim2[n4] = iTrimLoopGraphicArray2[n4].getPolyline2D();
            }
        }
        if (this.isoparmNumU > 2) {
            ArrayList<IGLLineStrip> arrayList2 = new ArrayList<IGLLineStrip>();
            arrayList = new ArrayList<IPolyline2D>();
            for (n3 = 0; n3 < n6 - 1; ++n3) {
                for (n2 = 0; n2 < this.isoparmNumRatio; ++n2) {
                    d = (double)n2 / (double)this.isoparmNumRatio;
                    if (n3 <= 0 && n2 <= 0) continue;
                    iIsoparmGraphic = new IIsoparmGraphic(this.surface, this.surface.v(n3, d), true, iTrimLoopGraphicArray, iTrimLoopGraphicArray2);
                    for (n = 0; n < iIsoparmGraphic.num(); ++n) {
                        arrayList2.add(new IGLLineStrip(iIsoparmGraphic.getLine(n)));
                        arrayList.add(iIsoparmGraphic.getLine2D(n));
                    }
                }
            }
            this.uline = arrayList2.toArray(new IGLLineStrip[arrayList2.size()]);
            this.uline2 = arrayList.toArray(new IPolyline2D[arrayList.size()]);
        }
        if (this.isoparmNumV > 2) {
            ArrayList<IGLLineStrip> arrayList3 = new ArrayList<IGLLineStrip>();
            arrayList = new ArrayList();
            for (n3 = 0; n3 < n5 - 1; ++n3) {
                for (n2 = 0; n2 < this.isoparmNumRatio; ++n2) {
                    d = (double)n2 / (double)this.isoparmNumRatio;
                    if (n3 <= 0 && n2 <= 0) continue;
                    iIsoparmGraphic = new IIsoparmGraphic(this.surface, this.surface.u(n3, d), false, iTrimLoopGraphicArray, iTrimLoopGraphicArray2);
                    for (n = 0; n < iIsoparmGraphic.num(); ++n) {
                        arrayList3.add(new IGLLineStrip(iIsoparmGraphic.getLine(n)));
                        arrayList.add(iIsoparmGraphic.getLine2D(n));
                    }
                }
            }
            this.vline = arrayList3.toArray(new IGLLineStrip[arrayList3.size()]);
            this.vline2 = arrayList.toArray(new IPolyline2D[arrayList.size()]);
        }
        this.initialized = true;
        this.simpleFlat = this.surface != null && this.surface.unum() == 2 && this.surface.vnum() == 2 && this.surface.isFlat();
    }

    public void updateSurface() {
        IVec2 iVec2;
        int n;
        int n2;
        if (this.simpleFlat && !this.surface.isFlat()) {
            this.simpleFlat = false;
            this.initSurface();
            return;
        }
        if (this.uline != null) {
            if (this.uline.length != this.uline2.length) {
                this.uline = new IGLLineStrip[this.uline2.length];
            }
            for (n2 = 0; n2 < this.uline2.length; ++n2) {
                if (this.uline[n2] == null || this.uline[n2].num() != this.uline2[n2].num()) {
                    this.uline[n2] = new IGLLineStrip(this.uline2[n2].num());
                }
                for (n = 0; n < this.uline2[n2].num(); ++n) {
                    iVec2 = this.uline2[n2].get(n);
                    this.uline[n2].setPoint(n, this.surface.pt(iVec2).get());
                }
            }
        }
        if (this.vline != null) {
            if (this.vline.length != this.vline2.length) {
                this.vline = new IGLLineStrip[this.vline2.length];
            }
            for (n2 = 0; n2 < this.vline2.length; ++n2) {
                if (this.vline[n2] == null || this.vline[n2].num() != this.vline2[n2].num()) {
                    this.vline[n2] = new IGLLineStrip(this.vline2[n2].num());
                }
                for (n = 0; n < this.vline2[n2].num(); ++n) {
                    iVec2 = this.vline2[n2].get(n);
                    this.vline[n2].setPoint(n, this.surface.pt(iVec2).get());
                }
            }
        }
        if (this.inTrim != null) {
            if (this.inTrim.length != this.inTrim2.length) {
                this.inTrim = new IGLLineLoop[this.inTrim2.length];
            }
            for (n2 = 0; n2 < this.inTrim2.length; ++n2) {
                if (this.inTrim[n2] == null || this.inTrim[n2].num() != this.inTrim2[n2].num()) {
                    this.inTrim[n2] = new IGLLineLoop(this.inTrim2[n2].num());
                }
                for (n = 0; n < this.inTrim2[n2].num(); ++n) {
                    iVec2 = this.inTrim2[n2].get(n);
                    this.inTrim[n2].setPoint(n, this.surface.pt(iVec2).get());
                }
            }
        }
        if (this.outTrim != null) {
            if (this.outTrim.length != this.outTrim2.length) {
                this.outTrim = new IGLLineLoop[this.outTrim2.length];
            }
            for (n2 = 0; n2 < this.outTrim2.length; ++n2) {
                if (this.outTrim[n2] == null || this.outTrim[n2].num() != this.outTrim2[n2].num()) {
                    this.outTrim[n2] = new IGLLineLoop(this.outTrim2[n2].num());
                }
                for (n = 0; n < this.outTrim2[n2].num(); ++n) {
                    iVec2 = this.outTrim2[n2].get(n);
                    this.outTrim[n2].setPoint(n, this.surface.pt(iVec2).get());
                }
            }
        }
    }

    @Override
    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL() && iGraphicMode.isWireframe();
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (!this.initialized) {
            this.initSurface();
        } else if (this.update) {
            this.updateSurface();
            this.update = false;
        }
        GL gL = iGraphics.getGL();
        if (gL == null) {
            return;
        }
        float f = ISurfaceGraphicGL.defaultColorRed;
        float f2 = ISurfaceGraphicGL.defaultColorGreen;
        float f3 = ISurfaceGraphicGL.defaultColorBlue;
        float f4 = ISurfaceGraphicGL.defaultColorAlpha;
        if (this.color != null) {
            f = (float)this.color.getRed() / 255.0f;
            f2 = (float)this.color.getGreen() / 255.0f;
            f3 = (float)this.color.getBlue() / 255.0f;
            f4 = (float)this.color.getAlpha() / 255.0f;
        }
        if (!iGraphics.view().mode().isTransparentWireframe()) {
            f4 = 1.0f;
        } else if (iGraphics.view().mode().isTransparent()) {
            f4 = (float)transparentModeAlpha;
        }
        if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
            float[] fArray = new float[]{f, f2, f3, f4};
            gL.glMaterialfv(1032, 4608, fArray, 0);
            gL.glMaterialfv(1032, 4609, fArray, 0);
            gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
            gL.glColor4f(f, f2, f3, 0.0f);
        } else {
            gL.glColor4f(f, f2, f3, f4);
        }
        gL.glLineWidth(weight);
        if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
            gL.glDisable(2896);
        }
        if (this.inTrim != null) {
            for (int i = 0; i < this.inTrim.length; ++i) {
                this.inTrim[i].draw(gL);
            }
        }
        if (this.outTrim != null) {
            for (int i = 0; i < this.outTrim.length; ++i) {
                this.outTrim[i].draw(gL);
            }
        }
        if (this.uline != null) {
            for (int i = 0; i < this.uline.length; ++i) {
                this.uline[i].draw(gL);
            }
        }
        if (this.vline != null) {
            for (int i = 0; i < this.vline.length; ++i) {
                this.vline[i].draw(gL);
            }
        }
        if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
            gL.glEnable(2896);
        }
    }
}

