/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IConfig;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IEntityParameter;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IOut;
import igeo.IParameterObject;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVecI;
import igeo.IVectorObject;
import igeo.Ir;

public class IVec
extends IParameterObject
implements IVecI,
IEntityParameter {
    public static final IVec origin = new IVec(0.0, 0.0, 0.0);
    public static final IVec xaxis = new IVec(1.0, 0.0, 0.0);
    public static final IVec yaxis = new IVec(0.0, 1.0, 0.0);
    public static final IVec zaxis = new IVec(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public IVec() {
    }

    public IVec(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public IVec(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.z = 0.0;
    }

    public IVec(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IVecI iVecI) {
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
    }

    public IVec(IVec2I iVec2I) {
        this.x = iVec2I.x();
        this.y = iVec2I.y();
        this.z = 0.0;
    }

    public IVec(IServerI iServerI) {
        super(iServerI);
    }

    public IVec(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public IVec(IServerI iServerI, double d, double d2) {
        super(iServerI);
        this.x = d;
        this.y = d2;
        this.z = 0.0;
    }

    public IVec(IServerI iServerI, IVec iVec) {
        super(iServerI);
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        IVec iVec = iVecI.get();
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
    }

    public IVec(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super(iServerI);
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
    }

    public IVec(IServerI iServerI, IVec2I iVec2I) {
        super(iServerI);
        this.x = iVec2I.x();
        this.y = iVec2I.y();
        this.z = 0.0;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public IVec get() {
        return this;
    }

    public IVec dup() {
        return new IVec(this.x, this.y, this.z);
    }

    public IVec2 to2d() {
        return new IVec2(this);
    }

    public IVec4 to4d() {
        return new IVec4(this);
    }

    public IVec4 to4d(double d) {
        return new IVec4(this, d);
    }

    public IVec4 to4d(IDoubleI iDoubleI) {
        return new IVec4((IVecI)this, iDoubleI);
    }

    public IDouble getX() {
        return new IDouble(this.x);
    }

    public IDouble getY() {
        return new IDouble(this.y);
    }

    public IDouble getZ() {
        return new IDouble(this.z);
    }

    public IVec set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public IVec set(IVec iVec) {
        this.x = iVec.x;
        this.y = iVec.y;
        this.z = iVec.z;
        return this;
    }

    public IVec set(IVecI iVecI) {
        return this.set(iVecI.get());
    }

    public IVec set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x = iDoubleI.x();
        this.y = iDoubleI2.x();
        this.z = iDoubleI3.x();
        return this;
    }

    public IVec add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public IVec add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x += iDoubleI.x();
        this.y += iDoubleI2.x();
        this.z += iDoubleI3.x();
        return this;
    }

    public IVec add(IVec iVec) {
        this.x += iVec.x;
        this.y += iVec.y;
        this.z += iVec.z;
        return this;
    }

    public IVec add(IVecI iVecI) {
        return this.add(iVecI.get());
    }

    public IVec sub(double d, double d2, double d3) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
        return this;
    }

    public IVec sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.x -= iDoubleI.x();
        this.y -= iDoubleI2.x();
        this.z -= iDoubleI3.x();
        return this;
    }

    public IVec sub(IVec iVec) {
        this.x -= iVec.x;
        this.y -= iVec.y;
        this.z -= iVec.z;
        return this;
    }

    public IVec sub(IVecI iVecI) {
        return this.sub(iVecI.get());
    }

    public IVec mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public IVec mul(IDouble iDouble) {
        this.x *= iDouble.x;
        this.y *= iDouble.x;
        this.z *= iDouble.x;
        return this;
    }

    public IVec mul(IDoubleI iDoubleI) {
        return this.mul(iDoubleI.x());
    }

    public IVec div(double d) {
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public IVec div(IDouble iDouble) {
        this.x /= iDouble.x;
        this.y /= iDouble.x;
        this.z /= iDouble.x;
        return this;
    }

    public IVec div(IDoubleI iDoubleI) {
        return this.div(iDoubleI.x());
    }

    public IVec neg() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public IVec rev() {
        return this.neg();
    }

    public IVec flip() {
        return this.neg();
    }

    public IVec zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public IVec add(IVec iVec, double d) {
        this.x += d * iVec.x;
        this.y += d * iVec.y;
        this.z += d * iVec.z;
        return this;
    }

    public IVec add(IVecI iVecI, double d) {
        return this.add(iVecI.get(), d);
    }

    public IVec add(IVecI iVecI, IDoubleI iDoubleI) {
        return this.add((IVecI)iVecI.get(), iDoubleI);
    }

    public IVec add(double d, IVec iVec) {
        return this.add(iVec, d);
    }

    public IVec add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    public IVec add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    public double dot(IVec iVec) {
        return this.x * iVec.x + this.y * iVec.y + this.z * iVec.z;
    }

    public double dot(IVecI iVecI) {
        return this.dot(iVecI.get());
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dot(iVecI);
    }

    public IDouble dot(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.dot(iVecI));
    }

    public IVec cross(IVec iVec) {
        return this.dup().set(this.y * iVec.z - this.z * iVec.y, this.z * iVec.x - this.x * iVec.z, this.x * iVec.y - this.y * iVec.x);
    }

    public IVec cross(IVecI iVecI) {
        return this.cross(iVecI.get());
    }

    public IVec icross(IVec iVec) {
        double d = this.y * iVec.z - this.z * iVec.y;
        double d2 = this.z * iVec.x - this.x * iVec.z;
        double d3 = this.x * iVec.y - this.y * iVec.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    public IDouble len(ISwitchR iSwitchR) {
        return new IDouble(this.len());
    }

    public double len2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    public IDouble len2(ISwitchR iSwitchR) {
        return new IDouble(this.len2());
    }

    public IVec len(double d) {
        this.x *= (d /= this.len());
        this.y *= d;
        this.z *= d;
        return this;
    }

    public IVec len(IDoubleI iDoubleI) {
        return this.len(iDoubleI.x());
    }

    public IVec unit() {
        double d = this.len();
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public double dist(IVec iVec) {
        return Math.sqrt((this.x - iVec.x) * (this.x - iVec.x) + (this.y - iVec.y) * (this.y - iVec.y) + (this.z - iVec.z) * (this.z - iVec.z));
    }

    public double dist(IVecI iVecI) {
        return this.dist(iVecI.get());
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist(iVecI);
    }

    public IDouble dist(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.dist(iVecI));
    }

    public double dist2(IVec iVec) {
        return (this.x - iVec.x) * (this.x - iVec.x) + (this.y - iVec.y) * (this.y - iVec.y) + (this.z - iVec.z) * (this.z - iVec.z);
    }

    public double dist2(IVecI iVecI) {
        return this.dist2(iVecI.get());
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist2(iVecI);
    }

    public IDouble dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.dist2(iVecI));
    }

    public boolean eq(IVec iVec) {
        return this.eq(iVec, IConfig.tolerance);
    }

    public boolean eq(IVecI iVecI) {
        return this.eq(iVecI.get(), IConfig.tolerance);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eq(iVecI);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eq(iVecI));
    }

    public boolean eq(IVec iVec, double d) {
        return this.dist2(iVec) <= d * d;
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.eq(iVecI.get(), d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eq(iVecI, d);
    }

    public IBool eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eq(iVecI, iDoubleI.x()));
    }

    public boolean eqX(IVec iVec) {
        return this.eqX(iVec, IConfig.tolerance);
    }

    public boolean eqY(IVec iVec) {
        return this.eqY(iVec, IConfig.tolerance);
    }

    public boolean eqZ(IVec iVec) {
        return this.eqZ(iVec, IConfig.tolerance);
    }

    public boolean eqX(IVecI iVecI) {
        return this.eqX(iVecI, IConfig.tolerance);
    }

    public boolean eqY(IVecI iVecI) {
        return this.eqY(iVecI, IConfig.tolerance);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.eqZ(iVecI, IConfig.tolerance);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqX(iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqY(iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqZ(iVecI);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eqX(iVecI));
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eqY(iVecI));
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBool(this.eqZ(iVecI));
    }

    public boolean eqX(IVec iVec, double d) {
        return Math.abs(this.x - iVec.x) <= d;
    }

    public boolean eqY(IVec iVec, double d) {
        return Math.abs(this.y - iVec.y) <= d;
    }

    public boolean eqZ(IVec iVec, double d) {
        return Math.abs(this.z - iVec.z) <= d;
    }

    public boolean eqX(IVecI iVecI, double d) {
        return Math.abs(this.x - iVecI.x()) <= d;
    }

    public boolean eqY(IVecI iVecI, double d) {
        return Math.abs(this.y - iVecI.y()) <= d;
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return Math.abs(this.z - iVecI.z()) <= d;
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqX(iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqY(iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqZ(iVecI, d);
    }

    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eqX(iVecI, iDoubleI.x()));
    }

    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eqY(iVecI, iDoubleI.x()));
    }

    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBool(this.eqZ(iVecI, iDoubleI.x()));
    }

    public double angle(IVec iVec) {
        double d = this.len();
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = iVec.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.dot(iVec) / (d * d2);
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        return Math.acos(d3);
    }

    public double angle(IVecI iVecI) {
        return this.angle(iVecI.get());
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.angle(iVecI);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDouble(this.angle(iVecI));
    }

    public double angle(IVec iVec, IVec iVec2) {
        double d = this.len();
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = iVec.len();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.dot(iVec) / (d * d2);
        IVec iVec3 = this.cross(iVec);
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        double d4 = Math.acos(d3);
        if (iVec3.dot(iVec2) < 0.0) {
            return -d4;
        }
        return d4;
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.angle(iVecI.get(), iVecI2.get());
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.angle(iVecI, iVecI2);
    }

    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return new IDouble(this.angle(iVecI, iVecI2));
    }

    public IVec rot(IVec iVec, double d) {
        if (iVec == null) {
            return this.rot(d);
        }
        double[][] dArray = new double[3][3];
        IVec iVec2 = iVec.dup().unit();
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0 - d3;
        dArray[0][0] = iVec2.x * iVec2.x * d4 + d3;
        dArray[0][1] = iVec2.x * iVec2.y * d4 - iVec2.z * d2;
        dArray[0][2] = iVec2.x * iVec2.z * d4 + iVec2.y * d2;
        dArray[1][0] = iVec2.y * iVec2.x * d4 + iVec2.z * d2;
        dArray[1][1] = iVec2.y * iVec2.y * d4 + d3;
        dArray[1][2] = iVec2.y * iVec2.z * d4 - iVec2.x * d2;
        dArray[2][0] = iVec2.z * iVec2.x * d4 - iVec2.y * d2;
        dArray[2][1] = iVec2.z * iVec2.y * d4 + iVec2.x * d2;
        dArray[2][2] = iVec2.z * iVec2.z * d4 + d3;
        double d5 = this.x;
        double d6 = this.y;
        this.x = dArray[0][0] * d5 + dArray[0][1] * d6 + dArray[0][2] * this.z;
        this.y = dArray[1][0] * d5 + dArray[1][1] * d6 + dArray[1][2] * this.z;
        this.z = dArray[2][0] * d5 + dArray[2][1] * d6 + dArray[2][2] * this.z;
        return this;
    }

    public IVec rot(IVecI iVecI, double d) {
        return this.rot(iVecI.get(), d);
    }

    public IVec rot(IVecI iVecI, IDoubleI iDoubleI) {
        return this.rot(iVecI.get(), iDoubleI.x());
    }

    public IVec rot(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = this.x;
        this.x = d3 * d4 - d2 * this.y;
        this.y = d2 * d4 + d3 * this.y;
        return this;
    }

    public IVec rot(IDoubleI iDoubleI) {
        return this.rot(iDoubleI.x());
    }

    public IVec rot(IVec iVec, IVec iVec2, double d) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).rot(iVec2, d).add(iVec);
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2, double d) {
        return this.rot(iVecI.get(), iVecI2.get(), d);
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return this.rot(iVecI.get(), iVecI2.get(), iDoubleI.x());
    }

    public IVec rot(IVec iVec, IVec iVec2) {
        return this.rot(iVec, iVec2.cross(iVec).angle(this.cross(iVec)));
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2) {
        return this.rot(iVecI.get(), iVecI2.get());
    }

    public IVec rot(IVec iVec, IVec iVec2, IVec iVec3) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).rot(iVec2, iVec3.dif(iVec)).add(iVec);
    }

    public IVec rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.rot(iVecI.get(), iVecI2.get(), iVecI3.get());
    }

    public IVec rot2(double d) {
        return this.rot(d);
    }

    public IVec rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    public IVec rot2(IVec iVec, double d) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).rot(d).add(iVec);
    }

    public IVec rot2(IVecI iVecI, double d) {
        return this.rot2(iVecI.get(), d);
    }

    public IVec rot2(IVecI iVecI, IDoubleI iDoubleI) {
        return this.rot2(iVecI.get(), iDoubleI.x());
    }

    public IVec rot2(IVec iVec) {
        return this.rot(iVec.cross(zaxis).angle(this.cross(zaxis)));
    }

    public IVec rot2(IVecI iVecI) {
        return this.rot2(iVecI.get());
    }

    public IVec rot2(IVec iVec, IVec iVec2) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).rot2(iVec2.dif(iVec)).add(iVec);
    }

    public IVec rot2(IVecI iVecI, IVecI iVecI2) {
        return this.rot2(iVecI.get(), iVecI2.get());
    }

    public IVec scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public IVec scale(double d) {
        return this.mul(d);
    }

    public IVec scale(IVec iVec, double d) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).scale(d).add(iVec);
    }

    public IVec scale(IVecI iVecI, double d) {
        return this.scale(iVecI.get(), d);
    }

    public IVec scale(IVecI iVecI, IDoubleI iDoubleI) {
        return this.scale(iVecI.get(), iDoubleI.x());
    }

    public IVec scale1d(IVec iVec, double d) {
        IVec iVec2 = iVec.dup().unit();
        iVec2.mul(this.dot(iVec2));
        IVec iVec3 = this.dif(iVec2);
        return this.set(iVec2.mul(d).add(iVec3));
    }

    public IVec scale1d(IVecI iVecI, double d) {
        return this.scale1d(iVecI.get(), d);
    }

    public IVec scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        return this.scale1d(iVecI.get(), iDoubleI.x());
    }

    public IVec scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).scale1d(iVecI2, d).add(iVecI);
    }

    public IVec scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return this.scale1d(iVecI, iVecI2, iDoubleI.x());
    }

    public IVec ref(IVec iVec) {
        return this.add(iVec.dup().mul(this.dot(iVec) / iVec.len2() * -2.0));
    }

    public IVec ref(IVecI iVecI) {
        return this.ref(iVecI.get());
    }

    public IVec ref(IVec iVec, IVec iVec2) {
        if (iVec == this) {
            return this;
        }
        return this.sub(iVec).ref(iVec2).add(iVec);
    }

    public IVec ref(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI.get(), iVecI2.get());
    }

    public IVec mirror(IVec iVec) {
        return this.ref(iVec);
    }

    public IVec mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    public IVec mirror(IVec iVec, IVec iVec2) {
        return this.ref(iVec, iVec2);
    }

    public IVec mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    public IVec shear(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.x + d * this.y + d6 * this.z;
        double d8 = d2 * this.x + this.y + d3 * this.z;
        double d9 = d5 * this.x + d4 * this.y + this.z;
        this.x = d7;
        this.y = d8;
        this.z = d9;
        return this;
    }

    public IVec shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        return this.shear(iDoubleI == null ? 0.0 : iDoubleI.x(), iDoubleI2 == null ? 0.0 : iDoubleI2.x(), iDoubleI3 == null ? 0.0 : iDoubleI3.x(), iDoubleI4 == null ? 0.0 : iDoubleI4.x(), iDoubleI5 == null ? 0.0 : iDoubleI5.x(), iDoubleI6 == null ? 0.0 : iDoubleI6.x());
    }

    public IVec shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shear(d, d2, d3, d4, d5, d6).add(iVecI);
    }

    public IVec shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        return this.shear(iVecI, iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x(), iDoubleI4.x(), iDoubleI5.x(), iDoubleI6.x());
    }

    public IVec shearXY(double d, double d2) {
        return this.shear(d, d2, 0.0, 0.0, 0.0, 0.0);
    }

    public IVec shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearXY(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearXY(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearXY(d, d2).add(iVecI);
    }

    public IVec shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearXY(iVecI, iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearYZ(double d, double d2) {
        return this.shear(0.0, 0.0, d, d2, 0.0, 0.0);
    }

    public IVec shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearYZ(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearYZ(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearYZ(d, d2).add(iVecI);
    }

    public IVec shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearYZ(iVecI, iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearZX(double d, double d2) {
        return this.shear(0.0, 0.0, 0.0, 0.0, d, d2);
    }

    public IVec shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearZX(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec shearZX(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearZX(d, d2).add(iVecI);
    }

    public IVec shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shearZX(iVecI, iDoubleI.x(), iDoubleI2.x());
    }

    public IVec translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVec translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVec transform(IMatrix3I iMatrix3I) {
        return this.set(iMatrix3I.mul(this));
    }

    public IVec transform(IMatrix4I iMatrix4I) {
        return this.set(iMatrix4I.mul(this));
    }

    public IVec transform(IVec iVec, IVec iVec2, IVec iVec3) {
        double d = iVec.x * this.x + iVec2.x * this.y + iVec3.x * this.z;
        double d2 = iVec.y * this.x + iVec2.y * this.y + iVec3.y * this.z;
        double d3 = iVec.z * this.x + iVec2.z * this.y + iVec3.z * this.z;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public IVec transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.transform(iVecI.get(), iVecI2.get(), iVecI3.get());
    }

    public IVec transform(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        return this.transform(iVec, iVec2, iVec3).add(iVec4);
    }

    public IVec transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return this.transform(iVecI.get(), iVecI2.get(), iVecI3.get(), iVecI4.get());
    }

    public IVec mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVec mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVec cp() {
        return this.dup();
    }

    public IVec cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IVec cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVec dif(IVec iVec) {
        return this.dup().sub(iVec);
    }

    public IVec dif(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IVec diff(IVec iVec) {
        return this.dif(iVec);
    }

    public IVec diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    public IVec mid(IVec iVec) {
        return this.dup().add(iVec).div(2.0);
    }

    public IVec mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IVec sum(IVec iVec) {
        return this.dup().add(iVec);
    }

    public IVec sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVec sum(IVec ... iVecArray) {
        IVec iVec = this.dup();
        for (IVec iVec2 : iVecArray) {
            iVec.add(iVec2);
        }
        return iVec;
    }

    public IVec sum(IVecI ... iVecIArray) {
        IVec iVec = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVec.add(iVecI);
        }
        return iVec;
    }

    public IVec bisect(IVec iVec) {
        return this.dup().unit().add(iVec.dup().unit());
    }

    public IVec bisect(IVecI iVecI) {
        return this.bisect(iVecI.get());
    }

    public IVec sum(IVec iVec, double d, double d2) {
        return this.dup().mul(d).add(iVec, d2);
    }

    public IVec sum(IVec iVec, double d) {
        return this.dup().mul(1.0 - d).add(iVec, d);
    }

    public IVec sum(IVecI iVecI, double d, double d2) {
        return this.sum(iVecI.get(), d, d2);
    }

    public IVec sum(IVecI iVecI, double d) {
        return this.sum(iVecI.get(), d);
    }

    public IVec sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI.get(), iDoubleI.x(), iDoubleI2.x());
    }

    public IVec sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI.get(), iDoubleI.x());
    }

    public boolean isValid() {
        if (!IDouble.isValid(this.x)) {
            IOut.err("invalid x (" + this.x + ")");
            return false;
        }
        if (!IDouble.isValid(this.y)) {
            IOut.err("invalid y (" + this.y + ")");
            return false;
        }
        if (!IDouble.isValid(this.z)) {
            IOut.err("invalid z (" + this.z + ")");
            return false;
        }
        return true;
    }

    public String toString() {
        return "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + "," + String.valueOf(this.z) + ")";
    }

    public boolean isParallel(IVecI iVecI) {
        return this.isParallel(iVecI, IConfig.angleTolerance);
    }

    public boolean isParallel(IVecI iVecI, double d) {
        return Math.abs(this.dot(iVecI.get()) / (this.len() * iVecI.get().len())) > Math.cos(d);
    }

    public boolean isStraight(IVecI iVecI, IVecI iVecI2) {
        return this.isStraight(iVecI, iVecI2, IConfig.angleTolerance);
    }

    public boolean isStraight(IVecI iVecI, IVecI iVecI2, double d) {
        return iVecI.get().dif(this).isParallel(iVecI2.get().dif(iVecI), d);
    }

    public IVec nml(IVecI iVecI) {
        return this.cross(iVecI);
    }

    public IVec nml(IVecI iVecI, IVecI iVecI2) {
        return this.dif(iVecI).cross(this.dif(iVecI2)).unit();
    }

    public IVec nml(IVec iVec, IVec iVec2) {
        return this.dif(iVec).icross(this.dif(iVec2)).unit();
    }

    public static IVecI getNormal(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return iVecI.nml(iVecI2, iVecI3);
    }

    public static IVec getNormal(IVec iVec, IVec iVec2, IVec iVec3) {
        return iVec.nml(iVec2, iVec3);
    }

    public IVecI getNormal(IVecI iVecI, IVecI iVecI2) {
        return this.nml(iVecI, iVecI2);
    }

    public IVec getNormal(IVec iVec, IVec iVec2) {
        return this.nml(iVec, iVec2);
    }

    public IVec projectToPlane(IVecI iVecI, IVecI iVecI2) {
        double d = this.dot(iVecI2) / iVecI.dot(iVecI2);
        this.x -= d * iVecI.x();
        this.y -= d * iVecI.y();
        this.z -= d * iVecI.z();
        return this;
    }

    public IVec projectToPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        if (iVecI3 == this) {
            return this;
        }
        return this.sub(iVecI3).projectToPlane(iVecI, iVecI2).add(iVecI3);
    }

    public IVec projectToLine(IVecI iVecI, IVecI iVecI2) {
        if (iVecI == this) {
            return this;
        }
        IVec iVec = this.dif(iVecI);
        double d = iVec.dot(iVecI2) / iVecI2.len();
        return iVec.set(iVecI2.get()).len(d).add(iVecI);
    }

    public double[] projectTo2Vec(IVecI iVecI, IVecI iVecI2) {
        IVec iVec;
        double[] dArray = new double[3];
        IVec iVec2 = iVecI.get().cross(iVecI2);
        double d = iVec2.len2();
        if (d == 0.0) {
            return null;
        }
        dArray[2] = this.dot(iVec2) / d;
        this.sub(iVec2.mul(dArray[2]));
        IVec iVec3 = iVecI.get();
        if (iVec3 == iVecI) {
            iVec3 = iVec3.dup();
        }
        if ((iVec = iVecI2.get()) == iVecI2) {
            iVec = iVec.dup();
        }
        iVec3.unit();
        iVec.unit();
        double d2 = iVec3.dot(iVec);
        double d3 = 1.0 - d2 * d2;
        if (d3 == 0.0) {
            return null;
        }
        double d4 = this.dot(iVec3);
        double d5 = this.dot(iVec);
        dArray[0] = (d4 - d5 * d2) / d3 / iVecI.len();
        dArray[1] = (d5 - d4 * d2) / d3 / iVecI2.len();
        return dArray;
    }

    public double projectToVec(IVecI iVecI) {
        double d = this.dot(iVecI) / iVecI.len2();
        this.set(iVecI).mul(d);
        return d;
    }

    public IVec[] decompose(IVecI iVecI, IVecI iVecI2) {
        IVec iVec;
        double d;
        IVec iVec2;
        IVec iVec3 = iVecI.get();
        if (iVec3 == iVecI) {
            iVec3 = iVec3.dup();
        }
        if ((iVec2 = iVecI2.get()) == iVecI2) {
            iVec2 = iVec2.dup();
        }
        if ((d = (iVec = iVec3.cross(iVec2)).len()) == 0.0) {
            IOut.err("two vectors are in same direction");
            return null;
        }
        iVec.div(d);
        iVec.mul(this.dot(iVec));
        IVec iVec4 = this.dup().sub(iVec);
        iVec3.unit();
        iVec2.unit();
        double d2 = iVec3.dot(iVec2);
        double d3 = 1.0 - d2 * d2;
        if (d3 == 0.0) {
            IOut.err("two vectors are in same direction");
            return null;
        }
        double d4 = iVec4.dot(iVec3);
        double d5 = iVec4.dot(iVec2);
        iVec3.mul((d4 - d5 * d2) / d3);
        iVec2.mul((d5 - d4 * d2) / d3);
        return new IVec[]{iVec3, iVec2, iVec};
    }

    public double distanceToPlane(IVecI iVecI, IVecI iVecI2) {
        return Math.abs(this.dif(iVecI2).dot(iVecI) / iVecI.len());
    }

    public IVec perpendicularVectorToLine(IVecI iVecI, IVecI iVecI2) {
        IVec iVec = iVecI.get().dup();
        IVec iVec2 = iVecI2.dif(this).get();
        return iVec.mul(-iVec.dot(iVec2) / iVec.len2()).add(iVec2);
    }

    public IVec perpendicularVectorToVector(IVecI iVecI) {
        IVec iVec = iVecI.get().dup();
        return iVec.mul(-iVec.dot(this) / iVec.len2()).add(this);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.isOnPlane(iVecI, iVecI2, iVecI3, IConfig.tolerance);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2) {
        return this.isOnPlane(iVecI, iVecI2, IConfig.tolerance);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return this.isOnPlane(IVec.getNormal(iVecI, iVecI2, iVecI3), iVecI, d);
    }

    public boolean isOnPlane(IVecI iVecI, IVecI iVecI2, double d) {
        return this.distanceToPlane(iVecI, iVecI2) < d;
    }

    public IVectorObject show(IVecI iVecI) {
        return new IVectorObject(this, iVecI);
    }

    public IVectorObject show() {
        return new IVectorObject(this);
    }

    public IVectorObject show(IServerI iServerI, IVecI iVecI) {
        return new IVectorObject(iServerI, this, iVecI);
    }

    public IVectorObject show(IServerI iServerI) {
        return new IVectorObject(iServerI, (IVecI)this);
    }

    public static boolean isFlat(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return iVecI.get().isOnPlane(iVecI2, iVecI3, iVecI4);
    }

    public static boolean isFlat(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, double d) {
        return iVecI.get().isOnPlane(iVecI2, iVecI3, iVecI4, d);
    }

    public static boolean isArrayEqual(IVec[] iVecArray, IVec[] iVecArray2, boolean bl, boolean bl2) {
        return IVec.isArrayEqual(iVecArray, iVecArray2, bl, bl2, IConfig.tolerance);
    }

    public static boolean isArrayEqual(IVec[] iVecArray, IVec[] iVecArray2, boolean bl, boolean bl2, double d) {
        int n;
        boolean bl3;
        int n2;
        if (iVecArray.length != iVecArray2.length) {
            return false;
        }
        int n3 = iVecArray.length;
        if (!bl) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                if (iVecArray[n4].eq(iVecArray2[n4], d) || bl2) continue;
                return false;
            }
            if (!bl2) {
                return true;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (iVecArray[n4].eq(iVecArray2[n3 - 1 - n4], d)) continue;
                return false;
            }
            return true;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bl3 = true;
            for (n = 0; n < n3; ++n) {
                if (iVecArray[n].eq(iVecArray2[(n + n2) % n3], d)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            return true;
        }
        if (!bl2) {
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            bl3 = true;
            for (n = 0; n < n3; ++n) {
                if (iVecArray[n].eq(iVecArray2[(n + n2) % n3], d)) continue;
                bl3 = false;
            }
            if (!bl3) continue;
            return true;
        }
        return false;
    }

    public static IVec averageNormal(IVecI[] iVecIArray) {
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return new IVec(0.0, 0.0, 1.0);
        }
        int n = iVecIArray.length;
        if (n <= 2) {
            if (n <= 1) {
                return new IVec(0.0, 0.0, 1.0);
            }
            IVec iVec = iVecIArray[1].get().dif(iVecIArray[0]).cross(xaxis);
            if (!iVec.eq(origin)) {
                return iVec.unit();
            }
            return iVecIArray[1].get().dif(iVecIArray[0]).cross(yaxis).unit();
        }
        if (n == 3) {
            return iVecIArray[1].get().dif(iVecIArray[0]).cross(iVecIArray[2].get().dif(iVecIArray[1])).unit();
        }
        IVec iVec = new IVec();
        for (int i = 0; i < n; ++i) {
            IVec iVec2 = iVecIArray[(i + 1) % n].get().dif(iVecIArray[i]);
            IVec iVec3 = iVecIArray[(i + 2) % n].get().dif(iVecIArray[(i + 1) % n]);
            iVec.add(iVec2.cross(iVec3));
        }
        if (iVec.eq(origin)) {
            return new IVec(0.0, 0.0, 1.0);
        }
        return iVec.unit();
    }

    public static IVec averageNormal(IVecI[][] iVecIArray) {
        if (iVecIArray == null || iVecIArray.length == 0) {
            IOut.err("pts is null");
            return new IVec(0.0, 0.0, 1.0);
        }
        if (iVecIArray.length == 1) {
            return IVec.averageNormal(iVecIArray[0]);
        }
        if (iVecIArray[0].length == 0) {
            IOut.err("pts is null");
            return new IVec(0.0, 0.0, 1.0);
        }
        if (iVecIArray[0].length == 1) {
            IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
            for (int i = 0; i < iVecIArray.length; ++i) {
                iVecIArray2[i] = iVecIArray[i][0];
            }
            return IVec.averageNormal(iVecIArray2);
        }
        IVec iVec = new IVec();
        for (int i = 0; i < iVecIArray.length - 1; ++i) {
            for (int j = 0; j < iVecIArray[i].length - 1; ++j) {
                iVec.add(iVecIArray[i + 1][j].dif(iVecIArray[i][j]).cross(iVecIArray[i][j + 1].dif(iVecIArray[i][j])));
                iVec.add(iVecIArray[i + 1][j + 1].dif(iVecIArray[i + 1][j]).cross(iVecIArray[i][j].dif(iVecIArray[i + 1][j])));
                iVec.add(iVecIArray[i][j + 1].dif(iVecIArray[i + 1][j + 1]).cross(iVecIArray[i + 1][j].dif(iVecIArray[i + 1][j + 1])));
                iVec.add(iVecIArray[i][j].dif(iVecIArray[i][j + 1]).cross(iVecIArray[i + 1][j + 1].dif(iVecIArray[i][j + 1])));
            }
        }
        if (iVec.eq(origin)) {
            return new IVec(0.0, 0.0, 1.0);
        }
        return iVec.unit();
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI) {
        IVecI[] iVecIArray = IVec.offset((IVecI[])iVecArray, d, iVecI);
        if (iVecIArray == null) {
            return null;
        }
        IVec[] iVecArray2 = new IVec[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecArray2[i] = iVecIArray[i].get();
        }
        return iVecArray2;
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI, boolean bl) {
        IVecI[] iVecIArray = IVec.offset((IVecI[])iVecArray, d, iVecI, bl);
        if (iVecIArray == null) {
            return null;
        }
        IVec[] iVecArray2 = new IVec[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecArray2[i] = iVecIArray[i].get();
        }
        return iVecArray2;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI, boolean bl) {
        if (!bl || iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            return IVec.offset(iVecIArray, d, iVecI);
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length + 1];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i];
        }
        iVecIArray2[iVecIArray.length] = iVecIArray[0].dup();
        IVecI[] iVecIArray3 = IVec.offset(iVecIArray2, d, iVecI);
        if (iVecIArray3 == null) {
            return iVecIArray3;
        }
        IVecI[] iVecIArray4 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray4[i] = iVecIArray3[i];
        }
        return iVecIArray4;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI) {
        IVecI iVecI2;
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return null;
        }
        int n = iVecIArray.length;
        IVecI[] iVecIArray2 = new IVecI[n];
        for (int i = 0; i < n; ++i) {
            iVecIArray2[i] = iVecIArray[i].dup();
        }
        if (d == 0.0) {
            return iVecIArray2;
        }
        IVecI[] iVecIArray3 = new IVecI[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            iVecI2 = iVecIArray[i + 1].dif(iVecIArray[i]);
            iVecIArray3[i] = iVecI2.cross(iVecI);
            iVecIArray3[i].len(d);
        }
        if (iVecIArray2[0].eq(iVecIArray[n - 1])) {
            IVecI iVecI3 = iVecIArray3[n - 2].dup().add(iVecIArray3[0]);
            iVecI3.mul(2.0 * d * d / iVecI3.len2());
            iVecIArray2[0].add(iVecI3);
            iVecIArray2[n - 1].add(iVecI3);
        } else {
            iVecIArray2[0].add(iVecIArray3[0]);
            iVecIArray2[n - 1].add(iVecIArray3[n - 2]);
        }
        for (int i = 1; i < n - 1; ++i) {
            iVecI2 = iVecIArray3[i - 1].dup().add(iVecIArray3[i]);
            iVecI2.mul(2.0 * d * d / iVecI2.len2());
            iVecIArray2[i].add(iVecI2);
        }
        return iVecIArray2;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI, boolean bl) {
        if (!bl || iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            return IVec.offset(iVecIArray, iDoubleI, iVecI);
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length + 1];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i];
        }
        iVecIArray2[iVecIArray.length] = iVecIArray[0].dup();
        IVecI[] iVecIArray3 = IVec.offset(iVecIArray2, iDoubleI, iVecI);
        if (iVecIArray3 == null) {
            return iVecIArray3;
        }
        IVecI[] iVecIArray4 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray4[i] = iVecIArray3[i];
        }
        return iVecIArray4;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI) {
        IVecI iVecI2;
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return null;
        }
        int n = iVecIArray.length;
        IVecI[] iVecIArray2 = new IVecI[n];
        for (int i = 0; i < n; ++i) {
            iVecIArray2[i] = iVecIArray[i].dup();
        }
        if (iDoubleI.x() == 0.0) {
            return iVecIArray2;
        }
        IVecI[] iVecIArray3 = new IVecI[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            iVecI2 = iVecIArray[i + 1].dif(iVecIArray[i]);
            iVecIArray3[i] = iVecI2.cross(iVecI);
            iVecIArray3[i].len(iDoubleI);
        }
        if (iVecIArray2[0].eq(iVecIArray[n - 1])) {
            IVecI iVecI3 = iVecIArray3[n - 2].dup().add(iVecIArray3[0]);
            iVecI3.mul(iDoubleI.dup().pow(2.0).mul(2.0).div(iVecI3.len2(Ir.i)));
            iVecIArray2[0].add(iVecI3);
            iVecIArray2[n - 1].add(iVecI3);
        } else {
            iVecIArray2[0].add(iVecIArray3[0]);
            iVecIArray2[n - 1].add(iVecIArray3[n - 2]);
        }
        for (int i = 1; i < n - 1; ++i) {
            iVecI2 = iVecIArray3[i - 1].dup().add(iVecIArray3[i]);
            iVecI2.mul(iDoubleI.dup().pow(2.0).mul(2.0).div(iVecI2.len2(Ir.i)));
            iVecIArray2[i].add(iVecI2);
        }
        return iVecIArray2;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IVecI[] iVecIArray2, double d) {
        IVecI iVecI;
        IVecI iVecI2;
        IVecI iVecI3;
        if (iVecIArray2.length < iVecIArray.length) {
            IOut.err("normal array size (" + iVecIArray2.length + ") doesn't match with pts.");
        }
        int n = iVecIArray.length;
        IVecI[] iVecIArray3 = new IVecI[n];
        for (int i = 0; i < n; ++i) {
            iVecIArray3[i] = iVecIArray[i].dup();
        }
        if (d == 0.0) {
            return iVecIArray3;
        }
        if (iVecIArray[0].eq(iVecIArray[n - 1])) {
            iVecI3 = iVecIArray[n - 1].dif(iVecIArray[n - 2]).cross(iVecIArray2[0]).len(d);
            iVecI2 = iVecIArray[1].dif(iVecIArray[0]).cross(iVecIArray2[0]).len(d);
            iVecI = iVecI3.add(iVecI2);
            iVecI.mul(2.0 * d * d / iVecI.len2());
            iVecIArray3[0].add(iVecI);
            iVecIArray3[n - 1].add(iVecI);
        } else {
            iVecI3 = iVecIArray[1].dif(iVecIArray[0]).cross(iVecIArray2[0]).len(d);
            iVecI2 = iVecIArray[n - 1].dif(iVecIArray[n - 2]).cross(iVecIArray2[n - 1]).len(d);
            iVecIArray3[0].add(iVecI3);
            iVecIArray3[n - 1].add(iVecI2);
        }
        for (int i = 1; i < n - 1; ++i) {
            iVecI2 = iVecIArray[i].dif(iVecIArray[i - 1]).cross(iVecIArray2[i]).len(d);
            iVecI = iVecIArray[i + 1].dif(iVecIArray[i]).cross(iVecIArray2[i]).len(d);
            IVecI iVecI4 = iVecI2.add(iVecI);
            iVecI4.mul(2.0 * d * d / iVecI4.len2());
            iVecIArray3[i].add(iVecI4);
        }
        return iVecIArray3;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IVecI[] iVecIArray2, IDoubleI iDoubleI) {
        IVecI iVecI;
        IVecI iVecI2;
        IVecI iVecI3;
        if (iVecIArray2.length < iVecIArray.length) {
            IOut.err("normal array size (" + iVecIArray2.length + ") doesn't match with pts.");
        }
        int n = iVecIArray.length;
        IVecI[] iVecIArray3 = new IVecI[n];
        for (int i = 0; i < n; ++i) {
            iVecIArray3[i] = iVecIArray[i].dup();
        }
        if (iDoubleI.x() == 0.0) {
            return iVecIArray3;
        }
        if (iVecIArray[0].eq(iVecIArray[n - 1])) {
            iVecI3 = iVecIArray[n - 1].dif(iVecIArray[n - 2]).cross(iVecIArray2[0]).len(iDoubleI);
            iVecI2 = iVecIArray[1].dif(iVecIArray[0]).cross(iVecIArray2[0]).len(iDoubleI);
            iVecI = iVecI3.add(iVecI2);
            iVecI.mul(iDoubleI.dup().pow(2.0).mul(2.0).div(iVecI.len2(Ir.i)));
            iVecIArray3[0].add(iVecI);
            iVecIArray3[n - 1].add(iVecI);
        } else {
            iVecI3 = iVecIArray[1].dif(iVecIArray[0]).cross(iVecIArray2[0]).len(iDoubleI);
            iVecI2 = iVecIArray[n - 1].dif(iVecIArray[n - 2]).cross(iVecIArray2[n - 1]).len(iDoubleI);
            iVecIArray3[0].add(iVecI3);
            iVecIArray3[n - 1].add(iVecI2);
        }
        for (int i = 1; i < n - 1; ++i) {
            iVecI2 = iVecIArray[i].dif(iVecIArray[i - 1]).cross(iVecIArray2[i]).len(iDoubleI);
            iVecI = iVecIArray[i + 1].dif(iVecIArray[i]).cross(iVecIArray2[i]).len(iDoubleI);
            IVecI iVecI4 = iVecI2.add(iVecI);
            iVecI4.mul(iDoubleI.dup().pow(2.0).mul(2.0).div(iVecI4.len2(Ir.i)));
            iVecIArray3[i].add(iVecI4);
        }
        return iVecIArray3;
    }

    public static IVec[] offset(IVec[] iVecArray, double d) {
        IVecI[] iVecIArray = IVec.offset((IVecI[])iVecArray, d);
        if (iVecIArray == null) {
            return null;
        }
        IVec[] iVecArray2 = new IVec[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecArray2[i] = iVecIArray[i].get();
        }
        return iVecArray2;
    }

    public static IVec[] offset(IVec[] iVecArray, double d, boolean bl) {
        IVecI[] iVecIArray = IVec.offset((IVecI[])iVecArray, d, bl);
        if (iVecIArray == null) {
            return null;
        }
        IVec[] iVecArray2 = new IVec[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecArray2[i] = iVecIArray[i].get();
        }
        return iVecArray2;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, boolean bl) {
        if (!bl || iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            return IVec.offset(iVecIArray, d);
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length + 1];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i];
        }
        iVecIArray2[iVecIArray.length] = iVecIArray[0].dup();
        IVecI[] iVecIArray3 = IVec.offset(iVecIArray2, d);
        if (iVecIArray3 == null) {
            return iVecIArray3;
        }
        IVecI[] iVecIArray4 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray4[i] = iVecIArray3[i];
        }
        return iVecIArray4;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d) {
        int n;
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return null;
        }
        if (iVecIArray.length == 1) {
            IOut.err("pts has only one point");
            return null;
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        if (iVecIArray.length == 2) {
            IVec iVec = new IVec(0.0, 0.0, 1.0);
            IVecI iVecI = iVecIArray[1].dif(iVecIArray[0]);
            if (iVec.isParallel(iVecI)) {
                iVec = new IVec(1.0, 0.0, 0.0);
            }
            iVecIArray2[0] = iVec;
            iVecIArray2[1] = iVec;
            return IVec.offset(iVecIArray, iVecIArray2, d);
        }
        boolean bl = false;
        if (iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            bl = true;
        }
        IVecI iVecI = null;
        IVec iVec = null;
        for (n = 0; n < iVecIArray.length; ++n) {
            if (n == 0) {
                if (bl && !iVecIArray[iVecIArray.length - 2].get().isStraight(iVecIArray[n], iVecIArray[n + 1])) {
                    iVecI = iVecIArray[iVecIArray.length - 2].nml(iVecIArray[n], iVecIArray[n + 1]);
                }
                for (int i = n; i < iVecIArray.length - 2 && iVecI == null; ++i) {
                    if (iVecIArray[i].get().isStraight(iVecIArray[i + 1], iVecIArray[i + 2])) continue;
                    iVecI = iVecIArray[i].nml(iVecIArray[i + 1], iVecIArray[i + 2]);
                }
                if (iVecI == null && (iVecI = new IVec(0.0, 0.0, 1.0)).get().isParallel(iVecIArray[n + 1].dif(iVecIArray[n]))) {
                    iVecI = new IVec(1.0, 0.0, 0.0);
                }
                iVec = iVecI;
            } else if (n < iVecIArray.length - 1) {
                if (!iVecIArray[n - 1].get().isStraight(iVecIArray[n], iVecIArray[n + 1])) {
                    iVecI = iVecIArray[n - 1].nml(iVecIArray[n], iVecIArray[n + 1]);
                }
            } else if (bl) {
                iVecI = iVec;
            }
            iVecIArray2[n] = iVecI;
        }
        for (n = 1; n < iVecIArray2.length; ++n) {
            if (bl && n >= iVecIArray2.length - 1 || !(iVecIArray2[n].dot(iVecIArray2[n - 1]) < 0.0)) continue;
            iVecIArray2[n].neg();
        }
        return IVec.offset(iVecIArray, iVecIArray2, d);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, boolean bl) {
        if (!bl || iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            return IVec.offset(iVecIArray, iDoubleI);
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length + 1];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i];
        }
        iVecIArray2[iVecIArray.length] = iVecIArray[0].dup();
        IVecI[] iVecIArray3 = IVec.offset(iVecIArray2, iDoubleI);
        if (iVecIArray3 == null) {
            return iVecIArray3;
        }
        IVecI[] iVecIArray4 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray4[i] = iVecIArray3[i];
        }
        return iVecIArray4;
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        int n;
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return null;
        }
        if (iVecIArray.length == 1) {
            IOut.err("pts has only one point");
            return null;
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        if (iVecIArray.length == 2) {
            IVec iVec = new IVec(0.0, 0.0, 1.0);
            IVecI iVecI = iVecIArray[1].dif(iVecIArray[0]);
            if (iVec.isParallel(iVecI)) {
                iVec = new IVec(1.0, 0.0, 0.0);
            }
            iVecIArray2[0] = iVec;
            iVecIArray2[1] = iVec;
            return IVec.offset(iVecIArray, iVecIArray2, iDoubleI);
        }
        boolean bl = false;
        if (iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            bl = true;
        }
        IVecI iVecI = null;
        IVec iVec = null;
        for (n = 0; n < iVecIArray.length; ++n) {
            if (n == 0) {
                if (bl && !iVecIArray[iVecIArray.length - 2].get().isStraight(iVecIArray[n], iVecIArray[n + 1])) {
                    iVecI = iVecIArray[iVecIArray.length - 2].nml(iVecIArray[n], iVecIArray[n + 1]);
                }
                for (int i = n; i < iVecIArray.length - 2 && iVecI == null; ++i) {
                    if (iVecIArray[i].get().isStraight(iVecIArray[i + 1], iVecIArray[i + 2])) continue;
                    iVecI = iVecIArray[i].nml(iVecIArray[i + 1], iVecIArray[i + 2]);
                }
                if (iVecI == null && (iVecI = new IVec(0.0, 0.0, 1.0)).get().isParallel(iVecIArray[n + 1].dif(iVecIArray[n]))) {
                    iVecI = new IVec(1.0, 0.0, 0.0);
                }
                iVec = iVecI;
            } else if (n < iVecIArray.length - 1) {
                if (!iVecIArray[n - 1].get().isStraight(iVecIArray[n], iVecIArray[n + 1])) {
                    iVecI = iVecIArray[n - 1].nml(iVecIArray[n], iVecIArray[n + 1]);
                }
            } else if (bl) {
                iVecI = iVec;
            }
            iVecIArray2[n] = iVecI;
        }
        for (n = 1; n < iVecIArray2.length; ++n) {
            if (bl && n >= iVecIArray2.length - 1 || !(iVecIArray2[n].dot(iVecIArray2[n - 1]) < 0.0)) continue;
            iVecIArray2[n].neg();
        }
        return IVec.offset(iVecIArray, iVecIArray2, iDoubleI);
    }

    public static IVecI projectToPlane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        if (iVecI4 == iVecI) {
            return iVecI;
        }
        iVecI.sub(iVecI4);
        IDoubleI iDoubleI = iVecI.dot(Ir.i, iVecI3).div(iVecI2.dot(Ir.i, iVecI3));
        return iVecI.sub(iVecI2.dup().mul(iDoubleI)).add(iVecI4);
    }

    public static void projectToPlane(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (IVecI iVecI4 : iVecIArray) {
            IVec.projectToPlane(iVecI4, iVecI, iVecI2, iVecI3);
        }
    }

    public static void projectToPlane(IVecI[][] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVecI[][] iVecIArray2 = iVecIArray;
        int n = iVecIArray2.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray3;
            for (IVecI iVecI4 : iVecIArray3 = iVecIArray2[i]) {
                IVec.projectToPlane(iVecI4, iVecI, iVecI2, iVecI3);
            }
        }
    }

    public static void projectToPlane(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2) {
        IVec.projectToPlane(iVecIArray, iVecI, iVecI, iVecI2);
    }

    public static void projectToPlane(IVecI[][] iVecIArray, IVecI iVecI, IVecI iVecI2) {
        IVec.projectToPlane(iVecIArray, iVecI, iVecI, iVecI2);
    }

    public static void projectToPlane(IVecI[] iVecIArray, IVecI iVecI) {
        IVec.projectToPlane(iVecIArray, iVecI, iVecIArray[0]);
    }

    public static void projectToPlane(IVecI[][] iVecIArray, IVecI iVecI) {
        IVec.projectToPlane(iVecIArray, iVecI, iVecIArray[0][0]);
    }

    public static void projectToPlane(IVecI[] iVecIArray) {
        if (iVecIArray == null || iVecIArray.length == 0) {
            return;
        }
        IVec.projectToPlane(iVecIArray, (IVecI)IVec.averageNormal(iVecIArray), iVecIArray[0]);
    }

    public static void projectToPlane(IVecI[][] iVecIArray) {
        if (iVecIArray == null || iVecIArray.length == 0 || iVecIArray[0].length == 0) {
            return;
        }
        IVec.projectToPlane(iVecIArray, (IVecI)IVec.averageNormal(iVecIArray), iVecIArray[0][0]);
    }

    public static IVec intersect(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        if (iVec.dist(iVec3) < IConfig.tolerance) {
            return iVec.dup();
        }
        if (iVec.dist(iVec4) < IConfig.tolerance) {
            return iVec.dup();
        }
        if (iVec2.dist(iVec3) < IConfig.tolerance) {
            return iVec2.dup();
        }
        if (iVec2.dist(iVec4) < IConfig.tolerance) {
            return iVec2.dup();
        }
        IVec iVec5 = iVec2.dif(iVec);
        IVec iVec6 = iVec4.dif(iVec3);
        IVec iVec7 = iVec.dif(iVec3);
        if (iVec5.isParallel(iVec7)) {
            return iVec.dup();
        }
        double[] dArray = iVec6.projectTo2Vec(iVec5, iVec7);
        if (dArray == null || dArray[1] == 0.0) {
            return null;
        }
        iVec5.mul(dArray[0] / dArray[1]);
        iVec5.add(iVec);
        return iVec5;
    }

    public static IVec intersectSegments(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        IVec iVec5 = new IVec(Math.min(iVec.x, iVec2.x), Math.min(iVec.y, iVec2.y), Math.min(iVec.z, iVec2.z));
        IVec iVec6 = new IVec(Math.max(iVec.x, iVec2.x), Math.max(iVec.y, iVec2.y), Math.max(iVec.z, iVec2.z));
        IVec iVec7 = new IVec(Math.min(iVec3.x, iVec4.x), Math.min(iVec3.y, iVec4.y), Math.min(iVec3.z, iVec4.z));
        IVec iVec8 = new IVec(Math.max(iVec3.x, iVec4.x), Math.max(iVec3.y, iVec4.y), Math.max(iVec3.z, iVec4.z));
        IVec iVec9 = iVec2.dif(iVec);
        IVec iVec10 = iVec4.dif(iVec3);
        IVec iVec11 = iVec.dif(iVec3);
        if (iVec9.isParallel(iVec10)) {
            return null;
        }
        double[] dArray = iVec10.projectTo2Vec(iVec9, iVec11);
        if (dArray == null || dArray[1] == 0.0) {
            return null;
        }
        double d = dArray[0] / dArray[1];
        if (d < 0.0 || d > 1.0) {
            return null;
        }
        iVec9.mul(d);
        iVec9.add(iVec);
        return iVec9;
    }

    public static double angle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return iVecI.dif(iVecI2).angle(iVecI3.dif(iVecI2));
    }
}

