/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolOp;
import igeo.IBoolR;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDoubleOp;
import igeo.IDoubleR;
import igeo.IMatrix3I;
import igeo.IMatrix3Op;
import igeo.IMatrix4I;
import igeo.IMatrix4Op;
import igeo.IParameterObject;
import igeo.IReferenceParameter;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2Op;
import igeo.IVec2R;
import igeo.IVec4R;
import igeo.IVecI;
import igeo.IVecOp;

public class IVecR
extends IParameterObject
implements IVecI,
IReferenceParameter {
    protected IVecOp op;

    public IVecR(double d, double d2, double d3) {
        this.op = new IVec(d, d2, d3);
    }

    public IVecR(IVecOp iVecOp) {
        this.op = iVecOp;
    }

    public IVecR(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new FromXYZ(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVecR(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.op = new IVec(d, d2, d3);
    }

    public IVecR(IServerI iServerI, IVecOp iVecOp) {
        super(iServerI);
        this.op = iVecOp;
    }

    public IVecR(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super(iServerI);
        this.op = new FromXYZ(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public double x() {
        return this.op.get().x;
    }

    public double y() {
        return this.op.get().y;
    }

    public double z() {
        return this.op.get().z;
    }

    public IVec get() {
        return this.op.get();
    }

    public IVecR dup() {
        return new IVecR(this.op);
    }

    public IVec2R to2d() {
        return new IVec2R(new ToVec2(this));
    }

    public IVec4R to4d() {
        return new IVec4R(this);
    }

    public IVec4R to4d(double d) {
        return new IVec4R((IVecI)this, d);
    }

    public IVec4R to4d(IDoubleI iDoubleI) {
        return new IVec4R((IVecI)this, iDoubleI);
    }

    public IDoubleR getX() {
        return new IDoubleR(new X(this.op));
    }

    public IDoubleR getY() {
        return new IDoubleR(new Y(this.op));
    }

    public IDoubleR getZ() {
        return new IDoubleR(new Z(this.op));
    }

    public IVecOp operator() {
        return this.op;
    }

    public IVecR set(IVecI iVecI) {
        this.op = iVecI;
        return this;
    }

    public IVecR set(double d, double d2, double d3) {
        this.op = new IVec(d, d2, d3);
        return this;
    }

    public IVecR set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new FromXYZ(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    public IVecR add(double d, double d2, double d3) {
        this.op = new Add(this.op, new IVec(d, d2, d3));
        return this;
    }

    public IVecR add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new Add(this.op, new IVecR(iDoubleI, iDoubleI2, iDoubleI3));
        return this;
    }

    public IVecR add(IVecI iVecI) {
        this.op = new Add(this.op, iVecI);
        return this;
    }

    public IVecR sub(double d, double d2, double d3) {
        this.op = new Sub(this.op, new IVec(d, d2, d3));
        return this;
    }

    public IVecR sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new Sub(this.op, new IVecR(iDoubleI, iDoubleI2, iDoubleI3));
        return this;
    }

    public IVecR sub(IVecI iVecI) {
        this.op = new Sub(this.op, iVecI);
        return this;
    }

    public IVecR mul(IDoubleI iDoubleI) {
        this.op = new Mul(this.op, iDoubleI);
        return this;
    }

    public IVecR mul(double d) {
        this.op = new Mul(this.op, new IDouble(d));
        return this;
    }

    public IVecR div(IDoubleI iDoubleI) {
        this.op = new Div(this.op, iDoubleI);
        return this;
    }

    public IVecR div(double d) {
        this.op = new Div(this.op, new IDouble(d));
        return this;
    }

    public IVecR neg() {
        this.op = new Neg(this.op);
        return this;
    }

    public IVecR rev() {
        return this.neg();
    }

    public IVecR flip() {
        return this.neg();
    }

    public IVecR zero() {
        return this.set(0.0, 0.0, 0.0);
    }

    public IVecR add(IVecI iVecI, double d) {
        return this.add(iVecI.dup().mul(d));
    }

    public IVecR add(IVecI iVecI, IDoubleI iDoubleI) {
        return this.add(iVecI.dup().mul(iDoubleI));
    }

    public IVecR add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    public IVecR add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    public double dot(IVecI iVecI) {
        return this.get().dot(iVecI);
    }

    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dot(iVecI);
    }

    public IDoubleR dot(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new Dot(this.op, iVecI));
    }

    public IVecR cross(IVecI iVecI) {
        return new IVecR(new Cross(this.op, iVecI));
    }

    public double len() {
        return this.get().len();
    }

    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    public IDoubleR len(ISwitchR iSwitchR) {
        return new IDoubleR(new Len(this.op));
    }

    public double len2() {
        return this.get().len2();
    }

    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    public IDoubleR len2(ISwitchR iSwitchR) {
        return new IDoubleR(new Len2(this.op));
    }

    public IVecR len(IDoubleI iDoubleI) {
        this.op = new SetLen(this.op, iDoubleI);
        return this;
    }

    public IVecR len(double d) {
        this.op = new SetLen(this.op, new IDouble(d));
        return this;
    }

    public IVecR unit() {
        this.op = new Unit(this.op);
        return this;
    }

    public double dist(IVecI iVecI) {
        return this.get().dist(iVecI);
    }

    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist(iVecI);
    }

    public IDoubleR dist(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new Dist(this.op, iVecI));
    }

    public double dist2(IVecI iVecI) {
        return this.get().dist2(iVecI);
    }

    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist2(iVecI);
    }

    public IDoubleR dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new Dist2(this.op, iVecI));
    }

    public boolean eq(IVecI iVecI) {
        return this.get().eq(iVecI);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eq(iVecI);
    }

    public IBoolR eq(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new Eq(this.op, iVecI));
    }

    public boolean eq(IVecI iVecI, double d) {
        return this.get().eq(iVecI, d);
    }

    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eq(iVecI, d);
    }

    public IBoolR eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new Eq(this.op, iVecI, iDoubleI));
    }

    public boolean eqX(IVecI iVecI) {
        return this.get().eqX(iVecI);
    }

    public boolean eqY(IVecI iVecI) {
        return this.get().eqY(iVecI);
    }

    public boolean eqZ(IVecI iVecI) {
        return this.get().eqZ(iVecI);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqX(iVecI);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqY(iVecI);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqZ(iVecI);
    }

    public IBoolR eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new EqX(this.op, iVecI));
    }

    public IBoolR eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new EqY(this.op, iVecI));
    }

    public IBoolR eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new EqZ(this.op, iVecI));
    }

    public boolean eqX(IVecI iVecI, double d) {
        return this.get().eqX(iVecI, d);
    }

    public boolean eqY(IVecI iVecI, double d) {
        return this.get().eqY(iVecI, d);
    }

    public boolean eqZ(IVecI iVecI, double d) {
        return this.get().eqZ(iVecI, d);
    }

    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqX(iVecI, d);
    }

    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqY(iVecI, d);
    }

    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqZ(iVecI, d);
    }

    public IBoolR eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new EqX(this.op, iVecI, iDoubleI));
    }

    public IBoolR eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new EqY(this.op, iVecI, iDoubleI));
    }

    public IBoolR eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new EqZ(this.op, iVecI, iDoubleI));
    }

    public double angle(IVecI iVecI) {
        return this.get().angle(iVecI);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.angle(iVecI);
    }

    public IDoubleR angle(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new Angle(this.op, iVecI));
    }

    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.get().angle(iVecI, iVecI2);
    }

    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.angle(iVecI, iVecI2);
    }

    public IDoubleR angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return new IDoubleR(new Angle(this.op, iVecI, iVecI2));
    }

    public IVecR rot(IDoubleI iDoubleI) {
        this.op = new Rot2(this.op, iDoubleI);
        return this;
    }

    public IVecR rot(double d) {
        return this.rot(new IDouble(d));
    }

    public IVecR rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.op = new Rot(this.op, iVecI, iDoubleI);
        return this;
    }

    public IVecR rot(IVecI iVecI, double d) {
        return this.rot(iVecI, new IDouble(d));
    }

    public IVecR rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot(iVecI2, iDoubleI).add(iVecI);
    }

    public IVecR rot(IVecI iVecI, IVecI iVecI2, double d) {
        return this.rot(iVecI, iVecI2, new IDouble(d));
    }

    public IVecR rot(IVecI iVecI, IVecI iVecI2) {
        return this.rot(iVecI, iVecI2.cross(iVecI).angle(this.cross(iVecI)));
    }

    public IVecR rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot(iVecI2, iVecI3.diff(iVecI)).add(iVecI);
    }

    public IVecR rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    public IVecR rot2(double d) {
        return this.rot(d);
    }

    public IVecR rot2(IVecI iVecI, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot(iDoubleI).add(iVecI);
    }

    public IVecR rot2(IVecI iVecI, double d) {
        return this.rot2(iVecI, new IDouble(d));
    }

    public IVecR rot2(IVecI iVecI) {
        return this.rot(iVecI.cross(IVec.zaxis).angle(this.cross(IVec.zaxis)));
    }

    public IVecR rot2(IVecI iVecI, IVecI iVecI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot2(iVecI2.diff(iVecI)).add(iVecI);
    }

    public IVecR scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public IVecR scale(double d) {
        return this.mul(d);
    }

    public IVecR scale(IVecI iVecI, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).mul(iDoubleI).add(iVecI);
    }

    public IVecR scale(IVecI iVecI, double d) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).mul(d).add(iVecI);
    }

    public IVecR scale1d(IVecI iVecI, double d) {
        return this.scale1d(iVecI, new IDouble(d));
    }

    public IVecR scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.op = new Scale1d(this.op, iVecI, iDoubleI);
        return this;
    }

    public IVecR scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        return this.scale1d(iVecI, iVecI2, new IDouble(d));
    }

    public IVecR scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).scale1d(iVecI2, iDoubleI).add(iVecI);
    }

    public IVecR ref(IVecI iVecI) {
        this.op = new Ref(this.op, iVecI);
        return this;
    }

    public IVecR ref(IVecI iVecI, IVecI iVecI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).ref(iVecI2).add(iVecI);
    }

    public IVecR mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    public IVecR mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    public IVecR shear(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.shear(new IDouble(d), new IDouble(d2), new IDouble(d3), new IDouble(d4), new IDouble(d5), new IDouble(d6));
    }

    public IVecR shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.op = new Shear(this.op, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    public IVecR shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shear(d, d2, d3, d4, d5, d6).add(iVecI);
    }

    public IVecR shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6).add(iVecI);
    }

    public IVecR shearXY(double d, double d2) {
        return this.shear(d, d2, 0.0, 0.0, 0.0, 0.0);
    }

    public IVecR shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shear(iDoubleI, iDoubleI2, null, null, null, null);
    }

    public IVecR shearXY(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearXY(d, d2).add(iVecI);
    }

    public IVecR shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearXY(iDoubleI, iDoubleI2).add(iVecI);
    }

    public IVecR shearYZ(double d, double d2) {
        return this.shear(0.0, 0.0, d, d2, 0.0, 0.0);
    }

    public IVecR shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shear(null, null, iDoubleI, iDoubleI2, null, null);
    }

    public IVecR shearYZ(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearYZ(d, d2).add(iVecI);
    }

    public IVecR shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearYZ(iDoubleI, iDoubleI2).add(iVecI);
    }

    public IVecR shearZX(double d, double d2) {
        return this.shear(0.0, 0.0, 0.0, 0.0, d, d2);
    }

    public IVecR shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shear(null, null, null, null, iDoubleI, iDoubleI2);
    }

    public IVecR shearZX(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearZX(d, d2).add(iVecI);
    }

    public IVecR shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearZX(iDoubleI, iDoubleI2).add(iVecI);
    }

    public IVecR translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVecR translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVecR translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVecR transform(IMatrix3I iMatrix3I) {
        this.op = new Transform3(this.op, iMatrix3I);
        return this;
    }

    public IVecR transform(IMatrix4I iMatrix4I) {
        this.op = new Transform4(this.op, iMatrix4I);
        return this;
    }

    public IVecR transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.op = new TransformVec3(this.op, iVecI, iVecI2, iVecI3);
        return this;
    }

    public IVecR transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.op = new TransformVec4(this.op, iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    public IVecR mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public IVecR mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVecR mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public IVecR cp() {
        return this.dup();
    }

    public IVecR cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public IVecR cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVecR cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVecR dif(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    public IVecR diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    public IVecR mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    public IVecR sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public IVecR sum(IVecI ... iVecIArray) {
        IVecR iVecR = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVecR.add(iVecI);
        }
        return iVecR;
    }

    public IVecR bisect(IVecI iVecI) {
        return this.dup().unit().add(iVecI.dup().unit());
    }

    public IVecR sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.dup().mul(iDoubleI).add(iVecI, iDoubleI2);
    }

    public IVecR sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.dup().mul(new IDouble(1.0).sub(iDoubleI)).add(iVecI, iDoubleI);
    }

    public IVecR sum(IVecI iVecI, double d, double d2) {
        return this.sum(iVecI, new IDouble(d), new IDouble(d2));
    }

    public IVecR sum(IVecI iVecI, double d) {
        return this.sum(iVecI, new IDouble(d));
    }

    public IVecR nml(IVecI iVecI) {
        return this.cross(iVecI);
    }

    public IVecR nml(IVecI iVecI, IVecI iVecI2) {
        return this.diff(iVecI).cross(this.diff(iVecI2)).unit();
    }

    public boolean isValid() {
        return this.get().isValid();
    }

    public static class TransformVec4
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IVecOp x;
        public IVecOp y;
        public IVecOp z;
        public IVecOp trans;

        public TransformVec4(IVecOp iVecOp, IVecOp iVecOp2, IVecOp iVecOp3, IVecOp iVecOp4, IVecOp iVecOp5) {
            this.v = iVecOp;
            this.x = iVecOp2;
            this.y = iVecOp3;
            this.z = iVecOp4;
            this.trans = iVecOp5;
        }

        public IVec get() {
            return this.v.get().transform(this.x.get(), this.y.get(), this.z.get(), this.trans.get());
        }
    }

    public static class TransformVec3
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IVecOp x;
        public IVecOp y;
        public IVecOp z;

        public TransformVec3(IVecOp iVecOp, IVecOp iVecOp2, IVecOp iVecOp3, IVecOp iVecOp4) {
            this.v = iVecOp;
            this.x = iVecOp2;
            this.y = iVecOp3;
            this.z = iVecOp4;
        }

        public IVec get() {
            return this.v.get().transform(this.x.get(), this.y.get(), this.z.get());
        }
    }

    public static class Transform4
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IMatrix4Op mat;

        public Transform4(IVecOp iVecOp, IMatrix4Op iMatrix4Op) {
            this.v = iVecOp;
            this.mat = iMatrix4Op;
        }

        public IVec get() {
            return this.v.get().transform(this.mat.get());
        }
    }

    public static class Transform3
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IMatrix3Op mat;

        public Transform3(IVecOp iVecOp, IMatrix3Op iMatrix3Op) {
            this.v = iVecOp;
            this.mat = iMatrix3Op;
        }

        public IVec get() {
            return this.v.get().transform(this.mat.get());
        }
    }

    public static class Shear
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IDoubleOp sxy;
        public IDoubleOp syx;
        public IDoubleOp syz;
        public IDoubleOp szy;
        public IDoubleOp szx;
        public IDoubleOp sxz;

        public Shear(IVecOp iVecOp, IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2, IDoubleOp iDoubleOp3, IDoubleOp iDoubleOp4, IDoubleOp iDoubleOp5, IDoubleOp iDoubleOp6) {
            this.v = iVecOp;
            this.sxy = iDoubleOp;
            this.syx = iDoubleOp2;
            this.syz = iDoubleOp3;
            this.szy = iDoubleOp4;
            this.szx = iDoubleOp5;
            this.sxz = iDoubleOp6;
        }

        public IVec get() {
            return this.v.get().shear(this.sxy.get(), this.syx.get(), this.syz.get(), this.szy.get(), this.szx.get(), this.sxz.get());
        }
    }

    public static class Ref
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IVecOp plane;

        public Ref(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v = iVecOp;
            this.plane = iVecOp2;
        }

        public IVec get() {
            return this.v.get().ref(this.plane.get());
        }
    }

    public static class Scale1d
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IVecOp axis;
        public IDoubleI factor;

        public Scale1d(IVecOp iVecOp, IVecOp iVecOp2, IDoubleI iDoubleI) {
            this.v = iVecOp;
            this.axis = iVecOp2;
            this.factor = iDoubleI;
        }

        public IVec get() {
            return this.v.get().scale1d((IVecI)this.axis.get(), this.factor.get());
        }
    }

    public static class EqZ
    extends IParameterObject
    implements IBoolOp {
        public IVecOp v1;
        public IVecOp v2;
        public IDoubleOp resolution = null;

        public EqZ(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public EqZ(IVecOp iVecOp, IVecOp iVecOp2, IDoubleOp iDoubleOp) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
            this.resolution = iDoubleOp;
        }

        public boolean x() {
            if (this.resolution == null) {
                return this.v1.get().eqZ(this.v2.get());
            }
            return this.v1.get().eqZ(this.v2.get(), this.resolution.x());
        }

        public IBool get() {
            if (this.resolution == null) {
                return this.v1.get().eqZ((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eqZ((ISwitchR)null, (IVecI)this.v2.get(), this.resolution.get());
        }
    }

    public static class EqY
    extends IParameterObject
    implements IBoolOp {
        public IVecOp v1;
        public IVecOp v2;
        public IDoubleOp resolution = null;

        public EqY(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public EqY(IVecOp iVecOp, IVecOp iVecOp2, IDoubleOp iDoubleOp) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
            this.resolution = iDoubleOp;
        }

        public boolean x() {
            if (this.resolution == null) {
                return this.v1.get().eqY(this.v2.get());
            }
            return this.v1.get().eqY(this.v2.get(), this.resolution.x());
        }

        public IBool get() {
            if (this.resolution == null) {
                return this.v1.get().eqY((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eqY((ISwitchR)null, (IVecI)this.v2.get(), this.resolution.get());
        }
    }

    public static class EqX
    extends IParameterObject
    implements IBoolOp {
        public IVecOp v1;
        public IVecOp v2;
        public IDoubleOp resolution = null;

        public EqX(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public EqX(IVecOp iVecOp, IVecOp iVecOp2, IDoubleOp iDoubleOp) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
            this.resolution = iDoubleOp;
        }

        public boolean x() {
            if (this.resolution == null) {
                return this.v1.get().eqX(this.v2.get());
            }
            return this.v1.get().eqX(this.v2.get(), this.resolution.x());
        }

        public IBool get() {
            if (this.resolution == null) {
                return this.v1.get().eqX((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eqX((ISwitchR)null, (IVecI)this.v2.get(), this.resolution.get());
        }
    }

    public static class Eq
    extends IParameterObject
    implements IBoolOp {
        public IVecOp v1;
        public IVecOp v2;
        public IDoubleOp resolution = null;

        public Eq(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public Eq(IVecOp iVecOp, IVecOp iVecOp2, IDoubleOp iDoubleOp) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
            this.resolution = iDoubleOp;
        }

        public boolean x() {
            if (this.resolution == null) {
                return this.v1.get().eq(this.v2.get());
            }
            return this.v1.get().eq(this.v2.get(), this.resolution.x());
        }

        public IBool get() {
            if (this.resolution == null) {
                return this.v1.get().eq((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eq((ISwitchR)null, (IVecI)this.v2.get(), this.resolution.get());
        }
    }

    public static class Dist2
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v1;
        public IVecOp v2;

        public Dist2(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public double x() {
            return this.v1.get().dist2(this.v2.get());
        }

        public IDouble get() {
            return this.v1.get().dist2((ISwitchR)null, (IVecI)this.v2.get());
        }
    }

    public static class Dist
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v1;
        public IVecOp v2;

        public Dist(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public double x() {
            return this.v1.get().dist(this.v2.get());
        }

        public IDouble get() {
            return this.v1.get().dist((ISwitchR)null, (IVecI)this.v2.get());
        }
    }

    public static class SetLen
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IDoubleOp l;

        public SetLen(IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v = iVecOp;
            this.l = iDoubleOp;
        }

        public IVec get() {
            return this.v.get().len(this.l.x());
        }
    }

    public static class Unit
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;

        public Unit(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public IVec get() {
            return this.v.get().unit();
        }
    }

    public static class Z
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v;

        public Z(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public double x() {
            return this.v.get().z;
        }

        public IDouble get() {
            return this.v.get().getZ();
        }
    }

    public static class Y
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v;

        public Y(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public double x() {
            return this.v.get().y;
        }

        public IDouble get() {
            return this.v.get().getY();
        }
    }

    public static class X
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v;

        public X(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public double x() {
            return this.v.get().x;
        }

        public IDouble get() {
            return this.v.get().getX();
        }
    }

    public static class Len2
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v;

        public Len2(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public double x() {
            return this.v.get().len2();
        }

        public IDouble get() {
            return this.v.get().len2((ISwitchR)null);
        }
    }

    public static class Len
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v;

        public Len(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public double x() {
            return this.v.get().len();
        }

        public IDouble get() {
            return this.v.get().len((ISwitchR)null);
        }
    }

    public static class Rot2
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IDoubleOp angle;

        public Rot2(IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v = iVecOp;
            this.angle = iDoubleOp;
        }

        public IVec get() {
            return this.v.get().rot(this.angle.x());
        }
    }

    public static class Rot
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IVecOp axis;
        public IDoubleOp angle;

        public Rot(IVecOp iVecOp, IVecOp iVecOp2, IDoubleOp iDoubleOp) {
            this.v = iVecOp;
            this.axis = iVecOp2;
            this.angle = iDoubleOp;
        }

        public IVec get() {
            return this.v.get().rot(this.axis.get(), this.angle.x());
        }
    }

    public static class Angle
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v1;
        public IVecOp v2;
        public IVecOp axis = null;

        public Angle(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public Angle(IVecOp iVecOp, IVecOp iVecOp2, IVecOp iVecOp3) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
            this.axis = iVecOp3;
        }

        public double x() {
            if (this.axis == null) {
                return this.v1.get().angle(this.v2.get());
            }
            return this.v1.get().angle(this.v2.get(), this.axis.get());
        }

        public IDouble get() {
            if (this.axis == null) {
                return this.v1.get().angle((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().angle((ISwitchR)null, (IVecI)this.v2.get(), (IVecI)this.axis.get());
        }
    }

    public static class Cross
    extends IParameterObject
    implements IVecOp {
        public IVecOp v1;
        public IVecOp v2;

        public Cross(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public IVec get() {
            return this.v1.get().cross(this.v2.get());
        }
    }

    public static class Dot
    extends IParameterObject
    implements IDoubleOp {
        public IVecOp v1;
        public IVecOp v2;

        public Dot(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public double x() {
            return this.v1.get().dot(this.v2.get());
        }

        public IDouble get() {
            return this.v1.get().dot((ISwitchR)null, (IVecI)this.v2.get());
        }
    }

    public static class ToVec2
    extends IParameterObject
    implements IVec2Op {
        public IVecOp v;

        public ToVec2(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public IVec2 get() {
            return new IVec2(this.v.get());
        }
    }

    public static class FromXYZ
    extends IParameterObject
    implements IVecOp {
        public IDoubleOp x;
        public IDoubleOp y;
        public IDoubleOp z;

        public FromXYZ(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2, IDoubleOp iDoubleOp3) {
            this.x = iDoubleOp;
            this.y = iDoubleOp2;
            this.z = iDoubleOp3;
        }

        public IVec get() {
            return new IVec(this.x.x(), this.y.x(), this.z.x());
        }
    }

    public static class Neg
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;

        public Neg(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        public IVec get() {
            return this.v.get().neg();
        }
    }

    public static class Div
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IDoubleOp d;

        public Div(IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v = iVecOp;
            this.d = iDoubleOp;
        }

        public IVec get() {
            return this.v.get().div(this.d.x());
        }
    }

    public static class Mul
    extends IParameterObject
    implements IVecOp {
        public IVecOp v;
        public IDoubleOp d;

        public Mul(IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v = iVecOp;
            this.d = iDoubleOp;
        }

        public IVec get() {
            return this.v.get().mul(this.d.x());
        }
    }

    public static class Sub
    extends IParameterObject
    implements IVecOp {
        public IVecOp v1;
        public IVecOp v2;

        public Sub(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public IVec get() {
            return this.v1.get().sub(this.v2.get());
        }
    }

    public static class Add
    extends IParameterObject
    implements IVecOp {
        public IVecOp v1;
        public IVecOp v2;

        public Add(IVecOp iVecOp, IVecOp iVecOp2) {
            this.v1 = iVecOp;
            this.v2 = iVecOp2;
        }

        public IVec get() {
            return this.v1.get().add(this.v2.get());
        }
    }
}

