/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDynamics;
import igeo.ILayer;
import igeo.IObject;
import igeo.ISubobject;
import java.awt.Color;
import java.util.ArrayList;

public class IAgent
extends IObject
implements IDynamics {
    public IObject parent = null;
    public ArrayList<IObject> targets;
    public ArrayList<IDynamics> localDynamics;
    public int time = -1;
    public int duration = -1;
    public boolean alive = true;

    public IAgent() {
        this.initAgent();
    }

    public IAgent(IObject iObject) {
        this.parent = iObject;
        this.initAgent();
    }

    public void initAgent() {
        super.addDynamics(this);
    }

    @Override
    public void addDynamics(IDynamics iDynamics) {
        if (this.localDynamics == null) {
            this.localDynamics = new ArrayList();
        }
        if (!this.localDynamics.contains(iDynamics)) {
            this.localDynamics.add(iDynamics);
            if (iDynamics.parent() != this) {
                iDynamics.parent(this);
            }
        }
    }

    @Override
    public IDynamics getDynamics(int n) {
        if (this.localDynamics == null) {
            return null;
        }
        return this.localDynamics.get(n);
    }

    @Override
    public int dynamicsNum() {
        if (this.localDynamics == null) {
            return 0;
        }
        return this.localDynamics.size();
    }

    @Override
    public void deleteDynamics() {
        if (this.server != null && this.server.dynamicServer != null && this.localDynamics != null) {
            for (IDynamics iDynamics : this.localDynamics) {
                this.server.dynamicServer.remove(iDynamics);
            }
        }
    }

    @Override
    public void deletDynamics(int n) {
        if (this.localDynamics == null || n < 0 || n >= this.localDynamics.size()) {
            return;
        }
        if (this.server != null && this.server.dynamicServer != null) {
            this.server.dynamicServer.remove(this.localDynamics.get(n));
        }
        this.localDynamics.remove(n);
    }

    @Override
    public void deleteDynamics(IDynamics iDynamics) {
        if (this.localDynamics == null || !this.localDynamics.contains(iDynamics)) {
            return;
        }
        if (this.server != null && this.server.dynamicServer != null) {
            this.server.dynamicServer.remove(iDynamics);
        }
        this.localDynamics.remove(iDynamics);
    }

    @Override
    public void del() {
        this.alive = false;
        this.deleteDynamics();
        super.del();
    }

    @Override
    public void updateGraphic() {
        if (this.parent != null) {
            this.parent.updateGraphic();
        }
    }

    @Override
    public IObject parent() {
        return this.parent;
    }

    @Override
    public ISubobject parent(IObject iObject) {
        if (this.parent != null) {
            this.parent.deleteDynamics(this);
            this.removeTarget(this.parent);
        }
        this.parent = iObject;
        if (this.parent != null) {
            this.parent.addDynamics(this);
            this.target(this.parent);
        }
        return this;
    }

    @Override
    public IAgent target(IObject iObject) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        this.targets.add(iObject);
        return this;
    }

    @Override
    public int targetNum() {
        return this.targets == null ? 0 : this.targets.size();
    }

    @Override
    public IObject target(int n) {
        if (n < 0 || n >= this.targets.size()) {
            return null;
        }
        return this.targets.get(n);
    }

    @Override
    public ArrayList<IObject> targets() {
        return this.targets;
    }

    @Override
    public IAgent removeTarget(int n) {
        if (n < 0 || n >= this.targets.size()) {
            return null;
        }
        this.targets.remove(n);
        return this;
    }

    @Override
    public IAgent removeTarget(IObject iObject) {
        this.targets.remove(iObject);
        return this;
    }

    @Override
    public void updateTarget() {
        if (this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                if (this.targets.get(i).server() == null) continue;
                this.targets.get(i).updateGraphic();
            }
        }
    }

    public boolean alive() {
        return this.alive;
    }

    public int time() {
        return this.time;
    }

    public IAgent time(int n) {
        this.time = n;
        return this;
    }

    public int duration() {
        return this.duration;
    }

    public IAgent duration(int n) {
        this.duration = n;
        return this;
    }

    @Override
    public synchronized void preinteract(ArrayList<IDynamics> arrayList) {
        ++this.time;
        if (this.localDynamics != null) {
            for (IDynamics iDynamics : this.localDynamics) {
                iDynamics.interact(arrayList);
            }
        }
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) == this) continue;
            this.interact(arrayList.get(i));
        }
    }

    public synchronized void interact(IDynamics iDynamics) {
    }

    @Override
    public synchronized void postinteract(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public synchronized void preupdate() {
        if (this.localDynamics != null) {
            for (IDynamics iDynamics : this.localDynamics) {
                iDynamics.update();
            }
        }
        if (this.duration >= 0 && this.time >= this.duration) {
            this.del();
        } else if (this.server != null) {
            this.server.updateState();
        }
    }

    @Override
    public synchronized void update() {
    }

    @Override
    public synchronized void postupdate() {
    }

    @Override
    public IAgent name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IAgent layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IAgent hide() {
        super.hide();
        return this;
    }

    @Override
    public IAgent show() {
        super.show();
        return this;
    }

    @Override
    public IAgent clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public IAgent clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public IAgent clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public IAgent clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public IAgent clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public IAgent clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public IAgent clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public IAgent clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public IAgent clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public IAgent clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public IAgent clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public IAgent clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public IAgent clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public IAgent clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public IAgent hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public IAgent hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public IAgent hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public IAgent hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IAgent setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public IAgent setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public IAgent setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public IAgent setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public IAgent setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public IAgent setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public IAgent setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public IAgent setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public IAgent setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public IAgent setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public IAgent setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public IAgent setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public IAgent setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IAgent setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IAgent setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IAgent setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IAgent setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public IAgent setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }
}

