/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDoubleI;
import igeo.IGraphicObject;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IServerI;
import igeo.ISurfaceGeo;
import igeo.ITransformable;
import igeo.IVecI;
import igeo.gui.IBrepGraphicGL;
import igeo.gui.IGraphicMode;
import java.awt.Color;

public class IBrep
extends IObject
implements ITransformable {
    public ISurfaceGeo[] surfaces;
    public boolean solid = false;

    public IBrep(ISurfaceGeo[] iSurfaceGeoArray) {
        this(null, iSurfaceGeoArray);
    }

    public IBrep(IServerI iServerI, ISurfaceGeo[] iSurfaceGeoArray) {
        super(iServerI);
        this.surfaces = iSurfaceGeoArray;
        this.initBrep(iServerI);
    }

    public IBrep(IBrep iBrep) {
        this((IServerI)iBrep.server, iBrep);
    }

    public IBrep(IServerI iServerI, IBrep iBrep) {
        super(iServerI, iBrep);
        if (iBrep.surfaces != null) {
            this.surfaces = new ISurfaceGeo[iBrep.surfaces.length];
            for (int i = 0; i < this.surfaces.length; ++i) {
                this.surfaces[i] = iBrep.surfaces[i].dup();
            }
        }
        this.solid = iBrep.solid;
        this.initBrep(iServerI);
    }

    public void initBrep(IServerI iServerI) {
        this.parameter = null;
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    @Override
    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        if (iGraphicMode.isGL()) {
            return new IBrepGraphicGL(this);
        }
        return null;
    }

    public ISurfaceGeo surface(int n) {
        return this.surfaces[n];
    }

    public int surfaceNum() {
        return this.surfaces.length;
    }

    @Override
    public IBrep dup() {
        return new IBrep(this);
    }

    @Override
    public IBrep name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IBrep layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IBrep hide() {
        super.hide();
        return this;
    }

    @Override
    public IBrep show() {
        super.show();
        return this;
    }

    @Override
    public IBrep clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public IBrep clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public IBrep clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public IBrep clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public IBrep clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public IBrep clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public IBrep clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public IBrep clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public IBrep clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public IBrep clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public IBrep clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public IBrep clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public IBrep clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBrep clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBrep hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBrep hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBrep hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public IBrep hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IBrep setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public IBrep setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public IBrep setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public IBrep setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public IBrep setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public IBrep setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    public IBrep setColor(float f, int n) {
        super.setColor(f, (float)n);
        return this;
    }

    @Override
    public IBrep setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public IBrep setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public IBrep setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public IBrep setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public IBrep setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public IBrep setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBrep setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBrep setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IBrep setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBrep setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public IBrep setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }

    @Override
    public IBrep add(double d, double d2, double d3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].add(d, d2, d3);
        }
        return this;
    }

    @Override
    public IBrep add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].add(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public IBrep add(IVecI iVecI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].add(iVecI);
        }
        return this;
    }

    @Override
    public IBrep sub(double d, double d2, double d3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].sub(d, d2, d3);
        }
        return this;
    }

    @Override
    public IBrep sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].sub(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public IBrep sub(IVecI iVecI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].sub(iVecI);
        }
        return this;
    }

    @Override
    public IBrep mul(IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mul(iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep mul(double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mul(d);
        }
        return this;
    }

    @Override
    public IBrep div(IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].div(iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep div(double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].div(d);
        }
        return this;
    }

    @Override
    public IBrep neg() {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].neg();
        }
        return this;
    }

    @Override
    public IBrep flip() {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].flip();
        }
        return this;
    }

    @Override
    public IBrep add(IVecI iVecI, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].add(iVecI, d);
        }
        return this;
    }

    @Override
    public IBrep add(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].add(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IBrep add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public IBrep rot(IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep rot(double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(d);
        }
        return this;
    }

    @Override
    public IBrep rot(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep rot(IVecI iVecI, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iVecI, d);
        }
        return this;
    }

    @Override
    public IBrep rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iVecI, iVecI2, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep rot(IVecI iVecI, IVecI iVecI2, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iVecI, iVecI2, d);
        }
        return this;
    }

    @Override
    public IBrep rot(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IBrep rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot(iVecI, iVecI2, iVecI3);
        }
        return this;
    }

    @Override
    public IBrep rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IBrep rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IBrep rot2(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot2(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep rot2(IVecI iVecI, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot2(iVecI, d);
        }
        return this;
    }

    @Override
    public IBrep rot2(IVecI iVecI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot2(iVecI);
        }
        return this;
    }

    @Override
    public IBrep rot2(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].rot2(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IBrep scale(IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale(iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep scale(double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale(d);
        }
        return this;
    }

    @Override
    public IBrep scale(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep scale(IVecI iVecI, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale(iVecI, d);
        }
        return this;
    }

    @Override
    public IBrep scale1d(IVecI iVecI, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale1d(iVecI, d);
        }
        return this;
    }

    @Override
    public IBrep scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale1d(iVecI, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale1d(iVecI, iVecI2, d);
        }
        return this;
    }

    @Override
    public IBrep scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].scale1d(iVecI, iVecI2, iDoubleI);
        }
        return this;
    }

    @Override
    public IBrep ref(IVecI iVecI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].ref(iVecI);
        }
        return this;
    }

    @Override
    public IBrep ref(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].ref(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IBrep mirror(IVecI iVecI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mirror(iVecI);
        }
        return this;
    }

    @Override
    public IBrep mirror(IVecI iVecI, IVecI iVecI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mirror(iVecI, iVecI2);
        }
        return this;
    }

    @Override
    public IBrep shear(double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shear(d, d2, d3, d4, d5, d6);
        }
        return this;
    }

    @Override
    public IBrep shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        }
        return this;
    }

    @Override
    public IBrep shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shear(iVecI, d, d2, d3, d4, d5, d6);
        }
        return this;
    }

    @Override
    public IBrep shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        }
        return this;
    }

    @Override
    public IBrep shearXY(double d, double d2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearXY(d, d2);
        }
        return this;
    }

    @Override
    public IBrep shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearXY(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IBrep shearXY(IVecI iVecI, double d, double d2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearXY(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public IBrep shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearXY(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IBrep shearYZ(double d, double d2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearYZ(d, d2);
        }
        return this;
    }

    @Override
    public IBrep shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearYZ(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IBrep shearYZ(IVecI iVecI, double d, double d2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearYZ(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public IBrep shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearYZ(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IBrep shearZX(double d, double d2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearZX(d, d2);
        }
        return this;
    }

    @Override
    public IBrep shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearZX(iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IBrep shearZX(IVecI iVecI, double d, double d2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearZX(iVecI, d, d2);
        }
        return this;
    }

    @Override
    public IBrep shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].shearZX(iVecI, iDoubleI, iDoubleI2);
        }
        return this;
    }

    @Override
    public IBrep mv(double d, double d2, double d3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mv(d, d2, d3);
        }
        return this;
    }

    @Override
    public IBrep mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mv(iDoubleI, iDoubleI2, iDoubleI3);
        }
        return this;
    }

    @Override
    public IBrep mv(IVecI iVecI) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].mv(iVecI);
        }
        return this;
    }

    @Override
    public IBrep cp() {
        return this.dup();
    }

    @Override
    public IBrep cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IBrep cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBrep cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IBrep translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IBrep translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBrep translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IBrep transform(IMatrix3I iMatrix3I) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].transform(iMatrix3I);
        }
        return this;
    }

    @Override
    public IBrep transform(IMatrix4I iMatrix4I) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].transform(iMatrix4I);
        }
        return this;
    }

    @Override
    public IBrep transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].transform(iVecI, iVecI2, iVecI3);
        }
        return this;
    }

    @Override
    public IBrep transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        for (int i = 0; i < this.surfaces.length; ++i) {
            this.surfaces[i].transform(iVecI, iVecI2, iVecI3, iVecI4);
        }
        return this;
    }
}

