/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDynamics;
import igeo.IG;
import igeo.IObject;
import igeo.IServerI;
import java.util.ArrayList;

public class IDynamicsBase
implements IDynamics {
    public IObject parent = null;
    public ArrayList<IObject> targets;

    public IDynamicsBase() {
        this.initDynamicsBase();
    }

    public IDynamicsBase(IServerI iServerI) {
        this.initDynamicsBase(iServerI);
    }

    public IDynamicsBase(IObject iObject) {
        this.parent(iObject);
    }

    public IDynamicsBase(IDynamicsBase iDynamicsBase) {
        if (iDynamicsBase.parent != null) {
            this.parent(iDynamicsBase.parent);
        } else {
            this.initDynamicsBase();
        }
        for (int i = 0; i < iDynamicsBase.targetNum(); ++i) {
            this.target(iDynamicsBase.target(i));
        }
    }

    public void initDynamicsBase() {
        this.initDynamicsBase(IG.cur());
    }

    public void initDynamicsBase(IServerI iServerI) {
        if (iServerI != null) {
            iServerI.server().dynamicServer().add(this);
        }
    }

    @Override
    public IObject parent() {
        return this.parent;
    }

    @Override
    public IDynamicsBase parent(IObject iObject) {
        if (this.parent == iObject) {
            return this;
        }
        if (this.parent == null) {
            IG iG = IG.cur();
            if (iG != null) {
                iG.server().dynamicServer().remove(this);
            }
        } else {
            this.parent.deleteDynamics(this);
            this.removeTarget(this.parent);
        }
        this.parent = iObject;
        if (this.parent != null) {
            this.parent.addDynamics(this);
            this.target(this.parent);
        }
        return this;
    }

    @Override
    public IDynamicsBase target(IObject iObject) {
        if (this.targets == null) {
            this.targets = new ArrayList();
        }
        this.targets.add(iObject);
        return this;
    }

    @Override
    public int targetNum() {
        return this.targets == null ? 0 : this.targets.size();
    }

    @Override
    public IObject target(int n) {
        if (this.targets == null || n < 0 || n >= this.targets.size()) {
            return null;
        }
        return this.targets.get(n);
    }

    @Override
    public ArrayList<IObject> targets() {
        return this.targets;
    }

    @Override
    public IDynamicsBase removeTarget(int n) {
        if (n < 0 || n >= this.targets.size()) {
            return null;
        }
        this.targets.remove(n);
        return this;
    }

    @Override
    public IDynamicsBase removeTarget(IObject iObject) {
        this.targets.remove(iObject);
        return this;
    }

    @Override
    public void updateTarget() {
        if (this.targets != null) {
            for (int i = 0; i < this.targets.size(); ++i) {
                if (this.targets.get(i).server() == null) continue;
                this.targets.get(i).updateGraphic();
            }
        }
    }

    @Override
    public void interact(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public void update() {
    }

    @Override
    public void preinteract(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public void postinteract(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public void preupdate() {
    }

    @Override
    public void postupdate() {
    }
}

