/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IArc;
import igeo.IBoolI;
import igeo.IBox;
import igeo.IBrep;
import igeo.ICircle;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveCreator;
import igeo.ICurveI;
import igeo.ICylinder;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDynamicServer;
import igeo.IGraphicObject;
import igeo.ILayer;
import igeo.IMesh;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IServer;
import igeo.IServerI;
import igeo.ISphere;
import igeo.ISurface;
import igeo.ISurfaceCreator;
import igeo.ISurfaceI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IGridPanel;
import igeo.gui.IPane;
import igeo.gui.IPanel;
import igeo.gui.IScreenTogglePanel;
import igeo.gui.IView;
import igeo.io.IIO;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class IG
implements IServerI {
    public static final Object lock = new Object();
    public static final String GL = "igeo.p.PIGraphicsGL";
    protected static ArrayList<IG> iglist = null;
    protected static int currentId = -1;
    public static final IVec xaxis = IVec.xaxis;
    public static final IVec yaxis = IVec.yaxis;
    public static final IVec zaxis = IVec.zaxis;
    public static final IVec origin = IVec.origin;
    public static final IVec x = IVec.xaxis;
    public static final IVec y = IVec.yaxis;
    public static final IVec z = IVec.zaxis;
    public static final IVec o = IVec.origin;
    public IServer server;
    public IPanel panel = null;
    public String inputFile;
    public String outputFile;
    public String basePath = ".";

    public static int majorVersion() {
        return 0;
    }

    public static int minorVersion() {
        return 7;
    }

    public static int buildVersion() {
        return 3;
    }

    public static int revisionVersion() {
        return 1;
    }

    public static Calendar versionDate() {
        return new GregorianCalendar(2011, 10, 24);
    }

    public static String version() {
        return String.valueOf(IG.majorVersion()) + "." + String.valueOf(IG.minorVersion()) + "." + String.valueOf(IG.buildVersion()) + "." + String.valueOf(IG.revisionVersion());
    }

    public static IG init() {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG();
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG init(IPanel iPanel) {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG(iPanel);
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG current() {
        return IG.cur();
    }

    public static IG cur() {
        if (iglist == null || currentId < 0 || currentId >= iglist.size()) {
            return null;
        }
        return iglist.get(currentId);
    }

    public static IG defaultThread() {
        return IG.cur();
    }

    public static IDynamicServer dynamicThread() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.dynamicServer();
    }

    public static IDynamicServer updateThread() {
        return IG.dynamicThread();
    }

    public static void setCurrent(IG iG) {
        int n = iglist.indexOf(iG);
        if (n >= 0 && n < iglist.size()) {
            currentId = n;
        } else {
            iglist.add(iG);
            currentId = iglist.size() - 1;
        }
        ICurveCreator.server(iG);
        ISurfaceCreator.server(iG);
    }

    public static void setCurrent(IPanel iPanel) {
        for (int i = 0; i < iglist.size(); ++i) {
            if (IG.iglist.get((int)i).panel != iPanel) continue;
            currentId = i;
            ICurveCreator.server(iglist.get(i));
            ISurfaceCreator.server(iglist.get(i));
            return;
        }
        IOut.err("no IG instance found for " + iPanel);
    }

    public static IG getIG(IPanel iPanel) {
        for (IG iG : iglist) {
            if (iG.panel != iPanel) continue;
            return iG;
        }
        return null;
    }

    public static boolean open(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.openFile(string);
    }

    public static boolean save(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveFile(string);
    }

    public static void duration(int n) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setDuration(n);
        }
    }

    public static int duration() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getDuration();
    }

    public static void time(int n) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setTime(n);
        }
    }

    public static int time() {
        IG iG = IG.cur();
        return iG == null ? -1 : iG.getTime();
    }

    public static void pause() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.pauseDynamics();
        }
    }

    public static void resume() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.resumeDynamics();
        }
    }

    public static void start() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.startDynamics();
        }
    }

    public static void stop() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.stopDynamics();
        }
    }

    public static void updateRate(double d) {
        IConfig.updateRate = d;
    }

    public static void updateSpeed(double d) {
        IG.updateRate(d);
    }

    public static void rate(double d) {
        IG.updateRate(d);
    }

    public static void speed(double d) {
        IG.updateRate(d);
    }

    public static double updateRate() {
        return IConfig.updateRate;
    }

    public static double updateSpeed() {
        return IG.updateRate();
    }

    public static double rate() {
        return IG.updateRate();
    }

    public static double speed() {
        return IG.updateRate();
    }

    public static void outputFile(String string) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setOutputFile(string);
        }
    }

    public static String outputFile() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getOutputFile();
    }

    public static void inputFile(String string) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setInputFile(string);
        }
    }

    public static String inputFile() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getInputFile();
    }

    public static IPoint[] points() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getPoints();
    }

    public static IPoint[] pts() {
        return IG.points();
    }

    public static ICurve[] curves() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getCurves();
    }

    public static ICurve[] crvs() {
        return IG.curves();
    }

    public static ISurface[] surfaces() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getSurfaces();
    }

    public static ISurface[] srfs() {
        return IG.surfaces();
    }

    public static IMesh[] meshes() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getMeshes();
    }

    public static IBrep[] breps() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getBreps();
    }

    public static IObject[] objects(Class clazz) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObjects(clazz);
    }

    public static IObject[] objs(Class clazz) {
        return IG.objects();
    }

    public static IObject[] objects() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObjects();
    }

    public static IObject[] objs() {
        return IG.objects();
    }

    public static IPoint point(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getPoint(n);
    }

    public static IPoint pt(int n) {
        return IG.point(n);
    }

    public static ICurve curve(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getCurve(n);
    }

    public static ICurve crv(int n) {
        return IG.curve(n);
    }

    public static ISurface surface(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getSurface(n);
    }

    public static ISurface srf(int n) {
        return IG.surface(n);
    }

    public static IMesh mesh(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getMesh(n);
    }

    public static IBrep brep(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getBrep(n);
    }

    public static IObject object(Class clazz, int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObject(clazz, n);
    }

    public static IObject obj(Class clazz, int n) {
        return IG.object(clazz, n);
    }

    public static IObject object(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObject(n);
    }

    public static IObject obj(int n) {
        return IG.object(n);
    }

    public static int pointNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getPointNum();
    }

    public static int ptNum() {
        return IG.pointNum();
    }

    public static int curveNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getCurveNum();
    }

    public static int crvNum() {
        return IG.curveNum();
    }

    public static int surfaceNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getSurfaceNum();
    }

    public static int srfNum() {
        return IG.surfaceNum();
    }

    public static int meshNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getMeshNum();
    }

    public static int brepNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getBrepNum();
    }

    public static int objectNum(Class clazz) {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getObjectNum(clazz);
    }

    public static int objNum(Class clazz) {
        return IG.objectNum(clazz);
    }

    public static int objectNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getObjectNum();
    }

    public static int objNum() {
        return IG.objectNum();
    }

    public static ILayer layer(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getLayer(string);
    }

    public static ILayer[] layers() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getAllLayers();
    }

    public static void delLayer(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.removeLayer(string);
    }

    public static void focus() {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.focusView();
    }

    public static boolean isGL() {
        IG iG = IG.cur();
        if (iG == null) {
            IOut.err("no IG found");
            return true;
        }
        if (iG.server().graphicServer() == null) {
            IOut.err("no graphic server found");
            return true;
        }
        return iG.server().graphicServer().isGL();
    }

    public static void graphicMode(IGraphicMode iGraphicMode) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.server().setGraphicMode(iGraphicMode);
    }

    public static void wireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, false, true, false));
    }

    public static void fill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, false));
    }

    public static void fillWithWireframe() {
        IG.wireframeFill();
    }

    public static void fillWireframe() {
        IG.wireframeFill();
    }

    public static void wireframeFill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, false));
    }

    public static void transparentFill() {
        IG.transparent();
    }

    public static void transparent() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, true));
    }

    public static void transparentFillWithWireframe() {
        IG.wireframeTransparent();
    }

    public static void transparentWireframe() {
        IG.wireframeTransparent();
    }

    public static void wireframeTransparent() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.JAVA;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, true));
    }

    public static IView view(int n) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        if (iG == null || iG.panel == null || iG.panel.panes == null || iG.panel.panes.size() <= n || n < 0) {
            return null;
        }
        if (iG.panel instanceof IScreenTogglePanel) {
            ((IScreenTogglePanel)iG.panel).enableFullScreen(iG.panel.panes.get(n));
        }
        return iG.panel.panes.get(n).getView();
    }

    public static IPane gridPane(int n, int n2) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        if (iG.panel != null && iG.panel instanceof IGridPanel) {
            IGridPanel iGridPanel = (IGridPanel)iG.panel;
            if (n >= 0 && n < iGridPanel.gridPanes.length && n2 >= 0 && n2 < iGridPanel.gridPanes[n].length) {
                IPane iPane = iGridPanel.gridPanes[n][n2];
                iGridPanel.enableFullScreen(iPane);
                return iPane;
            }
        }
        return null;
    }

    public static IPane topPane() {
        return IG.gridPane(0, 0);
    }

    public static IPane bottomPane() {
        return IG.topPane();
    }

    public static IPane perspectivePane() {
        return IG.gridPane(1, 0);
    }

    public static IPane axonometricPane() {
        return IG.perspectivePane();
    }

    public static IPane frontPane() {
        return IG.gridPane(0, 1);
    }

    public static IPane backPane() {
        return IG.frontPane();
    }

    public static IPane rightPane() {
        return IG.gridPane(1, 1);
    }

    public static IPane leftPane() {
        return IG.rightPane();
    }

    public static void top() {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop();
        }
    }

    public static void top(double d, double d2) {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop(d, d2);
        }
    }

    public static void top(double d, double d2, double d3) {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop(d, d2, d3);
        }
    }

    public static void top(double d, double d2, double d3, double d4) {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop(d, d2, d3, d4);
        }
    }

    public static void topView() {
        IG.top();
    }

    public static void topView(double d, double d2) {
        IG.top(d, d2);
    }

    public static void topView(double d, double d2, double d3) {
        IG.top(d, d2, d3);
    }

    public static void topView(double d, double d2, double d3, double d4) {
        IG.top(d, d2, d3, d4);
    }

    public static void bottom() {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom();
        }
    }

    public static void bottom(double d, double d2) {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom(d, d2);
        }
    }

    public static void bottom(double d, double d2, double d3) {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom(d, d2, d3);
        }
    }

    public static void bottom(double d, double d2, double d3, double d4) {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom(d, d2, d3, d4);
        }
    }

    public static void bottomView() {
        IG.bottom();
    }

    public static void bottomView(double d, double d2) {
        IG.bottom(d, d2);
    }

    public static void bottomView(double d, double d2, double d3) {
        IG.bottom(d, d2, d3);
    }

    public static void bottomView(double d, double d2, double d3, double d4) {
        IG.bottom(d, d2, d3, d4);
    }

    public static void perspective() {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective();
        }
    }

    public static void perspective(double d, double d2, double d3) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3);
        }
    }

    public static void perspective(double d, double d2, double d3, double d4, double d5) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3, d4, d5);
        }
    }

    public static void perspectiveView() {
        IG.perspective();
    }

    public static void perspectiveView(double d, double d2, double d3) {
        IG.perspective(d, d2, d3);
    }

    public static void perspectiveView(double d, double d2, double d3, double d4, double d5) {
        IG.perspective(d, d2, d3, d4, d5);
    }

    public static void pers() {
        IG.perspective();
    }

    public static void pers(double d, double d2, double d3) {
        IG.perspective(d, d2, d3);
    }

    public static void pers(double d, double d2, double d3, double d4, double d5) {
        IG.perspective(d, d2, d3, d4, d5);
    }

    public static void perspective(double d) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d);
        }
    }

    public static void perspective(double d, double d2, double d3, double d4) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3, d4);
        }
    }

    public static void perspective(double d, double d2, double d3, double d4, double d5, double d6) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3, d4, d5, d6);
        }
    }

    public static void perspectiveView(double d) {
        IG.perspective(d);
    }

    public static void perspectiveView(double d, double d2, double d3, double d4) {
        IG.perspective(d, d2, d3, d4);
    }

    public static void perspectiveView(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.perspective(d, d2, d3, d4, d5, d6);
    }

    public static void pers(double d) {
        IG.perspective(d);
    }

    public static void pers(double d, double d2, double d3, double d4) {
        IG.perspective(d, d2, d3, d4);
    }

    public static void pers(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.perspective(d, d2, d3, d4, d5, d6);
    }

    public static void axonometric() {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric();
        }
    }

    public static void axonometric(double d, double d2, double d3) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3);
        }
    }

    public static void axonometric(double d, double d2, double d3, double d4) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3, d4);
        }
    }

    public static void axonometric(double d, double d2, double d3, double d4, double d5) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3, d4, d5);
        }
    }

    public static void axonometric(double d, double d2, double d3, double d4, double d5, double d6) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3, d4, d5, d6);
        }
    }

    public static void axonometricView() {
        IG.axonometric();
    }

    public static void axonometricView(double d, double d2, double d3) {
        IG.axonometric(d, d2, d3);
    }

    public static void axonometricView(double d, double d2, double d3, double d4) {
        IG.axonometric(d, d2, d3, d4);
    }

    public static void axonometricView(double d, double d2, double d3, double d4, double d5) {
        IG.axonometric(d, d2, d3, d4, d5);
    }

    public static void axonometricView(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.axonometric(d, d2, d3, d4, d5, d6);
    }

    public static void axon() {
        IG.axonometric();
    }

    public static void axon(double d, double d2, double d3) {
        IG.axonometric(d, d2, d3);
    }

    public static void axon(double d, double d2, double d3, double d4) {
        IG.axonometric(d, d2, d3, d4);
    }

    public static void axon(double d, double d2, double d3, double d4, double d5) {
        IG.axonometric(d, d2, d3, d4, d5);
    }

    public static void axon(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.axonometric(d, d2, d3, d4, d5, d6);
    }

    public static void front() {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront();
        }
    }

    public static void front(double d, double d2) {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront(d, d2);
        }
    }

    public static void front(double d, double d2, double d3) {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront(d, d2, d3);
        }
    }

    public static void front(double d, double d2, double d3, double d4) {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront(d, d2, d3, d4);
        }
    }

    public static void frontView() {
        IG.front();
    }

    public static void frontView(double d, double d2) {
        IG.front(d, d2);
    }

    public static void frontView(double d, double d2, double d3) {
        IG.front(d, d2, d3);
    }

    public static void frontView(double d, double d2, double d3, double d4) {
        IG.front(d, d2, d3, d4);
    }

    public static void back() {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack();
        }
    }

    public static void back(double d, double d2) {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack(d, d2);
        }
    }

    public static void back(double d, double d2, double d3) {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack(d, d2, d3);
        }
    }

    public static void back(double d, double d2, double d3, double d4) {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack(d, d2, d3, d4);
        }
    }

    public static void backView() {
        IG.back();
    }

    public static void backView(double d, double d2) {
        IG.back(d, d2);
    }

    public static void backView(double d, double d2, double d3) {
        IG.back(d, d2, d3);
    }

    public static void backView(double d, double d2, double d3, double d4) {
        IG.back(d, d2, d3, d4);
    }

    public static void right() {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight();
        }
    }

    public static void right(double d, double d2) {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight(d, d2);
        }
    }

    public static void right(double d, double d2, double d3) {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight(d, d2, d3);
        }
    }

    public static void right(double d, double d2, double d3, double d4) {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight(d, d2, d3, d4);
        }
    }

    public static void rightView() {
        IG.right();
    }

    public static void rightView(double d, double d2) {
        IG.right(d, d2);
    }

    public static void rightView(double d, double d2, double d3) {
        IG.right(d, d2, d3);
    }

    public static void rightView(double d, double d2, double d3, double d4) {
        IG.right(d, d2, d3, d4);
    }

    public static void left() {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft();
        }
    }

    public static void left(double d, double d2) {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft(d, d2);
        }
    }

    public static void left(double d, double d2, double d3) {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft(d, d2, d3);
        }
    }

    public static void left(double d, double d2, double d3, double d4) {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft(d, d2, d3, d4);
        }
    }

    public static void leftView() {
        IG.left();
    }

    public static void leftView(double d, double d2) {
        IG.left(d, d2);
    }

    public static void leftView(double d, double d2, double d3) {
        IG.left(d, d2, d3);
    }

    public static void leftView(double d, double d2, double d3, double d4) {
        IG.left(d, d2, d3, d4);
    }

    public static void bg(Color color, Color color2, Color color3, Color color4) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.server().bg(color, color2, color3, color4);
    }

    public static void background(Color color, Color color2, Color color3, Color color4) {
        IG.bg(color, color2, color3, color4);
    }

    public static void bg(Color color) {
        IG.bg(color, color, color, color);
    }

    public static void background(Color color) {
        IG.bg(color);
    }

    public static void bg(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        IG.bg(IGraphicObject.getColor(n, n2, n3), IGraphicObject.getColor(n4, n5, n6), IGraphicObject.getColor(n7, n8, n9), IGraphicObject.getColor(n10, n11, n12));
    }

    public static void background(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        IG.bg(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n12, n11);
    }

    public static void bg(int n, int n2, int n3) {
        IG.bg(IGraphicObject.getColor(n, n2, n3));
    }

    public static void background(int n, int n2, int n3) {
        IG.bg(n, n2, n3);
    }

    public static void bg(int n, int n2, int n3, int n4) {
        IG.bg(IGraphicObject.getColor(n), IGraphicObject.getColor(n2), IGraphicObject.getColor(n3), IGraphicObject.getColor(n4));
    }

    public static void background(int n, int n2, int n3, int n4) {
        IG.bg(n, n2, n3, n4);
    }

    public static void bg(int n) {
        IG.bg(IGraphicObject.getColor(n));
    }

    public static void background(int n) {
        IG.bg(n);
    }

    public static void bg(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        IG.bg(IGraphicObject.getColor(f, f2, f3), IGraphicObject.getColor(f4, f5, f6), IGraphicObject.getColor(f7, f8, f9), IGraphicObject.getColor(f10, f11, f12));
    }

    public static void background(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        IG.bg(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f12, f11);
    }

    public static void bg(float f, float f2, float f3) {
        IG.bg(IGraphicObject.getColor(f, f2, f3));
    }

    public static void background(float f, float f2, float f3) {
        IG.bg(f, f2, f3);
    }

    public static void bg(float f, float f2, float f3, float f4) {
        IG.bg(IGraphicObject.getColor(f), IGraphicObject.getColor(f2), IGraphicObject.getColor(f3), IGraphicObject.getColor(f4));
    }

    public static void background(float f, float f2, float f3, float f4) {
        IG.bg(f, f2, f3, f4);
    }

    public static void bg(float f) {
        IG.bg(IGraphicObject.getColor(f));
    }

    public static void background(float f) {
        IG.bg(f);
    }

    public static void bg(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        IG.bg(IGraphicObject.getColor((float)d, (float)d2, (float)d3), IGraphicObject.getColor((float)d4, (float)d5, (float)d6), IGraphicObject.getColor((float)d7, (float)d8, (float)d9), IGraphicObject.getColor((float)d10, (float)d11, (float)d12));
    }

    public static void background(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        IG.bg(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d12, d11);
    }

    public static void bg(double d, double d2, double d3) {
        IG.bg(IGraphicObject.getColor((float)d, (float)d2, (float)d3));
    }

    public static void background(double d, double d2, double d3) {
        IG.bg(d, d2, d3);
    }

    public static void bg(double d, double d2, double d3, double d4) {
        IG.bg(IGraphicObject.getColor((float)d), IGraphicObject.getColor((float)d2), IGraphicObject.getColor((float)d3), IGraphicObject.getColor((float)d4));
    }

    public static void background(double d, double d2, double d3, double d4) {
        IG.bg(d, d2, d3, d4);
    }

    public static void bg(double d) {
        IG.bg(IGraphicObject.getColor((float)d));
    }

    public static void background(double d) {
        IG.bg(d);
    }

    public static void p(Object object) {
        IOut.printlnWithOffset(object, 1);
    }

    public static void p() {
        IOut.printlnWithOffset(1);
    }

    public static void enabePrintPrefix() {
        IOut.enablePrefix();
    }

    public static void disablePrintPrefix() {
        IOut.disablePrefix();
    }

    public static void err(Object object) {
        IOut.errWithOffset(object, 1);
    }

    public static void err() {
        IOut.errWithOffset(1);
    }

    public static void enabeErrorPrefix() {
        IOut.enablePrefix();
    }

    public static void disableErrorPrefix() {
        IOut.disablePrefix();
    }

    protected IG() {
        this.server = new IServer(this);
    }

    protected IG(IPanel iPanel) {
        this.server = new IServer(this, iPanel);
        this.panel = iPanel;
        iPanel.setIG(this);
    }

    public boolean openFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
        }
        boolean bl = IIO.open(string, (IServerI)this);
        this.server.updateState();
        this.inputFile = string;
        this.focusView();
        return bl;
    }

    public boolean saveFile(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
            File file2 = new File(this.basePath);
            if (!file2.isDirectory()) {
                IOut.debug(20, "creating directory" + file2.toString());
                if (!file2.mkdir()) {
                    IOut.err("failed to create directory: " + file2.toString());
                }
            }
        }
        return IIO.save(string, (IServerI)this);
    }

    public boolean save() {
        if (this.outputFile == null) {
            IOut.err("output filename is not set. not saved");
            return false;
        }
        return this.saveFile(this.outputFile);
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String setBasePath(String string) {
        this.basePath = string;
        return this.basePath;
    }

    public ILayer getLayer(String string) {
        return this.server.getLayer(string);
    }

    public ILayer[] getAllLayers() {
        return this.server.getAllLayers();
    }

    public void removeLayer(String string) {
        this.server.removeLayer(string);
    }

    public IPoint[] getPoints() {
        return this.server.points();
    }

    public ICurve[] getCurves() {
        return this.server.curves();
    }

    public ISurface[] getSurfaces() {
        return this.server.surfaces();
    }

    public IMesh[] getMeshes() {
        return this.server.meshes();
    }

    public IBrep[] getBreps() {
        return this.server.breps();
    }

    public IObject[] getObjects(Class clazz) {
        return this.server.objects(clazz);
    }

    public IObject[] getObjects() {
        return this.server.objects();
    }

    public IPoint getPoint(int n) {
        return this.server.point(n);
    }

    public ICurve getCurve(int n) {
        return this.server.curve(n);
    }

    public ISurface getSurface(int n) {
        return this.server.surface(n);
    }

    public IMesh getMesh(int n) {
        return this.server.mesh(n);
    }

    public IBrep getBrep(int n) {
        return this.server.brep(n);
    }

    public IObject getObject(Class clazz, int n) {
        return this.server.object(clazz, n);
    }

    public IObject getObject(int n) {
        return this.server.object(n);
    }

    public int getPointNum() {
        return this.server.pointNum();
    }

    public int getCurveNum() {
        return this.server.curveNum();
    }

    public int getSurfaceNum() {
        return this.server.surfaceNum();
    }

    public int getMeshNum() {
        return this.server.meshNum();
    }

    public int getBrepNum() {
        return this.server.brepNum();
    }

    public int getObjectNum(Class clazz) {
        return this.server.objectNum(clazz);
    }

    public int getObjectNum() {
        return this.server.objectNum();
    }

    public void focusView() {
        if (this.panel != null) {
            this.panel.focus();
        }
    }

    @Override
    public IServer server() {
        return this.server;
    }

    public IDynamicServer dynamicServer() {
        return this.server.dynamicServer();
    }

    public void setDuration(int n) {
        this.server.duration(n);
    }

    public int getDuration() {
        return this.server.duration();
    }

    public void setTime(int n) {
        this.server.time(n);
    }

    public int getTime() {
        return this.server.time();
    }

    public void pauseDynamics() {
        this.server.pause();
    }

    public void resumeDynamics() {
        this.server.resume();
    }

    public void startDynamics() {
        this.server.start();
    }

    public void stopDynamics() {
        this.server.stop();
    }

    public void clear() {
        this.server.clear();
    }

    public static IPoint point(IVecI iVecI) {
        return IG.pt(iVecI);
    }

    public static IPoint point(IVec iVec) {
        return IG.pt(iVec);
    }

    public static IPoint point(double d, double d2, double d3) {
        return IG.pt(d, d2, d3);
    }

    public static IPoint point(double d, double d2) {
        return IG.pt(d, d2);
    }

    public static IPoint pt(IVecI iVecI) {
        return new IPoint(iVecI);
    }

    public static IPoint pt(IVec iVec) {
        return new IPoint(iVec);
    }

    public static IPoint pt(double d, double d2, double d3) {
        return new IPoint(d, d2, d3);
    }

    public static IPoint pt(double d, double d2) {
        return new IPoint(d, d2);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ICurveCreator.curve(iVecIArray, n, dArray, d, d2);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, double[] dArray) {
        return ICurveCreator.curve(iVecIArray, n, dArray);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n) {
        return ICurveCreator.curve(iVecIArray, n);
    }

    public static ICurve curve(IVecI[] iVecIArray) {
        return ICurveCreator.curve(iVecIArray);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, boolean bl) {
        return ICurveCreator.curve(iVecIArray, n, bl);
    }

    public static ICurve curve(IVecI[] iVecIArray, boolean bl) {
        return ICurveCreator.curve(iVecIArray, bl);
    }

    public static ICurve curve(IVecI iVecI, IVecI iVecI2) {
        return ICurveCreator.curve(iVecI, iVecI2);
    }

    public static ICurve curve(double d, double d2, double d3, double d4, double d5, double d6) {
        return ICurveCreator.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve curve(double[][] dArray) {
        return ICurveCreator.curve(dArray);
    }

    public static ICurve curve(double[][] dArray, int n) {
        return ICurveCreator.curve(dArray, n);
    }

    public static ICurve curve(double[][] dArray, boolean bl) {
        return ICurveCreator.curve(dArray, bl);
    }

    public static ICurve curve(double[][] dArray, int n, boolean bl) {
        return ICurveCreator.curve(dArray, n, bl);
    }

    public static ICurve curve(ICurveI iCurveI) {
        return ICurveCreator.curve(iCurveI);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return IG.curve(iVecIArray, n, dArray, d, d2);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, double[] dArray) {
        return IG.curve(iVecIArray, n, dArray);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n) {
        return IG.curve(iVecIArray, n);
    }

    public static ICurve crv(IVecI[] iVecIArray) {
        return IG.curve(iVecIArray);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, boolean bl) {
        return IG.curve(iVecIArray, n, bl);
    }

    public static ICurve crv(IVecI[] iVecIArray, boolean bl) {
        return IG.curve(iVecIArray, bl);
    }

    public static ICurve crv(IVecI iVecI, IVecI iVecI2) {
        return IG.curve(iVecI, iVecI2);
    }

    public static ICurve crv(double d, double d2, double d3, double d4, double d5, double d6) {
        return IG.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve crv(double[][] dArray) {
        return IG.curve(dArray);
    }

    public static ICurve crv(double[][] dArray, int n) {
        return IG.curve(dArray, n);
    }

    public static ICurve crv(double[][] dArray, boolean bl) {
        return IG.curve(dArray, bl);
    }

    public static ICurve crv(double[][] dArray, int n, boolean bl) {
        return IG.curve(dArray, n, bl);
    }

    public static ICurve crv(ICurveI iCurveI) {
        return IG.curve(iCurveI);
    }

    public static ICurve line(IVecI iVecI, IVecI iVecI2) {
        return IG.curve(iVecI, iVecI2);
    }

    public static ICurve line(double d, double d2, double d3, double d4, double d5, double d6) {
        return IG.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve rect(IVecI iVecI, double d, double d2) {
        return ICurveCreator.rect(iVecI, d, d2);
    }

    public static ICurve rect(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.rect(iVecI, iVecI2, iVecI3);
    }

    public static ICurve rect(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.rect(d, d2, d3, d4, d5);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d) {
        return ICurveCreator.circle(iVecI, iVecI2, d);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, double d) {
        return ICurveCreator.circle(iVecI, d);
    }

    public static ICircle circle(double d, double d2, double d3, double d4) {
        return ICurveCreator.circle(d, d2, d3, d4);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ICurveCreator.circle(iVecI, iVecI2, d, d2);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, double d, double d2) {
        return ICurveCreator.circle(iVecI, d, d2);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.circle(d, d2, d3, d4, d5);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, d2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, d, bl);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, d, bl);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, boolean bl) {
        return ICurveCreator.circle(d, d2, d3, d4, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(IVecI iVecI, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, double d5, boolean bl) {
        return ICurveCreator.circle(d, d2, d3, d4, d5, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, bl);
    }

    public static ICircle ellipse(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.ellipse(iVecI, iVecI2, iVecI3);
    }

    public static ICircle ellipse(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.ellipse(iVecI, iDoubleI, iDoubleI2);
    }

    public static ICircle ellipse(IVecI iVecI, double d, double d2) {
        return ICurveCreator.ellipse(iVecI, d, d2);
    }

    public static ICircle ellipse(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.ellipse(d, d2, d3, d4, d5);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, d);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, double d) {
        return ICurveCreator.arc(iVecI, iVecI2, d);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ICurveCreator.arc(iVecI, iVecI2, iDoubleI);
    }

    public static IArc arc(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return ICurveCreator.arc(d, d2, d3, d4, d5, d6, d7);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iBoolI);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, bl);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iVecI4, iVecI5);
    }

    public static ICurve offset(ICurveI iCurveI, double d, IVecI iVecI) {
        return ICurveCreator.offset(iCurveI, d, iVecI);
    }

    public static ICurve offset(ICurveI iCurveI, IDoubleI iDoubleI, IVecI iVecI) {
        return ICurveCreator.offset(iCurveI, iDoubleI, iVecI);
    }

    public static ICurve offset(ICurveI iCurveI, double d) {
        return ICurveCreator.offset(iCurveI, d);
    }

    public static ICurve offset(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ICurveCreator.offset(iCurveI, iDoubleI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI) {
        return IVec.offset(iVecArray, d, iVecI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecArray, d, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecIArray, d, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI) {
        return IVec.offset(iVecIArray, d, iVecI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI) {
        return IVec.offset(iVecIArray, iDoubleI, iVecI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IVecI[] iVecIArray2, double d) {
        return IVec.offset(iVecIArray, iVecIArray2, d);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IVecI[] iVecIArray2, IDoubleI iDoubleI) {
        return IVec.offset(iVecIArray, iVecIArray2, iDoubleI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d) {
        return IVec.offset(iVecArray, d);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, boolean bl) {
        return IVec.offset(iVecArray, d, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, boolean bl) {
        return IVec.offset(iVecIArray, d, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d) {
        return IVec.offset(iVecIArray, d);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return IVec.offset(iVecIArray, iDoubleI);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2);
    }

    public static ISurface surface(IVecI[][] iVecIArray) {
        return ISurfaceCreator.surface(iVecIArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface surface(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(iVecIArray, bl, bl2);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.surface(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ISurfaceCreator.surface(iVecI, iVecI2, iVecI3);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return ISurfaceCreator.surface(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return ISurfaceCreator.surface(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface surface(double[][][] dArray) {
        return ISurfaceCreator.surface(dArray);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2) {
        return ISurfaceCreator.surface(dArray, n, n2);
    }

    public static ISurface surface(double[][][] dArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(dArray, bl, bl2);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(dArray, n, n2, bl, bl2);
    }

    public static ISurface surface(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.surface(iSurfaceI);
    }

    public static ISurface surface(ICurveI iCurveI) {
        return ISurfaceCreator.surface(iCurveI);
    }

    public static ISurface surface(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.surface(iCurveIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray) {
        return ISurfaceCreator.surface(iVecIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.surface(iVecIArray, n);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.surface(iVecIArray, n, dArray);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return IG.surface(iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return IG.surface(iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2) {
        return IG.surface(iVecIArray, n, n2);
    }

    public static ISurface srf(IVecI[][] iVecIArray) {
        return IG.surface(iVecIArray);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return IG.surface(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return IG.surface(iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return IG.surface(iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface srf(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return IG.surface(iVecIArray, bl, bl2);
    }

    public static ISurface srf(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IG.surface(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface srf(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return IG.surface(iVecI, iVecI2, iVecI3);
    }

    public static ISurface srf(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return IG.surface(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface srf(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return IG.surface(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface srf(double[][][] dArray) {
        return IG.surface(dArray);
    }

    public static ISurface srf(double[][][] dArray, int n, int n2) {
        return IG.surface(dArray, n, n2);
    }

    public static ISurface srf(double[][][] dArray, boolean bl, boolean bl2) {
        return IG.surface(dArray, bl, bl2);
    }

    public static ISurface srf(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return IG.surface(dArray, n, n2, bl, bl2);
    }

    public static ISurface srf(ISurfaceI iSurfaceI) {
        return IG.surface(iSurfaceI);
    }

    public static ISurface srf(ICurveI iCurveI) {
        return IG.surface(iCurveI);
    }

    public static ISurface srf(ICurveI[] iCurveIArray) {
        return IG.surface(iCurveIArray);
    }

    public static ISurface srf(IVecI[] iVecIArray) {
        return IG.surface(iVecIArray);
    }

    public static ISurface srf(IVecI[] iVecIArray, int n) {
        return IG.surface(iVecIArray, n);
    }

    public static ISurface srf(IVecI[] iVecIArray, int n, double[] dArray) {
        return IG.surface(iVecIArray, n, dArray);
    }

    public static IBox box(double d, double d2, double d3, double d4) {
        return ISurfaceCreator.box(d, d2, d3, d4);
    }

    public static IBox box(double d, double d2, double d3, double d4, double d5, double d6) {
        return ISurfaceCreator.box(d, d2, d3, d4, d5, d6);
    }

    public static IBox box(IVecI iVecI, double d) {
        return ISurfaceCreator.box(iVecI, d);
    }

    public static IBox box(IVecI iVecI, double d, double d2, double d3) {
        return ISurfaceCreator.box(iVecI, d, d2, d3);
    }

    public static IBox box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.box(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IBox box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        return ISurfaceCreator.box(iVecI, iVecI2, iVecI3, iVecI4, iVecI5, iVecI6, iVecI7, iVecI8);
    }

    public static IBox box(IVecI[][][] iVecIArray) {
        return ISurfaceCreator.box(iVecIArray);
    }

    public static ISphere sphere(double d, double d2, double d3, double d4) {
        return ISurfaceCreator.sphere(d, d2, d3, d4);
    }

    public static ISphere sphere(IVecI iVecI, double d) {
        return ISurfaceCreator.sphere(iVecI, d);
    }

    public static ISphere sphere(IVecI iVecI, IDoubleI iDoubleI) {
        return ISurfaceCreator.sphere(iVecI, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, d);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, d, d2);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.cone(iVecI, iVecI2, d);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ISurfaceCreator.cone(iVecI, iVecI2, iDoubleI);
    }

    public static ISurface plane(IVecI iVecI, double d, double d2) {
        return ISurfaceCreator.plane(iVecI, d, d2);
    }

    public static ISurface plane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ISurfaceCreator.plane(iVecI, iVecI2, iVecI3);
    }

    public static ISurface extrude(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.extrude(iVecIArray, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iCurve);
    }

    public static ISurface extrude(ICurveI iCurveI, IVecI iVecI) {
        return ISurfaceCreator.extrude(iCurveI, iVecI);
    }

    public static ISurface extrude(ICurveI iCurveI, double d) {
        return ISurfaceCreator.extrude(iCurveI, d);
    }

    public static ISurface extrude(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iCurveI, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.extrude(iVecIArray, iVecIArray2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.extrude(iVecIArray, n, iVecIArray2, n2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iVecIArray2, n2, bl2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iVecIArray2, n2, dArray2);
    }

    public static ISurface extrude(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.extrude(iCurveI, iCurveI2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecI2, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecI2, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecI2, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iCurveI2);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iCurveI2);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iCurveI2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, iVecI2, iVecIArray2, n2, dArray2);
    }

    public static ISurface pipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.pipe(iVecI, iVecI2, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, bl, d);
    }

    public static ISurface pipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.pipe(iCurveI, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, dArray, d);
    }

    public static ISurface squarePipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.squarePipe(iVecI, iVecI2, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, bl, d);
    }

    public static ISurface squarePipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.squarePipe(iCurveI, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, dArray, d);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, d, d2);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d2, d3, d4);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d2);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d2, d3, d4);
    }

    public static ISurface loft(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loft(iCurveIArray);
    }

    public static ISurface loft(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.loft(iCurveI, iCurveI2);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loft(iCurveIArray, n);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loft(iCurveIArray, n, bl);
    }

    public static ISurface loft(IVecI[][] iVecIArray) {
        return ISurfaceCreator.loft(iVecIArray);
    }

    public static ISurface loft(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.loft(iVecIArray, bl, bl2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.loft(iVecIArray, n, n2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.loft(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, n);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, n, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, n, n2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, n, n2, bl);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftX(iCurveIArray);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftX(iCurveIArray, n);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftX(iCurveIArray, n, bl);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftY(iCurveIArray);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftY(iCurveIArray, n);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftY(iCurveIArray, n, bl);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftZ(iCurveIArray);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftZ(iCurveIArray, n);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftZ(iCurveIArray, n, bl);
    }

    public static ICurve flatten(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2) {
        return ICurveCreator.flatten(iCurveI, iVecI, iVecI2);
    }

    public static ICurve flatten(ICurveI iCurveI, IVecI iVecI) {
        return ICurveCreator.flatten(iCurveI, iVecI);
    }

    public static ICurve flatten(ICurveI iCurveI) {
        return ICurveCreator.flatten(iCurveI);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI, IVecI iVecI2) {
        return ISurfaceCreator.flatten(iSurfaceI, iVecI, iVecI2);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI) {
        return ISurfaceCreator.flatten(iSurfaceI, iVecI);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.flatten(iSurfaceI);
    }

    public static IVec vec(double d, double d2, double d3) {
        return IG.v(d, d2, d3);
    }

    public static IVec vec(double d, double d2) {
        return IG.v(d, d2);
    }

    public static IVec vec(IVec iVec) {
        return IG.v(iVec);
    }

    public static IVec vec(IVecI iVecI) {
        return IG.v(iVecI);
    }

    public static IVec vec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public static IVec vec(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v(iDoubleI, iDoubleI2);
    }

    public static IVec vec(IVec2I iVec2I) {
        return IG.v(iVec2I);
    }

    public static IVec v(double d, double d2, double d3) {
        return new IVec(d, d2, d3);
    }

    public static IVec v(double d, double d2) {
        return new IVec(d, d2);
    }

    public static IVec v(IVec iVec) {
        return new IVec(iVec);
    }

    public static IVec v(IVecI iVecI) {
        return new IVec(iVecI);
    }

    public static IVec v(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return new IVec(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public static IVec v(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec(iDoubleI, iDoubleI2, new IDouble(0.0));
    }

    public static IVec v(IVec2I iVec2I) {
        return new IVec(iVec2I);
    }

    public static IVec vector(double d, double d2, double d3) {
        return IG.v(d, d2, d3);
    }

    public static IVec vector(double d, double d2) {
        return IG.v(d, d2);
    }

    public static IVec vector(IVec iVec) {
        return IG.v(iVec);
    }

    public static IVec vector(IVecI iVecI) {
        return IG.v(iVecI);
    }

    public static IVec vector(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public static IVec vector(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v(iDoubleI, iDoubleI2);
    }

    public static IVec vector(IVec2I iVec2I) {
        return IG.v(iVec2I);
    }

    public static IVec4 vec4(double d, double d2, double d3, double d4) {
        return IG.v4(d, d2, d3, d4);
    }

    public static IVec4 vec4(IVec iVec, double d) {
        return IG.v4(iVec, d);
    }

    public static IVec4 vec4(IVec4 iVec4) {
        return IG.v4(iVec4);
    }

    public static IVec4 vec4(IVecI iVecI) {
        return IG.v4(iVecI);
    }

    public static IVec4 vec4(IVecI iVecI, double d) {
        return IG.v4(iVecI, d);
    }

    public static IVec4 vec4(IVecI iVecI, IDoubleI iDoubleI) {
        return IG.v4(iVecI, iDoubleI);
    }

    public static IVec4 vec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public static IVec4 v4(double d, double d2, double d3, double d4) {
        return new IVec4(d, d2, d3, d4);
    }

    public static IVec4 v4(IVec iVec, double d) {
        return new IVec4(iVec, d);
    }

    public static IVec4 v4(IVec4 iVec4) {
        return new IVec4(iVec4);
    }

    public static IVec4 v4(IVecI iVecI) {
        return new IVec4(iVecI);
    }

    public static IVec4 v4(IVecI iVecI, double d) {
        return new IVec4(iVecI, d);
    }

    public static IVec4 v4(IVecI iVecI, IDoubleI iDoubleI) {
        return new IVec4(iVecI, iDoubleI);
    }

    public static IVec4 v4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return new IVec4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public static IVec4 vector4(double d, double d2, double d3, double d4) {
        return IG.v4(d, d2, d3, d4);
    }

    public static IVec4 vector4(IVec iVec, double d) {
        return IG.v4(iVec, d);
    }

    public static IVec4 vector4(IVec4 iVec4) {
        return IG.v4(iVec4);
    }

    public static IVec4 vector4(IVecI iVecI) {
        return IG.v4(iVecI);
    }

    public static IVec4 vector4(IVecI iVecI, double d) {
        return IG.v4(iVecI, d);
    }

    public static IVec4 vector4(IVecI iVecI, IDoubleI iDoubleI) {
        return IG.v4(iVecI, iDoubleI);
    }

    public static IVec4 vector4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public static IVec2 vec2(double d, double d2) {
        return IG.v2(d, d2);
    }

    public static IVec2 vec2(IVec2 iVec2) {
        return IG.v2(iVec2);
    }

    public static IVec2 vec2(IVecI iVecI) {
        return IG.v2(iVecI);
    }

    public static IVec2 vec2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v2(iDoubleI, iDoubleI2);
    }

    public static IVec2 v2(double d, double d2) {
        return new IVec2(d, d2);
    }

    public static IVec2 v2(IVec2 iVec2) {
        return new IVec2(iVec2);
    }

    public static IVec2 v2(IVecI iVecI) {
        return new IVec2(iVecI);
    }

    public static IVec2 v2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec2(iDoubleI, iDoubleI2);
    }

    public static IVec2 vector2(double d, double d2) {
        return IG.v2(d, d2);
    }

    public static IVec2 vector2(IVec2 iVec2) {
        return IG.v2(iVec2);
    }

    public static IVec2 vector2(IVecI iVecI) {
        return IG.v2(iVecI);
    }

    public static IVec2 vector2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v2(iDoubleI, iDoubleI2);
    }

    public static IVec[] vec(double d, double d2, double d3, double ... dArray) {
        return IG.v(d, d2, d3, dArray);
    }

    public static IVec[] vec(IVec ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[] vec(IVecI ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[] vec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI ... iDoubleIArray) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3, iDoubleIArray);
    }

    public static IVec[] vec(IVec2I ... iVec2IArray) {
        return IG.v(iVec2IArray);
    }

    public static IVec[][] vec(IVec[] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][] vec(IVecI[] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[][][] vec(IVec[][] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][][] vec(IVecI[][] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[] v(double d, double d2, double d3, double ... dArray) {
        int n = dArray.length / 3 + 1;
        if (dArray.length % 3 > 0) {
            ++n;
        }
        IVec[] iVecArray = new IVec[n];
        iVecArray[0] = new IVec(d, d2, d3);
        for (int i = 1; i < n; ++i) {
            iVecArray[i] = new IVec(dArray[(i - 1) * 3], (i - 1) * 3 + 1 < dArray.length ? dArray[(i - 1) * 3 + 1] : 0.0, (i - 1) * 3 + 2 < dArray.length ? dArray[(i - 1) * 3 + 2] : 0.0);
        }
        return iVecArray;
    }

    public static IVec[] v(IVec ... iVecArray) {
        return iVecArray;
    }

    public static IVecI[] v(IVecI ... iVecIArray) {
        return iVecIArray;
    }

    public static IVec[] v(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI ... iDoubleIArray) {
        int n = iDoubleIArray.length / 3 + 1;
        if (iDoubleIArray.length % 3 > 0) {
            ++n;
        }
        IVec[] iVecArray = new IVec[n];
        iVecArray[0] = new IVec(iDoubleI, iDoubleI2, iDoubleI3);
        for (int i = 1; i < n; ++i) {
            iVecArray[i] = new IVec(iDoubleIArray[(i - 1) * 3], (i - 1) * 3 + 1 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 3 + 1] : new IDouble(0.0), (i - 1) * 3 + 2 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 3 + 2] : new IDouble(0.0));
        }
        return iVecArray;
    }

    public static IVec[] v(IVec2I ... iVec2IArray) {
        if (iVec2IArray == null) {
            return null;
        }
        IVec[] iVecArray = new IVec[iVec2IArray.length];
        for (int i = 0; i < iVec2IArray.length; ++i) {
            iVecArray[i] = new IVec(iVec2IArray[i]);
        }
        return iVecArray;
    }

    public static IVec[][] v(IVec[] ... iVecArray) {
        return iVecArray;
    }

    public static IVecI[][] v(IVecI[] ... iVecIArray) {
        return iVecIArray;
    }

    public static IVec[][][] v(IVec[][] ... iVecArray) {
        return iVecArray;
    }

    public static IVecI[][][] v(IVecI[][] ... iVecIArray) {
        return iVecIArray;
    }

    public static IVec[] vector(double d, double d2, double d3, double ... dArray) {
        return IG.v(d, d2, d3, dArray);
    }

    public static IVec[] vector(IVec ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[] vector(IVecI ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[] vector(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI ... iDoubleIArray) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3, iDoubleIArray);
    }

    public static IVec[] vector(IVec2I ... iVec2IArray) {
        return IG.v(iVec2IArray);
    }

    public static IVec[][] vector(IVec[] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][] vector(IVecI[] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[][][] vector(IVec[][] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][][] vector(IVecI[][] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec4[] vec4(double d, double d2, double d3, double d4, double ... dArray) {
        return IG.v4(d, d2, d3, d4, dArray);
    }

    public static IVec4[] vec4(IVec4 ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[] vec4(IVec4I ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[] vec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI ... iDoubleIArray) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleIArray);
    }

    public static IVec4[][] vec4(IVec4[] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][] vec4(IVec4I[] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[][][] vec4(IVec4[][] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][][] vec4(IVec4I[][] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[] v4(double d, double d2, double d3, double d4, double ... dArray) {
        int n = dArray.length / 4 + 1;
        if (dArray.length % 4 > 0) {
            ++n;
        }
        IVec4[] iVec4Array = new IVec4[n];
        iVec4Array[0] = new IVec4(d, d2, d3, d4);
        for (int i = 1; i < n; ++i) {
            iVec4Array[i] = new IVec4(dArray[(i - 1) * 4], (i - 1) * 4 + 1 < dArray.length ? dArray[(i - 1) * 4 + 1] : 0.0, (i - 1) * 4 + 2 < dArray.length ? dArray[(i - 1) * 4 + 2] : 0.0, (i - 1) * 4 + 3 < dArray.length ? dArray[(i - 1) * 4 + 3] : 0.0);
        }
        return iVec4Array;
    }

    public static IVec4[] v4(IVec4 ... iVec4Array) {
        return iVec4Array;
    }

    public static IVec4I[] v4(IVec4I ... iVec4IArray) {
        return iVec4IArray;
    }

    public static IVec4[] v4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI ... iDoubleIArray) {
        int n = iDoubleIArray.length / 4 + 1;
        if (iDoubleIArray.length % 4 > 0) {
            ++n;
        }
        IVec4[] iVec4Array = new IVec4[n];
        iVec4Array[0] = new IVec4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
        for (int i = 1; i < n; ++i) {
            iVec4Array[i] = new IVec4(iDoubleIArray[(i - 1) * 4], (i - 1) * 4 + 1 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 4 + 1] : new IDouble(0.0), (i - 1) * 4 + 2 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 4 + 2] : new IDouble(0.0), (i - 1) * 4 + 3 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 4 + 3] : new IDouble(0.0));
        }
        return iVec4Array;
    }

    public static IVec4[][] v4(IVec4[] ... iVec4Array) {
        return iVec4Array;
    }

    public static IVec4I[][] v4(IVec4I[] ... iVec4IArray) {
        return iVec4IArray;
    }

    public static IVec4[][][] v4(IVec4[][] ... iVec4Array) {
        return iVec4Array;
    }

    public static IVec4I[][][] v4(IVec4I[][] ... iVec4IArray) {
        return iVec4IArray;
    }

    public static IVec4[] vector4(double d, double d2, double d3, double d4, double ... dArray) {
        return IG.v4(d, d2, d3, d4, dArray);
    }

    public static IVec4[] vector4(IVec4 ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[] vector4(IVec4I ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[] vector4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI ... iDoubleIArray) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleIArray);
    }

    public static IVec4[][] vector4(IVec4[] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][] vector4(IVec4I[] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[][][] vector4(IVec4[][] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][][] vector4(IVec4I[][] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec2[] vec2(double d, double d2, double ... dArray) {
        return IG.v2(d, d2, dArray);
    }

    public static IVec2[] vec2(IVec2 ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[] vec2(IVec2I ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[] vec2(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI ... iDoubleIArray) {
        return IG.v2(iDoubleI, iDoubleI2, iDoubleIArray);
    }

    public static IVec2[][] vec2(IVec2[] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][] vec2(IVec2I[] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[][][] vec2(IVec2[][] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][][] vec2(IVec2I[][] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[] v2(double d, double d2, double ... dArray) {
        int n = dArray.length / 2 + 1;
        if (dArray.length % 2 > 0) {
            ++n;
        }
        IVec2[] iVec2Array = new IVec2[n];
        iVec2Array[0] = new IVec2(d, d2);
        for (int i = 1; i < n; ++i) {
            iVec2Array[i] = new IVec2(dArray[(i - 1) * 2], (i - 1) * 2 + 1 < dArray.length ? dArray[(i - 1) * 2 + 1] : 0.0);
        }
        return iVec2Array;
    }

    public static IVec2[] v2(IVec2 ... iVec2Array) {
        return iVec2Array;
    }

    public static IVec2I[] v2(IVec2I ... iVec2IArray) {
        return iVec2IArray;
    }

    public static IVec2[] v2(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI ... iDoubleIArray) {
        int n = iDoubleIArray.length / 2 + 1;
        if (iDoubleIArray.length % 2 > 0) {
            ++n;
        }
        IVec2[] iVec2Array = new IVec2[n];
        iVec2Array[0] = new IVec2(iDoubleI, iDoubleI2);
        for (int i = 1; i < n; ++i) {
            iVec2Array[i] = new IVec2(iDoubleIArray[(i - 1) * 2], (i - 1) * 2 + 1 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 2 + 1] : new IDouble(0.0));
        }
        return iVec2Array;
    }

    public static IVec2[][] v2(IVec2[] ... iVec2Array) {
        return iVec2Array;
    }

    public static IVec2I[][] v2(IVec2I[] ... iVec2IArray) {
        return iVec2IArray;
    }

    public static IVec2[][][] v2(IVec2[][] ... iVec2Array) {
        return iVec2Array;
    }

    public static IVec2I[][][] v2(IVec2I[][] ... iVec2IArray) {
        return iVec2IArray;
    }

    public static IVec2[] vector2(double d, double d2, double ... dArray) {
        return IG.v2(d, d2, dArray);
    }

    public static IVec2[] vector2(IVec2 ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[] vector2(IVec2I ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[] vector2(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI ... iDoubleIArray) {
        return IG.v2(iDoubleI, iDoubleI2, iDoubleIArray);
    }

    public static IVec2[][] vector2(IVec2[] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][] vector2(IVec2I[] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[][][] vector2(IVec2[][] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][][] vector2(IVec2I[][] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static <T> T[] array(T ... TArray) {
        return IG.a(TArray);
    }

    public static <T> T[] array(int n, T ... TArray) {
        return IG.a(n, TArray);
    }

    public static <T> T[][] array2(int n, int n2, T ... TArray) {
        return IG.a2(n, n2, TArray);
    }

    public static <T> T[][] array2(int n, T ... TArray) {
        return IG.a2(n, TArray);
    }

    public static <T> T[][][] array3(int n, int n2, int n3, T ... TArray) {
        return IG.a3(n, n2, n3, TArray);
    }

    public static <T> T[][][] array3(int n, int n2, T ... TArray) {
        return IG.a3(n, n2, TArray);
    }

    public static <T> T[] arr(T ... TArray) {
        return IG.a(TArray);
    }

    public static <T> T[] arr(int n, T ... TArray) {
        return IG.a(n, TArray);
    }

    public static <T> T[][] arr2(int n, int n2, T ... TArray) {
        return IG.a2(n, n2, TArray);
    }

    public static <T> T[][] arr2(int n, T ... TArray) {
        return IG.a2(n, TArray);
    }

    public static <T> T[][][] arr3(int n, int n2, int n3, T ... TArray) {
        return IG.a3(n, n2, n3, TArray);
    }

    public static <T> T[][][] arr3(int n, int n2, T ... TArray) {
        return IG.a3(n, n2, TArray);
    }

    public static <T> T[] a(T ... TArray) {
        return TArray;
    }

    public static <T> T[] a(int n, T ... TArray) {
        if (TArray == null) {
            return null;
        }
        if (TArray.length != n) {
            IOut.err("length1*length2 doesn't match with number of values");
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray[0].getClass(), n);
        for (int i = 0; i < n && i < TArray.length; ++i) {
            objectArray[i] = TArray[i];
        }
        return TArray;
    }

    public static <T> T[][] a2(int n, int n2, T ... TArray) {
        int n3;
        if (TArray == null) {
            return null;
        }
        if (TArray.length != n * n2) {
            IOut.err("length1*length2 doesn't match with number of values");
        }
        Object[][] objectArray = (Object[][])Array.newInstance(TArray.getClass(), n);
        for (n3 = 0; n3 < n; ++n3) {
            objectArray[n3] = (Object[])Array.newInstance(TArray[0].getClass(), n2);
        }
        n3 = 0;
        for (int i = 0; i < n && n3 < TArray.length; ++i) {
            for (int j = 0; j < n2 && n3 < TArray.length; ++j) {
                objectArray[i][j] = TArray[n3++];
            }
        }
        return objectArray;
    }

    public static <T> T[][] a2(int n, T ... TArray) {
        if (TArray == null) {
            return null;
        }
        int n2 = TArray.length / n;
        if (TArray.length != n2 * n) {
            IOut.err("length2 doesn't match with number of values");
        }
        if (n2 == 0) {
            n2 = 1;
        }
        return IG.array2(n2, n, TArray);
    }

    public static <T> T[][][] a3(int n, int n2, int n3, T ... TArray) {
        int n4;
        int n5;
        if (TArray == null) {
            return null;
        }
        if (TArray.length != n * n2 * n3) {
            IOut.err("length1*length2*length3 doesn't match with number of values");
        }
        Object[][][] objectArray = (Object[][][])Array.newInstance(((Object[][])Array.newInstance(TArray.getClass(), 0)).getClass(), n);
        for (n5 = 0; n5 < n; ++n5) {
            objectArray[n5] = (Object[][])Array.newInstance(TArray.getClass(), n2);
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                objectArray[n5][n4] = (Object[])Array.newInstance(TArray[0].getClass(), n3);
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < n && n5 < TArray.length; ++n4) {
            for (int i = 0; i < n2 && n5 < TArray.length; ++i) {
                for (int j = 0; j < n3 && n5 < TArray.length; ++j) {
                    objectArray[n4][i][j] = TArray[n5++];
                }
            }
        }
        return objectArray;
    }

    public static <T> T[][][] a3(int n, int n2, T ... TArray) {
        if (TArray == null) {
            return null;
        }
        int n3 = TArray.length / (n * n2);
        if (TArray.length != n3 * n * n2) {
            IOut.err("length2*length3 doesn't match with number of values");
        }
        if (n3 == 0) {
            n3 = 1;
        }
        return IG.array3(n3, n, n2, TArray);
    }
}

