/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolOp;
import igeo.IBoolR;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDoubleOp;
import igeo.IDoubleR;
import igeo.IMatrix3I;
import igeo.IMatrix3Op;
import igeo.IMatrix4I;
import igeo.IMatrix4Op;
import igeo.IParameterObject;
import igeo.IReferenceParameter;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2Op;
import igeo.IVec2R;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVec4Op;
import igeo.IVecI;
import igeo.IVecOp;
import igeo.IVecR;

public class IVec4R
extends IParameterObject
implements IVec4I,
IVecI,
IReferenceParameter {
    protected IVec4Op op;

    public IVec4R(IVec4Op iVec4Op) {
        this.op = iVec4Op;
    }

    public IVec4R(IVecI iVecI) {
        this.op = new FromVec(iVecI);
    }

    public IVec4R(IVecI iVecI, double d) {
        this.op = new FromVecAndW(this.op, new IDouble(d));
    }

    public IVec4R(IVecI iVecI, IDoubleI iDoubleI) {
        this.op = new FromVecAndW(this.op, iDoubleI);
    }

    public IVec4R(double d, double d2, double d3, double d4) {
        this.op = new IVec4(d, d2, d3, d4);
    }

    public IVec4R(double d, double d2, double d3) {
        this.op = new IVec4(d, d2, d3, 1.0);
    }

    public IVec4R(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        this.op = new FromXYZW(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public IVec4R(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new FromXYZ(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public IVec4R(IServerI iServerI, IVec4Op iVec4Op) {
        super(iServerI);
        this.op = iVec4Op;
    }

    public IVec4R(IServerI iServerI, IVecI iVecI) {
        super(iServerI);
        this.op = new FromVec(iVecI);
    }

    public IVec4R(IServerI iServerI, IVecI iVecI, double d) {
        super(iServerI);
        this.op = new FromVecAndW(this.op, new IDouble(d));
    }

    public IVec4R(IServerI iServerI, IVecI iVecI, IDoubleI iDoubleI) {
        super(iServerI);
        this.op = new FromVecAndW(this.op, iDoubleI);
    }

    public IVec4R(IServerI iServerI, double d, double d2, double d3, double d4) {
        super(iServerI);
        this.op = new IVec4(d, d2, d3, d4);
    }

    public IVec4R(IServerI iServerI, double d, double d2, double d3) {
        super(iServerI);
        this.op = new IVec4(d, d2, d3, 1.0);
    }

    public IVec4R(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        super(iServerI);
        this.op = new FromXYZW(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public IVec4R(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super(iServerI);
        this.op = new FromXYZ(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public double x() {
        return this.op.get().x;
    }

    @Override
    public double y() {
        return this.op.get().y;
    }

    @Override
    public double z() {
        return this.op.get().z;
    }

    @Override
    public double w() {
        return this.op.get().w;
    }

    @Override
    public IVec4 get() {
        return this.op.get();
    }

    @Override
    public IVec4R dup() {
        return new IVec4R(this.op);
    }

    @Override
    public IVec2R to2d() {
        return new IVec2R(new ToVec2(this.op));
    }

    @Override
    public IVecR to3d() {
        return new IVecR(new ToVec(this.op));
    }

    @Override
    public IVec4R to4d() {
        return this.dup();
    }

    @Override
    public IVec4R to4d(double d) {
        return new IVec4R((IVecI)this, d);
    }

    @Override
    public IVec4R to4d(IDoubleI iDoubleI) {
        return new IVec4R((IVecI)this, iDoubleI);
    }

    @Override
    public IDoubleR getX() {
        return new IDoubleR(new X(this.op));
    }

    @Override
    public IDoubleR getY() {
        return new IDoubleR(new Y(this.op));
    }

    @Override
    public IDoubleR getZ() {
        return new IDoubleR(new Z(this.op));
    }

    @Override
    public IDoubleR getW() {
        return new IDoubleR(new W(this.op));
    }

    @Override
    public IVec4Op operator() {
        return this.op;
    }

    @Override
    public IVec4R set(double d, double d2, double d3, double d4) {
        this.op = new IVec4(d, d2, d3, d4);
        return this;
    }

    @Override
    public IVec4R set(double d, double d2, double d3) {
        this.op = new IVec4(d, d2, d3, 1.0);
        return this;
    }

    @Override
    public IVec4R set(IVec4I iVec4I) {
        this.op = iVec4I;
        return this;
    }

    @Override
    public IVec4R set(IVecI iVecI) {
        this.op = new FromVec(iVecI);
        return this;
    }

    @Override
    public IVec4R set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        this.op = new FromXYZW(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
        return this;
    }

    @Override
    public IVec4R set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new FromXYZ(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IVec4R set(IVecI iVecI, double d) {
        this.op = new FromVecAndW(iVecI, new IDouble(d));
        return this;
    }

    @Override
    public IVec4R set(IVecI iVecI, IDoubleI iDoubleI) {
        this.op = new FromVecAndW(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4R add(double d, double d2, double d3) {
        this.op = new Add(this.op, new IVec(d, d2, d3));
        return this;
    }

    @Override
    public IVec4R add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new Add(this.op, new IVecR(iDoubleI, iDoubleI2, iDoubleI3));
        return this;
    }

    @Override
    public IVec4R add(IVecI iVecI) {
        this.op = new Add(this.op, iVecI);
        return this;
    }

    @Override
    public IVec4R sub(double d, double d2, double d3) {
        this.op = new Sub(this.op, new IVec(d, d2, d3));
        return this;
    }

    @Override
    public IVec4R sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.op = new Sub(this.op, new IVecR(iDoubleI, iDoubleI2, iDoubleI3));
        return this;
    }

    @Override
    public IVec4R sub(IVecI iVecI) {
        this.op = new Sub(this.op, iVecI);
        return this;
    }

    @Override
    public IVec4R mul(IDoubleI iDoubleI) {
        this.op = new Mul(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec4R mul(double d) {
        this.op = new Mul(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec4R div(IDoubleI iDoubleI) {
        this.op = new Div(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec4R div(double d) {
        this.op = new Div(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec4R neg() {
        this.op = new Neg(this.op);
        return this;
    }

    @Override
    public IVec4R rev() {
        return this.neg();
    }

    @Override
    public IVec4R flip() {
        return this.neg();
    }

    @Override
    public IVec4R zero() {
        return this.set(0.0, 0.0, 0.0);
    }

    @Override
    public IVec4R add(IVecI iVecI, double d) {
        return this.add(iVecI.dup().mul(d));
    }

    @Override
    public IVec4R add(IVecI iVecI, IDoubleI iDoubleI) {
        return this.add(iVecI.dup().mul(iDoubleI));
    }

    @Override
    public IVec4R add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IVec4R add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public double dot(IVecI iVecI) {
        return this.get().dot(iVecI);
    }

    @Override
    public double dot(double d, double d2, double d3) {
        return this.get().dot(d, d2, d3);
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dot(iVecI);
    }

    @Override
    public IDoubleR dot(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new IVecR.Dot(this.op, iVecI));
    }

    @Override
    public IVec4R cross(IVecI iVecI) {
        return new IVec4R(new Cross(this.op, iVecI));
    }

    @Override
    public IVec4R cross(double d, double d2, double d3) {
        return new IVec4R(new Cross(this.op, new IVec(d, d2, d3)));
    }

    @Override
    public double len() {
        return this.get().len();
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    @Override
    public IDoubleR len(ISwitchR iSwitchR) {
        return new IDoubleR(new IVecR.Len(this.op));
    }

    @Override
    public double len2() {
        return this.get().len2();
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    @Override
    public IDoubleR len2(ISwitchR iSwitchR) {
        return new IDoubleR(new IVecR.Len2(this.op));
    }

    @Override
    public IVec4R len(IDoubleI iDoubleI) {
        this.op = new SetLen(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec4R len(double d) {
        this.op = new SetLen(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec4R unit() {
        this.op = new Unit(this.op);
        return this;
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.get().dist(iVecI);
    }

    @Override
    public double dist(double d, double d2, double d3) {
        return this.get().dist(d, d2, d3);
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist(iVecI);
    }

    @Override
    public IDoubleR dist(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new Dist(this.op, iVecI));
    }

    @Override
    public double dist2(IVecI iVecI) {
        return this.get().dist2(iVecI);
    }

    @Override
    public double dist2(double d, double d2, double d3) {
        return this.get().dist2(d, d2, d3);
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.dist2(iVecI);
    }

    @Override
    public IDoubleR dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new Dist2(this.op, iVecI));
    }

    @Override
    public boolean eq(IVecI iVecI) {
        return this.get().eq(iVecI);
    }

    @Override
    public boolean eq(double d, double d2, double d3) {
        return this.get().eq(d, d2, d3);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eq(iVecI);
    }

    @Override
    public IBoolR eq(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new Eq(this.op, iVecI));
    }

    @Override
    public boolean eqX(IVecI iVecI) {
        return this.get().eqX(iVecI);
    }

    @Override
    public boolean eqY(IVecI iVecI) {
        return this.get().eqY(iVecI);
    }

    @Override
    public boolean eqZ(IVecI iVecI) {
        return this.get().eqZ(iVecI);
    }

    @Override
    public boolean eqW(IVec4I iVec4I) {
        return this.get().eqW(iVec4I);
    }

    @Override
    public boolean eqX(double d) {
        return this.get().eqX(d);
    }

    @Override
    public boolean eqY(double d) {
        return this.get().eqY(d);
    }

    @Override
    public boolean eqZ(double d) {
        return this.get().eqZ(d);
    }

    @Override
    public boolean eqW(double d) {
        return this.get().eqW(d);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqX(iVecI);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqY(iVecI);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.eqZ(iVecI);
    }

    @Override
    public boolean eqW(ISwitchE iSwitchE, IVec4I iVec4I) {
        return this.eqW(iVec4I);
    }

    @Override
    public IBoolR eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new EqX(this.op, iVecI));
    }

    @Override
    public IBoolR eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new EqY(this.op, iVecI));
    }

    @Override
    public IBoolR eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return new IBoolR(new EqZ(this.op, iVecI));
    }

    @Override
    public IBoolR eqW(ISwitchR iSwitchR, IVec4I iVec4I) {
        return new IBoolR(new EqW(this.op, iVec4I));
    }

    @Override
    public boolean eq(IVecI iVecI, double d) {
        return this.get().eq(iVecI, d);
    }

    @Override
    public boolean eq(double d, double d2, double d3, double d4) {
        return this.get().eq(d, d2, d3, d4);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eq(iVecI, d);
    }

    @Override
    public IBoolR eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new Eq(this.op, iVecI, iDoubleI));
    }

    @Override
    public boolean eqX(IVecI iVecI, double d) {
        return this.get().eqX(iVecI, d);
    }

    @Override
    public boolean eqY(IVecI iVecI, double d) {
        return this.get().eqY(iVecI, d);
    }

    @Override
    public boolean eqZ(IVecI iVecI, double d) {
        return this.get().eqZ(iVecI, d);
    }

    @Override
    public boolean eqW(IVec4I iVec4I, double d) {
        return this.get().eqW(iVec4I, d);
    }

    @Override
    public boolean eqX(double d, double d2) {
        return this.get().eqX(d, d2);
    }

    @Override
    public boolean eqY(double d, double d2) {
        return this.get().eqY(d, d2);
    }

    @Override
    public boolean eqZ(double d, double d2) {
        return this.get().eqZ(d, d2);
    }

    @Override
    public boolean eqW(double d, double d2) {
        return this.get().eqW(d, d2);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqX(iVecI, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqY(iVecI, d);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.eqZ(iVecI, d);
    }

    @Override
    public boolean eqW(ISwitchE iSwitchE, IVec4I iVec4I, double d) {
        return this.eqW(iVec4I, d);
    }

    @Override
    public IBoolR eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new EqX(this.op, iVecI, iDoubleI));
    }

    @Override
    public IBoolR eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new EqY(this.op, iVecI, iDoubleI));
    }

    @Override
    public IBoolR eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return new IBoolR(new EqZ(this.op, iVecI, iDoubleI));
    }

    @Override
    public IBoolR eqW(ISwitchR iSwitchR, IVec4I iVec4I, IDoubleI iDoubleI) {
        return new IBoolR(new EqW(this.op, iVec4I, iDoubleI));
    }

    @Override
    public double angle(IVecI iVecI) {
        return this.get().angle(iVecI);
    }

    @Override
    public double angle(double d, double d2, double d3) {
        return this.get().angle(d, d2, d3);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.angle(iVecI);
    }

    @Override
    public IDoubleR angle(ISwitchR iSwitchR, IVecI iVecI) {
        return new IDoubleR(new IVecR.Angle(this.op, iVecI));
    }

    @Override
    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.get().angle(iVecI, iVecI2);
    }

    @Override
    public double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.get().angle(d, d2, d3, d4, d5, d6);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.angle(iVecI, iVecI2);
    }

    @Override
    public IDoubleR angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return new IDoubleR(new IVecR.Angle(this.op, iVecI, iVecI2));
    }

    @Override
    public IVec4R rot(IDoubleI iDoubleI) {
        this.op = new Rot2(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec4R rot(double d) {
        this.op = new Rot2(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec4R rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.op = new Rot(this.op, iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4R rot(IVecI iVecI, double d) {
        this.op = new Rot(this.op, iVecI, new IDouble(d));
        return this;
    }

    @Override
    public IVec4R rot(double d, double d2, double d3, double d4) {
        this.op = new Rot(this.op, new IVec(d, d2, d3), new IDouble(d4));
        return this;
    }

    @Override
    public IVec4R rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot(iVecI2, iDoubleI).add(iVecI);
    }

    @Override
    public IVec4R rot(IVecI iVecI, IVecI iVecI2, double d) {
        return this.rot(iVecI, iVecI2, new IDouble(d));
    }

    @Override
    public IVec4R rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.rot((IVecI)new IVec(d, d2, d3), (IVecI)new IVec(d4, d5, d6), new IDouble(d7));
    }

    @Override
    public IVec4R rot(IVecI iVecI, IVecI iVecI2) {
        return this.rot(iVecI, iVecI2.cross(iVecI).angle(this.cross(iVecI)));
    }

    @Override
    public IVec4R rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot(iVecI2, iVecI3.diff(iVecI)).add(iVecI);
    }

    @Override
    public IVec4R rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IVec4R rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IVec4R rot2(IVecI iVecI, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot(iDoubleI).add(iVecI);
    }

    @Override
    public IVec4R rot2(IVecI iVecI, double d) {
        return this.rot2(iVecI, new IDouble(d));
    }

    @Override
    public IVec4R rot2(double d, double d2, double d3) {
        return this.rot2((IVecI)new IVec(d, d2), new IDouble(d3));
    }

    @Override
    public IVec4R rot2(IVecI iVecI) {
        return this.rot(iVecI.cross(IVec.zaxis).angle(this.cross(IVec.zaxis)));
    }

    @Override
    public IVec4R rot2(IVecI iVecI, IVecI iVecI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).rot2(iVecI2.diff(iVecI)).add(iVecI);
    }

    @Override
    public IVec4R scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public IVec4R scale(double d) {
        return this.mul(d);
    }

    @Override
    public IVec4R scale(IVecI iVecI, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).mul(iDoubleI).add(iVecI);
    }

    @Override
    public IVec4R scale(IVecI iVecI, double d) {
        return this.scale(iVecI, new IDouble(d));
    }

    @Override
    public IVec4R scale(double d, double d2, double d3, double d4) {
        return this.scale((IVecI)new IVec(d, d2, d3), new IDouble(d4));
    }

    @Override
    public IVec4R scale1d(IVecI iVecI, double d) {
        return this.scale1d(iVecI, new IDouble(d));
    }

    @Override
    public IVec4R scale1d(double d, double d2, double d3, double d4) {
        return this.scale1d((IVecI)new IVec(d, d2, d3), new IDouble(d4));
    }

    @Override
    public IVec4R scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.op = new Scale1d(this.op, iVecI, iDoubleI);
        return this;
    }

    @Override
    public IVec4R scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        return this.scale1d(iVecI, iVecI2, new IDouble(d));
    }

    @Override
    public IVec4R scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return this.scale1d((IVecI)new IVec(d, d2, d3), (IVecI)new IVec(d4, d5, d6), new IDouble(d7));
    }

    @Override
    public IVec4R scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).scale1d(iVecI2, iDoubleI).add(iVecI);
    }

    @Override
    public IVec4R ref(IVecI iVecI) {
        this.op = new Ref(this.op, iVecI);
        return this;
    }

    @Override
    public IVec4R ref(double d, double d2, double d3) {
        this.op = new Ref(this.op, new IVec(d, d2, d3));
        return this;
    }

    @Override
    public IVec4R ref(IVecI iVecI, IVecI iVecI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).ref(iVecI2).add(iVecI);
    }

    @Override
    public IVec4R ref(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.ref(new IVec(d, d2, d3), new IVec(d4, d5, d6));
    }

    @Override
    public IVec4R mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public IVec4R mirror(double d, double d2, double d3) {
        return this.ref(d, d2, d3);
    }

    @Override
    public IVec4R mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public IVec4R mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.ref(d, d2, d3, d4, d5, d6);
    }

    @Override
    public IVec4R shear(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.shear(new IDouble(d), new IDouble(d2), new IDouble(d3), new IDouble(d4), new IDouble(d5), new IDouble(d6));
    }

    @Override
    public IVec4R shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.op = new Shear(this.op, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IVec4R shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shear(d, d2, d3, d4, d5, d6).add(iVecI);
    }

    @Override
    public IVec4R shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6).add(iVecI);
    }

    @Override
    public IVec4R shearXY(double d, double d2) {
        return this.shear(d, d2, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public IVec4R shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shear(iDoubleI, iDoubleI2, null, null, null, null);
    }

    @Override
    public IVec4R shearXY(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearXY(d, d2).add(iVecI);
    }

    @Override
    public IVec4R shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearXY(iDoubleI, iDoubleI2).add(iVecI);
    }

    @Override
    public IVec4R shearYZ(double d, double d2) {
        return this.shear(0.0, 0.0, d, d2, 0.0, 0.0);
    }

    @Override
    public IVec4R shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shear(null, null, iDoubleI, iDoubleI2, null, null);
    }

    @Override
    public IVec4R shearYZ(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearYZ(d, d2).add(iVecI);
    }

    @Override
    public IVec4R shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearYZ(iDoubleI, iDoubleI2).add(iVecI);
    }

    @Override
    public IVec4R shearZX(double d, double d2) {
        return this.shear(0.0, 0.0, 0.0, 0.0, d, d2);
    }

    @Override
    public IVec4R shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.shear(null, null, null, null, iDoubleI, iDoubleI2);
    }

    @Override
    public IVec4R shearZX(IVecI iVecI, double d, double d2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearZX(d, d2).add(iVecI);
    }

    @Override
    public IVec4R shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        if (iVecI == this) {
            return this;
        }
        return this.sub(iVecI).shearZX(iDoubleI, iDoubleI2).add(iVecI);
    }

    @Override
    public IVec4R translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVec4R translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVec4R translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVec4R transform(IMatrix3I iMatrix3I) {
        this.op = new Transform3(this.op, iMatrix3I);
        return this;
    }

    @Override
    public IVec4R transform(IMatrix4I iMatrix4I) {
        this.op = new Transform4(this.op, iMatrix4I);
        return this;
    }

    @Override
    public IVec4R transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.op = new TransformVec3(this.op, iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IVec4R transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.op = new TransformVec4(this.op, iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IVec4R mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVec4R mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVec4R mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVec4R cp() {
        return this.dup();
    }

    @Override
    public IVec4R cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IVec4R cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVec4R cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVec4R dif(IVecI iVecI) {
        return this.dup().sub(iVecI);
    }

    @Override
    public IVec4R dif(double d, double d2, double d3) {
        return this.dup().sub(new IVec(d, d2, d3));
    }

    @Override
    public IVec4R diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    @Override
    public IVec4R diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    @Override
    public IVec4R mid(IVecI iVecI) {
        return this.dup().add(iVecI).div(2.0);
    }

    @Override
    public IVec4R mid(double d, double d2, double d3) {
        return this.dup().add(new IVec(d, d2, d3)).div(2.0);
    }

    @Override
    public IVec4R sum(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVec4R sum(double d, double d2, double d3) {
        return this.dup().add(new IVec(d, d2, d3));
    }

    @Override
    public IVec4R sum(IVecI ... iVecIArray) {
        IVec4R iVec4R = this.dup();
        for (IVecI iVecI : iVecIArray) {
            iVec4R.add(iVecI);
        }
        return iVec4R;
    }

    @Override
    public IVec4R bisect(IVecI iVecI) {
        return this.dup().unit().add(iVecI.dup().unit());
    }

    @Override
    public IVec4R bisect(double d, double d2, double d3) {
        return this.dup().unit().add(new IVecR(d, d2, d3).unit());
    }

    @Override
    public IVec4R sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.dup().mul(iDoubleI).add(iVecI, iDoubleI2);
    }

    @Override
    public IVec4R sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.dup().mul(new IDouble(1.0).sub(iDoubleI)).add(iVecI, iDoubleI);
    }

    @Override
    public IVec4R sum(IVecI iVecI, double d, double d2) {
        return this.sum(iVecI, new IDouble(d), new IDouble(d2));
    }

    @Override
    public IVec4R sum(IVecI iVecI, double d) {
        return this.sum(iVecI, new IDouble(d));
    }

    @Override
    public IVec4R nml(IVecI iVecI) {
        return this.cross(iVecI);
    }

    @Override
    public IVec4R nml(double d, double d2, double d3) {
        return this.cross(new IVec(d, d2, d3));
    }

    @Override
    public IVec4R nml(IVecI iVecI, IVecI iVecI2) {
        return this.diff(iVecI).cross(this.diff(iVecI2));
    }

    @Override
    public IVec4R nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.diff(d, d2, d3).cross(this.diff(d4, d5, d6));
    }

    @Override
    public boolean isValid() {
        return this.get().isValid();
    }

    public static class TransformVec4
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IVecOp x;
        public IVecOp y;
        public IVecOp z;
        public IVecOp trans;

        public TransformVec4(IVec4Op iVec4Op, IVecOp iVecOp, IVecOp iVecOp2, IVecOp iVecOp3, IVecOp iVecOp4) {
            this.v = iVec4Op;
            this.x = iVecOp;
            this.y = iVecOp2;
            this.z = iVecOp3;
            this.trans = iVecOp4;
        }

        @Override
        public IVec4 get() {
            return this.v.get().transform(this.x.get(), this.y.get(), this.z.get(), this.trans.get());
        }
    }

    public static class TransformVec3
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IVecOp x;
        public IVecOp y;
        public IVecOp z;

        public TransformVec3(IVec4Op iVec4Op, IVecOp iVecOp, IVecOp iVecOp2, IVecOp iVecOp3) {
            this.v = iVec4Op;
            this.x = iVecOp;
            this.y = iVecOp2;
            this.z = iVecOp3;
        }

        @Override
        public IVec4 get() {
            return this.v.get().transform(this.x.get(), this.y.get(), this.z.get());
        }
    }

    public static class Transform4
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IMatrix4Op mat;

        public Transform4(IVec4Op iVec4Op, IMatrix4Op iMatrix4Op) {
            this.v = iVec4Op;
            this.mat = iMatrix4Op;
        }

        @Override
        public IVec4 get() {
            return this.v.get().transform(this.mat.get());
        }
    }

    public static class Transform3
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IMatrix3Op mat;

        public Transform3(IVec4Op iVec4Op, IMatrix3Op iMatrix3Op) {
            this.v = iVec4Op;
            this.mat = iMatrix3Op;
        }

        @Override
        public IVec4 get() {
            return this.v.get().transform(this.mat.get());
        }
    }

    public static class Shear
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IDoubleOp sxy;
        public IDoubleOp syx;
        public IDoubleOp syz;
        public IDoubleOp szy;
        public IDoubleOp szx;
        public IDoubleOp sxz;

        public Shear(IVec4Op iVec4Op, IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2, IDoubleOp iDoubleOp3, IDoubleOp iDoubleOp4, IDoubleOp iDoubleOp5, IDoubleOp iDoubleOp6) {
            this.v = iVec4Op;
            this.sxy = iDoubleOp;
            this.syx = iDoubleOp2;
            this.syz = iDoubleOp3;
            this.szy = iDoubleOp4;
            this.szx = iDoubleOp5;
            this.sxz = iDoubleOp6;
        }

        @Override
        public IVec4 get() {
            return this.v.get().shear(this.sxy.get(), this.syx.get(), this.syz.get(), this.szy.get(), this.szx.get(), this.sxz.get());
        }
    }

    public static class Ref
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IVecOp plane;

        public Ref(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v = iVec4Op;
            this.plane = iVecOp;
        }

        @Override
        public IVec4 get() {
            return this.v.get().ref(this.plane.get());
        }
    }

    public static class Scale1d
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IVecOp axis;
        public IDoubleI factor;

        public Scale1d(IVec4Op iVec4Op, IVecOp iVecOp, IDoubleI iDoubleI) {
            this.v = iVec4Op;
            this.axis = iVecOp;
            this.factor = iDoubleI;
        }

        @Override
        public IVec4 get() {
            return this.v.get().scale1d((IVecI)this.axis.get(), this.factor.get());
        }
    }

    public static class EqW
    extends IParameterObject
    implements IBoolOp {
        public IVec4Op v1;
        public IVec4Op v2;
        public IDoubleOp tolerance = null;

        public EqW(IVec4Op iVec4Op, IVec4Op iVec4Op2) {
            this.v1 = iVec4Op;
            this.v2 = iVec4Op2;
        }

        public EqW(IVec4Op iVec4Op, IVec4Op iVec4Op2, IDoubleOp iDoubleOp) {
            this.v1 = iVec4Op;
            this.v2 = iVec4Op2;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eqW(this.v2.get());
            }
            return this.v1.get().eqW(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eqW((ISwitchR)null, (IVec4I)this.v2.get());
            }
            return this.v1.get().eqW((ISwitchR)null, (IVec4I)this.v2.get(), this.tolerance.get());
        }
    }

    public static class EqZ
    extends IParameterObject
    implements IBoolOp {
        public IVec4Op v1;
        public IVecOp v2;
        public IDoubleOp tolerance = null;

        public EqZ(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        public EqZ(IVec4Op iVec4Op, IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eqZ(this.v2.get());
            }
            return this.v1.get().eqZ(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eqZ((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eqZ((ISwitchR)null, (IVecI)this.v2.get(), this.tolerance.get());
        }
    }

    public static class EqY
    extends IParameterObject
    implements IBoolOp {
        public IVec4Op v1;
        public IVecOp v2;
        public IDoubleOp tolerance = null;

        public EqY(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        public EqY(IVec4Op iVec4Op, IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eqY(this.v2.get());
            }
            return this.v1.get().eqY(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eqY((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eqY((ISwitchR)null, (IVecI)this.v2.get(), this.tolerance.get());
        }
    }

    public static class EqX
    extends IParameterObject
    implements IBoolOp {
        public IVec4Op v1;
        public IVecOp v2;
        public IDoubleOp tolerance = null;

        public EqX(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        public EqX(IVec4Op iVec4Op, IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eqX(this.v2.get());
            }
            return this.v1.get().eqX(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eqX((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eqX((ISwitchR)null, (IVecI)this.v2.get(), this.tolerance.get());
        }
    }

    public static class Eq
    extends IParameterObject
    implements IBoolOp {
        public IVec4Op v1;
        public IVecOp v2;
        public IDoubleOp tolerance = null;

        public Eq(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        public Eq(IVec4Op iVec4Op, IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eq(this.v2.get());
            }
            return this.v1.get().eq(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eq((ISwitchR)null, (IVecI)this.v2.get());
            }
            return this.v1.get().eq((ISwitchR)null, (IVecI)this.v2.get(), this.tolerance.get());
        }
    }

    public static class Dist2
    extends IParameterObject
    implements IDoubleOp {
        public IVec4Op v1;
        public IVecOp v2;

        public Dist2(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        @Override
        public double x() {
            return this.v1.get().dist2(this.v2.get());
        }

        @Override
        public IDouble get() {
            return this.v1.get().dist2((ISwitchR)null, (IVecI)this.v2.get());
        }
    }

    public static class Dist
    extends IParameterObject
    implements IDoubleOp {
        public IVec4Op v1;
        public IVecOp v2;

        public Dist(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        @Override
        public double x() {
            return this.v1.get().dist(this.v2.get());
        }

        @Override
        public IDouble get() {
            return this.v1.get().dist((ISwitchR)null, (IVecI)this.v2.get());
        }
    }

    public static class SetLen
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IDoubleOp l;

        public SetLen(IVec4Op iVec4Op, IDoubleOp iDoubleOp) {
            this.v = iVec4Op;
            this.l = iDoubleOp;
        }

        @Override
        public IVec4 get() {
            return this.v.get().len(this.l.x());
        }
    }

    public static class Unit
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;

        public Unit(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public IVec4 get() {
            return this.v.get().unit();
        }
    }

    public static class W
    extends IParameterObject
    implements IDoubleOp {
        public IVec4Op v;

        public W(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public double x() {
            return this.v.get().w;
        }

        @Override
        public IDouble get() {
            return this.v.get().getW();
        }
    }

    public static class Z
    extends IParameterObject
    implements IDoubleOp {
        public IVec4Op v;

        public Z(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public double x() {
            return this.v.get().z;
        }

        @Override
        public IDouble get() {
            return this.v.get().getZ();
        }
    }

    public static class Y
    extends IParameterObject
    implements IDoubleOp {
        public IVec4Op v;

        public Y(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public double x() {
            return this.v.get().y;
        }

        @Override
        public IDouble get() {
            return this.v.get().getY();
        }
    }

    public static class X
    extends IParameterObject
    implements IDoubleOp {
        public IVec4Op v;

        public X(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public double x() {
            return this.v.get().x;
        }

        @Override
        public IDouble get() {
            return this.v.get().getX();
        }
    }

    public static class Rot2
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IDoubleOp angle;

        public Rot2(IVec4Op iVec4Op, IDoubleOp iDoubleOp) {
            this.v = iVec4Op;
            this.angle = iDoubleOp;
        }

        @Override
        public IVec4 get() {
            return this.v.get().rot(this.angle.x());
        }
    }

    public static class Rot
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IVecOp axis;
        public IDoubleOp angle;

        public Rot(IVec4Op iVec4Op, IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v = iVec4Op;
            this.axis = iVecOp;
            this.angle = iDoubleOp;
        }

        @Override
        public IVec4 get() {
            return this.v.get().rot(this.axis.get(), this.angle.x());
        }
    }

    public static class Cross
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v1;
        public IVecOp v2;

        public Cross(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        @Override
        public IVec4 get() {
            return this.v1.get().cross(this.v2.get());
        }
    }

    public static class Neg
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;

        public Neg(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public IVec4 get() {
            return this.v.get().neg();
        }
    }

    public static class Div
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IDoubleOp d;

        public Div(IVec4Op iVec4Op, IDoubleOp iDoubleOp) {
            this.v = iVec4Op;
            this.d = iDoubleOp;
        }

        @Override
        public IVec4 get() {
            return this.v.get().div(this.d.x());
        }
    }

    public static class Mul
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v;
        public IDoubleOp d;

        public Mul(IVec4Op iVec4Op, IDoubleOp iDoubleOp) {
            this.v = iVec4Op;
            this.d = iDoubleOp;
        }

        @Override
        public IVec4 get() {
            return this.v.get().mul(this.d.x());
        }
    }

    public static class Sub
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v1;
        public IVecOp v2;

        public Sub(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        @Override
        public IVec4 get() {
            return this.v1.get().sub(this.v2.get());
        }
    }

    public static class Add
    extends IParameterObject
    implements IVec4Op {
        public IVec4Op v1;
        public IVecOp v2;

        public Add(IVec4Op iVec4Op, IVecOp iVecOp) {
            this.v1 = iVec4Op;
            this.v2 = iVecOp;
        }

        @Override
        public IVec4 get() {
            return this.v1.get().add(this.v2.get());
        }
    }

    public static class ToVec2
    extends IParameterObject
    implements IVec2Op {
        public IVec4Op v;

        public ToVec2(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public IVec2 get() {
            return new IVec2(this.v.get());
        }
    }

    public static class ToVec
    extends IParameterObject
    implements IVecOp {
        public IVec4Op v;

        public ToVec(IVec4Op iVec4Op) {
            this.v = iVec4Op;
        }

        @Override
        public IVec get() {
            return new IVec(this.v.get());
        }
    }

    public static class FromXYZW
    extends IParameterObject
    implements IVec4Op {
        public IDoubleOp x;
        public IDoubleOp y;
        public IDoubleOp z;
        public IDoubleOp w;

        public FromXYZW(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2, IDoubleOp iDoubleOp3, IDoubleOp iDoubleOp4) {
            this.x = iDoubleOp;
            this.y = iDoubleOp2;
            this.z = iDoubleOp3;
            this.w = iDoubleOp4;
        }

        @Override
        public IVec4 get() {
            return new IVec4(this.x.x(), this.y.x(), this.z.x(), this.w.x());
        }
    }

    public static class FromXYZ
    extends IParameterObject
    implements IVec4Op {
        public IDoubleOp x;
        public IDoubleOp y;
        public IDoubleOp z;

        public FromXYZ(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2, IDoubleOp iDoubleOp3) {
            this.x = iDoubleOp;
            this.y = iDoubleOp2;
            this.z = iDoubleOp3;
        }

        @Override
        public IVec4 get() {
            return new IVec4(this.x.x(), this.y.x(), this.z.x(), 1.0);
        }
    }

    public static class FromVecAndW
    extends IParameterObject
    implements IVec4Op {
        public IVecOp v;
        public IDoubleOp w;

        public FromVecAndW(IVecOp iVecOp, IDoubleOp iDoubleOp) {
            this.v = iVecOp;
            this.w = iDoubleOp;
        }

        @Override
        public IVec4 get() {
            return new IVec4(this.v.get(), this.w.x());
        }
    }

    public static class FromVec
    extends IParameterObject
    implements IVec4Op {
        public IVecOp v;

        public FromVec(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        @Override
        public IVec4 get() {
            return new IVec4(this.v.get());
        }
    }
}

