/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IGraphicObject;
import igeo.IVec;
import igeo.IVectorObject;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.ISurfaceGraphicGL;
import javax.media.opengl.GL;

public class IVectorGraphic
extends IGraphicObject {
    public static double defaultSize = 2.0;
    public static float defaultWeight = 1.0f;
    public static IVec arrowHeadNormal = new IVec(0.0, 0.0, 1.0);
    public static IVec arrowHeadNormal2 = new IVec(0.0, 1.0, 0.0);
    public IVectorObject vec = null;
    public double size = defaultSize;
    public float weight = defaultWeight;

    public IVectorGraphic(IVectorObject iVectorObject) {
        super(iVectorObject);
        this.vec = iVectorObject;
    }

    public void size(double d) {
        this.size = d;
    }

    public double size() {
        return this.size;
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (this.vec == null) {
            return;
        }
        if (iGraphics.view().mode().isGL()) {
            Object object;
            GL gL = iGraphics.getGL();
            gL.glLineWidth(this.weight);
            gL.glPointSize((float)this.size);
            float f = defaultRed;
            float f2 = defaultGreen;
            float f3 = defaultBlue;
            float f4 = defaultAlpha;
            if (this.color != null) {
                f = (float)this.color.getRed() / 255.0f;
                f2 = (float)this.color.getGreen() / 255.0f;
                f3 = (float)this.color.getBlue() / 255.0f;
                f4 = (float)this.color.getAlpha() / 255.0f;
            }
            if (iGraphics.view().mode().isTransparent() && iGraphics.view().mode().isTransparentWireframe()) {
                f4 = (float)transparentModeAlpha;
            }
            if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
                object = new float[]{f, f2, f3, f4};
                gL.glMaterialfv(1032, 4608, (float[])object, 0);
                gL.glMaterialfv(1032, 4609, (float[])object, 0);
                gL.glMaterialf(1032, 5633, ISurfaceGraphicGL.defaultShininess);
                gL.glColor4f(f, f2, f3, 0.0f);
            } else {
                gL.glColor4f(f, f2, f3, f4);
            }
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glDisable(2896);
            }
            object = this.vec.root.get();
            IVec iVec = this.vec.vec.get();
            IVec iVec2 = null;
            iVec2 = iVec.angle(arrowHeadNormal) < IConfig.angleTolerance ? iVec.cross(arrowHeadNormal2) : iVec.cross(arrowHeadNormal);
            iVec2.len(this.size / 2.0);
            IVec iVec3 = this.vec.vec.get().dup().rev().len(this.size);
            if (iGraphics.view().mode().isFill()) {
                gL.glBegin(1);
                gL.glVertex3d(((IVec)object).x, ((IVec)object).y, ((IVec)object).z);
                gL.glVertex3d(iVec.x + iVec3.x + ((IVec)object).x, iVec.y + iVec3.y + ((IVec)object).y, iVec.z + iVec3.z + ((IVec)object).z);
                gL.glEnd();
                if (iGraphics.view().mode().isTransparent()) {
                    f4 = (float)transparentModeAlpha;
                    gL.glColor4f(f, f2, f3, f4);
                }
                gL.glBegin(4);
                gL.glVertex3d(iVec.x + iVec3.x - iVec2.x + ((IVec)object).x, iVec.y + iVec3.y - iVec2.y + ((IVec)object).y, iVec.z + iVec3.z - iVec2.z + ((IVec)object).z);
                gL.glVertex3d(iVec.x + ((IVec)object).x, iVec.y + ((IVec)object).y, iVec.z + ((IVec)object).z);
                gL.glVertex3d(iVec.x + iVec3.x + iVec2.x + ((IVec)object).x, iVec.y + iVec3.y + iVec2.y + ((IVec)object).y, iVec.z + iVec3.z + iVec2.z + ((IVec)object).z);
                gL.glEnd();
            } else {
                gL.glColor4f(f, f2, f3, f4);
                gL.glBegin(1);
                gL.glVertex3d(((IVec)object).x, ((IVec)object).y, ((IVec)object).z);
                gL.glVertex3d(iVec.x + ((IVec)object).x, iVec.y + ((IVec)object).y, iVec.z + ((IVec)object).z);
                gL.glEnd();
                gL.glBegin(3);
                gL.glVertex3d(iVec.x + iVec3.x - iVec2.x + ((IVec)object).x, iVec.y + iVec3.y - iVec2.y + ((IVec)object).y, iVec.z + iVec3.z - iVec2.z + ((IVec)object).z);
                gL.glVertex3d(iVec.x + ((IVec)object).x, iVec.y + ((IVec)object).y, iVec.z + ((IVec)object).z);
                gL.glVertex3d(iVec.x + iVec3.x + iVec2.x + ((IVec)object).x, iVec.y + iVec3.y + iVec2.y + ((IVec)object).y, iVec.z + iVec3.z + iVec2.z + ((IVec)object).z);
                gL.glEnd();
            }
            if (iGraphics.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                gL.glEnable(2896);
            }
        } else if (iGraphics.view().mode().isJava()) {
            // empty if block
        }
    }

    @Override
    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }
}

