/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolOp;
import igeo.IBoolR;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDoubleOp;
import igeo.IDoubleR;
import igeo.IParameterObject;
import igeo.IReferenceParameter;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec2Op;
import igeo.IVec4;
import igeo.IVec4Op;
import igeo.IVec4R;
import igeo.IVecOp;
import igeo.IVecR;

public class IVec2R
extends IParameterObject
implements IVec2I,
IReferenceParameter {
    protected IVec2Op op;

    public IVec2R(IVec2Op iVec2Op) {
        this.op = iVec2Op;
    }

    public IVec2R(double d, double d2) {
        this.op = new IVec2(d, d2);
    }

    public IVec2R(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.op = new FromXY(iDoubleI, iDoubleI2);
    }

    public IVec2R(IServerI iServerI, IVec2Op iVec2Op) {
        super(iServerI);
        this.op = iVec2Op;
    }

    public IVec2R(IServerI iServerI, double d, double d2) {
        super(iServerI);
        this.op = new IVec2(d, d2);
    }

    public IVec2R(IServerI iServerI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super(iServerI);
        this.op = new FromXY(iDoubleI, iDoubleI2);
    }

    @Override
    public double x() {
        return this.op.get().x;
    }

    @Override
    public double y() {
        return this.op.get().y;
    }

    @Override
    public IVec2 get() {
        return this.op.get();
    }

    @Override
    public IDoubleR getX() {
        return new IDoubleR(new X(this.op));
    }

    @Override
    public IDoubleR getY() {
        return new IDoubleR(new Y(this.op));
    }

    @Override
    public IVec2Op operator() {
        return this.op;
    }

    @Override
    public IVec2R dup() {
        return new IVec2R(this.op);
    }

    @Override
    public IVecR to3d() {
        return new IVecR(new ToVec3(this));
    }

    @Override
    public IVecR to3d(double d) {
        return new IVecR(new ToVec3(this, new IDouble(d)));
    }

    @Override
    public IVecR to3d(IDoubleI iDoubleI) {
        return new IVecR(new ToVec3(this, iDoubleI));
    }

    @Override
    public IVec4R to4d() {
        return new IVec4R(new ToVec4(this));
    }

    @Override
    public IVec4R to4d(double d, double d2) {
        return new IVec4R(new ToVec4(this, new IDouble(d), new IDouble(d2)));
    }

    @Override
    public IVec4R to4d(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec4R(new ToVec4(this, iDoubleI, iDoubleI2));
    }

    @Override
    public IVec2R set(IVec2I iVec2I) {
        this.op = iVec2I;
        return this;
    }

    @Override
    public IVec2R set(double d, double d2) {
        this.op = new IVec2(d, d2);
        return this;
    }

    @Override
    public IVec2R set(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.op = new FromXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IVec2R add(double d, double d2) {
        this.op = new Add(this.op, new IVec2(d, d2));
        return this;
    }

    @Override
    public IVec2R add(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.op = new Add(this.op, new IVec2R(iDoubleI, iDoubleI2));
        return this;
    }

    @Override
    public IVec2R add(IVec2I iVec2I) {
        this.op = new Add(this.op, iVec2I);
        return this;
    }

    @Override
    public IVec2R sub(double d, double d2) {
        this.op = new Sub(this.op, new IVec2(d, d2));
        return this;
    }

    @Override
    public IVec2R sub(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.op = new Sub(this.op, new IVec2R(iDoubleI, iDoubleI2));
        return this;
    }

    @Override
    public IVec2R sub(IVec2I iVec2I) {
        this.op = new Sub(this.op, iVec2I);
        return this;
    }

    @Override
    public IVec2R mul(IDoubleI iDoubleI) {
        this.op = new Mul(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec2R mul(double d) {
        this.op = new Mul(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec2R div(IDoubleI iDoubleI) {
        this.op = new Div(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec2R div(double d) {
        this.op = new Div(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec2R neg() {
        this.op = new Neg(this.op);
        return this;
    }

    @Override
    public IVec2R rev() {
        return this.neg();
    }

    @Override
    public IVec2R flip() {
        return this.neg();
    }

    @Override
    public IVec2R zero() {
        return this.set(0.0, 0.0);
    }

    @Override
    public IVec2R add(IVec2I iVec2I, double d) {
        return this.add(iVec2I.dup().mul(d));
    }

    @Override
    public IVec2R add(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.add(iVec2I.dup().mul(iDoubleI));
    }

    @Override
    public IVec2R add(double d, IVec2I iVec2I) {
        return this.add(iVec2I, d);
    }

    @Override
    public IVec2R add(IDoubleI iDoubleI, IVec2I iVec2I) {
        return this.add(iVec2I, iDoubleI);
    }

    @Override
    public double dot(IVec2I iVec2I) {
        return this.get().dot(iVec2I);
    }

    @Override
    public double dot(double d, double d2) {
        return this.get().dot(d, d2);
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dot(iVec2I);
    }

    @Override
    public IDoubleR dot(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDoubleR(new Dot(this.op, iVec2I));
    }

    @Override
    public IVecR cross(IVec2I iVec2I) {
        return new IVecR(new Cross(this.op, iVec2I));
    }

    @Override
    public IVecR cross(double d, double d2) {
        return new IVecR(new Cross(this.op, new IVec2(d, d2)));
    }

    @Override
    public double len() {
        return this.get().len();
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.len();
    }

    @Override
    public IDoubleR len(ISwitchR iSwitchR) {
        return new IDoubleR(new Len(this.op));
    }

    @Override
    public double len2() {
        return this.get().len2();
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.len2();
    }

    @Override
    public IDoubleR len2(ISwitchR iSwitchR) {
        return new IDoubleR(new Len2(this.op));
    }

    @Override
    public IVec2R len(IDoubleI iDoubleI) {
        this.op = new SetLen(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec2R len(double d) {
        this.op = new SetLen(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec2R unit() {
        this.op = new Unit(this.op);
        return this;
    }

    @Override
    public IVec2R ortho() {
        this.op = new Ortho(this.op);
        return this;
    }

    @Override
    public double dist(IVec2I iVec2I) {
        return this.get().dist(iVec2I);
    }

    @Override
    public double dist(double d, double d2) {
        return this.get().dist(d, d2);
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist(iVec2I);
    }

    @Override
    public IDoubleR dist(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDoubleR(new Dist(this.op, iVec2I));
    }

    @Override
    public double dist2(IVec2I iVec2I) {
        return this.get().dist2(iVec2I);
    }

    @Override
    public double dist2(double d, double d2) {
        return this.get().dist2(d, d2);
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.dist2(iVec2I);
    }

    @Override
    public IDoubleR dist2(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDoubleR(new Dist2(this.op, iVec2I));
    }

    @Override
    public boolean eq(IVec2I iVec2I) {
        return this.get().eq(iVec2I);
    }

    @Override
    public boolean eq(double d, double d2) {
        return this.get().eq(d, d2);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eq(iVec2I);
    }

    @Override
    public IBoolR eq(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBoolR(new Eq(this.op, iVec2I));
    }

    @Override
    public boolean eq(IVec2I iVec2I, double d) {
        return this.get().eq(iVec2I, d);
    }

    @Override
    public boolean eq(double d, double d2, double d3) {
        return this.get().eq(d, d2, d3);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eq(iVec2I, d);
    }

    @Override
    public IBoolR eq(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBoolR(new Eq(this.op, iVec2I, iDoubleI));
    }

    @Override
    public boolean eqX(IVec2I iVec2I) {
        return this.get().eqX(iVec2I);
    }

    @Override
    public boolean eqY(IVec2I iVec2I) {
        return this.get().eqY(iVec2I);
    }

    @Override
    public boolean eqX(double d) {
        return this.get().eqX(d);
    }

    @Override
    public boolean eqY(double d) {
        return this.get().eqY(d);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqX(iVec2I);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.eqY(iVec2I);
    }

    @Override
    public IBoolR eqX(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBoolR(new EqX(this.op, iVec2I));
    }

    @Override
    public IBoolR eqY(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IBoolR(new EqY(this.op, iVec2I));
    }

    @Override
    public boolean eqX(IVec2I iVec2I, double d) {
        return this.get().eqX(iVec2I, d);
    }

    @Override
    public boolean eqY(IVec2I iVec2I, double d) {
        return this.get().eqY(iVec2I, d);
    }

    @Override
    public boolean eqX(double d, double d2) {
        return this.get().eqX(d, d2);
    }

    @Override
    public boolean eqY(double d, double d2) {
        return this.get().eqY(d, d2);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqX(iVec2I, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVec2I iVec2I, double d) {
        return this.eqY(iVec2I, d);
    }

    @Override
    public IBoolR eqX(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBoolR(new EqX(this.op, iVec2I, iDoubleI));
    }

    @Override
    public IBoolR eqY(ISwitchR iSwitchR, IVec2I iVec2I, IDoubleI iDoubleI) {
        return new IBoolR(new EqY(this.op, iVec2I, iDoubleI));
    }

    @Override
    public double angle(IVec2I iVec2I) {
        return this.get().angle(iVec2I);
    }

    @Override
    public double angle(double d, double d2) {
        return this.get().angle(d, d2);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVec2I iVec2I) {
        return this.angle(iVec2I);
    }

    @Override
    public IDoubleR angle(ISwitchR iSwitchR, IVec2I iVec2I) {
        return new IDoubleR(new Angle(this.op, iVec2I));
    }

    @Override
    public IVec2R rot(double d) {
        this.op = new Rot(this.op, new IDouble(d));
        return this;
    }

    @Override
    public IVec2R rot(IDoubleI iDoubleI) {
        this.op = new Rot(this.op, iDoubleI);
        return this;
    }

    @Override
    public IVec2R rot(IVec2I iVec2I, double d) {
        if (iVec2I == this) {
            return this;
        }
        return this.sub(iVec2I).rot(d).add(iVec2I);
    }

    @Override
    public IVec2R rot(double d, double d2, double d3) {
        return this.rot((IVec2I)new IVec2(d, d2), d3);
    }

    @Override
    public IVec2R rot(IVec2I iVec2I, IDoubleI iDoubleI) {
        if (iVec2I == this) {
            return this;
        }
        return this.sub(iVec2I).rot(iDoubleI).add(iVec2I);
    }

    @Override
    public IVec2R rot(IVec2I iVec2I) {
        return this.rot(this.angle(iVec2I));
    }

    @Override
    public IVec2R rot(IVec2I iVec2I, IVec2I iVec2I2) {
        if (iVec2I == this) {
            return this;
        }
        return this.sub(iVec2I).rot(iVec2I2.diff(iVec2I)).add(iVec2I);
    }

    @Override
    public IVec2R scale(double d) {
        return this.mul(d);
    }

    @Override
    public IVec2R scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public IVec2R scale(IVec2I iVec2I, double d) {
        if (iVec2I == this) {
            return this;
        }
        return this.sub(iVec2I).mul(d).add(iVec2I);
    }

    @Override
    public IVec2R scale(double d, double d2, double d3) {
        return this.scale((IVec2I)new IVec2(d, d2), d3);
    }

    @Override
    public IVec2R scale(IVec2I iVec2I, IDoubleI iDoubleI) {
        if (iVec2I == this) {
            return this;
        }
        return this.sub(iVec2I).mul(iDoubleI).add(iVec2I);
    }

    @Override
    public IVec2R ref(IVec2I iVec2I) {
        this.op = new Ref(this.op, iVec2I);
        return this;
    }

    @Override
    public IVec2R ref(double d, double d2) {
        return this.ref(new IVec2(d, d2));
    }

    @Override
    public IVec2R ref(IVec2I iVec2I, IVec2I iVec2I2) {
        if (iVec2I == this) {
            return this;
        }
        return this.sub(iVec2I).ref(iVec2I2).add(iVec2I);
    }

    @Override
    public IVec2R ref(double d, double d2, double d3, double d4) {
        return this.ref(new IVec2(d, d2), new IVec2(d3, d4));
    }

    @Override
    public IVec2R mirror(IVec2I iVec2I) {
        return this.ref(iVec2I);
    }

    @Override
    public IVec2R mirror(double d, double d2) {
        return this.ref(d, d2);
    }

    @Override
    public IVec2R mirror(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.ref(iVec2I, iVec2I2);
    }

    @Override
    public IVec2R mirror(double d, double d2, double d3, double d4) {
        return this.ref(d, d2, d3, d4);
    }

    @Override
    public IVec2R transform(IVec2I iVec2I, IVec2I iVec2I2) {
        this.op = new TransformVec2(this.op, iVec2I, iVec2I2);
        return this;
    }

    @Override
    public IVec2R transform(IVec2I iVec2I, IVec2I iVec2I2, IVec2I iVec2I3) {
        this.op = new TransformVec3(this.op, iVec2I, iVec2I2, iVec2I3);
        return this;
    }

    @Override
    public IVec2R dif(IVec2I iVec2I) {
        return this.dup().sub(iVec2I);
    }

    @Override
    public IVec2R dif(double d, double d2) {
        return this.dup().sub(new IVec2(d, d2));
    }

    @Override
    public IVec2R diff(IVec2I iVec2I) {
        return this.dif(iVec2I);
    }

    @Override
    public IVec2R diff(double d, double d2) {
        return this.dif(d, d2);
    }

    @Override
    public IVec2R mid(IVec2I iVec2I) {
        return this.dup().add(iVec2I).div(2.0);
    }

    @Override
    public IVec2R mid(double d, double d2) {
        return this.dup().add(new IVec2(d, d2)).div(2.0);
    }

    @Override
    public IVec2R sum(IVec2I iVec2I) {
        return this.dup().add(iVec2I);
    }

    @Override
    public IVec2R sum(double d, double d2) {
        return this.dup().add(new IVec2(d, d2));
    }

    @Override
    public IVec2R sum(IVec2I ... iVec2IArray) {
        IVec2R iVec2R = this.dup();
        for (IVec2I iVec2I : iVec2IArray) {
            iVec2R.add(iVec2I);
        }
        return iVec2R;
    }

    @Override
    public IVec2R bisect(IVec2I iVec2I) {
        return this.dup().unit().add(iVec2I.dup().unit());
    }

    @Override
    public IVec2R bisect(double d, double d2) {
        return this.dup().unit().add(new IVec2R(d, d2).unit());
    }

    @Override
    public IVec2R sum(IVec2I iVec2I, double d, double d2) {
        return this.sum(iVec2I, new IDouble(d), new IDouble(d2));
    }

    @Override
    public IVec2R sum(IVec2I iVec2I, double d) {
        return this.sum(iVec2I, new IDouble(d));
    }

    @Override
    public IVec2R sum(IVec2I iVec2I, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.dup().mul(iDoubleI).add(iVec2I, iDoubleI2);
    }

    @Override
    public IVec2R sum(IVec2I iVec2I, IDoubleI iDoubleI) {
        return this.dup().mul(new IDouble(1.0).sub(iDoubleI)).add(iVec2I, iDoubleI);
    }

    @Override
    public IVecR nml(IVec2I iVec2I) {
        return this.cross(iVec2I);
    }

    @Override
    public IVecR nml(double d, double d2) {
        return this.cross(d, d2);
    }

    @Override
    public IVecR nml(IVec2I iVec2I, IVec2I iVec2I2) {
        return this.dif(iVec2I).cross(this.dif(iVec2I2));
    }

    @Override
    public IVecR nml(double d, double d2, double d3, double d4) {
        return this.dif(d, d2).cross(this.dif(d3, d4));
    }

    @Override
    public boolean isValid() {
        return this.get().isValid();
    }

    public static class TransformVec3
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IVec2Op xvec;
        public IVec2Op yvec;
        public IVec2Op translate;

        public TransformVec3(IVec2Op iVec2Op, IVec2Op iVec2Op2, IVec2Op iVec2Op3, IVec2Op iVec2Op4) {
            this.v = iVec2Op;
            this.xvec = iVec2Op2;
            this.yvec = iVec2Op3;
            this.translate = iVec2Op4;
        }

        @Override
        public IVec2 get() {
            return this.v.get().transform(this.xvec.get(), this.yvec.get(), this.translate.get());
        }
    }

    public static class TransformVec2
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IVec2Op xvec;
        public IVec2Op yvec;

        public TransformVec2(IVec2Op iVec2Op, IVec2Op iVec2Op2, IVec2Op iVec2Op3) {
            this.v = iVec2Op;
            this.xvec = iVec2Op2;
            this.yvec = iVec2Op3;
        }

        @Override
        public IVec2 get() {
            return this.v.get().transform(this.xvec.get(), this.yvec.get());
        }
    }

    public static class Ref
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IVec2Op lineDir;

        public Ref(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v = iVec2Op;
            this.lineDir = iVec2Op2;
        }

        @Override
        public IVec2 get() {
            return this.v.get().ref(this.lineDir.get());
        }
    }

    public static class EqY
    extends IParameterObject
    implements IBoolOp {
        public IVec2Op v1;
        public IVec2Op v2;
        public IDoubleOp tolerance = null;

        public EqY(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        public EqY(IVec2Op iVec2Op, IVec2Op iVec2Op2, IDoubleOp iDoubleOp) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eqY(this.v2.get());
            }
            return this.v1.get().eqY(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eqY((ISwitchR)null, (IVec2I)this.v2.get());
            }
            return this.v1.get().eqY((ISwitchR)null, (IVec2I)this.v2.get(), this.tolerance.get());
        }
    }

    public static class EqX
    extends IParameterObject
    implements IBoolOp {
        public IVec2Op v1;
        public IVec2Op v2;
        public IDoubleOp tolerance = null;

        public EqX(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        public EqX(IVec2Op iVec2Op, IVec2Op iVec2Op2, IDoubleOp iDoubleOp) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eqX(this.v2.get());
            }
            return this.v1.get().eqX(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eqX((ISwitchR)null, (IVec2I)this.v2.get());
            }
            return this.v1.get().eqX((ISwitchR)null, (IVec2I)this.v2.get(), this.tolerance.get());
        }
    }

    public static class Eq
    extends IParameterObject
    implements IBoolOp {
        public IVec2Op v1;
        public IVec2Op v2;
        public IDoubleOp tolerance = null;

        public Eq(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        public Eq(IVec2Op iVec2Op, IVec2Op iVec2Op2, IDoubleOp iDoubleOp) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
            this.tolerance = iDoubleOp;
        }

        @Override
        public boolean x() {
            if (this.tolerance == null) {
                return this.v1.get().eq(this.v2.get());
            }
            return this.v1.get().eq(this.v2.get(), this.tolerance.x());
        }

        @Override
        public IBool get() {
            if (this.tolerance == null) {
                return this.v1.get().eq((ISwitchR)null, (IVec2I)this.v2.get());
            }
            return this.v1.get().eq((ISwitchR)null, (IVec2I)this.v2.get(), this.tolerance.get());
        }
    }

    public static class Dist2
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v1;
        public IVec2Op v2;

        public Dist2(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public double x() {
            return this.v1.get().dist2(this.v2.get());
        }

        @Override
        public IDouble get() {
            return this.v1.get().dist2((ISwitchR)null, (IVec2I)this.v2.get());
        }
    }

    public static class Dist
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v1;
        public IVec2Op v2;

        public Dist(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public double x() {
            return this.v1.get().dist(this.v2.get());
        }

        @Override
        public IDouble get() {
            return this.v1.get().dist((ISwitchR)null, (IVec2I)this.v2.get());
        }
    }

    public static class SetLen
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IDoubleOp l;

        public SetLen(IVec2Op iVec2Op, IDoubleOp iDoubleOp) {
            this.v = iVec2Op;
            this.l = iDoubleOp;
        }

        @Override
        public IVec2 get() {
            return this.v.get().len(this.l.x());
        }
    }

    public static class Ortho
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;

        public Ortho(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public IVec2 get() {
            return this.v.get().ortho();
        }
    }

    public static class Unit
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;

        public Unit(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public IVec2 get() {
            return this.v.get().unit();
        }
    }

    public static class Y
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v;

        public Y(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public double x() {
            return this.v.get().y;
        }

        @Override
        public IDouble get() {
            return this.v.get().getY();
        }
    }

    public static class X
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v;

        public X(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public double x() {
            return this.v.get().x;
        }

        @Override
        public IDouble get() {
            return this.v.get().getX();
        }
    }

    public static class Len2
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v;

        public Len2(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public double x() {
            return this.v.get().len2();
        }

        @Override
        public IDouble get() {
            return this.v.get().len2((ISwitchR)null);
        }
    }

    public static class Len
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v;

        public Len(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public double x() {
            return this.v.get().len();
        }

        @Override
        public IDouble get() {
            return this.v.get().len((ISwitchR)null);
        }
    }

    public static class FromXY
    extends IParameterObject
    implements IVec2Op {
        public IDoubleOp x;
        public IDoubleOp y;

        public FromXY(IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.x = iDoubleOp;
            this.y = iDoubleOp2;
        }

        @Override
        public IVec2 get() {
            return new IVec2(this.x.x(), this.y.x());
        }
    }

    public static class Rot
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IDoubleOp angle;

        public Rot(IVec2Op iVec2Op, IDoubleOp iDoubleOp) {
            this.v = iVec2Op;
            this.angle = iDoubleOp;
        }

        @Override
        public IVec2 get() {
            return this.v.get().rot(this.angle.x());
        }
    }

    public static class Angle
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v1;
        public IVec2Op v2;

        public Angle(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public double x() {
            return this.v1.get().angle(this.v2.get());
        }

        @Override
        public IDouble get() {
            return this.v1.get().angle((ISwitchR)null, (IVec2I)this.v2.get());
        }
    }

    public static class Cross
    extends IParameterObject
    implements IVecOp {
        public IVec2Op v1;
        public IVec2Op v2;

        public Cross(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public IVec get() {
            return this.v1.get().cross(this.v2.get());
        }
    }

    public static class Dot
    extends IParameterObject
    implements IDoubleOp {
        public IVec2Op v1;
        public IVec2Op v2;

        public Dot(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public double x() {
            return this.v1.get().dot(this.v2.get());
        }

        @Override
        public IDouble get() {
            return this.v1.get().dot((ISwitchR)null, (IVec2I)this.v2.get());
        }
    }

    public static class Neg
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;

        public Neg(IVec2Op iVec2Op) {
            this.v = iVec2Op;
        }

        @Override
        public IVec2 get() {
            return this.v.get().neg();
        }
    }

    public static class Div
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IDoubleOp d;

        public Div(IVec2Op iVec2Op, IDoubleOp iDoubleOp) {
            this.v = iVec2Op;
            this.d = iDoubleOp;
        }

        @Override
        public IVec2 get() {
            return this.v.get().div(this.d.x());
        }
    }

    public static class Mul
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v;
        public IDoubleOp d;

        public Mul(IVec2Op iVec2Op, IDoubleOp iDoubleOp) {
            this.v = iVec2Op;
            this.d = iDoubleOp;
        }

        @Override
        public IVec2 get() {
            return this.v.get().mul(this.d.x());
        }
    }

    public static class Sub
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v1;
        public IVec2Op v2;

        public Sub(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public IVec2 get() {
            return this.v1.get().sub(this.v2.get());
        }
    }

    public static class Add
    extends IParameterObject
    implements IVec2Op {
        public IVec2Op v1;
        public IVec2Op v2;

        public Add(IVec2Op iVec2Op, IVec2Op iVec2Op2) {
            this.v1 = iVec2Op;
            this.v2 = iVec2Op2;
        }

        @Override
        public IVec2 get() {
            return this.v1.get().add(this.v2.get());
        }
    }

    public static class ToVec2
    extends IParameterObject
    implements IVec2Op {
        public IVecOp v;

        public ToVec2(IVecOp iVecOp) {
            this.v = iVecOp;
        }

        @Override
        public IVec2 get() {
            return new IVec2(this.v.get());
        }
    }

    public static class ToVec4
    extends IParameterObject
    implements IVec4Op {
        public IVec2Op v;
        public IDoubleOp z;
        public IDoubleOp w;

        public ToVec4(IVec2Op iVec2Op) {
            this.v = iVec2Op;
            this.z = new IDouble(0.0);
            this.w = new IDouble(1.0);
        }

        public ToVec4(IVec2Op iVec2Op, IDoubleOp iDoubleOp, IDoubleOp iDoubleOp2) {
            this.v = iVec2Op;
            this.z = iDoubleOp;
            this.w = iDoubleOp2;
        }

        @Override
        public IVec4 get() {
            IVec2 iVec2 = this.v.get();
            return new IVec4(iVec2.x, iVec2.y, this.z.x(), this.w.x());
        }
    }

    public static class ToVec3
    extends IParameterObject
    implements IVecOp {
        public IVec2Op v;
        public IDoubleOp z;

        public ToVec3(IVec2Op iVec2Op) {
            this.v = iVec2Op;
            this.z = new IDouble(0.0);
        }

        public ToVec3(IVec2Op iVec2Op, IDoubleOp iDoubleOp) {
            this.v = iVec2Op;
            this.z = iDoubleOp;
        }

        @Override
        public IVec get() {
            IVec2 iVec2 = this.v.get();
            return new IVec(iVec2.x, iVec2.y, this.z.x());
        }
    }
}

