/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IGraphicI;
import igeo.IObject;
import igeo.ISubobject;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import java.awt.Color;

public abstract class IGraphicObject
implements ISubobject,
IGraphicI {
    public static float defaultRed = 0.5f;
    public static float defaultGreen = 0.5f;
    public static float defaultBlue = 0.5f;
    public static float defaultAlpha = 1.0f;
    static int colorRange1i = 255;
    static int colorRange2i = 255;
    static int colorRange3i = 255;
    static int colorRange4i = 255;
    static float colorRange1f = 1.0f;
    static float colorRange2f = 1.0f;
    static float colorRange3f = 1.0f;
    static float colorRange4f = 1.0f;
    public static double transparentModeAlpha = 0.4;
    public Color color;
    public boolean visible = true;
    public IObject parent;
    public boolean update = false;

    public IGraphicObject(IObject iObject) {
        this.parent = iObject;
    }

    @Override
    public IObject parent() {
        return this.parent;
    }

    @Override
    public ISubobject parent(IObject iObject) {
        this.parent = iObject;
        return this;
    }

    @Override
    public abstract void draw(IGraphics var1);

    @Override
    public abstract boolean isDrawable(IGraphicMode var1);

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean visible() {
        return this.visible;
    }

    public void hide() {
        this.visible = false;
        if (this.parent != null && this.parent.server != null) {
            this.parent.server.updateState();
        }
    }

    public void show() {
        this.visible = true;
        if (this.parent != null && this.parent.server != null) {
            this.parent.server.updateState();
        }
    }

    public void update() {
        this.update = true;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color, int n) {
        this.setColor(IGraphicObject.getColor(color, n));
    }

    public void setColor(int n) {
        this.setColor(IGraphicObject.getColor(n));
    }

    public void setColor(float f) {
        this.setColor(IGraphicObject.getColor(f));
    }

    public void setColor(int n, int n2) {
        this.setColor(IGraphicObject.getColor(n, n2));
    }

    public void setColor(float f, float f2) {
        this.setColor(IGraphicObject.getColor(f, f2));
    }

    public void setColor(int n, int n2, int n3) {
        this.setColor(IGraphicObject.getColor(n, n2, n3));
    }

    public void setColor(float f, float f2, float f3) {
        this.setColor(IGraphicObject.getColor(f, f2, f3));
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.setColor(IGraphicObject.getColor(n, n2, n3, n4));
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.setColor(IGraphicObject.getColor(f, f2, f3, f4));
    }

    public void setHSBColor(float f, float f2, float f3, float f4) {
        this.setColor(IGraphicObject.getHSBColor(f, f2, f3, f4));
    }

    public void setHSBColor(float f, float f2, float f3) {
        this.setColor(IGraphicObject.getHSBColor(f, f2, f3));
    }

    public static Color getColor(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n < 0 ? 0 : (n > 255 ? 255 : n));
    }

    public static Color getColor(int n) {
        if (colorRange1i == 255) {
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            return new Color(n, n, n);
        }
        float f = (float)n / (float)colorRange1i;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return new Color(f, f, f);
    }

    public static Color getColor(float f) {
        if ((f /= colorRange1f) < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return new Color(f, f, f);
    }

    public static Color getColor(int n, int n2) {
        if (colorRange1i == 255 && colorRange4i == 255) {
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            return new Color(n, n, n, n2);
        }
        float f = (float)n / (float)colorRange1i;
        float f2 = (float)n2 / (float)colorRange4i;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return new Color(f, f, f, f2);
    }

    public static Color getColor(float f, float f2) {
        f /= colorRange1f;
        f2 /= colorRange4f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return new Color(f, f, f, f2);
    }

    public static Color getColor(int n, int n2, int n3) {
        if (colorRange1i == 255 && colorRange2i == 255 && colorRange3i == 255) {
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            return new Color(n, n2, n3);
        }
        float f = (float)n / (float)colorRange1i;
        float f2 = (float)n2 / (float)colorRange2i;
        float f3 = (float)n3 / (float)colorRange3i;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return new Color(f, f2, f3);
    }

    public static Color getColor(float f, float f2, float f3) {
        f /= colorRange1f;
        f2 /= colorRange2f;
        f2 /= colorRange3f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return new Color(f, f2, f3);
    }

    public static Color getColor(int n, int n2, int n3, int n4) {
        if (colorRange1i == 255 && colorRange2i == 255 && colorRange3i == 255 && colorRange4i == 255) {
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            return new Color(n, n2, n3, n4);
        }
        float f = (float)n / (float)colorRange1i;
        float f2 = (float)n2 / (float)colorRange2i;
        float f3 = (float)n3 / (float)colorRange3i;
        float f4 = (float)n3 / (float)colorRange4i;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        return new Color(f, f2, f3, f4);
    }

    public static Color getColor(float f, float f2, float f3, float f4) {
        f /= colorRange1f;
        f2 /= colorRange2f;
        f2 /= colorRange3f;
        f4 /= colorRange4f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        return new Color(f, f2, f3, f4);
    }

    public static Color getHSBColor(float f, float f2, float f3, float f4) {
        int n = Color.HSBtoRGB(f, f2, f3);
        int n2 = (int)(f4 * 255.0f);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        return new Color(n >>> 16 & 0xFF, n >>> 8 & 0xFF, n & 0xFF, n2);
    }

    public static Color getHSBColor(float f, float f2, float f3) {
        return new Color(Color.HSBtoRGB(f, f2, f3));
    }
}

