/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IComparator;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.IDynamicServer;
import igeo.IDynamicsBase;
import igeo.IG;
import igeo.ILayer;
import igeo.IObject;
import igeo.IOut;
import igeo.IParticleAgent;
import igeo.IParticleI;
import igeo.IParticleOnCurveAgent;
import igeo.IParticleOnCurveI;
import igeo.IServer;
import igeo.ISort;
import igeo.ISpacingEqualizer;
import igeo.IStraightenerCurve;
import igeo.ITensionI;
import igeo.ITensionLine;
import igeo.ITensionOnCurve;
import igeo.ITransformable;
import igeo.IVec;
import igeo.IVecI;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ITensileNet {
    public static double friction = 0.005;
    public static double tension = 1.0;
    public static double onRailTension = 1.0;
    public static double straightenerTension = 1.0;
    public static double equalizerTension = 1.0;
    public static boolean constantTension = false;
    public static double tolerance = IConfig.tolerance;
    public static double railTolerance = IConfig.tolerance;
    public static Color pointColor = new Color(255, 255, 255);
    public static Color railPointColor = new Color(192, 192, 192);
    public static Color fixedPointColor = new Color(255, 255, 0);
    public static Color straightenerColor = new Color(255, 128, 0);
    public static String pointLayer = "nodes";
    public static String fixedPointLayer = "fixedNodes";
    public static String straightenerLayer = "straightener";
    public static String equalizerLayer = "equalizer";
    public static boolean fixOpenLinePoint = true;
    public static boolean deleteInputLine = true;
    public static boolean tensionOnSameRail = true;
    public static boolean fixPointOnRailEnd = true;
    public static boolean fixPointNotOnRail = true;
    public static boolean straightener = false;
    public static double straightenerThresholdAngle = 1.0471975511965976;
    public static boolean removeBranchStraightener = true;
    public static boolean spacingEqualizer = false;
    public static Class<? extends IParticleI> particleClass = null;
    public static Class<? extends ITensionI> tensionClass = null;
    public static Class<? extends IParticleOnCurveI> particleOnCurveClass = null;
    public static Constructor<? extends IParticleI> particleConstructor;
    public static Class<?>[] particleConstructorParameters;
    public static Constructor<? extends ITensionI> tensionConstructor;
    public static Class<?>[] tensionConstructorParameters;
    public static Constructor<? extends IParticleOnCurveI> particleOnCurveConstructor;
    public static Class<?>[] particleOnCurveConstructorParameters;
    public ArrayList<ITensionI> links;
    public ArrayList<IParticleI> nodes;

    public static void friction(double d) {
        friction = d;
    }

    public static void fric(double d) {
        ITensileNet.friction(d);
    }

    public static void tension(double d) {
        tension = d;
    }

    public static void onRailTension(double d) {
        onRailTension = d;
    }

    public static void straightenerTension(double d) {
        straightenerTension = d;
    }

    public static void equalizerTension(double d) {
        equalizerTension = d;
    }

    public static void constantTension(boolean bl) {
        constantTension = bl;
    }

    public static void enableConstantTension() {
        constantTension = true;
    }

    public static void disableConstantTension() {
        constantTension = false;
    }

    public static void tolerance(double d) {
        tolerance = d;
    }

    public static void railTolerance(double d) {
        railTolerance = d;
    }

    public static void pointColor(Color color) {
        pointColor = color;
    }

    public static void railPointColor(Color color) {
        railPointColor = color;
    }

    public static void fixedPointColor(Color color) {
        fixedPointColor = color;
    }

    public static void straightenerColor(Color color) {
        straightenerColor = color;
    }

    public static void pointLayer(String string) {
        pointLayer = string;
    }

    public static void fixedPointLayer(String string) {
        fixedPointLayer = string;
    }

    public static void straightenerLayer(String string) {
        straightenerLayer = string;
    }

    public static void equalizerLayer(String string) {
        equalizerLayer = string;
    }

    public static void fixOpenLinePoint(boolean bl) {
        fixOpenLinePoint = bl;
    }

    public static void enableFixOpenLinePoint() {
        fixOpenLinePoint = true;
    }

    public static void disableFixOpenLinePoint() {
        fixOpenLinePoint = false;
    }

    public static void deleteInputLine(boolean bl) {
        deleteInputLine = bl;
    }

    public static void enableDeleteInputLine() {
        deleteInputLine = true;
    }

    public static void disableDeleteInputLine() {
        deleteInputLine = false;
    }

    public static void tensionOnSameRail(boolean bl) {
        tensionOnSameRail = bl;
    }

    public static void enableTensionOnSameRail() {
        tensionOnSameRail = true;
    }

    public static void disableTensionOnSameRail() {
        tensionOnSameRail = false;
    }

    public static void fixPointOnRailEnd(boolean bl) {
        fixPointOnRailEnd = bl;
    }

    public static void enableFixPointOnRailEnd() {
        fixPointOnRailEnd = true;
    }

    public static void disableFixPointOnRailEnd() {
        fixPointOnRailEnd = false;
    }

    public static void fixPointNotOnRail(boolean bl) {
        fixPointNotOnRail = bl;
    }

    public static void enableFixPointNotOnRail(boolean bl) {
        fixPointNotOnRail = true;
    }

    public static void disableFixPointNotOnRail(boolean bl) {
        fixPointNotOnRail = false;
    }

    public static void straightener(boolean bl) {
        straightener = bl;
    }

    public static void enableStraightener() {
        straightener = true;
    }

    public static void disableStraightener() {
        straightener = false;
    }

    public static void straightenerThresholdAngle(double d) {
        straightenerThresholdAngle = d;
    }

    public static void removeBranchStraightener(boolean bl) {
        removeBranchStraightener = bl;
    }

    public static void enableRemoveBranchStraightener() {
        removeBranchStraightener = true;
    }

    public static void disableRemoveBranchStraightener() {
        removeBranchStraightener = false;
    }

    public static void spacingEqualizer(boolean bl) {
        spacingEqualizer = bl;
    }

    public static void enableSpacingEqualizer() {
        spacingEqualizer = true;
    }

    public static void disableSpacingEqualizer() {
        spacingEqualizer = false;
    }

    public static void particleClass(Class<? extends IParticleI> clazz) {
        particleClass = clazz;
    }

    public static void tensionClass(Class<? extends ITensionI> clazz) {
        tensionClass = clazz;
    }

    public static void particleOnCurveClass(Class<? extends IParticleOnCurveI> clazz) {
        particleOnCurveClass = clazz;
    }

    public static void particleConstructor(Constructor<? extends IParticleI> constructor) {
        particleConstructor = constructor;
    }

    public static void particleConstructorParameters(Class<?>[] classArray) {
        particleConstructorParameters = classArray;
    }

    public static void tensionConstructor(Constructor<? extends ITensionI> constructor) {
        tensionConstructor = constructor;
    }

    public static void tensionConstructorParameters(Class<?>[] classArray) {
        tensionConstructorParameters = classArray;
    }

    public static void particleOnCurveConstructor(Constructor<? extends IParticleOnCurveI> constructor) {
        particleOnCurveConstructor = constructor;
    }

    public static void particleOnCurveConstructorParameters(Class<?>[] classArray) {
        particleOnCurveConstructorParameters = classArray;
    }

    public ITensileNet() {
    }

    public ITensileNet(ArrayList<ITensionI> arrayList, ArrayList<IParticleI> arrayList2) {
        this.links = arrayList;
        this.nodes = arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, IVecI[] iVecIArray) {
        int n;
        Object object;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray = new IVec[iCurveIArray.length][2];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iVecArray[i][0] = iCurveIArray[i].start().get();
            iVecArray[i][1] = iCurveIArray[i].end().get();
        }
        Color[] colorArray = new Color[iCurveIArray.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray.length];
        IServer iServer = null;
        for (n3 = 0; n3 < iCurveIArray.length; ++n3) {
            if (!(iCurveIArray[n3] instanceof IObject)) continue;
            colorArray[n3] = ((IObject)((Object)iCurveIArray[n3])).clr();
            iLayerArray[n3] = ((IObject)((Object)iCurveIArray[n3])).layer();
            if (iServer == null) {
                iServer = ((IObject)((Object)iCurveIArray[n3])).server();
            }
            if (!deleteInputLine) continue;
            ((IObject)((Object)iCurveIArray[n3])).del();
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray.length; ++n3) {
            IVec[] iVecArray2 = iVecArray[n3];
            if (iVecArray2[1].eq(iVecArray2[0], tolerance)) {
                iVecArray[n3] = null;
                continue;
            }
            for (n2 = n3 + 1; n2 < iVecArray.length; ++n2) {
                object = iVecArray[n2];
                for (n = 0; n < 2; ++n) {
                    if (object[n].eq(iVecArray2[0], tolerance)) {
                        object[n] = iVecArray2[0];
                        continue;
                    }
                    if (!object[n].eq(iVecArray2[1], tolerance)) continue;
                    object[n] = iVecArray2[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray.length; ++i) {
            if (iVecArray[i] == null) continue;
            for (n2 = 0; n2 < 2; ++n2) {
                object = iVecArray[i][n2];
                if (arrayList.contains(object)) continue;
                arrayList.add((IVec[])object);
            }
        }
        if (fixOpenLinePoint) {
            ArrayList arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray.length; ++n) {
                    if (iVecArray[n] == null) continue;
                    if (iVecArray[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
            if (iVecIArray != null) {
                for (n2 = 0; n2 < iVecIArray.length; ++n2) {
                    arrayList2.add(iVecIArray[n2]);
                }
            }
            iVecIArray = arrayList2.toArray(new IVecI[arrayList2.size()]);
        }
        if (particleClass != null) {
            ITensileNet.searchParticleConstructor(particleClass);
        }
        if (tensionClass != null) {
            ITensileNet.searchTensionConstructor(tensionClass);
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            ITransformable iTransformable;
            Object object2;
            IParticleI iParticleI;
            Object object3;
            ArrayList<IParticleI> arrayList3 = new ArrayList<IParticleI>();
            for (n = 0; n < arrayList.size(); ++n) {
                IParticleI iParticleI2 = null;
                if (particleConstructor != null && particleConstructorParameters != null && (iParticleI2 = ITensileNet.getParticleInstance((IVec)arrayList.get(n))) != null) {
                    iParticleI2.fric(friction);
                    if (iParticleI2 instanceof IObject) {
                        ((IObject)((Object)iParticleI2)).clr(pointColor);
                        if (pointLayer != null) {
                            ((IObject)((Object)iParticleI2)).layer(IG.layer(pointLayer).clr(pointColor));
                        }
                    }
                    arrayList3.add(iParticleI2);
                }
                if (iParticleI2 != null) continue;
                object3 = new IParticleAgent((IVec)arrayList.get(n));
                ((IParticleAgent)object3).fric(friction);
                ((IParticleAgent)object3).clr(pointColor);
                arrayList3.add((IParticleI)object3);
                if (pointLayer == null) continue;
                ((IParticleAgent)object3).layer(IG.layer(pointLayer).clr(pointColor));
            }
            if (iVecIArray != null) {
                for (n = 0; n < iVecIArray.length; ++n) {
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        if (!iVecIArray[n].eq(arrayList3.get(i), tolerance)) continue;
                        arrayList3.get(i).fix();
                        if (!(arrayList3.get(i) instanceof IObject)) continue;
                        object3 = (IObject)((Object)arrayList3.get(i));
                        ((IObject)object3).clr(fixedPointColor);
                        if (fixedPointLayer == null) continue;
                        ((IObject)object3).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                    }
                }
            }
            ArrayList<ITensionI> arrayList4 = new ArrayList<ITensionI>();
            for (int i = 0; i < iVecArray.length; ++i) {
                object3 = iVecArray[i];
                if (object3 == null) continue;
                int n5 = arrayList.indexOf(object3[0]);
                int n6 = arrayList.indexOf(object3[1]);
                if (n5 >= 0 && n6 >= 0) {
                    IParticleI iParticleI3 = arrayList3.get(n5);
                    iParticleI = arrayList3.get(n6);
                    object2 = null;
                    if (tensionConstructor != null && tensionConstructorParameters != null && (object2 = ITensileNet.getTensionInstance(iParticleI3, iParticleI)) != null) {
                        if (object2 instanceof IObject) {
                            if (colorArray[i] != null) {
                                ((IObject)object2).clr(colorArray[i]);
                            }
                            if (iLayerArray[i] != null) {
                                ((IObject)object2).layer(iLayerArray[i]);
                            }
                        }
                        object2.tension(tension);
                        object2.constant(constantTension);
                        arrayList4.add((ITensionI)object2);
                    }
                    if (object2 != null) continue;
                    iTransformable = new ITensionLine(iParticleI3, iParticleI, tension);
                    if (colorArray[i] != null) {
                        ((ICurve)iTransformable).clr(colorArray[i]);
                    }
                    if (iLayerArray[i] != null) {
                        ((ICurve)iTransformable).layer(iLayerArray[i]);
                    }
                    ((ITensionLine)iTransformable).tension(tension);
                    ((ITensionLine)iTransformable).constant(constantTension);
                    arrayList4.add((ITensionI)((Object)iTransformable));
                    continue;
                }
                IOut.err("end point is not found");
            }
            if (straightener) {
                Object object4;
                IParticleI iParticleI4;
                int n7;
                ArrayList<IStraightenerCurve> arrayList5 = new ArrayList<IStraightenerCurve>();
                for (n7 = 0; n7 < arrayList4.size(); ++n7) {
                    IParticleI iParticleI5 = arrayList4.get(n7).pt(0);
                    IParticleI iParticleI6 = arrayList4.get(n7).pt(1);
                    for (int i = n7 + 1; i < arrayList4.size(); ++i) {
                        iParticleI = arrayList4.get(i).pt(0);
                        object2 = arrayList4.get(i).pt(1);
                        iTransformable = null;
                        iParticleI4 = null;
                        object4 = null;
                        if (iParticleI5 == iParticleI) {
                            iTransformable = iParticleI6;
                            iParticleI4 = iParticleI5;
                            object4 = object2;
                        } else if (iParticleI5 == object2) {
                            iTransformable = iParticleI6;
                            iParticleI4 = iParticleI5;
                            object4 = iParticleI;
                        } else if (iParticleI6 == iParticleI) {
                            iTransformable = iParticleI5;
                            iParticleI4 = iParticleI6;
                            object4 = object2;
                        } else if (iParticleI6 == object2) {
                            iTransformable = iParticleI5;
                            iParticleI4 = iParticleI6;
                            object4 = iParticleI;
                        }
                        if (iTransformable == null || iParticleI4 == null || object4 == null || !(Math.abs(iParticleI4.pos().diff(iTransformable.pos()).angle(object4.pos().diff(iParticleI4.pos()))) < straightenerThresholdAngle)) continue;
                        IStraightenerCurve iStraightenerCurve = new IStraightenerCurve((IParticleI)iTransformable, iParticleI4, (IParticleI)object4);
                        iStraightenerCurve.tension(straightenerTension);
                        iStraightenerCurve.clr(straightenerColor);
                        iStraightenerCurve.layer(IG.layer(straightenerLayer).clr(straightenerColor));
                        arrayList5.add(iStraightenerCurve);
                    }
                }
                if (removeBranchStraightener) {
                    for (n7 = 0; n7 < arrayList5.size(); ++n7) {
                        IParticleI iParticleI7 = ((IStraightenerCurve)arrayList5.get(n7)).pt(0);
                        IParticleI iParticleI8 = ((IStraightenerCurve)arrayList5.get(n7)).pt(1);
                        IParticleI iParticleI9 = ((IStraightenerCurve)arrayList5.get(n7)).pt(2);
                        boolean bl = false;
                        for (int i = n7 + 1; i < arrayList5.size() && !bl; ++i) {
                            iTransformable = ((IStraightenerCurve)arrayList5.get(i)).pt(0);
                            iParticleI4 = ((IStraightenerCurve)arrayList5.get(i)).pt(1);
                            object4 = ((IStraightenerCurve)arrayList5.get(i)).pt(2);
                            if (iParticleI8 != iParticleI4 || iParticleI7 != iTransformable && iParticleI7 != object4 && iParticleI9 != iTransformable && iParticleI9 != object4) continue;
                            double d = iParticleI8.pos().diff(iParticleI7.pos()).angle(iParticleI9.pos().diff(iParticleI8.pos()));
                            double d2 = iParticleI4.pos().diff(iTransformable.pos()).angle(object4.pos().diff(iParticleI4.pos()));
                            if (Math.abs(d) < Math.abs(d2)) {
                                ((IStraightenerCurve)arrayList5.get(i)).del();
                                arrayList5.remove(i);
                                --i;
                                continue;
                            }
                            ((IStraightenerCurve)arrayList5.get(n7)).del();
                            arrayList5.remove(n7);
                            --n7;
                            --i;
                            bl = true;
                        }
                    }
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    public static boolean searchParticleConstructor(Class<? extends IParticleI> clazz) {
        if (clazz == null) {
            return false;
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        Constructor<?> constructor4 = null;
        Constructor<?> constructor5 = null;
        Constructor<?> constructor6 = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null) {
                return false;
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray == null || classArray.length == 0) {
                    constructor3 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 1 && IVecI.class.isAssignableFrom(classArray[0])) {
                    constructor2 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && IVecI.class.isAssignableFrom(classArray[0]) && IVecI.class.isAssignableFrom(classArray[1])) {
                    constructor = constructorArray[i];
                    continue;
                }
                if (classArray.length == 1 && !IVecI.class.isAssignableFrom(classArray[0])) {
                    constructor6 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 2 && !IVecI.class.isAssignableFrom(classArray[0]) && IVecI.class.isAssignableFrom(classArray[1])) {
                    constructor5 = constructorArray[i];
                    continue;
                }
                if (classArray.length != 3 || IVecI.class.isAssignableFrom(classArray[0]) || !IVecI.class.isAssignableFrom(classArray[1]) || !IVecI.class.isAssignableFrom(classArray[2])) continue;
                constructor4 = constructorArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (constructor != null) {
            particleConstructor = constructor;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[]{IVecI.class, IVecI.class};
            return true;
        }
        if (constructor2 != null) {
            particleConstructor = constructor2;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[]{IVecI.class};
            return true;
        }
        if (constructor3 != null) {
            particleConstructor = constructor3;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[0];
            return true;
        }
        if (constructor4 != null) {
            particleConstructor = constructor4;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[]{Object.class, IVecI.class, IVecI.class};
            return true;
        }
        if (constructor5 != null) {
            particleConstructor = constructor5;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[]{Object.class, IVecI.class};
            return true;
        }
        if (constructor6 != null) {
            particleConstructor = constructor6;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[]{Object.class};
            return true;
        }
        IOut.err("no matching particle constructor found. it should be like constructor(IVec) or constructor(IVec,IVec)");
        return false;
    }

    public static boolean searchTensionConstructor(Class<? extends ITensionI> clazz) {
        if (clazz == null) {
            return false;
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        Constructor<?> constructor4 = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null) {
                return false;
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length == 2 && IParticleI.class.isAssignableFrom(classArray[0]) && IParticleI.class.isAssignableFrom(classArray[1])) {
                    constructor = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && IParticleI.class.isAssignableFrom(classArray[0]) && IParticleI.class.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2])) {
                    constructor2 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !IParticleI.class.isAssignableFrom(classArray[0]) && IParticleI.class.isAssignableFrom(classArray[1]) && IParticleI.class.isAssignableFrom(classArray[2])) {
                    constructor3 = constructorArray[i];
                    continue;
                }
                if (classArray.length != 4 || IParticleI.class.isAssignableFrom(classArray[0]) || !IParticleI.class.isAssignableFrom(classArray[1]) || !IParticleI.class.isAssignableFrom(classArray[2]) || !Double.TYPE.isAssignableFrom(classArray[3])) continue;
                constructor4 = constructorArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (constructor2 != null) {
            tensionConstructor = constructor2;
            tensionConstructor.setAccessible(true);
            tensionConstructorParameters = new Class[]{IParticleI.class, IParticleI.class, Double.TYPE};
            return true;
        }
        if (constructor != null) {
            tensionConstructor = constructor;
            tensionConstructor.setAccessible(true);
            tensionConstructorParameters = new Class[]{IParticleI.class, IParticleI.class};
            return true;
        }
        if (constructor4 != null) {
            tensionConstructor = constructor4;
            tensionConstructor.setAccessible(true);
            tensionConstructorParameters = new Class[]{Object.class, IParticleI.class, IParticleI.class, Double.TYPE};
            return true;
        }
        if (constructor3 != null) {
            tensionConstructor = constructor3;
            tensionConstructor.setAccessible(true);
            tensionConstructorParameters = new Class[]{Object.class, IParticleI.class, IParticleI.class};
            return true;
        }
        IOut.err("no matching tension constructor found. it should be like constructor(IParticleI,IParticleI,double) or constructor(IParticleI,IParticleI)");
        return false;
    }

    public static boolean searchParticleOnCurveConstructor(Class<? extends IParticleOnCurveI> clazz) {
        if (clazz == null) {
            return false;
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        Constructor<?> constructor4 = null;
        Constructor<?> constructor5 = null;
        Constructor<?> constructor6 = null;
        Constructor<?> constructor7 = null;
        Constructor<?> constructor8 = null;
        try {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null) {
                return false;
            }
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length == 2 && ICurveI.class.isAssignableFrom(classArray[0]) && Double.TYPE.isAssignableFrom(classArray[1])) {
                    constructor = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && ICurveI.class.isAssignableFrom(classArray[0]) && Double.TYPE.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2])) {
                    constructor2 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && !ICurveI.class.isAssignableFrom(classArray[0]) && ICurveI.class.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2])) {
                    constructor3 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !ICurveI.class.isAssignableFrom(classArray[0]) && ICurveI.class.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2]) && Double.TYPE.isAssignableFrom(classArray[3])) {
                    constructor4 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 3 && ICurveI.class.isAssignableFrom(classArray[0]) && Double.TYPE.isAssignableFrom(classArray[1]) && IVec.class.isAssignableFrom(classArray[2])) {
                    constructor5 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && ICurveI.class.isAssignableFrom(classArray[0]) && Double.TYPE.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2]) && Double.TYPE.isAssignableFrom(classArray[3])) {
                    constructor6 = constructorArray[i];
                    continue;
                }
                if (classArray.length == 4 && !ICurveI.class.isAssignableFrom(classArray[0]) && ICurveI.class.isAssignableFrom(classArray[1]) && Double.TYPE.isAssignableFrom(classArray[2]) && Double.TYPE.isAssignableFrom(classArray[3])) {
                    constructor7 = constructorArray[i];
                    continue;
                }
                if (classArray.length != 5 || ICurveI.class.isAssignableFrom(classArray[0]) || !ICurveI.class.isAssignableFrom(classArray[1]) || !Double.TYPE.isAssignableFrom(classArray[2]) || !Double.TYPE.isAssignableFrom(classArray[3]) || !Double.TYPE.isAssignableFrom(classArray[4])) continue;
                constructor8 = constructorArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (constructor6 != null) {
            particleOnCurveConstructor = constructor6;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{ICurveI.class, Double.TYPE, Double.TYPE, IVec.class};
            return true;
        }
        if (constructor5 != null) {
            particleOnCurveConstructor = constructor5;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{ICurveI.class, Double.TYPE, IVec.class};
            return true;
        }
        if (constructor8 != null) {
            particleOnCurveConstructor = constructor8;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{Object.class, ICurveI.class, Double.TYPE, Double.TYPE, IVec.class};
            return true;
        }
        if (constructor7 != null) {
            particleOnCurveConstructor = constructor7;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{Object.class, ICurveI.class, Double.TYPE, IVec.class};
            return true;
        }
        if (constructor2 != null) {
            particleOnCurveConstructor = constructor2;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{ICurveI.class, Double.TYPE, Double.TYPE};
            return true;
        }
        if (constructor != null) {
            particleConstructor = constructor;
            particleConstructor.setAccessible(true);
            particleConstructorParameters = new Class[]{ICurveI.class, Double.TYPE};
            return true;
        }
        if (constructor4 != null) {
            particleOnCurveConstructor = constructor4;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{Object.class, ICurveI.class, Double.TYPE, Double.TYPE};
            return true;
        }
        if (constructor3 != null) {
            particleOnCurveConstructor = constructor3;
            particleOnCurveConstructor.setAccessible(true);
            particleOnCurveConstructorParameters = new Class[]{Object.class, ICurveI.class, Double.TYPE};
            return true;
        }
        IOut.err("no matching particle on curve constructor found. it should be like constructor(ICurve,double) or constructor(ICurve,double,double)");
        return false;
    }

    public static IParticleI getParticleInstance(IVec iVec) {
        IParticleI iParticleI = null;
        try {
            if (particleConstructorParameters.length == 0) {
                iParticleI = particleConstructor.newInstance(new Object[0]);
                iParticleI.pos().set(iVec);
            } else if (particleConstructorParameters.length == 1 && particleConstructorParameters[0] == IVecI.class) {
                iParticleI = particleConstructor.newInstance(iVec);
            } else if (particleConstructorParameters.length == 2 && particleConstructorParameters[0] == IVecI.class) {
                iParticleI = particleConstructor.newInstance(iVec, new IVec());
            } else if (particleConstructorParameters.length == 1 && particleConstructorParameters[0] == Object.class) {
                iParticleI = particleConstructor.newInstance(new Object[]{null});
                iParticleI.pos().set(iVec);
            } else if (particleConstructorParameters.length == 2 && particleConstructorParameters[0] == Object.class) {
                iParticleI = particleConstructor.newInstance(null, iVec);
            } else if (particleConstructorParameters.length == 3 && particleConstructorParameters[0] == Object.class) {
                iParticleI = particleConstructor.newInstance(null, iVec, new IVec());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iParticleI;
    }

    public static ITensionI getTensionInstance(IParticleI iParticleI, IParticleI iParticleI2) {
        ITensionI iTensionI = null;
        try {
            if (tensionConstructorParameters.length == 2 && tensionConstructorParameters[0] == IParticleI.class && tensionConstructorParameters[1] == IParticleI.class) {
                iTensionI = tensionConstructor.newInstance(iParticleI, iParticleI2);
            } else if (tensionConstructorParameters.length == 3 && tensionConstructorParameters[0] == IParticleI.class && tensionConstructorParameters[1] == IParticleI.class && tensionConstructorParameters[2] == Double.TYPE) {
                iTensionI = tensionConstructor.newInstance(iParticleI, iParticleI2, tension);
            } else if (tensionConstructorParameters.length == 3 && tensionConstructorParameters[0] == Object.class && tensionConstructorParameters[1] == IParticleI.class && tensionConstructorParameters[2] == IParticleI.class) {
                iTensionI = tensionConstructor.newInstance(null, iParticleI, iParticleI2);
            } else if (tensionConstructorParameters.length == 4 && tensionConstructorParameters[0] == Object.class && tensionConstructorParameters[1] == IParticleI.class && tensionConstructorParameters[2] == IParticleI.class && tensionConstructorParameters[3] == Double.TYPE) {
                iTensionI = tensionConstructor.newInstance(null, iParticleI, iParticleI2, tension);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iTensionI;
    }

    public static IParticleOnCurveI getParticleOnCurveInstance(ICurveI iCurveI, double d, IVec iVec) {
        IParticleOnCurveI iParticleOnCurveI = null;
        try {
            if (particleOnCurveConstructorParameters.length == 2 && particleOnCurveConstructorParameters[0] == ICurveI.class && particleOnCurveConstructorParameters[1] == Double.TYPE) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(iCurveI, d);
            } else if (particleOnCurveConstructorParameters.length == 3 && particleOnCurveConstructorParameters[0] == ICurveI.class && particleOnCurveConstructorParameters[1] == Double.TYPE && particleOnCurveConstructorParameters[2] == Double.TYPE) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(iCurveI, d, 0);
            } else if (particleOnCurveConstructorParameters.length == 3 && particleOnCurveConstructorParameters[0] == Object.class && particleOnCurveConstructorParameters[1] == ICurveI.class && particleOnCurveConstructorParameters[2] == Double.TYPE) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(null, iCurveI, d);
            } else if (particleOnCurveConstructorParameters.length == 4 && particleOnCurveConstructorParameters[0] == Object.class && particleOnCurveConstructorParameters[1] == ICurveI.class && particleOnCurveConstructorParameters[2] == Double.TYPE && particleOnCurveConstructorParameters[3] == Double.TYPE) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(null, iCurveI, d, 0);
            } else if (particleOnCurveConstructorParameters.length == 3 && particleOnCurveConstructorParameters[0] == ICurveI.class && particleOnCurveConstructorParameters[1] == Double.TYPE && particleOnCurveConstructorParameters[2] == IVec.class) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(iCurveI, d, iVec);
            } else if (particleOnCurveConstructorParameters.length == 4 && particleOnCurveConstructorParameters[0] == ICurveI.class && particleOnCurveConstructorParameters[1] == Double.TYPE && particleOnCurveConstructorParameters[2] == Double.TYPE && particleOnCurveConstructorParameters[3] == IVec.class) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(iCurveI, d, 0, iVec);
            } else if (particleOnCurveConstructorParameters.length == 4 && particleOnCurveConstructorParameters[0] == Object.class && particleOnCurveConstructorParameters[1] == ICurveI.class && particleOnCurveConstructorParameters[2] == Double.TYPE && particleOnCurveConstructorParameters[3] == IVec.class) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(null, iCurveI, d, iVec);
            } else if (particleOnCurveConstructorParameters.length == 5 && particleOnCurveConstructorParameters[0] == Object.class && particleOnCurveConstructorParameters[1] == ICurveI.class && particleOnCurveConstructorParameters[2] == Double.TYPE && particleOnCurveConstructorParameters[3] == Double.TYPE && particleOnCurveConstructorParameters[4] == IVec.class) {
                iParticleOnCurveI = particleOnCurveConstructor.newInstance(null, iCurveI, d, 0, iVec);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iParticleOnCurveI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, IVecI[] iVecIArray) {
        int n;
        Object object;
        int n2;
        int n3;
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            return ITensileNet.create(iCurveIArray2, iVecIArray);
        }
        if (iCurveIArray2 == null || iCurveIArray2.length == 0) {
            IOut.err("no link line input found");
            return null;
        }
        IVec[][] iVecArray = new IVec[iCurveIArray2.length][2];
        for (int i = 0; i < iCurveIArray2.length; ++i) {
            iVecArray[i][0] = iCurveIArray2[i].start().get();
            iVecArray[i][1] = iCurveIArray2[i].end().get();
        }
        Color[] colorArray = new Color[iCurveIArray2.length];
        ILayer[] iLayerArray = new ILayer[iCurveIArray2.length];
        IServer iServer = null;
        if (deleteInputLine) {
            for (n3 = 0; n3 < iCurveIArray2.length; ++n3) {
                if (!(iCurveIArray2[n3] instanceof IObject)) continue;
                colorArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).clr();
                iLayerArray[n3] = ((IObject)((Object)iCurveIArray2[n3])).layer();
                ((IObject)((Object)iCurveIArray2[n3])).del();
                if (iServer != null) continue;
                iServer = ((IObject)((Object)iCurveIArray2[n3])).server();
            }
        }
        if (iServer == null) {
            iServer = IG.current().server();
        }
        for (n3 = 0; n3 < iVecArray.length; ++n3) {
            IVec[] iVecArray2 = iVecArray[n3];
            if (iVecArray2[1].eq(iVecArray2[0], tolerance)) {
                iVecArray[n3] = null;
                continue;
            }
            for (n2 = n3 + 1; n2 < iVecArray.length; ++n2) {
                object = iVecArray[n2];
                for (n = 0; n < 2; ++n) {
                    if (object[n].eq(iVecArray2[0], tolerance)) {
                        object[n] = iVecArray2[0];
                        continue;
                    }
                    if (!object[n].eq(iVecArray2[1], tolerance)) continue;
                    object[n] = iVecArray2[1];
                }
            }
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray.length; ++i) {
            if (iVecArray[i] == null) continue;
            for (n2 = 0; n2 < 2; ++n2) {
                object = iVecArray[i][n2];
                if (arrayList.contains(object)) continue;
                arrayList.add((IVec[])object);
            }
        }
        ArrayList arrayList2 = null;
        if (fixOpenLinePoint) {
            arrayList2 = new ArrayList();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n4 = 0;
                for (n = 0; n < iVecArray.length; ++n) {
                    if (iVecArray[n] == null) continue;
                    if (iVecArray[n][0] == arrayList.get(n2)) {
                        ++n4;
                    }
                    if (iVecArray[n][1] != arrayList.get(n2)) continue;
                    ++n4;
                }
                if (n4 != true) continue;
                arrayList2.add(arrayList.get(n2));
            }
        }
        boolean[] blArray = new boolean[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            blArray[i] = false;
            if (iVecIArray == null) continue;
            for (n = 0; n < iVecIArray.length && !blArray[i]; ++n) {
                if (!iVecIArray[n].eq((IVecI)arrayList.get(i), tolerance)) continue;
                blArray[i] = true;
            }
        }
        ArrayList[] arrayListArray = null;
        if (tensionOnSameRail || spacingEqualizer) {
            ArrayList[] arrayListArray2;
            arrayListArray = arrayListArray2 = new ArrayList[iCurveIArray.length];
            for (int i = 0; i < arrayListArray.length; ++i) {
                arrayListArray[i] = new ArrayList();
            }
        }
        if (particleClass != null) {
            ITensileNet.searchParticleConstructor(particleClass);
        }
        if (tensionClass != null) {
            ITensileNet.searchTensionConstructor(tensionClass);
        }
        if (particleOnCurveClass != null) {
            ITensileNet.searchParticleOnCurveConstructor(particleOnCurveClass);
        }
        ITensileNet iTensileNet = null;
        IDynamicServer iDynamicServer = iServer.dynamicServer();
        synchronized (iDynamicServer) {
            ITransformable iTransformable;
            Object object2;
            IParticleI iParticleI;
            int n5;
            int n6;
            Object object3;
            ArrayList<IParticleI> arrayList3 = new ArrayList<IParticleI>();
            for (int i = 0; i < arrayList.size(); ++i) {
                IParticleOnCurveI iParticleOnCurveI;
                if (arrayList.size() > 100 && i % 100 == 0) {
                    IOut.debug(0, "finding curve for point to be on (" + i + "/" + arrayList.size() + ")");
                }
                if ((object3 = (iParticleOnCurveI = ITensileNet.createParticleOnClosestCurve(iCurveIArray, (IVec)arrayList.get(i), railTolerance, 0.001))) == null) {
                    if (particleConstructor != null && particleConstructorParameters != null && (object3 = ITensileNet.getParticleInstance((IVec)arrayList.get(i))) != null) {
                        object3.fric(friction);
                        if (fixPointNotOnRail || fixOpenLinePoint && arrayList2 != null && arrayList2.contains(arrayList.get(i))) {
                            object3.fix();
                            if (object3 instanceof IObject) {
                                if (fixedPointLayer != null) {
                                    ((IObject)object3).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                                }
                                ((IObject)object3).clr(fixedPointColor);
                            }
                        } else if (object3 instanceof IObject) {
                            if (pointLayer != null) {
                                ((IObject)object3).layer(IG.layer(pointLayer).clr(pointColor));
                            }
                            ((IObject)object3).clr(pointColor);
                        }
                    }
                    if (object3 == null) {
                        IParticleAgent iParticleAgent = new IParticleAgent((IVec)arrayList.get(i));
                        iParticleAgent.fric(friction);
                        if (fixPointNotOnRail || fixOpenLinePoint && arrayList2 != null && arrayList2.contains(arrayList.get(i))) {
                            iParticleAgent.fix();
                            iParticleAgent.clr(fixedPointColor);
                            if (fixedPointLayer != null) {
                                iParticleAgent.layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                            }
                        } else {
                            iParticleAgent.clr(pointColor);
                            if (pointLayer != null) {
                                iParticleAgent.layer(IG.layer(pointLayer).clr(pointColor));
                            }
                        }
                        object3 = iParticleAgent;
                    }
                }
                arrayList3.add((IParticleI)object3);
                if (blArray[i]) {
                    object3.fix();
                    if (object3 instanceof IObject) {
                        ((IObject)object3).clr(fixedPointColor);
                        if (fixedPointLayer != null) {
                            ((IObject)object3).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
                        }
                    }
                }
                if (iParticleOnCurveI == null) continue;
                if (tensionOnSameRail || spacingEqualizer) {
                    int n7 = -1;
                    for (n6 = 0; n6 < iCurveIArray.length && n7 < 0; ++n6) {
                        if (iCurveIArray[n6] != iParticleOnCurveI.curve()) continue;
                        n7 = n6;
                    }
                    if (n7 >= 0) {
                        arrayListArray[n7].add(iParticleOnCurveI);
                    }
                }
                if (!fixPointOnRailEnd || !(iParticleOnCurveI.upos() < IConfig.parameterTolerance) && !(iParticleOnCurveI.upos() > 1.0 - IConfig.parameterTolerance)) continue;
                iParticleOnCurveI.fix();
                if (!(iParticleOnCurveI instanceof IObject)) continue;
                ((IObject)((Object)iParticleOnCurveI)).clr(fixedPointColor);
                if (fixedPointLayer == null) continue;
                ((IObject)((Object)iParticleOnCurveI)).layer(IG.layer(fixedPointLayer).clr(fixedPointColor));
            }
            ArrayList<ITensionI> arrayList4 = new ArrayList<ITensionI>();
            for (n5 = 0; n5 < iVecArray.length; ++n5) {
                object3 = iVecArray[n5];
                if (object3 == null) continue;
                int n8 = arrayList.indexOf(object3[0]);
                n6 = arrayList.indexOf(object3[1]);
                if (n8 >= 0 && n6 >= 0) {
                    IParticleI iParticleI2 = arrayList3.get(n8);
                    iParticleI = arrayList3.get(n6);
                    object2 = null;
                    if (tensionConstructor != null && tensionConstructorParameters != null && (object2 = ITensileNet.getTensionInstance(iParticleI2, iParticleI)) != null) {
                        if (object2 instanceof IObject) {
                            if (colorArray[n5] != null) {
                                ((IObject)object2).clr(colorArray[n5]);
                            }
                            if (iLayerArray[n5] != null) {
                                ((IObject)object2).layer(iLayerArray[n5]);
                            }
                        }
                        object2.tension(tension);
                        object2.constant(constantTension);
                        arrayList4.add((ITensionI)object2);
                    }
                    if (object2 != null) continue;
                    iTransformable = new ITensionLine(iParticleI2, iParticleI, tension);
                    if (colorArray[n5] != null) {
                        ((ICurve)iTransformable).clr(colorArray[n5]);
                    }
                    if (iLayerArray[n5] != null) {
                        ((ICurve)iTransformable).layer(iLayerArray[n5]);
                    }
                    ((ITensionLine)iTransformable).tension(tension);
                    ((ITensionLine)iTransformable).constant(constantTension);
                    arrayList4.add((ITensionI)((Object)iTransformable));
                    continue;
                }
                IOut.err("end point is not found");
            }
            if (tensionOnSameRail || spacingEqualizer) {
                for (n5 = 0; n5 < iCurveIArray.length; ++n5) {
                    IDynamicsBase iDynamicsBase;
                    int n9;
                    if (arrayListArray[n5].size() <= 1) continue;
                    ISort.sort(arrayListArray[n5], new IParticleOnCurveComparator());
                    boolean bl = iCurveIArray[n5].isClosed();
                    if (tensionOnSameRail) {
                        for (n9 = 0; !bl && n9 < arrayListArray[n5].size() - 1 || bl && n9 < arrayListArray[n5].size(); ++n9) {
                            iDynamicsBase = new ITensionOnCurve((IParticleOnCurveI)arrayListArray[n5].get(n9), (IParticleOnCurveI)arrayListArray[n5].get((n9 + 1) % arrayListArray[n5].size()), onRailTension);
                        }
                    }
                    if (!spacingEqualizer) continue;
                    for (n9 = 0; !bl && n9 < arrayListArray[n5].size() - 2 || bl && n9 < arrayListArray[n5].size(); ++n9) {
                        iDynamicsBase = new ISpacingEqualizer((IParticleI)arrayListArray[n5].get(n9), (IParticleI)arrayListArray[n5].get((n9 + 1) % arrayListArray[n5].size()), (IParticleI)arrayListArray[n5].get((n9 + 2) % arrayListArray[n5].size())).tension(equalizerTension);
                    }
                }
            }
            if (straightener) {
                Object object4;
                IParticleI iParticleI3;
                int n10;
                ArrayList<IStraightenerCurve> arrayList5 = new ArrayList<IStraightenerCurve>();
                for (n10 = 0; n10 < arrayList4.size(); ++n10) {
                    IParticleI iParticleI4 = arrayList4.get(n10).pt(0);
                    IParticleI iParticleI5 = arrayList4.get(n10).pt(1);
                    for (int i = n10 + 1; i < arrayList4.size(); ++i) {
                        iParticleI = arrayList4.get(i).pt(0);
                        object2 = arrayList4.get(i).pt(1);
                        iTransformable = null;
                        iParticleI3 = null;
                        object4 = null;
                        if (iParticleI4 == iParticleI) {
                            iTransformable = iParticleI5;
                            iParticleI3 = iParticleI4;
                            object4 = object2;
                        } else if (iParticleI4 == object2) {
                            iTransformable = iParticleI5;
                            iParticleI3 = iParticleI4;
                            object4 = iParticleI;
                        } else if (iParticleI5 == iParticleI) {
                            iTransformable = iParticleI4;
                            iParticleI3 = iParticleI5;
                            object4 = object2;
                        } else if (iParticleI5 == object2) {
                            iTransformable = iParticleI4;
                            iParticleI3 = iParticleI5;
                            object4 = iParticleI;
                        }
                        if (iTransformable == null || iParticleI3 == null || object4 == null || !(Math.abs(iParticleI3.pos().diff(iTransformable.pos()).angle(object4.pos().diff(iParticleI3.pos()))) < straightenerThresholdAngle)) continue;
                        IStraightenerCurve iStraightenerCurve = new IStraightenerCurve((IParticleI)iTransformable, iParticleI3, (IParticleI)object4);
                        iStraightenerCurve.tension(straightenerTension);
                        iStraightenerCurve.clr(straightenerColor);
                        iStraightenerCurve.layer(IG.layer(straightenerLayer).clr(straightenerColor));
                        arrayList5.add(iStraightenerCurve);
                    }
                }
                if (removeBranchStraightener) {
                    for (n10 = 0; n10 < arrayList5.size(); ++n10) {
                        IParticleI iParticleI6 = ((IStraightenerCurve)arrayList5.get(n10)).pt(0);
                        IParticleI iParticleI7 = ((IStraightenerCurve)arrayList5.get(n10)).pt(1);
                        IParticleI iParticleI8 = ((IStraightenerCurve)arrayList5.get(n10)).pt(2);
                        boolean bl = false;
                        for (int i = n10 + 1; i < arrayList5.size() && !bl; ++i) {
                            iTransformable = ((IStraightenerCurve)arrayList5.get(i)).pt(0);
                            iParticleI3 = ((IStraightenerCurve)arrayList5.get(i)).pt(1);
                            object4 = ((IStraightenerCurve)arrayList5.get(i)).pt(2);
                            if (iParticleI7 != iParticleI3 || iParticleI6 != iTransformable && iParticleI6 != object4 && iParticleI8 != iTransformable && iParticleI8 != object4) continue;
                            double d = iParticleI7.pos().diff(iParticleI6.pos()).angle(iParticleI8.pos().diff(iParticleI7.pos()));
                            double d2 = iParticleI3.pos().diff(iTransformable.pos()).angle(object4.pos().diff(iParticleI3.pos()));
                            if (Math.abs(d) < Math.abs(d2)) {
                                ((IStraightenerCurve)arrayList5.get(i)).del();
                                arrayList5.remove(i);
                                --i;
                                continue;
                            }
                            ((IStraightenerCurve)arrayList5.get(n10)).del();
                            arrayList5.remove(n10);
                            --n10;
                            --i;
                            bl = true;
                        }
                    }
                }
            }
            iTensileNet = new ITensileNet(arrayList4, arrayList3);
        }
        return iTensileNet;
    }

    public static ITensileNet create(ICurveI[] iCurveIArray, ICurveI[] iCurveIArray2, ICurveI[] iCurveIArray3, IVecI[] iVecIArray) {
        int n;
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        for (n = 0; n < iCurveIArray3.length; ++n) {
            int n2;
            IVec iVec;
            IVec iVec2 = iCurveIArray3[n].start().get();
            if (iVec2.eq(iVec = iCurveIArray3[n].end().get(), tolerance)) {
                iVec = null;
            }
            for (n2 = 0; n2 < arrayList.size() && iVec2 != null; ++n2) {
                if (!iVec2.eq((IVecI)arrayList.get(n2), tolerance)) continue;
                iVec2 = null;
            }
            if (iVec2 != null) {
                arrayList.add(iVec2);
            }
            for (n2 = 0; n2 < arrayList.size() && iVec != null; ++n2) {
                if (!iVec.eq((IVecI)arrayList.get(n2), tolerance)) continue;
                iVec = null;
            }
            if (iVec == null) continue;
            arrayList.add(iVec);
        }
        for (n = 0; iVecIArray != null && n < iVecIArray.length; ++n) {
            arrayList.add(iVecIArray[n]);
        }
        return ITensileNet.create(iCurveIArray, iCurveIArray2, arrayList.toArray(new IVecI[arrayList.size()]));
    }

    public static ICurveI findClosestCurve(ICurveI[] iCurveIArray, IVec iVec, int n) {
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j <= n; ++j) {
                double d2 = iCurveIArray[i].pt((double)j / (double)n).dist(iVec);
                if (n2 >= 0 && !(d2 < d)) continue;
                n2 = i;
                d = d2;
            }
        }
        if (n2 < 0) {
            return null;
        }
        return iCurveIArray[n2];
    }

    public static IParticleOnCurveI createParticleOnClosestCurve(ICurveI[] iCurveIArray, IVec iVec, double d, double d2) {
        IParticleOnCurveI iParticleOnCurveI = null;
        do {
            ICurveI iCurveI = null;
            iCurveI = iCurveIArray.length == 1 ? iCurveIArray[0] : ITensileNet.findClosestCurve(iCurveIArray, iVec, 20);
            iParticleOnCurveI = ITensileNet.createParticleOnCurve(iCurveI, iVec, d, d2);
            if (iParticleOnCurveI != null) continue;
            if (iCurveIArray.length > 1) {
                ICurveI[] iCurveIArray2 = new ICurveI[iCurveIArray.length - 1];
                int n = 0;
                int n2 = 0;
                while (n < iCurveIArray.length) {
                    if (iCurveIArray[n] != iCurveI) {
                        iCurveIArray2[n2] = iCurveIArray[n];
                    } else {
                        --n2;
                    }
                    ++n;
                    ++n2;
                }
                iCurveIArray = iCurveIArray2;
                continue;
            }
            return null;
        } while (iParticleOnCurveI == null && iCurveIArray.length > 1);
        return iParticleOnCurveI;
    }

    public static IParticleOnCurveI createParticleOnCurve(ICurveI iCurveI, IVec iVec, double d, double d2) {
        IParticleOnCurveI iParticleOnCurveI;
        int n = 0;
        if (iCurveI == null) {
            return null;
        }
        n = d2 == 0.0 ? 10000 : (int)(1.0 / d2 + 0.5);
        double d3 = -1.0;
        double d4 = -1.0;
        for (int i = 0; i <= n; ++i) {
            double d5 = (double)i / (double)n;
            double d6 = iCurveI.pt(d5).dist(iVec);
            if (!(d4 < 0.0) && !(d6 < d3)) continue;
            d3 = d6;
            d4 = d5;
        }
        if (d4 >= 0.0) {
            IVec iVec2 = iCurveI.pt(d4).get();
            IVec iVec3 = iCurveI.tan(d4).get();
            double d7 = iVec3.len2();
            double d8 = iVec.diff(iVec2).dot(iVec3) / d7;
            if ((d4 += d8) < 0.0) {
                d4 = 0.0;
            }
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d3 = iCurveI.pt(d4).dist(iVec);
        }
        if (d >= 0.0 && d3 > d) {
            return null;
        }
        if (particleOnCurveConstructor != null && particleOnCurveConstructorParameters != null && (iParticleOnCurveI = ITensileNet.getParticleOnCurveInstance(iCurveI, d4, iVec)) != null) {
            iParticleOnCurveI.friction(friction);
            if (iParticleOnCurveI instanceof IObject) {
                if (pointLayer != null) {
                    ((IObject)((Object)iParticleOnCurveI)).layer(IG.layer(pointLayer).clr(pointColor));
                }
                ((IObject)((Object)iParticleOnCurveI)).clr(railPointColor);
            }
            return iParticleOnCurveI;
        }
        IParticleOnCurveAgent iParticleOnCurveAgent = new IParticleOnCurveAgent(iCurveI, d4, iVec);
        iParticleOnCurveAgent.fric(friction);
        if (pointLayer != null) {
            iParticleOnCurveAgent.layer(IG.layer(pointLayer).clr(pointColor));
        }
        iParticleOnCurveAgent.clr(railPointColor);
        return iParticleOnCurveAgent;
    }

    public static class IParticleOnCurveComparator
    implements IComparator<IParticleOnCurveI> {
        @Override
        public int compare(IParticleOnCurveI iParticleOnCurveI, IParticleOnCurveI iParticleOnCurveI2) {
            if (iParticleOnCurveI.upos() < iParticleOnCurveI2.upos()) {
                return -1;
            }
            if (iParticleOnCurveI.upos() > iParticleOnCurveI2.upos()) {
                return 1;
            }
            return 0;
        }
    }
}

