/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IVec;
import igeo.gui.IMouseButton;
import igeo.gui.IPane;
import igeo.gui.IView;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class INavigator {
    public static final IMouseButton defaultRotateButton = new IMouseButton(1);
    public static final IMouseButton defaultRotateButton2 = new IMouseButton(1, false, false, true);
    public static final IMouseButton defaultPanButton = new IMouseButton(2);
    public static final IMouseButton defaultPanButton2 = new IMouseButton(1, true, false, false);
    public static final IMouseButton defaultZoomButton = new IMouseButton(3);
    public static final IMouseButton defaultZoomButton2 = new IMouseButton(1, false, true, false);
    public static double minimumAxonometricMouseZoomRatio = 1.0E-6;
    public double rotationYawRatio = IConfig.mouseRotationSpeed / 180.0 * Math.PI;
    public double rotationPitchRatio = IConfig.mouseRotationSpeed / 180.0 * Math.PI;
    public double perspectivePanRatio = IConfig.mousePerspectivePanSpeed;
    public double axonometricPanRatio = IConfig.mouseAxonometricPanSpeed;
    public double axonZoomRatio = IConfig.mouseAxonometricZoomSpeed / 100.0;
    public double persZoomRatio = IConfig.mousePerspectiveZoomSpeed;
    public double wheelZoomRatio = IConfig.mouseWheelZoomSpeed;
    public double keyRotationYawInc = IConfig.keyRotationSpeed / 180.0 * Math.PI;
    public double keyRotationPitchInc = IConfig.keyRotationSpeed / 180.0 * Math.PI;
    public double keyPerspectivePanInc = IConfig.keyPerspectivePanSpeed;
    public double keyAxonometricPanInc = IConfig.keyAxonometricPanSpeed;
    public double keyZoomInc = IConfig.keyZoomSpeed;
    public boolean rotateLock = false;
    public IPane pane;
    public IView view;
    public int mouseX;
    public int mouseY;
    public boolean mousePressed = false;
    public IVec viewPos;
    public IVec viewTarget;
    public IVec viewAngle;
    public double viewAxonRatio;
    public DragType dragType = null;
    public ArrayList<IMouseButton> rotateButtons;
    public ArrayList<IMouseButton> panButtons;
    public ArrayList<IMouseButton> zoomButtons;
    public ArrayList<IMouseButton> rotateUnlockButtons;

    public INavigator(IView iView, IPane iPane) {
        this(iView);
        this.pane = iPane;
    }

    public INavigator(IView iView) {
        this.view = iView;
        this.rotateButtons = new ArrayList();
        this.panButtons = new ArrayList();
        this.zoomButtons = new ArrayList();
        this.rotateUnlockButtons = new ArrayList();
        this.rotateButtons.add(defaultRotateButton);
        this.rotateButtons.add(defaultRotateButton2);
        this.panButtons.add(defaultPanButton);
        this.panButtons.add(defaultPanButton2);
        this.zoomButtons.add(defaultZoomButton);
        this.zoomButtons.add(defaultZoomButton2);
        this.rotateUnlockButtons.add(defaultRotateButton2);
    }

    public void setPane(IPane iPane) {
        this.pane = iPane;
    }

    public void setRotationRatio(double d, double d2) {
        this.rotationYawRatio = d;
        this.rotationPitchRatio = d2;
    }

    public void setPerspectivePanRatio(double d) {
        this.perspectivePanRatio = d;
    }

    public void setAxonometricPanRatio(double d) {
        this.axonometricPanRatio = d;
    }

    public void setPerspectiveZoomRatio(double d) {
        this.persZoomRatio = d;
    }

    public void setAxonometricZoomRatio(double d) {
        this.axonZoomRatio = d;
    }

    public void wheelZoomRatio(double d) {
        this.wheelZoomRatio = d;
    }

    public void setRotateLock(boolean bl) {
        this.rotateLock = bl;
    }

    public void updateRotationByMouse(int n, int n2) {
        if (this.mousePressed) {
            int n3 = n - this.mouseX;
            int n4 = n2 - this.mouseY;
            double d = (double)(-n3) * this.rotationYawRatio;
            double d2 = (double)n4 * this.rotationPitchRatio;
            this.updateRotation(d, d2);
        }
    }

    public void updateRotation(double d, double d2) {
        double d3 = this.viewAngle.x + d;
        double d4 = this.viewAngle.y + d2;
        d3 -= Math.floor(d3 / (Math.PI * 2)) * 2.0 * Math.PI;
        d4 -= Math.floor(d4 / (Math.PI * 2)) * 2.0 * Math.PI;
        this.view.setAngle(d3, d4);
        this.view.update();
    }

    public void updatePanByMouse(int n, int n2) {
        if (this.mousePressed) {
            int n3 = n - this.mouseX;
            int n4 = n2 - this.mouseY;
            double d = this.view.isAxonometric() ? this.view.getAxonometricRatio() * this.axonometricPanRatio : this.perspectivePanRatio;
            this.updatePan((double)(-n3) * d, (double)n4 * d);
        }
    }

    public void updatePan(double d, double d2) {
        IVec iVec = this.view.rightDirection();
        IVec iVec2 = this.view.upDirection();
        iVec.len(d).add(iVec2.len(d2));
        this.view.setLocation(this.viewPos.dup().add(iVec));
        this.view.setTarget(this.viewTarget.dup().add(iVec));
        this.view.update();
    }

    public void updateZoomByMouse(int n, int n2) {
        if (this.mousePressed) {
            this.updateZoom(n2 - this.mouseY);
        }
    }

    public void updateZoom(double d) {
        if (this.view.isAxonometric()) {
            double d2 = d > 0.0 ? (1.0 + d * this.axonZoomRatio) * this.viewAxonRatio : 1.0 / (1.0 - d * this.axonZoomRatio) * this.viewAxonRatio;
            if (d2 < minimumAxonometricMouseZoomRatio) {
                d2 = minimumAxonometricMouseZoomRatio;
            }
            this.view.setAxonometricRatio(d2);
        } else {
            double d3 = -d * this.persZoomRatio;
            IVec iVec = this.view.frontDirection().len(d3);
            this.view.setLocation(this.viewPos.dup().add(iVec));
            this.view.update();
        }
    }

    public DragType getDragType(MouseEvent mouseEvent) {
        if (this.rotateLock) {
            for (IMouseButton iMouseButton : this.rotateUnlockButtons) {
                if (!iMouseButton.match(mouseEvent)) continue;
                this.rotateLock = false;
                return DragType.Rotate;
            }
            for (IMouseButton iMouseButton : this.rotateButtons) {
                if (!iMouseButton.match(mouseEvent)) continue;
                return DragType.Pan;
            }
        } else {
            for (IMouseButton iMouseButton : this.rotateButtons) {
                if (!iMouseButton.match(mouseEvent)) continue;
                return DragType.Rotate;
            }
        }
        for (IMouseButton iMouseButton : this.panButtons) {
            if (!iMouseButton.match(mouseEvent)) continue;
            return DragType.Pan;
        }
        for (IMouseButton iMouseButton : this.zoomButtons) {
            if (!iMouseButton.match(mouseEvent)) continue;
            return DragType.Zoom;
        }
        return null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        this.mousePressed = true;
        this.dragType = this.getDragType(mouseEvent);
        this.viewPos = this.view.location();
        this.viewTarget = this.view.target();
        this.viewAngle = this.view.getAngles();
        this.viewAxonRatio = this.view.getAxonometricRatio();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragType == DragType.Rotate) {
            this.updateRotationByMouse(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.dragType == DragType.Pan) {
            this.updatePanByMouse(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.dragType == DragType.Zoom) {
            this.updateZoomByMouse(mouseEvent.getX(), mouseEvent.getY());
        }
        this.mousePressed = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragType == DragType.Rotate) {
            this.updateRotationByMouse(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.dragType == DragType.Pan) {
            this.updatePanByMouse(mouseEvent.getX(), mouseEvent.getY());
        } else if (this.dragType == DragType.Zoom) {
            this.updateZoomByMouse(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.viewPos = this.view.location();
        this.viewAxonRatio = this.view.getAxonometricRatio();
        this.updateZoom(this.wheelZoomRatio * (double)mouseWheelEvent.getWheelRotation());
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isControlDown();
        if (!bl && !bl2) {
            if (n == 38) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(0.0, -this.keyRotationPitchInc);
            } else if (n == 40) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(0.0, this.keyRotationPitchInc);
            } else if (n == 37) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(this.keyRotationYawInc, 0.0);
            } else if (n == 39) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(-this.keyRotationYawInc, 0.0);
            }
        } else if (bl && !bl2) {
            double d = this.view.isAxonometric() ? this.view.getAxonometricRatio() * this.keyAxonometricPanInc : this.keyPerspectivePanInc;
            if (n == 38) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(0.0, -d);
            } else if (n == 40) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(0.0, d);
            } else if (n == 37) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(d, 0.0);
            } else if (n == 39) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(-d, 0.0);
            }
        } else if (!bl && bl2) {
            if (n == 38) {
                this.viewPos = this.view.location();
                this.viewAxonRatio = this.view.getAxonometricRatio();
                this.updateZoom(-this.keyZoomInc);
            } else if (n == 40) {
                this.viewPos = this.view.location();
                this.viewAxonRatio = this.view.getAxonometricRatio();
                this.updateZoom(this.keyZoomInc);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DragType {
        Rotate,
        Pan,
        Zoom;

    }
}

