/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolI;
import igeo.ICurveGeo;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVecI;

public class IArcGeo
extends ICurveGeo {
    public static double maxSegmentAngle = 0.39269908169872414;
    public IVecI center;
    public IVecI normal;
    public IVecI startPt;
    public IDoubleI angle;

    public static int arcDeg() {
        return 2;
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, double d) {
        if (d < 0.0) {
            iVec2 = iVec2.dup().neg();
            d = -d;
        }
        int n = (int)(d / maxSegmentAngle) + 1;
        IVec4[] iVec4Array = new IVec4[n * 2 + 1];
        IVec iVec4 = iVec3.diff(iVec);
        IVec iVec5 = iVec4.dup();
        double d2 = iVec4.len();
        double d3 = d / (double)n;
        double d4 = d3 / 2.0;
        double d5 = d2 / Math.cos(d4);
        iVec5.len(d5);
        iVec5.rot(iVec2, d4);
        for (int i = 0; i < iVec4Array.length; ++i) {
            iVec4Array[i] = iVec.to4d();
            if (i % 2 == 0) {
                iVec4Array[i].add(iVec4);
                iVec4.rot(iVec2, d3);
                continue;
            }
            iVec4Array[i].add(iVec5);
            iVec4Array[i].w = Math.cos(d4);
            iVec5.rot(iVec2, d3);
        }
        return iVec4Array;
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, boolean bl) {
        IVec iVec4 = iVec2.diff(iVec);
        IVec iVec5 = iVec3.diff(iVec);
        IVec iVec6 = null;
        iVec6 = iVec4.isParallel(iVec5) ? iVec5.cross(iVec4.cross(IVec.zaxis)) : iVec5.cross(iVec4);
        double d = iVec4.angle(iVec5);
        if (d == 0.0 || d == Math.PI) {
            iVec6 = iVec4.x != 0.0 || iVec4.y != 0.0 ? iVec4.cross(IVec.zaxis) : iVec4.cross(IVec.xaxis);
        }
        if (bl) {
            d = Math.PI * 2 - d;
            iVec6.neg();
        }
        return IArcGeo.arcCP(iVec, iVec6, iVec2, d);
    }

    public static IVec4[] arcCP(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5) {
        IVec iVec6 = iVec2.diff(iVec);
        IVec iVec7 = iVec4.diff(iVec);
        IVec iVec8 = iVec3.diff(iVec);
        double d = iVec6.angle(iVec7, iVec5);
        double d2 = iVec6.angle(iVec8, iVec5);
        if (d > 0.0 && d2 < 0.0) {
            d = -(Math.PI * 2 - d);
        } else if (d < 0.0 && d2 > 0.0) {
            d = Math.PI * 2 + d;
        }
        if (d < 0.0) {
            iVec5.neg();
            d = -d;
        }
        iVec5.neg();
        return IArcGeo.arcCP(iVec, iVec5, iVec2, d);
    }

    public static double[] arcKnots(double d) {
        double d2;
        if (d < 0.0) {
            d = -d;
        }
        int n = (int)(d / maxSegmentAngle) + 1;
        double d3 = d / (double)n;
        double[] dArray = new double[(n + 1) * 2 + 2];
        int n2 = 0;
        dArray[n2] = d2 = 0.0;
        dArray[++n2] = d2;
        dArray[++n2] = d2;
        ++n2;
        while (n2 < dArray.length - 1) {
            dArray[n2] = d2 += d3;
            dArray[++n2] = d2;
            ++n2;
        }
        dArray[n2] = d2;
        n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] / d2;
        }
        return dArray;
    }

    public IArcGeo() {
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        this.init(iVecI, iVecI2, iVecI3, new IDouble(d));
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        this.init(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        this.init(iVecI, iVecI2, iVecI3, iBoolI);
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        this.init(iVecI, iVecI2, iVecI3, new IBool(bl));
    }

    public IArcGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        this.init(iVecI, iVecI2, iVecI3, iVecI4, iVecI5);
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        this.center = iVecI;
        this.normal = iVecI2;
        this.startPt = iVecI3;
        this.angle = iDoubleI;
        IVecI[] iVecIArray = IArcGeo.arcCP(iVecI.get(), iVecI2.get(), iVecI3.get(), iDoubleI.x());
        super.init(iVecIArray, IArcGeo.arcDeg(), IArcGeo.arcKnots(iDoubleI.x()));
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        IVec iVec;
        IVec iVec2 = iVecI2.get().diff(iVecI);
        this.normal = iVec2.isParallel(iVec = iVecI3.get().diff(iVecI)) ? iVec.cross(iVec2.cross(IVec.zaxis)) : iVec.cross(iVec2);
        double d = iVec2.angle(iVec);
        if (d == 0.0 || d == Math.PI) {
            this.normal = iVec2.x != 0.0 || iVec2.y != 0.0 ? iVec2.cross(IVec.zaxis) : iVec2.cross(IVec.xaxis);
        }
        if (iBoolI.x()) {
            d = Math.PI * 2 - d;
            this.normal.neg();
        }
        this.init(iVecI, this.normal, iVecI2, new IDouble(d));
    }

    public void init(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        IVec iVec = iVecI2.get().diff(iVecI);
        IVec iVec2 = iVecI4.get().diff(iVecI);
        IVec iVec3 = iVecI3.get().diff(iVecI);
        double d = iVec.angle((IVecI)iVec2, iVecI5);
        double d2 = iVec.angle((IVecI)iVec3, iVecI5);
        if (d > 0.0 && d2 < 0.0) {
            d = -(Math.PI * 2 - d);
        } else if (d < 0.0 && d2 > 0.0) {
            d = Math.PI * 2 + d;
        }
        if (d < 0.0) {
            iVecI5.neg();
            d = -d;
        }
        iVecI5.neg();
        this.init(iVecI, iVecI5, iVecI2, new IDouble(d));
    }
}

