/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IDynamics;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IParticle;
import igeo.IParticleOnCurveI;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticleOnCurve
extends IParticle
implements IParticleOnCurveI {
    public ICurveI curve;
    public double upos;
    public double uvel;
    public double ufrc;
    public IVec utan;

    public IParticleOnCurve(ICurveI iCurveI) {
        this(iCurveI, 0.0);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d) {
        super(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, double d2) {
        this(iCurveI, d);
        this.uvel = d2;
    }

    public IParticleOnCurve(ICurveI iCurveI, IVec iVec) {
        this(iCurveI, 0.0, iVec);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IVec iVec) {
        super(iVec);
        iVec.set(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, double d2, IVec iVec) {
        this(iCurveI, d, iVec);
        this.uvel = d2;
    }

    public IParticleOnCurve(ICurveI iCurveI, IObject iObject) {
        this(iCurveI, 0.0, iObject);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IObject iObject) {
        super(iCurveI.pt(d).get(), iObject);
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, double d2, IObject iObject) {
        this(iCurveI, d, iObject);
        this.uvel = d2;
    }

    public IParticleOnCurve(ICurveI iCurveI, IVec iVec, IObject iObject) {
        this(iCurveI, 0.0, iVec, iObject);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IVec iVec, IObject iObject) {
        super(iVec, iObject);
        iVec.set(iCurveI.pt(d).get());
        this.curve = iCurveI;
        this.upos = d;
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, double d2, IVec iVec, IObject iObject) {
        this(iCurveI, d, iVec, iObject);
        this.uvel = d2;
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IPoint iPoint) {
        this(iCurveI, d, iPoint.pos, (IObject)iPoint);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, double d2, IPoint iPoint) {
        this(iCurveI, d, d2, iPoint.pos, iPoint);
    }

    public IParticleOnCurve(ICurveI iCurveI, IPoint iPoint) {
        this(iCurveI, 0.0, iPoint.pos, (IObject)iPoint);
    }

    public IParticleOnCurve(ICurveI iCurveI, IPointR iPointR) {
        this(iCurveI, 0.0, iPointR.pos.get(), (IObject)iPointR);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, IPointR iPointR) {
        this(iCurveI, d, iPointR.pos.get(), (IObject)iPointR);
    }

    public IParticleOnCurve(ICurveI iCurveI, double d, double d2, IPointR iPointR) {
        this(iCurveI, d, d2, iPointR.pos.get(), iPointR);
    }

    public IParticleOnCurve(ICurve iCurve) {
        this((ICurveI)iCurve, 0.0, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, double d) {
        this((ICurveI)iCurve, d, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, double d, double d2) {
        this((ICurveI)iCurve, d, d2, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, IVec iVec) {
        this((ICurveI)iCurve, 0.0, iVec, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, double d, IVec iVec) {
        this((ICurveI)iCurve, d, iVec, (IObject)iCurve);
    }

    public IParticleOnCurve(ICurve iCurve, double d, double d2, IVec iVec) {
        this(iCurve, d, d2, iVec, iCurve);
    }

    public IParticleOnCurve(IParticleOnCurve iParticleOnCurve) {
        this(iParticleOnCurve.curve, iParticleOnCurve.upos, iParticleOnCurve.pos.dup(), iParticleOnCurve.parent());
    }

    public IParticleOnCurve(IParticleOnCurve iParticleOnCurve, IVec iVec) {
        this(iParticleOnCurve.curve, iParticleOnCurve.upos, iVec, iParticleOnCurve.parent());
    }

    public IParticleOnCurve(IParticleOnCurve iParticleOnCurve, IObject iObject) {
        this(iParticleOnCurve.curve, iParticleOnCurve.upos, iParticleOnCurve.pos.dup(), iObject);
    }

    public IParticleOnCurve(IParticleOnCurve iParticleOnCurve, IVec iVec, IObject iObject) {
        this(iParticleOnCurve.curve, iParticleOnCurve.upos, iVec, iObject);
    }

    @Override
    public IParticleOnCurve dup() {
        return new IParticleOnCurve(this);
    }

    @Override
    public ICurveI curve() {
        return this.curve;
    }

    @Override
    public synchronized IParticleOnCurve fix() {
        super.fix();
        return this;
    }

    @Override
    public synchronized IParticleOnCurve unfix() {
        super.unfix();
        return this;
    }

    @Override
    public synchronized IParticleOnCurve mass(double d) {
        super.mass(d);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve position(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve pos(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve velocity(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve vel(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve force(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve frc(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve friction(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve fric(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve decay(double d) {
        return this.fric(d);
    }

    @Override
    public synchronized IParticleOnCurve push(IVecI iVecI) {
        super.push(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve pull(IVecI iVecI) {
        super.pull(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve addForce(IVecI iVecI) {
        super.addForce(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnCurve reset() {
        super.reset();
        return this;
    }

    @Override
    public synchronized IParticleOnCurve resetForce() {
        super.resetForce();
        return this;
    }

    @Override
    public synchronized IParticleOnCurve uposition(double d) {
        return this.upos(d);
    }

    @Override
    public synchronized IParticleOnCurve upos(double d) {
        this.upos = d;
        return this;
    }

    @Override
    public synchronized double uposition() {
        return this.upos();
    }

    @Override
    public synchronized double upos() {
        return this.upos;
    }

    @Override
    public synchronized IParticleOnCurve uvelocity(double d) {
        return this.uvel(d);
    }

    @Override
    public synchronized IParticleOnCurve uvel(double d) {
        this.uvel = d;
        return this;
    }

    @Override
    public synchronized double uvelocity() {
        return this.uvel();
    }

    @Override
    public synchronized double uvel() {
        return this.uvel;
    }

    @Override
    public synchronized IParticleOnCurve uforce(double d) {
        return this.ufrc(d);
    }

    @Override
    public synchronized IParticleOnCurve ufrc(double d) {
        this.ufrc = d;
        return this;
    }

    @Override
    public synchronized double uforce() {
        return this.ufrc();
    }

    @Override
    public synchronized double ufrc() {
        return this.ufrc;
    }

    @Override
    public synchronized IParticleOnCurve addUForce(double d) {
        return this.upush(d);
    }

    @Override
    public synchronized IParticleOnCurve resetUForce() {
        return this.ureset();
    }

    @Override
    public synchronized IParticleOnCurve upush(double d) {
        this.ufrc += d;
        return this;
    }

    @Override
    public synchronized IParticleOnCurve upull(double d) {
        this.ufrc -= d;
        return this;
    }

    @Override
    public synchronized IParticleOnCurve ureset() {
        this.ufrc = 0.0;
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public synchronized void update() {
        if (this.fixed || this.curve == null) {
            return;
        }
        this.utan = this.curve.tan(this.upos).get();
        this.ufrc = this.frc.projectToVec(this.utan) > 0.0 ? (this.ufrc += this.frc.len() / this.utan.len()) : (this.ufrc += -this.frc.len() / this.utan.len());
        this.uvel += this.ufrc / this.mass * IConfig.updateRate;
        this.uvel *= 1.0 - this.friction;
        if (this.upos + this.uvel * IConfig.updateRate < 0.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * IConfig.updateRate;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 0.0;
                this.uvel = 0.0;
            }
        } else if (this.upos + this.uvel * IConfig.updateRate > 1.0) {
            if (this.curve.isClosed()) {
                this.upos += this.uvel * IConfig.updateRate;
                this.upos -= Math.floor(this.upos);
            } else {
                this.upos = 1.0;
                this.uvel = 0.0;
            }
        } else {
            this.upos += this.uvel * IConfig.updateRate;
        }
        this.pos.set(this.curve.pt(this.upos));
        this.frc.zero();
        this.ufrc = 0.0;
    }

    @Override
    public IParticleOnCurve x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IParticleOnCurve y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IParticleOnCurve z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IParticleOnCurve x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurve add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurve add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurve sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IParticleOnCurve div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IParticleOnCurve neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IParticleOnCurve rev() {
        return this.neg();
    }

    @Override
    public IParticleOnCurve flip() {
        return this.neg();
    }

    @Override
    public IParticleOnCurve zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IParticleOnCurve add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurve add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve add(double d, IVecI iVecI) {
        this.pos.add(d, iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve add(IDoubleI iDoubleI, IVecI iVecI) {
        this.pos.add(iDoubleI, iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IParticleOnCurve rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IParticleOnCurve rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurve rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnCurve rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticleOnCurve rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticleOnCurve rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurve rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(double d) {
        this.pos.rot2(d);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(IDoubleI iDoubleI) {
        this.pos.rot2(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurve scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IParticleOnCurve scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurve scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnCurve scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnCurve scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnCurve scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticleOnCurve scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnCurve scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticleOnCurve ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurve ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurve mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnCurve mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurve shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurve shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticleOnCurve shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnCurve shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticleOnCurve shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IParticleOnCurve shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurve shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnCurve shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurve shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IParticleOnCurve shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurve shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnCurve shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurve shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IParticleOnCurve shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurve shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnCurve shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnCurve translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnCurve translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnCurve translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IParticleOnCurve transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IParticleOnCurve transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IParticleOnCurve transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticleOnCurve transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IParticleOnCurve mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IParticleOnCurve mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticleOnCurve mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IParticleOnCurve cp() {
        return this.dup();
    }

    @Override
    public IParticleOnCurve cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IParticleOnCurve cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticleOnCurve cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

