/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IGraphicObject;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class IPointGraphic
extends IGraphicObject {
    public IVecI pt = null;
    public float weight = IConfig.pointSize;

    public IPointGraphic(IPoint iPoint) {
        super(iPoint);
        this.initPoint(iPoint.pos);
    }

    public IPointGraphic(IPointR iPointR) {
        super(iPointR);
        this.initPoint(iPointR.pos);
    }

    public void initPoint(IVecI iVecI) {
        this.pt = iVecI;
    }

    public void initPoint() {
        if (this.parent instanceof IPoint) {
            this.pt = ((IPoint)this.parent).pos;
        } else if (this.parent instanceof IPointR) {
            this.pt = ((IPointR)this.parent).pos;
        }
    }

    public void size(float f) {
        this.weight(f);
    }

    public double size() {
        return this.weight();
    }

    public void weight(float f) {
        this.weight = f;
    }

    public float weight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight(f);
    }

    public float getWeight() {
        return this.weight();
    }

    public void draw(IGraphics iGraphics) {
        if (this.pt == null) {
            this.initPoint();
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            float f;
            float f2;
            float f3;
            float f4;
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            iGraphics3D.pointSize(this.weight);
            if (this.color != null) {
                f4 = this.color.getRed();
                f3 = this.color.getGreen();
                f2 = this.color.getBlue();
                f = this.color.getAlpha();
            } else {
                f4 = IConfig.objectColor.getRed();
                f3 = IConfig.objectColor.getGreen();
                f2 = IConfig.objectColor.getBlue();
                f = IConfig.objectColor.getAlpha();
            }
            if (iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe()) {
                f = IConfig.transparentModeAlpha;
            }
            if (iGraphics3D.view().mode().isLight() && iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(f4, f3, f2, f);
                iGraphics3D.diffuse(f4, f3, f2, f);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.clr(f4, f3, f2, 0.0f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            iGraphics3D.stroke(f4, f3, f2, f);
            iGraphics3D.drawPoint(this.pt.get());
            if (iGraphics3D.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        } else if (iGraphics.view().mode().isJ2D()) {
            // empty if block
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }
}

