/*
 * Decompiled with CFR 0.152.
 */
package igeo.p;

import igeo.IBounds;
import igeo.IConfig;
import igeo.IG;
import igeo.IGraphicI;
import igeo.IObject;
import igeo.IOut;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;
import igeo.gui.IGridPanel;
import igeo.gui.INavigator;
import igeo.gui.IPane;
import igeo.gui.IPanel;
import igeo.gui.IView;
import igeo.p.PIConfig;
import igeo.p.PIInput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics3D;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIGraphics3D
extends PGraphics3D
implements IGraphics3D,
IPane {
    static boolean keepColorMode = false;
    public IPanel panel;
    public IView view;
    public IVec viewDirection;
    public IVec viewLocation;
    public int origColorMode;
    public float origColorModeX;
    public float origColorModeY;
    public float origColorModeZ;
    public float origColorModeA;
    public boolean overridePAppletFinish = true;
    public boolean finished = false;
    public boolean overridePAppletLoop = true;
    public boolean looping = true;
    public boolean enableDepthSort;
    public boolean overrideDepthSort = false;
    public int screenX = 0;
    public int screenY = 0;
    public float borderWidth = 1.0f;
    public BasicStroke borderStroke = new BasicStroke(this.borderWidth);
    public Color borderColor = Color.gray;
    public INavigator navigator;
    public boolean visible = true;
    public PImage bgImage = null;
    public PIGraphics3D[][] subGraphics = null;

    public void setParent(PApplet pApplet) {
        super.setParent(pApplet);
        try {
            this.subGraphics = new PIGraphics3D[2][2];
            this.subGraphics[0][0] = new PIGraphics3D();
            this.subGraphics[0][1] = new PIGraphics3D();
            this.subGraphics[1][0] = new PIGraphics3D();
            this.subGraphics[1][1] = new PIGraphics3D();
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.subGraphics[i][j].setSize(pApplet.getWidth() / 2, pApplet.getHeight() / 2);
                }
            }
            this.panel = new IGridPanel(0, 0, pApplet.getWidth(), pApplet.getHeight(), 2, 2, this.subGraphics);
            this.panel.setVisible(true);
            IG iG = IG.init(this.panel);
            iG.server().graphicServer().enableGL();
            if (!pApplet.online) {
                iG.setBasePath(pApplet.dataPath(""));
            }
            iG.setInputWrapper(new PIInput(pApplet));
            pApplet.addMouseListener((MouseListener)this.panel);
            pApplet.addMouseMotionListener((MouseMotionListener)this.panel);
            pApplet.addMouseWheelListener((MouseWheelListener)this.panel);
            pApplet.addKeyListener((KeyListener)this.panel);
            pApplet.addFocusListener((FocusListener)this.panel);
            pApplet.addComponentListener((ComponentListener)this.panel);
            if (PIConfig.drawBeforeProcessing) {
                pApplet.registerPre((Object)this);
            } else {
                pApplet.registerDraw((Object)this);
            }
            pApplet.registerPost((Object)this);
            this.enableDepthSort = IConfig.depthSort;
            if (this.enableDepthSort) {
                super.hint(5);
            } else {
                super.hint(-5);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setParentPGraphics3D(PApplet pApplet) {
        super.setParent(pApplet);
    }

    public void pre() {
        this.drawIG();
    }

    public void draw() {
        this.drawIG();
    }

    public void vertex(float f, float f2, float f3) {
        if (this.hints[5] && this.shape == 20 && this.vertexCount > 0 && this.vertexCount == this.shapeFirst && Math.abs(this.vertices[this.vertexCount - 1][0] - f) < 1.0E-4f && Math.abs(this.vertices[this.vertexCount - 1][1] - f2) < 1.0E-4f && Math.abs(this.vertices[this.vertexCount - 1][2] - f3) < 1.0E-4f) {
            this.vertexCheck();
            float[] fArray = this.vertices[this.vertexCount];
            this.curveVertexCount = 0;
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            float f4 = fArray[12] = this.edge ? 1.0f : 0.0f;
            if (this.fill || this.textureImage != null) {
                if (this.textureImage == null) {
                    fArray[3] = this.fillR;
                    fArray[4] = this.fillG;
                    fArray[5] = this.fillB;
                    fArray[6] = this.fillA;
                } else if (this.tint) {
                    fArray[3] = this.tintR;
                    fArray[4] = this.tintG;
                    fArray[5] = this.tintB;
                    fArray[6] = this.tintA;
                } else {
                    fArray[3] = 1.0f;
                    fArray[4] = 1.0f;
                    fArray[5] = 1.0f;
                    fArray[6] = 1.0f;
                }
                fArray[25] = this.ambientR;
                fArray[26] = this.ambientG;
                fArray[27] = this.ambientB;
                fArray[28] = this.specularR;
                fArray[29] = this.specularG;
                fArray[30] = this.specularB;
                fArray[31] = this.shininess;
                fArray[32] = this.emissiveR;
                fArray[33] = this.emissiveG;
                fArray[34] = this.emissiveB;
            }
            if (this.stroke) {
                fArray[13] = this.strokeR;
                fArray[14] = this.strokeG;
                fArray[15] = this.strokeB;
                fArray[16] = this.strokeA;
                fArray[17] = this.strokeWeight;
            }
            if (this.textureImage != null) {
                fArray[7] = this.textureU;
                fArray[8] = this.textureV;
            }
            fArray[9] = this.normalX;
            fArray[10] = this.normalY;
            fArray[11] = this.normalZ;
            fArray[35] = 0.0f;
            ++this.vertexCount;
        } else {
            super.vertex(f, f2, f3);
        }
    }

    public void drawIG() {
        if (this.panel != null) {
            this.panel.draw(this);
        }
    }

    public void post() {
        if (this.overridePAppletFinish) {
            this.parent.finished = this.finished;
        }
        if (this.overridePAppletLoop) {
            if (this.looping) {
                this.parent.loop();
            } else {
                this.parent.noLoop();
            }
        }
    }

    public void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public void noLoop() {
        if (this.looping) {
            this.looping = false;
        }
    }

    public void start() {
        if (this.finished) {
            this.finished = false;
        }
    }

    public void stop() {
        if (!this.finished) {
            this.finished = true;
        }
    }

    @Override
    public IGraphicMode.GraphicType type() {
        return IGraphicMode.GraphicType.P3D;
    }

    @Override
    public IView view() {
        return this.view;
    }

    public PImage createBGImage(int n, int n2, IView iView) {
        int n3;
        PImage pImage = new PImage(n, n2);
        float[][][] fArray = new float[2][2][3];
        for (n3 = 0; n3 < 2; ++n3) {
            for (int i = 0; i < 2; ++i) {
                fArray[n3][i][0] = iView.bgColor[n3][i].getRed();
                fArray[n3][i][1] = iView.bgColor[n3][i].getGreen();
                fArray[n3][i][2] = iView.bgColor[n3][i].getBlue();
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            float f = (float)(n2 - n3) / (float)n2;
            for (int i = 0; i < n; ++i) {
                float f2 = (float)(n - i) / (float)n;
                int n4 = (int)(f * (f2 * fArray[0][0][0] + (1.0f - f2) * fArray[1][0][0]) + (1.0f - f) * (f2 * fArray[0][1][0] + (1.0f - f2) * fArray[1][1][0]));
                int n5 = (int)(f * (f2 * fArray[0][0][1] + (1.0f - f2) * fArray[1][0][1]) + (1.0f - f) * (f2 * fArray[0][1][1] + (1.0f - f2) * fArray[1][1][1]));
                int n6 = (int)(f * (f2 * fArray[0][0][2] + (1.0f - f2) * fArray[1][0][2]) + (1.0f - f) * (f2 * fArray[0][1][2] + (1.0f - f2) * fArray[1][1][2]));
                pImage.set(i, n3, 0xFF000000 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF);
            }
        }
        return pImage;
    }

    public void drawBG(IView iView) {
        if (iView.bgColor != null) {
            if (this.bgImage == null) {
                this.bgImage = this.createBGImage(this.width, this.height, iView);
            }
            this.background(this.bgImage);
        }
    }

    public void drawView(IView iView) {
        this.drawBG(iView);
        this.viewLocation = iView.location();
        this.viewDirection = iView.frontDirection();
        if (iView.mode.isLight()) {
            super.lights();
        }
        if (!this.overrideDepthSort && IConfig.depthSort != this.enableDepthSort) {
            if (IConfig.depthSort) {
                this.enableDepthSort = true;
                super.hint(5);
            } else {
                this.enableDepthSort = false;
                super.hint(-5);
            }
        }
        if (IConfig.smoothGraphicP3D) {
            super.smooth();
        }
        super.translate((float)(iView.screenWidth / 2), (float)(iView.screenHeight / 2), 0.0f);
        super.scale(1.0f, -1.0f, 1.0f);
        if (iView.axonometric) {
            double d = (double)iView.screenWidth * iView.axonRatio;
            double d2 = (double)iView.screenHeight * iView.axonRatio;
            super.ortho((float)(-d) / 2.0f, (float)d / 2.0f, (float)(-d2) / 2.0f, (float)d2 / 2.0f, (float)iView.near, (float)iView.far);
        } else {
            super.scale((float)iView.screenHeight);
            double d = iView.near * iView.persRatio * 2.0;
            double d3 = d * (double)iView.screenWidth / (double)iView.screenHeight;
            super.frustum((float)(-d3) / 2.0f, (float)d3 / 2.0f, (float)(-d) / 2.0f, (float)d / 2.0f, (float)iView.near, (float)iView.far);
        }
        super.applyMatrix((float)iView.transformArray[0], (float)iView.transformArray[4], (float)iView.transformArray[8], (float)iView.transformArray[12], (float)iView.transformArray[1], (float)iView.transformArray[5], (float)iView.transformArray[9], (float)iView.transformArray[13], (float)iView.transformArray[2], (float)iView.transformArray[6], (float)iView.transformArray[10], (float)iView.transformArray[14], (float)iView.transformArray[3], (float)iView.transformArray[7], (float)iView.transformArray[11], (float)iView.transformArray[15]);
    }

    @Override
    public synchronized void draw(ArrayList<IGraphicI> arrayList, IView iView) {
        this.view = iView;
        if (this.view.hide) {
            return;
        }
        if (this.enableDepthSort) {
            if (arrayList != null && IConfig.maxObjectNumberForDepthSort > 0 && arrayList.size() > IConfig.maxObjectNumberForDepthSort) {
                if (!this.overrideDepthSort) {
                    this.overrideDepthSort = true;
                    this.enableDepthSort = false;
                    super.hint(-5);
                    IOut.err("number of graphic objects (" + arrayList.size() + ") exceeds IConfig.maxObjectNumberForDepthSort (" + IConfig.maxObjectNumberForDepthSort + ")");
                    IOut.err("depth sort is disalbed");
                }
            } else if (IConfig.maxObjectNumberForDepthSort > 0 && this.overrideDepthSort) {
                this.overrideDepthSort = false;
            }
        }
        super.beginDraw();
        this.drawView(this.view);
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (!arrayList.get(i).isVisible()) continue;
                arrayList.get(i).draw(this);
            }
        }
        if (this.view.mode().isLight()) {
            this.disableLight();
        }
        super.endDraw();
    }

    public boolean isDefaultColorMode() {
        return this.colorMode == 1 && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f && this.colorModeA == 255.0f;
    }

    public void pushColorMode() {
        this.origColorMode = this.colorMode;
        this.origColorModeX = this.colorModeX;
        this.origColorModeY = this.colorModeY;
        this.origColorModeZ = this.colorModeZ;
        this.origColorModeA = this.colorModeA;
    }

    public void popColorMode() {
        super.colorMode(this.origColorMode, this.origColorModeX, this.origColorModeY, this.origColorModeZ, this.origColorModeA);
    }

    @Override
    public void clr(Color color) {
        this.clr(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    public void clr(float f, float f2, float f3) {
        this.clr(f, f2, f3, 255.0f);
    }

    @Override
    public void clr(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            super.fill(f, f2, f3, f4);
            this.popColorMode();
        } else {
            super.fill(f, f2, f3, f4);
        }
    }

    @Override
    public void stroke(Color color) {
        this.stroke(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @Override
    public void stroke(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            super.stroke(f, f2, f3, f4);
            this.popColorMode();
        } else {
            super.stroke(f, f2, f3, f4);
        }
    }

    @Override
    public void stroke(float f, float f2, float f3) {
        this.stroke(f, f2, f3, 255.0f);
    }

    @Override
    public void weight(float f) {
        super.strokeWeight(f);
    }

    @Override
    public void diffuse(float f, float f2, float f3, float f4) {
        this.clr(f, f2, f3, f4);
    }

    @Override
    public void diffuse(float f, float f2, float f3) {
        this.clr(f, f2, f3, 255.0f);
    }

    @Override
    public void diffuse(Color color) {
        this.clr(color);
    }

    @Override
    public void ambient(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            super.ambient(f, f2, f3);
            this.popColorMode();
        } else {
            super.ambient(f, f2, f3);
        }
    }

    @Override
    public void ambient(float f, float f2, float f3) {
        this.ambient(f, f2, f3, 255.0f);
    }

    @Override
    public void ambient(Color color) {
        this.ambient(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void specular(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            super.specular(f, f2, f3);
            this.popColorMode();
        } else {
            super.specular(f, f2, f3);
        }
    }

    @Override
    public void specular(float f, float f2, float f3) {
        this.specular(f, f2, f3, 255.0f);
    }

    @Override
    public void specular(Color color) {
        this.specular(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void emissive(float f, float f2, float f3, float f4) {
        if (keepColorMode && !this.isDefaultColorMode()) {
            this.pushColorMode();
            super.emissive(f, f2, f3);
            this.popColorMode();
        } else {
            super.emissive(f, f2, f3);
        }
    }

    @Override
    public void emissive(float f, float f2, float f3) {
        this.emissive(f, f2, f3, 255.0f);
    }

    @Override
    public void emissive(Color color) {
        this.emissive(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void shininess(float f) {
        super.shininess(f);
    }

    @Override
    public void enableLight() {
        super.lights();
    }

    @Override
    public void disableLight() {
        super.noLights();
    }

    @Override
    public void pointSize(float f) {
        this.weight(f);
    }

    public boolean isInFront(IVec iVec) {
        return iVec.dif(this.viewLocation).dot(this.viewDirection) > 0.0;
    }

    public void vertex(IVec iVec) {
        this.vertex((float)iVec.x, (float)iVec.y, (float)iVec.z);
    }

    public void vertex(IVec[] iVecArray) {
        for (int i = 0; i < iVecArray.length; ++i) {
            this.vertex((float)iVecArray[i].x, (float)iVecArray[i].y, (float)iVecArray[i].z);
        }
    }

    public void vertex(IVec[] iVecArray, IVec[] iVecArray2) {
        for (int i = 0; i < iVecArray.length; ++i) {
            super.normal((float)iVecArray2[i].x, (float)iVecArray2[i].y, (float)iVecArray2[i].z);
            this.vertex((float)iVecArray[i].x, (float)iVecArray[i].y, (float)iVecArray[i].z);
        }
    }

    public void normal(IVec iVec) {
        super.normal((float)iVec.x, (float)iVec.y, (float)iVec.z);
    }

    @Override
    public void drawPoint(IVec iVec) {
        this.stroke = true;
        this.fill = false;
        super.beginShape(4);
        if (IConfig.cullVertexBehindViewInP3D) {
            if (this.isInFront(iVec)) {
                this.vertex(iVec);
                this.vertex(iVec);
            }
        } else {
            this.vertex(iVec);
            this.vertex(iVec);
        }
        super.endShape();
    }

    @Override
    public void drawPoints(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        super.beginShape(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i]);
        }
        super.endShape();
    }

    @Override
    public void drawLines(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        super.beginShape(4);
        for (int i = 0; i < iVecArray.length - 1; i += 2) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i + 1]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i + 1]);
        }
        super.endShape();
    }

    @Override
    public void drawLineStrip(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl3) {
                    if (bl2) {
                        this.vertex(iVecArray[i]);
                    } else {
                        super.beginShape(20);
                        this.vertex(iVecArray[i]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(20);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawLineLoop(IVec[] iVecArray) {
        this.stroke = true;
        this.fill = false;
        if (IConfig.cullVertexBehindViewInP3D) {
            int n;
            boolean[] blArray = new boolean[iVecArray.length];
            boolean bl = false;
            for (n = 0; n < iVecArray.length; ++n) {
                blArray[n] = this.isInFront(iVecArray[n]);
                if (blArray[n]) continue;
                bl = true;
            }
            if (bl) {
                n = 0;
                boolean bl2 = false;
                for (int i = 0; i <= iVecArray.length; ++i) {
                    int n2 = blArray[i % iVecArray.length];
                    if (n2 != 0) {
                        if (bl2) {
                            this.vertex(iVecArray[i % iVecArray.length]);
                        } else {
                            super.beginShape(20);
                            this.vertex(iVecArray[i % iVecArray.length]);
                            bl2 = true;
                        }
                    } else if (bl2) {
                        super.endShape();
                        bl2 = false;
                    }
                    n = n2;
                }
                if (bl2) {
                    super.endShape();
                }
            } else {
                super.beginShape(20);
                for (n = 0; n < iVecArray.length; ++n) {
                    this.vertex(iVecArray[n]);
                }
                super.endShape(2);
            }
        } else {
            super.beginShape(20);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape(2);
        }
    }

    @Override
    public void drawPolygon(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.vertex(iVecArray[i]);
                continue;
            }
            this.vertex(iVecArray[i]);
        }
        super.endShape(2);
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(20);
        for (int i = 0; i < iVecArray.length; ++i) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i]);
        }
        super.endShape(2);
    }

    @Override
    public void drawQuads(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(16);
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i + 1]);
                this.vertex(iVecArray[i + 2]);
                this.vertex(iVecArray[i + 3]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i + 1]);
            this.vertex(iVecArray[i + 2]);
            this.vertex(iVecArray[i + 3]);
        }
        super.endShape();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(16);
        for (int i = 0; i < iVecArray.length - 3; i += 4) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2]) || !this.isInFront(iVecArray[i + 3])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
                this.normal(iVecArray2[i + 3]);
                this.vertex(iVecArray[i + 3]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i]);
            this.normal(iVecArray2[i + 1]);
            this.vertex(iVecArray[i + 1]);
            this.normal(iVecArray2[i + 2]);
            this.vertex(iVecArray[i + 2]);
            this.normal(iVecArray2[i + 3]);
            this.vertex(iVecArray[i + 3]);
        }
        super.endShape();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length - 1; i += 2) {
                boolean bl3;
                boolean bl4 = bl3 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                if (bl3) {
                    if (bl2) {
                        this.vertex(iVecArray[i]);
                        this.vertex(iVecArray[i + 1]);
                    } else {
                        super.beginShape(17);
                        this.vertex(iVecArray[i]);
                        this.vertex(iVecArray[i + 1]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(17);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < iVecArray.length - 1; i += 2) {
                boolean bl3;
                boolean bl4 = bl3 = this.isInFront(iVecArray[i]) && this.isInFront(iVecArray[i + 1]);
                if (bl3) {
                    if (bl2) {
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                    } else {
                        super.beginShape(17);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                        this.normal(iVecArray2[i + 1]);
                        this.vertex(iVecArray[i + 1]);
                        bl2 = true;
                    }
                } else if (bl2) {
                    super.endShape();
                    bl2 = false;
                }
                bl = bl3;
            }
            if (bl2) {
                super.endShape();
            }
        } else {
            super.beginShape(17);
            for (int i = 0; i < iVecArray.length; ++i) {
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray) {
        this.stroke = false;
        this.fill = true;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            int n;
            if (IConfig.cullVertexBehindViewInP3D) {
                n = 0;
                boolean bl = false;
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    int n2;
                    int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                    if (n2 != 0) {
                        if (bl) {
                            this.vertex(iVecArray[i][j]);
                            this.vertex(iVecArray[i + 1][j]);
                        } else {
                            super.beginShape(17);
                            this.vertex(iVecArray[i][j]);
                            this.vertex(iVecArray[i + 1][j]);
                            bl = true;
                        }
                    } else if (bl) {
                        super.endShape();
                        bl = false;
                    }
                    n = n2;
                }
                if (!bl) continue;
                super.endShape();
                continue;
            }
            super.beginShape(17);
            for (n = 0; n < iVecArray[i].length; ++n) {
                this.vertex(iVecArray[i][n]);
                this.vertex(iVecArray[i + 1][n]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            int n;
            if (IConfig.cullVertexBehindViewInP3D) {
                n = 0;
                boolean bl = false;
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    int n2;
                    int n3 = n2 = this.isInFront(iVecArray[i][j]) && this.isInFront(iVecArray[i + 1][j]) ? 1 : 0;
                    if (n2 != 0) {
                        if (bl) {
                            this.normal(iVecArray2[i][j]);
                            this.vertex(iVecArray[i][j]);
                            this.normal(iVecArray2[i + 1][j]);
                            this.vertex(iVecArray[i + 1][j]);
                        } else {
                            super.beginShape(17);
                            this.normal(iVecArray2[i][j]);
                            this.vertex(iVecArray[i][j]);
                            this.normal(iVecArray2[i + 1][j]);
                            this.vertex(iVecArray[i + 1][j]);
                            bl = true;
                        }
                    } else if (bl) {
                        super.endShape();
                        bl = false;
                    }
                    n = n2;
                }
                if (!bl) continue;
                super.endShape();
                continue;
            }
            super.beginShape(17);
            for (n = 0; n < iVecArray[i].length; ++n) {
                this.normal(iVecArray2[i][n]);
                this.vertex(iVecArray[i][n]);
                this.normal(iVecArray2[i + 1][n]);
                this.vertex(iVecArray[i + 1][n]);
            }
            super.endShape();
        }
    }

    @Override
    public void drawTriangles(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                this.vertex(iVecArray[i]);
                this.vertex(iVecArray[i + 1]);
                this.vertex(iVecArray[i + 2]);
                continue;
            }
            this.vertex(iVecArray[i]);
            this.vertex(iVecArray[i + 1]);
            this.vertex(iVecArray[i + 2]);
        }
        super.endShape();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        super.beginShape(9);
        for (int i = 0; i < iVecArray.length - 2; i += 3) {
            if (IConfig.cullVertexBehindViewInP3D) {
                if (!this.isInFront(iVecArray[i]) || !this.isInFront(iVecArray[i + 1]) || !this.isInFront(iVecArray[i + 2])) continue;
                this.normal(iVecArray2[i]);
                this.vertex(iVecArray[i]);
                this.normal(iVecArray2[i + 1]);
                this.vertex(iVecArray[i + 1]);
                this.normal(iVecArray2[i + 2]);
                this.vertex(iVecArray[i + 2]);
                continue;
            }
            this.normal(iVecArray2[i]);
            this.vertex(iVecArray[i]);
            this.normal(iVecArray2[i + 1]);
            this.vertex(iVecArray[i + 1]);
            this.normal(iVecArray2[i + 2]);
            this.vertex(iVecArray[i + 2]);
        }
        super.endShape();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl4 = this.isInFront(iVecArray[i]);
                if (bl4) {
                    if (bl) {
                        this.vertex(iVecArray[i]);
                    } else {
                        super.beginShape(10);
                        this.vertex(iVecArray[i]);
                        bl = true;
                    }
                } else if (bl) {
                    super.endShape();
                    bl = false;
                }
                bl3 = bl2;
                bl2 = bl4;
            }
            if (bl) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            this.vertex(iVecArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        if (iVecArray.length < 3) {
            return;
        }
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i = 0; i < iVecArray.length; ++i) {
                boolean bl4 = this.isInFront(iVecArray[i]);
                if (bl4) {
                    if (bl) {
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                    } else {
                        super.beginShape(10);
                        this.normal(iVecArray2[i]);
                        this.vertex(iVecArray[i]);
                    }
                } else if (bl) {
                    super.endShape();
                    bl = false;
                }
                bl3 = bl2;
                bl2 = bl4;
            }
            if (bl) {
                super.endShape();
            }
        } else {
            super.beginShape(10);
            this.vertex(iVecArray, iVecArray2);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl;
            super.beginShape(11);
            this.vertex(iVecArray[0]);
            boolean bl2 = bl = this.isInFront(iVecArray[0]);
            for (int i = 1; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl || bl2 || bl3) {
                    this.vertex(iVecArray[i]);
                }
                bl2 = bl3;
            }
            super.endShape();
        } else {
            super.beginShape(11);
            this.vertex(iVecArray);
            super.endShape();
        }
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2) {
        this.stroke = false;
        this.fill = true;
        if (IConfig.cullVertexBehindViewInP3D) {
            boolean bl;
            super.beginShape(11);
            this.normal(iVecArray2[0]);
            this.vertex(iVecArray[0]);
            boolean bl2 = bl = this.isInFront(iVecArray[0]);
            for (int i = 1; i < iVecArray.length; ++i) {
                boolean bl3 = this.isInFront(iVecArray[i]);
                if (bl || bl2 || bl3) {
                    this.normal(iVecArray2[i]);
                    this.vertex(iVecArray[i]);
                }
                bl2 = bl3;
            }
            super.endShape();
        } else {
            super.beginShape(11);
            this.vertex(iVecArray, iVecArray2);
            super.endShape();
        }
    }

    @Override
    public synchronized void setLocation(int n, int n2) {
        this.screenX = n;
        this.screenY = n2;
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public synchronized void setSize(int n, int n2) {
        if (this.view != null) {
            this.bgImage = this.createBGImage(n, n2, this.view);
        }
        super.setSize(n, n2);
        if (this.view != null) {
            this.view.setPane(this);
        }
    }

    @Override
    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        this.setSize(n3, n4);
        this.screenX = n;
        this.screenY = n2;
    }

    @Override
    public int getX() {
        return this.screenX;
    }

    @Override
    public int getY() {
        return this.screenY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean contains(int n, int n2) {
        if (n < this.screenX) {
            return false;
        }
        if (n2 < this.screenY) {
            return false;
        }
        if (n >= this.screenX + this.width) {
            return false;
        }
        return n2 < this.screenY + this.height;
    }

    @Override
    public void setPanel(IPanel iPanel) {
        this.panel = iPanel;
    }

    @Override
    public IPanel getPanel() {
        return this.panel;
    }

    @Override
    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    @Override
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public Stroke getBorderStroke() {
        return null;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public INavigator navigator() {
        return this.navigator;
    }

    @Override
    public void setView(IView iView) {
        this.view = iView;
        this.view.setPane(this);
        IGraphicMode iGraphicMode = new IGraphicMode(this.view.mode());
        iGraphicMode.setGraphicType(IGraphicMode.GraphicType.P3D);
        this.view.setMode(iGraphicMode);
        if (this.navigator == null) {
            this.navigator = new INavigator(this.view, this);
        } else {
            this.navigator.setView(this.view);
        }
    }

    @Override
    public IView getView() {
        return this.view;
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (this.view != null) {
            ArrayList<IGraphicI> arrayList = this.panel.ig.server().graphicServer().getObjects(this.view);
            this.draw(arrayList, this.view);
            ((PIGraphics3D)iGraphics).set(this.screenX, this.screenY, (PImage)this);
        } else {
            IOut.err("view is null");
        }
    }

    @Override
    public void focus() {
        this.panel.setBounds();
        this.view.focus(this.panel.getBounds());
    }

    @Override
    public void focus(ArrayList<IObject> arrayList) {
        IBounds iBounds = new IBounds();
        iBounds.setObjects(arrayList);
        this.view.focus(iBounds);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.navigator.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.navigator.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.navigator.mouseClicked(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.navigator.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.navigator.mouseExited(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.navigator.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.navigator.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.navigator.mouseWheelMoved(mouseWheelEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.navigator.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.navigator.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.navigator.keyTyped(keyEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

