/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IGraphicObject;
import igeo.IVec;
import igeo.IVectorObject;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class IVectorGraphic
extends IGraphicObject {
    public static IVec arrowHeadNormal = new IVec(0.0, 0.0, 1.0);
    public static IVec arrowHeadNormal2 = new IVec(0.0, 1.0, 0.0);
    public IVectorObject vec = null;
    public float size = IConfig.arrowSize;
    public float weight = IConfig.strokeWeight;

    public IVectorGraphic(IVectorObject iVectorObject) {
        super(iVectorObject);
        this.vec = iVectorObject;
    }

    public void size(double d) {
        this.size = (float)d;
    }

    public double size() {
        return this.size;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public float getWeight() {
        return this.weight;
    }

    public void draw(IGraphics iGraphics) {
        if (this.vec == null) {
            return;
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            float f;
            float f2;
            float f3;
            float f4;
            IVec iVec = this.vec.root.get();
            IVec iVec2 = this.vec.vec.get();
            IVec iVec3 = null;
            iVec3 = iVec2.isParallel(arrowHeadNormal) ? iVec2.cross(arrowHeadNormal2) : iVec2.cross(arrowHeadNormal);
            iVec3.len(this.size / 2.0f * IConfig.arrowWidthRatio);
            IVec iVec4 = this.vec.vec.get().dup().rev().len(this.size);
            IVec[] iVecArray = new IVec[2];
            IVec[] iVecArray2 = new IVec[3];
            iVecArray[0] = iVec;
            iVecArray[1] = iVec.dup().add(iVec2);
            iVecArray2[0] = iVec2.dup().add(iVec4).sub(iVec3).add(iVec);
            iVecArray2[1] = iVec2.dup().add(iVec);
            iVecArray2[2] = iVec2.dup().add(iVec4).add(iVec3).add(iVec);
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            iGraphics3D.weight(this.weight);
            if (this.color != null) {
                f4 = this.color.getRed();
                f3 = this.color.getGreen();
                f2 = this.color.getBlue();
                f = this.color.getAlpha();
            } else {
                f4 = IConfig.objectColor.getRed();
                f3 = IConfig.objectColor.getGreen();
                f2 = IConfig.objectColor.getBlue();
                f = IConfig.objectColor.getAlpha();
            }
            if (iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe()) {
                f = IConfig.transparentModeAlpha;
            }
            if (iGraphics3D.view().mode().isTransparent()) {
                f = IConfig.transparentModeAlpha;
            }
            if (iGraphics3D.view().mode().isLight()) {
                iGraphics3D.ambient(f4, f3, f2, f);
                iGraphics3D.diffuse(f4, f3, f2, f);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.clr(f4, f3, f2, 0.0f);
            } else {
                iGraphics3D.clr(f4, f3, f2, f);
            }
            if (iGraphics3D.view().mode().isFill()) {
                iVecArray[1].add(iVec4);
                iGraphics3D.drawLines(iVecArray);
                if (iGraphics3D.view().mode().isTransparent()) {
                    f = IConfig.transparentModeAlpha;
                }
                iGraphics3D.clr(f4, f3, f2, f);
                iGraphics3D.drawTriangles(iVecArray2);
            }
            f = iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe() ? (float)IConfig.transparentModeAlpha : (this.color != null ? (float)this.color.getAlpha() : (float)IConfig.objectColor.getAlpha());
            if (iGraphics3D.view().mode().isLight() && iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(f4, f3, f2, f);
                iGraphics3D.diffuse(f4, f3, f2, f);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.stroke(f4, f3, f2, 0.0f);
            } else {
                iGraphics3D.stroke(f4, f3, f2, f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            iGraphics3D.stroke(f4, f3, f2, f);
            if (iGraphics3D.view().mode().isWireframe()) {
                iGraphics3D.stroke(f4, f3, f2, f);
                iGraphics3D.drawLines(iVecArray);
                if (iGraphics3D.view().mode().isFill()) {
                    iGraphics3D.drawLineLoop(iVecArray2);
                } else {
                    iGraphics3D.drawLineStrip(iVecArray2);
                }
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        } else if (iGraphics.view().mode().isJ2D()) {
            // empty if block
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }
}

