/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBrep;
import igeo.ICurve;
import igeo.IDynamicsBase;
import igeo.IGeometry;
import igeo.IMesh;
import igeo.IOut;
import igeo.IParticleI;
import igeo.IPointAgent;
import igeo.ISurface;
import igeo.IVec;
import igeo.IVecI;

public class IAgentTracker
extends IDynamicsBase {
    public static boolean setAgentAttributes = true;
    public static IVec defaultOrientation = new IVec(0.0, 1.0, 0.0);
    public IGeometry[] geometries;
    public IPointAgent agent;
    public IParticleI particle;
    public IVec prevPos;
    public IVec prevVel;
    public IVec rotAxis;
    public double rotAngle = 0.0;
    public boolean orient = true;

    public IAgentTracker(IPointAgent iPointAgent, IGeometry ... iGeometryArray) {
        this.geometries = iGeometryArray;
        this.initTracker(iPointAgent);
    }

    public IAgentTracker(IPointAgent iPointAgent, IVecI iVecI, IGeometry[] iGeometryArray) {
        this.geometries = iGeometryArray;
        this.initTracker(iVecI, iPointAgent);
    }

    public IAgentTracker(IPointAgent iPointAgent, IVecI iVecI, IVecI iVecI2, IGeometry[] iGeometryArray) {
        this.geometries = iGeometryArray;
        this.initTracker(iVecI, iVecI2, iPointAgent);
    }

    public int geometryNum() {
        return this.geometries.length;
    }

    public IGeometry geometry(int n) {
        return this.geometries[n];
    }

    public IGeometry geometry() {
        if (this.geometries.length == 0) {
            return null;
        }
        return this.geometries[0];
    }

    public ICurve curve() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!(this.geometries[i] instanceof ICurve)) continue;
            return (ICurve)this.geometries[i];
        }
        return null;
    }

    public ISurface surface() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!(this.geometries[i] instanceof ISurface)) continue;
            return (ISurface)this.geometries[i];
        }
        return null;
    }

    public IBrep brep() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!(this.geometries[i] instanceof IBrep)) continue;
            return (IBrep)this.geometries[i];
        }
        return null;
    }

    public IMesh mesh() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (!(this.geometries[i] instanceof IMesh)) continue;
            return (IMesh)this.geometries[i];
        }
        return null;
    }

    public IAgentTracker show() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].show();
        }
        return this;
    }

    public IAgentTracker hide() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].hide();
        }
        return this;
    }

    public void del() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].del();
        }
        this.geometries = new IGeometry[0];
        this.parent.deleteDynamics(this);
    }

    public IAgentTracker orient(boolean bl) {
        if (this.particle != null) {
            this.orient = bl;
        } else {
            IOut.err("parent is not particle. orient is changed.");
        }
        return this;
    }

    public void initTracker(IPointAgent iPointAgent) {
        IVec iVec = new IVec();
        for (int i = 0; i < this.geometries.length; ++i) {
            iVec.add(this.geometries[i].center());
        }
        iVec.div(this.geometries.length);
        this.initTracker(iVec, iPointAgent);
    }

    public void initTracker(IVecI iVecI, IPointAgent iPointAgent) {
        this.initTracker(iVecI, defaultOrientation, iPointAgent);
    }

    public void initTracker(IVecI iVecI, IVecI iVecI2, IPointAgent iPointAgent) {
        int n;
        this.agent = iPointAgent;
        this.agent.addDynamics(this);
        if (this.agent instanceof IParticleI) {
            this.particle = (IParticleI)((Object)this.agent);
        } else {
            this.orient = false;
        }
        if (iVecI2 == null) {
            this.orient = false;
        }
        if (setAgentAttributes) {
            int n2;
            if (this.agent.attr() != null) {
                for (n2 = 0; n2 < this.geometries.length; ++n2) {
                    this.geometries[n2].attr(this.agent.attr());
                }
            } else if (this.agent.clr() != null) {
                for (n2 = 0; n2 < this.geometries.length; ++n2) {
                    this.geometries[n2].clr(this.agent.clr());
                }
            }
        }
        IVec iVec = this.agent.pos().dif(iVecI);
        boolean bl = false;
        if (iVec.len() > 0.0) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].add(iVec);
            }
            bl = true;
        }
        this.prevPos = this.agent.pos().dup();
        if (this.particle != null && iVecI2 != null) {
            this.prevVel = this.particle.vel().dup();
            if (this.prevVel.len() == 0.0) {
                this.prevVel = iVecI2.get();
            } else if (iVecI2.len() > 0.0) {
                this.rotAngle = iVecI2.angle(this.prevVel);
                this.rotAxis = iVecI2.get().cross(this.prevVel);
                if (this.rotAngle != 0.0) {
                    for (n = 0; n < this.geometries.length; ++n) {
                        this.geometries[n].rot((IVecI)this.agent.pos(), (IVecI)this.rotAxis, this.rotAngle);
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].updateGraphic();
            }
        }
    }

    public void update() {
        int n;
        this.prevPos.sub(this.agent.pos()).neg();
        if (this.orient && this.particle != null) {
            if (this.particle.vel().len() == 0.0) {
                this.rotAngle = 0.0;
            } else {
                this.rotAngle = this.prevVel.angle(this.particle.vel());
                this.rotAxis = this.prevVel.cross(this.particle.vel());
                this.prevVel = this.particle.vel().dup();
                if (this.rotAxis.len() == 0.0) {
                    this.rotAngle = 0.0;
                }
            }
        }
        boolean bl = false;
        if (this.prevPos.len() > 0.0) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].add(this.prevPos);
            }
            bl = true;
        }
        if (this.orient && this.rotAngle != 0.0) {
            for (n = 0; n < this.geometries.length; ++n) {
                if (!this.orient || this.rotAngle == 0.0) continue;
                this.geometries[n].rot((IVecI)this.agent.pos(), (IVecI)this.rotAxis, this.rotAngle);
            }
            bl = true;
        }
        if (bl) {
            for (n = 0; n < this.geometries.length; ++n) {
                this.geometries[n].updateGraphic();
            }
        }
        this.prevPos.set(this.agent.pos());
    }
}

