/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IColor;
import igeo.IConfig;
import igeo.IVec;
import igeo.IVecI;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRand {
    public static final long defaultSeed = 1L;
    protected static Random random = null;

    public static void init() {
        IRand.init(1L);
    }

    public static void init(long l) {
        random = new Random(l);
    }

    public static void initByTime() {
        random = new Random(System.currentTimeMillis());
    }

    public static double get() {
        if (random == null) {
            IRand.init();
        }
        return random.nextDouble();
    }

    public static double getDouble(double d, double d2) {
        return IRand.get(d, d2);
    }

    public static double getDouble(double d) {
        return IRand.get(d);
    }

    public static double getDouble() {
        return IRand.get();
    }

    public static double get(double d, double d2) {
        if (random == null) {
            IRand.init();
        }
        return random.nextDouble() * (d2 - d) + d;
    }

    public static double get(double d) {
        if (random == null) {
            IRand.init();
        }
        return random.nextDouble() * d;
    }

    public static float getf() {
        if (random == null) {
            IRand.init();
        }
        return random.nextFloat();
    }

    public static float getf(float f, float f2) {
        if (random == null) {
            IRand.init();
        }
        return random.nextFloat() * (f2 - f) + f;
    }

    public static float getf(float f) {
        if (random == null) {
            IRand.init();
        }
        return random.nextFloat() * f;
    }

    public static float getFloat() {
        return IRand.getf();
    }

    public static float getFloat(float f, float f2) {
        return IRand.getf(f, f2);
    }

    public static float getFloat(float f) {
        return IRand.getf(f);
    }

    public static int geti(int n, int n2) {
        int n3 = (int)IRand.get(n, n2 + 1);
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public static int geti(int n) {
        int n2 = (int)IRand.get(0.0, n + 1);
        if (n2 > n) {
            n2 = n;
        }
        return n2;
    }

    public static int geti() {
        int n = (int)IRand.get(0.0, 2.0);
        if (n > 1) {
            n = 1;
        }
        return n;
    }

    public static int getInt(int n, int n2) {
        return IRand.geti(n, n2);
    }

    public static int getInt(int n) {
        return IRand.geti(n);
    }

    public static int getInt() {
        return IRand.geti();
    }

    public static int getInteger(int n, int n2) {
        return IRand.geti(n, n2);
    }

    public static int getInteger(int n) {
        return IRand.geti(n);
    }

    public static int getInteger() {
        return IRand.geti();
    }

    public static <T> T get(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        return TArray[IRand.geti(0, TArray.length - 1)];
    }

    public static <T> T get(List<T> list) {
        if (list == null) {
            return null;
        }
        return list.get(IRand.geti(0, list.size() - 1));
    }

    public static IVec pt(IVec iVec, IVec iVec2) {
        return new IVec(IRand.get(iVec.x, iVec2.x), IRand.get(iVec.y, iVec2.y), IRand.get(iVec.z, iVec2.z));
    }

    public static IVec point(IVec iVec, IVec iVec2) {
        return IRand.pt(iVec, iVec2);
    }

    public static IVec getPoint(IVec iVec, IVec iVec2) {
        return IRand.pt(iVec, iVec2);
    }

    public static IVec pt(IVec iVec) {
        return new IVec(IRand.get(iVec.x), IRand.get(iVec.y), IRand.get(iVec.z));
    }

    public static IVec point(IVec iVec) {
        return IRand.pt(iVec);
    }

    public static IVec getPoint(IVec iVec) {
        return IRand.pt(iVec);
    }

    public static IVec pt(double d, double d2, double d3, double d4, double d5, double d6) {
        return new IVec(IRand.get(d, d4), IRand.get(d2, d5), IRand.get(d3, d6));
    }

    public static IVec pt(double d, double d2, double d3) {
        return new IVec(IRand.get(d), IRand.get(d2), IRand.get(d3));
    }

    public static IVec pt(double d, double d2, double d3, double d4) {
        return new IVec(IRand.get(d, d3), IRand.get(d2, d4), 0.0);
    }

    public static IVec pt(double d, double d2) {
        return new IVec(IRand.get(d, d2), IRand.get(d, d2), IRand.get(d, d2));
    }

    public static IVec pt(double d) {
        return new IVec(IRand.get(0.0, d), IRand.get(0.0, d), IRand.get(0.0, d));
    }

    public static IVec pt() {
        return new IVec(IRand.get(), IRand.get(), IRand.get());
    }

    public static IVec point(double d, double d2, double d3, double d4, double d5, double d6) {
        return IRand.pt(d, d2, d3, d4, d5, d6);
    }

    public static IVec point(double d, double d2, double d3, double d4) {
        return IRand.pt(d, d2, d3, d4);
    }

    public static IVec point(double d, double d2, double d3) {
        return IRand.pt(d, d2, d3);
    }

    public static IVec point(double d, double d2) {
        return IRand.pt(d, d2);
    }

    public static IVec point(double d) {
        return IRand.pt(d);
    }

    public static IVec point() {
        return IRand.pt();
    }

    public static IVec getPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        return IRand.pt(d, d2, d3, d4, d5, d6);
    }

    public static IVec getPoint(double d, double d2, double d3, double d4) {
        return IRand.pt(d, d2, d3, d4);
    }

    public static IVec getPoint(double d, double d2, double d3) {
        return IRand.pt(d, d2, d3);
    }

    public static IVec getPoint(double d, double d2) {
        return IRand.pt(d, d2);
    }

    public static IVec getPoint(double d) {
        return IRand.pt(d);
    }

    public static IVec getPoint() {
        return IRand.pt();
    }

    public static IVec pt2(double d, double d2, double d3, double d4) {
        return new IVec(IRand.get(d, d3), IRand.get(d2, d4), 0.0);
    }

    public static IVec pt2(double d, double d2) {
        return new IVec(IRand.get(d, d2), IRand.get(d, d2), 0.0);
    }

    public static IVec pt2(double d) {
        return new IVec(IRand.get(0.0, d), IRand.get(0.0, d), 0.0);
    }

    public static IVec pt2() {
        return new IVec(IRand.get(), IRand.get(), 0.0);
    }

    public static IVec point2(double d, double d2, double d3, double d4) {
        return IRand.pt2(d, d2, d3, d4);
    }

    public static IVec point2(double d, double d2) {
        return IRand.pt2(d, d2);
    }

    public static IVec point2(double d) {
        return IRand.pt2(d);
    }

    public static IVec point2() {
        return IRand.pt2();
    }

    public static IVec getPoint2(double d, double d2, double d3, double d4) {
        return IRand.pt2(d, d2, d3, d4);
    }

    public static IVec getPoint2(double d, double d2) {
        return IRand.pt2(d, d2);
    }

    public static IVec getPoint2(double d) {
        return IRand.pt2(d);
    }

    public static IVec getPoint2() {
        return IRand.pt2();
    }

    public static IVec dir() {
        return IRand.dir(1.0);
    }

    public static IVec dir(double d) {
        IVec iVec = IRand.pt(-1.0, 1.0);
        double d2 = iVec.len();
        while (d2 < IConfig.tolerance) {
            iVec = IRand.pt(-1.0, 1.0);
            d2 = iVec.len();
        }
        return iVec.mul(d / d2);
    }

    public static IVec dir(IVecI iVecI) {
        return IRand.dir(iVecI, 1.0);
    }

    public static IVec dir(IVecI iVecI, double d) {
        IVec iVec = null;
        iVec = !IVec.zaxis.isParallel(iVecI) ? IVec.zaxis.cross(iVecI) : IVec.xaxis.cross(iVecI);
        return iVec.rot(iVecI, IRand.get(Math.PI * 2)).len(d);
    }

    public static IVec direction() {
        return IRand.dir();
    }

    public static IVec direction(double d) {
        return IRand.dir(d);
    }

    public static IVec direction(IVecI iVecI) {
        return IRand.dir(iVecI);
    }

    public static IVec direction(IVecI iVecI, double d) {
        return IRand.dir(iVecI, d);
    }

    public static IVec getDirection() {
        return IRand.dir();
    }

    public static IVec getDirection(double d) {
        return IRand.dir(d);
    }

    public static IVec getDirection(IVecI iVecI) {
        return IRand.dir(iVecI);
    }

    public static IVec getDirection(IVecI iVecI, double d) {
        return IRand.dir(iVecI, d);
    }

    public static IVec dir2() {
        return IRand.dir2(1.0);
    }

    public static IVec dir2(double d) {
        double d2 = IRand.get(Math.PI * 2);
        return new IVec(d * Math.cos(d2), d * Math.sin(d2), 0.0);
    }

    public static IVec direction2() {
        return IRand.dir2();
    }

    public static IVec direction2(double d) {
        return IRand.dir2(d);
    }

    public static IVec getDirection2() {
        return IRand.dir2();
    }

    public static IVec getDirection2(double d) {
        return IRand.dir2(d);
    }

    public static boolean getPercent(double d) {
        return IRand.percent(d);
    }

    public static boolean percent(double d) {
        return IRand.get() < d / 100.0;
    }

    public static boolean pct(double d) {
        return IRand.percent(d);
    }

    public static IColor getColor() {
        return IRand.clr();
    }

    public static IColor clr() {
        return new IColor(IRand.getInt(0, 255), IRand.getInt(0, 255), IRand.getInt(0, 255));
    }

    protected static int limit255(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    protected static float limit1(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    public static IColor getColor(int n) {
        return IRand.clr(n);
    }

    public static IColor clr(int n) {
        return new IColor(IRand.getInt(0, 255), IRand.getInt(0, 255), IRand.getInt(0, 255), IRand.limit255(n));
    }

    public static IColor getColor(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return IRand.clr(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static IColor clr(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new IColor(IRand.limit255(IRand.getInt(n, n2)), IRand.limit255(IRand.getInt(n3, n4)), IRand.limit255(IRand.getInt(n5, n6)), IRand.limit255(IRand.getInt(n7, n8)));
    }

    public static IColor getColor(IColor iColor, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return IRand.clr(iColor, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static IColor clr(IColor iColor, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new IColor(IRand.limit255(iColor.getRed() + IRand.getInt(n, n2)), IRand.limit255(iColor.getGreen() + IRand.getInt(n3, n4)), IRand.limit255(iColor.getBlue() + IRand.getInt(n5, n6)), IRand.limit255(iColor.getAlpha() + IRand.getInt(n7, n8)));
    }

    public static IColor getColor(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return IRand.clr(n, n2, n3, n4, n5, n6, n7);
    }

    public static IColor clr(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new IColor(IRand.limit255(IRand.getInt(n, n2)), IRand.limit255(IRand.getInt(n3, n4)), IRand.limit255(IRand.getInt(n5, n6)), IRand.limit255(n7));
    }

    public static IColor getColor(IColor iColor, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return IRand.clr(iColor, n, n2, n3, n4, n5, n6, n7);
    }

    public static IColor clr(IColor iColor, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new IColor(IRand.limit255(iColor.getRed() + IRand.getInt(n, n2)), IRand.limit255(iColor.getGreen() + IRand.getInt(n3, n4)), IRand.limit255(iColor.getBlue() + IRand.getInt(n5, n6)), IRand.limit255(n7));
    }

    public static IColor getColor(int n, int n2, int n3, int n4, int n5, int n6) {
        return IRand.clr(n, n2, n3, n4, n5, n6);
    }

    public static IColor clr(int n, int n2, int n3, int n4, int n5, int n6) {
        return new IColor(IRand.limit255(IRand.getInt(n, n2)), IRand.limit255(IRand.getInt(n3, n4)), IRand.limit255(IRand.getInt(n5, n6)));
    }

    public static IColor getColor(IColor iColor, int n, int n2, int n3, int n4, int n5, int n6) {
        return IRand.clr(iColor, n, n2, n3, n4, n5, n6);
    }

    public static IColor clr(IColor iColor, int n, int n2, int n3, int n4, int n5, int n6) {
        return new IColor(IRand.limit255(iColor.getRed() + IRand.getInt(n, n2)), IRand.limit255(iColor.getGreen() + IRand.getInt(n3, n4)), IRand.limit255(iColor.getBlue() + IRand.getInt(n5, n6)));
    }

    public static IColor getColor(int n, int n2, int n3, int n4) {
        return IRand.clr(n, n2, n3, n4);
    }

    public static IColor clr(int n, int n2, int n3, int n4) {
        return new IColor(IRand.limit255(IRand.getInt(n)), IRand.limit255(IRand.getInt(n2)), IRand.limit255(IRand.getInt(n3)), IRand.limit255(n4));
    }

    public static IColor getColor(IColor iColor, int n, int n2, int n3, int n4) {
        return IRand.clr(iColor, n, n2, n3, n4);
    }

    public static IColor clr(IColor iColor, int n, int n2, int n3, int n4) {
        return new IColor(IRand.limit255(iColor.getRed() + IRand.getInt(n)), IRand.limit255(iColor.getGreen() + IRand.getInt(n2)), IRand.limit255(iColor.getBlue() + IRand.getInt(n3)), IRand.limit255(n4));
    }

    public static IColor getColor(int n, int n2, int n3) {
        return IRand.clr(n, n2, n3);
    }

    public static IColor clr(int n, int n2, int n3) {
        return new IColor(IRand.limit255(IRand.getInt(n)), IRand.limit255(IRand.getInt(n2)), IRand.limit255(IRand.getInt(n3)));
    }

    public static IColor getColor(IColor iColor, int n, int n2, int n3) {
        return IRand.clr(iColor, n, n2, n3);
    }

    public static IColor clr(IColor iColor, int n, int n2, int n3) {
        return new IColor(IRand.limit255(iColor.getRed() + IRand.getInt(n)), IRand.limit255(iColor.getGreen() + IRand.getInt(n2)), IRand.limit255(iColor.getBlue() + IRand.getInt(n3)));
    }

    public static IColor getColor(float f) {
        return IRand.clr(f);
    }

    public static IColor clr(float f) {
        return new IColor(IRand.getFloat(), IRand.getFloat(), IRand.getFloat(), IRand.limit1(f));
    }

    public static IColor getColor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return IRand.clr(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public static IColor clr(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return new IColor(IRand.limit1(IRand.getFloat(f, f2)), IRand.limit1(IRand.getFloat(f3, f4)), IRand.limit1(IRand.getFloat(f5, f6)), IRand.limit1(IRand.getFloat(f7, f8)));
    }

    public static IColor getColor(IColor iColor, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return IRand.clr(iColor, f, f2, f3, f4, f5, f6, f7, f8);
    }

    public static IColor clr(IColor iColor, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return new IColor(IRand.limit1((float)iColor.getRed() / 255.0f + IRand.getFloat(f, f2)), IRand.limit1((float)iColor.getGreen() / 255.0f + IRand.getFloat(f3, f4)), IRand.limit1((float)iColor.getBlue() / 255.0f + IRand.getFloat(f5, f6)), IRand.limit1((float)iColor.getAlpha() / 255.0f + IRand.getFloat(f7, f8)));
    }

    public static IColor getColor(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return IRand.clr(f, f2, f3, f4, f5, f6, f7);
    }

    public static IColor clr(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return new IColor(IRand.limit1(IRand.getFloat(f, f2)), IRand.limit1(IRand.getFloat(f3, f4)), IRand.limit1(IRand.getFloat(f5, f6)), IRand.limit1(f7));
    }

    public static IColor getColor(IColor iColor, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return IRand.clr(iColor, f, f2, f3, f4, f5, f6, f7);
    }

    public static IColor clr(IColor iColor, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return new IColor(IRand.limit1((float)iColor.getRed() / 255.0f + IRand.getFloat(f, f2)), IRand.limit1((float)iColor.getGreen() / 255.0f + IRand.getFloat(f3, f4)), IRand.limit1((float)iColor.getBlue() / 255.0f + IRand.getFloat(f5, f6)), IRand.limit1(f7));
    }

    public static IColor getColor(float f, float f2, float f3, float f4, float f5, float f6) {
        return IRand.clr(f, f2, f3, f4, f5, f6);
    }

    public static IColor clr(float f, float f2, float f3, float f4, float f5, float f6) {
        return new IColor(IRand.limit1(IRand.getFloat(f, f2)), IRand.limit1(IRand.getFloat(f3, f4)), IRand.limit1(IRand.getFloat(f5, f6)));
    }

    public static IColor getColor(IColor iColor, float f, float f2, float f3, float f4, float f5, float f6) {
        return IRand.clr(iColor, f, f2, f3, f4, f5, f6);
    }

    public static IColor clr(IColor iColor, float f, float f2, float f3, float f4, float f5, float f6) {
        return new IColor(IRand.limit1((float)iColor.getRed() / 255.0f + IRand.getFloat(f, f2)), IRand.limit1((float)iColor.getGreen() / 255.0f + IRand.getFloat(f3, f4)), IRand.limit1((float)iColor.getBlue() / 255.0f + IRand.getFloat(f5, f6)));
    }

    public static IColor getColor(float f, float f2, float f3, float f4) {
        return IRand.clr(f, f2, f3, f4);
    }

    public static IColor clr(float f, float f2, float f3, float f4) {
        return new IColor(IRand.limit1(IRand.getFloat(f)), IRand.limit1(IRand.getFloat(f2)), IRand.limit1(IRand.getFloat(f3)), IRand.limit1(f4));
    }

    public static IColor getColor(IColor iColor, float f, float f2, float f3, float f4) {
        return IRand.clr(iColor, f, f2, f3, f4);
    }

    public static IColor clr(IColor iColor, float f, float f2, float f3, float f4) {
        return new IColor(IRand.limit1((float)iColor.getRed() / 255.0f + IRand.getFloat(f)), IRand.limit1((float)iColor.getGreen() / 255.0f + IRand.getFloat(f2)), IRand.limit1((float)iColor.getBlue() / 255.0f + IRand.getFloat(f3)), IRand.limit1(f4));
    }

    public static IColor getIColor(float f, float f2, float f3) {
        return IRand.clr(f, f2, f3);
    }

    public static IColor clr(float f, float f2, float f3) {
        return new IColor(IRand.limit1(IRand.getFloat(f)), IRand.limit1(IRand.getFloat(f2)), IRand.limit1(IRand.getFloat(f3)));
    }

    public static IColor getIColor(IColor iColor, float f, float f2, float f3) {
        return IRand.clr(iColor, f, f2, f3);
    }

    public static IColor clr(IColor iColor, float f, float f2, float f3) {
        return new IColor(IRand.limit1((float)iColor.getRed() / 255.0f + IRand.getFloat(f)), IRand.limit1((float)iColor.getGreen() / 255.0f + IRand.getFloat(f2)), IRand.limit1((float)iColor.getBlue() / 255.0f + IRand.getFloat(f3)));
    }

    public static IColor getGrayIColor() {
        return IRand.gray();
    }

    public static IColor getGray() {
        return IRand.gray();
    }

    public static IColor gray() {
        int n = IRand.getInt(0, 255);
        return new IColor(n, n, n);
    }

    public static IColor getGrayIColor(int n) {
        return IRand.gray(n);
    }

    public static IColor getGray(int n) {
        return IRand.gray(n);
    }

    public static IColor gray(int n) {
        int n2 = IRand.getInt(0, 255);
        return new IColor(n2, n2, n2, IRand.limit255(n));
    }

    public static IColor getGrayIColor(float f) {
        return IRand.gray(f);
    }

    public static IColor getGray(float f) {
        return IRand.gray(f);
    }

    public static IColor gray(float f) {
        float f2 = IRand.getFloat();
        return new IColor(f2, f2, f2, IRand.limit1(f));
    }

    public static IColor getGrayIColor(float f, float f2, float f3, float f4) {
        return IRand.gray(f, f2, f3, f4);
    }

    public static IColor getGray(float f, float f2, float f3, float f4) {
        return IRand.gray(f, f2, f3, f4);
    }

    public static IColor gray(float f, float f2, float f3, float f4) {
        float f5 = IRand.limit1(IRand.getFloat(f, f2));
        return new IColor(f5, f5, f5, IRand.limit1(IRand.getFloat(f3, f4)));
    }

    public static IColor getGrayIColor(float f, float f2, float f3) {
        return IRand.gray(f, f2, f3);
    }

    public static IColor getGray(float f, float f2, float f3) {
        return IRand.gray(f, f2, f3);
    }

    public static IColor gray(float f, float f2, float f3) {
        float f4 = IRand.limit1(IRand.getFloat(f, f2));
        return new IColor(f4, f4, f4, IRand.limit1(f3));
    }

    public static IColor getGrayIColor(float f, float f2) {
        return IRand.gray(f, f2);
    }

    public static IColor getGray(float f, float f2) {
        return IRand.gray(f, f2);
    }

    public static IColor gray(float f, float f2) {
        float f3 = IRand.limit1(IRand.getFloat(f, f2));
        return new IColor(f3, f3, f3);
    }
}

