/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IColor;
import igeo.ICurveI;
import igeo.IObject;
import igeo.IOut;
import igeo.IServerI;
import igeo.ITrimCurveI;
import igeo.IVec2;
import igeo.gui.IView;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IAIExporter {
    public static double minimumPoint = 1.0E-5f;
    public static double defaultLineWeight = 0.1;
    public static boolean writeSubsurfaceAsMesh = false;
    public static boolean writeOutlineWhenMesh = false;
    public static double internalScaleFactor = 4.667;
    public static double internalXShift = -49.9;
    public static double internalYShift = -39.9;
    public static NumberFormat f;

    IAIExporter() {
    }

    public static void initFormat() {
        f = NumberFormat.getInstance();
        if (f instanceof DecimalFormat) {
            ((DecimalFormat)f).setDecimalSeparatorAlwaysShown(false);
            ((DecimalFormat)f).setMaximumFractionDigits(50);
            ((DecimalFormat)f).setMinimumFractionDigits(0);
            ((DecimalFormat)f).setGroupingUsed(false);
        } else {
            IOut.err("Not DecimalFormat");
        }
    }

    public static void writeHeader(PrintStream printStream) {
        printStream.println("%!PS-Adobe-3.0");
        printStream.println("%%Creator: Java");
        printStream.println("%%BoundingBox: 0 0 1000 1000");
        printStream.println("%%DocumentProcessColors: Black");
        printStream.println("%%DocumentNeededResources: procset Adobe_packedarray 2.0 0");
        printStream.println("%%+ procset Adobe_cmykcolor 1.1 0");
        printStream.println("%%+ procset Adobe_cshow 1.1 0");
        printStream.println("%%+ procset Adobe_customcolor 1.0 0");
        printStream.println("%%+ procset Adobe_typography_AI3 1.0 0");
        printStream.println("%%+ procset Adobe_IllustratorA_AI3 1.0 0");
        printStream.println("%AI3_ColorUsage: Color");
        printStream.println("%AI3_DocumentPreview: None");
        printStream.println("%%Template:");
        printStream.println("%%PageOrigin:0 0");
        printStream.println("%%EndComments");
        printStream.println("%%BeginProlog");
        printStream.println("%%IncludeResource: procset Adobe_packedarray 2.0 0");
        printStream.println("Adobe_packedarray /initialize get exec");
        printStream.println("%%IncludeResource: procset Adobe_cmykcolor 1.1 0");
        printStream.println("%%IncludeResource: procset Adobe_cshow 1.1 0");
        printStream.println("%%IncludeResource: procset Adobe_customcolor 1.0 0");
        printStream.println("%%IncludeResource: procset Adobe_typography_AI3 1.0 0");
        printStream.println("%%IncludeResource: procset Adobe_IllustratorA_AI3 1.0 0");
        printStream.println("%%EndProlog");
        printStream.println("%%BeginSetup");
        printStream.println("Adobe_cmykcolor /initialize get exec");
        printStream.println("Adobe_cshow /initialize get exec");
        printStream.println("Adobe_customcolor /initialize get exec");
        printStream.println("Adobe_typography_AI3 /initialize get exec");
        printStream.println("Adobe_IllustratorA_AI3 /initialize get exec");
        printStream.println("%%EndSetup");
    }

    public static void convertCoordinates(IVec2 iVec2, double d, IView iView) {
        iVec2.y = (double)iView.screenHeight - iVec2.y;
        if (iView.isAxonometric()) {
            iVec2.x *= d * 72.0 / iView.getAxonometricRatio();
            iVec2.y *= d * 72.0 / iView.getAxonometricRatio();
        } else {
            iVec2.x *= d;
            iVec2.y *= d;
        }
        iVec2.x *= internalScaleFactor;
        iVec2.y *= internalScaleFactor;
        iVec2.x += internalXShift * 72.0;
        iVec2.y += internalYShift * 72.0;
    }

    public static void writePolylinePaths(PrintStream printStream, ArrayList<ArrayList<IVec2>> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IAIExporter.writePolylinePath(printStream, arrayList.get(i), bl && i == 0);
        }
    }

    public static void writePolylinePath(PrintStream printStream, ArrayList<IVec2> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IVec2 iVec2 = arrayList.get(i);
            if (i == 0) {
                if (bl) {
                    printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                    printStream.println("m");
                    continue;
                }
                printStream.print("%%");
                printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                printStream.println("m");
                continue;
            }
            printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
            if (i == arrayList.size() - 1) {
                printStream.println("L");
                continue;
            }
            printStream.println("l");
        }
    }

    public static ArrayList<ArrayList<IVec2>> createPolylinePointArrayList(IVec2[] iVec2Array) {
        ArrayList<ArrayList<IVec2>> arrayList = new ArrayList<ArrayList<IVec2>>();
        arrayList.add(new ArrayList());
        for (int i = 0; i < iVec2Array.length; ++i) {
            if (iVec2Array[i] != null) {
                arrayList.get(arrayList.size() - 1).add(iVec2Array[i]);
                continue;
            }
            if (arrayList.get(arrayList.size() - 1).size() <= 0) continue;
            arrayList.add(new ArrayList());
        }
        return arrayList;
    }

    public static void writePaintStyle(PrintStream printStream, IColor iColor, IColor iColor2, double d) {
        printStream.println("0 A");
        if (iColor != null) {
            printStream.println("0 O");
        }
        if (iColor2 != null) {
            printStream.println("0 R");
        }
        double d2 = 1.0;
        if (iColor != null) {
            printStream.println(f.format((double)iColor.getRed() / 255.0) + " " + f.format((double)iColor.getGreen() / 255.0) + " " + f.format((double)iColor.getBlue() / 255.0) + " " + "Xa");
            d2 = (double)iColor.getAlpha() / 255.0;
        }
        if (iColor2 != null) {
            printStream.println(f.format((double)iColor2.getRed() / 255.0) + " " + f.format((double)iColor2.getGreen() / 255.0) + " " + f.format((double)iColor2.getBlue() / 255.0) + " " + "XA");
            if (iColor == null) {
                d2 = (double)iColor2.getAlpha() / 255.0;
            }
        }
        printStream.println("0 " + f.format(d2) + " 0 0 0 Xy");
        printStream.println("0 J 0 j " + f.format(d) + " w 4 M []0 d");
    }

    public static ArrayList<ArrayList<IVec2>> convertTo2DPoints(ICurveI iCurveI, double d, IView iView) {
        int n;
        IVec2[] iVec2Array = null;
        boolean bl = false;
        if (iCurveI.deg() == 1 && (!(iCurveI instanceof ITrimCurveI) || iCurveI instanceof ITrimCurveI && ((ITrimCurveI)iCurveI).surface().isFlat())) {
            iVec2Array = new IVec2[iCurveI.cpNum()];
            for (n = 0; n < iVec2Array.length; ++n) {
                iVec2Array[n] = new IVec2();
                boolean bl2 = iView.convert(iCurveI.cp(n), iVec2Array[n]);
                if (!bl2) {
                    iVec2Array[n] = null;
                }
                if (n <= 0 || iVec2Array[n - 1] == null || iVec2Array[n] == null) continue;
                bl = true;
            }
        }
        if (!bl) {
            return null;
        }
        for (n = 0; n < iVec2Array.length; ++n) {
            if (iVec2Array[n] == null) continue;
            IAIExporter.convertCoordinates(iVec2Array[n], d, iView);
        }
        return IAIExporter.createPolylinePointArrayList(iVec2Array);
    }

    public static void writeNurbsCurve(PrintStream printStream, ICurveI iCurveI, double d, IView iView) {
        ArrayList<ArrayList<IVec2>> arrayList = IAIExporter.convertTo2DPoints(iCurveI, d, iView);
        if (arrayList == null) {
            return;
        }
        double d2 = defaultLineWeight;
        IColor iColor = null;
        if (iCurveI instanceof IObject) {
            iColor = ((IObject)((Object)iCurveI)).clr();
        }
        if (iCurveI.isClosed()) {
            IAIExporter.writePaintStyle(printStream, iColor, null, d2);
        } else {
            IAIExporter.writePaintStyle(printStream, null, iColor, d2);
        }
        IAIExporter.writePolylinePaths(printStream, arrayList, true);
        if (iCurveI.isClosed()) {
            printStream.println("f");
        } else {
            printStream.println("S");
        }
    }

    public static void startCompoundPath(PrintStream printStream) {
        printStream.println("*u");
    }

    public static void endCompoundPath(PrintStream printStream) {
        printStream.println("*U");
    }

    public static String getRGBString(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n3 * n2 + n];
        int n5 = n4 >> 24 & 0xFF;
        int n6 = n4 >> 16 & 0xFF;
        int n7 = n4 >> 8 & 0xFF;
        int n8 = n4 & 0xFF;
        return IAIExporter.getByteString(n6) + IAIExporter.getByteString(n7) + IAIExporter.getByteString(n8);
    }

    public static String getByteString(int n) {
        int n2 = n >> 4 & 0xF;
        int n3 = n & 0xF;
        return String.valueOf(IAIExporter.getHex(n2)) + String.valueOf(IAIExporter.getHex(n3));
    }

    public static char getHex(int n) {
        if (n >= 0 && n <= 9) {
            return (char)(48 + n);
        }
        switch (n) {
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return '\u0000';
    }

    public static void startLayer(PrintStream printStream, String string, int n, boolean bl) {
        String string2 = "0";
        if (bl) {
            string2 = "1";
        }
        printStream.println("1 1 1 1 0 0 1 " + String.valueOf(n) + " 0 0 0 0 50 " + string2 + " Lb");
        printStream.println("(" + string + ") Ln");
    }

    public static void endLayer(PrintStream printStream) {
        printStream.println("LB");
    }

    public static void startMask(PrintStream printStream) {
        printStream.println("q");
    }

    public static void endMask(PrintStream printStream) {
        printStream.println("Q");
    }

    public static void startGroup(PrintStream printStream) {
        printStream.println("u");
    }

    public static void endGroup(PrintStream printStream) {
        printStream.println("U");
    }

    public static void writeFooter(PrintStream printStream) {
        printStream.println("%%PageTrailer");
        printStream.println("gsave annotatepage grestore showpage");
        printStream.println("%%Trailer");
        printStream.println("Adobe_IllustratorA_AI3 /terminate get exec");
        printStream.println("Adobe_typography_AI3 /terminate get exec");
        printStream.println("Adobe_customcolor /terminate get exec");
        printStream.println("Adobe_cshow /terminate get exec");
        printStream.println("Adobe_cmykcolor /terminate get exec");
        printStream.println("Adobe_packedarray /terminate get exec");
        printStream.println("%%EOF");
    }

    public static IVec2 getIntersection(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
        double d = (iVec22.y * (iVec23.x - iVec2.x) - iVec22.x * (iVec23.y - iVec2.y)) / (iVec22.x * iVec24.y - iVec24.x * iVec22.y);
        return new IVec2(d * iVec24.x + iVec23.x, d * iVec24.y + iVec23.y);
    }

    public static String getOctaString(char c) {
        int n = c % 8;
        int n2 = c / 8 % 8;
        int n3 = c / 64 % 8;
        return String.valueOf(n3) + String.valueOf(n2) + String.valueOf(n);
    }

    public static boolean write(File file, IServerI iServerI, double d) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        IAIExporter.write(printStream, iServerI.server().allObjects(), d, iServerI.server().ig.panel.currentPane().getView());
        printStream.close();
        return true;
    }

    public static void write(PrintStream printStream, ArrayList<IObject> arrayList, double d, IView iView) {
        IAIExporter.initFormat();
        IAIExporter.writeHeader(printStream);
        IAIExporter.startLayer(printStream, "default", 0, false);
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            if (i > 0 && i % 100 == 0) {
                IOut.debug(0, "exporting " + i + "/" + arrayList.size());
            }
            if (!(arrayList.get(i) instanceof ICurveI) || arrayList.get(i) instanceof ITrimCurveI) continue;
            ICurveI iCurveI = (ICurveI)((Object)arrayList.get(i));
            IAIExporter.writeNurbsCurve(printStream, iCurveI, d, iView);
        }
        IAIExporter.endLayer(printStream);
        IAIExporter.writeFooter(printStream);
    }
}

