/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IVec;
import igeo.gui.IKeyEvent;
import igeo.gui.IMouseEvent;
import igeo.gui.IMouseWheelEvent;
import igeo.gui.IPane;
import igeo.gui.IView;
import java.util.ArrayList;

public class INavigator {
    public static final IMouseEvent defaultRotateButton = new IMouseEvent(1);
    public static final IMouseEvent defaultRotateButton2 = new IMouseEvent(1, false, false, true);
    public static final IMouseEvent defaultPanButton = new IMouseEvent(2);
    public static final IMouseEvent defaultPanButton2 = new IMouseEvent(1, true, false, false);
    public static final IMouseEvent defaultZoomButton = new IMouseEvent(3);
    public static final IMouseEvent defaultZoomButton2 = new IMouseEvent(1, false, true, false);
    public static double minimumAxonometricMouseZoomRatio = 1.0E-6;
    public double rotationYawRatio = IConfig.mouseRotationSpeed / 180.0 * Math.PI;
    public double rotationPitchRatio = IConfig.mouseRotationSpeed / 180.0 * Math.PI;
    public double perspectivePanRatio = IConfig.mousePerspectivePanSpeed;
    public double axonometricPanRatio = IConfig.mouseAxonometricPanSpeed;
    public double axonZoomRatio = IConfig.mouseAxonometricZoomSpeed / 100.0;
    public double persZoomRatio = IConfig.mousePerspectiveZoomSpeed;
    public double wheelZoomRatio = IConfig.mouseWheelZoomSpeed;
    public double keyRotationYawInc = IConfig.keyRotationSpeed / 180.0 * Math.PI;
    public double keyRotationPitchInc = IConfig.keyRotationSpeed / 180.0 * Math.PI;
    public double keyPerspectivePanInc = IConfig.keyPerspectivePanSpeed;
    public double keyAxonometricPanInc = IConfig.keyAxonometricPanSpeed;
    public double keyZoomInc = IConfig.keyZoomSpeed;
    public boolean rotateLock = false;
    public IPane pane;
    public IView view;
    public int mouseX;
    public int mouseY;
    public boolean mousePressed = false;
    public IVec viewPos;
    public IVec viewTarget;
    public IVec viewAngle;
    public double viewAxonRatio;
    public DragType dragType = null;
    public ArrayList<IMouseEvent> rotateButtons;
    public ArrayList<IMouseEvent> panButtons;
    public ArrayList<IMouseEvent> zoomButtons;
    public ArrayList<IMouseEvent> rotateUnlockButtons;

    public INavigator(IView iView, IPane iPane) {
        this(iView);
        this.pane = iPane;
    }

    public INavigator(IView iView) {
        this.view = iView;
        this.rotateButtons = new ArrayList();
        this.panButtons = new ArrayList();
        this.zoomButtons = new ArrayList();
        this.rotateUnlockButtons = new ArrayList();
        this.rotateButtons.add(defaultRotateButton);
        this.rotateButtons.add(defaultRotateButton2);
        this.panButtons.add(defaultPanButton);
        this.panButtons.add(defaultPanButton2);
        this.zoomButtons.add(defaultZoomButton);
        this.zoomButtons.add(defaultZoomButton2);
        this.rotateUnlockButtons.add(defaultRotateButton2);
    }

    public void setPane(IPane iPane) {
        this.pane = iPane;
    }

    public void setView(IView iView) {
        this.view = iView;
    }

    public void setRotationRatio(double d, double d2) {
        this.rotationYawRatio = d;
        this.rotationPitchRatio = d2;
    }

    public void setPerspectivePanRatio(double d) {
        this.perspectivePanRatio = d;
    }

    public void setAxonometricPanRatio(double d) {
        this.axonometricPanRatio = d;
    }

    public void setPerspectiveZoomRatio(double d) {
        this.persZoomRatio = d;
    }

    public void setAxonometricZoomRatio(double d) {
        this.axonZoomRatio = d;
    }

    public void wheelZoomRatio(double d) {
        this.wheelZoomRatio = d;
    }

    public void setRotateLock(boolean bl) {
        this.rotateLock = bl;
    }

    public void updateRotationByMouse(int n, int n2) {
        if (this.mousePressed) {
            int n3 = n - this.mouseX;
            int n4 = n2 - this.mouseY;
            double d = (double)(-n3) * this.rotationYawRatio;
            double d2 = (double)n4 * this.rotationPitchRatio;
            this.updateRotation(d, d2);
        }
    }

    public void updateRotation(double d, double d2) {
        double d3 = this.viewAngle.x + d;
        double d4 = this.viewAngle.y + d2;
        d3 -= Math.floor(d3 / (Math.PI * 2)) * 2.0 * Math.PI;
        d4 -= Math.floor(d4 / (Math.PI * 2)) * 2.0 * Math.PI;
        this.view.setAngle(d3, d4);
        this.view.update();
    }

    public void updatePanByMouse(int n, int n2) {
        if (this.mousePressed) {
            int n3 = n - this.mouseX;
            int n4 = n2 - this.mouseY;
            double d = this.view.isAxonometric() ? this.view.getAxonometricRatio() * this.axonometricPanRatio : this.perspectivePanRatio;
            this.updatePan((double)(-n3) * d, (double)n4 * d);
        }
    }

    public void updatePan(double d, double d2) {
        IVec iVec = this.view.rightDirection();
        IVec iVec2 = this.view.upDirection();
        iVec.len(d).add(iVec2.len(d2));
        this.view.setLocation(this.viewPos.dup().add(iVec));
        this.view.setTarget(this.viewTarget.dup().add(iVec));
        this.view.update();
    }

    public void updateZoomByMouse(int n, int n2) {
        if (this.mousePressed) {
            this.updateZoom(n2 - this.mouseY);
        }
    }

    public void updateZoom(double d) {
        if (this.view.isAxonometric()) {
            double d2 = d > 0.0 ? (1.0 + d * this.axonZoomRatio) * this.viewAxonRatio : 1.0 / (1.0 - d * this.axonZoomRatio) * this.viewAxonRatio;
            if (d2 < minimumAxonometricMouseZoomRatio) {
                d2 = minimumAxonometricMouseZoomRatio;
            }
            this.view.setAxonometricRatio(d2);
        } else {
            double d3 = -d * this.persZoomRatio;
            IVec iVec = this.view.frontDirection().len(d3);
            this.view.setLocation(this.viewPos.dup().add(iVec));
            this.view.update();
        }
    }

    public DragType getDragType(IMouseEvent iMouseEvent) {
        if (this.rotateLock) {
            for (IMouseEvent iMouseEvent2 : this.rotateUnlockButtons) {
                if (!iMouseEvent2.match(iMouseEvent)) continue;
                this.rotateLock = false;
                return DragType.Rotate;
            }
            for (IMouseEvent iMouseEvent2 : this.rotateButtons) {
                if (!iMouseEvent2.match(iMouseEvent)) continue;
                return DragType.Pan;
            }
        } else {
            for (IMouseEvent iMouseEvent2 : this.rotateButtons) {
                if (!iMouseEvent2.match(iMouseEvent)) continue;
                return DragType.Rotate;
            }
        }
        for (IMouseEvent iMouseEvent2 : this.panButtons) {
            if (!iMouseEvent2.match(iMouseEvent)) continue;
            return DragType.Pan;
        }
        for (IMouseEvent iMouseEvent2 : this.zoomButtons) {
            if (!iMouseEvent2.match(iMouseEvent)) continue;
            return DragType.Zoom;
        }
        return null;
    }

    public void mousePressed(IMouseEvent iMouseEvent) {
        this.mouseX = iMouseEvent.getX();
        this.mouseY = iMouseEvent.getY();
        this.mousePressed = true;
        this.dragType = this.getDragType(iMouseEvent);
        this.viewPos = this.view.location();
        this.viewTarget = this.view.target();
        this.viewAngle = this.view.getAngles();
        this.viewAxonRatio = this.view.getAxonometricRatio();
    }

    public void mouseReleased(IMouseEvent iMouseEvent) {
        if (this.dragType == DragType.Rotate) {
            this.updateRotationByMouse(iMouseEvent.getX(), iMouseEvent.getY());
        } else if (this.dragType == DragType.Pan) {
            this.updatePanByMouse(iMouseEvent.getX(), iMouseEvent.getY());
        } else if (this.dragType == DragType.Zoom) {
            this.updateZoomByMouse(iMouseEvent.getX(), iMouseEvent.getY());
        }
        this.mousePressed = false;
    }

    public void mouseClicked(IMouseEvent iMouseEvent) {
    }

    public void mouseEntered(IMouseEvent iMouseEvent) {
    }

    public void mouseExited(IMouseEvent iMouseEvent) {
    }

    public void mouseMoved(IMouseEvent iMouseEvent) {
    }

    public void mouseDragged(IMouseEvent iMouseEvent) {
        if (this.dragType == DragType.Rotate) {
            this.updateRotationByMouse(iMouseEvent.getX(), iMouseEvent.getY());
        } else if (this.dragType == DragType.Pan) {
            this.updatePanByMouse(iMouseEvent.getX(), iMouseEvent.getY());
        } else if (this.dragType == DragType.Zoom) {
            this.updateZoomByMouse(iMouseEvent.getX(), iMouseEvent.getY());
        }
    }

    public void mouseWheelMoved(IMouseWheelEvent iMouseWheelEvent) {
        this.viewPos = this.view.location();
        this.viewAxonRatio = this.view.getAxonometricRatio();
        this.updateZoom(this.wheelZoomRatio * (double)iMouseWheelEvent.getWheelRotation());
    }

    public void keyPressed(IKeyEvent iKeyEvent) {
        int n = iKeyEvent.getKeyCode();
        boolean bl = iKeyEvent.isShiftDown();
        boolean bl2 = iKeyEvent.isControlDown();
        if (!bl && !bl2) {
            if (n == 38) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(0.0, -this.keyRotationPitchInc);
            } else if (n == 40) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(0.0, this.keyRotationPitchInc);
            } else if (n == 37) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(this.keyRotationYawInc, 0.0);
            } else if (n == 39) {
                this.viewAngle = this.view.getAngles();
                this.updateRotation(-this.keyRotationYawInc, 0.0);
            }
        } else if (bl && !bl2) {
            double d = this.view.isAxonometric() ? this.view.getAxonometricRatio() * this.keyAxonometricPanInc : this.keyPerspectivePanInc;
            if (n == 38) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(0.0, -d);
            } else if (n == 40) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(0.0, d);
            } else if (n == 37) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(d, 0.0);
            } else if (n == 39) {
                this.viewPos = this.view.location();
                this.viewTarget = this.view.target();
                this.updatePan(-d, 0.0);
            }
        } else if (!bl && bl2) {
            if (n == 38) {
                this.viewPos = this.view.location();
                this.viewAxonRatio = this.view.getAxonometricRatio();
                this.updateZoom(-this.keyZoomInc);
            } else if (n == 40) {
                this.viewPos = this.view.location();
                this.viewAxonRatio = this.view.getAxonometricRatio();
                this.updateZoom(this.keyZoomInc);
            }
        }
    }

    public void keyReleased(IKeyEvent iKeyEvent) {
    }

    public void keyTyped(IKeyEvent iKeyEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DragType {
        Rotate,
        Pan,
        Zoom;

    }
}

