/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAttractor;
import igeo.IAttractorGeo;
import igeo.IDoubleOp;
import igeo.IFace;
import igeo.IFieldI;
import igeo.IG;
import igeo.IIntegerOp;
import igeo.IMesh;
import igeo.IMeshGeo;
import igeo.IOut;
import igeo.IVal;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVecOp;
import igeo.IVertex;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFieldMesh {
    public static IMesh create(double d, IVecI iVecI, IVecI iVecI2, int n, int n2, int n3) {
        return IFieldMesh.create(IG.cur(), d, iVecI, iVecI2, n, n2, n3);
    }

    public static IMesh create(IG iG, double d, IVecI iVecI, IVecI iVecI2, int n, int n2, int n3) {
        ArrayList<IFieldI> arrayList = new ArrayList<IFieldI>();
        for (int i = 0; i < iG.dynamicServer().dynamics.size(); ++i) {
            if (!(iG.dynamicServer().dynamics.get(i) instanceof IFieldI)) continue;
            arrayList.add((IFieldI)((Object)iG.dynamicServer().dynamics.get(i)));
        }
        return IFieldMesh.create(arrayList, d, iVecI, iVecI2, n, n2, n3);
    }

    public static IMesh create(ArrayList<IFieldI> arrayList, double d, IVecI iVecI, IVecI iVecI2, int n, int n2, int n3) {
        double[][][] dArray = new double[n + 1][n2 + 1][n3 + 1];
        VertexGrid vertexGrid = new VertexGrid(n, n2, n3);
        IMeshGeo iMeshGeo = new IMeshGeo();
        IVec iVec = iVecI2.get().dif(iVecI);
        iVec.x /= (double)n;
        iVec.y /= (double)n2;
        iVec.z /= (double)n3;
        vertexGrid.setGridPosition(iVecI.get(), iVec.x, iVec.y, iVec.z);
        for (int i = 0; i <= n; ++i) {
            double d2 = iVec.x * (double)i + iVecI.x();
            for (int j = 0; j <= n2; ++j) {
                double d3 = iVec.y * (double)j + iVecI.y();
                for (int k = 0; k <= n3; ++k) {
                    IFace[] iFaceArray;
                    IVec iVec2;
                    IVec iVec3;
                    IVec iVec4;
                    double d4;
                    double d5;
                    IVec iVec5;
                    double d6;
                    double d7 = iVec.z * (double)k + iVecI.z();
                    IVec iVec6 = new IVec(d2, d3, d7);
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        if (arrayList.get(i2) instanceof IAttractor && ((IAttractorGeo)((IAttractor)arrayList.get((int)i2)).field).pos.eq(iVec6) && ((IAttractorGeo)((IAttractor)arrayList.get((int)i2)).field).constantIntensity) {
                            double[] dArray2 = dArray[i][j];
                            int n4 = k;
                            dArray2[n4] = dArray2[n4] + arrayList.get(i2).intensity();
                            continue;
                        }
                        IVal iVal = arrayList.get(i2).get(iVec6);
                        if (iVal instanceof IVecOp) {
                            IVec iVec7 = ((IVecOp)iVal).get();
                            double[] dArray3 = dArray[i][j];
                            int n5 = k;
                            dArray3[n5] = dArray3[n5] + iVec7.len();
                            continue;
                        }
                        if (iVal instanceof IDoubleOp) {
                            double d8 = ((IDoubleOp)iVal).x();
                            double[] dArray4 = dArray[i][j];
                            int n6 = k;
                            dArray4[n6] = dArray4[n6] + d8;
                            continue;
                        }
                        if (!(iVal instanceof IIntegerOp)) continue;
                        int n7 = ((IIntegerOp)iVal).x();
                        double[] dArray5 = dArray[i][j];
                        int n8 = k;
                        dArray5[n8] = dArray5[n8] + (double)n7;
                    }
                    vertexGrid.index(i, j, k);
                    double d9 = dArray[i][j][k] - d;
                    if (d9 == 0.0) {
                        vertexGrid.corner(iVec6.cp());
                    }
                    if (i > 0 && (d6 = dArray[i - 1][j][k] - d) * d9 < 0.0) {
                        iVec5 = iVec6.cp();
                        iVec5.x -= Math.abs(d9) / (Math.abs(d6) + Math.abs(d9)) * iVec.x;
                        vertexGrid.x(iVec5);
                    }
                    if (j > 0 && (d5 = dArray[i][j - 1][k] - d) * d9 < 0.0) {
                        iVec5 = iVec6.cp();
                        iVec5.y -= Math.abs(d9) / (Math.abs(d5) + Math.abs(d9)) * iVec.y;
                        vertexGrid.y(iVec5);
                    }
                    if (k > 0 && (d4 = dArray[i][j][k - 1] - d) * d9 < 0.0) {
                        iVec5 = iVec6.cp();
                        iVec5.z -= Math.abs(d9) / (Math.abs(d4) + Math.abs(d9)) * iVec.z;
                        vertexGrid.z(iVec5);
                    }
                    if (i > 0 && j > 0) {
                        if ((i + j + k) % 2 == 0) {
                            double d10 = dArray[i - 1][j - 1][k] - d;
                            if (d10 * d9 < 0.0) {
                                iVec5 = iVec6.cp();
                                iVec5.x -= Math.abs(d9) / (Math.abs(d10) + Math.abs(d9)) * iVec.x;
                                iVec5.y -= Math.abs(d9) / (Math.abs(d10) + Math.abs(d9)) * iVec.y;
                                vertexGrid.xy(iVec5);
                            }
                        } else {
                            double d11 = dArray[i][j - 1][k] - d;
                            double d12 = dArray[i - 1][j][k] - d;
                            if (d11 * d12 < 0.0) {
                                iVec4 = iVec6.cp();
                                iVec3 = iVec6.cp();
                                iVec4.y -= iVec.y;
                                iVec3.x -= iVec.x;
                                iVec2 = iVec4.sum(iVec3, Math.abs(d11) / (Math.abs(d11) + Math.abs(d12)));
                                vertexGrid.xy(iVec2);
                            }
                        }
                    }
                    if (j > 0 && k > 0) {
                        if ((i + j + k) % 2 == 0) {
                            double d13 = dArray[i][j - 1][k - 1] - d;
                            if (d13 * d9 < 0.0) {
                                IVec iVec8 = iVec6.cp();
                                iVec8.y -= Math.abs(d9) / (Math.abs(d13) + Math.abs(d9)) * iVec.y;
                                iVec8.z -= Math.abs(d9) / (Math.abs(d13) + Math.abs(d9)) * iVec.z;
                                vertexGrid.yz(iVec8);
                            }
                        } else {
                            double d14 = dArray[i][j][k - 1] - d;
                            double d15 = dArray[i][j - 1][k] - d;
                            if (d14 * d15 < 0.0) {
                                iVec4 = iVec6.cp();
                                iVec3 = iVec6.cp();
                                iVec4.z -= iVec.z;
                                iVec3.y -= iVec.y;
                                iVec2 = iVec4.sum(iVec3, Math.abs(d14) / (Math.abs(d14) + Math.abs(d15)));
                                vertexGrid.yz(iVec2);
                            }
                        }
                    }
                    if (k > 0 && i > 0) {
                        if ((i + j + k) % 2 == 0) {
                            double d16 = dArray[i - 1][j][k - 1] - d;
                            if (d16 * d9 < 0.0) {
                                IVec iVec9 = iVec6.cp();
                                iVec9.z -= Math.abs(d9) / (Math.abs(d16) + Math.abs(d9)) * iVec.z;
                                iVec9.x -= Math.abs(d9) / (Math.abs(d16) + Math.abs(d9)) * iVec.x;
                                vertexGrid.zx(iVec9);
                            }
                        } else {
                            double d17 = dArray[i - 1][j][k] - d;
                            double d18 = dArray[i][j][k - 1] - d;
                            if (d17 * d18 < 0.0) {
                                iVec4 = iVec6.cp();
                                iVec3 = iVec6.cp();
                                iVec4.x -= iVec.x;
                                iVec3.z -= iVec.z;
                                iVec2 = iVec4.sum(iVec3, Math.abs(d17) / (Math.abs(d17) + Math.abs(d18)));
                                vertexGrid.zx(iVec2);
                            }
                        }
                    }
                    if (i <= 0 || j <= 0 || k <= 0) continue;
                    if ((i + j + k) % 2 == 0) {
                        int[][][] nArray = IFieldMesh.findEdge(d, dArray[i - 1][j - 1][k - 1], dArray[i][j - 1][k - 1], dArray[i - 1][j][k - 1], dArray[i - 1][j - 1][k]);
                        if (nArray != null) {
                            iFaceArray = vertexGrid.faces(new int[]{0, 1, 3, 4}, nArray, new double[]{dArray[i - 1][j - 1][k - 1] - d, dArray[i][j - 1][k - 1] - d, dArray[i - 1][j][k - 1] - d, dArray[i - 1][j - 1][k] - d});
                            for (int i3 = 0; i3 < iFaceArray.length; ++i3) {
                                iMeshGeo.addFace(iFaceArray[i3]);
                            }
                        }
                        if ((nArray = IFieldMesh.findEdge(d, dArray[i][j][k - 1], dArray[i - 1][j][k - 1], dArray[i][j - 1][k - 1], dArray[i][j][k])) != null) {
                            iFaceArray = vertexGrid.faces(new int[]{2, 3, 1, 6}, nArray, new double[]{dArray[i][j][k - 1] - d, dArray[i - 1][j][k - 1] - d, dArray[i][j - 1][k - 1] - d, dArray[i][j][k] - d});
                            for (int i4 = 0; i4 < iFaceArray.length; ++i4) {
                                iMeshGeo.addFace(iFaceArray[i4]);
                            }
                        }
                        if ((nArray = IFieldMesh.findEdge(d, dArray[i][j][k], dArray[i][j - 1][k], dArray[i - 1][j - 1][k], dArray[i][j - 1][k - 1])) != null) {
                            iFaceArray = vertexGrid.faces(new int[]{6, 5, 4, 1}, nArray, new double[]{dArray[i][j][k] - d, dArray[i][j - 1][k] - d, dArray[i - 1][j - 1][k] - d, dArray[i][j - 1][k - 1] - d});
                            for (int i5 = 0; i5 < iFaceArray.length; ++i5) {
                                iMeshGeo.addFace(iFaceArray[i5]);
                            }
                        }
                        if ((nArray = IFieldMesh.findEdge(d, dArray[i - 1][j - 1][k], dArray[i - 1][j][k], dArray[i][j][k], dArray[i - 1][j][k - 1])) != null) {
                            iFaceArray = vertexGrid.faces(new int[]{4, 7, 6, 3}, nArray, new double[]{dArray[i - 1][j - 1][k] - d, dArray[i - 1][j][k] - d, dArray[i][j][k] - d, dArray[i - 1][j][k - 1] - d});
                            for (int i6 = 0; i6 < iFaceArray.length; ++i6) {
                                iMeshGeo.addFace(iFaceArray[i6]);
                            }
                        }
                        if ((nArray = IFieldMesh.findEdge(d, dArray[i][j - 1][k - 1], dArray[i - 1][j][k - 1], dArray[i][j][k], dArray[i - 1][j - 1][k])) == null) continue;
                        iFaceArray = vertexGrid.faces(new int[]{1, 3, 6, 4}, nArray, new double[]{dArray[i][j - 1][k - 1] - d, dArray[i - 1][j][k - 1] - d, dArray[i][j][k] - d, dArray[i - 1][j - 1][k] - d});
                        for (int i7 = 0; i7 < iFaceArray.length; ++i7) {
                            iMeshGeo.addFace(iFaceArray[i7]);
                        }
                        continue;
                    }
                    int[][][] nArray = IFieldMesh.findEdge(d, dArray[i - 1][j - 1][k - 1], dArray[i][j - 1][k - 1], dArray[i][j][k - 1], dArray[i][j - 1][k]);
                    if (nArray != null) {
                        iFaceArray = vertexGrid.faces(new int[]{0, 1, 2, 5}, nArray, new double[]{dArray[i - 1][j - 1][k - 1] - d, dArray[i][j - 1][k - 1] - d, dArray[i][j][k - 1] - d, dArray[i][j - 1][k] - d});
                        for (int i8 = 0; i8 < iFaceArray.length; ++i8) {
                            iMeshGeo.addFace(iFaceArray[i8]);
                        }
                    }
                    if ((nArray = IFieldMesh.findEdge(d, dArray[i][j][k - 1], dArray[i - 1][j][k - 1], dArray[i - 1][j - 1][k - 1], dArray[i - 1][j][k])) != null) {
                        iFaceArray = vertexGrid.faces(new int[]{2, 3, 0, 7}, nArray, new double[]{dArray[i][j][k - 1] - d, dArray[i - 1][j][k - 1] - d, dArray[i - 1][j - 1][k - 1] - d, dArray[i - 1][j][k] - d});
                        for (int i9 = 0; i9 < iFaceArray.length; ++i9) {
                            iMeshGeo.addFace(iFaceArray[i9]);
                        }
                    }
                    if ((nArray = IFieldMesh.findEdge(d, dArray[i - 1][j - 1][k], dArray[i][j - 1][k], dArray[i - 1][j][k], dArray[i - 1][j - 1][k - 1])) != null) {
                        iFaceArray = vertexGrid.faces(new int[]{4, 5, 7, 0}, nArray, new double[]{dArray[i - 1][j - 1][k] - d, dArray[i][j - 1][k] - d, dArray[i - 1][j][k] - d, dArray[i - 1][j - 1][k - 1] - d});
                        for (int i10 = 0; i10 < iFaceArray.length; ++i10) {
                            iMeshGeo.addFace(iFaceArray[i10]);
                        }
                    }
                    if ((nArray = IFieldMesh.findEdge(d, dArray[i][j][k], dArray[i - 1][j][k], dArray[i][j - 1][k], dArray[i][j][k - 1])) != null) {
                        iFaceArray = vertexGrid.faces(new int[]{6, 7, 5, 2}, nArray, new double[]{dArray[i][j][k] - d, dArray[i - 1][j][k] - d, dArray[i][j - 1][k] - d, dArray[i][j][k - 1] - d});
                        for (int i11 = 0; i11 < iFaceArray.length; ++i11) {
                            iMeshGeo.addFace(iFaceArray[i11]);
                        }
                    }
                    if ((nArray = IFieldMesh.findEdge(d, dArray[i - 1][j - 1][k - 1], dArray[i][j][k - 1], dArray[i][j - 1][k], dArray[i - 1][j][k])) == null) continue;
                    iFaceArray = vertexGrid.faces(new int[]{0, 2, 5, 7}, nArray, new double[]{dArray[i - 1][j - 1][k - 1] - d, dArray[i][j][k - 1] - d, dArray[i][j - 1][k] - d, dArray[i - 1][j][k] - d});
                    for (int i12 = 0; i12 < iFaceArray.length; ++i12) {
                        iMeshGeo.addFace(iFaceArray[i12]);
                    }
                }
            }
        }
        if (iMeshGeo.faceNum() > 0) {
            return new IMesh(iMeshGeo);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int[][][] findEdge(double d, double ... dArray) {
        int n;
        int[][][] nArray;
        int[] nArray2;
        int n2;
        block29: {
            n2 = dArray.length;
            nArray2 = new int[n2];
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; n3 += nArray2[i], ++i) {
                if (dArray[i] == d) {
                    nArray2[i] = 0;
                    ++n4;
                    continue;
                }
                nArray2[i] = dArray[i] > d ? 1 : -1;
            }
            if (n3 == n2 || n3 == -n2) {
                return null;
            }
            if (n4 == 4) {
                int[][][] nArray3 = new int[4][3][1];
                nArray3[0][0][0] = 0;
                nArray3[0][1][0] = 2;
                nArray3[0][2][0] = 1;
                nArray3[1][0][0] = 0;
                nArray3[1][1][0] = 1;
                nArray3[1][2][0] = 3;
                nArray3[2][0][0] = 1;
                nArray3[2][1][0] = 2;
                nArray3[2][2][0] = 3;
                nArray3[3][0][0] = 0;
                nArray3[3][1][0] = 3;
                nArray3[3][2][0] = 2;
                return nArray3;
            }
            if (n4 == 3) {
                int[][][] nArray4 = new int[1][3][1];
                int n5 = 0;
                int n6 = 0;
                while (true) {
                    if (n5 >= n2) {
                        return nArray4;
                    }
                    if (nArray2[n5] == 0) {
                        nArray4[0][n6][0] = n5;
                        ++n6;
                    }
                    ++n5;
                }
            }
            if (n4 == 2) {
                if (n3 != 0) {
                    return null;
                }
            } else if (n4 == 1) {
                if (n3 >= n2 - n4 || n3 <= -(n2 - n4)) {
                    return null;
                }
                nArray = new int[1][3][];
                nArray[0][0] = new int[1];
                nArray[0][1] = new int[2];
                nArray[0][2] = new int[2];
                n = 1;
                break block29;
            } else {
                if (nArray2[0] == nArray2[1]) {
                    if (nArray2[0] == nArray2[2]) {
                        if (nArray2[0] == nArray2[3]) {
                            IOut.err("invalid states");
                            return null;
                        }
                        int[][][] nArray5 = new int[1][3][2];
                        nArray5[0][0][0] = 0;
                        nArray5[0][0][1] = 3;
                        nArray5[0][1][0] = 1;
                        nArray5[0][1][1] = 3;
                        nArray5[0][2][0] = 2;
                        nArray5[0][2][1] = 3;
                        return nArray5;
                    }
                    if (nArray2[0] == nArray2[3]) {
                        int[][][] nArray6 = new int[1][3][2];
                        nArray6[0][0][0] = 0;
                        nArray6[0][0][1] = 2;
                        nArray6[0][1][0] = 1;
                        nArray6[0][1][1] = 2;
                        nArray6[0][2][0] = 3;
                        nArray6[0][2][1] = 2;
                        return nArray6;
                    }
                    int[][][] nArray7 = new int[1][4][2];
                    nArray7[0][0][0] = 0;
                    nArray7[0][0][1] = 2;
                    nArray7[0][1][0] = 0;
                    nArray7[0][1][1] = 3;
                    nArray7[0][2][0] = 1;
                    nArray7[0][2][1] = 3;
                    nArray7[0][3][0] = 1;
                    nArray7[0][3][1] = 2;
                    return nArray7;
                }
                if (nArray2[0] == nArray2[2]) {
                    if (nArray2[0] == nArray2[3]) {
                        int[][][] nArray8 = new int[1][3][2];
                        nArray8[0][0][0] = 0;
                        nArray8[0][0][1] = 1;
                        nArray8[0][1][0] = 2;
                        nArray8[0][1][1] = 1;
                        nArray8[0][2][0] = 3;
                        nArray8[0][2][1] = 1;
                        return nArray8;
                    }
                    int[][][] nArray9 = new int[1][4][2];
                    nArray9[0][0][0] = 0;
                    nArray9[0][0][1] = 3;
                    nArray9[0][1][0] = 0;
                    nArray9[0][1][1] = 1;
                    nArray9[0][2][0] = 2;
                    nArray9[0][2][1] = 1;
                    nArray9[0][3][0] = 2;
                    nArray9[0][3][1] = 3;
                    return nArray9;
                }
                if (nArray2[0] == nArray2[3]) {
                    int[][][] nArray10 = new int[1][4][2];
                    nArray10[0][0][0] = 0;
                    nArray10[0][0][1] = 1;
                    nArray10[0][1][0] = 0;
                    nArray10[0][1][1] = 2;
                    nArray10[0][2][0] = 3;
                    nArray10[0][2][1] = 2;
                    nArray10[0][3][0] = 3;
                    nArray10[0][3][1] = 1;
                    return nArray10;
                }
                int[][][] nArray11 = new int[1][3][2];
                nArray11[0][0][0] = 0;
                nArray11[0][0][1] = 1;
                nArray11[0][1][0] = 0;
                nArray11[0][1][1] = 2;
                nArray11[0][2][0] = 0;
                nArray11[0][2][1] = 3;
                return nArray11;
            }
            int[][][] nArray12 = new int[1][3][];
            nArray12[0][0] = new int[1];
            nArray12[0][1] = new int[1];
            nArray12[0][2] = new int[2];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (true) {
                if (n9 >= n2) {
                    return nArray12;
                }
                if (nArray2[n9] == 0) {
                    nArray12[0][n7][0] = n9;
                    ++n7;
                } else {
                    nArray12[0][2][n8] = n9;
                    ++n8;
                }
                ++n9;
            }
        }
        for (int i = 0; i < n2; ++i) {
            if (nArray2[i] == 0) {
                nArray[0][0][0] = i;
                continue;
            }
            for (int j = i + 1; j < n2; ++j) {
                if (nArray2[i] == nArray2[j]) continue;
                nArray[0][n][0] = i;
                nArray[0][n][0] = j;
                ++n;
            }
        }
        if (n == 2) {
            return nArray;
        }
        IOut.err("edge index count doesn't match");
        return null;
    }

    public static class EdgeVertex {
        IVertex vertex;
        int dir;
        int i;
        int j;

        public EdgeVertex(IVertex iVertex, int n, int n2, int n3) {
            this.vertex = iVertex;
            this.dir = n;
            this.i = n2;
            this.j = n3;
        }
    }

    public static class VertexGrid {
        public IVertex[][][] xpt;
        public IVertex[][][] ypt;
        public IVertex[][][] zpt;
        public IVertex[][][] corner;
        public IVertex[][][] xypt;
        public IVertex[][][] yzpt;
        public IVertex[][][] zxpt;
        public int xnum;
        public int ynum;
        public int znum;
        public int xindex;
        public int yindex;
        public int zindex;
        public IVec pos;
        public double xinc;
        public double yinc;
        public double zinc;

        public VertexGrid(int n, int n2, int n3) {
            this.xnum = n;
            this.ynum = n2;
            this.znum = n3;
            this.xpt = new IVertex[this.xnum][this.ynum + 1][this.znum + 1];
            this.ypt = new IVertex[this.xnum + 1][this.ynum][this.znum + 1];
            this.zpt = new IVertex[this.xnum + 1][this.ynum + 1][this.znum];
            this.corner = new IVertex[this.xnum + 1][this.ynum + 1][this.znum + 1];
            this.xypt = new IVertex[this.xnum][this.ynum][this.znum + 1];
            this.yzpt = new IVertex[this.xnum + 1][this.ynum][this.znum];
            this.zxpt = new IVertex[this.xnum][this.ynum + 1][this.znum];
        }

        public void setGridPosition(IVec iVec, double d, double d2, double d3) {
            this.pos = iVec;
            this.xinc = d;
            this.yinc = d2;
            this.zinc = d3;
        }

        public void index(int n, int n2, int n3) {
            this.xindex = n;
            this.yindex = n2;
            this.zindex = n3;
        }

        public void x(int n, int n2, int n3, IVecI iVecI) {
            this.xpt[n][n2][n3] = new IVertex(iVecI);
        }

        public void y(int n, int n2, int n3, IVecI iVecI) {
            this.ypt[n][n2][n3] = new IVertex(iVecI);
        }

        public void z(int n, int n2, int n3, IVecI iVecI) {
            this.zpt[n][n2][n3] = new IVertex(iVecI);
        }

        public void x(IVecI iVecI) {
            this.xpt[this.xindex - 1][this.yindex][this.zindex] = new IVertex(iVecI);
        }

        public void y(IVecI iVecI) {
            this.ypt[this.xindex][this.yindex - 1][this.zindex] = new IVertex(iVecI);
        }

        public void z(IVecI iVecI) {
            this.zpt[this.xindex][this.yindex][this.zindex - 1] = new IVertex(iVecI);
        }

        public void xy(IVecI iVecI) {
            this.xypt[this.xindex - 1][this.yindex - 1][this.zindex] = new IVertex(iVecI);
        }

        public void yz(IVecI iVecI) {
            this.yzpt[this.xindex][this.yindex - 1][this.zindex - 1] = new IVertex(iVecI);
        }

        public void zx(IVecI iVecI) {
            this.zxpt[this.xindex - 1][this.yindex][this.zindex - 1] = new IVertex(iVecI);
        }

        public void corner(IVecI iVecI) {
            this.corner[this.xindex][this.yindex][this.zindex] = new IVertex(iVecI);
        }

        public IVertex x(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n >= this.xnum || n2 > this.ynum || n3 > this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.xpt[n][n2][n3];
        }

        public IVertex y(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n > this.xnum || n2 >= this.ynum || n3 > this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.ypt[n][n2][n3];
        }

        public IVertex z(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n > this.xnum || n2 > this.ynum || n3 >= this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.zpt[n][n2][n3];
        }

        public IVertex corner(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n > this.xnum || n2 > this.ynum || n3 > this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.corner[n][n2][n3];
        }

        public IVertex xy(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n >= this.xnum || n2 >= this.ynum || n3 > this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.xypt[n][n2][n3];
        }

        public IVertex yz(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n > this.xnum || n2 >= this.ynum || n3 >= this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.yzpt[n][n2][n3];
        }

        public IVertex zx(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0 || n >= this.xnum || n2 > this.ynum || n3 >= this.znum) {
                IOut.err(n + "," + n2 + "," + n3);
                return null;
            }
            return this.zxpt[n][n2][n3];
        }

        public IFace[] faces(int[] nArray, int[][][] nArray2, double[] dArray) {
            IFace[] iFaceArray = new IFace[nArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                int n;
                IVertex[] iVertexArray = new IVertex[nArray2[i].length];
                int n2 = -1;
                for (n = 0; n < nArray2[i].length; ++n) {
                    if (nArray2[i][n].length == 1) {
                        iVertexArray[n] = this.cornerByIndex(nArray[nArray2[i][n][0]]);
                    } else {
                        iVertexArray[n] = this.pointByIndex(nArray[nArray2[i][n][0]], nArray[nArray2[i][n][1]]);
                        if (n2 < 0) {
                            n2 = nArray2[i][n][0];
                        }
                    }
                    if (iVertexArray[n] != null) continue;
                    IOut.err("null at " + n);
                }
                if (n2 < 0) {
                    for (n = 0; n < nArray.length && n2 < 0; ++n) {
                        int n3;
                        for (n3 = 0; n3 < nArray2[i].length && nArray2[i][n3][0] != n; ++n3) {
                        }
                        if (n3 != nArray2[i].length) continue;
                        n2 = n;
                    }
                    if (n2 < 0) {
                        IOut.err("normalCheckIndex couldn't be foound");
                    }
                }
                if (iVertexArray.length < 3) {
                    IOut.err("too less number of edgeIdx[" + i + "].length (" + nArray2[i].length + "). it shoudl be >= 3");
                } else if (n2 >= 0) {
                    IVec iVec = iVertexArray[1].get().dif(iVertexArray[0].pos()).cross(iVertexArray[2].pos().dif(iVertexArray[0].pos()));
                    IVec iVec2 = null;
                    IVertex iVertex = this.cornerByIndex(nArray[n2]);
                    if (iVertex != null) {
                        iVec2 = iVertex.get();
                    }
                    if (iVec2 == null) {
                        iVec2 = this.posByIndex(nArray[n2]);
                    }
                    if (iVec2 != null) {
                        if (iVec2.dif(iVertexArray[0].pos()).dot(iVec) < 0.0) {
                            if (dArray[n2] < 0.0) {
                                iVertexArray = this.flipVertexArray(iVertexArray);
                            }
                        } else if (dArray[n2] > 0.0) {
                            iVertexArray = this.flipVertexArray(iVertexArray);
                        }
                    } else {
                        IOut.err("corner couldn't be calculated");
                    }
                }
                iFaceArray[i] = new IFace(iVertexArray);
            }
            return iFaceArray;
        }

        public IVertex[] flipVertexArray(IVertex[] iVertexArray) {
            IVertex[] iVertexArray2 = new IVertex[iVertexArray.length];
            for (int i = 0; i < iVertexArray.length; ++i) {
                iVertexArray2[i] = iVertexArray[iVertexArray.length - 1 - i];
            }
            return iVertexArray2;
        }

        public IVec posByIndex(int n, int n2, int n3) {
            if (this.pos == null) {
                return null;
            }
            return this.pos.cp().add((double)n * this.xinc, (double)n2 * this.yinc, (double)n3 * this.zinc);
        }

        public IVec posByIndex(int n) {
            switch (n) {
                case 0: {
                    return this.posByIndex(this.xindex - 1, this.yindex - 1, this.zindex - 1);
                }
                case 1: {
                    return this.posByIndex(this.xindex, this.yindex - 1, this.zindex - 1);
                }
                case 2: {
                    return this.posByIndex(this.xindex, this.yindex, this.zindex - 1);
                }
                case 3: {
                    return this.posByIndex(this.xindex - 1, this.yindex, this.zindex - 1);
                }
                case 4: {
                    return this.posByIndex(this.xindex - 1, this.yindex - 1, this.zindex);
                }
                case 5: {
                    return this.posByIndex(this.xindex, this.yindex - 1, this.zindex);
                }
                case 6: {
                    return this.posByIndex(this.xindex, this.yindex, this.zindex);
                }
                case 7: {
                    return this.posByIndex(this.xindex - 1, this.yindex, this.zindex);
                }
            }
            IOut.err("invalid index " + n);
            return null;
        }

        public IVertex pointByIndex(int n, int n2) {
            if (n == 0 && n2 == 1 || n == 1 && n2 == 0) {
                return this.x(this.xindex - 1, this.yindex - 1, this.zindex - 1);
            }
            if (n == 3 && n2 == 2 || n == 2 && n2 == 3) {
                return this.x(this.xindex - 1, this.yindex, this.zindex - 1);
            }
            if (n == 4 && n2 == 5 || n == 5 && n2 == 4) {
                return this.x(this.xindex - 1, this.yindex - 1, this.zindex);
            }
            if (n == 7 && n2 == 6 || n == 6 && n2 == 7) {
                return this.x(this.xindex - 1, this.yindex, this.zindex);
            }
            if (n == 0 && n2 == 3 || n == 3 && n2 == 0) {
                return this.y(this.xindex - 1, this.yindex - 1, this.zindex - 1);
            }
            if (n == 2 && n2 == 1 || n == 1 && n2 == 2) {
                return this.y(this.xindex, this.yindex - 1, this.zindex - 1);
            }
            if (n == 4 && n2 == 7 || n == 7 && n2 == 4) {
                return this.y(this.xindex - 1, this.yindex - 1, this.zindex);
            }
            if (n == 5 && n2 == 6 || n == 6 && n2 == 5) {
                return this.y(this.xindex, this.yindex - 1, this.zindex);
            }
            if (n == 0 && n2 == 4 || n == 4 && n2 == 0) {
                return this.z(this.xindex - 1, this.yindex - 1, this.zindex - 1);
            }
            if (n == 1 && n2 == 5 || n == 5 && n2 == 1) {
                return this.z(this.xindex, this.yindex - 1, this.zindex - 1);
            }
            if (n == 2 && n2 == 6 || n == 6 && n2 == 2) {
                return this.z(this.xindex, this.yindex, this.zindex - 1);
            }
            if (n == 3 && n2 == 7 || n == 7 && n2 == 3) {
                return this.z(this.xindex - 1, this.yindex, this.zindex - 1);
            }
            if (n == 0 && n2 == 2 || n == 2 && n2 == 0 || n == 1 && n2 == 3 || n == 3 && n2 == 1) {
                return this.xy(this.xindex - 1, this.yindex - 1, this.zindex - 1);
            }
            if (n == 4 && n2 == 6 || n == 6 && n2 == 4 || n == 5 && n2 == 7 || n == 7 && n2 == 5) {
                return this.xy(this.xindex - 1, this.yindex - 1, this.zindex);
            }
            if (n == 0 && n2 == 7 || n == 7 && n2 == 0 || n == 3 && n2 == 4 || n == 4 && n2 == 3) {
                return this.yz(this.xindex - 1, this.yindex - 1, this.zindex - 1);
            }
            if (n == 1 && n2 == 6 || n == 6 && n2 == 1 || n == 2 && n2 == 5 || n == 5 && n2 == 2) {
                return this.yz(this.xindex, this.yindex - 1, this.zindex - 1);
            }
            if (n == 0 && n2 == 5 || n == 5 && n2 == 0 || n == 1 && n2 == 4 || n == 4 && n2 == 1) {
                return this.zx(this.xindex - 1, this.yindex - 1, this.zindex - 1);
            }
            if (n == 2 && n2 == 7 || n == 7 && n2 == 2 || n == 3 && n2 == 6 || n == 6 && n2 == 3) {
                return this.zx(this.xindex - 1, this.yindex, this.zindex - 1);
            }
            IOut.err("invalid combination " + n + ", " + n2);
            return null;
        }

        public IVertex cornerByIndex(int n) {
            switch (n) {
                case 0: {
                    return this.corner[this.xindex - 1][this.yindex - 1][this.zindex - 1];
                }
                case 1: {
                    return this.corner[this.xindex][this.yindex - 1][this.zindex - 1];
                }
                case 2: {
                    return this.corner[this.xindex][this.yindex][this.zindex - 1];
                }
                case 3: {
                    return this.corner[this.xindex - 1][this.yindex][this.zindex - 1];
                }
                case 4: {
                    return this.corner[this.xindex - 1][this.yindex - 1][this.zindex];
                }
                case 5: {
                    return this.corner[this.xindex][this.yindex - 1][this.zindex];
                }
                case 6: {
                    return this.corner[this.xindex][this.yindex][this.zindex];
                }
                case 7: {
                    return this.corner[this.xindex - 1][this.yindex][this.zindex];
                }
            }
            IOut.err("invalid index " + n);
            return null;
        }

        public IFace triangle(int n) {
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            switch (n) {
                case 0: {
                    n2 = 0;
                    n3 = 8;
                    n4 = 4;
                    break;
                }
                case 1: {
                    n2 = 7;
                    n3 = 9;
                    n4 = 0;
                    break;
                }
                case 2: {
                    n2 = 1;
                    n3 = 10;
                    n4 = 7;
                    break;
                }
                case 3: {
                    n2 = 4;
                    n3 = 11;
                    n4 = 1;
                    break;
                }
                case 4: {
                    n2 = 5;
                    n3 = 8;
                    n4 = 3;
                    break;
                }
                case 5: {
                    n2 = 3;
                    n3 = 9;
                    n4 = 6;
                    break;
                }
                case 6: {
                    n2 = 6;
                    n3 = 10;
                    n4 = 2;
                    break;
                }
                case 7: {
                    n2 = 2;
                    n3 = 11;
                    n4 = 5;
                }
            }
            if (n2 < 0 || n3 < 0 || n4 < 0) {
                return null;
            }
            IVertex iVertex = this.v(n2);
            IVertex iVertex2 = this.v(n3);
            IVertex iVertex3 = this.v(n4);
            if (iVertex == null || iVertex2 == null || iVertex3 == null) {
                return null;
            }
            return new IFace(iVertex, iVertex2, iVertex3);
        }

        public IFace quad(int n) {
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            switch (n) {
                case 0: {
                    n2 = 0;
                    n3 = 1;
                    n4 = 2;
                    n5 = 3;
                    break;
                }
                case 1: {
                    n2 = 4;
                    n3 = 5;
                    n4 = 6;
                    n5 = 7;
                    break;
                }
                case 2: {
                    n2 = 8;
                    n3 = 9;
                    n4 = 10;
                    n5 = 11;
                }
            }
            if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
                return null;
            }
            IVertex iVertex = this.v(n2);
            IVertex iVertex2 = this.v(n3);
            IVertex iVertex3 = this.v(n4);
            IVertex iVertex4 = this.v(n5);
            if (iVertex == null || iVertex2 == null || iVertex3 == null || iVertex4 == null) {
                return null;
            }
            return new IFace(iVertex, iVertex2, iVertex3, iVertex4);
        }

        public IVertex corner(int n) {
            switch (n) {
                case 0: {
                    return this.corner(this.xindex - 1, this.yindex - 1, this.zindex - 1);
                }
                case 1: {
                    return this.corner(this.xindex, this.yindex - 1, this.zindex - 1);
                }
                case 2: {
                    return this.corner(this.xindex, this.yindex, this.zindex - 1);
                }
                case 3: {
                    return this.corner(this.xindex - 1, this.yindex, this.zindex - 1);
                }
                case 4: {
                    return this.corner(this.xindex - 1, this.yindex - 1, this.zindex);
                }
                case 5: {
                    return this.corner(this.xindex, this.yindex - 1, this.zindex);
                }
                case 6: {
                    return this.corner(this.xindex, this.yindex, this.zindex);
                }
                case 7: {
                    return this.corner(this.xindex - 1, this.yindex, this.zindex);
                }
            }
            return null;
        }

        public IVertex v(int n) {
            switch (n) {
                case 0: {
                    return this.x(this.xindex - 1, this.yindex - 1, this.zindex - 1);
                }
                case 1: {
                    return this.x(this.xindex - 1, this.yindex, this.zindex - 1);
                }
                case 2: {
                    return this.x(this.xindex - 1, this.yindex, this.zindex);
                }
                case 3: {
                    return this.x(this.xindex - 1, this.yindex - 1, this.zindex);
                }
                case 4: {
                    return this.y(this.xindex - 1, this.yindex - 1, this.zindex - 1);
                }
                case 5: {
                    return this.y(this.xindex - 1, this.yindex - 1, this.zindex);
                }
                case 6: {
                    return this.y(this.xindex, this.yindex - 1, this.zindex);
                }
                case 7: {
                    return this.y(this.xindex, this.yindex - 1, this.zindex - 1);
                }
                case 8: {
                    return this.z(this.xindex - 1, this.yindex - 1, this.zindex - 1);
                }
                case 9: {
                    return this.z(this.xindex, this.yindex - 1, this.zindex - 1);
                }
                case 10: {
                    return this.z(this.xindex, this.yindex, this.zindex - 1);
                }
                case 11: {
                    return this.z(this.xindex - 1, this.yindex - 1, this.zindex - 1);
                }
            }
            return null;
        }
    }
}

